var __index = {"config":{"lang":["de"],"separator":"[\\s\\-]+","pipeline":["stopWordFilter"],"fields":{"title":{"boost":1000.0},"text":{"boost":1.0},"tags":{"boost":1000000.0}}},"docs":[{"location":"index.html","title":"\u00dcber diese Dokumentation","text":"<p>Die vorliegende Dokumentation gilt f\u00fcr die Softwareanwendung:</p> <p></p> <p>SASKIA.H2R 5.4.0</p> <p>Stand vom: 12.12.2025</p> <p>Eine entsprechende aktuelle Online-Webhilfe ist unter folgendem Link erreichbar:</p> <p>https://h2r.saskia.de Webhilfe </p> Die Dokumentation besteht aus folgenden Bestandteilen: Aktuelles \u00c4nderungsinformationen (Releasenotes) Produktbeschreibung vertriebliche Dokumentation Systembeschreibung technische Dokumentation Anwenderhandbuch fachliche Benutzerdokumentation <p>Kontakt bei R\u00fcckfragen zur Dokumentation:</p> SASKIA\u00ae Informations-Systeme GmbH Fachbereich Finanzverfahren Telefon: +49 371 8088-444 Telefax: \u00a0 +49 371 8088-200 Mail: hotline@saskia.de Internet: www.saskia.de Datenschutz: www.saskia.de/datenschutz Impressum: www.saskia.de/impressum <p></p>"},{"location":"Installation/aktualisierung.html","title":"Aktualisierung SASKIA.H2R","text":"<p>\u00dcber das Programm <code>s342 - Systemaktualisierung</code> kann die H2R Software <code>SASKIA.H2R</code> und <code>SASKIA.H2R-Jobserver</code> aktualisiert werden.</p>"},{"location":"Installation/aktualisierung.html#voraussetzung-fur-die-nutzung-des-progamms","title":"Voraussetzung f\u00fcr die Nutzung des Progamms","text":"<ul> <li>Nutzung von IIS als Server zur Bereitstellung von <code>SASKIA.H2R</code> bzw. <code>SASKIA.H2R-Jobserver</code></li> <li>Nutzer des Anwendungspool (<code>ApplicationPoolIdentity</code>) muss IIS-Berechtigung zur Verwaltung der Webanwendung besitzen</li> <li>Aufruf der Anwendung \u00fcber den Web-Browser mittels Windows-Authentifizierung</li> <li>dotnet 8 oder hoeher</li> </ul>"},{"location":"Installation/aktualisierung.html#konfiguration-defaultjson-onlineupdate","title":"Konfiguration Default.json OnlineUpdate","text":"<p>Bitte nehmen sie folgende Parameter f\u00fcr die Grundkonfiguration des OnlineUpdates in die Default.json auf</p> <pre><code>    \"settings\": {\n        \"OnlineUpdate.Feed\": \"https://service.saskia.de/autoupdate\",\n        \"OnlineUpdate.JobServerPath\": \"\",\n        \"OnlineUpdate.WorkingDirectory\": \"\"\n    }\n</code></pre> <ul> <li><code>OnlineUpdate.WorkingDirectory</code>: Basispfad des OnlineUpdates zum Speichern von heruntergeladenen Aktualisierungen und Backups</li> <li><code>OnlineUpdate.Feed</code>: URL des Servers, der die OnlineUpdates bereith\u00e4lt (Default ist <code>https://service.saskia.de/autoupdate</code>)</li> <li><code>OnlineUpdate.JobServerPath\"</code>: Pfad zum SASKIA.H2R Jobserver Ordner (Physical Path). Diese Ordner ist die Basis f\u00fcr die SASKIA.H2R Jobserver Aktualisierung</li> </ul> <p></p> <p>Es werden beim Start des Programms Informationen zur aktuellen Installation angegeben:</p> <ul> <li>Name des ApplicationPools</li> <li>Name der ApplicationPoolIdentity</li> <li>Installationspfad der Anwendung (physischer Pfad)</li> <li>Quellpfad f\u00fcr die Aktualisierung (mit diesen Dateien wird die aktuelle H2R-Installation aktualisiert)</li> </ul>"},{"location":"Installation/aktualisierung.html#erklarungen-zu-den-installationsoptionen","title":"Erkl\u00e4rungen zu den Installationsoptionen","text":"<ul> <li>OnlineUpdate interaktiv starten: <code>sasupcli.exe</code> wird auf dem Server gestartet und erlaubt weitere Einstellungen.</li> </ul> <p>Hinweis</p> <p>Der Aufruf im interkativen Modus ist nur m\u00f6glich, wenn man die Systemaktualisierung direkt im Browser auf dem Server startet</p> <ul> <li>OnlineUpdate Ordner vorab bereinigen: Der Ordner <code>H2R_UPDATE</code> wird komplet gel\u00f6scht und das OnlineUpdate l\u00e4dt die letzte aktuelle Version erneut herunter </li> <li>OnlineUpdate vorbereitet: der oben angegebene Ordner enth\u00e4lt bereits die aktuellen Dateien und wird vorab nicht aktualisiert bzw. ausgetauscht. Erm\u00f6glicht das Einspielen von noch nicht ver\u00f6ffentlichten Release-St\u00e4nden und anderen Test-Szenarien</li> </ul>"},{"location":"Installation/aktualisierung.html#grundlegende-erlauterungen-zum-aktualisierungsvorgang","title":"Grundlegende Erl\u00e4uterungen zum Aktualisierungsvorgang","text":"<p><code>H2R</code> bzw. <code>H2R Server</code> k\u00f6nnen in unterschiedlichen Server-Szenarien bereitgestellt werden Die Systemaktualisierung erfolgt in 3 Schritten:</p> <ol> <li>Herunterladen der aktuellsten Version von <code>H2R</code> bzw. <code>H2R Server</code></li> <li>Erstellung einer Schattenkopie der H2R Anwendung durch Anpassung des pyhsischen Pfades der Webanwendung (notwendig f\u00fcr den Austausch der in Nutzung befindlichen Quellcode-Dateien)</li> <li>Neustart der H2R Anwendung durch Nutzung des Schattenkopie-Ordners</li> <li>Austausch der Dateien im alten physischen Pfad der Anwendung mit den aktualisierten Dateien im <code>H2R_UPDATE</code> Ordner</li> <li>R\u00fccksetzen des physischen Pfades der H2R Anwendung auf den urspr\u00fcnglichen Dateipfad</li> <li>Neustart der Server-Anwendung und Abschluss der Aktualisierung</li> </ol>"},{"location":"Installation/aktualisierung.html#durchfuhrung-der-aktualisierung","title":"Durchf\u00fchrung der Aktualisierung","text":"<ol> <li>Programm <code>s342 - Systemaktualisierung</code> aufrufen</li> <li>Anwender und Passwort eingeben, der berechtigt ist, denn IIS zu administrieren</li> <li>Schaltfl\u00e4che <code>Weiter</code> bet\u00e4tigen</li> <li>Frage nach Backup mit <code>Ja</code> oder <code>Nein</code> beantworten</li> <li>Frage nach  dem Server-Neustart mit <code>Ja</code> beantworten</li> <li>Vollst\u00e4ndigen Neustart der Anwendung im Browser abwarten</li> <li>Programm <code>s342 - Systemaktualisierung</code> erneut starten (Programm sollte Information zum Abschluss der Installation enthalten)</li> <li>Aktualisierung des Anwendungscodes starten</li> <li>Abfrage nach Serverneustart mit <code>Ja</code> beantworten</li> <li>Vollst\u00e4ndigen Neustart der Anwendung im Browser abwarten</li> <li>Manuelle Installationsschritte (Releasewechsel) durchf\u00fchren</li> </ol>"},{"location":"Installation/aktualisierung.html#individuelle-anpassung-der-aktualisierungsschritte","title":"Individuelle Anpassung der Aktualisierungsschritte","text":"<p>Die Durchf\u00fchrung der Aktualisierungen auf dem Sever werden u.a. durch die Nutzung von Powershell-Skripten realisiert. Innerhalb der Installation k\u00f6nnen individuelle Skripte vor und nach der Installation genutzt werden. Dazu m\u00fcssen im Root-Ordner der Anwendung (physikalischer Pfad) hinterlegt werden. Diese Dateien werden beim Aktualisierungsprozess nicht gel\u00f6scht oder aktualisiert.</p> <p>Folgende Powershell-Skripte k\u00f6nnen angegeben werden</p> <ul> <li>before_update.ps1</li> <li>after_update.ps1</li> </ul> <p>Wird im Ordner ebenfalls eine update.ps1 Datei gefunden, wird diese f\u00fcr den Aktualisierungsvorgang verwendet. Standardm\u00e4\u00dfig findet der Skript aus der Online-Aktualisierung (<code>H2R_UPDATE\\bin\\updater\\update_default.ps1</code>) Verwendung. Der Skript enth\u00e4lt beim Aufruf die folgenden Parameter</p> <ul> <li>$source: Quellpfad der Aktualisierung (Absoluter Pfad zum <code>`H2R_UPDATE</code> Ordner)</li> <li>$destination: Zielpfad, in den installiert wird (absoluter Pfad, entspricht dem urspr\u00fcnglichen physikalischen Pfad)</li> </ul> <pre><code>param([String]$source,\n    [String]$destination\n)\n</code></pre> <p>Hinweis</p> <p>Im Ordner <code>/images</code> k\u00f6nnen weiterhin individuelle Logodateien abgelegt werden. Diese werden beim Durchf\u00fchren der Online-Aktualisierung nicht gel\u00f6scht oder \u00fcberschrieben.</p>"},{"location":"Installation/freigaben.html","title":"SASKIA.H2R Freigaben","text":"<p>SASKIA.H2R und SASKIA.H2R-Jobserver kommunizieren unter anderem mit externen Diensten. Folgende Server-Adressen m\u00fcssen freigegeben werden, damit die Anwendung korrekt funktionieren kann:</p> URL Beschreibung https://h2r.saskia.de Zugriff auf die SASKIA.H2R Dokumentation https://service.saskia.de Download von Updates f\u00fcr SASKIA.H2R https://www.elster.de Kommunikation Elster Eric Schnittstelle https://evatr.bff-online.de Abgleich Umsatzsteuer-Identifikationsnummer - Bundeszentralamt f\u00fcr Steuern - weitere Details https://api.epost.docuguide.com SASKIA.H2R eVersand - E-POST-Anbindung (E-POSTBUSINESS API) - Deutsche Post AG lokale URL Zugriff zum Meldewesen Adress Dienst http://license.wisej.com/ Lizenzaktivierung Wisej/H2R <p>Zentrale Einstellungen der Proxykonfiguration f\u00fcr die H2R-Instanzen sind in der web.config in den folgenden Umgebungsvariablen zu hinterlegen.</p> <pre><code>        &lt;aspNetCore stdoutLogEnabled=\"false\" hostingModel=\"inprocess\" processPath=\".\\bin\\SIS.H2r.exe\" arguments=\"\"&gt;\n            &lt;environmentVariables&gt;\n                &lt;environmentVariable name=\"all_proxy\" value=\"http://my.proxy.de:80\"/&gt;\n                &lt;environmentVariable name=\"http_proxy\" value=\"http://my.proxy.de:80\"/&gt;\n                &lt;environmentVariable name=\"https_proxy\" value=\"https://my.proxy.de:80\"/&gt;\n                &lt;environmentVariable name=\"no_proxy\" value=\".local,.my.other.domain\"/&gt;\n            &lt;/environmentVariables&gt;\n        &lt;/aspNetCore&gt;\n</code></pre> <p>Beachten sie die Syntax f\u00fcr die Verwendung von Auflistungen bei <code>no_proxy</code>. Details entnehmen sie bitte hier</p>"},{"location":"Installation/h2r-installation.html","title":"SASKIA.H2R (NetFramework)","text":""},{"location":"Installation/h2r-installation.html#voraussetzungen","title":"Voraussetzungen","text":"<p>Ausf\u00fchrliche Informationen zu Systemvoraussetzungen finden sie hier. </p>"},{"location":"Installation/h2r-installation.html#installation-iis-webserver","title":"Installation IIS Webserver","text":"<p>Klicken sie in der <code>Systemsteuerung</code> auf <code>Windows-Features aktivieren oder deaktivieren</code>.</p> <p></p> <p>W\u00e4hlen sie im Anschluss im erscheinenden Dialog <code>Assistent zum Hinzuf\u00fcgen von Rollen und Features</code> die \"<code>Rollenbasierte oder featurebasierte Installation</code> als Installationstyp aus und Klicken sie auf <code>Weiter</code>.</p> <p></p> <p>Aktivieren sie im Dialogschritt <code>Serverrollen</code> die folgenden Webserver (IIS) - Rollen:</p> <p></p> <p>Im Dialogschritt <code>Features</code> aktivieren sie bitte die folgenden Optionen:</p> <p></p> <p>Schlie\u00dfen sie den Dialog durch Bet\u00e4tigen von <code>Installieren</code> ab.</p> <p>Im Windows Server Manager ist anschlie\u00dfend der Eintrag <code>IIS</code> verf\u00fcgbar.</p> <p></p> <p>Nach der Installation der notwendigen Features k\u00f6nnen sie den IIS Manager per Rechtsklick auf dem entsprechend aufgelisteten Webserver aufrufen.</p> <p></p> <p>Damit ist die Installation von IIS f\u00fcr den Betrieb von H2R abgeschlossen</p>"},{"location":"Installation/h2r-installation.html#installation-powershell-remoting-dienst","title":"Installation Powershell Remoting Dienst","text":"<p>Zur Durchf\u00fchrung des OnlineUpdates wir der Dienst <code>Windows-Remoteverwaltung (WS-Verwaltung)</code> ben\u00f6tigt.</p> <p>Sie k\u00f6nnen diesen Dienst \u00fcber folgenden Befehl in der Powershell direkt installieren.</p> <pre><code>Enable-PSRemoting\n</code></pre> <p>Weiterf\u00fchrende Informationen erhalten sie hier.</p> <p></p>"},{"location":"Installation/h2r-installation.html#installation-h2r-anwendung","title":"Installation H2R Anwendung","text":"<p>\u00d6ffnen sie den IIS Manager und erstellen sie einen neuen Anwendungspool <code>H2R</code> mit den folgenden Einstellungen</p> <ul> <li>Name: <code>H2R</code></li> <li>.Net CLR-Version: verf\u00fcgbare .Net CLR-Version ausw\u00e4hlen</li> <li>verwalteter Pipelinemodus: <code>Integriert</code></li> <li>Anwendungspool sofort starten: <code>Aktiviert</code></li> </ul> <p></p> <p>Setzen sie anschlie\u00dfend in den erweiterten Einstellungen des Anwendungspools <code>H2R</code> den Eintrag <code>Benutzerprofil laden</code> auf <code>True</code>. Der korrekte Eintrag ist essenziell f\u00fcr die Realisierung des PDF Druckes mit Hilfe des IIS Servers. </p> <p>Die H2R Anwendung muss nun als Website angelegt und dem Anwendungspool <code>H2R</code> zugeordnet werden. Klicken sie daf\u00fcr mit der rechten Maustaste auf den Punkt <code>Sites</code> und w\u00e4hlen sie anschlie\u00dfend <code>Website hinzuf\u00fcgen</code> </p> <p>Folgende Angaben sind zu hinterlegen: </p> <ul> <li>Sitename: H2R</li> <li>Physischer Pfad: D:\\H2R (Bei Bedarf anpassen)</li> <li>Bindung Typ: HTTP</li> <li>Bindung Port: 80</li> </ul> <p>Kopieren sie nun den Inhalt des durch das Saskia OnlineUpdates bereitgestellten Ordners <code>H2R</code> in den Ordner der zuvor erstellten Website.</p> <p>In unserem Beispiel sollte der Ordner <code>D:\\H2R</code> wie folgt aussehen: </p> <p>Hinweis</p> <p>Die Datei <code>wisej-server.lic</code> wird beim ersten Start der Anwendung erstellt und pr\u00fcft den hinterlegten Wisej.LicenseKey in der <code>Web.config</code> auf G\u00fcltigkeit. F\u00fcr diese Anfrage muss der IIS Prozess per Webrequest mit der Adresse http://license.wisej.com/ kommunizieren k\u00f6nnen. Notwendige Proxyeinstellung f\u00fcr diese Verbindung k\u00f6nnen sie in der Web.config unter system.net.DefaultProxy hinterlegen.</p> <p>F\u00fcr den erstellten Ordner m\u00fcssen je nach Sicherheitsrichtline volle Lese- und Schreibrechte f\u00fcr den Anwender <code>IIS_IUSRS</code> eingerichtet werden.</p> <p></p> <p>Im Anschluss sollte die H2R-Anwendung im Browser \u00fcber die Serveradresse aufrufbar sein:</p> <p></p>"},{"location":"Installation/h2r-installation.html#datei-und-ordnerstruktur","title":"Datei- und Ordnerstruktur","text":"<p>Im folgenden Abschnitt werden die Datei- und Ordnerstruktur von H2R auf dem Webserver erl\u00e4utert.</p> Ordner/Datei Beschreibung bin Der bin-Ordner enth\u00e4lt den ausf\u00fchrbaren Programmcode von H2R sowie \u00dcbersetzungen/Lokalisierungen Default.html enth\u00e4lt den Einstiegspunkt der Anwendung, wird beim Aufruf der URL geladen Defaullt.json enth\u00e4lt Grundeinstellungen der H2R Webanwendung, z.B. Sessiontimeout oder verwendetes Theme Web.config enth\u00e4lt IIS Konfigurationsangaben f\u00fcr die H2R Anwendung central.config enth\u00e4lt die zentrale Konfiguration der mit H2R verbundenen Dienste (WCF) sql.config enth\u00e4lt die f\u00fcr H2R zur Verf\u00fcgung stehenden Datenbankverbindungsinformationen"},{"location":"Installation/h2r-installation.html#konfigurationsdateien","title":"Konfigurationsdateien","text":"<p>Im folgenden Abschnitt werden die verschiedenen H2R-Konfigurationsdateien aufgelistet und beschrieben.</p> Web.configDefault.jsonsql.config <p>Mit Hilfe der Web.config Datei k\u00f6nnen IIS Anwendungen konfiguriert werden. Eine ausf\u00fchrliche Beschreibung der m\u00f6glichen Einstellungen entnehmen sie bitte der offiziellen Windows Dokumentation.</p> <pre><code>&lt;?xml version=\"1.0\"?&gt;\n&lt;configuration&gt;\n    &lt;appSettings&gt;\n        &lt;add key=\"Wisej.LicenseKey\" value=\"ba2afe0be26448cb248b884ddf204fe3\" /&gt;\n        &lt;add key=\"Wisej.DefaultTheme\" value=\"saskia\" /&gt;\n        &lt;add key=\"dbname\" value=\"myDatabaseName\" /&gt;\n        &lt;add key=\"configFile\" value=\"central.config\" /&gt;\n        &lt;add key=\"replication\" value=\"false\" /&gt;\n    &lt;/appSettings&gt;\n    &lt;system.net&gt;\n        &lt;defaultProxy&gt;\n                &lt;proxy autoDetect=\"false\" bypassonlocal=\"true\" proxyaddress=\"http://proxy.example.de:80\" /&gt;\n        &lt;/defaultProxy&gt;\n    &lt;/system.net&gt;\n    &lt;system.web&gt;\n        &lt;globalization requestEncoding=\"utf-8\" responseEncoding=\"utf-8\" /&gt;\n        &lt;httpRuntime targetFramework=\"4.8\" maxRequestLength=\"1048576\" /&gt;\n        &lt;httpModules&gt;\n            &lt;add name=\"Wisej\" type=\"Wisej.Core.HttpModule, Wisej.Framework\" /&gt;\n        &lt;/httpModules&gt;\n    &lt;/system.web&gt;\n    &lt;system.webServer&gt;\n        &lt;validation validateIntegratedModeConfiguration=\"false\" /&gt;\n        &lt;handlers&gt;\n            &lt;add name=\"wisej\" verb=\"*\" path=\"*.wx\" type=\"Wisej.Core.HttpHandler, Wisej.Framework\" /&gt;\n        &lt;/handlers&gt;\n        &lt;security&gt;\n            &lt;requestFiltering&gt;\n            &lt;requestLimits maxAllowedContentLength=\"1073741824\" /&gt;\n            &lt;/requestFiltering&gt;\n        &lt;/security&gt;\n        &lt;defaultDocument enabled=\"true\"&gt;\n        &lt;files&gt;\n            &lt;add value=\"Default.html\" /&gt;\n        &lt;/files&gt;\n        &lt;/defaultDocument&gt;\n    &lt;/system.webServer&gt;\n&lt;/configuration&gt;\n</code></pre> Konfigurationskey Beschreibung appSettings.Wisej.LicenseKey enth\u00e4lt die Lizenz zum Starten der Anwendung auf einem Webserver. Die Lizenz wird von Saskia bereitgestellt appSettings.Wisej.DefaultTheme enth\u00e4lt den Namen des Standardthemes appSettings.dbname Beim Starten von H2R muss sich das System direkt mit einer vorhandenen Datenbank verbinden. Hier geben sie den Namen dieser Datenbank an appSettings.configFile Angabe des Dateipfades zur central.config appSettings.replication Parameter muss aus Kompatibilit\u00e4tsgr\u00fcnden immer auf false gesetzt werden system.net.defaultProxy Angabe des Proxies zur Lizenzabfrage Wisej, wenn Server hinter einem Proxy betrieben wird <p>In dieser Anwendungskonfigurationsdatei kann das Verhalten der Webanwendung H2R beeinflusst werden. Eine ausf\u00fchrliche Beschreibung der Einstellungen finden sie hier</p> <pre><code>//\n// Application Configuration:\n//\n// All settings are optional.\n//\n// startup:                    Full name of the startup method. i.e. \"MyApp.Program.Main, MyApp\".\n// mainWindow:                 Full name of a view (Page or Form) created automatically at startup. i.e. \"MyApp.MainView, MyApp\".\n// theme:                      Name of the theme, without the extension, to load at startup.\n// url:                        Destination URL. If null, the request must match a web page.\n// allowedRoutes:              Allows the application to handle different Url routes, separated by a semicolon. i.e. \"api;admin;query/users\".\n// culture:                    The default culture of the application. Default: \"auto\" (detects the culture from the browser.)\n// rightToLeft:                Enables or disables Right to Left mode: true, false or auto. Default: \"auto\".\n// sessionTimeout:             Timeout of the session in seconds. Default: 120. Minimum: 60. Disable: 0.\n// responseTimeout:            Timeout of the Wisej requests in seconds. Default: 300. Minimum: 300.\n//                             Increase this value if you expect your application to process long running requests.\n// pollingInterval:            Interval for the automatic polling of the server in milliseconds. Default: 0 (disabled). Minimum: 1000.\n//                             This option is ignored for WebSocket connections.\n// autoReload:                 When true, the application is automatically reloaded when the session expires or Application.Exit() is called. Default: false.\n// secure:                     Forces the client to use SSL. Default: false.\n// showLoader:                 Loads the wisej ajax loader. Default: true.\n// loaderTimeout:              Timeout before the appearance of the Ajax loader in milliseconds. Default: 5000. Minimum: 1000. Disable: 0.\n// browserCheck:               Custom expression to validate the browser, i.e. \"navigator.platform == 'Win32'\".\n// enablePWA:                  Enables PWA mode in browsers that support it. Default: false.\n// offlineUrl:                 URL to navigate to when the client loses connectivity with the application. Default: \"\".\n// notSupportedUrl:            URL of the not-supported page. Wisej will redirect here when the browser is not supported. Default: 'resource.wx/Wisej.Framework/NotSupported.html'\n// notAvailableUrl:            URL of the not-available page. Wisej will redirect here when the server cannot accept any more sessions. Default: 'resource.wx/Wisej.Framework/NotAvailable.html'\n// debug:                      Enables logging on the client browser console. Default: false.\n// enableWebSocket:            Enables the user of WebSocket if available. Default: true.\n// enableWebSocketCompression: Enables compression of incoming WebSocket data. Default: true.\n// maxSessions:                Maximum number of active sessions (users) before redirecting to notAvailableUrl. Default: -1 (unlimited).\n// maxModalStack:              Maximum number of nested modal dialogs. Default: 10.\n// dropDuplicateClicks:        Drops all \"execute\" (clicks) events while there is a pending request. Touch and mouse clicks are still queued and will be executed. Default: false.\n// disableClientObjectModel:   Disables the creation of the JavaScript object model on the client.\n// validateClient              Verifies the client fingerprint when retrieving a session. Default: true.\n// impersonate:                Set impersonate:true to impersonate the user on the server. Default: false.\n// threadPool:                 Configures the thread pool without having to modify the machin.config file.\n//                             All values are optional. i.e. {minWorkerThreads:100}. Default: null.\n// options:                    Map of platform options. i.e. {\"automation.mode\": true, \"mobile.mode\": true, ...}.\n// settings:                   Map of custom application settings. i.e. {jquery: \"http://cdn...\", rootPath: \"c:\\\\users\\\\...\", ...}.\n//                             Custom settings are available using Application.Configuration.Settings.\n{\n    \"url\": \"Default.html\",\n    \"theme\": \"saskia\",\n    \"options\": { \"mobile.mode\": true },\n    \"startup\": \"SIS.H2r.Program.Main, SIS.H2r\",\n    \"showLoader\": false,\n    \"autoReload\": true,\n    \"sessionTimeout\":  600,\n}\n</code></pre> <p>Warnung</p> <p>Im aktuellen Entwicklungsstand kann die H2R-Anwendung nur mit SQL Server Datenbanken verbunden werden. Die Oracle-Anbindung wird bis zur Ver\u00f6ffentlichung von H2R implementiert.</p> <p>F\u00fcr den Connection String sind alle g\u00fcltigen SQL Server- Varianten m\u00f6glich. Details entnehmen sie bitte der offiziellen Microsoft-Dokumentation oder der Knowledge Database unter https://www.connectionstrings.com/sql-server/</p> <pre><code>&lt;databases&gt;\n    &lt;database name=\"MyDatabase&gt;\n        &lt;provider name=\"Sql\" namespace=\"System.Data.SqlClient\" assembly=\"\" brand=\"31\" /&gt;\n        &lt;autocommit value=\"false\" /&gt;\n        &lt;named_parameters value=\"true\" prefix=\"@\" /&gt;\n        &lt;multiple_connections value=\"false\" /&gt;\n        &lt;null_empty_strings value=\"true\" /&gt;\n        &lt;connection_string value=\"Data Source=my.domain.de;Initial Catalog=MyDatabase;MultipleActiveResultSets=True;pooling=false;\" /&gt;\n        &lt;mars_supported value=\"true\" /&gt;\n        &lt;custom_properties&gt;\n            &lt;add name=\"dbu\" value=\"SgRP9RTtNZpQvnKEH13kLiz0jmB7yX7XnrMEF7qz3p8=\" /&gt;\n        &lt;/custom_properties&gt;\n    &lt;/database&gt;\n&lt;/databases&gt;\n</code></pre>"},{"location":"Installation/h2r-installation.html#https-kommunikation-aktivieren","title":"HTTPS Kommunikation aktivieren","text":"<p>Um f\u00fcr die H2R-Anwendung eine verschl\u00fcselte Kommunikation zwischen Webbrowser und IIS Server zu erreichen, gehen sie bitte wie folgt vor:</p> <p>Markieren sie im IIS-Manager ihre Website/Applikation und \u00f6ffnen sie per Rechtsklick den Kontextmen\u00fceintrag <code>Bindungen bearbeiten</code> </p> <p>Es werden nun die vorhandenen Bindungen angezeigt. \u00dcber die Schaltfl\u00e4che <code>Hinzuf\u00fcgen</code> k\u00f6nnen neue Bindungen hinzugef\u00fcgt werden. </p> <p>Folgende Angaben sind zu hinterlegen:</p> <ul> <li>Bindung Typ: HTTPS</li> <li>Bindung Port: 443</li> <li>SSL-Zertifikat: verf\u00fcgbares CA-Zertifikat oder Domainenzertifikat w\u00e4hlen</li> </ul> <p></p>"},{"location":"Installation/h2r-installation.html#domainenzertifikat-erstellen","title":"Domainenzertifikat erstellen","text":"<p>In diesem Abschnitt beschreiben wir die Aktivierung von HTTPS f\u00fcr die H2R Anwendung \u00fcber ein Domainenzertifikat.</p> <p>Hinweis</p> <p>Die Erstellung und Einrichtung CA-signierter Zertifikate ist nicht Bestandteil dieser Dokumentation.</p> <p>Der H2R Server ist im Regelfall nur im internen Netz erreichbar. Kann daher kein CA-signiertes Zertifikat erstellt werden, empfehlen wir die Verwendung eines sogenannten Dom\u00e4nenzertifikats. Vorteilhaft sind dabei die Kostenerstarnis bei der Ausstellung von Zertifikaten und die einfache Bereitstellung.</p> <p>Um ein Domainenzertifikat zu erstellen gehen sie bitte wie folgt vor:</p> <p>\u00d6ffnen sie im IIS Manager den Dialog <code>Serverzertifikate</code></p> <p></p> <p>Klicken Sie anschlie\u00dfend im Fenster <code>Aktionen</code> auf <code>Dom\u00e4nenzertifikat erstellen</code>.</p> <p></p> <p>Im Dialog tragen sie nun die Zertifikatsinformationen f\u00fcr ihren spezifischen Standort ein. Im Feld Gemeinsamer Name m\u00fcssen Sie den vollst\u00e4ndig qualifizierten Dom\u00e4nennamen des H2R Servers eingeben, beispielsweise <code>`server.meine-domain.de</code>.</p> <p></p> <p>Nach Eingabe der Daten geben sie im Folgedialog bitte ihre Online-Zertifizierungsstelle an.</p> <p></p> <p>Schlie\u00dfen sie die Domainzertifikatserstellung durch Bet\u00e4tigen der Schaltfl\u00e4che <code>Fertig stellen</code> ab.</p>"},{"location":"Installation/h2r-installation.html#strict-transport-security-hsts-unterstutzung-aktivieren","title":"Strict Transport Security (HSTS)-Unterst\u00fctzung aktivieren","text":"<p>Hinweis</p> <p>IIS unterst\u00fctzt mehrere M\u00f6glichkeiten, um eine sichere \u00dcbertragung mittels HTTPS zu erzwingen. Eine komplette Beschreibung finden sie hier.</p> <p>IIS 10.0 bietet ab Version 1709 Native HSTS-Unterst\u00fctzung. Aktivieren sie diese Einstellung im ISS Manager, in dem sie ihre Website ausw\u00e4hlen und im  Aktionsmenu <code>HSTS</code> ausw\u00e4hlen:</p> <p></p> <p>Folgende Angaben sind zu hinterlegen:</p> <ul> <li>Aktivieren: Ja</li> <li>Max Age: 31536000</li> <li>IncludeSubSomains: Ja (wenn Anwendung nicht \u00fcber Subdomain auf dem Server genutzt wird)</li> <li>HTTP an HTTPS umleiten</li> </ul> <p></p> <p>Der Webserver liefert dann die korrekten Antwort-Header zur\u00fcck, die sie \u00fcber die Browser Console einsehen k\u00f6nnen. Damit ist HSTS korrekt f\u00fcr ihre H2R-Anwendung eingerichtet.</p> <p></p> <p>Subdomain-Handling</p> <p>Pr\u00fcfen sie ihre individuellen URL-Rewrite Regeln im Zusammenspiel mit HSTS, um ein korrektes Redirect-Verhalten zu erreichen. Die Einstellungsm\u00f6glichkeiten sind hier detailliert dokumentiert.</p>"},{"location":"Installation/h2r-installation.html#wndows-authentifizierung-sso-single-sign-on-aktivieren","title":"Wndows Authentifizierung (SSO Single Sign On) aktivieren","text":"<p>Klicken sie in der <code>Systemsteuerung</code> auf <code>Windows-Features aktivieren oder deaktivieren</code>.</p> <p></p> <p>W\u00e4hlen sie im Anschluss im erscheinenden Dialog <code>Assistent zum Hinzuf\u00fcgen von Rollen und Features</code> die \"<code>Rollenbasierte oder featurebasierte Installation</code> als Installationstyp aus und Klicken sie auf <code>Weiter</code>.</p> <p></p> <p>Aktivieren sie im Dialogschritt <code>Serverrollen</code> die Webserver (IIS) - Rolle <code>Windows-Authentifizierung</code>.</p> <p></p> <p>Hinweis</p> <p>Starten sie anschlie\u00dfend den IIS Dienst in der Dienstverwaltung neu</p> <p>Im IIS Manager steht nun unter dem Punkt <code>Authentifizierung</code> die Option <code>Windows-Authentifizierung</code> zur Verf\u00fcgung, welche sie aktivieren.</p> <p></p> <p></p> <p>Deaktivieren sie zus\u00e4tzlich die anonyme Authentifizierung, wenn H2R nur f\u00fcr Domain-Anwender erreichbar sein soll.</p> <p>Als letzten Schritt erg\u00e4nzen sie folgenden Eintrag in der <code>Web.config</code> ihrer H2R-Installation</p> <pre><code>    &lt;configuration&gt;\n        &lt;system.web&gt;\n            &lt;authentication mode=\"Windows\" /&gt;\n        &lt;/system.web&gt;\n    &lt;/configuration&gt;\n</code></pre>"},{"location":"Installation/h2r-installation.html#installation-von-schriftarten","title":"Installation von Schriftarten","text":"<p>Die verf\u00fcgbaren Mrt-Reports werden auf dem Server im Kontext des konfigurierten ApplicationPool-Anwenders erzeugt. Daher m\u00fcssen alle ben\u00f6tigten Schriften f\u00fcr diesen Anwender verf\u00fcgbar gemacht werden. Wir empfehlen die Installation der Schriftart f\u00fcr alle Windows-Anwender. Kopieren sie daf\u00fcr die Schriftart-Datei auf den Server und w\u00e4hlen nach vorherigem Rechtsklick im Kontextmen\u00fc die Option <code>F\u00fcr alle Benutzer installieren</code>.</p> <p>Nach der Installation muss der Server zwingend neugestartet werden, damit die neue Schriftart verf\u00fcgbar wird.</p> <p>wichtiger Hinweis</p> <p>Es muss ein Standarddrucker in dem Nutzerprofil des verwendeten App-Pool-Nutzers hinterlegt werden. Beachten sie dabei ihre Domainen-konfiguration und Gruppenrichtlinien!!!!</p>"},{"location":"Installation/h2r-net-installation.html","title":"SASKIA.H2R (Net 8.0)","text":""},{"location":"Installation/h2r-net-installation.html#voraussetzungen","title":"Voraussetzungen","text":"<p>Ausf\u00fchrliche Informationen zu Systemvoraussetzungen finden sie hier. </p>"},{"location":"Installation/h2r-net-installation.html#installation-iis-webserver","title":"Installation IIS Webserver","text":"<p>Die Installationsschritte auf dem IIS Webserver entsprechen den Installationsschritten der H2R Installation f\u00fcr Net Framework (net48). Um Net8 oder h\u00f6heren Code im IIS ausf\u00fchren zu k\u00f6nnen, m\u00fcssen sie zus\u00e4tzlich das <code>Dotnet Core Hosting Bundle</code> installieren.</p> <p>Den Download und weiterf\u00fchrende Informationen finden sie hier</p>"},{"location":"Installation/h2r-net-installation.html#installation-h2r-anwendung","title":"Installation H2R Anwendung","text":"<p>Es werden die Unterschiede zur Installation von H2R f\u00fcr Net Framework 48 beschrieben.</p> <p>\u00d6ffnen sie den IIS Manager und erstellen sie einen neuen Anwendungspool <code>H2R</code> mit den folgenden Einstellungen</p> <ul> <li>Name: <code>H2R</code></li> <li>.Net CLR-Version: <code>kein verwalteter Code</code></li> <li>verwalteter Pipelinemodus: <code>Integriert</code></li> <li>Anwendungspool sofort starten: <code>Aktiviert</code></li> </ul> <p>Wichtig dabei ist, dass die .Net CLR (Common Language Runtime) auf <code>kein verwalteter Code</code> umgestellt wird.</p> <p>Weiterhin ist die <code>Web.config</code> durch die Umstellung auf .Net vereinfacht. So sind unter anderem die notwendigen Runtime-Anpassungen entfallen und k\u00f6nnen aus einer bestehenden Datei entfernt werden (XML Pfad <code>&lt;configuration&gt;/&lt;runtime&gt;</code>)</p> <p>Die bisherigen appSettings (XML Pfad <code>&lt;configuration&gt;/&lt;appSettings&gt;</code>) k\u00f6nnen ebenfalls entfallen. Die Einstellungen werden nun komplett in der Defaul.json verwaltet. Das OnlineUpdate liefert entsprechend Standard-Dateien mit aus, die alle m\u00f6glichen Settings enth\u00e4lt.</p> <p>Die Anwendung selbst wird zus\u00e4tzlich durch die Angabe <code>&lt;aspNetCore stdoutLogEnabled=\"false\" hostingModel=\"InProcess\" processPath=\".\\bin\\SIS.H2r.exe\" arguments=\"\" /&gt;</code> unter dem XML Pfad <code>&lt;configuration&gt;\\&lt;system.webServer&gt;</code> eingebunden.</p> <p>Weiterf\u00fchrende Informationen erhalten sie unter (https://learn.microsoft.com/en-us/aspnet/core/host-and-deploy/iis/web-config?view=aspnetcore-8.0)[https://learn.microsoft.com/en-us/aspnet/core/host-and-deploy/iis/web-config?view=aspnetcore-8.0]</p>"},{"location":"Installation/h2r-net-installation.html#anpassungen-webconfig","title":"Anpassungen Web.config","text":"<pre><code>&lt;?xml version=\"1.0\" encoding=\"UTF-8\"?&gt;\n&lt;!--\n  For more information on how to configure your ASP.NET application, please visit\n  http://go.microsoft.com/fwlink/?LinkId=169433\n  --&gt;\n&lt;configuration&gt;\n    &lt;configSections&gt;\n        &lt;!-- For more information on Entity Framework configuration, visit https://go.microsoft.com/fwlink/?LinkID=237468 --&gt;\n        &lt;section name=\"entityFramework\"\n        type=\"System.Data.Entity.Internal.ConfigFile.EntityFrameworkSection, EntityFramework, Version=6.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089\"\n        requirePermission=\"false\"/&gt;\n        &lt;section name=\"oracle.manageddataaccess.client\"\n        type=\"OracleInternal.Common.ODPMSectionHandler, Oracle.ManagedDataAccess, Version=4.122.23.1, Culture=neutral, PublicKeyToken=89b483f429c47342\"/&gt;\n    &lt;/configSections&gt;\n    &lt;appSettings&gt;\n        &lt;add key=\"Wisej.DefaultTheme\" value=\"saskia\" /&gt;\n        &lt;add key=\"dbname\" value=\"oifrentw\" /&gt;\n        &lt;add key=\"configFile\" value=\"central.config\" /&gt;\n        &lt;add key=\"replication\" value=\"false\" /&gt;\n        &lt;add key=\"environment\" value=\"production\"/&gt;\n    &lt;/appSettings&gt;\n    &lt;system.data&gt;\n        &lt;DbProviderFactories&gt;\n            &lt;remove invariant=\"Oracle.ManagedDataAccess.Client\" /&gt;\n            &lt;add name=\"ODP.NET, Managed Driver\" invariant=\"Oracle.ManagedDataAccess.Client\" description=\"Oracle Data Provider for .NET, Managed Driver\" type=\"Oracle.ManagedDataAccess.Client.OracleClientFactory, Oracle.ManagedDataAccess, Version=4.122.23.1, Culture=neutral, PublicKeyToken=89b483f429c47342\" /&gt;\n        &lt;/DbProviderFactories&gt;\n    &lt;/system.data&gt;\n    &lt;system.net&gt;\n        &lt;defaultProxy&gt;\n            &lt;proxy autoDetect=\"True\" bypassonlocal=\"False\" proxyaddress=\"http://my.proxy.de:12345\" /&gt;\n        &lt;/defaultProxy&gt;\n    &lt;/system.net&gt;\n    &lt;system.web&gt;\n        &lt;authentication mode=\"Windows\" /&gt;\n    &lt;/system.web&gt;\n    &lt;system.webServer&gt;\n        &lt;modules&gt;\n            &lt;remove name=\"Wisej\"/&gt;\n            &lt;add name=\"Wisej\" type=\"Wisej.Core.HttpModule, Wisej.Framework\"/&gt;\n        &lt;/modules&gt;\n        &lt;handlers&gt;\n            &lt;remove name=\"aspNetCore\"/&gt;\n            &lt;add name=\"aspNetCore\" path=\"*\" verb=\"*\" modules=\"AspNetCoreModuleV2\" resourceType=\"Unspecified\" /&gt;\n            &lt;remove name=\"wisej\"/&gt;\n            &lt;add name=\"wisej\" verb=\"*\" path=\"*.wx\" type=\"Wisej.Core.HttpHandler, Wisej.Framework\"/&gt;\n        &lt;/handlers&gt;\n        &lt;aspNetCore stdoutLogEnabled=\"false\" hostingModel=\"InProcess\" processPath=\".\\bin\\SIS.H2r.exe\" arguments=\"\" /&gt;\n    &lt;/system.webServer&gt;\n&lt;/configuration&gt;\n</code></pre>"},{"location":"Installation/h2r-net-installation.html#proxy-konfiguration","title":"Proxy Konfiguration","text":"<p>Im Unterschied zu Net Framework erfolgt die Proxy-Konfiguration \u00fcber folgende Umgebungsvariablen innerhalb der geladenen Aspnet Core Anwendung.</p> <pre><code>        &lt;aspNetCore stdoutLogEnabled=\"false\" hostingModel=\"inprocess\" processPath=\".\\bin\\SIS.H2r.exe\" arguments=\"\"&gt;\n            &lt;environmentVariables&gt;\n                &lt;environmentVariable name=\"http_proxy\" value=\"http://my.proxy.de:80\"/&gt;\n                &lt;environmentVariable name=\"https_proxy\" value=\"https://my.proxy.de:80\"/&gt;\n                &lt;environmentVariable name=\"no_proxy\" value=\".local,.my.other.domain\"/&gt;\n            &lt;/environmentVariables&gt;\n        &lt;/aspNetCore&gt;\n</code></pre> <p>Beachten sie dabei die Syntax f\u00fcr die Verwendung von Auflistungen bei <code>no_proxy</code>. Details zur erlaubten Syntax entnehmen sie bitte hier</p>"},{"location":"Installation/h2rserver-installation.html","title":"SASKIA.H2R-Jobserver","text":"<p>Der H2R Server wird mit den gleichen Installationsschritten wie die H2R Installation im IIS installiert. Details siehe hier.</p> <p>Zus\u00e4tzlich m\u00fcssen folgende Einstellungen an der Website/Webapplication und dem Anwendungspool der H2R Server Installation vorgenommen werden:</p>"},{"location":"Installation/h2rserver-installation.html#anonyme-authentifizierung","title":"Anonyme Authentifizierung","text":"<p>Aktivieren sie f\u00fcr diese IIS-Anwendung die anonyme Authentifizierung. Eine automatische Anmeldung mittels Domainenauthentifizierung ist f\u00fcr den H2R Server nicht vorgesehen.</p>"},{"location":"Installation/h2rserver-installation.html#iis-feature-anwendungsinitialisierung","title":"IIS Feature Anwendungsinitialisierung","text":"<p>F\u00fcr eine korrekte Einrichtung des H2R Server muss das IIS Feature <code>Anwendungsinitialisierung</code> installiert werden. Eine Anleitung zur Installation finden sie hier</p>"},{"location":"Installation/h2rserver-installation.html#startmodus-alwaysrunning","title":"Startmodus AlwaysRunning","text":"<p>Im Anwendungspool des H2R Servers muss im Abschnitt <code>Allgemein</code> der  Eintrag <code>Startmodus</code> auf <code>AlwaysRunning</code> gestellt werden. </p>"},{"location":"Installation/h2rserver-installation.html#leerlauftimeout-minuten","title":"Leerlauftimeout (Minuten)","text":"<p>Setzen sie im Anwendungspool des H2R Servers im Abschnitt <code>Prozessmodell</code> das <code>Leerlauftimeout</code> auf den Wert <code>0</code>. </p>"},{"location":"Installation/h2rserver-installation.html#vorabladen-aktiviert-preload-enabled","title":"Vorabladen aktiviert (Preload Enabled)","text":"<p>Aktivieren sie in den Website-Einstellungen der H2R Server Installation im Abschnitt <code>Allgemein</code> die Option <code>Vorabladen aktivert</code>. </p> <p>Weiterf\u00fchrende Informationen zu diesem Feature finden sie auf der IIS Microsoft-Website unter https://learn.microsoft.com/de-de/archive/blogs/vijaysk/iis-8-whats-new-website-settings.</p>"},{"location":"Installation/h2rserver-installation.html#baseurl-parameter-in-defaultjson-setzen","title":"baseUrl Parameter in Default.json setzen","text":"<p>Erg\u00e4nzen sie in der <code>Default.json</code> das Setting <code>baseUrl</code> und tragen sie die korrekte Url zum H2rServer ein.</p> Default.json <pre><code>{\n    \"sessionTimeout\": 0,\n    \"culture\": \"de-DE\",\n    \"settings\": {\n        \"baseUrl\": \"https://myserver.domain.de:8443\",\n    }\n}\n</code></pre>"},{"location":"Installation/h2rserver-installation.html#preload-url-im-iis-manager-einstellen","title":"Preload URL im IIS Manager einstellen","text":"<p>Makrieren sie im IIS Manager die H2R Sever Website und starten sie den Konfigurations-Editor. .</p> <p>Im folgenden Dialog w\u00e4hlen sie den <code>Abschnitt</code> <code>system.webServer/applicationInitialization</code> </p> <p>Starten sie anschlie\u00dfend in der Zeile <code>(Auflistung)</code> die Erfassung der Preload-Url. Wir tragen dort den Wert <code>/</code> ein. </p> <p>Abschlie\u00dfend setzen sie zus\u00e4tzlich im Konfigurations-Editor die Einstellung <code>doAppInitAfterRestart</code> auf <code>True</code>. </p> <p>Eine ausf\u00fchrliche Anleitung finden sie unter https://learn.microsoft.com/en-us/iis/configuration/system.webserver/applicationinitialization/.</p>"},{"location":"Installation/h2rserver-installation.html#preload-url-in-webconfig-setzen","title":"Preload URL in web.config setzen","text":"<p>Erg\u00e4nzen sie in der <code>web.config</code> folgenden Eintrag und passen sie anschlie\u00dfend die Parameter <code>initializationPage</code> und <code>hostName</code> entsprechend ihrer Systemumgebung an:</p> Web.config <pre><code>&lt;system.webServer&gt;\n    ...\n    &lt;applicationInitialization doAppInitAfterRestart=\"true\"&gt;\n        &lt;add initializationPage=\"/\" hostName=\"\" /&gt;\n    &lt;/applicationInitialization&gt;\n&lt;/system.webServer&gt;\n</code></pre>"},{"location":"Installation/h2rserver-installation.html#anmerkungen","title":"Anmerkungen","text":"<ul> <li>wenn sie den H2rServer als Webapplication im IIS einbinden, geben sie bitte dort mit <code>/</code> beginnend den Pfad an z.B. <code>/jobserver</code></li> <li>bei der Einrichtung von H2rServer als IIS-Website ist <code>/</code> korrekt</li> <li>Hostname ist nicht anzugeben</li> </ul> <p>Neustart</p> <p>Beachten sie f\u00fcr einen funktionierende Preload m\u00f6gliche URL-Rewrite Regelungen und fehlerhafte Portangaben bzw. URL's.</p> <p>Starten sie anschlie\u00dfend den IIS neu, damit die Einstellungen aktiv werden.</p> <p>Eine funktionierende Preload-Einrichtung erkennen Sie daran, dass im Task-Manager ein <code>W3p.exe</code>-Prozess mit dem entsprechenden ApplicationPool entsteht, der direkt startet und 400 MB oder mehr an Arbeitsspeicher reserviert.</p> <p></p>"},{"location":"aktuelles/index.html","title":"Aktuelles","text":"<p>Die aktuelle Version von SASKIA.H2R ist: </p> <p>5.4.0 </p>"},{"location":"aktuelles/index.html#versionshistorie","title":"Versionshistorie","text":"<p>5.3.3 5.3.2 5.3.1 5.3.0 5.2.4 5.2.3 5.2.2 5.2.1 5.2.0 5.1.1 5.1.0 5.0.2 5.0.1 </p> <p>Wichtige Informationen zu den Systemvoraussetzungen finden Sie unter  Allgemeines </p> <p>Bei einem Update wird die ben\u00f6tigte .NET 8.0 Runtime in der aktuell erforderlichen Version mitgeliefert. F\u00fcr den Betrieb von SASKIA.H2R wird zus\u00e4tzlich das .NET Core Hosting Bundle in der Version 8.0 ben\u00f6tigt, um .NET 8.0 oder h\u00f6heren Code im IIS Webserver ausf\u00fchren zu k\u00f6nnen. Dieses Hosting Bundle wurde bei der Installation von SASKIA.H2R bereits installiert und wird von Microsoft regelm\u00e4\u00dfig aktualisiert. In den Release Notes weisen wir Sie darauf hin, wenn sich die Version ge\u00e4ndert hat und ein Update durch Ihre ITK erforderlich ist.</p> <p>Weiterf\u00fchrende Informationen zum .NET Core Hosting Bundle finden sie hier</p> <p>Oder die Website zum direkten Download des .NET Core Hosting Bundle (Rubrik: ASP.NET Core Runtime) hier</p>"},{"location":"aktuelles/nutzerspezifische_anpassung.html","title":"Nutzerspezifische Programmanpassungen","text":"<p>Es ist g\u00e4ngige Praxis, Programm\u00e4nderungen oder Anpassungen, die nicht in der urspr\u00fcnglichen Dokumentation oder im Programmstand erw\u00e4hnt wurden, in zuk\u00fcnftigen Releasebeschreibungen zu kategorisieren. Dies hilft, Transparenz zu schaffen und sicherzustellen, dass alle Benutzer \u00fcber die vorgenommenen \u00c4nderungen informiert sind, auch wenn diese urspr\u00fcnglich als nutzerspezifische Fehler angesehen wurden.</p> <p>Um eine klare Kommunikation zu gew\u00e4hrleisten, k\u00f6nnte die folgende Struktur f\u00fcr die Releasebeschreibung verwendet werden:</p>"},{"location":"aktuelles/nutzerspezifische_anpassung.html#kategorie-nicht-dokumentierte-programmanderungen","title":"Kategorie: Nicht dokumentierte Programm\u00e4nderungen","text":"<ul> <li> <p>Beschreibung der Anpassung: Hier wird erkl\u00e4rt, welche \u00c4nderungen vorgenommen wurden und warum sie notwendig waren.</p> </li> <li> <p>Urspr\u00fcngliche Annahme: Eine Erl\u00e4uterung, warum die \u00c4nderungen urspr\u00fcnglich nicht als notwendig erachtet wurden (z.B. Annahme eines nutzerspezifischen Fehlers).</p> </li> </ul> <p>Durch diese Vorgehensweise wird nicht nur die Nachvollziehbarkeit von \u00c4nderungen gew\u00e4hrleistet, sondern auch das Vertrauen der Nutzer in das Produkt gest\u00e4rkt, da sie sehen k\u00f6nnen, dass alle Anpassungen dokumentiert und kommuniziert werden.</p>"},{"location":"aktuelles/news/01.08.2025.html","title":"01.08.2025 | Neuigkeiten SASKIA.H2R \u2013 Nr. 02/2025","text":"<p>Nach einem intensiven ersten Halbjahr 2025 bieten die Sommerferien f\u00fcr viele eine Gelegenheit zum Durchatmen, bevor das Jahr auf die Zielgerade einbiegt.</p> <p>Diese Zeit m\u00f6chten wir gern nutzen, um Sie \u00fcber die aktuellen Themen und Termine f\u00fcr den Bereich kommunale Finanzwirtschaft im Allgemeinen und SASKIA.H2R im Speziellen zu informieren. </p>"},{"location":"aktuelles/news/01.08.2025.html#zertifizierungen","title":"Zertifizierungen","text":"<p>SASKIA\u00ae ist durch verschiedene l\u00e4nderrechtliche Vorgaben (bspw. \u00a787 Abs. 2 S\u00e4chsGemO) verpflichtet, die Fachprogramme f\u00fcr das kommunale Haushalts-Kassen-Rechnungswesen regelm\u00e4\u00dfig einer unabh\u00e4ngigen Verfahrenspr\u00fcfung zu unterziehen. Nach dem fl\u00e4chendeckenden Wechsel von unserer bisherigen Finanzsoftware SASKIA\u00ae.de-IFR auf die Nachfolgel\u00f6sung, wurde nun erstmals SASKIA.H2R gepr\u00fcft. </p> <p>Wir freuen uns, Ihnen mitteilen zu k\u00f6nnen, dass wir in den letzten Wochen gleich zwei voneinander unabh\u00e4ngige Zertifizierungen f\u00fcr SASKIA.H2R erfolgreich absolvieren konnten.  So konnten wir zum einen die Pr\u00fcfung im Fachgebiet \u201eDoppisches Finanzwesen\u201c auf Basis der umfangreichen OKKSA-Anforderungskataloge f\u00fcr die Bundesl\u00e4nder Sachsen-Anhalt und Brandenburg abschlie\u00dfen. Zum anderen konnte SASKIA.H2R f\u00fcr den Pr\u00fcfbereich \u201eUmsatzsteuer\u201c entsprechend der SAKD-Verwaltungsvorschrift (VwV PHB-Ust.Doppik) zertifiziert werden. </p> <p>Der betr\u00e4chtliche Umfang beider Zertifizierungen zeigte dabei neben der fachlichen Tiefe auch deutlich, dass SASKIA.H2R eine zuverl\u00e4ssige, rechtssichere und auch praxisgerechte Finanzsoftware in allen Belangen der modernen kommunalen Finanzwirtschaft ist.</p> <p>Derzeit laufen weitere erg\u00e4nzende SAKD-Pr\u00fcfungen, so u.a. f\u00fcr den allgemeinen Pr\u00fcfbereich \u201eHKR-Doppik\u201c. </p>"},{"location":"aktuelles/news/01.08.2025.html#nutzungsende-saskiade-ifr","title":"Nutzungsende SASKIA\u00ae.de-IFR","text":"<p>Wie bereits mehrfach angek\u00fcndigt, m\u00f6chten wir heute die notwendige Trennung der Verfahren SASKIA\u00ae.de-IFR und SASKIA.H2R bekanntgeben. </p> <p>Bisher laufen beide Verfahren gleichberechtigt unter Nutzung der gleichen Datenbank. Dies war lange f\u00fcr einen reibungsarmen und selbst organisierten Verfahrensumstieg sehr vorteilhaft, wird allerdings mit fortschreitender Entwicklung von SASKIA.H2R zunehmend zu einer immer gr\u00f6\u00dferen Herausforderung.</p> <p>So wurden zuletzt Fehlerbehebungen oder technische Umgehungsl\u00f6sungen notwendig, die der unterschiedlichen Programmarchitektur von IFR und H2R geschuldet waren. Dies ist leider nicht nur f\u00fcr Sie oftmals \u00e4rgerlich, sondern bindet auch bei uns Zeit und Personal. </p> <p>Deshalb nehmen wir im n\u00e4chsten planm\u00e4\u00dfigen Programmupdate (Version 5.3.0) Ende August 2025 die Herausl\u00f6sung von SASKIA\u00ae.de-IFR aus dem regul\u00e4ren Benutzerzugriff vor.</p> <p>Wichtig!  Dabei werden keine Daten oder IFR-Programmdateien gel\u00f6scht, sodass der Zugriff bei gr\u00f6\u00dferen Problemen wiederhergestellt werden kann. Sollten Ihrerseits technische Gr\u00fcnde vorliegen, welche gegen diese Ma\u00dfnahme sprechen, besteht nach einer Pr\u00fcfung des Systems in Einzelf\u00e4llen die M\u00f6glichkeit, eine zeitlich begrenzte \u00dcbergangsphase zur Weiternutzung von IFR einzurichten. </p>"},{"location":"aktuelles/news/01.08.2025.html#aktualisierung-elster-transfer-software-etr","title":"Aktualisierung ELSTER Transfer-Software (ETR)","text":"<p>F\u00fcr weiterhin fehlerfreie Importe von Grund- und Gewerbesteuermeldungen in die Veranlagung von SASKIA.H2R ist die zeitnahe Aktualisierung der ELSTER-Transfer Software (ETR) erforderlich.</p> <p>Die Mindestanforderung f\u00fcr den Einsatz von ETR zur Datenabholung wird ab dem 01.09.2025 verbindlich auf Version 24.07 (Ver\u00f6ffentlichung: August 2024) angehoben.</p> <p>Entsprechende Herstellerinformationen zur ELSTER Transfer-Anwendung finden Sie auf der Webseite der Finanzverwaltung: www.elster.de/elsterweb/infoseite/verwaltung</p> <p>Bitte pr\u00fcfen Sie die bei Ihnen aktuell eingesetzte Version! Ist die Version \u00e4lter (alle Installationen vor Version 24.07), veranlassen Sie die erforderliche Softwareaktualisierung bitte bei Ihrer zust\u00e4ndigen IT-Abteilung.</p> <p>Kunden mit entsprechenden SASKIA-Systempflegevertr\u00e4gen erhalten durch unsere Systemtechnik zeitnah Terminvorschl\u00e4ge zur Aktualisierung. </p> <p>Sollten Sie Fragen haben, kontaktieren Sie uns gern per E-Mail oder telefonisch unter 0371 8088-444.</p> <p>Freundliche Gr\u00fc\u00dfe aus Chemnitz</p> <p>Ihr Team von SASKIA\u00ae </p>"},{"location":"aktuelles/news/01.08.2025.html#anmeldung-und-weitere-infos-zum-saskia-solution-day","title":"Anmeldung und weitere Infos zum SASKIA\u00ae SOLUTION DAY","text":""},{"location":"aktuelles/release-notes/5.0.1.html","title":"Release Notes 5.0.1","text":"<p>Ver\u00f6ffentlichungsdatum des Updates: 07.02.2025</p>"},{"location":"aktuelles/release-notes/5.0.1.html#allgemein","title":"Allgemein","text":""},{"location":"aktuelles/release-notes/5.0.1.html#individuelle-shortcuts-zentraler-standard","title":"Individuelle Shortcuts &amp; zentraler Standard","text":"<p>Ab sofort k\u00f6nnen Sie individuelle Tastenkombinationen ganz einfach \u00fcber die obere rechte Toolbar (Tastatursymbol) f\u00fcr Ihre Benutzerkennung festlegen und alle verf\u00fcgbaren Shortcuts auf einen Blick einsehen. Das Symbol wird invertiert dargestellt, sobald eigene Belegungen aktiv sind.  </p> <p>Zus\u00e4tzlich kann auch ein globaler Standard f\u00fcr die Tastaturbelegung zentral durch die Verwaltung definiert werden. Diese Konfiguration ist ausschlie\u00dflich mit einer Admin-Kennung m\u00f6glich und unterliegt keiner separaten Rechteverwaltung, wie es bei den globalen Tabellenansichten der Fall ist. Bereits individuell konfigurierte Belegungen einzelner Anwender bleiben dabei unver\u00e4ndert.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#1-stammdaten","title":"1 - Stammdaten","text":""},{"location":"aktuelles/release-notes/5.0.1.html#12a3-personenkontenverwaltung","title":"12a3 - Personenkontenverwaltung","text":"<p>Wird im Personenkonto als steuerliches Identifikationsmerkmal eine Steuer-ID einer nat\u00fcrlichen Person eingetragen, so kann diese mittels des nebenstehenden Symbols (runder Kreis mit Haken) auf Richtigkeit gepr\u00fcft werden. Bitte beachten Sie, dass ausschlie\u00dflich die Ziffernfolge gepr\u00fcft werden kann, nicht die Zuordnung zur Person. </p> <p>\u00c4nderungen an den Adressstammdaten k\u00f6nnen wieder \u00fcbernommen werden.</p> <p>Mandantenlogo sind wieder auf den Drucken f\u00fcr die SEPA-Mandate vorhanden.</p> <p>In der Personenkontenverwaltung ist es nun m\u00f6glich die Gemeinn\u00fctzigkeitsbescheinigung, die im Rahmen der Mitteilungsverordnung eine Bedeutung hat, zu hinterlegen. Dabei k\u00f6nnen alle Informationen zur Gemeinn\u00fctzigkeitsbescheinigung erfasst werden. Dazu z\u00e4hlen die G\u00fcltigkeitsdaten, ein eventuelles Widerrufsdatum, die Vereinsnummer, die ausstellende Beh\u00f6rde und das Aktenzeichen.  Die hier hinterlegten Werte werden dann in der Buchungsmaske und dem Eingangsrechnungsjournal visualisiert nach Auswahl des jeweiligen Personenkontos. </p>"},{"location":"aktuelles/release-notes/5.0.1.html#1272-zahlwege","title":"1272 - Zahlwege","text":"<p>Das \u00dcberzahlungsprodukt wird nun auch korrekt am Zahlweg hinterlegt, wenn dieses durch das Abtauchen in die Produktliste ausgew\u00e4hlt wurde.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#2-planung","title":"2 - Planung","text":""},{"location":"aktuelles/release-notes/5.0.1.html#27-neue-buchungsstelle","title":"27 - neue Buchungsstelle","text":"<p>Eine im Men\u00fc 27 nachtr\u00e4glich angelegte Buchungsstelle wir jetzt auch wieder in allen Planvarianten des Haushaltsjahres angelegt.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#3-buchung","title":"3 - Buchung","text":""},{"location":"aktuelles/release-notes/5.0.1.html#311-einzelbuchung","title":"311 - Einzelbuchung","text":"<p>Bei der Erfassung einer Buchung wird die Buchungsmaske bei der Eingabe eines neuen Buchungsschl\u00fcssels stets vollst\u00e4ndig zur\u00fcckgesetzt, um das Entstehen von umgekehrten Buchungss\u00e4tzen zu verhindern.</p> <p>Druckjobs werden ab sofort nicht mehr in allen Sitzungen parallel ge\u00f6ffnet.</p> <p>Hat ein Sachkonto in den Stammdaten das Kennzeichen \"Buchung bei \u00dcberschreitung des Verf\u00fcgbaren akzeptieren\" gesetzt, kann dieses nun wieder ohne Budgetumbuchung \u00fcberbucht werden.</p> <p>Im Falle einer Auszahlung ohne Soll (BS 731) ist der Zahlweg nun wieder im Haben zu erfassen, sodass der Buchungsbetrag kein gedrehtes Vorzeichen f\u00fcr die korrekte Buchung mehr ben\u00f6tigt.</p> <p>Wenn eine Einzelbuchung erfasst wird und bei dieser die Metadaten aus dem DMS \u00fcbernommen werden, erscheint bei \u00dcberschreitung der maximalen Feldl\u00e4nge eine verst\u00e4ndliche Fehlermeldung. Dadurch hat der Anwender die M\u00f6glichkeit, die Buchung entsprechend zu bearbeiten.</p> <p>Im Men\u00fc 311 Einzelbuchungsmaske wurde die an der Einnahmeart hinterlegte OP-Nummern-Bildungsfunktion \u00fcberarbeitet. Die Platzhalter Einnahmeart {EA} und Zahler  {Z} werden korrekt aufgel\u00f6st. Bei SOLl=IST - und Ratenbuchungen wird eine eindeutige OP-Nummer gebildet.</p> <p>Im Men\u00fc 311 Einzelbuchungsmaske wurde die Buchungsweise auf Freie AO's \u00fcberarbeitet. Die Zuordnung zu einer Freien Ao mit Buchungsschl\u00fcssel BS511 ist wieder m\u00f6glich. Es kommt wie im IFR eine entsprechende Abfrage.</p> <p>Im Men\u00fc 311 Einzelbuchungsmaske sind bei Zahlungs-Buchungsschl\u00fcsseln nur noch aktuelle Zahlwege ausw\u00e4hlbar. Es wird gegen die Kennzeichen aus dem Men\u00fc 1272 Zahlwege \"Zahlweg bebuchbar\" und \"Historisch ab HH-Jahr\"</p> <p>Im Men\u00fc 311 Einzelbuchungsmaske wurde bei Kreditbuchungen mit Bilanzkonten der Kontoart S0 die Auswahl von abweichenden FR-Konten angepasst. Es ist jetzt m\u00f6glich im Auswahlfeld \"FR-Konto\" abzutauschen und ein mit dem S0-Konto verbundenes FR-Konto manuell auszuw\u00e4hlen. Bitte beachten! Es wird  keine FR-Auswahl-Box mehr erzeugt!</p> <p>Buchungserfassung mit Mehrfachauswahl funktioniert nun wieder fehlerfrei.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#312-dauerbuchung","title":"312 - Dauerbuchung","text":"<p>Bei der \u00c4nderung einer Dauerbuchung wird diese nun nicht mehr doppelt angelegt.</p> <p>Das \u00c4ndern einer Dauerbuchung funktioniert wieder, ebenso die Neuanlage auf Basis einer bestehenden Dauerbuchung.</p> <p>Beim Buchen mit einer OP-Nummer, die einen Platzhalter enth\u00e4lt, erfolgt nun die korrekte Aufl\u00f6sung beim Verbuchen.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#32-tagesabschluss","title":"32 - Tagesabschluss","text":"<p>Die Plausibilit\u00e4tspr\u00fcfungen im Men\u00fc 32 bei Durchf\u00fchrung eines Tagesabschlusses hinsichtlich des Abschlusskennzeichens der Zahlwegskonten wurde \u00fcberarbeitet.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#33-buchungsstapel","title":"33 - Buchungsstapel","text":"<p>Im Men\u00fc 33 Buchungsstapel ist die Bearbeitung von Buchungs\u00e4tzen \u00fcber den Button \"Buchung bearbeiten\" wieder m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#36-anordungsverwaltung","title":"36 - Anordungsverwaltung","text":"<p>Im Men\u00fc 36 wurde eine neue Spalte \u201eAuswahl\u201c im Form einer Checkbox hinzugef\u00fcgt, um die Bedienung ergonomischer zu gestalten. Damit lassen sich Anordnungen zur Unterzeichnung, Best\u00e4tigung oder zum Nachdruck nun eindeutig ausw\u00e4hlen. Zus\u00e4tzlich kann \u00fcber das Kontextmen\u00fc per Rechtsklick auf die Spalte \u201eAuswahl\u201c bequem die gesamte Liste markiert werden.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#37-anordnung","title":"37 - Anordnung","text":"<p>Im Men\u00fc 37 wurde eine neue Spalte \u201eAuswahl\u201c im Form einer Checkbox hinzugef\u00fcgt, um die Bedienung ergonomischer zu gestalten. Damit lassen sich Anordnungen zur Unterzeichnung, Best\u00e4tigung oder zum Nachdruck nun eindeutig ausw\u00e4hlen. Zus\u00e4tzlich kann \u00fcber das Kontextmen\u00fc per Rechtsklick auf die Spalte \u201eAuswahl\u201c bequem die gesamte Liste markiert werden.</p> <p>Im Men\u00fc 37 wird nach dem Best\u00e4tigen die Maske nun automatisch aktualisiert.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#391-auskunft-personenkonten","title":"391 - Auskunft Personenkonten","text":"<p>In den Tabellen werden nun alle Betr\u00e4ge einheitlich  mit 2 Dezimalstellen dargestellt.</p> <p>Im diesem wurde f\u00fcr den Reiter OP's die Standardvorbelegung auf \"OP's bzgl.HH-Jahr\" ge\u00e4ndert. </p> <p>Der Wechsel zwischen unterschiedlichen Personenkonten funktioniert nun auch, wenn die PKs keine offenen Posten haben.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#394-budgetubsersicht","title":"394 - Budget\u00fcbsersicht","text":"<p>Die Wertefelder der Budget\u00fcbersicht, die rechnerisch ermittelt werden, zeigen nun anstatt des urspr\u00fcnglichen Tooltipps des Rechenweges, eine Berechnungstabelle auf der rechten Seite der Budget\u00fcbersicht an. Der Rechenweg des entsprechenden Wertefeldes wird NICHT durch Anklicken der Zelle angezeigt, sondern indem der Mauszeiger auf der Zelle \"liegt\".</p>"},{"location":"aktuelles/release-notes/5.0.1.html#5-auftrag","title":"5 - Auftrag","text":""},{"location":"aktuelles/release-notes/5.0.1.html#52-eingangsrechnungsjournal","title":"52 - Eingangsrechnungsjournal","text":"<p>Die Auswahlbox f\u00fcr Steuerkennzeichen im Eingangs- und Ausgangsrechnungsjournal wurde analog zur Buchungsmaske ge\u00e4ndert, so dass der Eintrag \"Nicht steuerbar\" auch \u00fcber die Tastatur ausgew\u00e4hlt werden kann.    </p> <p>Im ERJ wird bei einem Sachkonto mit Steuerart 2 wieder Steuer gezogen.</p> <p>Bei \u00c4nderung einer Eingangsrechnung im ERJ bestand das Problem, dass das Steuerkennzeichen nicht ge\u00e4ndert werden konnte. Es ist nun wieder m\u00f6glich. </p> <p>Das L\u00f6schen von bestehenden Rechnungspositionen im Eingangsrechnungsjournal funktioniert wieder.</p> <p>Ist am Personenkonto eine Gemeinn\u00fctzigkeitsbescheinigung hinterlegt, so wird dies im Eingangsrechnungsjournal und der Einzelbuchungsmaske \u00fcber das neue Symbol \"G\" sichtbar.  Gemeinn\u00fctzigkeitsbescheinigungen, deren G\u00fcltigkeit \u00fcber das aktuelle Haushaltsjahr hinaus gehen, werden mittels eines gr\u00fcn eingef\u00e4rbten \"G\" dargestellt. Ist die Gemeinn\u00fctzikeitsbescheinigung nur noch in dem aktuell zu buchenden Haushaltsjahr g\u00fcltig, bekommt das \"G\" eine gelbe Farbe und wenn die Beschenigung abgelaufen ist oder widerufen wurde, so erscheint das \"G\" in roter Farbe. </p> <p>Die Plausibilit\u00e4tspr\u00fcfungen im Men\u00fc 52 bei Durchf\u00fchrung eines Tagesabschlusses hinsichtlich des Abschlusskennzeichens der Zahlwegskonten wurde \u00fcberarbeitet.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#54-ausgangsrechnungsjournal","title":"54 - Ausgangsrechnungsjournal","text":"<p>Die Auswahlbox f\u00fcr Steuerkennzeichen im Eingangs- und Ausgangsrechnungsjournal wurde analog zur Buchungsmaske ge\u00e4ndert, so dass der Eintrag \"Nicht steuerbar\" auch \u00fcber die Tastatur ausgew\u00e4hlt werden kann. </p> <p>Beim Hinzuf\u00fcgen von weiteren Positionen wird jetzt wieder nur eine neue Tarifzeile angelegt.</p> <p>Im Men\u00fc 54 Ausgangsrechnungsjournal wurde die automatische Aktualisierungsfunktion \u00fcberarbeitet. Beim \u00d6ffnen des Men\u00fcpunktes sind sofort alle AR's des jeweiligen Nutzers entsprechend der eingestellten Statusangaben sichtbar. Weiterhin wird die \u00dcbersichtsmaske automatisch aktualisiert, wenn man aus dem Bearbeiten-Modus in die \u00dcbersicht zur\u00fcckwechselt. Sofern die \u00dcbersichtsmaske nicht absteigend nach Rechnungsnummer sortiert ist, sollte bitte f\u00fcr die Maske die Standardansicht eingestellt werden.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#55-muster-rechnungen","title":"55 - Muster-Rechnungen","text":"<p>Der Druck einer Musterrechnung im ARJ funktioniert jetzt wieder.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#6-auswertungen","title":"6 - Auswertungen","text":""},{"location":"aktuelles/release-notes/5.0.1.html#672-umsatzsteuer-meldung","title":"672 - Umsatzsteuer-Meldung","text":"<p>Die Umsatzsteuerjahresmeldung 2024 steht ab sofort zur Verf\u00fcgung. </p> <p>Die Umsatzsteuervoranmeldung, die Beantragung der Dauerfristverl\u00e4ngerung und die Durchf\u00fchrung einer Zusammenfassenden Meldung ist mit diesem Release f\u00fcr das Jahr 2025 m\u00f6glich. </p> <p>Um im Rahmen der Vorsteuerberichtigung gem\u00e4\u00df \u00a715a UStG die Angaben zu den Grundst\u00fccks-/Geb\u00e4udeeigenschaften zu machen, wurde ein neuer Eingabedialog geschaffen, der es erm\u00f6glicht, Informationen zu mehreren Grundst\u00fccken/Geb\u00e4uden zu hinterlegen.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#69-auswertungszentrale","title":"69 - Auswertungszentrale","text":"<p>In der Auswertungszentrale ist die Produktauswahl wieder fehlerfrei m\u00f6glich.</p> <p>Die Listen Ergebnis-HH (M05), Finanz-HH (M07), Ergebnisrechnung (M11) und Finanzrechnung (M12) sind technologisch bedingt nur noch \u00fcber Men\u00fc 69 - Auswertungszentrale im H2R zu drucken.    </p>"},{"location":"aktuelles/release-notes/5.0.1.html#7-jahresabschluss","title":"7 - Jahresabschluss","text":""},{"location":"aktuelles/release-notes/5.0.1.html#731-rap-verwaltung","title":"731 - RAP-Verwaltung","text":"<p>Bei der automatischen Budgetumbuchung konnte es unter bestimmten Voraussetzungen passieren, dass ein Ausgleich des Fehlbetrages durch Abschreibungskonten erfolgte. Dies wurde behoben, indem nun aus dem automatischen Budgetausgleich Sachkonten ohne anh\u00e4ngendes Finanzrechnungskonto nicht mehr zur Deckung herangezogen werden. </p>"},{"location":"aktuelles/release-notes/5.0.1.html#9-barkasse","title":"9 - Barkasse","text":""},{"location":"aktuelles/release-notes/5.0.1.html#92-einnahme-und-ausgabe-kasse","title":"92 - Einnahme und Ausgabe Kasse","text":"<p>Die Barkasse wurde komplett \u00fcberarbeitet und funktioniert jetzt wieder fehlerfrei.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#f-steuerbewertung","title":"f - Steuerbewertung","text":""},{"location":"aktuelles/release-notes/5.0.1.html#f1-steuerkompass","title":"f1 - Steuerkompass","text":"Mit der neuen Version des Steuerkompass wurden neue Subkategorien; speziell f\u00fcr typische Praxisf\u00e4lle eingef\u00fcgt: \u00dcberlassung von Fl\u00e4chen und Geb\u00e4uden/ \u00f6ffentliche Fl\u00e4chen/ Dorfplatz \u00dcberlassung von Fl\u00e4chen und Geb\u00e4uden/ \u00f6ffentliche Fl\u00e4chen/ Fl\u00e4che Altkleidercontainer \u00dcberlassung von Fl\u00e4chen und Geb\u00e4uden/ \u00f6ffentliche Fl\u00e4chen/ Wohnungsvermietung \u00dcberlassung von Fl\u00e4chen und Geb\u00e4uden/ Gemeinschaftseinrichtungen/ Gastst\u00e4tte Leistungs- und Lieferbeziehungen/ Ver- und Entsorgung/e-Ladestation <p>Dar\u00fcber hinaus wurde das Hinweisfeld bei allen Abfragen zur Kleinunternehmerregelung nach \u00a7 19 UStG bez\u00fcglich des neuen Schwellenwerts ab 01.01.2025 \u00fcberarbeitet.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#s-systemverwaltung","title":"s - Systemverwaltung","text":""},{"location":"aktuelles/release-notes/5.0.1.html#s11-systemparameter","title":"s11 - Systemparameter","text":"<p>Im Men\u00fc s11 wurde im Reiter MAIL die M\u00f6glichkeit geschaffen, ein E-Mail Funktionspostfach zu hinterlegen. Diese Konfiguration ist die Grundlage f\u00fcr die E-Mail Benachrichtigung bei Anordnungen und im Eingangsrechnungsjournal.</p>"},{"location":"aktuelles/release-notes/5.0.1.html#s21-benutzerverwaltung","title":"s21 - Benutzerverwaltung","text":"<p>Im Reiter \"Nutzer\" wurde die Spalte \"Administrator\" erg\u00e4nzt, sodass Berechtigte einen konkreten \u00dcberblick \u00fcber vorhandene Admin-Kennungen haben. Weiterhin wird im Men\u00fc s51 \u00c4nderungsprotokolle die Vergabe vom Admin-Recht protokolliert.</p>"},{"location":"aktuelles/release-notes/5.0.2.html","title":"Release Notes 5.0.2","text":"<p>Ver\u00f6ffentlichungsdatum des Updates: 14.02.2025</p>"},{"location":"aktuelles/release-notes/5.0.2.html#1-stammdaten","title":"1 - Stammdaten","text":""},{"location":"aktuelles/release-notes/5.0.2.html#124-sachkontenverwaltung","title":"124 - Sachkontenverwaltung","text":"<p>Ein Sachkonto mit der Steuerart 1 (beliebig) kann nun auch wieder OHNE Steuerkennzeichen gef\u00fchrt werden. Es ist somit m\u00f6glich in der Sachkontenverwaltung, sowie auch in der Buchungsmaske die Steuerart leer zu lassen/ auszuw\u00e4hlen. Somit wird kein steuerlicher Vorgang in Verbindung mit diesem Sachkonto erfasst.</p>"},{"location":"aktuelles/release-notes/5.0.2.html#3-buchung","title":"3 - Buchung","text":""},{"location":"aktuelles/release-notes/5.0.2.html#einzelbuchung","title":"Einzelbuchung","text":"<p>Beim Versuch eine Budgetumbuchung durchzuf\u00fchren wurden keine  Buchungsstellen zur Auswahl angeboten. Dies wurde nun behoben, so dass bei Buchungsstellen (au\u00dferhalb es Deckungskreises) nach Auswahl der Budgetumbuchung diese auch zur Verf\u00fcgung steht. </p>"},{"location":"aktuelles/release-notes/5.0.2.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":""},{"location":"aktuelles/release-notes/5.0.2.html#4a-op-anpassung","title":"4a - OP-Anpassung","text":"<p>Die Auswahl der Kreditoren ist wieder m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.0.2.html#5-auftragfaktura","title":"5 - Auftrag/Faktura","text":""},{"location":"aktuelles/release-notes/5.0.2.html#54-ausgangsrechnungsjournal","title":"54 - Ausgangsrechnungsjournal","text":"<p>Das Feld \"Position\" wurde innerhalb der Ausgangsrechnung freigeschaltet, sodass der Anwender die Reihenfolge der Positionsnummern nun wieder selbst bestimmen kann.  Beispiel: Eine Position kann an den Anfang gesetzt werden, indem die Position 0 oder -123 eingetragen wird. Die \u00c4nderungen werden allerdings erst durch das \u00dcbernehmen g\u00fcltig. Auch beim L\u00f6schen von Positionen findet nun wieder eine automatische Neunummerierung statt, sobald die \u00c4nderungen \u00fcbernommen werden.</p>"},{"location":"aktuelles/release-notes/5.0.2.html#6-auswertungen","title":"6 - Auswertungen","text":""},{"location":"aktuelles/release-notes/5.0.2.html#672-umsatzsteuermeldungen","title":"672 - Umsatzsteuermeldungen","text":"<p>Das Vorauszahlungssoll in der Dauerfristverl\u00e4ngerung wird nun anhand der Zahllasten der gesendeten Umsatzsteuervoranmeldungen des Vorjahres automatisch ermittelt.  Dieser Betrag kann jedoch \u00fcberschrieben werden. Wurden im Vorjahr ingesamt mehr Vorsteuererstattungen gebucht, so wird das Vorauszahlungssoll mit negativem Vorzeichen eingetragen, jedoch erfolgt dann keine Berechnung der Sondervorauszahlung.</p> <p>Ist keine ELSTER-ERiC-Schnittstelle f\u00fcr die Umsatzsteuer aktiv, so k\u00f6nnen nun auch wieder die Umsatzsteuervoranmeldung und die Umsatzsteuerjahresmeldung als versendet markiert werden.  In diesem Fall erscheint in den beiden genannten Registerlaschen im Men\u00fcpunkt 672 - \"Meldungen\" eine Funktion mit Briefkastensymbol. </p>"},{"location":"aktuelles/release-notes/5.0.2.html#8-veranlagung","title":"8 - Veranlagung","text":""},{"location":"aktuelles/release-notes/5.0.2.html#81-einzelveranlagung","title":"81 - Einzelveranlagung","text":"<p>Der Bescheiddruck mit Giro Code funktioniert wieder. </p>"},{"location":"aktuelles/release-notes/5.0.2.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":""},{"location":"aktuelles/release-notes/5.0.2.html#b11-anlagegut-bearbeiten","title":"b11 - Anlagegut bearbeiten","text":"<p>Es konnte keine Zuschussverkn\u00fcpfung vorgenommen werden, dies ist nun wieder m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.0.2.html#b21-zuschuss-bearbeiten","title":"b21 - Zuschuss bearbeiten","text":"<p>Es konnte keine Zuschussverkn\u00fcpfung vorgenommen werden, dies ist nun wieder m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.0.2.html#b22-zuschussfunktionen","title":"b22... - Zuschussfunktionen","text":"<p>Eine Neuerfassung von Bewegungen war nicht m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.0.2.html#k-kostenleistungsrechnungcontrolling","title":"k - Kostenleistungsrechnung/Controlling","text":""},{"location":"aktuelles/release-notes/5.0.2.html#k53-betriebskostenabrechnungsbogen-bab","title":"k53 - Betriebskostenabrechnungsbogen (BAB)","text":"<p>Der Aufruf der Kalkulation ist nun wieder in allen Kalkulationsschemen m\u00f6glich. </p> <p>Die Darstellung des Betriebsabrechnungsbogens wurde \u00fcberarbeitet, so dass die Lesbarkeit der einzelnen Zelleninhalte problemlos m\u00f6glich ist. </p>"},{"location":"aktuelles/release-notes/5.1.0.html","title":"Release Notes 5.1.0","text":"<p>Ver\u00f6ffentlichungsdatum des Updates: 10.03.2025</p>"},{"location":"aktuelles/release-notes/5.1.0.html#allgemein","title":"Allgemein","text":""},{"location":"aktuelles/release-notes/5.1.0.html#design-optimierungen-theme","title":"Design Optimierungen (Theme)","text":"<p>Verbesserung: Fokussierte Buttons in Abfragefenstern, welche durch die Leertaste ausgel\u00f6st werden k\u00f6nnen, werden nun in SASKIA-Blau (dunkelbau) hervorgehoben.  </p> <p>Verbesserung: Beim \u00dcberfahren inaktiver Buttons und Reiter wird der Mauszeiger als Verbotssymbol\ud83d\udeab dargestellt.  </p> <p>Behoben: Buttons wurden in Bestimmten Konstellationen augenscheinlich inaktiv (disabled) angezeigt obwohl diese Aktiv waren.  </p> <p>Viele weitere kleinere Optimierungen und Verbesserungen.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#startseite-to-do-kacheln","title":"Startseite To-do Kacheln","text":"<p>NEU: Auf der Startseite erscheinen mit der neuen Version zwei weitere Kacheln, die Ihnen m\u00f6gliche To-dos anzeigen. Die erste Kachel zeigt Ihnen die Anzahl der Anordnungen an, die Ihnen systemseitig ohne Einschr\u00e4nkung des Haushaltsjahres zur Unterzeichnung vorliegen. Die zweite Kachel zeigt Ihnen alle Eingangsrechnungen an, die Sie selbst erfasst haben oder die an einen entsprechenden Benutzer weitergeleitet wurden. Dabei ist der Status der Eingangsrechnung festgelegt auf \"erfasst\" und \"gedruckt\u201c. Sichtbar wird die jeweilige Kachel nur f\u00fcr jene Benutzer, die das Men\u00fcrecht f\u00fcr die Men\u00fcpunkte AO-Verwaltung (Men\u00fcpunkt 36) und Eingangsrechnungsjournal (Men\u00fcpunkt 52) haben.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#sidebar-menu","title":"Sidebar Men\u00fc","text":"<p>Behoben: Bei Verwendung des Buttons \"Alles schlie\u00dfen\" in der rechten Men\u00fcleiste wurden bei Auswahl \"Nein\" trotzdem alle Fenster geschlossen. </p>"},{"location":"aktuelles/release-notes/5.1.0.html#protokollfunktionen-abstimmungsfunktionen","title":"Protokollfunktionen &amp; Abstimmungsfunktionen","text":"<p>Verbesserung: Alle Protokollfunktionen im SASKIA.H2R, etwa in der Anlagenbuchhaltung oder Veranlagung, sowie alle Abstimmungsfunktionen, einschlie\u00dflich der Men\u00fcpunkte 733x/1z und der Planungsfunktionalit\u00e4ten, wurden hinsichtlich ihrer Laufzeit optimiert.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#druckjobs","title":"Druckjobs","text":"<p>Verbesserung: Druckjobs werden ab sofort nicht mehr in allen Sitzungen parallel ge\u00f6ffnet.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#neustrukturierung-externer-ressourcen-und-anpassungen-mit-dem-releasewechsel-51","title":"Neustrukturierung externer Ressourcen und Anpassungen mit dem Releasewechsel 5.1","text":"<p>NEU: Mit diesem Update werden externe Ressourcen, wie zum Beispiel Reports, freie Auswertungen, makrobasierte Schnittstellen sowie Logos und Wappen, die f\u00fcr den Betrieb von SASKIA.H2R bzw. SASKIA.H2R-Server erforderlich sind, vom urspr\u00fcnglichen SASKIA\u00ae.de-IFR-Programmverzeichnis getrennt. Diese Ressourcen werden k\u00fcnftig im Ordner \"deployment\" innerhalb des SASKIA.H2R-Programmverzeichnisses gespeichert. Dieser \"deployment\"-Ordner wird mit jedem Update vollst\u00e4ndig ersetzt \u2013 genau wie das gesamte SASKIA.H2R-Programmverzeichnis.</p> <p>Alle kundenindividuellen Logos und Wappen werden nun im Ordner \"customization\" verwaltet, der vom Online-Update nicht ver\u00e4ndert wird. Beim ersten Start von SASKIA.H2R werden bereits vorhandene Bilder, wie z. B. Logos und Wappen, automatisch in diesen Ordner verschoben. Ab diesem Zeitpunkt m\u00fcssen sie dort gepflegt werden.</p> <p>Beim Releasewechsel auf Version 5.1 erfolgt ein \u201eTest auf individuelle Schnittstellen und Auswertungen\u201c. F\u00e4llt dieser positiv aus, erhalten Sie eine Meldung mit der Aufforderung, sich an den Support zu wenden. Dies kann erforderlich sein, wenn makrobasierte Schnittstellen oder individuelle freie Auswertungen nicht bei SASKIA bekannt sind und daher nicht im Repository hinterlegt wurden. Falls erforderlich, werden diese durch SASKIA fest in SASKIA.H2R integriert.</p> <p>F\u00e4llt der Test negativ aus, kann es f\u00e4lschlicherweise zu einer Fehlermeldung kommen, die darauf hinweist, dass ein Fehler aufgetreten sei und das Protokoll konsultiert werden solle. Da jedoch tats\u00e4chlich kein Fehler vorliegt, enth\u00e4lt das Protokoll keine relevanten Eintr\u00e4ge. In diesem Fall bleibt der Releasewechselpunkt offen \u2013 dies hat jedoch keine Auswirkungen auf Ihre Arbeit.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#1-stammdaten","title":"1 - Stammdaten","text":""},{"location":"aktuelles/release-notes/5.1.0.html#11-pflege-mandant","title":"11 - Pflege Mandant","text":"<p>Verbesserung: Die zul\u00e4ssige Zeichenl\u00e4nge f\u00fcr die Felder \u201eTelefon\u201c und \u201eFax\u201c wurde auf 30 Zeichen erh\u00f6ht.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#121-produktverwaltung","title":"121 - Produktverwaltung","text":"<p>Verbesserung: Das Anlegen von neuen Produkten wurde hinsichtlich Ihrer korrekten automatischen Zuordnung zur P-Produkthierarchie \u00fcberarbeitet. </p>"},{"location":"aktuelles/release-notes/5.1.0.html#128-adressverwaltung","title":"128 - Adressverwaltung","text":"<p>Verbesserung: Die zul\u00e4ssige Zeichenl\u00e4nge f\u00fcr die Felder \u201eTelefon\u201c und \u201eFax\u201c wurde auf 30 Zeichen erh\u00f6ht.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#12a2-gebietsgliederung","title":"12a2 - Gebietsgliederung","text":"<p>Behoben: Im Men\u00fc 12a2 Gebietsgliederung sind die Hausnummern wieder sicht- und editierbar.</p> <p>Behoben: Die Gebietsgliederung zeigt nun nur noch Orte des aktuellen Mandanten.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#12a3-personenkontenverwaltung","title":"12a3 - Personenkontenverwaltung","text":"<p>Verbesserung: Aufgrund einer Programmanpassung werden keine automatischen Steuer-IDs in Form einer GUID mehr hinterlegt, wenn einem OP, Informationen im Rahmen der Mitteilungsverordnung hinzugef\u00fcgt werden und noch keine \"echte\" Steuer-ID hinterlegt wurde. Mit Durchf\u00fchrung des Releasewechsels werden alle bestehenden GUID entfernt. </p> <p>Verbesserung: Die zul\u00e4ssige Zeichenl\u00e4nge f\u00fcr die Felder \u201eTelefon\u201c und \u201eFax\u201c wurde auf 30 Zeichen erh\u00f6ht.</p> <p>Behoben: Die Erfassung ausl\u00e4ndischer IBAN ist m\u00f6glich, auch wenn nach den ersten beiden L\u00e4nderbuchstaben weitere Buchstaben enthalten sind.</p> <p>Behoben: Das Nebensuchfeld \"Betrag offen &gt;=\" hat nicht mehr auf die Betragseingabe reagiert, sodass auch mittels dieser Suche wieder eine Einschr\u00e4nkung auf Personenkonten m\u00f6glich ist.     </p>"},{"location":"aktuelles/release-notes/5.1.0.html#175-standorte","title":"175 - Standorte","text":"<p>Behoben: Die Standorttabelle in den Men\u00fcpunkten 175/b11 wird nun wieder in voller Fensterbreite/-l\u00e4nge angezeigt.   </p>"},{"location":"aktuelles/release-notes/5.1.0.html#1y1-textbausteine","title":"1y1 - Textbausteine","text":"<p>Behoben: In der Textbausteinverwaltung wurde die Verarbeitung komplexer (mit Gupta oder C# Befehl) und \u00fcber mehrere Ebenen verschachtelter Textbausteine (RTB/BTB) optimiert und korrigiert. Dies betrifft verschiedene Szenarien, in denen die automatische Aufl\u00f6sung von Textbausteinen innerhalb von Reports bisher zu inkonsistenten oder fehlerhaften Ergebnissen f\u00fchrte. Durch die Anpassungen wird sichergestellt, dass Verkn\u00fcpfungen und Abh\u00e4ngigkeiten innerhalb der Textbausteine nun zuverl\u00e4ssig aufgel\u00f6st werden.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#2-planung","title":"2 - Planung","text":""},{"location":"aktuelles/release-notes/5.1.0.html#22-planvarianten","title":"22 - Planvarianten","text":"<p>NEU: Im Men\u00fc hat man jetzt die M\u00f6glichkeit von einem Doppelhaushalt eine neue Variante abzuleiten und diese als Einzelhaushalt weiterzubearbeiten. Es muss zun\u00e4chst die erste Speicherung als \"Doppelhaushalt\" erfolgen. Deshalb ist die Checkbox noch inaktiv. Nach dem Speichern ist die Checkbox verf\u00fcgbar. Sp\u00e4testens beim erneuten \u00d6ffnen der Maske kann die Checkbox entfernt werden und das anschlie\u00dfende Speichern erstellt aus einen Doppelhaushalt einen Einzelhaushalt. ACHTUNG!: Dieser Prozess ist nicht umkehrbar! Es sollte dem Anwender bewusst sein, dass dies eine einmalige Aktion ist. Sprich diese neue Einzelhaushaltsvariante kann nicht zur\u00fcck zu einem Doppelhaushalt mit den urspr\u00fcnglichen Planwerten gewandelt werden. Es ist eine entsprechende Sicherheitsabfrage integriert.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#23-budgetzuordnung","title":"23 - Budgetzuordnung","text":"<p>Verbesserung: Die Budgetzuordnung wurde umgebaut und erweitert; damit geht eine neue Darstellung einher. Die Standardansicht sieht eine Gruppierung nach Budget vor und zeigte damit in erster Gruppierung auch die Buchungsstellen an, die keinem Budget zugeordnet sind, da ein 'leer' an erster Stelle steht. Wir haben eine Checkbox erg\u00e4nzt (kein Budget zugeordnet) um die Buchungsstellen bewusst ein- oder auszublenden, die keinem Budget zugeordnet sind. </p> <p>Verbesserung: Der Men\u00fcpunkt 23 - \"Budgetzuordnung\" wurde komplett \u00fcberarbeitet, so dass \u00c4nderungen zweistufig durchgef\u00fchrt werden k\u00f6nnen. Nach der Auswahl der zu ver\u00e4ndernden Buchungsstellen ist die Funktion mit den zwei Pfeilen zu verwenden, um eine \u00c4nderung bei den gew\u00e4hlten Buchungsstellen durchf\u00fchren zu k\u00f6nnen. Das System pr\u00fcft die Plausibilit\u00e4ten und zeigt ggf. ein entsprechendes Protokoll an. Dieses Protokoll kann jedoch auch manuell von jedem Anwender aufgerufen werden.  Dazu sind die gew\u00fcnschten Buchungsstellen nach dem \u00d6ffnen der Maske auszuw\u00e4hlen und dann das Listensymbol mit den Haken zu verwenden. </p>"},{"location":"aktuelles/release-notes/5.1.0.html#3-buchung","title":"3 - Buchung","text":""},{"location":"aktuelles/release-notes/5.1.0.html#311-einzelbuchung","title":"311 - Einzelbuchung","text":"<p>NEU: Ist am Personenkonto eine Gemeinn\u00fctzigkeitsbescheinigung hinterlegt, so wird dies der \u00fcber das neue Symbol \"G\" sichtbar.  Gemeinn\u00fctzigkeitsbescheinigungen, deren G\u00fcltigkeit \u00fcber das aktuelle Haushaltsjahr hinaus gehen, werden mittels eines gr\u00fcn eingef\u00e4rbten \"G\" dargestellt. Ist die Gemeinn\u00fctzigkeitsbescheinigung nur noch in dem aktuell zu buchenden Haushaltsjahr g\u00fcltig, bekommt das \"G\" eine gelbe Farbe und wenn die Bescheinigung abgelaufen ist oder widerrufen wurde, so erscheint das \"G\" in roter Farbe. </p>"},{"location":"aktuelles/release-notes/5.1.0.html#312-dauerbuchung","title":"312 - Dauerbuchung","text":"<p>Behoben: Bei der \u00c4nderung einer Daueranordnung wurde diese doppelt angelegt.</p> <p>Behoben: Es k\u00f6nnen wieder beliebig viele Daueranordnung pro Stapel erfasst werden.</p> <p>Behoben: Beim Buchen mit einer OP-Nummer, welche einen Platzhalter enth\u00e4lt, erfolgt nun die korrekte Aufl\u00f6sung beim Verbuchen.</p> <p>Behoben: In den Dauerbuchungen steht nun auch wieder die M\u00f6glichkeit der Ansicht historischer Dauerbuchungen zur Verf\u00fcgung. Bei Bedarf kann diese Checkbox mit Setzen des Hakens aktiviert werden und es werden alle Dauerbuchungen angezeigt, die nicht mehr aktiv gef\u00fchrt werden.     </p>"},{"location":"aktuelles/release-notes/5.1.0.html#32-tagesabschluss","title":"32 - Tagesabschluss","text":"<p>Verbesserung: Die Plausibilit\u00e4tspr\u00fcfungen im Men\u00fc 32 bei Durchf\u00fchrung eines Tagesabschlusses hinsichtlich des Abschlusskennzeichens der Zahlwegskonten wurde \u00fcberarbeitet.</p> <p>Behoben: Im Men\u00fc ist die Korrektur einer U-Liste in der LUSI wieder m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#33-buchungsstapel","title":"33 - Buchungsstapel","text":"<p>Behoben: Die Bearbeitung von Buchungs\u00e4tzen \u00fcber den Button \"Buchung bearbeiten\" war nicht m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#37-anordnungsfreigabe","title":"37 - Anordnungsfreigabe","text":"<p>Verbesserung: Nach der Best\u00e4tigung einer Anordnung wird die Maske automatisch aktualisiert.</p> <p>Verbesserung: Es ist eine Mehrfachauswahl von Anordnungen zur Best\u00e4tigung m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#391-auskunft-personenkonten","title":"391 - Auskunft Personenkonten","text":"<p>Verbesserung: Es wurde ein Tooltip f\u00fcr die Anzeige der Bezeichnung von Konto und Produkt im Reiter \"OP\" erg\u00e4nzt.</p> <p>Verbesserung: Im Reiter OPs wurde die Standardvorbelegung auf \"OP's bzgl.HH-Jahr\" ge\u00e4ndert. </p> <p>Behoben: Die Summierung des OP-Betrages bei einer Mehrfachauswahl von OPs war fehlerhaft. </p> <p>Behoben: Der Wechsel zwischen unterschiedlichen Personenkonten funktioniert nun auch, wenn die PKs keine offenen Posten haben.</p> <p>Behoben: In den Tabellen werden nun alle Betr\u00e4ge einheitlich mit 2 Dezimalstellen dargestellt.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#392-sachkontenauskunft","title":"392 - Sachkontenauskunft","text":"<p>Behoben: Bei der Filterung von Daten kam es noch zu einem unkorrekten Verhalten, hierzu erfolgte eine Programmanpassung. Hinweis, wenn ein Filterkriterium aber nur die untergeordnete Zeile erf\u00fcllt, dann geht die Hierarchie verloren, das ist kein Fehler und auch nicht anders l\u00f6sbar.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#394-budgetubersicht","title":"394 - Budget\u00fcbersicht","text":"<p>Behoben: Die Wertefelder der Budget\u00fcbersicht, die rechnerisch ermittelt werden, zeigen nun anstatt des urspr\u00fcnglichen Tooltipps des Rechenweges eine Berechnungstabelle auf der rechten Seite der Budget\u00fcbersicht an. Der Rechenweg des entsprechenden Wertefeldes wird NICHT durch Anklicken der Zelle angezeigt, sondern indem der Mauszeiger auf der Zelle \"liegt\".</p>"},{"location":"aktuelles/release-notes/5.1.0.html#3a2-kontoauszug-abgleich","title":"3a2 - Kontoauszug Abgleich","text":"<p>Behoben: Die Summierung des OP-Betrags wurde bei einer Mehrfachauswahl offner Posten korrigiert.</p> <p>Behoben: Wenn in der PK-Suche mit % oder * am Anfang oder Ende der Selektionsbedingung gearbeitet wurde, wurde f\u00e4lschlicherweise stets das zuerst im System angelegte, der Suchbedingung entsprechende PK als \u00dcberzahlungs-PK ausgew\u00e4hlt und in die \u00dcberzahlungsposition eingetragen.</p> <p>Behoben: Unter bestimmten Konstellationen (z.B. in der Kontoauszugsverarbeitung) erfolgte kein L\u00f6schen von Bearbeitungssperren, die vom System angelegt wurden. Damit war eine Weiterbearbeitung, z.B. des Kontoauszuges, durch andere Nutzer nicht mehr m\u00f6glich. </p> <p>Behoben: Beim manuellen Abgleich einer Kontoauszugsposition durch Doppelklick auf einen OP wurde die Ausgleichsposition fehlerhaft gebildet. Statt der Buchungsschl\u00fcssel 631/731 wurden f\u00e4lschlicherweise 411/511 verwendet. Bei der OP-\u00dcbernahme \u00fcber den Button \"OP-Zuordnung\" trat dieses Problem nicht auf. Eine OP-\u00dcbernahme per Doppelklick ist k\u00fcnftig nicht mehr m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#3a3-kontoauszug-buchen","title":"3a3 - Kontoauszug buchen","text":"<p>Verbesserung: In der Kontoauszugsverbuchung wurde die automatische OP-Nummernbildung erweitert. Wenn man im manuellen Abgleich eine \u00dcberzahlung erzeugt, kann man diese Auszugsposition einem konkreten \u201eHilfs\u201c-Personenkonto zuweisen. Dabei wird die OP-Nummer nach der neuen Regel \u00dcZ-Zahlweg/Auszugsnummer/Auszugspositionsnummer gebildet.  Durch die Hinzunahme der Auszugspositionsnummer wird der OP auf dem Personenkonto eindeutig. Mit dieser Erweiterung besteht somit die M\u00f6glichkeit, separate \u201eHilfs\u201c-Personenkonten je Fachamt zu f\u00fchren, damit \u201eungekl\u00e4rte Einzahlungen\u201c differenzierter ausgewertet werden k\u00f6nnen.</p> <p>Behoben: Beim Verbuchen der Kontoausz\u00fcge im Men\u00fc 3a3 wurde unter gewissen Konstellationen kein Buchungsdatum in die nachfolgenden Funktionen (Buchungsstapel und Offene Posten) \u00fcbergeben. Da das Buchungsdatum, ein rein informatorisches Datum ist, besteht kein direkter negativer Einfluss auf das Buchwerk. Bei m\u00f6glichen avviso-\u00dcbergaben h\u00e4tte es zu Fehlern bei der Erstellung des Vollstreckungslaufes kommen k\u00f6nnen.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":""},{"location":"aktuelles/release-notes/5.1.0.html#52-eingangsrechnungsjournal","title":"52 - Eingangsrechnungsjournal","text":"<p>Behoben: Bei der Anlage einer Eingangsrechnung mit RAP-Informationen wurde unter bestimmen Umst\u00e4nden eine Rechnung nicht gebucht. </p> <p>Behoben: Bei Erfassung einer Eingangsrechnung kann nun wieder eine abweichende Bankverbindung, bei Auswahl des Kreditors, gew\u00e4hlt werden.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#54-ausgangsrechnungsjournal","title":"54 - Ausgangsrechnungsjournal","text":"<p>Verbesserung: Im Men\u00fc wurde die Funktionalit\u00e4t \"abweichende Leistungsperiode\" im Kontext mit mind. 2 Positionen \u00fcberarbeitet.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#55-stammdaten","title":"55 - Stammdaten","text":"<p>Verbesserung: Das Feld \u201eTarifnummer\u201c wurde vergr\u00f6\u00dfert und neu positioniert.</p> <p>Behoben: Die Feldl\u00e4nge des Feldes \"Tarifgruppe\" im Men\u00fc 55 wurde auf 50 Zeichen erh\u00f6ht.</p> <p>Behoben: Der Druck einer Musterrechnung funktionierte nicht. </p> <p>Behoben: Bei der Neuanlage/Bearbeitung von Tarifen innerhalb der Stammdaten des Ausgangsrechnungsjournals waren bei der Nutzung der Tab-Taste zur Bearbeitung der einzelnen Felder nicht alle Felder mit \"Tab\" erreichbar. Dies wurde korrigiert. </p>"},{"location":"aktuelles/release-notes/5.1.0.html#6-auswertungen","title":"6 - Auswertungen","text":""},{"location":"aktuelles/release-notes/5.1.0.html#6422-teilergebnisrechnung","title":"6422 - Teilergebnisrechnung","text":"<p>Behoben: Beim Druck der Teilergebnisrechnung wurden in den Spaltenk\u00f6pfen die selektierten Perioden nicht korrekt ausgewiesen. </p>"},{"location":"aktuelles/release-notes/5.1.0.html#6612-lastschriftvorschlag","title":"6612 - Lastschriftvorschlag","text":"<p>Behoben: Das Setzen der Option \"Enth\u00e4lt Wandlungsschreiben\" im Lastschriftlauf funktionierte nicht.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#663-op-listen-stichtag","title":"663 - OP-Listen Stichtag","text":"<p>Behoben: Ausl\u00e4ndische Personenkonten werden wieder korrekt in der OP-Liste dargestellt.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#672-umsatzsteuer-meldung","title":"672 - Umsatzsteuer-Meldung","text":"<p>Verbesserung: Eine Umsatzsteuermeldung kann nun auch auf der \"Startseite\" des Men\u00fcpunkts 672 erstellt werden. Dabei wird eine Meldung immer genau f\u00fcr die Periode erstellt, die markiert ist. </p> <p>Verbesserung: Die Gruppierung der Steuerkennzeichenzuordnung \"Nicht zum Steuerformular zugeordnet\" beachtet nun die Steuer- anstatt Buchungsperiode. Das hei\u00dft, wenn im H2R mit der Steuerbearbeitung erst bspw. 2024 begonnen wurde, somit im Men\u00fc 11 in 2023 keine Stammdaten/Zuordnungen der Steuerkennzeichen eingepflegt wurden, jedoch ein Beleg buchhalterisch in 2023 gebucht, steuerlich in 2024 steht, wird nun die Steuerperiode beachtet (hier 2024) um in der Gruppierung der Steuerkennzeichen die korrekte Abbildung darzustellen.</p> <p>Behoben: Das Anlegen von zusammenfassenden Steuermeldungen ist wieder m\u00f6glich. Gleichzeitig wurde der Anzeige-/Erstellungsprozess \u00fcberarbeitet.</p> <p>Behoben: In der Steuerbuchungsrecherche als auch in den ausstehenden Buchungen der Umsatzsteuermeldung ist die Filterung nach dem Personenkonto nun wieder m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#674-buchung-abziehbare-vorsteuer","title":"674 - Buchung abziehbare Vorsteuer","text":"<p>Verbesserung: Wird ein Buchungslauf zur nicht abziehbaren Vorsteuer erfasst, bei dem die abweichende Leistungsperiode im Vorjahr liegt und eine Quotenkorrektur erfolgt, werden nun folgende Punkte ber\u00fccksichtigt: 1. Ist das Vorjahr, in dem der Aufwand korrigiert wurde, noch offen, so wird eine Stornobuchung in der Periode erzeugt und in der neuen Periode eingebucht, wenn im neuen NAV-Lauf nach Korrektur der Quote ohne Ber\u00fccksichtigung der Leistungsperiode eine Buchung erfolgen soll.  2. Ist das Vorjahr unter den o.g. Voraussetzungen bereits abgeschlossen, so wird die Korrekturbuchung in der ersten Periode des n\u00e4chsten offenen Haushaltsjahres daf\u00fcr verwendet und die Verf\u00fcgbarkeitspr\u00fcfung erfolgt ebenfalls in dem n\u00e4chsten offenen Haushaltsjahr.  Die Standardansicht wurde dahingehend angepasst, dass das Haushaltsjahr in der Verf\u00fcgbarkeitspr\u00fcfung sichtbar ist. </p> <p>Behoben:  Bei der automatischen Budgetumbuchung konnte es unter bestimmten Voraussetzungen passieren, dass ein Ausgleich des Fehlbetrages durch ein Abschreibungskonto erfolgte. Sachkonten ohne anh\u00e4ngendes Finanzrechnungskonto werden nicht mehr zur Deckung herangezogen. </p>"},{"location":"aktuelles/release-notes/5.1.0.html#69-auswertungszentrale","title":"69 - Auswertungszentrale","text":"<p>Behoben:  Die \"Jahresverf\u00fcgbarkeit\" steht ab sofort wieder als Auswahl im Sachkontenauszug zur Verf\u00fcgung. </p> <p>Behoben:  Die Interpunktion der Produkte erfolgt an den Stellen wieder automatisch, an denen beim Absprung in die Auswahl keine Mehrfachauswahl zul\u00e4ssig ist. Ist beim Absprung eine Mehrfachauswahl zugelassen, so muss bei der manuellen Eingabe der Produktnummer auch die Interpunktion gesetzt werden. </p> <p>Behoben:  Beim Druck der Teilergebnisrechnung wurden in den Spaltenk\u00f6pfen die selektierten Perioden nicht korrekt ausgewiesen.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#7-jahresabschluss","title":"7 - Jahresabschluss","text":""},{"location":"aktuelles/release-notes/5.1.0.html#733x-abstimmungsfunktionen","title":"733x - Abstimmungsfunktionen","text":"<p>Verbesserung: Die Abstimmungsfunktionen in den Men\u00fcpunkten 733x. wurden hinsichtlich ihres Laufzeitverhaltens optimiert.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":""},{"location":"aktuelles/release-notes/5.1.0.html#b11-bearbeiten","title":"b11 - Bearbeiten","text":"<p>Behoben: Die Standorttabelle in den Men\u00fcpunkten 175/b11 wird nun wieder in voller Fensterbreite/-l\u00e4nge angezeigt.   </p>"},{"location":"aktuelles/release-notes/5.1.0.html#f-steuerbewertung","title":"f - Steuerbewertung","text":"NEU: Der Steuerkompass wurde im Bereich Liegenschafts- und Geb\u00e4udemanagement um folgende Themenbereiche erweitert: Parken / Garage DDR-Altertrag sonstige dingliche Rechte / Erbbaurecht sonstige dingliche Rechte / Werberecht <p>NEU: Der Bereich Leistungs- und Lieferbeziehungen wurde um Sonderf\u00e4lle und den innergemeinschaftlichen Erwerb erg\u00e4nzt. Der Fragenkatalog der Vorsteuer wurde auf Basis des BMF-Schreibens vom 12.06.2024 aktualisiert. </p> <p>Verbesserung: Zudem wurde die Vorsteuerkorrektur nach \u00a715a (neu)/ Vorsteuerkorrektur \u00a715a Abs. 1 UStG angepasst. Hier ist zu beachten, dass der Hilfetext in der rechten Sidebox sehr lang ist und in der Standardansicht \"abgeschnitten\" wird. Um den gesamten Text lesen zu k\u00f6nnen, muss die Box breit gezogen werden. Daf\u00fcr reicht es, sich mit dem Mauszeiger auf den linken Rand der Box zu stellen und zu ziehen, wenn das entsprechende Pfeilsymbol erscheint. </p>"},{"location":"aktuelles/release-notes/5.1.0.html#k-kostenrechnungcontrolling","title":"k - Kostenrechnung/Controlling","text":""},{"location":"aktuelles/release-notes/5.1.0.html#k51-controlling-journal","title":"k51 - Controlling Journal","text":"<p>Verbesserung: Da es zwischenzeitlich zu Problemen in der Darstellung der Abfragefelder f\u00fcr das Controllingjournal kam, wurde das Layout angepasst. Somit steht nun wieder eine einheitliche Ansicht zur Verf\u00fcgung und die vorhandenen Felder bleiben best\u00e4ndig an den gewohnten Stellen verf\u00fcgbar. </p>"},{"location":"aktuelles/release-notes/5.1.0.html#s-system","title":"s - System","text":""},{"location":"aktuelles/release-notes/5.1.0.html#s11-systemparameter-reiter-mail-konfiguration","title":"s11 - Systemparameter - Reiter MAIL-Konfiguration","text":"<p>NEU: Da SASKIA.H2R im Gegensatz zum IFR keine Client-Server-Anwendung mehr ist, kann das lokale (Outlook-)Mail-Profil des Nutzers nicht mehr verwendet werden. Der Browser blockiert den Zugriff darauf aus Sicherheitsgr\u00fcnden. Daher kann nun ein SMTP-Mailserver mit einer zentralen Mailadresse f\u00fcr die interne Kommunikation z.B. AO-Benachrichtigungen oder den internen Versand von Dokumenten, direkt aus H2R heraus konfiguriert werden.  </p> <p>Der zu verwendende SMTP-Port h\u00e4ngt vom gew\u00e4hlten Verschl\u00fcsselungstyp und vom Mailserver ab:</p> <ul> <li>Port 25 (ggf. von Firewalls blockiert): ohne Verschl\u00fcsselung (None)  </li> <li>Port 465 SSL/TLS (SslOnConnect)  </li> <li>Port 587 STARTTLS (StartTls, StartTlsWhenAvailable)  </li> </ul> <p>Falls der Mailserver eigene Ports verwendet oder Unklarheit besteht, kann der korrekte SMTP-Port in der Dokumentation des Mailservers nachgeschlagen oder direkt beim IT-Administrator erfragt werden.</p> <p>Zus\u00e4tzlich kann der Verschl\u00fcsselungstyp f\u00fcr die Verbindung zum Mailserver ausgew\u00e4hlt werden. Dabei stehen folgende Optionen zur Verf\u00fcgung:</p> <ul> <li>None (keine Verschl\u00fcsselung)  </li> <li>Auto (automatische Auswahl)  </li> <li>SslOnConnect (SSL/TLS-Verschl\u00fcsselung direkt bei der Verbindung)  </li> <li>StartTls (TLS wird nach der Verbindung aktiviert)  </li> <li>StartTlsWhenAvailable (TLS wird genutzt, wenn es verf\u00fcgbar ist)  </li> </ul> <p>Um die Konfiguration zu \u00fcberpr\u00fcfen, steht eine Testfunktion zur Verf\u00fcgung. Hier kann eine Test-E-Mail an eine beliebige E-Mail-Adresse versendet werden. Nach dem Klick auf \"Absenden\" wird gepr\u00fcft, ob die Mail erfolgreich \u00fcber den konfigurierten SMTP-Server verschickt werden kann.</p>"},{"location":"aktuelles/release-notes/5.1.0.html#s21-benutzerverwaltung","title":"s21 - Benutzerverwaltung","text":"<p>Verbesserung: Im Men\u00fc wurde im Reiter Gruppen das Recht \"Adressnummer\" in \"Debitorennummer\" umbenannt. Weiterhin wurden diesbez\u00fcgliche Berechtigungspr\u00fcfungen in Buchungs- und Auskunftsfunktionen \u00fcberarbeitet.</p> <p>Verbesserung: Die zul\u00e4ssige Zeichenl\u00e4nge f\u00fcr die Felder \u201eTelefon\u201c und \u201eFax\u201c wurde auf 30 Zeichen erh\u00f6ht</p>"},{"location":"aktuelles/release-notes/5.1.0.html#admin-konsole","title":"Admin-Konsole","text":""},{"location":"aktuelles/release-notes/5.1.0.html#session-uberblick","title":"Session-\u00dcberblick","text":"<p>NEU: Die Admin-Konsole zeigt jetzt die Gesamtzahl der Sitzungen als Kachel im oberen Teil an. Es wurden in der Admin-Konsole zwei Kacheln f\u00fcr die Visualisierung aktiver und inaktiver Sessions eingef\u00fcgt. Bei Doppelklick auf die Rote Kachel f\u00fcr die inaktiven Sessions werden diese beendet und eine kleine Meldung angezeigt, dass die Aktion abgeschlossen wurde. Au\u00dferdem wird die Ansicht sofort aktualisiert.   </p>"},{"location":"aktuelles/release-notes/5.1.1.html","title":"Release Notes 5.1.1","text":"<p>Ver\u00f6ffentlichungsdatum des Updates: 11.04.2025</p>"},{"location":"aktuelles/release-notes/5.1.1.html#0-global","title":"0 - Global","text":""},{"location":"aktuelles/release-notes/5.1.1.html#013-postausgang","title":"013 - Postausgang","text":"<p>Verbesserung: Die \u00dcbergabe von Vorlagen in den Postausgang erfolgt nun zuverl\u00e4ssiger. Zudem wurde die Filterfunktion erweitert, sodass Postausg\u00e4nge nun nach Erstellungs- und Versanddatum eingegrenzt werden k\u00f6nnen.</p>"},{"location":"aktuelles/release-notes/5.1.1.html#1-stammdaten","title":"1 - Stammdaten","text":""},{"location":"aktuelles/release-notes/5.1.1.html#12a3-personenkontenverwaltung","title":"12a3 - Personenkontenverwaltung","text":"<p>Behoben: Die Anlage einer Gemeinn\u00fctzigkeitsbescheinigung am Personenkonto im Rahmen der Mitteilungsverordnung war nicht m\u00f6glich. </p> <p>Behoben: Personenkonten, die als Zahlungspflichtiger angelegt wurden, konnten nicht angezeigt werden und standen somit auch nicht als Kontoinhaber zur Auswahl.</p>"},{"location":"aktuelles/release-notes/5.1.1.html#2-planung","title":"2 - Planung","text":""},{"location":"aktuelles/release-notes/5.1.1.html#23-budgetzuordnung","title":"23 - Budgetzuordnung","text":"<p>Verbesserung: Die Budgetzuordnung wurde mit SASKIA.H2R umgebaut und um eine neue Darstellung erg\u00e4nzt. Standardm\u00e4\u00dfig erfolgt die Gruppierung nach Budget, wodurch zun\u00e4chst auch Buchungsstellen ohne Budgetzuordnung angezeigt wurden. Eine neue Checkbox \"kein Budget zugeordnet\" erm\u00f6glicht es nun, diese Buchungsstellen gezielt ein- oder auszublenden. </p>"},{"location":"aktuelles/release-notes/5.1.1.html#3-buchung","title":"3 - Buchung","text":""},{"location":"aktuelles/release-notes/5.1.1.html#3521-eingangsschnittstelle-einlesen","title":"3521 - Eingangsschnittstelle einlesen","text":"<p>NEU: GMBAX-Meldungen k\u00f6nnen \u00fcber die Grundsteuer-Schnittstelle eingelesen und verarbeitet werden. Die \u00c4nderung des neuen Aktenzeichens ist vorerst manuell \u00fcber das Objekt durchzuf\u00fchren. </p>"},{"location":"aktuelles/release-notes/5.1.1.html#37-anordnungsfreigabe","title":"37 - Anordnungsfreigabe","text":"<p>Behoben: Erfasste Weiterleitungs-Bemerkungen wurden nicht angezeigt.</p>"},{"location":"aktuelles/release-notes/5.1.1.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":""},{"location":"aktuelles/release-notes/5.1.1.html#41-aufrechnung","title":"41 - Aufrechnung","text":"<p>Verbesserung: Die technologische Aufrechnungs-Reihenfolge bei einer Verrechnung von mindestens drei offenen Posten wurde angepasst, sodass am Ende gegebenenfalls nur ein anteilig offener Posten verbleibt.</p>"},{"location":"aktuelles/release-notes/5.1.1.html#441-niederschlagung","title":"441 - Niederschlagung","text":"<p>Behoben: Im Reiter \"Auswahl\" wurden bereits erfasste Niederschlagungen doppelt angezeigt.</p>"},{"location":"aktuelles/release-notes/5.1.1.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":""},{"location":"aktuelles/release-notes/5.1.1.html#52-eingangsrechnungsjournal","title":"52 - Eingangsrechnungsjournal","text":"<p>Behoben: Wurde w\u00e4hrend der Erfassung oder Bearbeitung einer Eingangsrechnung zu einem anderen Men\u00fcpunkt gewechselt, so konnte es vorkommen, dass sich die verwendeten Men\u00fcpunkte selbstst\u00e4ndig mehrfach \u00f6ffneten. Ebenso konnte es vorkommen, dass selbst definierte Favoriten verschwanden oder andere Favoriten auf der Startseite angezeigt wurden.</p> <p>Behoben: Bei der Verwendung eines Sachkontos mit der Steuerart 2 (feste Vorgabe eines Steuerkennzeichens) steht nun ausschlie\u00dflich das hinterlegte Steuerkennzeichen sowie optional das Kennzeichen f\u00fcr nicht abziehbare Vorsteuer zur Auswahl.</p> <p>Behoben: Eingangsrechnungen konnten unter Zuhilfenahme von vollst\u00e4ndigen und unvollst\u00e4ndigen Verteilungsringen nicht angelegt und gebucht werden. </p> <p>Behoben: Bei der Stornierung einer Eingangsrechnung in Verbindung mit einem zugeh\u00f6rigen Auftrag kam es in bestimmten Konstellationen zu einer fehlerhaften Berechnung der verf\u00fcgbaren Mittel innerhalb des Auftrags. </p>"},{"location":"aktuelles/release-notes/5.1.1.html#54-ausgangsrechnungsjournal","title":"54 - Ausgangsrechnungsjournal","text":"<p>Behoben: Die Aufl\u00f6sung von Platzhaltern (Berichtsdaten des Textbausteindatenstromes) innerhalb der Individualtexte funktionierte nicht mehr. </p> <p>Behoben: \u00c4nderungen an den Individualtexten werden nun wieder korrekt angezeigt und gedruckt.</p>"},{"location":"aktuelles/release-notes/5.1.1.html#6-auswertungen","title":"6 - Auswertungen","text":""},{"location":"aktuelles/release-notes/5.1.1.html#671-umsatzsteuerjournal","title":"671 - Umsatzsteuerjournal","text":"<p>Verbesserung: Die Anzeige der nicht f\u00e4lligen Umsatzsteuer wurde dahingehend \u00fcberarbeitet, dass die gezeigten offenen Posten mit dem Merkmal \"Ist-Versteuerung\" einen Stichtagsbezug haben und auf den eingestellten Stichtag reagieren. </p>"},{"location":"aktuelles/release-notes/5.1.1.html#9-barkasse","title":"9 - Barkasse","text":""},{"location":"aktuelles/release-notes/5.1.1.html#92-einnahme-und-ausgabe-kasse","title":"92 - Einnahme und Ausgabe Kasse","text":"<p>Behoben: Die Verbuchung von Barkassenvorg\u00e4ngen f\u00fcr Soll-Ist Buchungen (Buchungsschl\u00fcssel 421 und 424) wurde korrigiert. </p>"},{"location":"aktuelles/release-notes/5.1.1.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":""},{"location":"aktuelles/release-notes/5.1.1.html#b11-anlagegut-bearbeiten","title":"b11 - Anlagegut Bearbeiten","text":"<p>Verbesserung: Hinweis-Meldungen (blaue Message Box) zu fehlenden Steuer-Quotierungen am Produkt werden beim \u00d6ffnen des Men\u00fcpunkts nicht mehr angezeigt.</p>"},{"location":"aktuelles/release-notes/5.1.1.html#b12x-zusatzfunktionen-anlageguter","title":"b12x - Zusatzfunktionen (Anlageg\u00fcter)","text":"<p>Behoben: In bestimmten Konstellationen konnte das Produkt oder Sachkonto weder durch manuelle Eingabe noch durch Auswahl ge\u00e4ndert werden.</p>"},{"location":"aktuelles/release-notes/5.1.1.html#b17-assistent-vorsteuer","title":"b17 \u2013 Assistent Vorsteuer","text":"<p>Neu: Der Vorsteuerassistent wurde vollst\u00e4ndig \u00fcberarbeitet und ber\u00fccksichtigt bei der Berechnung der Berichtigungswerte - sofern die Checkbox \"manuell\" nicht aktiviert ist - die Anforderungen gem\u00e4\u00df \u00a7 44 UStDV.</p> <p>Die \u00dcberarbeitung umfasst folgende Neuerungen:</p> <ol> <li>Einzeldruck pro Inventargut ist nun als separater Funktionsaufruf auf der rechten Seite der Toolbar verf\u00fcgbar.  </li> <li>Bei Eingabe des Vorsteuerwerts erfolgt eine automatische Pr\u00fcfung, ob dieser den Schwellenwert von 1.000 EUR \u00fcberschreitet.  </li> <li>Die Ansicht der zu berichtigenden Werte zeigt nur noch die Vergangenheitswerte bis zum aktuell eingestellten Haushaltsjahr an.  </li> <li>Eine neue Checkbox \"Vorschau\" erm\u00f6glicht die Anzeige der Berichtigungswerte aus Sicht des aktuellen Haushaltsjahres.  </li> <li>Es gibt einen neuen Spaltenbereich \"\u00a7 44 UStDV\" mit den darunterliegenden Spalten \"\u00c4nderung Quote\" und \"\u00c4nderung Vorsteuerbetrag\". Die Checkboxen werden systemseitig aktiv, je nachdem welche Auswirkung die Quotenanpassung in den Stammdaten des Produktes im Vergleich zur urspr\u00fcnglichen Quote hat. Je nach \u00c4nderung berechnet das System automatisch, ob Korrekturwerte erforderlich sind oder nicht. Die Begr\u00fcndung f\u00fcr oder gegen eine Berechnung wird als Tooltip angezeigt.   </li> <li>Die Informationen aus den Tooltips sind auch in den Auswertungen (Gesamtdruck und Einzeldruck) nachvollziehbar enthalten.</li> </ol> <p>Behoben: Das Speichern der Quote eines Produkts in der Anlagenbuchhaltung war zeitweise nicht m\u00f6glich, was zu wiederholten Hinweis-Boxen aufgrund fehlender Quoten f\u00fchrte. Dieser Fehler wurde behoben \u2013 das System erkennt nun wieder die in der Produktverwaltung hinterlegten Quoten korrekt.</p> <p>Behoben: Hinweis-Meldungen (blaue Message Box) zu fehlenden Steuer-Quotierungen am Produkt wurden in bestimmten Konstellationen zweifach angezeigt.</p>"},{"location":"aktuelles/release-notes/5.1.1.html#b22x-zuschussfunktionen","title":"b22x - Zuschussfunktionen","text":"<p>Behoben: In bestimmten Konstellationen konnte das Produkt oder Sachkonto weder durch manuelle Eingabe noch durch Auswahl ge\u00e4ndert werden. Des Weitern fand eine Validierung auf Richtigkeit der Buchungsstelle nicht statt.</p>"},{"location":"aktuelles/release-notes/5.1.1.html#s-system","title":"s - System","text":""},{"location":"aktuelles/release-notes/5.1.1.html#s11-systemparameter-reiter-mail-konfiguration","title":"s11 - Systemparameter - Reiter MAIL-Konfiguration","text":"<p>Verbesserung: Der neue Parameter \"SSL-Richtlinienfehler ignorieren\" steuert, ob SSL-Zertifikatsfehler bei der Verbindung mit einem Server ignoriert werden sollen. Wenn dieser Parameter auf \"True\" gesetzt ist, werden Zertifikatswarnungen (z. B. abgelaufene oder nicht vertrauensw\u00fcrdige Zertifikate) nicht als Verbindungsfehler behandelt.</p>"},{"location":"aktuelles/release-notes/5.1.1.html#s59-aufgabenuberwachung","title":"s59 - Aufgaben\u00fcberwachung","text":"<p>Behoben: Beim Zur\u00fccksetzen des DMS-\u00dcbergabe-Status per Mehrfachauswahl wurde nur der erste Eintrag zur\u00fcckgesetzt, anstatt die gesamte Auswahl zu ber\u00fccksichtigen.</p>"},{"location":"aktuelles/release-notes/5.2.0.html","title":"Release Notes 5.2.0","text":"<p>Ver\u00f6ffentlichungsdatum des Updates: 09.05.2025</p>"},{"location":"aktuelles/release-notes/5.2.0.html#ubergreifende-funktionen","title":"\u00fcbergreifende Funktionen","text":""},{"location":"aktuelles/release-notes/5.2.0.html#allgemein","title":"Allgemein","text":"<p>Neu: Die Hauptreiter (Tabs) im Programm k\u00f6nnen nun verschoben und somit frei angeordnet werden. Dies erm\u00f6glicht eine individuell anpassbare Benutzeroberfl\u00e4che entsprechend der pers\u00f6nlichen Arbeitsweise.</p> <p>Verbesserung: Die Filterfunktionen (Tabellenkopf) in den einzelnen Tabellenansichten  wurden optimiert, sodass sie nun auch bei einer gro\u00dfen Datenmenge eine stabile und performante Ausf\u00fchrung gew\u00e4hrleisten. Zus\u00e4tzlich wurde die Suchfunktion innerhalb der Filterauswahl verbessert, sodass diese eine gezielte Eingrenzung der angezeigten Daten erm\u00f6glicht und die Bedienbarkeit weiter verbessert. Zahlenwerte m\u00fcssen im Filterfeld nicht mehr mit Tausendertrennzeichen eingegeben werden und es k\u00f6nnen Vergleichsoperatoren wie =, &gt;, &lt; verwendet werden.</p> <p>Behoben:  Die Speicherung einer individuellen Spaltenanordnung in den einzelnen Tabellen wurde \u00fcberarbeitet. Nutzerdefinierte Einstellungen bleiben nun systemweit auch nach der n\u00e4chsten Programmanmeldung erhalten.Au\u00dferdem k\u00f6nnen gespeicherte Tabellenansichten wieder korrekt aufgerufen werden.</p> <p>In bestimmten F\u00e4llen wurden auf dem eigenen Dashboard f\u00e4lschlicherweise die Favoriten anderer Benutzer angezeigt, w\u00e4hrend die eigenen Favoriten nicht sichtbar waren.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#budgetumbuchungen","title":"Budgetumbuchungen","text":"<p>Behoben:  Bei der manuellen Budgetumbuchung werden in der \u00dcbersicht zur Auswahl der verf\u00fcgbaren Mittel wieder Konten zur Deckung angezeigt, denen kein Finanzrechnungskonto zugeordnet ist.  Eine entsprechende Auswahl zur Herstellung von Verf\u00fcgbarkeit ist damit gegeben. </p> <p>Bitte beachten: Diese M\u00f6glichkeit steht ausschlie\u00dflich au\u00dferhalb von Deckungskreisen zur Verf\u00fcgung. Im Rahmen von Deckungskreisen werden Konten ohne zugeordnete FR-Konten nicht zur Deckung ber\u00fccksichtigt. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#dms","title":"DMS","text":"<p>Verbesserung: In der DMS-Vorschau ist nun auch die Anzeige von Dokumenten des Typs .docx sowie von einfachen Excel-Dateien m\u00f6glich. Achtung: Bitte beachten Sie, dass es sich hierbei lediglich um eine Vorschau handelt, die in Einzelf\u00e4llen vom Originaldokument abweichen kann. Sollte dies der Fall sein, kann das betreffende Dokument heruntergeladen und mit einer geeigneten Anwendung ge\u00f6ffnet werden.</p> <p>Behoben: Beim Hinzuf\u00fcgen von Zusatzdokumenten wird bei der Verwendung der \u201eBl\u00e4ttern\u201c-Funktion in Kombination mit einem ge\u00f6ffneten zweiten DMS-Fenster die Belegnummer automatisch aktualisiert. Dies stellt sicher, dass die versehentlich \"falsche\" Verkn\u00fcpfung eines Zusatzdokuments verhindert wird. Zudem wird in der Auswahlliste der Belegnummern nun ausschlie\u00dflich die eindeutige Belegnummer des aktuell angezeigten DMS-Vorgangs dargestellt.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#druck","title":"Druck","text":"<p>Behoben: Die Aufl\u00f6sung komplexer, mehrzeiliger Ausdr\u00fccke in den Textbausteinen kann nun korrekt verarbeitet werden. Damit ist sichergestellt, dass beim Druck die entsprechenden Informationen vollst\u00e4ndig und korrekt dargestellt werden.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#mandantenspezifische-funktionen","title":"Mandantenspezifische Funktionen","text":"<p>Behoben:  Werden mehrere Mandanten verwendet und darin eine gleiche Budgetnummer oder ein gleicher Buchungskreis (K\u00fcrzel) benutzt, werden nun in verschiedenen Masken die korrekten Bezeichnungen des jeweiligen Mandanten wieder angezeigt. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#startseite","title":"Startseite","text":"<p>Neu:  Auf der Startseite steht eine neue Kachel zur Verf\u00fcgung, die entsprechend der Berechtigung die Anzahl der offenen Veranlagungen des gew\u00e4hlten Mandanten anzeigt. Mit einem Klick auf die Kachel werden dann die offenen Veranlagungen nach Einnahmeart und Haushaltsjahr angezeigt. In der Anzeige wird auch (im Vergleich zu SASKIA.de-IFR) das Recht auf Einnahmearten ber\u00fccksichtigt. </p> <p>Auf der Startseite steht, abh\u00e4ngig vom Men\u00fcrecht eine neue Kachel \"letzter Tagesabschluss\" zur Verf\u00fcgung.Diese zeigt an, wann der letzte Tagesabschluss erfolgt ist. </p> <p>Auf der Startseite steht eine neue Kachel \"Postausgang\" zur Verf\u00fcgung. Auf dieser Kachel werden ausschlie\u00dflich die \u00dcbertragungsfehler des Postausgangs angezeigt, damit jeder Versender einen \u00dcberblick hat. Mit dem Klick auf die Kachel gelangt man direkt in den Postausgang. </p> <p>Verbesserung:  Das Design und die Bedienung der Kacheln und Favoriten auf der Startseite wurden \u00fcberarbeitet:</p> <ul> <li>Kachlen und Favoriten wurden in einem Bereich (Raster) vereinheitlicht.</li> <li>Info-Kacheln weisen durch einen dezenten Animationseffekt mit Farbverlauf auf Neuigkeiten oder \u00c4nderungen hin. </li> <li>\u00dcber die Schaltfl\u00e4chen (4 Buttons nachstehend n\u00e4her erl\u00e4utert) in der oberen rechten Ecke der Startseite kann der Bearbeitungsmodus (Stift Symbol) aktiviert werden.</li> <li>Kachelgr\u00f6\u00dfe und -farbe k\u00f6nnen nun individuell im Bearbeitungsmodus an der jeweiligen Kachel oder Favorit selbst angepasst werden.</li> <li>Die Bezeichnung einer Favoriten-Kachel kann durch einen langen Klick direkt auf die Kachel ge\u00e4ndert werden.</li> <li>Im Bearbeitungsmodus lassen sich Favoriten oder Kacheln mit einem langen Klick auf das M\u00fclleimer-Symbol l\u00f6schen.</li> <li>Alle vorhandenen Info-Kacheln lassen sich \u00fcber den Button \u201eAlle Info-Kacheln wiederherstellen\u201c (Doppelpfeil-Symbol) auf einmal einblenden oder k\u00f6nnen gezielt \u00fcber den Button \u201eAusgeblendete Kacheln hinzuf\u00fcgen\u201c (Plus-Symbol) aktiviert werden. </li> <li>Sollten Kacheln oder Favoriten nach dem Update nicht wie gewohnt platziert sein, so k\u00f6nnen diese \u00fcber den Button \"Alles neu anordnen\" (Kachel-Symbol) automatisch am Raster neu ausgerichtet werden.</li> <li>Neue Kacheln oder Favoriten werden nun automatisch rechts neben bestehende oder in einer neuen Zeile am Ende der vorhandenen Elemente eingef\u00fcgt.</li> </ul> <p>Der Abruf des Men\u00fcpunktes \u00fcber die Kachel \"offene Anordnungen\" wurde \u00fcberarbeitet. Benutzer, die die Men\u00fcpunkte 36 - AO-Verwaltung und 37 - Anordnungsfreigabe berechtigt haben, werden mit dem Doppelklick auf die Kachel in das Men\u00fc der Anordnungsverwaltung gef\u00fchrt. Benutzer, die ausschlie\u00dflich die Anordnungsfreigabe berechtigt haben, werden nun auch in dieses Men\u00fc gef\u00fchrt. </p> <p>Bei der Anlage von pers\u00f6nlichen Favoriten auf der Startseite, die nicht direkt nebeneinander angeordnet sind, konnte es zu automatischem \"L\u00fcckenschluss\" kommen. Mit diesem Release werden die festgelegten Kacheln an den definierten Orten beibehalten.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#0-global","title":"0 - Global","text":""},{"location":"aktuelles/release-notes/5.2.0.html#013-postausgang","title":"013 - Postausgang","text":"<p>Behoben: Die Anrede im E-Mail-Template des eVersandes wurde zwischenzeitlich nicht korrekt aufgel\u00f6st. Damit die Anrede wieder korrekt eingesetzt wird, ist eine Anpassung des Templates unter Men\u00fcpunkt 1y2 \u201eAusgabeklassen\u201c an der entsprechenden Ausgabeklasse erforderlich. Folgendes Muster steht dabei f\u00fcr die korrekte Anrede zur Verf\u00fcgung: </p><pre><code>{{ if Anrede | object.size &gt; 0 }} {{ originalAnrede = Anrede }} {{ if Anrede == \"Herrn\" }} {{ Anrede = \"Herr\" }} {{ end }} {{ if Anrede == \"Herr\" }} {{ suffix = \"geehrter\" }}{{ else }} {{ suffix = \"geehrte\" }} {{ end }} {{ if AddressLine1 == originalAnrede }} {{ name = AddressLine2 }} {{ else }} {{ if string.starts_with AddressLine1 (originalAnrede + \" \") }} {{ name = string.slice AddressLine1 ((string.index_of AddressLine1 \" \") + 1) }} {{ else }} {{ name = AddressLine1 }} {{ end }} {{ end }}\n\nSehr {{ suffix }} {{ Anrede }} {{ name }},\n\n{{ else }}\n\nSehr geehrte Damen und Herren,\n\n{{ end }}\n\nhiermit erhalten Sie Ihren &lt;strong&gt; xxx &lt;/strong&gt;.\n\nMit freundlichen Gr\u00fc\u00dfen\n</code></pre><p></p> <p>Der eVersand funktoniert nun auch, ohne das man unter dem Men\u00fcpunkt s11 im Reiter \"EPOST\" Daten eintr\u00e4gt. Sollte kein E-Mail Versand vordergr\u00fcndig verwendet werden, dann wird automatisch \"Direktdruck\" als Versandart gew\u00e4hlt.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#022-druckerwarteschlange","title":"022 - Druckerwarteschlange","text":"<p>Neu: Im Men\u00fc 022 \u2013 Druckausgaben werden nun auch bereits ausgef\u00fchrte Drucke eines Benutzers angezeigt. Diese k\u00f6nnen bei Bedarf erneut eingesehen oder erneut ausgegeben werden.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#1-stammdaten","title":"1 - Stammdaten","text":""},{"location":"aktuelles/release-notes/5.2.0.html#1277-mahnstaffel","title":"1277 - Mahnstaffel","text":"<p>Behoben:  Im Men\u00fc 1277 Mahnstaffel ist das Anlegen eines Mahngrades bei der Einnahmeart Verzugszins weder m\u00f6glich. Der Eintrag BUNDESBANKBASISZINS  ist ausw\u00e4hlbar.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#12a3-personenkontenverwaltung","title":"12a3 - Personenkontenverwaltung","text":"<p>Verbesserung:  Im Men\u00fc 12a3 wurde eine neue Spalte \u201eName\u201c integriert. Hier wird die Kombination \u201eNachname, Vorname\u201c visualisiert, auch wenn der Vorname separate in der gleichnamigen Spalte \u201eVorname\u201c hinterlegt ist. Die Spalte \u201eName1\u201c enth\u00e4lt wie bisher die tats\u00e4chlich hinterlegten Eintr\u00e4ge\u201c. Das gleichnamige Auswahlfeld \u201eName1\u201c wirkt genau auf diese Spalte.</p> <p>Behoben: Die Anzeigen von Personenkonten, die als Zahlungspflichtiger angelegt wurden, ist wieder m\u00f6glich. Dementsprechend stehen diese Personenkonten auch als Kontoinhaber zur Auswahl. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#152-einnahmearten","title":"152 - Einnahmearten","text":"<p>Behoben:  Kopieren von Einnahmenarten in der Veranlagung ist wieder m\u00f6glich. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#1y1-textbausteine","title":"1y1 - Textbausteine","text":"<p>Verbesserung:  Die Darstellung der Abst\u00e4nde in den Textbausteinen wurde \u00fcberarbeitet, so dass in den Vorlagen weniger Leerzeilen sichtbar sind. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#2-planung","title":"2 - Planung","text":""},{"location":"aktuelles/release-notes/5.2.0.html#23-budgetzuordnung","title":"23 - Budgetzuordnung","text":"<p>Behoben:  Im Men\u00fc 23 wurde die Deckungskreis-Analyse-Verf\u00fcgbarkeitspr\u00fcfung angepasst. Bei einem Deckungskreis mit unechter Deckung ist nur noch ein SOLL-Konto erforderlich und nicht wie bisher als vermeintlicher Fehler ausgewiesen 2 SOLL Konten.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#262-uplapl","title":"262 - \u00dcPL/APL","text":"<p>Behoben:  Unter bestimmten Konstellationen kam es in verschiedenen Men\u00fcpunkten zu einer Fehlermeldung bei der Auswahl einer Ma\u00dfnahme. \"Die Ma\u00dfnahme ist nicht zul\u00e4ssig bzw. existiert nicht\". Die interne Programmpr\u00fcfung wurde \u00fcberarbeitet, sodass es nicht mehr zu dieser Meldung kommen kann.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#269-mehrfachsperren","title":"269 - Mehrfachsperren","text":"<p>Verbesserung:  Das Setzen von Mehrfachsperren wurde \u00fcberarbeitet. </p> <p>Die Ansicht zur Neuanlage von Sperren wurde dahingehend \u00fcberarbeitet, dass eine Gruppierung nach Budget und Produkt erfolgt. Mit Hilfe einer Mehrfachmarkierung (Klick mit der linken Maustaste + [Strg]) k\u00f6nnen die markierten Buchungsstellen \u00fcbernommen und in der Folge gesperrt werden.</p> <p>Besteht der Wunsch Buchungsstellen nach Budget oder nach Produkt zu sperren, empfiehlt es sich eine entsprechende Einschr\u00e4nkung im Vorfeld vorzunehmen und dann mittels Tastenkombination [Strg] + [A] alle Buchungsstellen zu markieren und dann zu \u00fcbernehmen. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#27-neue-buchungsstelle","title":"27 - Neue Buchungsstelle","text":"<p>Verbesserung Im Men\u00fc 27 wurde im Reiter \"\u00dcbernahme Buchungsstellen Vorjahr\" im Kontextmen\u00fc \"Alle Bst. anlegen\" integriert.</p> <p>Behoben Es ist nun m\u00f6glich, eine Buchungsstelle auch dann anzulegen, wenn die zugeh\u00f6rige Ma\u00dfnahme innerhalb des Haushaltsjahres vor dem 31.12. endet.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#3-buchung","title":"3 - Buchung","text":""},{"location":"aktuelles/release-notes/5.2.0.html#311-einzelbuchung","title":"311 - Einzelbuchung","text":"<p>NEU: Um zu einer ungezielten Zahlungen direkt bei der Erfassung eine Buchungsstelle zuordnen zu k\u00f6nnen, steht im Panel \"Kontierung\" am Feld \"OP-Buchungsstelle\" eine Funktion mit dem Buchstaben \"E\" zur Verf\u00fcgung. Mit dem Aufruf dieser Funktion werden die Einnahmearten aufgerufen und eine Einnahmeart kann gew\u00e4hlt werden.  Die Buchungsstelle dieser Einnahmeart wird dann als Information f\u00fcr den OP mitgef\u00fchrt; so wie die bekannte Funktion in SASKIA.de-IFR. </p> <p>Verbesserung:  Bei erneuter Belegerfassung in der Einzelbuchungsmaske wird der Buchungskreis, der in der vorherigen Buchung verwendet wurde wieder angezeigt. Hier erfolgt kein R\u00fccksetzen mehr; damit ist ein benutzerbezogenes Speichern ab sofort wieder m\u00f6glich. </p> <p>Die an verschiedenen Funktionen (Men\u00fc 51, 52, 311) gekoppelte Verf\u00fcgbarkeitspr\u00fcfung wurde bei Produktsachkonten mit und ohne Deckungskreis \u00fcberarbeitet. In Verbindung mit Schalter F62 = Ja (keine Automatische \u00dcberbuchung bei Deckungskreis ohne Best\u00e4tigung) wird bei Produktsachkonten mit Deckungskreis wieder  die Abfrage-Option \u201eBudgetumbuchung\u2026\u201c aktiviert. Daneben besteht weiterhin die M\u00f6glichkeit die konkrete Buchungsstelle im Deckungskreis zu \u00fcberbuchen, sofern die Gesamtverf\u00fcgbarkeit des Deckungskreises gegeben ist. Die nachfolgende Budgetumbuchungsmaske ber\u00fccksichtigt die Eigenschaften (Budget und Deckungskreis) der zu Grunde liegenden Buchung.</p> <p>In der Einzelbuchungsmaske wird bei der Konstellation Produkt - Steuerart 1 und Sachkonto Steuerart 1 nun zwingend ein Wert im Steuerkennzeichen gefordert. Der Vorgang muss somit als \"nicht steuerbar\" oder mit Steuerkennzeichen bewertet werden.</p> <p>Behoben:  Bei der Erfassung einer negativen Sollstellung konnte es vorkommen, das das System die Zahlungsbuchung ebenfalls mit negativem Vorzeichen gebucht hat und damit kein Ausgleich stattgefunden hat. </p> <p>Dies wurde nun behoben, so dass negative Sollstellung mit einer Gegenbuchung als Zahlungsbuchung und ohne negatives Vorzeichen ausgeglichen werden.</p> <p>Sol der Ausgleich \u00fcber den umgekehrten Buchungssatz erfolgen, ist die entsprechende Funktion in der Einzelbuchungsmaske zu verwenden und auf das Vorzeichen im Buchungsbetrag zu achten. </p> <p>In der Einzelbuchungsmaske Men\u00fc 311 wurden die Verwendung von abweichenden Bankverbindungen optimiert. Grunds\u00e4tzlich wird jetzt wie auch im Men\u00fc52  eine bewusst abweichend  ausgew\u00e4hlte IBAN f\u00fcr die erzeugte Buchung verwendet. W\u00e4hlt man zuerst eine BV am Kreditor, und danach einen OP mit anderen BV, so wird die BV des OP verwendet.  W\u00e4hlt man nach dem OP nochmals die BV am Kreditor aus, so wird diese, vom OP evtl. abw. BV, verwendet. Bei  Buchungsschl\u00fcssel 733 wurde das Verhalten gegen\u00fcber dem IFR angepasst . Dort wurde beim \u00dcbernehmen immer die Standard-BV verwendet. Jetzt wird die ggf. abweichend ausgew\u00e4hlte BV verwendet.</p> <p>Bei Buchungen mit Buchungsschl\u00fcssel 511 kam es bei Mehrfachauswahl zu dem Problem, dass ein Zahlweg verlangt wurde. Dies wurde behoben. </p> <p>Wird eine Buchung mit Buchungsschl\u00fcssel 421 oder 521 get\u00e4tigt und dabei ein bestehender OP als Buchungsvorlage verwendet, so wird nun auch die eventuelle \u00c4nderung der Forderungs- oder Verbindlichkeitskontos ber\u00fccksichtigt. </p> <p>Wenn die Einstellung \"Periode lt. F\u00e4lligkeit\" im Folgejahr eines Sachkontos nicht eingetragen war, konnte diese Funktion bei Ratenbuchungen nict verwendet werden. Dies wurde dahingehend angepasst, dass die Einstellung am Sachkonto im Haushaltsjahr gem\u00e4\u00df Belegdatum gepr\u00fcft wird.  </p> <p>Bei der Verwendung von Kundennummern am Kreditor wurden je nach Konstellation entweder keine Kundennummern auf der Anordnung gedruckt oder die Standard-Kundennummer, aber nicht die der Buchung zugeordneten Kundennummer. Mit Release 5.2.0 funktioniert die Verwendung der Kundennummern nun wieder wie gewohnt. </p> <p>Bei der Angabe einer LUSI-Listen Nummer als OP-Nummer in den Buchungsschl\u00fcsseln 231 und 331 wird keine Kontierung mehr vorgegeben. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#32-tagesabschluss","title":"32 - Tagesabschluss","text":"<p>Verbesserung: In letzter Zeit gab es vermehrt R\u00fcckfragen zur Anzeige der Einzelbestandteile von Schwebeposten in der Gesamt\u00fcbersicht. Grunds\u00e4tzlich gilt: Die Einzelbestandteile sind weiterhin verf\u00fcgbar, jedoch wurde die Standard-Einstellung der Checkbox \u201eNur offene Schwebeposten\u201c in SASKIA.H2R auf aktiv gesetzt (im Gegensatz zur bisherigen inaktiven Voreinstellung in SASKIA.de-IFR).</p> <p>Wichtig:</p> <ul> <li>Um alle Einzelbestandteile eines Schwebepostens anzuzeigen, muss die Checkbox deaktiviert werden.</li> <li>Der gew\u00fcnschte Schwebeposten ist anschlie\u00dfend zu markieren \u2013 durch einen Doppelklick l\u00e4sst sich die Detailanzeige aufklappen.</li> </ul>"},{"location":"aktuelles/release-notes/5.2.0.html#33-buchungsstapel","title":"33 - Buchungsstapel","text":"<p>Behoben:  Die bisher zweizeilige Darstellung der Buchungss\u00e4tze wurde auf eine einzeilige Ansicht pro Buchungssatz umgestellt. Diese Anpassung behebt mehrere gemeldete Darstellungsprobleme und bringt deutliche Vorteile in der Handhabung:</p> <ul> <li>Optimierte Nutzung der Tastenkombination STRG + Ende</li> <li>Statusangaben (z.\u202fB. verbuchbar, fehlerhaft) werden nun geb\u00fcndelt in einer Spalte angezeigt</li> <li>Schnelleres Laden und fl\u00fcssigere Anzeige der Buchungsstapel \u2013 inkl. visualisierter Fortschrittsanzeige</li> <li>Verbesserte Filterfunktionen in den Spalten</li> <li>Optimierte Sortierung der Daten</li> </ul> <p>Ausblick: Mit dem kommenden Release 5.3.0 wird zus\u00e4tzlich die Spaltenfixierung eingef\u00fchrt. Damit lassen sich individuell angepasste Spaltenanordnungen um eine weitere n\u00fctzliche Funktion erweitern.</p> <p>Bei der Erfassung von Soll-Ist-Buchungen ist es wieder m\u00f6glich die Zahlungsbuchung zu bearbeiten. Zu beachten ist dabei, dass eine Bearbeitung ausschlie\u00dflich m\u00f6glich ist, wenn kein Anordnungsdruck vollzogen wurde.  Nach erfolgtem Anordnungsdruck steht die Bearbeitungsfunktion nicht mehr zur Verf\u00fcgung. Hierf\u00fcr ist eine Stornierung durchzuf\u00fchren. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#35x-schnittstellen-3521-einlesen-3522-varbeiten","title":"35x - Schnittstellen (3521 - Einlesen / 3522 - Varbeiten)","text":"<p>Verbesserung: In der Standard-Schnittstelle (V4.x) werden zuk\u00fcnftig folgende Parameter zur Verf\u00fcgung gestellt: Adress-/Zusatz-/Mandant-/DMS-/RAP-Operations-Parameter. Damit ist es m\u00f6glich die entsprechenden Bereiche innerhalb der Schnittstellenstruktur zu aktivieren bzw. zu deaktivieren, wenn das externe System diese nicht mitliefern kann.</p> <p>Im Men\u00fc 3521 / 3522 kann der Block \u201eParameter\u201c nun in der Breite flexibel angepasst werden \u2013 einfach durch Ziehen mit der Maus am Parameter-Block.</p> <p>Behoben: Im Men\u00fc 3521 / 3522 wurde die Darstellung der einzelnen Schnittstellen-Datens\u00e4tze innerhalb der Funktion \u201eStapel bearbeiten\u201c optimiert.</p> <ul> <li>Die Anzeige wurde \u00fcberarbeitet, sodass keine Darstellungsfehler (z.\u202fB. L\u00fccken oder Verschiebungen) mehr auftreten sollten.</li> <li>Zudem wurde der bekannte Modus \u201eSuchen / Ersetzen\u201c integriert, der eine gezielte Anpassung von Spaltenwerten direkt in der Bearbeitungsmaske erm\u00f6glicht.</li> </ul> <p>\u201eAVVISO_AO\u201c-Schnittstelle (Eingang) | Bei der Funktion \u201eStapelverarbeitung\u201c kam es bei der Verarbeitung mehrerer Schnittstellendateien zu einem Fehler, durch den enthaltene Buchungss\u00e4tze f\u00e4lschlicherweise aufsummiert und dadurch Mehrfachbuchungen erzeugt wurden. Die Buchungss\u00e4tze werden nun korrekt verarbeitet, ohne dass es zu doppelten Buchungen kommt.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#36-anordnung","title":"36 - Anordnung","text":"<p>Behoben: Beim Abweisen einer Anordnung im Men\u00fc 36 wird jetzt die Druckjob-Fortschrittsanzeige eingeblendet, damit erkennbar ist, dass eine Anordnung mit dem Titel \"AO-L\u00f6schung ohne Buchung\" erzeugt wird.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#391-personenkonten","title":"391 - Personenkonten","text":"<p>Verbesserung:  Eine zus\u00e4tzliche Spalte \u201eVollstreckung\u201c wurde erg\u00e4nzt. Bei erfolgter avviso-\u00dcbergabe wird dort analog zu den Spalten \u201eNiederschlagung\u201c, \u201eAdV\u201c etc. ein Haken gesetzt.</p> <p>Die Datumsangaben in den Feldern \"Buchungsdatum\" und \"Belegdatum\" wurden angepasst, so dass nur noch Datumswerte erkennbar sind; die Uhrzeitangabe mit 0:00:00 ist entfallen. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#392-sachkonten","title":"392 - Sachkonten","text":"<p>Behoben:  Im Register \"Verf\u00fcgbarkeit\" stehen nun wieder die Auswahlboxen zur differenzierten Anzeige von FR-Konten und / oder Ergebis- und Bilanzkonten zur Verf\u00fcgung. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#394-budgetubersicht","title":"394 - Budget\u00fcbersicht","text":"<p>Behoben:  \u00d6ffnet man in der Budget\u00fcbersicht die weiterf\u00fchrende Ansicht zum Aufruf der Journalbuchungen, so stehen in der Tabelle jetzt auch wieder die Steuerperiode und das Steuerkennzeichen zur Ansicht zur Verf\u00fcgung. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#3a2-kontoauszugsabgleich","title":"3a2 - Kontoauszugsabgleich","text":"<p>Verbesserung:  Im Men\u00fc 3a2 wurde im manuellen Abgleich die OP-Summenanzeige reaktiviert analog der Darstellung im Men\u00fc 391 Reiter OP's.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#3a3-kontoauszugsverbuchung","title":"3a3 - Kontoauszugsverbuchung","text":"<p>Behoben:  Beim Versuch des  Verbuchens eines Kontoauszuges im Men\u00fc 3a3 wird eine m\u00f6gliche Sperre durch einen anderen Nutzer namentlich angezeigt</p>"},{"location":"aktuelles/release-notes/5.2.0.html#3b1-verwahrguter","title":"3b1 - Verwahrg\u00fcter","text":"<p>Verbesserung:  Im Men\u00fc 3b1 Verwahrgelass wurde ein neuer DMS-Dokumententyp \u201eVerwahrgelassBeleg\u201c integriert. Um Dokumente hinterlegen zu k\u00f6nnen ist es zun\u00e4chst notwendig ein sog. \u201eErst-oder Ur-\u201cBeleg zu erzeugen, also ein Druck der \u201eEinlieferungs-Anordnung\u201c.  An diesen Erstbeleg k\u00f6nnen dann beliebig viele Zusatzdokumente als Dokumentation der \u201eVerwahrungen\u201c angef\u00fcgt werden. Um diesen neuen DMS-Dokumententypen bei Ihnen zu konfigurieren sprechen Sie uns bitte an.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":""},{"location":"aktuelles/release-notes/5.2.0.html#421-stundung","title":"421 - Stundung","text":"<p>Behoben:  Im Men\u00fc 421 Stundung wurde der Rateneditor \u00fcberarbeitet. Ein m\u00f6gliche Dauerschleife tritt nicht mehr auf.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":""},{"location":"aktuelles/release-notes/5.2.0.html#52-eingangsrechnungsjournal","title":"52 - Eingangsrechnungsjournal","text":"<p>NEU:  Im Men\u00fc 52 Eingangsrechnungsjournal wurde an den jeweils erfassten Eingangsrechnungs-Positionen ein E-Mail Button integriert. Damit ist es m\u00f6glich direkt aus der ER-Position heraus eine interne E-Mail zu erzeugen.</p> <p>Verbesserung:  Eine Stornierung von Eingangsrechnungen unter Verwendung eines Auftrags ist wieder m\u00f6glich. </p> <p>Bei Rechnungserfassung mit DMS-Abfrage, wird nun das Rechnungs-PDF in einer Child-Session ge\u00f6ffnet. Diese kann ge\u00f6ffnet bleiben und wird aktualisiert sobald eine neue Rechnung erfasst wird. Die Child-Session der Rechnungserfassung  l\u00e4uft asynchron zur Child-Session der normalen DMS-Anzeige. </p> <p>Beim Anlegen einer neuen Eingangsrechnung mittels eines DMS-Abrufs werden individuell angeordnete Spalten im DMS-Abruf Fenster jetzt nutzerspezifisch gespeichert, sodass die individuell definierten \u201ewichtigen\u201c Spalten im vorderen Bereich angeordnet werden k\u00f6nnen. Dieses DMS-Abruf-Fenster ist ein sehr dynamisches Fenster, da es rein auf den vom DMS-Systemen ungeordnet gelieferten META-Angaben basiert. </p> <p>Behoben:  Wird im Eingangsrechnungsjournal bei einem Sachkonto mit Steuerart 1 KEIN Steuerkennzeichen hinterlegt, so erscheint eine Fehlermeldung, dass das Steuerkennzeichen auszuw\u00e4hlen ist (oder \"nicht steuerbar\" hinterlegt werden muss).</p> <p>Das Einlesen von ZUGFeRD Rechnungen mit Steueranteil wurde \u00fcberarbeitet. Es werden mit \u00dcbernahme aus dem DMS nun keine Steuerkennzeichen vorbelegt oder aus der Rechnung interpretiert. Die Betr\u00e4ge werden nun korrekt in der Eingangsrechnungserfassung dargestellt.</p> <p>Eingangsrechnungen k\u00f6nnen unter Zuhilfenahme von vollst\u00e4ndigen und unvollst\u00e4ndigen Verteilungsringen wieder angelegt und gebucht werden. </p> <p>Im Eingangsrechnungsjournal Men\u00fc 52 wurde das nutzerspezifische Speichern der Status-Filter \u00fcberarbeitet. Der letzte Zustand wird jetzt beim Schlie\u00dfen des Men\u00fcpunktes oder des Programms gespeichert und sollte beim erneuten \u00d6ffnen genauso wieder vorhanden sein.</p> <p>Die Eingabe des Produktes funktioniert wieder problemlos. </p> <p>Bei der Verwendung von Vorjahresmitteln im Rahmen des Eingangsrechnungsjournals unter Angabe eines Auftrags wird nun der korrekte Buchungsschl\u00fcssel \"513\" wieder angezeigt.</p> <p>Im Eingangsrechnungsjournal wird wieder eine automatische Benachrichtigungs-E-Mail versendet , sofern das Gruppenrecht \u201eERJ Email Benachrichtigung\u201c konfiguriert ist. Des Weiteren wurde eine manuelle interne E-Mail Funktion an der ER-Position integriert, sodass auch z.B. gezielt Nachfragen zu bestimmten ER-Postionen an interne Nutzer gestellt werden k\u00f6nnen direkt aus dem ERJ heraus.</p> <p>Ab Release 5.2.0 hat eine Eingangsrechnung mehrere Positionen mit nicht ausreichender Verf\u00fcgbarkeit, so werden nun beim \"Buchen\" alle Budgetanpassungen direkt nacheinander abgefragt und nach erfolgreicher Anpassung die Checkbox \"A\" gef\u00fcllt (AO Best\u00e4tigung ist erforderlich- n\u00e4chster Schritt). Diese Vorg\u00e4nge geschehen nun ohne mehrmaliges bet\u00e4tigen des Buttons \"Buchen\".</p> <p>Im Men\u00fc 52 Eingangsrechnungsjournal wurde die Problem-Thematik \"Object Referenz not set to an instance\" behoben. Der Fehler trat im Zusammenhang mit der Verwendung von Auftr\u00e4gen auf, wo der Rechnungspositionsbetrag = dem Restauftragswert entsprach, also der Auftrag einen Schlussabruf bekommen w\u00fcrde. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#54-ausgangsrechnungsjournal","title":"54 - Ausgangsrechnungsjournal","text":"<p>Behoben:  Das Erstellen von Musterrechnungen ist wieder m\u00f6glich. </p> <p>Ist der Reporttextbaustein 3 \u2013 \u201eunterer Bescheidtext\u201c leer, erfolgt kein automatischer Seitenwechsel mehr.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#55-stammdaten-ausgangsrechnungsjournal","title":"55 - Stammdaten Ausgangsrechnungsjournal","text":"<p>Behoben: </p> <ul> <li>Die Tabreihenfolge bei der Neuanlage von Tarifgruppen und Tarifen wurde \u00fcberarbeitet.</li> <li>Bei der Zuordnung von Tarifgruppen oder Tarifen schlie\u00dft sich das Feld nicht mehr, wenn man auf die n\u00e4chste Seite bl\u00e4ttert. </li> </ul>"},{"location":"aktuelles/release-notes/5.2.0.html#6-auswertungen","title":"6 - Auswertungen","text":""},{"location":"aktuelles/release-notes/5.2.0.html#623-summen-und-saldenliste","title":"623 - Summen- und Saldenliste","text":"<p>Behoben:  Die Maske zur Filterung einer OP-Liste auf Basis von Personenkonten wurde \u00fcberarbeitet und kann nun wieder problemlos verwendet werden. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#661x-vorschlagslisten","title":"661x - Vorschlagslisten","text":"<p>Verbesserung:  In den \"Vorschlagsmen\u00fcpunkten\" (u.a. Lastschrift-, Gutschrift-, Zahlungs- und Mahnungsvorschlag) wurde die Darstellung der jeweiligen Datens\u00e4tze von mehrzeilig auf einzeilig umgestellt. Damit konnten verschiedenste gemeldete Effekte behoben werden.  Diese neue Darstellung gew\u00e4hrleistet eine neue Form der \u00dcbersichtlichtkeit. Dies betrifft u.a. die Verwendung der Spaltenfilter, die Sortierf\u00e4higkeit der Spalten und auch das Verhalten von bestimmten editierbaren Zellen, in denen jetzt auch ein Suchen und Ersetzen m\u00f6glich ist.  </p>"},{"location":"aktuelles/release-notes/5.2.0.html#6614-mahnvorschlag","title":"6614 - Mahnvorschlag","text":"<p>Verbesserung:  Im Men\u00fc 6614 Mahnvorschlag wurde die Funktion \"NF Neu\" reaktiviert.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#6618-vorankundigung-lastschrift","title":"6618 - Vorank\u00fcndigung Lastschrift","text":"<p>Behoben:  Die Sepavorank\u00fcndigung druckte unter bestimmten Umst\u00e4nden ein falsches Mandat.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#663-op-listen-stichtag","title":"663 - OP-Listen Stichtag","text":"<p>Behoben: Der Druck der OP-Stichtagsliste ist wieder ohne Einschr\u00e4nkungen m\u00f6glich. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#672-meldung","title":"672 - Meldung","text":"<p>Behoben:  Ist keine ELSTER-ERiC-Schnittstelle f\u00fcr die Umsatzsteuer aktiv, so k\u00f6nnen nun auch wieder die Umsatzsteuervoranmeldung und die Umsatzsteuerjahresmeldung als versendet markiert werden.  In diesem Fall erscheint in den beiden genannten Registerlaschen im Men\u00fcpunkt 672 - \"Meldungen\" eine Funktion mit Briefkastensymbol. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#674-buchung-abziehbare-vorsteuer","title":"674 - Buchung abziehbare Vorsteuer","text":"<p>Behoben:  Befindet sich in einem Deckungskreis ein Quellkonto und dieses wurde mit nicht abziehbarer Vorsteuer gebucht, hat die Buchung des nicht abziehbaren Anteils bisher zu einer Automatiksperre gef\u00fchrt. Dies wurde nun behoben und die Verf\u00fcgbarkeit wird entsprechend korrigiert. </p> <p>Bisher gebuchte Werte in vorhandenen Buchungsl\u00e4ufen der nicht abziehbaren Vorsteuer werden nun korrekt ber\u00fccksichtigt, auch wenn in vergangenen Buchungsl\u00e4ufen auf Periode(n) und/oder Produkt(e) eingeschr\u00e4nkt wurde. Ein neuer Buchungslauf zur nicht abziehbaren Vorsteuer \u00fcber alle Produkte und Perioden (Ohne Einschr\u00e4nkungen) bringt nun ggf. Korrekturen, die noch zu buchen sind. Jeder weitere direkt danach erstellete Buchungslauf sollte die zu buchenden Werte 0,00 haben (wenn zwischenzeitlich KEINE neuen Steuerkennzeichen mit dem Merkmal \"nicht abziehbar\" gebucht wurden). Hinweis: Grunds\u00e4tzlich ist die Herstellerempfehlung OHNE Einschr\u00e4nkungen zu arbeiten. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#68-freie-auswertungen","title":"68 - Freie Auswertungen","text":"<p>Neu: Im H2R stehen ab sofort zwei neue freie Auswertungen zur Verf\u00fcgung, die der Abstimmung mit dem Bestand im Bereich Grundsteuer dienen. Die Auswertungen:</p> <ul> <li>FQ7770 \u2013 Suche abweichende Veranlagungen Grundsteuer</li> <li>FQ7780 \u2013 Veranlagungen ohne Zuordnung zum Messbetragsverzeichnis (MBV) sind im Men\u00fc 68 \u2013 Veranlagung Grundsteuer verf\u00fcgbar und unterst\u00fctzen bei der gezielten Identifikation und Nachverfolgung von Abweichungen bzw. fehlenden Zuordnungen.</li> </ul>"},{"location":"aktuelles/release-notes/5.2.0.html#69-auswertungszentrale","title":"69 - Auswertungszentrale","text":"<p>Neu:  Im Men\u00fc 69 wurde beim Teilfinanzhaushalt B eine neue Druckvorlage \u201eZusammenfassung der investiven Ma\u00dfnahmen\u201c (Report FR_60082_InvestiveMa\u00dfnahmen.mrt) erg\u00e4nzt.  Die Liste bringt eine komprimierte Auflistung aller investiven Ma\u00dfnahmen der Kontenklassen 68 und 78. Dazu wurden in der Listenpositionsverwaltung im Schattenmandanten f\u00fcr die Bundesl\u00e4nder (Sachsen, Sachsen-Anhalt und Brandenburg) jeweils eine entsprechende Finanz-Liste hinterlegt. Die Liste hat 3 Positionen:</p> Listen-Nr./ Position Gliederung Bezeichnung Information Pos.-Art Kontenbereich 102 Zusammenfassung der investiven Ma\u00dfnahmen nach Teilhaushalten 10 E Einzahlungen E 68% 20 A Auszahlungen A 75% 30 G Summe G <p>Sachsen Finanz-Liste 13 Sachsen-Anhalt Finanz-Liste 14 Brandenburg Finanz-Liste 10  </p> <p>Verbesserung:  Die Berichte \"Sachkontenauszug\", \"Produkte, Budgets!, \"Erlass-Auswertung\" und \"Planvariantenvergleich wurden multiselektionsf\u00e4hig gemacht.  Das bedeutet, dass in all den genannten Auswertungen in den Feldern \"Produkt\", \"Sachkonto\" und \"Ma\u00dfnahme\" mehrere Eintragungen von Hand erfolgen k\u00f6nnen und das Programm ber\u00fccksichtigt die getroffene Mehrfachauswahl in der gew\u00fcnschten Auswertung.</p> <p>Behoben Die Einschr\u00e4nkungen innerhalb des Sachkontoauszuges bezogen auf eine Ma\u00dfnahme, nachdem ein Produkt ausgew\u00e4hlt wurde, werden vom Programm wieder ber\u00fccksichtigt.  Auch der Druck selbst reagiert nun wieder auf die Einschr\u00e4nkungen und druckt nur gem\u00e4\u00df der Vorauswahl die Sachkontenbl\u00e4tter. </p> <p>In einigen Planungs- und Jahresrechnungslisten gab es teilweise ein falsche Darstellung der ausgewiesenen Werte hinsichtlich der Formatierung der Dezimalstellen. Dies wurde angepasst. Spalten mit einem eindeutigen Planwert sind generell ganzzahlig. Alle anderen Spalten, wo u.a auch Budgetumbuchungen, Buchungswerte usw. ausgewiesen werden, sind als Dezimalzahl formatiert.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#7-jahresabschluss","title":"7 - Jahresabschluss","text":""},{"location":"aktuelles/release-notes/5.2.0.html#74-endgultiger-abschluss","title":"74 - Endg\u00fcltiger Abschluss","text":"<p>Behoben:  Die Pr\u00fcfungen im Rahmen des endg\u00fcltigen Jahresabschlusses erfolgen nun wieder wie gewohnt. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#8-veranlagung","title":"8 - Veranlagung","text":""},{"location":"aktuelles/release-notes/5.2.0.html#81-einzelveranlagung","title":"81 - Einzelveranlagung","text":"<p>Verbesserung:  Die Bescheidart ist nun im Bereich der Sonderkorrektur editierbar. Diese Anpassung stellt sicher, dass bei der Anlage von Erstbescheiden die Ermittlung der Bescheid\u00fcberschrift innerhalb der Textbausteine zuverl\u00e4ssig erfolgt.</p> <p>Behoben:  Die Anzeige objektbeschreibender Informationen stellt nun zuverl\u00e4ssig die im Men\u00fc 152 \u2013 Einnahmearten hinterlegten Informationen dar. Bei der Verwendung von Unterobjekten werden ausschlie\u00dflich die Informationen angezeigt, die dem jeweiligen Hauptobjekt zugeordnet sind.</p> <p>Im Reiter 5.2 \u2013 Saldo und Buchungen wird das Buchungsjournal ab sofort wieder angezeigt.</p> <p>Im Bereich Grundsteuer wurde ein Problem behoben, bei dem die Auswahl des Steuerjahres im Reiter \u201eHistorik\u201c zum Einfrieren des Programms f\u00fchrte. Die Auswahl und somit die Auskunft \u00fcber ein Steuerjahr ist nun wieder m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#841-aufkommen","title":"841 - Aufkommen","text":"<p>Behoben:  Im Men\u00fc 841 wurde die \"doppelte\" Zeile \"Gesamtsumnme\"  entfernt, sodass die Gesamtsummenbildung nun korrekt funktioniert.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#861-gewerbesteuer-meldungen","title":"861 - Gewerbesteuer-Meldungen","text":"<p>Verbesserung: In der Gewerbesteuer-Schnittstelle wurden folgende Schl\u00fcssel erg\u00e4nzt:</p> <ul> <li>0106600930000000000000000: Betriebsende liegt im Erhebungszeitraum   Sofern das Betriebsende im Erhebungszeitraum liegt, wird der Schl\u00fcssel mit Wert \u201e1\u201c geliefert.</li> <li>0106700550000000000000000: Versp\u00e4tungszuschlag in \u20ac   Der Schl\u00fcssel wird anstelle des Schl\u00fcssels 0106600550000000000000000 geliefert.    Der Schl\u00fcssel stellt den der Gemeinde zugewiesenen Versp\u00e4tungszuschlag in \u20ac dar. </li> <li>0106501670000000000000000 bis 2040 Vorauszahlungen lediglich f\u00fcr Jahr JJJJ wegen Einstellung des Betriebs</li> <li>0106601670000000000000000 bis 2040 Vorauszahlungen lediglich f\u00fcr Jahr JJJJ wegen Einstellung des Betriebs</li> </ul>"},{"location":"aktuelles/release-notes/5.2.0.html#862-grundsteuer-meldungen","title":"862 - Grundsteuer-Meldungen","text":"<p>Neu: Die zwei neuen Datentypen ( GMBAX,GMBVX) k\u00f6nnen \u00fcber das H2R eingelesen und verarbeitet werden. Ggfs. m\u00fcssen diese beim Finanzamt noch beantragt und im ELSTER-Transfer als Datenabholung eingerichtet werden. Im H2R ist beim Einlesen der Schnittstellen zu beachten, dass ELSTER-Transfer einen separaten Dateiordner f\u00fcr die GMBAX/ GMBVX-Meldungen erstellt. Dies muss beim Einlesen der Schnittstellen im H2R ber\u00fccksichtigt werden.</p> <p>Bei den GMBVX-Meldungen (Grundsteuermessbetragsverzeichnis) werden Abweichungen im Men\u00fc 862 als zu kl\u00e4rende Meldungen angezeigt, Meldungen ohne Differenzen zum H2R, werden auf bescheidunwirksam gesetzt.</p> <p>Verbesserung:  Bei der Kopie des Aktenzeichens im Men\u00fc 862 \u00fcber die Tastenkombination Strg\u202f+\u202fC werden nun keine Leerzeichen mehr mitkopiert. Dies erm\u00f6glicht eine direkte Suche nach dem kopierten Aktenzeichen im Men\u00fc 81, ohne dass eine manuelle Nachbearbeitung erforderlich ist.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#9-barkasse","title":"9 - Barkasse","text":""},{"location":"aktuelles/release-notes/5.2.0.html#92-einnahme-und-ausgabe-kasse","title":"92 - Einnahme und Ausgabe Kasse","text":"<p>Behoben:  Ein Fehler wurde behoben, bei dem es durch das Erfassen und anschlie\u00dfende Streichen einzelner Belege zu einem negativen Bestand in der Barkasse kommen konnte. Infolgedessen konnte der Z-Bon nicht erstellt werden, da eine Pr\u00fcfung den Hinweis ausgab, dass der Bestand unter 0 liegt. Diese Pr\u00fcfung wird nun ignoriert, sofern die Barkasse zum Zeitpunkt der Erstellung des Z-Bons wieder einen positiven Bestand aufweist. Zudem wird ein neu erstellter Z-Bon nun sofort nach der Erstellung angezeigt.</p> <p>Die Verbuchung von Barkassenvorg\u00e4ngen f\u00fcr Soll-Ist Buchungen (BS 421 und 424) wurde korrigiert. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":""},{"location":"aktuelles/release-notes/5.2.0.html#b11-anlagegut-bearbeiten","title":"b11 \u2013 Anlagegut bearbeiten","text":"<p>Behoben:  Beim Abspeichern eines Anlagegutes kam es zu einem Datenbankfehler, wenn zuvor eine Rechnung mit leerem Steuerbetrag aus \u201eER+\u201c \u00fcbernommen wurde.</p>"},{"location":"aktuelles/release-notes/5.2.0.html#b17-assistent-vorsteuer","title":"b17 - Assistent Vorsteuer","text":"<p>NEU:  Aufgrund der Anpassung des Vorsteuerassistenten zur Ber\u00fccksichtigung des \u00a744 UStDV im Rahmen der Vorsteuerberichtigung nach \u00a7 15a UStG wurden auch die Auswertungen \"Einzeldruck\" pro Anlagegut und \"Gesamtdruck\" \u00fcber alle Anlageg\u00fcter erweitert.  Die Bewertungsgrundlage zur Ermittlung der Betr\u00e4ge bei \u00c4nderung der Quote und des Vorsteuerberichtigungsbetrags werden nun auch in den Auswertungen dokumentiert. Am Anlagegut sind daf\u00fcr hochgestellte Zahlen verwendet wurden, die in einer Legende am Ende der Auswertung erl\u00e4utert werden. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#b21-bearbeiten","title":"b21 - Bearbeiten","text":"<p>Behoben: Bei gr\u00f6\u00dferen Zoom-Stufen bestand das Problem, dass man den rechten Teil der Tabelle nicht durch scrollen erreichen konnte. Mit diesem Release ist die Scrollbar wieder sichtbar und kann bedient werden. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#f-steuerbewertung","title":"f - Steuerbewertung","text":""},{"location":"aktuelles/release-notes/5.2.0.html#f1-steuerkompass","title":"f1 - Steuerkompass","text":"<p>NEU:</p> Im Steuerkompass wurden neue Subkategorien auf Kundennachfrage eingef\u00fcgt: 1. \u00dcberlassung von Fl\u00e4chen und Geb\u00e4uden/ sonstige dingliche Rechte/ Gestattungsvertrag 2. Leistungs- und Lieferbeziehungen/ innere Verwaltung/Sponsoring 3. Leistungs- und Lieferbeziehungen/ innere Verwaltung/Kreditgesch\u00e4fte 4. Leistungs- und Lieferbeziehungen/ Kinder-, Jugend- und Familie/Schulessen 5. Leistungs- und Lieferbeziehungen/ Kinder-, Jugend- und Familie/Schulkiosk-, Snackautomat"},{"location":"aktuelles/release-notes/5.2.0.html#s-system","title":"s - System","text":""},{"location":"aktuelles/release-notes/5.2.0.html#s21-benutzerverwaltung","title":"s21 - Benutzerverwaltung","text":"<p>Verbesserung: Im Men\u00fc s21, Reiter Druck, wurde eine Tabelle integriert, die die bisherige Druckfunktionalit\u00e4t erweitert. Diese Erg\u00e4nzung erm\u00f6glicht eine verbesserte Nachverfolgung und Kontrolle des jeweils umgesetzten Rechterollen-Konzepts. Als Einstieg in die Auswertung k\u00f6nnen weiterhin die Filter Gruppe und/oder Nutzer verwendet werden. Die vollst\u00e4ndige Datenaufbereitung bei einer Nutzeranzahl von ca. 500 aktiven Personen nimmt etwa zwei Minuten in Anspruch. Bei einer geringeren Anzahl erfolgt die Anzeige entsprechend schneller. Die Tabelle bietet zus\u00e4tzlich erweiterte Funktionalit\u00e4ten, wie beispielsweise die Gruppierung nach beliebigen Spalten.</p> <p>Beispielanwendung \u2013 \u00dcbersicht aller Nutzer mit zugeordneten Budgets:</p> <ol> <li>Im Auswahlfeld Gruppe: \u201ealle Nutzer\u201c ausw\u00e4hlen und Maske aktualisieren</li> <li>Gruppierung nach der Spalte \"Nutzer\"</li> <li>Filter in der Spalte \"Recht\" auf den Wert \u201eBudget\u201c setzen</li> <li>In der Spalte \"Rechtewerte\" werden die entsprechenden Rechte je Nutzer angezeigt</li> </ol> <p>Behoben:  Im Men\u00fc s21 wurde die Darstellung der Eingabefelder optimiert damit die jeweiligen Feldgr\u00f6\u00dfen auch den kompletten eingegebenen Inhalt darstellen, u.a. Feld Postleitzahl. </p>"},{"location":"aktuelles/release-notes/5.2.0.html#s42-wartungsoperationen","title":"s42 - Wartungsoperationen","text":"<p>Verbesserung:  Umlaute in den Wartungsskripten werden wieder lesbar dargestellt.</p>"},{"location":"aktuelles/release-notes/5.2.1.html","title":"Release Notes 5.2.1","text":"<p>Ver\u00f6ffentlichungsdatum des Updates: 15.05.2025</p>"},{"location":"aktuelles/release-notes/5.2.1.html#1-stammdaten","title":"1 - Stammdaten","text":""},{"location":"aktuelles/release-notes/5.2.1.html#1273-steuerkennzeichen","title":"1273 - Steuerkennzeichen","text":"<p>Behoben: 25.05.084 | Die Eintragung eines \"nicht f\u00e4llig\"- Kontos in einem Steuerkennzeichen, auf dem bereits eine Ist-versteuerte Buchung statt gefunden hat, f\u00fchrt nun wieder zum erfolgreichen Umbuchen vom f\u00e4lligen auf das nicht f\u00e4llige Steuerkonto.</p>"},{"location":"aktuelles/release-notes/5.2.1.html#12a1-adressstammdaten","title":"12a1 - Adressstammdaten","text":"<p>Behoben: 25.05.074 | Im Reiter \"4 Adress-Nr. Sperren\" wurden alphanumerische Adressnummern nicht angezeigt und konnten auch nicht neu angelegt werden.</p>"},{"location":"aktuelles/release-notes/5.2.1.html#3-buchung","title":"3 - Buchung","text":""},{"location":"aktuelles/release-notes/5.2.1.html#311-einzelbuchung","title":"311 - Einzelbuchung","text":"<p>Behoben: 25.05.076 | Bei Buchung einer Zahlung mithilfe eines Barkassen-Zahlwegs wird die Kontierung gem\u00e4\u00df Gruppenschl\u00fcssel wieder dargestellt. </p> <p>25.05.081 | Das Programm reagiert wieder auf die Schaltereinstellung F03, sowohl bei Ist-, als auch bei Sollversteuerung.</p> <p>25.05.082 | Bei Nutzung der Buchungsvorlage und anschlie\u00dfendem \u00c4ndern des Sachkontos, wird das Gegenkonto (Forderungs- oder Verbindlichkeitskonto) entsprechend automatisch den Voreinstellungen des neuen Sachkontos angepasst.</p> <p>25.05.085 | F\u00fcr die Soll-Istbuchung mit Kontoart 10, wird das korrekte Finanzrechnungskonto wieder in der Buchungsmaske angezeigt. bei 421 das Einzahlungs- und bei 521 das Auszahlungskonto hinter dem Sachkonto mit Kontenart 10.</p> <p>25.05.088 | Bei der Buchung von Zahlungen, deren Sollstellung Skonto ausweist, erscheint die Abfrage wieder wie der Betrag zu interpretieren ist. Das hei\u00dft hier ist nun wieder ausw\u00e4hlbar, ob es sich beim eingegebenen Betrag um den Zahlbetrag abzgl. Skonto handelt oder ob der Bruttobetrag angegeben wurde und das System Skonto ber\u00fccksichtigen muss. </p> <p>25.05.095 | Wird ein bestehender OP als Buchungsvorlage verwendet und aus der eingetragenen Buchungsstelle ergibt sich die Steuerart \"0\" - nicht steuerbar, so bleibt das Feld des Steuerkennzeichens wieder f\u00fcr Eingaben gesperrt. Folgen mehrere Buchungen hintereinander, so erscheint die Abfrage f\u00fcr jede Buchung mit Skonto. </p>"},{"location":"aktuelles/release-notes/5.2.1.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":""},{"location":"aktuelles/release-notes/5.2.1.html#52-eingangsrechnungsjournal","title":"52 - Eingangsrechnungsjournal","text":"<p>Behoben: 25.05.094 | Die Erfassung von Eingangsrechnungen mit Steuerart 0/1/2 war nicht m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.2.1.html#6-auswertungen","title":"6 - Auswertungen","text":""},{"location":"aktuelles/release-notes/5.2.1.html#69-auswertungszentrale","title":"69 - Auswertungszentrale","text":"<p>Behoben: 25.05.111 | Der Druck der Liste \"Produktblatt\" war nicht m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.2.1.html#8-veranlagung","title":"8 - Veranlagung","text":""},{"location":"aktuelles/release-notes/5.2.1.html#81-einzelveranlagung","title":"81 - Einzelveranlagung","text":"<p>Behoben: 25.05.068 | In der Funktion \"Objekt\" wird das \u00fcber eine vordefinierte Eingabemaske z.B. XXX/XXX/XXXX/XXX/XXX/X erfasste Aktenzeichen bei einem nachtr\u00e4glichen Editieren eines anderen Objektbeschreibungsfeldes nicht mehr abgeschnitten.</p>"},{"location":"aktuelles/release-notes/5.2.2.html","title":"Release Notes 5.2.2","text":"<p>Ver\u00f6ffentlichungsdatum des Updates: 11.06.2025</p>"},{"location":"aktuelles/release-notes/5.2.2.html#ubergreifende-funktionen","title":"\u00fcbergreifende Funktionen","text":""},{"location":"aktuelles/release-notes/5.2.2.html#allgemein","title":"Allgemein","text":"<p>Behoben Nach Anmeldung am Programm wurden f\u00e4lschlicherweise leere Reiter \u201eVorschau Protokoll\u201c angezeigt.</p>"},{"location":"aktuelles/release-notes/5.2.2.html#textfelder-textbausteine","title":"Textfelder / Textbausteine","text":"<p>Verbesserung: 25.05.184 | In Textfeldern (z.B. Textbausteine - Men\u00fc 1y1, Individualtexte - Men\u00fc 54, usw.) stehen nun s\u00e4mtliche auf dem Server installierten Schriftarten zur Formatierung zur Verf\u00fcgung.</p>"},{"location":"aktuelles/release-notes/5.2.2.html#1-stammdaten","title":"1 - Stammdaten","text":""},{"location":"aktuelles/release-notes/5.2.2.html#11-mandant-reiter-umsatzsteuer","title":"11 - Mandant (Reiter: Umsatzsteuer)","text":"<p>Behoben: 25.05.207 | Die Zuordnung der Steuerkennzeichen zu den einzelnen Formularfeldern f\u00fcr die Umsatzsteuervoranmeldung und die Umsatzsteuerjahresmeldung ist wieder vollst\u00e4ndig gegeben. </p>"},{"location":"aktuelles/release-notes/5.2.2.html#2-planung","title":"2 - Planung","text":""},{"location":"aktuelles/release-notes/5.2.2.html#23-budgetzuordnung","title":"23 - Budgetzuordnung","text":"<p>Behoben: 25.06.009 | In bestimmten Konstellationen konnte die Buchungsstellen-Matrix nicht f\u00fcr alle Kontotypen korrekt angezeigt werden. </p>"},{"location":"aktuelles/release-notes/5.2.2.html#27-neue-buchungsstelle","title":"27 - Neue Buchungsstelle","text":"<p>Verbesserung: 25.02.113 | Im Reiter \u201e\u00dcbernahme Buchungsstellen Vorjahr\u201c wurde das Kontextmen\u00fc um die Funktion \u201eAlle Bst. anlegen\u201c erweitert. Damit k\u00f6nnen nun alle angezeigten Buchungsstellen in einem Schritt ausgew\u00e4hlt werden.</p>"},{"location":"aktuelles/release-notes/5.2.2.html#3-buchung","title":"3 - Buchung","text":""},{"location":"aktuelles/release-notes/5.2.2.html#311-einzelbuchung","title":"311 - Einzelbuchung","text":"<p>Behoben: 25.05.176 | Bei einer sogenannten Soll-Ist-Buchung mit dem Buchungsschl\u00fcssel 421 und einem Konto mit der Steuerart 0 verlangte das Programm f\u00e4lschlicherweise beim zugeh\u00f6rigen Zahlungsbuchungsanteil (Buchungsschl\u00fcssel 621) die Angabe eines Steuerkennzeichens.</p>"},{"location":"aktuelles/release-notes/5.2.2.html#33-buchungsstapel","title":"33 - Buchungsstapel","text":"<p>Behoben: 25.05.153 | Das L\u00f6schen einzelner Zahlungsbuchungen ist nun wieder \u00fcber die ENTF-Taste oder die Papierkorb-Funktion (Tabellen-Toolbar) innerhalb der Tabelle m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.2.2.html#35x-schnittstellen-3521-einlesen-3522-varbeiten","title":"35x - Schnittstellen (3521 - Einlesen / 3522 - Varbeiten)","text":"<p>Verbesserung: 25.02.113 | Im Kontextmen\u00fc innerhalb der Tabelle wurde die Funktion \u201eSuchen/Ersetzen\u201c \u00fcberarbeitet. Diese erm\u00f6glicht eine gezielte Bearbeitung mehrerer Datens\u00e4tze innerhalb einer Spalte. Aus technischen Gr\u00fcnden muss vor dem Ersetzen zun\u00e4chst immer die Funktion \u201eN\u00e4chstes Finden\u201c ausgef\u00fchrt werden. Erst danach werden die drei verf\u00fcgbaren \u201eErsetzen\u201c-Funktionen aktiviert.</p>"},{"location":"aktuelles/release-notes/5.2.2.html#392-sachkonten","title":"392 - Sachkonten","text":"<p>Behoben:  DMS-Dokumente werden wieder korrekt angezeigt.</p>"},{"location":"aktuelles/release-notes/5.2.2.html#6-auswertungen","title":"6 - Auswertungen","text":""},{"location":"aktuelles/release-notes/5.2.2.html#661x-vorschlagslisten","title":"661x - Vorschlagslisten","text":"<p>Verbesserung: 25.06.007 | In den Vorschlagsmen\u00fcpunkten 6612, 6613, 6614 und 6622 wurde die L\u00f6schfunktionalit\u00e4t einzelner Datens\u00e4tze \u00fcberarbeitet. Es stehen nun folgende M\u00f6glichkeiten zum L\u00f6schen zur Verf\u00fcgung:</p> <ul> <li>Doppelklick auf den Zeilenkopf (1. Spalte jeder Tabelle - ohne Spalten\u00fcberschrift) der zu l\u00f6schenden Zeile</li> <li>Papierkorb-Funktion in der Tabellen-Toolbar</li> <li>ENTF-Taste \u279c Hinweis: Die Zeile muss im Zeilenkopf markiert sein. Ein aktiver Zellfokus \u2013 erkennbar durch  Umrandung einer Zelle \u2013 verhindert die L\u00f6schung.</li> </ul> <p>25.02.113 | Im Kontextmen\u00fc der Vorschlagsmen\u00fcpunkte 6612, 6613, 6614 und 6622 wurde innerhalb der Tabelle die Funktion \u201eSuchen/Ersetzen\u201c \u00fcberarbeitet. Diese erm\u00f6glicht eine gezielte Bearbeitung mehrerer Datens\u00e4tze innerhalb einer Spalte. Aus technischen Gr\u00fcnden muss vor dem Ersetzen zun\u00e4chst immer die Funktion \u201eN\u00e4chstes Finden\u201c ausgef\u00fchrt werden. Erst danach werden die drei verf\u00fcgbaren \u201eErsetzen\u201c-Funktionen aktiviert. Die Funktion \u201eSuchen\u201c steht grunds\u00e4tzlich in allen Spalten zur Verf\u00fcgung, w\u00e4hrend \u201eErsetzen\u201c nur in editierbaren Spalten genutzt werden kann.</p> <p>Behoben: 25.05.150 | DMS-Dokumente werden in den Men\u00fcs 6612, 6613, 6614 und 6622 wieder korrekt angezeigt.</p>"},{"location":"aktuelles/release-notes/5.2.2.html#6622-zahlungsvorschlag","title":"6622 - Zahlungsvorschlag","text":"<p>Behoben: 25.05.189 | Die editierbaren Betragsspalten wurden \u00fcberarbeitet. Die bisherige IFR-Spalte \u201ezur Zahlung angew.\u201c entspricht nun der neuen H2R-Spalte \u201eBetrag\u201c. Diese ist editierbar und stellt den auszuzahlenden Betrag dar.</p>"},{"location":"aktuelles/release-notes/5.2.2.html#68-freie-auswertungen","title":"68 - Freie Auswertungen","text":"<p>Verbesserung 25.05.183 | \u00dcberarbeitung der freien Auswertungen FQ7770  und FQ7780:</p> <ul> <li>FQ7770 - abweichende MB-Veranlagungen: Anpassung der Parameter-Bezeichnungen, Filterung nach Grundsteuerart und Unterobjekten m\u00f6glich, - Anzeige aller Messbetr\u00e4ge m\u00f6glich (inkl. der \u00dcbereinstimmenden)  </li> <li>FQ7780 - Veranlagungen ohne Zuordnung zum MBV: Anpassung der Parameter-Bezeichnungen</li> </ul>"},{"location":"aktuelles/release-notes/5.2.2.html#69-auswertungszentrale","title":"69 - Auswertungszentrale","text":"<p>Behoben: 25.05.147 | Die Druckfunktion nach einzelnen Teilhaushalten unter der Verwendung von sog. Platzhaltern (z.B. 1-% f\u00fcr Teilhaushalt 1) im Feld Auswahl wurde wiederhergestellt.</p>"},{"location":"aktuelles/release-notes/5.2.2.html#8-veranlagung","title":"8 - Veranlagung","text":""},{"location":"aktuelles/release-notes/5.2.2.html#81-einzelveranlagung","title":"81 - Einzelveranlagung","text":"<p>Verbesserung: 25.06.056 | Die Gr\u00f6\u00dfe des Feldes \"Objektinfo\" im Men\u00fc 81 kann jetzt als Panel auf- oder zugeklappt werden, sodass eine Neuerfassung/Bearbeitung wieder ohne Probleme m\u00f6glich ist. Diese Eigenschaft wird benutzerspezifisch gespeichert. Weiterhin kann der Inhalt \u00fcber das Men\u00fc 152 im Reiter \"Objekt\" in der Spalte \u201eObjektinfo\u201c pro Einnahmeart definiert werden. Diese Auswahl hat keine Auswirkung mehr auf die DTA-Meldungen im Men\u00fc 861 und 862. In der Objektbeschreibung der DTA-Meldungen werden alle definierten Felder der Einnahmeart angezeigt.</p> <p>Behoben: 25.05.199 | Die manuelle Eingabe von Saldobetr\u00e4gen f\u00fcr die Gewerbesteuerverzinsung (Men\u00fc 81 &gt; Vollverzinsung &gt; Saldo und Buchungen) ist wieder m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.2.2.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":""},{"location":"aktuelles/release-notes/5.2.2.html#allgemein-menupunkte-b31-b32-b33-b34-b71-b73","title":"Allgemein: Men\u00fcpunkte b31 | b32 | b33 | b34 | b71 | b73","text":"<p>Behoben: 25.05.096 | Nach der Buchung eines Anlagegutes bzw. Sonderpostens oder beim Er\u00f6ffnen bzw. Abschlie\u00dfen eines Anbu-Jahres wurde f\u00e4lschlicherweise ein leerer Reiter \u201eVorschau Protokoll\u201c angezeigt.</p>"},{"location":"aktuelles/release-notes/5.2.2.html#gesetzliche-anderungen-bundesland-brandenburg","title":"gesetzliche \u00c4nderungen Bundesland Brandenburg","text":"<p>Mit dem aktuellen Release 5.2.2 wurden umfangreiche Anpassungen gem\u00e4\u00df der neuen KomHKV ab 2025 vorgenommen.  </p> Folgende Muster, insbesondere im Kontext des Jahresabschlusses, wurden gem\u00e4\u00df den aktuellen gesetzlichen Vorgaben \u00fcberarbeitet: 5.10 Muster zu \u00a7 3 Abs. 2 Nr. 4 und \u00a7 49 Abs. 3 KomHKV f\u00fcr die Verbindlichkeiten\u00fcbersicht 5.18 Muster zu \u00a7 43 KomHKV f\u00fcr die Ergebnisrechnung 5.19 Muster zu \u00a7 44 KomHKV f\u00fcr die Finanzrechnung 5.20 Muster zu \u00a7 45 KomHKV f\u00fcr die Teilergebnisrechnung 5.21 Muster zu \u00a7 45 KomHKV f\u00fcr die Teilfinanzrechnung 5.23 Muster zu \u00a7 49 Abs. 1 KomHKV f\u00fcr die Anlagen\u00fcbersicht 5.24 Muster zu \u00a7 49 Abs. 2 KomHKV f\u00fcr die Forderungs\u00fcbersicht <p>WICHTIG: Die neuen Muster sind ausschlie\u00dflich \u00fcber SASKIA.H2R im Men\u00fc 69 verf\u00fcgbar.</p> <p>F\u00fcr alle angepassten Muster wurde die neue Vorlagenoption \u201egem\u00e4\u00df KomHKV ab 2025\u201c integriert. Diese ist zu aktivieren, wenn die entsprechenden Listen nach dem neuen Haushaltsrecht erzeugt werden sollen. Die Option stellt gleichzeitig sicher, dass die Abw\u00e4rtskompatibilit\u00e4t zu fr\u00fcheren Haushaltsjahren erhalten bleibt.</p> <p>Bereitstellung einer neuen Schattenmandanten-Version 0001 Im Men\u00fc s31 \u2013 Releasewechsel ist das Update des Schattenmandanten f\u00fcr alle als \u201eAusf\u00fchren\u201c gekennzeichneten Punkte durchzuf\u00fchren. Anschlie\u00dfend ist im Men\u00fc 11 - Mandant der Schalter F41 - Version Schattenmandant ab den betreffenden Haushaltsjahren auf 0001 zu setzen. Mit dieser Version k\u00f6nnen im Men\u00fc 123 \u2013 Listenpositionsverwaltung die angepassten Listenstrukturen neu abgeleitet werden. Strukturelle \u00c4nderungen betreffen insbesondere die Finanzlisten.</p> <p>Neues Auswertungsmuster zu \u00a7 47 Abs. 3 Nr. 1 KomHKV F\u00fcr das Muster 5.22 (\u00dcbersicht \u00fcber \u00fcbertragene Haushaltserm\u00e4chtigungen gem\u00e4\u00df \u00a7 47 Abs. 3 Nr. 1 KomHKV) steht im Men\u00fc 68 die Freie Auswertung FQ2610 - \u00dcbersicht der \u00fcbertragenen Haushaltserm\u00e4chtigungen im Bereich \"Haushalts\u00fcberwachung\" zur Verf\u00fcgung. Die Auswertung korrespondiert datentechnisch mit der Spalte \u201eMittel\u00fcbertrag Vorjahr\u201c im Men\u00fc 394 \u2013 Budget\u00fcbersicht und kumuliert die Werte je Produktbereich.</p> Die Auswertung ber\u00fccksichtigt aktuell folgende Kontenklassen: FR-Konten 70:75 Aufwendungen / Auszahlungen aus laufender Verwaltungst\u00e4tigkeit FR-Konten 78% Auszahlungen aus Investitionst\u00e4tigkeit FR-Konten 79% Auszahlungen aus Finanzierungst\u00e4tigkeit"},{"location":"aktuelles/release-notes/5.2.3.html","title":"Release Notes 5.2.3","text":"<p>Ver\u00f6ffentlichungsdatum des Updates: 26.06.2025</p>"},{"location":"aktuelles/release-notes/5.2.3.html#3-buchung","title":"3 - Buchung","text":""},{"location":"aktuelles/release-notes/5.2.3.html#311-einzelbuchung","title":"311 - Einzelbuchung","text":"<p>Behoben  25.06.149 | Bei der Zahlung eines r\u00fcckstellungsbezogenen OPs wird nun das bei der Sollstellung hinterlegte abweichende FR-Konto korrekt in die Zahlungsbuchung \u00fcbernommen.</p>"},{"location":"aktuelles/release-notes/5.2.3.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":""},{"location":"aktuelles/release-notes/5.2.3.html#48-vollstreckung","title":"48 - Vollstreckung","text":"<p>Behoben: 25.06.153 | Der unter bestimmten Konstellationen aufgetretene Fehler \u201eInvalid operation. The connection is closed.\u201c bei der avviso-\u00dcbergabe wurde korrigiert und sollte k\u00fcnftig nicht mehr auftreten.</p>"},{"location":"aktuelles/release-notes/5.2.3.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":""},{"location":"aktuelles/release-notes/5.2.3.html#51-auftragsverwaltung","title":"51 Auftragsverwaltung","text":"<p>Behoben: 25.06.028 | Wird eine Anordnung zu einer Eingangsrechnung mit dem Zusatz \u201eSchlussabruf\u201c abgewiesen, wird der zugeh\u00f6rige Auftrag nun wieder korrekt auf den Status \u201eTeilaufruf\u201c zur\u00fcckgesetzt. Der Auftrag verbleibt somit nicht mehr f\u00e4lschlicherweise im Status \u201eSchlussabruf\u201c und steht anschlie\u00dfend wieder f\u00fcr eine korrigierte oder weitere Rechnung zur Verf\u00fcgung.</p>"},{"location":"aktuelles/release-notes/5.2.3.html#52-eingangsrechnungsjournal","title":"52 - Eingangsrechnungsjournal","text":"<p>Behoben: 25.06.070 | In bestimmten Konstellationen, insbesondere bei der Verarbeitung von eRechnungen aus dem DMS, wurde die IBAN der zuvor erfassten Rechnung im Hintergrund zwischengespeichert und f\u00e4lschlicherweise der folgenden Rechnung zugeordnet.</p> <p>25.06.157 | Die unter bestimmten Voraussetzungen f\u00e4lschlicherweise angezeigte Fehlermeldung bei der Erfassung einer Eingangsrechnung mit mehreren Rechnungspositionen, wonach eine Produktangabe unzul\u00e4ssig sei, nicht existiere oder die Buchungsstelle nicht gefunden wurde, obwohl die Angaben korrekt waren, wurde behoben.</p>"},{"location":"aktuelles/release-notes/5.2.3.html#54-ausgangsrechnungsjournal","title":"54 - Ausgangsrechnungsjournal","text":"<p>Behoben: 25.06.115 | Die IBAN auf einer Ausgangsrechnung wird bei den Informationen zur Abbuchung k\u00fcnftig wieder anonymisiert angezeigt, sofern der Schalter F08 auf \u201eJa\u201c gesetzt ist.</p>"},{"location":"aktuelles/release-notes/5.2.3.html#8-veranlagung","title":"8 - Veranlagung","text":""},{"location":"aktuelles/release-notes/5.2.3.html#81-einzelveranlagung","title":"81 - Einzelveranlagung","text":"<p>Behoben: 25.06.096 | Bei der Nutzung von Sammeleinnahmearten steht der Button \"Raten bilden\" in der Maske \"Neuerfassung\" wieder zur Verf\u00fcgung.</p>"},{"location":"aktuelles/release-notes/5.2.3.html#862-grundsteuer-meldungen","title":"862 - Grundsteuer-Meldungen","text":"<p>Behoben: 25.06.150 | Bei der Messbetrags\u00fcbernahme aus Elster-Grundsteuermeldungen wurde bei Nutzung von Sammeleinnahmearten, trotz vorhandenem Vorg\u00e4ngerbescheid, das Soll-Alt immer mit 0 angegeben. Dieses Problem wurde behoben sodass bei Erstellung eines neuen \u00c4nderungsbescheides aufgrund der Messbetrags\u00fcbernahme immer der korrekte Betrag aus der betroffenen Teilnehmer-Einnahmeart des Vorg\u00e4ngerbescheides als Soll-Alt \u00fcbergeben wird.</p>"},{"location":"aktuelles/release-notes/5.2.3.html#9-barkasse","title":"9 - Barkasse","text":""},{"location":"aktuelles/release-notes/5.2.3.html#92-einnahme-und-ausgabe-kasse","title":"92 - Einnahme und Ausgabe Kasse","text":"<p>Behoben: 25.05.098 | Die Funktion \"Stapelbuchen\" ist f\u00fcr Barkassenvorg\u00e4nge wieder korrekt verf\u00fcgbar.</p> <p>25.06.139 | Die Verbuchung von Ausgaben in der Barkasse funktioniert wieder korrekt.</p>"},{"location":"aktuelles/release-notes/5.2.4.html","title":"Release Notes 5.2.4","text":"<p>Ver\u00f6ffentlichungsdatum des Updates: 15.07.2025</p>"},{"location":"aktuelles/release-notes/5.2.4.html#releasewechsel","title":"Releasewechsel","text":"<p>Hinweis: F\u00fcr diesen Patch sollte unbedingt der Releasewechselpunkt \u201eKorrektur leerer (NULL) Buchstapel-Betr\u00e4ge\u201c im Men\u00fc s31 - Releasewechsel ausgef\u00fchrt werden, um eventuell vorhandene fehlerhafte Datenkonstellationen im Buchungsstapel zu bereinigen. (siehe auch Punkt 33 - Buchungsstapel \u2013 Nummer: 25.07.046)</p>"},{"location":"aktuelles/release-notes/5.2.4.html#3-buchung","title":"3 - Buchung","text":""},{"location":"aktuelles/release-notes/5.2.4.html#311-einzelbuchung","title":"311 - Einzelbuchung","text":"<p>Behoben: 25.07.013 | Bei der Verwendung des Buchungsschl\u00fcssels 260 wurde das angegebene Finanzrechnungskonto auf der Soll-Seite f\u00e4lschlicherweise entfernt, wodurch keine Buchung m\u00f6glich war. </p> <p>25.07.023 | Beim Buchen mit den Buchungsschl\u00fcsseln 421/521 wird das Personenkonto nun wieder korrekt auf den Zahlungsbuchungsschl\u00fcsseln 621/721 \u00fcbertragen.</p> <p>25.07.027 | Bei Ausgleich von Offenen Posten per Mehrfachauswahl wurde die Gesamtsumme bzw. der Zahlbetrag nicht automatisch in das Feld \u201eGesamtbetrag / Aufteilung\u201c aus dem Dialog \u201eOP-Mehrfachauswahl best\u00e4tigen\u201c \u00fcbernommen, sondern musste manuell eingegeben werden, da sonst die Buchung nicht verarbeitet werden konnte.</p>"},{"location":"aktuelles/release-notes/5.2.4.html#33-buchungsstapel","title":"33 - Buchungsstapel","text":"<p>Behoben:  25.07.046 | Der Fehler \u201eDer Wert NULL kann in die...nicht eingef\u00fcgt werden...\", der unter bestimmten Konstellationen auftrat und das Verbuchen einzelner Buchungss\u00e4tze im Buchungsstapel verhinderte, wurde behoben.</p> <p>Hinweis: Zur Bereinigung eventuell bereits vorhandener Datenkonstellationen ist der Releasewechselpunkt \u201eKorrektur leerer (NULL) Buchstapel-Betr\u00e4ge\u201c im Men\u00fc s31 - Releasewechsel auszuf\u00fchren.</p>"},{"location":"aktuelles/release-notes/5.2.4.html#6-auswertungen","title":"6 - Auswertungen","text":""},{"location":"aktuelles/release-notes/5.2.4.html#661x-vorschlagslisten","title":"661x - Vorschlagslisten","text":"<p>Behoben: 25.07.006 | Die Spalte \u201eKundennummer\u201c l\u00e4sst sich f\u00fcr s\u00e4mtliche Vorschlaglisten wieder bearbeiten.</p>"},{"location":"aktuelles/release-notes/5.2.4.html#8-veranlagung","title":"8 - Veranlagung","text":""},{"location":"aktuelles/release-notes/5.2.4.html#862-grundsteuer-meldungen","title":"862 - Grundsteuer-Meldungen","text":"<p>Neu: 25.07.038 | Im Zuge der Grundsteuerreform passt ELSTER regelm\u00e4\u00dfig die zugrunde liegende Datenstruktur an. Diese \u00c4nderungen erfordern entsprechende Anpassungen an der SASKIA.H2R Schnittstelle, um die reibungslose Verarbeitung weiterhin sicherzustellen. (Version: GMBX 2-5-0-1 | GMBVX 2-5-0-2 | Details : https://www.esteuer.de/#grst-reform - zum Stand 25.06.2025)</p> <p>Folgende Anpassungen wurden vorgenommen: - bekannte Schl\u00fcsselbedeutungen f\u00fcr SONSTIGE-BE-KENNZEICHNUNG werden k\u00fcnftig angezeigt</p>"},{"location":"aktuelles/release-notes/5.3.0.html","title":"Release Notes 5.3.0","text":"<p>Ver\u00f6ffentlichungsdatum des Updates: 05.09.2025</p>"},{"location":"aktuelles/release-notes/5.3.0.html#ubergreifende-funktionen","title":"\u00fcbergreifende Funktionen","text":""},{"location":"aktuelles/release-notes/5.3.0.html#allgemein","title":"Allgemein","text":"<p>Neu:  In den Tabellenansichten ist es jetzt m\u00f6glich, Spalten zu fixieren/festzuhalten, sodass diese beim Scrollen sichtbar bleiben. Diese Funktion verbessert die \u00dcbersichtlichkeit bei der Arbeit mit umfangreichen Tabellen.</p> <p>Verbesserung: 25.05.050 | Die Darstellung aktiv gesetzter Spaltenfilter wurde \u00fcberarbeitet: Ist ein Filter aktiviert, wird das Filtersymbol jetzt farblich ausgef\u00fcllt dargestellt. Dadurch ist auf einen Blick erkennbar, welche Spalten gefiltert sind.</p> <p>25.05.057 | Im Testsystem ist eine \u00c4nderung des Farbschemas nicht mehr m\u00f6glich. Dadurch bleibt das gelbe Farbschema dauerhaft aktiv, sodass das Testsystem zuverl\u00e4ssig und eindeutig vom Produktivsystem zu unterscheiden ist.</p> <p>25.06.041 | In den SASKIA.H2R-Tabellen wurden die bisherigen Sidebar-Funktionen \u201eZell- oder Zeilenmodus\u201c entfernt, da ein Wechsel zwischen diesen nicht mehr erforderlich ist. Dadurch konnten auch Wechselwirkungen bei Summierungsfunktionen und Buttons optimiert werden.</p> <p>Behoben: 25.06.122 | Die pers\u00f6nlich definierte Tastaturbelegung funktioniert f\u00fcr den Shortcut \"DMS Button ausl\u00f6sen\" (Standard: Ctrl+Shift+M) wieder korrekt. Definierte Tastenk\u00fcrzel k\u00f6nnen sowohl aus einzelnen Tasten (z.B. F5 f\u00fcr \u201eAktualisieren\u201c) als auch aus Tastenkombinationen bestehen und werden zuverl\u00e4ssig erkannt. Hinweis: Voraussetzung ist, dass der Fokus im H2R und nicht im Browser liegt.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#theme-erscheinungsbild","title":"Theme (Erscheinungsbild)","text":"<p>Verbesserung: Das ausgew\u00e4hlte Theme wird nun pro Nutzer dauerhaft gespeichert und steht nach einer erneuten Anmeldung automatisch wieder zur Verf\u00fcgung. Damit entf\u00e4llt die bisherige Notwendigkeit, das gew\u00fcnschte Erscheinungsbild nach jedem Login erneut einstellen zu m\u00fcssen. Zus\u00e4tzlich wurde ein neues Kontextmen\u00fc zu den Theme-Einstellungen integriert.</p> <p>Im Kontextmen\u00fc Themeanpassung k\u00f6nnen folgende Einstellungen getroffen werden:</p> Theme folgende Themes stehen aktuell zur Auswahl saskia Standard-Theme mit den bekannten Farben und Formen saskiahell - Theme mit reduziertem Einsatz von SASKIA-Blau - Zusammenf\u00fchrung der bisherigen Entw\u00fcrfe Saskia-Entwurf-01 und Saskia-Entwurf-02 - die optionale hellgr\u00fcne Hintergrundfarbe kann \u00fcber die Einstellung \u201eHintergrund einf\u00e4rben\u201c aktiviert werden saskiarund - experimentelles Theme (Beta) Anzeigeprobleme sind nicht ausgeschlossen - enth\u00e4lt abgerundete Elemente sowie umrandete Labeltexte Farben Unterscheidung zwischen Prim\u00e4r- &amp; Sekund\u00e4rfarbe Standard SASKIA-Blau und SASKIA-Gr\u00fcn Fr\u00fchlingSommerHerbstWinter experimentelle Funktion zum dynamischen Einf\u00e4rben des Erscheinungsbildes (Anzeigeprobleme sind nicht ausgeschlossen) Optionen mehr Linien - standardm\u00e4\u00dfig ist diese Option aktiviert - Reduzierung horizontaler und vertikaler Linien der einzelnen Maskenelemente Hintergrund einf\u00e4rben Mit dieser Option kann der standardm\u00e4\u00dfig wei\u00dfe Hintergrund der Themes zur Verbesserung des Kontrasts eingef\u00e4rbt werden.  - in den Themes saskia und saskiarund wird eine Abstufung von SASKIA-Blau verwendet  - im Theme saskiahell kommt eine Abstufung von SASKIA-Gr\u00fcn zum Einsatz <p>Zahlreiche kleinere Optimierungen und Verbesserungen am Erscheinungsbild wurden in den Themes saskia und saskiahell umgesetzt. Im Testsystem wurde das Erscheinungsbild auf Basis des Themes saskia aktualisiert und mit einer gelben Hintergrundfarbe versehen. Zudem ist dort ein Wechsel des Themes nicht mehr m\u00f6glich, sodass das Testsystem zuverl\u00e4ssig und eindeutig vom Produktivsystem zu unterscheiden ist.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#dms","title":"DMS","text":"<p>Behoben: 25.07.105 | Im DMS-Anzeigefenster kann die Dokumenten_ID eines bereits zugeordneten Dokuments jetzt per Ctrl+C kopiert werden. Diese ID l\u00e4sst sich anschlie\u00dfend in einem anderen DMS-Vorgang im Eingabefeld \u201eDokumente_ID\u201c einf\u00fcgen, um das Dokument auch dort zuzuordnen. Dies erleichtert die Mehrfachverwendung bereits vorhandener Dokumente.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#druck","title":"Druck","text":"<p>Behoben: 25.07.053 | Die Reportansicht wird jetzt nach jeder \u00c4nderung der Vorlagenparameter korrekt aktualisiert.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#jobserver","title":"Jobserver","text":"<p>Neu: 25.04.083 | Es wurde ein neuer Job in den Jobserver integriert, welcher die automatisierte Bereinigung der Aufgabenverwaltung entsprechend der definierten Konfiguration erm\u00f6glicht. Die Bereinigung kann sowohl mandanten- als auch nutzerspezifisch durchgef\u00fchrt werden. Zu den Objekten, welche im Rahmen des Jobs bereinigt werden k\u00f6nnen, z\u00e4hlen Nachrichten, Termine, Aufgaben und Protokolle.  Hinweis: Das Alter der zu bereinigenden Objekte ist konfigurierbar, muss jedoch mindestens 180 Tage betragen. J\u00fcngere Objekte k\u00f6nnen weiterhin ausschlie\u00dflich manuell \u00fcber das Men\u00fc 011 entfernt werden.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#startseite","title":"Startseite","text":"<p>Behoben: 25.08.006 | Die Kacheln auf der Startseite wurden bisher als Favoriten angezeigt, wodurch es in der Favoritenleiste zu scheinbar doppelten Favoriten kam. Zuk\u00fcnftig werden die Kacheln nicht mehr als Favorit ausgewertet, wodurch die Anzeige in der Favoritenleiste wieder lediglich die pers\u00f6nlich hinzugef\u00fcgten Favoriten beinhaltet. Au\u00dferdem wurde die Funktion \u201eAlles neu anordnen\u201c \u00fcberarbeitet, sodass es beim Neuanordnen nicht mehr zu \u00dcberlappungen der Favoriten kommt.</p> <p>25.04.107 | Protokollabrufe aus dem SASKIA.de-IFR werden nicht mehr in SASKIA.H2R angezeigt.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#0-global","title":"0 - Global","text":""},{"location":"aktuelles/release-notes/5.3.0.html#013-postausgang","title":"013 - Postausgang","text":"<p>Behoben: 25.03.154 | eRechnungen werden jetzt im korrekten Format im Hintergrund im DMS abgelegt und beim Versand per E-Mail \u00fcber den eVersand \u00fcbertragen. Dadurch ist sichergestellt, dass sowohl Archivierung als auch Versand den geltenden Formatvorgaben entsprechen.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#1-stammdaten","title":"1 - Stammdaten","text":""},{"location":"aktuelles/release-notes/5.3.0.html#121-produktverwaltung","title":"121 - Produktverwaltung","text":"<p>Verbesserung: 25.02.032 | Um eine Druckliste \u00fcber alle Produkte zu erzeugen, kann im Men\u00fc 121 innerhalb der Produkthierarchie die Option \u201eP\u201c ausgew\u00e4hlt werden. Dadurch wird der Druck-Button aktiviert und der Ausdruck der vollst\u00e4ndigen Produktliste erm\u00f6glicht. Hinweis: Zur visuellen Aufbereitung der eingegebenen Quoten pro Produkt und Periode steht ab sofort in den freien Auswertungen die neue Auswertung \u201eFQ2600\u201c zur Verf\u00fcgung. Diese unterst\u00fctzt eine gezielte Analyse der Verteilquoten \u00fcber definierte Zeitr\u00e4ume hinweg.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#125-manahmen","title":"125 - Ma\u00dfnahmen","text":"<p>Verbesserung: 25.04.033 | In der Spalte \u201eg\u00fcltig bis\u201c kann jetzt auch nach Ma\u00dfnahmen gefiltert werden, die kein Enddatum enthalten. Hierf\u00fcr steht der Filtereintrag {leer} zur Verf\u00fcgung, mit dem gezielt Ma\u00dfnahmen ohne hinterlegtes Enddatum ausgew\u00e4hlt werden k\u00f6nnen.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#1272-zahlwege","title":"1272 - Zahlwege","text":"<p>Behoben: 25.05.151 | F\u00fcr das \u00dcberzahlkonto ist die Neuanlage eines Zahlweges \u00fcber die N-Funktion zur Anlage aus dem Schattenmandanten wieder m\u00f6glich. Bei der Anlage eines Zahlwegs mit Geldtransit erfolgt zudem wieder eine Pr\u00fcfung darauf, dass eine IBAN vorhanden ist, um eine korrekte Zahlungsabwicklung sicherzustellen.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#1273-steuerkennzeichen","title":"1273 - Steuerkennzeichen","text":"<p>Neu: 25.02.132 | Bisher war es programmseitig nicht m\u00f6glich, Buchungen im Rahmen des \u00a7 13b Abs. 2 Nr. 7 UStG zu erfassen, wenn die Verwaltung als Schrotth\u00e4ndler aufgetreten ist. Mit dem aktuellen Release wurde dieses Verhalten angepasst. Die Buchung solcher Vorg\u00e4nge ist jetzt m\u00f6glich. Die genaue Handhabung wird im folgenden Abschnitt beschrieben:</p> <ol> <li> <p>Zur Anlage von Verbundkennzeichen war es bisher notwendig die Checkbox \"Steuer f\u00fcr EG-Land\" zu aktivieren. Damit wurde jedoch auch eine Pr\u00fcfung der Umsatzsteuer-ID f\u00fcr innergemeinschaftliche Personenkonten notwendig, die im Fall von deutschen Personenkonten fehlschlug. Hier wurde eine Anpassung vorgenommen, dass f\u00fcr alle Vorsteuerkennzeichen das Merkmal zum Verbundkennzeichen frei definiert werden kann. Somit ist keine USt.-ID Pr\u00fcfung mehr f\u00fcr Inl\u00e4nder notwendig. Handelt es sich um ein Steuerkennzeichen, welches im Rahmen eines innergemeinschaftlichen Erwerbs verwendet wird, so erfolgt die Pr\u00fcfung auf Vorhandensein einer USt.-ID nach wie vor, wenn das entsprechende Stkz das \u201eEG-Merkmal\u201c tr\u00e4gt.</p> </li> <li> <p>Die Verwaltung erh\u00e4lt eine Schrott- oder Edelmetalllieferung und muss aufgrund der Umkehr der Steuerschuld diesen Erhalt in der Umsatzsteuervoranmeldung ber\u00fccksichtigen. Hierf\u00fcr sind zwei verbundene Steuerkennzeichen notwendig - das Kennzeichen f\u00fcr die Vorsteuer muss mit dem Kennzeichen f\u00fcr die Umsatzsteuer mit Hilfe des Feldes \"verbundenes Umsatzsteuerkennzeichen f\u00fcr igE oder \u00a7 13b\" verbunden werden. Handelt es sich um einen inl\u00e4ndischen Sachverhalt darf die Checkbox \"Steuersatz f\u00fcr EG-Land\" nicht gef\u00fcllt werden.</p> <p>Eine Buchung des Sachverhalts muss \u00fcber die Einzelbuchungsmaske im Rahmen des Buchungsschl\u00fcssels 511 - Eingangsrechnung erfolgen. Beide Steuerkennzeichen sind den Umsatzsteuerformularkennzeichen f\u00fcr Voranmeldung und Jahresmeldung im Mandantenstamm zuzuordnen. </p> </li> <li> <p>Ist die Verwaltung der Lieferant von Schrott oder Edelmetallen ist ein entsprechendes Umsatzsteuerkennzeichen mit 0% Steuer anzulegen und bei der Erstellung von Buchungen zu verwenden. Diese Buchung kann sowohl im Ausgangsrechnungsjournal wie auch der Einzelbuchungsmaske erzeugt werden. Dieses Steuerkennzeichen ist den Umsatzsteuerformularkennzeichen f\u00fcr die Umsatzsteuervoranmeldung und die Jahresmeldung im Mandantenstamm zuzuordnen.</p> </li> </ol> <p>Bitte beachten: Jeder Steuersachverhalt der durch ein Umsatzsteuervoranmeldungskennzeichen gekennzeichnet wird ben\u00f6tigt auch ein separates Steuerkennzeichen in SASKIA.H2R. Das hei\u00dft, dass ein bereits vorhandenes Steuerkennzeichen mit 0% Umsatzsteuer nicht parallel f\u00fcr diesen Sachverhalt verwendet werden kann. In diesem Fall muss ein neues Steuerkennzeichen angelegt und im Mandantenstamm dem USt.-VA-Kennzeichen zugeordnet werden.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#1274-ausgabearten","title":"1274 - Ausgabearten","text":"<p>Neu: 24.05.167 | Als funktionales Gegenst\u00fcck zu den \u201eEinnahmearten\u201c steht jetzt der neue Men\u00fcpunkt 1274 - Ausgabearten zur Verf\u00fcgung. Im ersten Schritt dienen die Ausgabearten dazu, Ausgaben in den Stammdaten des Ausgangsrechnungsjournals (z.B. Tarifgruppen) zu hinterlegen. Diese k\u00f6nnen anschlie\u00dfend in der Barkasse genutzt werden und erm\u00f6glichen damit eine strukturierte und nachvollziehbare Ausgabenerfassung.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#1275-einnahmearten","title":"1275 - Einnahmearten","text":"<p>Verbesserung: 25.08.078 | Die Maskenaufteilung wurde \u00fcberarbeitet, sodass die Suchfelder und Bearbeitungsfelder der Einnahmearten jetzt wieder klar voneinander getrennt sind.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#1277-mahnstaffel","title":"1277 - Mahnstaffel","text":"<p>Behoben: 25.05.009 | Das Anlegen eines Mahngrades bei der Einnahmeart Verzugszins ist jetzt m\u00f6glich. Der Eintrag BUNDESBANKBASISZINS steht zur Auswahl, sodass Verzugszinsen basierend auf dem jeweils g\u00fcltigen Basiszinssatz hinterlegt und verarbeitet werden k\u00f6nnen.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#127e-ao-bestatigungsstufen","title":"127e - Ao-Best\u00e4tigungsstufen","text":"<p>Behoben: 25.05.011 | Das Einf\u00fcgen und Entfernen von AO-Best\u00e4tigungsstufen ist wieder m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#127f-belegtypen","title":"127f - Belegtypen","text":"<p>Verbesserung: 25.07.092 | F\u00fcr die Bildung von Belegnummern in der Einzelbuchungsmaske k\u00f6nnen jetzt auch alphanummerische Belegtypen definiert werden. Dazu steht der neue Platzhalter {Z} zur Verf\u00fcgung, der einen alphanummerischen Z\u00e4hlerwert unterst\u00fctzt. Nach Auswahl eines solchen Belegtyps bei der Festlegung der Belegnummer kann eine Kombination aus Buchstaben und Zahlen eingegeben werden. Wird eine Buchung mit diesem Belegtyp durchgef\u00fchrt und anschlie\u00dfend ein weiterer Beleg erfasst ohne die Maske zu schlie\u00dfen, wird die zuletzt verwendete Belegnummer automatisch wieder vorgeblendet, nachdem derselbe Belegtyp erneut ausgew\u00e4hlt wurde.</p> <p>Beispiel:</p> <p>Bei der manuellen Buchung eines Kontoauszugs wird ein Belegtyp mit dem Platzhalter {Z} verwendet. Nach Auswahl dieses Typs wird die Belegnummer KA123 eingegeben und die Buchung abgeschlossen. Wird anschlie\u00dfend ein weiterer Posten gebucht und derselbe Belegtyp erneut gew\u00e4hlt, erscheint automatisch wieder die Belegnummer KA123 als Vorschlag \u2013 ohne erneute Eingabe. Dies erleichtert die fortlaufende Verbuchung gleichartiger Belege erheblich.</p> <p>Behoben: 25.04.084 | Bei der Verwendung von Belegtypen werden jetzt die definierten Platzhalter-Einstellungen zur Jahresangabe korrekt ber\u00fccksichtigt. Wird z.B. eine zweistellige Jahresangabe \u00fcber den Platzhalter {J2} definiert, so wird diese auch entsprechend umgesetzt. Hinweis: Bei der Verwendung des Platzhalters f\u00fcr die laufende Nummer ({Z}) ist zu beachten, dass die Angabe der Stelligkeit nicht die maximale, sondern die minimale Anzahl von Stellen definiert. Eine k\u00fcrzere Eingabe wird daher als Fehler erkannt.  </p> <p>Beispiel:</p> <p>Soll eine Belegnummer aus der Belegtypenbezeichnung (JABS), einer zweistelligen Jahreszahl und einer mindestens f\u00fcnfstelligen laufenden Nummer bestehen, ergibt sich folgender Platzhalter: {T}{J2}{Z5} Daraus resultiert die Belegnummer: JABS2500001</p> <p>Ist die manuelle Nummernvergabe aktiviert, kann in diesem Fall auch eine sechsstellige laufende Nummer vergeben werden (z.B. JABS2512345), nicht jedoch eine vierstellige. Eine zu kurze Nummer wird vom System entsprechend erkannt und als fehlerhaft markiert.</p> <p>25.06.119 | Das Anlegen neuer Belegtyp ist wieder m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#12a3-personenkontenverwaltung","title":"12a3 - Personenkontenverwaltung","text":"<p>Verbesserung: 25.04.069 | Bei der Anlage einer Bankverbindung mit einem abweichenden Kontoinhaber, der in der Personenkontenauskunft als \u201eZahlungspflichtiger\u201c (04) gekennzeichnet ist, werden jetzt die Personenkonten angezeigt, bei denen dieser Zahlungspflichtige bereits als Kontoinhaber hinterlegt ist. Diese k\u00f6nnen direkt aus der Liste ausgew\u00e4hlt werden, ohne dass ein separates Personenkonto gew\u00e4hlt werden muss.</p> <p>25.04.092 | Zur Bearbeitung einer vorhandenen Bankverbindung kann jetzt auch ein Doppelklick auf die markierte Zeile verwendet werden. Die separate Auswahl der Funktion \u201eBearbeiten\u201c ist damit nicht mehr zwingend erforderlich, was die Bedienung deutlich vereinfacht.</p> <p>Behoben: 25.04.067 | Beim Druck der SEPA-Lastschriftmandate wird jetzt wieder zwischen Schuldner und Kontoinhaber unterschieden. Ist f\u00fcr einen Mandanten ein abweichender Kontoinhaber hinterlegt, erh\u00e4lt dieser das Mandatsschreiben. Der eigentliche Debitor wird als Zahlungspflichtiger bzw. Schuldner informatorisch auf dem Schreiben ausgewiesen.</p> <p>25.04.085 | Das Anlegen eines Kassenakteneintrages ist wieder m\u00f6glich</p> <p>25.07.077 | Die Anlage einer Bankverbindung ist wieder m\u00f6glich, auch wenn noch kein Datensatz vorhanden ist.</p> <p>25.07.120 | Die Anzeige der \u201eSoll\u201c, \u201eHaben\u201c und \u201eOffen\u201c-Betr\u00e4ge in der Personenkontenauswahl, welche beim Abtauchen im Feld \u201ePersonenkonto\u201c angezeigt werden, wurde korrigiert. Die Betr\u00e4ge werden jetzt rechnerisch korrekt dargestellt.</p> <p>25.07.122 | Im SEPA-Mandatsformular werden die Angaben zum Zahlungspflichtigen in dem Report jetzt vollst\u00e4ndig dargestellt und nicht mehr abgeschnitten. Dadurch wird sichergestellt, dass alle relevanten Informationen im Ausdruck lesbar und vollst\u00e4ndig verf\u00fcgbar sind.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#1y1-textbausteine","title":"1y1 - Textbausteine","text":"<p>Verbesserung: 25.07.132 | In den Vorlagenoptionen des Ausgangsrechnungsjournals besteht jetzt die M\u00f6glichkeit, f\u00fcr die Einstellung \u201emit Ausdruck Einzugserm\u00e4chtigung\u201c die Option \u201eeinmalige Forderung ausblenden\u201c zu aktivieren. Dadurch k\u00f6nnen einmalige Forderungen bei der Erstellung der Ausdrucke gezielt ausgeblendet werden.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#1w-import","title":"1w - Import","text":"<p>Behoben: 25.05.177 | Das Einlesen der Schnittstellen f\u00fcr die Anlagengruppen ist jetzt auch m\u00f6glich, wenn der Anmeldename l\u00e4nger als 10 Zeichen ist. Damit wurde eine bisherige Einschr\u00e4nkung bei der Verarbeitung langer Anmeldenamen behoben.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#2-planung","title":"2 - Planung","text":""},{"location":"aktuelles/release-notes/5.3.0.html#27-neue-buchungsstelle","title":"27 - Neue Buchungsstelle","text":"<p>Neu: 25.07.072 | Beim Anlegen neuer Buchungsstellen im Men\u00fc 27 wurde eine Plausibilit\u00e4tspr\u00fcfung integriert. F\u00fcr das Bundesland Sachsen erfolgt jetzt eine Pr\u00fcfung der Kombinationen aus Produkt und Sachkonto anhand der Vorgaben des Statistischen Landesamtes des Freistaates Sachsen (Teil C: \u201e\u00dcbersicht \u00fcber die zul\u00e4ssigen Kombinationen von Produkt- und Kontonummern\u201c). Wird eine Kombination verwendet, die laut den Vorgaben nicht oder nur optional zul\u00e4ssig ist, erscheint folgende Abfrage:</p> <p>Info:</p> <p>Die Kombination aus Produkt und Sachkonto entspricht nicht den Vorgaben des Statistischen Landesamtes des Freistaates Sachsen, ver\u00f6ffentlicht im Teil C \"\u00dcbersicht \u00fcber die zul\u00e4ssigen Kombinationen von Produkt- und Kontonummern\". Wollen Sie das Produkt/Sachkonto trotzdem anlegen? JA / NEIN</p> <p>Die Entscheidung f\u00fcr eine optionale Abfrage wurde bewusst getroffen, da die Aktualit\u00e4t der genannten Anlage C nicht immer tagesgenau gew\u00e4hrleistet werden kann. Der Anwender handelt in diesen F\u00e4llen in eigener Verantwortung. Hinweis: Die Plausibilit\u00e4tspr\u00fcfungen f\u00fcr Sachsen-Anhalt und Brandenburg befinden sich derzeit in Vorbereitung.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#241-budgetubersicht-planwerte","title":"241 - Budget\u00fcbersicht - Planwerte","text":"<p>Verbesserung: 25.05.004 / 25.05.129 | Folgende Optimierungen wurden in der Maske vorgenommen:</p> <ul> <li>Das Feld Haushaltsjahr (HH-Jahr) wurde vergr\u00f6\u00dfert, um die Eingabe und Lesbarkeit zu verbessern.</li> <li>Ein neues Feld f\u00fcr die Budgetbezeichnung wurde erg\u00e4nzt, um Budgets klarer identifizieren zu k\u00f6nnen.</li> <li>Ein neues Auswahlfeld f\u00fcr den Deckungskreis wurde erg\u00e4nzt, um gezieltere Auswertungen und Eingaben zu erm\u00f6glichen.</li> <li>Die Reihenfolge der Auswahlfelder wurde \u00fcberarbeitet \u2013 die neue Struktur lautet: Produkt, Sachkonto, Ma\u00dfnahme.</li> <li>Die Tabellenansicht wurde umfassend \u00fcberarbeitet, um die Darstellung zus\u00e4tzlicher Informationen, insbesondere der Verpflichtungserm\u00e4chtigungen zu erm\u00f6glichen.</li> </ul> <p>25.05.129 | Die Budget\u00fcbersicht wurde umfassend \u00fcberarbeitet und bietet jetzt eine deutlich erweiterte Informationsdarstellung. Neben den Planwerten werden jetzt auch Budgetangaben, Deckungskreise sowie VE (Verpflichtungserm\u00e4chtigungen) angezeigt. Die Anzeige unterliegt dem jeweils g\u00fcltigen Budgetrecht, sodass auch in dezentralen Planungsphasen die Fach\u00e4mter fr\u00fchzeitig einen umfassenden \u00dcberblick \u00fcber die relevanten finanziellen Rahmenbedingungen und verf\u00fcgbaren Mittel erhalten k\u00f6nnen.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#291-planbuchungsjournal","title":"291 - Planbuchungsjournal","text":"<p>Verbesserung: 25.05.140 | Das Layout der Stammdatenfelder f\u00fcr Produkt, Sachkonto und Ma\u00dfnahme wurde \u00fcberarbeitet. Dadurch ist jetzt auch bei Stelligkeiten gr\u00f6\u00dfer als 8 Zeichen eine vollst\u00e4ndige und \u00fcbersichtliche Anzeige der Inhalte gew\u00e4hrleistet.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#3-buchung","title":"3 - Buchung","text":""},{"location":"aktuelles/release-notes/5.3.0.html#311-einzelbuchung","title":"311 - Einzelbuchung","text":"<p>Neu: 24.04.075 | Zur individuellen Verwendung von Belegnummern in der Einzelbuchungsmaske k\u00f6nnen \u00fcber den Men\u00fcpunkt \u201eBelegtypen\u201c (127f) eigene Belegtypen angelegt werden. Dabei l\u00e4sst sich festlegen, ob die Belegnummernvergabe manuell oder automatisch erfolgen soll und welcher Systematik der Belegnummernaufbau folgt. Diese Funktion wurde jetzt erweitert: Ab sofort kann ein oder k\u00f6nnen mehrere konkrete Buchungsschl\u00fcssel einem Belegtyp zugewiesen werden. Dadurch erscheinen die definierten Belegtypen nur noch in den entsprechenden Buchungsschl\u00fcsseln, was die Auswahlliste gezielt einschr\u00e4nkt und die \u00dcbersichtlichkeit bei der Buchung deutlich verbessert.</p> <p>Verbesserung: 25.03.097 | Die Logik zur Nutzung des Aufteilungsbetrags in der Einzelbuchungsmaske wurde erweitert und pr\u00e4zisiert. Folgende Kombinationen von Buchungsschl\u00fcsseln sind jetzt zul\u00e4ssig bzw. werden speziell behandelt:</p> <ul> <li>Reine Sollbuchungen (411/511 oder Kombinationen): Der Aufteilungsbetrag wird auf Basis von Ertrag minus Aufwand berechnet.</li> <li>Soll-/Ist-Buchungen (421/521 oder Kombinationen): F\u00fcr die Berechnung des Aufteilungsbetrags wird ausschlie\u00dflich die Soll-Seite betrachtet und Ertrag minus Aufwand berechnet.</li> <li>Zahlungsbuchungen (631/731 oder Kombinationen): Eine Aufteilung \u00fcber diese Buchungsschl\u00fcssel oder deren Kombination ist m\u00f6glich.</li> <li>Kombination aus PK- und 2*-Buchungsschl\u00fcsseln: Bei einer solchen Kombination (z.B. 421 und 521 mit RAP) werden nur die PK-Buchungsschl\u00fcssel zur Ermittlung der Aufteilungsdifferenz herangezogen.</li> <li>Unzul\u00e4ssige Kombination aus Soll-/Ist- und Zahlungsbuchungen: Eine gleichzeitige Nutzung von Soll-/Ist- und Zahlungsbuchungsschl\u00fcsseln innerhalb derselben Aufteilung ist nicht zul\u00e4ssig. In diesem Fall erscheint eine Warnmeldung, dass der Aufteilungsbetrag aufgrund der gew\u00e4hlten Kombination nicht berechnet werden kann.</li> </ul> <p>25.03.101 | Mit der neuen Einzelbuchungsmaske ist es jetzt m\u00f6glich, den Buchungsschl\u00fcssel auch w\u00e4hrend der laufenden Eingabe zu \u00e4ndern. Um daraus resultierende Fehleingaben zu vermeiden, wurde das Verhalten beim Leeren einzelner Felder \u00fcberarbeitet. Besonders f\u00fcr den Buchungsschl\u00fcssel 260 \u2013 Umbuchung FR-Konten wurden gezielte Anpassungen vorgenommen:</p> <ul> <li> <p>Beim Wechsel zu Buchungsschl\u00fcssel 260 werden folgende Felder automatisch geleert:</p> </li> <li> <p>Personenkonto</p> </li> <li>OP-Nummer</li> <li>F\u00e4lligkeits- und Valutadatum</li> <li> <p>alle Kontierungsangaben</p> </li> <li> <p>Beim Wechsel von Buchungsschl\u00fcssel 260 in einen anderen Buchungsschl\u00fcssel werden s\u00e4mtliche Kontierungsangaben entfernt.</p> </li> <li>Beim Wechsel zwischen anderen Buchungsschl\u00fcsseln bleiben ausgew\u00e4hlte Angaben erhalten, um eine vollst\u00e4ndige Neueingabe zu vermeiden und den Buchungsprozess effizient zu gestalten. </li> </ul> <p>25.03.131 | Nach dem Setzen einer oder mehrerer Buchungen in den AO-Status wurde die Einzelbuchungsmaske (EBM) bisher geleert, war jedoch nicht sofort wieder editierbar \u2013 ein manueller Klick auf + war erforderlich, um eine neue Buchung erfassen zu k\u00f6nnen. Dieses Verhalten wurde jetzt angepasst: Die Einzelbuchungsmaske ist direkt nach Abschluss einer Buchung erneut editierbar, sodass nahtlos mit der n\u00e4chsten Buchung fortgefahren werden kann.</p> <p>25.05.010 | In der Einzelbuchungsmaske wird bei der Konstellation Produkt mit Steuerart 1 und Sachkonto mit Steuerart 1 jetzt zwingend ein Eintrag im Steuerkennzeichen gefordert. Der Vorgang muss somit entweder explizit als \u201enicht steuerbar\u201c gekennzeichnet oder mit einem g\u00fcltigen Steuerkennzeichen bewertet werden. Dadurch wird sichergestellt, dass steuerlich relevante Buchungen eindeutig klassifiziert sind.</p> <p>25.05.041 | Die Feldgr\u00f6\u00dfe der Personenkontonummer wurde an den Stellen vergr\u00f6\u00dfert, an denen eine Auswahl \u00fcber Drill-down m\u00f6glich ist. Dadurch werden jetzt auch Personenkontonummern mit mehr als 8 Stellen wieder vollst\u00e4ndig angezeigt und korrekt dargestellt.</p> <p>25.04.109 | Bei Buchungen mit dem Buchungsschl\u00fcssel 511 und der Kontoart 10 wird in der Einzelbuchungsmaske die Bemessungsgrundlage und der Steuerbetrag jetzt wieder mit einheitlichem Vorzeichen gebucht.</p> <p>25.05.080 | Bisher konnten steuerrelevante Buchungen mit Konten der Kontoart 13 ausschlie\u00dflich mit dem Buchungsschl\u00fcssel 290 durchgef\u00fchrt werden. Diese Einschr\u00e4nkung wurde jetzt aufgehoben: Ab sofort k\u00f6nnen solche Buchungen auch mit dem Buchungsschl\u00fcssel 200 vorgenommen werden. Hintergrund der \u00c4nderung ist die verpflichtende Eingabe der Steuerperiode bei Umbuchungen von Rundungsdifferenzen im Rahmen des Jahresabschlusses, da diese Umbuchungen nicht in der Umsatzsteuermeldung ber\u00fccksichtigt werden m\u00fcssen.</p> <p>25.05.219 | Wenn im Men\u00fc 1271 kein Buchungskreis definiert ist, merkt sich die Einzelbuchungsmaske im Men\u00fc 311 jetzt ebenfalls den Zustand \u201ekein Buchungskreis\u201c und blendet diesen bei der n\u00e4chsten Buchung automatisch vor.</p> <p>25.06.101 | Ist an einem Sachkonto im allgemeinen Kennzeichen die Einstellung aktiv, sodass bei Buchungen ein Steuerjahr anzugeben ist, so steht hierf\u00fcr jetzt in der Buchungsmaske ein neues Feld \u201eSteuerjahr\u201c zur Verf\u00fcgung. Zudem wurde der Platzhalter {SJ} in der OP-Nummernbildung \u2013 sofern \u00fcber die Einnahmeart definiert \u2013 entsprechend sensibilisiert. Befindet sich der Cursor im Feld der OP-Nummer, kann der Platzhalter gezielt \u00fcber die Tab-Taste angesprochen und bewusst angepasst werden. Wird das neue Feld \u201eSteuerjahr\u201c bef\u00fcllt, hat dessen Wert bei der Bildung der OP-Nummer Vorrang vor dem Platzhalter {SJ}. Dadurch ist eine pr\u00e4zisere und kontrollierbare Steuerjahreszuweisung bei OP-Buchungen m\u00f6glich.</p> <p>Behoben: 24.11.053 | Wird eine Kostenart verwendet, die keine Vorgabe zur Kostenstelle und/oder zum Kostentr\u00e4ger enth\u00e4lt, w\u00e4hrend jedoch systemseitig definiert ist, dass Kostenstelle und/oder Kostentr\u00e4ger verpflichtend einzugeben sind, zeigt das System jetzt keine Vorauswahl mehr f\u00fcr diese Felder an. In dieser Konstellation ist es daher zwingend erforderlich, dass der Anwender eine Kostenstelle bzw. einen Kostentr\u00e4ger manuell hinterlegt, da keine Vorbelegung mehr erfolgt.</p> <p>25.04.079 | Wird bei der Erfassung einer Sollstellung ein \u00fcberzahlter OP ausgew\u00e4hlt, erschien bisher keine Abfrage zur weiteren Verwendung, wodurch der OP nicht als Buchungsvorlage genutzt werden konnte. Dieses Verhalten wurde angepasst: Bei Auswahl eines \u00fcberzahlten OPs erscheint jetzt die Abfrage \u201eOP Buchen oder Buchungsvorlage\u201c, sodass auch \u00fcberzahlte OPs als Vorlage f\u00fcr neue Sollstellungen verwendet werden k\u00f6nnen.</p> <p>25.05.112 | Die Anzeige des F\u00e4lligkeitsdatum bei Buchungen mit dem Buchungsschl\u00fcssel  2xx wurde korrigiert, sodass das Feld leer bleibt.</p> <p>25.05.117 | Die Plausibilit\u00e4tspr\u00fcfung des F\u00e4lligkeitsdatums bei Buchungen mit dem Buchungsschl\u00fcssel 631 wurde \u00fcberarbeitet. Die Pr\u00fcfung erfolgt jetzt ausschlie\u00dflich bei Sollstellungen. </p> <p>25.05.176 | Bei einer Soll-/Ist-Buchung mit Buchungsschl\u00fcssel 421 und einem Konto mit Steuerart 0 verlangt das Programm beim zugeh\u00f6rigen Zahlungsbuchungsanteil (Buchungsschl\u00fcssel 621) nicht mehr die Eingabe eines Steuerkennzeichens.</p> <p>25.05.198 | Das Eingabefeld \"Belegdatum\" wird bei Fehlern oder wenn es leer ist, als Pflichtfeld rot eingef\u00e4rbt.</p> <p>25.05.201 | In der Einzelbuchungsmaske wird das Feld \u201eGesamtbetrag / Aufteilung\u201c nach einer erfolgreich \u00fcbernommenen Buchung beim Zur\u00fcckwechseln in die Erfassungsmaske jetzt wieder korrekt geleert.</p> <p>25.06.102 | Der Zahlweg wird bei Buchungsschl\u00fcsseln vom Typ SOLL/IST wieder korrekt innerhalb der Anordnung ausgewiesen.</p> <p>25.06.106 | Beim Buchungsschl\u00fcssel 631 wird beim Buchen auf eine konkrete Einnahmeart \u00fcber den E-Knopf kein \u00dcberzahlkonto mehr verlangt, sofern im Standard f\u00fcr den zu buchenden Zahlweg kein \u00dcberzahlkonto definiert ist.</p> <p>25.08.087 | In der Einzelbuchungsmaske ist es jetzt m\u00f6glich, eine abweichende F\u00e4lligkeit einzugeben, wenn ein Offener Posten (OP) mittels Buchungsvorlage eingebucht wird. Diese Flexibilisierung erleichtert die individuelle Terminierung von Zahlungsverpflichtungen.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#312-dauerbuchung","title":"312 - Dauerbuchung","text":"<p>Neu: 21.04.070 | Die OP-Eigenschaft \u201eBelegnummer\u201c bei Dauerbuchungen wurde auf vielfachen Kundenwunsch \u00fcberarbeitet, um eine buchungsbegr\u00fcndende DMS-Funktionalit\u00e4t zu erm\u00f6glichen. Ab sofort bleibt die Belegnummer je Dauerbuchungsvorgang dauerhaft gleich \u2013 auch bei mehrfachen Abrufen des Vorgangs. Dieses Verhalten stellt eine Abweichung zur bisherigen Logik dar, bei der die Belegnummer automatisch hochgez\u00e4hlt wurde. Durch diese \u00c4nderung ist es jetzt m\u00f6glich, einem Dauerbuchungsvorgang einen festen digitalen, buchungsbegr\u00fcndenden Beleg dauerhaft zuzuordnen. Hierf\u00fcr stehen zwei Varianten zur Verf\u00fcgung:</p> <ol> <li>Verwendung des DMS-Prozesses \u201eManuellerBuchbeleg\u201c, analog zur Vorgehensweise im Men\u00fc 311 (Einzelbuchungsmaske), sofern lizenziert und konfiguriert.</li> <li>Hinzuf\u00fcgen eines buchungsbegr\u00fcndenden Belegs zur \u201eErst\u201c-Anordnung des Dauerbuchungsvorgangs als sogenanntes DMS-Zusatzdokument.</li> </ol> <p>Behoben: 25.05.093 | Die Werktags- und Feiertagsregelung bei Daueranordnungen funktioniert wieder korrekt. Nach dem einmaligen Verschieben aufgrund eines Feiertages wird wieder die urspr\u00fcngliche F\u00e4lligkeit herangezogen.</p> <p>25.07.101 | Dauerbuchungen behalten die manuell gesetzte Ist-Versteuerung wieder bei.</p> <p>25.08.124 | Wird bei der Neuanlage einer Dauerbuchung eine bestehende Dauerbuchung als Vorlage verwendet, so wird auch der zugeh\u00f6rige Stapelname automatisch \u00fcbernommen.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#32-tagesabschluss","title":"32 - Tagesabschluss","text":"<p>Neu: 25.04.077 | Beim Tagesabschluss muss jetzt f\u00fcr jeden Zahlweg ein Banktag (Wertstellungstag) eingetragen werden. Der Banktag gibt an, an welchem Wertstellungstag sich der Zahlweg im aktuellen Tagesabschluss befindet. Diese Neuerung wurde eingef\u00fchrt, da bisher im Kopf des Tagesabschlusses nur das Erstelldatum des Abschlusses dokumentiert wurde, jedoch keine konkreten Angaben zum Wertstellungsdatum vorhanden waren. Folgende Regeln gelten:</p> <ul> <li>Wird kein Banktag eingetragen, wird automatisch der Vortag des aktuellen Tagesdatums verwendet. (Im \u00dcbersichtsdruck werden in diesem Fall leere Banktage angezeigt.)</li> <li>R\u00fcckwirkende \u00c4nderungen am Banktag nach Abschluss des Tagesabschlusses sind nicht m\u00f6glich.</li> <li>Falls ein eingegebener Banktag j\u00fcnger ist als der Banktag des vorherigen Tagesabschlusses f\u00fcr denselben Zahlweg, erscheint eine Abfrage, ob diese ungew\u00f6hnliche \u00c4nderung trotzdem \u00fcbernommen werden soll.</li> <li>Ein einfacher \u00dcbertrag des Banktags auf weitere Zahlwege ist per Doppelklick in das Datumsfeld m\u00f6glich.</li> </ul> <p>Behoben: 25.04.034 | Im Rahmen der Erstellung des Tagesabschlusses wurde eine Hintergrundmeldung entfernt, die in der Vergangenheit wiederholt zu Anzeigeproblemen gef\u00fchrt hatte.</p> <p>25.06.141 | Das Logo wird auf dem Zahlungsavis wieder korrekt angezeigt.</p> <p>25.08.035 | Beim Druck der LUSI-Liste wird die Gruppierung in der Druckauswahl jetzt wieder korrekt angezeigt.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#33-buchungsstapel","title":"33 - Buchungsstapel","text":"<p>Verbesserung: 25.07.116 | Die Spaltenbezeichnung wurde von \u201eRechnungs-Nr.\u201c in \u201eOP-Nummer\u201c ge\u00e4ndert, um Verwechslungen und Irritationen bei der Interpretation der Daten zu vermeiden.</p> <p>25.08.088 | Eine SOLL-Buchung kann in bestimmten Einzelf\u00e4llen bearbeitet werden, z.B. wenn sie \u00fcber die Einzelbuchungsmaske erzeugt wurde, noch keinen AO-Status besitzt und nicht aus einem Nebenbuch stammt. Wird in diesem Zusammenhang z.B. eine Kontierung angepasst und dabei eine vorhandene Freie Anordnung erkannt, wird der AO-Status automatisch korrekt auf \u201everbuchbar\u201c gesetzt.</p> <p>Behoben: 25.05.227 | Die Bearbeitung von IST-Buchungen mit Buchungsschl\u00fcssel 6xx und 7xx  funktioniert aus dem Buchungsstapel wieder korrekt. Es wird jetzt wieder das richtige Finanzrechnungskonto gepr\u00fcft, statt f\u00e4lschlich das ER-Konto ohne Produkt aus der OP-Buchungsstelle heranzuziehen.</p> <p>25.06.089 | Eine in der Einzelbuchungsmaske erfasste Zahlungsbuchung kann im Buchungsstapel wieder angepasst werden.</p> <p>25.06.091 | Beim Buchungsschl\u00fcssel 631 wurde die OP-Muster-Bildungsfunktion an der Einnahmeart \u00fcberarbeitet. Wird \u00fcber den E-Knopf an der OP-Buchungsstelle eine entsprechend konfigurierte Einnahmeart ausgew\u00e4hlt, werden die definierten Platzhalter wieder korrekt aufgel\u00f6st.</p> <p>25.07.104 | Beim Zur\u00fcckhalten von Buchungen in einem Buchungsstapel \u00fcber die Spalte \u201eZur\u00fcck\u201c wurde der Button \u201e\u00dcbernehmen\u201c bisher nicht sofort aktiviert. Erst nach einem Klick in eine andere Spalte wurde der Button aktiv. Dieses Verhalten wurde angepasst \u2013 der Button \u201e\u00dcbernehmen\u201c wird jetzt sofort aktiviert, sobald eine Buchung als \u201ezur\u00fcck\u201c markiert wird.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#36-anordnung","title":"36 - Anordnung","text":"<p>Neu: 25.06.144 | Beim Nachdruck einer Anordnung oder Anordnungsliste besteht jetzt die M\u00f6glichkeit, diesen ohne die bisherige Aufschrift \u201eZweitschrift\u201c durchzuf\u00fchren. Hierf\u00fcr wurde eine gleichnamige Vorlagenoption implementiert, die bei Bedarf aktiviert werden kann. Standardm\u00e4\u00dfig wird weiterhin \u201eZweitschrift\u201c ausgewiesen.</p> <p>Verbesserung:  25.05.171 | Der bisher frei zug\u00e4ngliche Button \u201eFreie AO\u201c wurde mit einem neuen virtuellen Recht versehen. F\u00fcr berechtigte Benutzer muss im Men\u00fc s21 - Benutzerverwaltung in den Men\u00fcrechten das Recht \u201e360 - Freie AO\u201c vergeben werden.</p> <p>25.06.145 | Es wurde eine M\u00f6glichkeit geschaffen, um vermeintliche L\u00fccken in der Vergabereihenfolge der Anordnungsnummern zu identifizieren. Diese Pr\u00fcfung findet sich im Men\u00fc 7331 - Kontenabstimmung und ist unter diesem im Folgenden detailliert beschrieben.</p> <p>Behoben: 25.04.093 | Der Druck der AO-\u00dcbersichtsliste ist wieder m\u00f6glich.</p> <p>25.05.163 | In den Men\u00fcpunkten 36 \u2013 Anordnung und 37 \u2013 Anordnungsfreigabe wurde ein reines Leserecht integriert. Die Konfiguration erfolgt wie gewohnt \u00fcber das Men\u00fc s21 \u2013 Benutzerverwaltung, wobei das Leserecht in den Men\u00fcrechten durch einen waagerechten Strich in der Checkbox dargestellt wird.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#391-personenkonten","title":"391 - Personenkonten","text":"<p>Neu: 25.07.059 | Zur Optimierung der \u00dcbersichtlichkeit werden unter der Kategorie \u201eObjekt\u201c ab sofort nur noch aktuelle Veranlagungsobjekte angezeigt \u2013 also solche ohne das Kennzeichen \u201eHistorisch\u201c. Damit wird die Darstellung relevanter Objekte klarer und gezielter auf die laufende Bearbeitung ausgerichtet. Erg\u00e4nzend wurde ein neues Merkmal \u201eAnmeldezeitraum\u201c eingef\u00fchrt. Dieses zeigt die am Objekt hinterlegten An- und Abmeldedaten an und erm\u00f6glicht so eine schnellere zeitliche Einordnung direkt in der \u00dcbersicht.</p> <p>Verbesserung: 25.05.103 | In der OP-\u00dcbersicht der Personenkontenauskunft steht eine neue Spalte \u201eIST-Versteuerung\u201c zur Verf\u00fcgung. Ist die Checkbox in dieser Spalte aktiviert, erfolgt die Umsatzsteuerf\u00e4lligkeit des jeweiligen Postens erst mit Zahlungseingang.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#392-sachkonten","title":"392 - Sachkonten","text":"<p>Behoben: 25.05.132 | Beim Druck des Journals direkt aus der Sachkontenauskunft in der Registerkarte \u201eBuchungen\u201c wird jetzt wieder das Eingangs- bzw. Valutadatum im Ausdruck mit ausgegeben.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#394-budgetubersicht","title":"394 - Budget\u00fcbersicht","text":"<p>Neu: 24.07.081 | In der Budget\u00fcbersicht stehen ab sofort drei neue Spalten zur Verf\u00fcgung, die bei Ertragskonten ber\u00fccksichtigt werden:</p> <ul> <li>Erf\u00fcllungsstand lfd. Jahr</li> <li>Erf\u00fcllungsstand Vorjahr</li> <li>Erf\u00fcllungsstand gesamt</li> </ul> <p>Der Erf\u00fcllungsstand zeigt an, in welchem Umfang der Planansatz bereits erf\u00fcllt ist: </p> <p>Beispiel:</p> <p>Liegt der Planansatz einer Buchungsstelle bei 10.000\u202fEUR und es wurden 1.000\u202fEUR gebucht, ergibt sich ein Erf\u00fcllungsstand von -9.000\u202fEUR. Werden anschlie\u00dfend weitere 11.000\u202fEUR gebucht, betr\u00e4gt der Erf\u00fcllungsstand 2.000\u202fEUR.</p> <p>Wurden Mittel aus dem Vorjahr \u00fcbertragen, wird der Erf\u00fcllungsstand Vorjahr im gleichnamigen Feld identisch berechnet. Der Erf\u00fcllungsstand gesamt ergibt sich als Summe aus Erf\u00fcllungsstand lfd. Jahr und Vorjahr.</p> <p>Verbesserung: 25.05.141 | In der Budget\u00fcbersicht wurde die Darstellung der Haushaltsjahre \u00fcberarbeitet. Im oberen Feld wird jetzt das aktuelle Haushaltsjahr angezeigt, das gleichzeitig angibt bis zu welchem Haushaltsjahr die Budget\u00fcbersicht abgerufen wird. Das darunterliegende Feld wurde in \u201eab Haushaltsjahr\u201c umbenannt und kann optional genutzt werden, um Auswertungen \u00fcber mehrere Haushaltsjahre hinweg zu erm\u00f6glichen.</p> <p>25.05.217 | Die Popup-Fenster in der Budget\u00fcbersicht k\u00f6nnen jetzt nicht mehr minimiert werden, wodurch Folgefehler vermieden werden.</p> <p>Behoben: 24.12.046 | Werden in den Bewirtschaftungsbuchungen, die \u00fcber die Spalte \u201eGebucht gesamt\u201c in der Budget\u00fcbersicht aufgerufen werden k\u00f6nnen, einzelne Zeilen markiert, so erscheint in der Spalte \u201eBuchungsbetrag\u201c ein Tooltip mit der Summe der markierten Zeilen. Hinweis: Die \u00fcbergeordnete Summenzeile ist von dieser Funktion ausgeschlossen und wird bei der Summenberechnung nicht ber\u00fccksichtigt.</p> <p>25.05.023 | Wird in der Budget\u00fcbersicht per Doppelklick auf das Feld \u201egebucht gesamt\u201c einer Buchungsstelle das Buchungsjournal aufgerufen, erfolgt die Anzeige jetzt wieder korrekt. Insbesondere bei Buchungen mit umsatzsteuerrechtlichem Tatbestand werden die Summen korrekt dargestellt: Der Buchungsbetrag entspricht dem gebuchten Nettobetrag, und das Feld Bruttobetrag weist diesen ebenfalls ordnungsgem\u00e4\u00df aus. Damit ist die Transparenz der Betr\u00e4ge im Journal wieder vollst\u00e4ndig gegeben.</p> <p>25.06.041 | Durch die Entfernung der bisherigen Sidebar-Funktionen \u201eZell- oder Zeilenmodus\u201c k\u00f6nnen die DMS-Dokumente in den Bewirtschaftungsbuchungen, die \u00fcber die Spalte \u201eGebucht gesamt\u201c in der Budget\u00fcbersicht aufgerufen werden k\u00f6nnen, jetzt unabh\u00e4ngig vom Fokus abgerufen werden.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":""},{"location":"aktuelles/release-notes/5.3.0.html#421-bearbeiten","title":"421 - Bearbeiten","text":"<p>Behoben: 25.07.096 | Der Stundungs-Ratenassistent wurde \u00fcberarbeitet. Die Bildung zus\u00e4tzlicher automatisierter Null-Raten wurde unterbunden, sodass jetzt nur noch sinnvolle Raten mit tats\u00e4chlichem Zahlungsanteil erzeugt werden.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#444-wertberichtigungsbearbeitung","title":"444 - Wertberichtigungsbearbeitung","text":"<p>Behoben: 25.07.079 | Im Reiter \u201eAnpassung Wertberichtigung\u201c ist es wieder m\u00f6glich, gezielt nach einem bestimmten Personenkonto zu suchen. Zudem wurde die Mehrfachauswahl bei Personenkonten korrigiert, sodass jetzt wieder alle ausgew\u00e4hlten Personenkonten korrekt \u00fcbernommen werden.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#4b-mitteilungsverordnung","title":"4b - Mitteilungsverordnung","text":"<p>Neu: 25.03.017 | Im Rahmen der Mitteilungsverordnung wurden wichtige Anpassungen vorgenommen, um die Prozesse zwischen Datenpflege und Meldung zu unterscheiden und die Maske zum \u00dcberblick der Daten zur Mitteilungsverordnung klarer zu strukturieren und die Bedienbarkeit zu verbessern. Die wichtigsten Anpassungen sind nachfolgend zusammengefasst:</p> <ol> <li> <p>Zur besseren funktionalen Trennung zwischen der Datenpflege und der Meldung wurden zwei neue Men\u00fcpunkte eingef\u00fchrt:</p> <ul> <li>4b1 - \u00dcbersicht: Anzeige und Bearbeitung der relevanten OP-Daten zur Mitteilungsverordnung</li> <li>4b2 - ELSTER Schnittstelle: Versand der Meldungen an das Finanzamt Hinweis: Details zur Anwendung und Berechtigung inkl. eines Schulungsvideos werden in einem separaten Versionsstand bekannt gegeben. Eine entsprechende Information wird zum gegebenen Zeitpunkt zur Verf\u00fcgung gestellt.</li> </ul> </li> <li> <p>Im Rahmen der Datenpr\u00fcfung kann es vorkommen, dass Personenstammdaten unvollst\u00e4ndig sind, was einen Versand der Meldung an das Finanzamt verhindert. Um diesen F\u00e4llen fr\u00fchzeitig zu begegnen, wurden folgende Neuerungen eingef\u00fchrt:  </p> <ol> <li>Nach Auswahl eines Datensatzes in der \u00dcbersicht wird die Funktion \u201ePersonenkonto bearbeiten\u201c in der Toolbar aktiv. Ein separater Aufruf der Personenkontenverwaltung ist somit nicht mehr erforderlich. Der Aufruf erfolgt unter Ber\u00fccksichtigung der Men\u00fcberechtigungen und abh\u00e4ngig vom Schalter F09 \u2013 \u201eEindeutige Person verwenden\u201c, der festlegt, ob in das Men\u00fc 12a3 - Personenkontenverwaltung oder in 128 - Adressverwaltung verzweigt wird. Zudem wird automatisch das zugeh\u00f6rige Personenkonto vorausgew\u00e4hlt.  </li> <li>Personendaten die zwingend gepflegt werden m\u00fcssen, weil diese an das Finanzamt geliefert werden, sind die Steuer-ID bzw. Steuernummer, das Geburtsdatum und der Name. Um nicht erst beim Versand der Meldung festzustellen was fehlt, ist neben der neuen Spalte \"Steuer-ID\" eine weitere Spalte \"Status Personendaten\" integriert worden. Hier sind Hinweise auf fehlende Stammdatenangaben (Fehlender Vorname, fehlendes Geburtsdatum) zu finden.</li> <li>F\u00fcr Kreditoren, die eine Gemeinn\u00fctzigkeitsbescheinigung haben, ist diese im Personenkonto zu hinterlegen. Eine solche Bescheinigung unterliegt einer Befristung, was zu einer eventuellen Meldung mitteilungspflichtiger Zahlungen f\u00fchrt. Zur besseren \u00dcbersicht und Kontrolle wurde ein zus\u00e4tzliches Panel \u201eGemeinn\u00fctzigkeitsbescheinigung\u201c integriert. Ist die Bescheinigung im DMS abgelegt, kann sie direkt \u00fcber dieses Panel aufgerufen werden.</li> </ol> </li> <li> <p>Zur besseren Verst\u00e4ndlichkeit der OP-Klassifizierung im Zusammenhang mit der Mitteilungsverordnung wurden die Bezeichnungen im Feld \u201eMV-Status\u201c angepasst. Statt der bisherigen Bezeichnungen wird jetzt unterschieden zwischen:  </p> <ul> <li>\u201eOPs mit MV-Informationen\u201c</li> <li>\u201eOPs ohne MV-Informationen\u201c  </li> </ul> <p>Dies erleichtert die Einsch\u00e4tzung, ob f\u00fcr einen offenen Posten relevante Meldedaten vorhanden sind.</p> </li> <li> <p>In der \u00dcbersicht werden k\u00fcnftig standardm\u00e4\u00dfig sowohl Rechnungen (Sollstellungen) als auch Zahlungen angezeigt, um alle relevanten Buchungen im Zusammenhang mit der Mitteilungsverordnung sichtbar zu machen. Da dies zu einer erh\u00f6hten Datenmenge und potenzieller Un\u00fcbersichtlichkeit f\u00fchren kann, wurde eine neue Filterfunktion integriert:  </p> <ul> <li>Die Checkbox \u201enur Zahlungsbuchungen anzeigen\u201c ist standardm\u00e4\u00dfig aktiviert, kann aber bei Bedarf deaktiviert werden. So l\u00e4sst sich die Ansicht gezielt auf zahlungsrelevante Buchungen einschr\u00e4nken.  </li> </ul> </li> <li> <p>Zur besseren Nachverfolgbarkeit des Versandstatus wurde die Spalte \u201eMeldungsstatus\u201c erg\u00e4nzt. In dieser Spalte ist ersichtlich, ob bereits eine Meldung zum OP erstellt oder versendet wurde. Auch der Status \u201enoch keine Meldung erstellt\u201c wird angezeigt, was die \u00dcbersicht \u00fcber den Bearbeitungsstand deutlich verbessert.   </p> </li> </ol> <p></p> <p>Behoben: 25.05.019 | Die Einschr\u00e4nkung des Haushaltsjahres in der \u00dcbersicht zur Mitteilungsverordnung wirkt sich jetzt auch auf die Anzeige der Offenen Posten aus, sodass nur noch Posten des gew\u00e4hlten Haushaltsjahres angezeigt werden.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":""},{"location":"aktuelles/release-notes/5.3.0.html#51-auftragsverwaltung","title":"51 - Auftragsverwaltung","text":"<p>Behoben: 25.08.106 | Das L\u00f6schen nicht mehr ben\u00f6tigter Musterauftr\u00e4ge wurde \u00fcberarbeitet und erfolgt jetzt unter Wahrung der Datenintegrit\u00e4t, sodass alle zugeh\u00f6rigen Informationen konsistent und vollst\u00e4ndig aus der Datenbank entfernt werden.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#52-eingangsrechnungsjournal","title":"52 - Eingangsrechnungsjournal","text":"<p>Verbesserung: 25.03.056 | Im Eingangsrechnungsjournal wurde in der Tabellen\u00fcbersicht ein zus\u00e4tzlicher tempor\u00e4rer Status \u201eerfasst (unvollst\u00e4ndig)\u201c eingef\u00fchrt. Dieser Status ist nicht \u00fcber die allgemeinen Auswahl-Statusfilter ausw\u00e4hlbar, sondern ausschlie\u00dflich in der Tabelle sichtbar und dort bei Bedarf \u00fcber den Spaltenfilter selektierbar.</p> <p>Dieser neue Status dient der Kennzeichnung von Eingangsrechnungen, welche noch unvollst\u00e4ndig sind \u2013 entweder weil Pflichtangaben fehlen oder der Gesamtbetrag nicht mit der Summe der erfassten Positionsbetr\u00e4ge \u00fcbereinstimmt.</p> <p>25.06.110 | Wird im Eingangsrechnungsjournal eine Position mit Bezug zu einem Auftrag angelegt, wird der Buchungstext 2 bislang automatisch aus dem Auftrag \u00fcbernommen. Mit dieser Erweiterung ist es jetzt zus\u00e4tzlich m\u00f6glich, den \u00fcbernommenen Buchungstext 2 vollst\u00e4ndig zu entfernen. Bisher konnte der Text lediglich \u00fcberschrieben oder angepasst werden \u2013 eine vollst\u00e4ndige L\u00f6schung war nicht vorgesehen.</p> <p>25.07.002 | \u00dcber die DMS-Dokumentenvorschau k\u00f6nnen k\u00fcnftig auch zus\u00e4tzliche Anlagen eines Dokuments angezeigt werden.</p> <p>Behoben: 25.04.072 | Der Fehler \u201eObject reference not set to an instance\u201c behoben. Dieser trat auf, wenn der Rechnungspositionsbetrag exakt dem verbleibenden Auftragswert entsprach und somit ein Schlussabruf ausgel\u00f6st wurde.</p> <p>25.05.156 | Wird im Eingangsrechnungsjournal (ERJ) eine einzelne Rechnungsposition gel\u00f6scht, bleibt der zugeh\u00f6rige Labeltext zur Checkbox \u201eSperre\u201c jetzt korrekt erhalten und wird nicht mehr irrt\u00fcmlich ausgeblendet.</p> <p>25.08.050 | Eingangsrechnungen, welche ausschlie\u00dflich Kopfdaten enthielten und keine Positionsangaben, konnten nicht korrekt weitergeleitet werden. Dieses Problem trat ausschlie\u00dflich in Verbindung mit dem von SASKIA.H2R verwendeten Datenbanksystem Oracle Database auf.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#54-ausgangsrechnungsjournal","title":"54 - Ausgangsrechnungsjournal","text":"<p>Verbesserung: 22.06.152 | Im Ausgangsrechnungsjournal kann bei der Erfassung von Buchungen jetzt wieder direkt ein Zahlweg ausgew\u00e4hlt werden. Wird ein Zahlweg angegeben, so wird dieser beim Druck der Rechnung verwendet. Ist kein Zahlweg hinterlegt, greift das System auf den Standard-Zahlweg des Mandanten zur\u00fcck. F\u00fcr die Verwendung im Druck steht der Platzhalter {SMBankname} zur Verf\u00fcgung, mit dem der Zahlweg flexibel eingebunden werden kann.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#55-stammdaten","title":"55 - Stammdaten","text":"<p>Verbesserung: 25.08.060 | Das Feld \u201eMenge\u201c wird auf der Rechnung im Ausgangsrechnungsjournal jetzt in genau der Anzahl an Nachkommastellen dargestellt, wie sie bei der Eingabe verwendet wurde (max. 4 Nachkommastellen). Abschlie\u00dfende Nullen werden bei der Anzeige automatisch entfernt, um eine klarere und \u00fcbersichtlichere Darstellung der Mengenangaben auf der Rechnung zu gew\u00e4hrleisten.</p> <p>Behoben: 25.04.062 | Die Tarifauswahl im Grid w\u00e4hlt jetzt korrekt den ge\u00e4nderten Tarif aus, wodurch das unwillk\u00fcrliche Springen beim Anlegen von Tarifgruppen/Tarifen behoben wurde. Au\u00dferdem bleibt das Zuordnungsfeld beim Bl\u00e4ttern zu n\u00e4chsten Seiten ge\u00f6ffnet.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#6-auswertungen","title":"6 - Auswertungen","text":""},{"location":"aktuelles/release-notes/5.3.0.html#66xx-vorschlags-und-op-listen","title":"66xx - Vorschlags- und OP-Listen","text":"<p>Verbesserung: 25.08.073 | Beim Erstellen einer Vorschlagsliste \u00fcber den Button \u201eVorschlag aus OP-Liste erstellen\u201c wurde eine Fortschrittsanzeige integriert. Diese zeigt den Verarbeitungsfortschritt in Echtzeit an und sorgt insbesondere bei umfangreichen Datenmengen f\u00fcr bessere Transparenz hinsichtlich der laufenden Programmaktivit\u00e4t. Benutzer k\u00f6nnen so jederzeit nachvollziehen, dass der Vorgang aktiv verarbeitet wird.</p> <p>Behoben: 25.05.136 | Das Markieren und Demarkieren von Einzelpositionen funktioniert wieder wie vorgesehen in den Vorschlagslisten.</p> <p>25.05.222 | Der Button \u201eOP-Historie\u201c vergr\u00f6\u00dferte bisher beim Bet\u00e4tigen den rechten Seitenbereich. Die Gr\u00f6\u00dfe des Arbeitsbereichs bleibt jetzt unver\u00e4ndert, unabh\u00e4ngig davon, ob die der Button \u201eOP-Historie\u201c bet\u00e4tigt wird.</p> <p>25.06.105 | In den Vorschlagslisten ist das Duplizieren von Buchungstexten wieder m\u00f6glich.</p> <p>25.06.126 | In bestimmten Konstellationen kam es in Einzelf\u00e4llen zu einem Fehler bei der Anzeige der OP-Listen: Die Anschrift des Debitors wurde f\u00e4lschlicherweise als Datumswert interpretiert. Dieses Verhalten trat ausschlie\u00dflich bei Debitoren mit einem Auslandskennzeichen auf. Das Problem wurde behoben \u2013 die Anschrift wird jetzt korrekt dargestellt.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#6611-op-listen","title":"6611 - OP-Listen","text":"<p>Behoben: 25.06.125 | Die Mehrfachauswahl bei Personenkonten wurde korrigiert, sodass jetzt wieder alle ausgew\u00e4hlten Personenkonten korrekt \u00fcbernommen werden.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#6614-mahnvorschlag","title":"6614 - Mahnvorschlag","text":"<p>Verbesserung: 25.05.126 | Die Ausgabe objektbezogener Informationen zu einem Grundsteuerobjekt auf dem Mahnbescheid und dem PK-Kontoauszug wurde erweitert. Bisher wurde im Rahmen einer entsprechenden Elster-Meldung lediglich die Nummer des verwendeten Schl\u00fcssels angezeigt, wenn die zugrunde liegende Einnahmeart daf\u00fcr eingerichtet war. Ab sofort wird neben der Schl\u00fcsselnummer auch die zugeh\u00f6rige Bedeutung des Schl\u00fcssels ausgegeben.  </p> <p>Beispiel:</p> <p>Elster_Grundst\u00fccksart: 3 \u2013 Mietwohngrundst\u00fcck</p> <p>25.08.185 - Im Rahmen der Einzugserm\u00e4chtigung unterhalb des Passus \u201eSEPA-Lastschriftmandat\u201c wurde eine sprachliche Anpassung vorgenommen:</p> <ul> <li>Bisheriger Text: \u201eIch erm\u00e4chtige die [Name der Verwaltung] \u2026\u201c</li> <li>Neuer Text: \u201eIch erm\u00e4chtige die/den [Name der Verwaltung] \u2026\u201c</li> </ul> <p>Behoben: 25.04.103 | Die Funktion \u201eNF neu\u201c wurde reaktiviert. Damit ist es wieder m\u00f6glich, Nebenforderungen neu zu berechnen.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#6225-infoschreiben","title":"6225 - Infoschreiben","text":"<p>Behoben: 25.06.001 | Das Infoschreiben kann jetzt auch dann erzeugt werden, wenn Reporttextbausteine fehlen. In diesem Fall erscheint auf dem Report der Hinweis \u201eTextbaustein(RTB_?) nicht definiert\u201c. Dies weist darauf hin, dass die entsprechenden Textbausteine im Men\u00fc 1y1 hinterlegt werden m\u00fcssen.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#663-op-listen-stichtag","title":"663 - OP-Listen Stichtag","text":"<p>Behoben: 25.04.066 | Der Druck der OP-Stichtagsliste ist wieder m\u00f6glich, auch wenn keine Einschr\u00e4nkungen getroffen wurden.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#671-umsatzsteuerjournal","title":"671 - Umsatzsteuerjournal","text":"<p>Verbesserung: Im Journal wurden die Registerkarte \"Steuerbuchungsrecherche\" und \"Umsatzsteuerjournal\" getauscht. Inhaltlich hat dies keine Auswirkungen.</p> <p>25.07.108 | Die Spalte \u201eUST. Meldung\u201c zeigt an, ob und in welcher Form eine Buchung dem Finanzamt gemeldet wurde \u2013 also \u00fcber die Umsatzsteuervoranmeldung (VA), die Umsatzsteuerjahresmeldung (JA) oder beide. Folgende Eintr\u00e4ge k\u00f6nnen jetzt in der Spalte \u201eUST. Meldung\u201c erscheinen:</p> <ul> <li>\u201ekeine\u201c \u2013 Die Buchung ist in keiner Meldung enthalten.</li> <li>\u201eVA\u201c \u2013 Die Buchung ist in einer Umsatzsteuervoranmeldung ber\u00fccksichtigt.</li> <li>\u201eJA\u201c \u2013 Die Buchung ist in einer Umsatzsteuerjahresmeldung ber\u00fccksichtigt.</li> <li>\u201eVA / JA\u201c \u2013 Die Buchung wurde sowohl in der Voranmeldung als auch in der Jahresmeldung verarbeitet.  </li> </ul> <p>Diese Erweiterung erm\u00f6glicht eine bessere Nachvollziehbarkeit der gemeldeten Buchungen und unterst\u00fctzt insbesondere bei der Analyse von Differenzen auf dem Umsatzsteuerverrechnungskonto, etwa dann, wenn sich Abweichungen zwischen Buchungssummen und gemeldeten Betr\u00e4gen ergeben \u2013 auch \u00fcber den Jahreswechsel hinweg.</p> <p>25.08.084 | Die Spalte \u201eUST-VA\u201c in der Steuerbuchungsrecherche wurde in \u201eUST. Meldung\u201c umbenannt, um die Bezeichnung klarer und verst\u00e4ndlicher zu gestalten.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#672-meldung","title":"672 - Meldung","text":"<p>Verbesserung: Ab sofort ist das Verschieben einer Buchung in eine andere Steuerperiode m\u00f6glich. Dabei ist zwingend ein Freitext anzugeben, da es sich um keinen Standardsachverhalt handelt und dieser Vorgang im Rahmen einer Steuerpr\u00fcfung gesondert zu beachten ist.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#68-freie-auswertungen","title":"68 - Freie Auswertungen","text":"<p>Neu: 25.02.032 | Zur visuellen Aufbereitung der eingegebenen Quoten pro Produkt und Periode steht ab sofort in den freien Auswertungen die neue Auswertung \u201eFQ2600\u201c zur Verf\u00fcgung. Diese unterst\u00fctzt eine gezielte Analyse der Verteilquoten \u00fcber definierte Zeitr\u00e4ume hinweg.</p> <p>25.08.016 | Die neue Freie Auswertung FQ6020 \u2013 Pr\u00fcfliste Jahresrechnungsstatistik wurde bereitgestellt. Diese Auswertung \u00fcberpr\u00fcft unzul\u00e4ssig gebuchte Kombinationen im Zusammenhang mit der Erstellung der Jahresrechnungsstatistik.</p> <p>Behoben: 25.06.069 | Im gesetzlichen Muster FS7001 wird das Datum wieder korrekt angezeigt.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#69-auswertungszentrale-ehem-gesetzliche-drucklisten","title":"69 - Auswertungszentrale (ehem. Gesetzliche Drucklisten)","text":"<p>Neu: 25.02.073 | In der Auswertungszentrale stehen zahlreiche Berichte zur Verf\u00fcgung, die entsprechend der individuell gew\u00e4hlten Einstellungen abgerufen werden k\u00f6nnen. Ab sofort besteht die M\u00f6glichkeit, die gesetzten Filterkriterien als Vorlage zu speichern, um wiederkehrende Eingaben zu vermeiden und den Arbeitsablauf zu optimieren.</p> <p>Beispiel:</p> <p>Wird regelm\u00e4\u00dfig die Auswertung \u201eAuftr\u00e4ge\u201c produktbezogen \u00fcber mehrere Quellkonten hinweg durchgef\u00fchrt, mussten bislang nach jedem Druck erneut die Felder \u201eProdukt von\u201c und \u201eProdukt bis\u201c gesetzt werden. Mithilfe der neuen Vorlagenfunktion kann diese Einstellung jetzt gespeichert und bei Bedarf direkt wiederverwendet werden.</p> <p>Vorgehensweise zur Erstellung einer Vorlage:</p> <ol> <li>Gew\u00fcnschten Bericht ausw\u00e4hlen</li> <li>Filterkriterien setzen</li> <li>Im Feld \u201eVorlage\u201c (oben rechts) einen Namen vergeben</li> <li>Vorlage speichern</li> </ol> <p>Verf\u00fcgt der Benutzer \u00fcber die Berechtigung \u201eglobale Tabellenansichten\u201c, kann beim Speichern zus\u00e4tzlich gew\u00e4hlt werden, ob die Vorlage nur nutzerspezifisch oder f\u00fcr alle Anwender freigegeben werden soll. Der Abruf gespeicherter Vorlagen ist jederzeit \u00fcber das Feld \u201eVorlagen\u201c m\u00f6glich, wodurch ein schneller und effizienter Zugriff auf h\u00e4ufig verwendete Auswertungskonfigurationen sichergestellt ist.</p> <p>25.05.027 | Die Auswertungszentrale in SASKIA.H2R bietet bereits eine Vielzahl an Berichten, die zentral \u00fcber den Men\u00fcpunkt 69 aufgerufen werden k\u00f6nnen. Um gezielt zur gew\u00fcnschten Auswertung zu gelangen, steht im oberen Bereich ein Filterfeld zur Verf\u00fcgung. Hier kann die Bezeichnung des Berichts \u2013 oder ein Teil davon \u2013 eingegeben werden. Die Anzeige der verf\u00fcgbaren Berichte wird daraufhin entsprechend eingeschr\u00e4nkt. Zum Beispiel zeigt die Eingabe von \u201eSach\u201c alle Berichte an, die diesen Begriff in der Bezeichnung tragen \u2013 einschlie\u00dflich des zugeh\u00f6rigen Hierarchieknotens mit allen untergeordneten Berichten. Da zunehmend auch Auswertungen, die zuvor in SASKIA.de-IFR \u00fcber eigene Men\u00fcpunkte aufgerufen wurden, in die Auswertungszentrale \u00fcberf\u00fchrt werden, besteht jetzt eine zus\u00e4tzliche Aufrufm\u00f6glichkeit: \u00dcber die \u00fcbergreifende Suche kann zun\u00e4chst die Auswertungszentrale (z.B. durch Eingabe \u201e69\u201c) ge\u00f6ffnet und anschlie\u00dfend direkt die Bezeichnung des gew\u00fcnschten Berichts (z.B. \u201e6212\u201c oder \u201eSachkontenauszug\u201c) eingegeben werden. Die Anzeige wird daraufhin automatisch auf den entsprechenden Bericht gefiltert, was den Zugriff auf bekannte Auswertungen deutlich erleichtert.</p> <p>Verbesserung: In den gesetzlichen Mustern f\u00fcr die Gesamt- und Teilfinanz- sowie Ergebnisrechnung des Bundeslands Sachsen wurde die \u00dcberschrift der Spalte 5 angepasst. Die \u00dcberschrift wurde um das Wort \u201efortgeschriebener\u201c erg\u00e4nzt, um den gesetzlichen Anforderungen zu entsprechen.</p> <p>25.02.142 | F\u00fcr das Bundesland Brandenburg wurde die Liste der \"Finanzrechnung\" entsprechend den aktuellen landesspezifischen Vorgaben \u00fcberarbeitet und steht nun in angepasster Form zur Verf\u00fcgung. Die \u00c4nderungen betreffen das Muster 5.4 zu \u00a7\u202f5 i.\u202fV.\u202fm. \u00a7\u202f11 KomHKV und beziehen sich auf den Finanzhaushalt sowie die mittelfristige Finanzplanung. </p> <p>25.07.088 | Die Fehlermeldung beim Druck der Druckliste \u201eM31 Anlagennachweis\u201c wurde behoben. Der Ausdruck der Liste ist jetzt wieder problemlos m\u00f6glich.</p> <p>Behoben: 25.05.045 | Der Druck des Sachkontenauszugs erfolgt wieder korrekt anhand der eingestellten Filterkriterien. Zuvor ignorierte Filtereinstellungen werden jetzt ordnungsgem\u00e4\u00df ber\u00fccksichtigt.</p> <p>25.05.052 | Beim Druck einer Liste in einem bereits abgeschlossenen Haushaltsjahr erscheint keine Fehlermeldung mehr. Die Pr\u00fcfung wurde dahingehend \u00fcberarbeitet.</p> <p>25.07.074 | Der Schalter F51 \u2013 \"Verbindlichkeits\u00fcbersicht gem\u00e4\u00df \u00a7\u202f54 Abs.\u202f2 und 3 S\u00e4chsKomHVO nach VwV KomHSys Abschnitt IV. Nr.\u202f3\" wurde hinsichtlich der Laufzeitberechnung \u00fcberarbeitet. Steht der Schalter auf \u201eJa\u201c, beeinflusst er jetzt die Einordnung der Kredite in der Verbindlichkeits\u00fcbersicht dahingehend, dass kurzfristige Verbindlichkeiten von bis zu einem Jahr korrekt zugeordnet werden.</p> <p>Beispiel:</p> <p>Im Jahr 2019 wurde ein Kredit aufgenommen, dessen Laufzeit bis Ende 2020 geht. Erfolgt der Druck der Verbindlichkeits\u00fcbersicht zum Abschluss 2019, so wurde bisher die verbleibende Restschuld in die Kategorie \u201e1\u20135 Jahre\u201c eingeordnet, wenn der Schalter F51 auf \"Ja\" stand. Zuk\u00fcnftig wird diese Restschuld korrekt der Kategorie \u201ebis zu einem Jahr\u201c zugewiesen, da das Restjahr 2020 als kurzfristige Verbindlichkeit zu behandeln ist.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#7-jahresabschluss","title":"7 - Jahresabschluss","text":""},{"location":"aktuelles/release-notes/5.3.0.html#7331-kontenabstimmung","title":"7331 - Kontenabstimmung","text":"<p>Neu: 25.06.145 | Die Kontenabstimmung wurde um den Reiter \u201eAO\u2019s ohne Belegbezug\u201c erweitert. Diese Pr\u00fcfung identifiziert Anordnungsnummern, die innerhalb eines Haushaltsjahres in der Reihenfolge fehlen und keinem Belegbezug haben. Technologisch bedingt k\u00f6nnen solche \u201eL\u00fccken\u201c auftreten, ohne dass ein tats\u00e4chlicher Fehler vorliegt. Die Pr\u00fcfung dient daher ausschlie\u00dflich der Dokumentation und stellt keinen Fehler im Sinne der Auswertung dar. Hinweis: Werden L\u00fccken identifiziert lautet die Meldung: \u201eAnordnung xxx ist nicht vorhanden und hat keinen Belegbezug.\u201c</p>"},{"location":"aktuelles/release-notes/5.3.0.html#72-kassenjahreswechsel","title":"72 - Kassenjahreswechsel","text":"<p>Verbesserung: 25.05.024 | Die Feldgr\u00f6\u00dfe zur Eingabe des Datums f\u00fcr den Kassenjahreswechsel wurde erweitert. Dadurch ist jetzt die gesamte Jahreszahl wieder vollst\u00e4ndig sichtbar, was die Lesbarkeit und Bedienbarkeit verbessert.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#8-veranlagung","title":"8 - Veranlagung","text":""},{"location":"aktuelles/release-notes/5.3.0.html#81-einzelveranlagung","title":"81 - Einzelveranlagung","text":"<p>Verbesserung: 25.05.240 | Bei der Neuerfassung von Berechnungsgrundlagen (Tarifzeilen) erfolgt jetzt ein automatischer Abgleich mit den Datumsangaben aus dem Hauptobjekt (z.B. An- und Abmeldedatum). Sofern dies in der Stammdatenkonfiguration der jeweiligen Einnahmeart vorgesehen ist, werden die relevanten Daten, wie z.B. das Abmeldedatum eines Hundes, automatisch als Bis-Datum in die Tarifzeile der Veranlagung \u00fcbernommen. Diese Funktion stellt sicher, dass die tarifliche Veranlagung wieder korrekt mit den Objektlaufzeiten abgeglichen wird und dadurch manuelle Eingaben reduziert sowie potenzielle Fehlerquellen minimiert werden.</p> <p>Behoben: 25.05.005 | Beim Arbeiten mit Unterobjekten ist es wieder m\u00f6glich, bei der Erfassung der Jahreswechselwerte \u00fcber eine Auswahlbox ein Unterobjekt zu hinterlegen.</p> <p>25.05.115 | Die Logik zur Anlage von Jahreswechselwerten wurde \u00fcberarbeitet, um eine konsistente Datenpflege sicherzustellen. Ab sofort ist es nicht mehr m\u00f6glich, Tarifzeilen f\u00fcr ein Folgejahr anzulegen, wenn f\u00fcr die entsprechende Einnahmeart noch keine Tarife f\u00fcr dieses Steuerjahr hinterlegt sind. Durch diese Anpassung wird verhindert, dass es zu Folgefehlern oder Fehlermeldungen bei der Verarbeitung kommt. Die Eingabe bleibt damit systematisch korrekt und stabil.</p> <p>25.05.192 | Bei \u00c4nderungsveranlagungen, die durch eine r\u00fcckwirkende Objektabmeldung zum Vorjahr ausgel\u00f6st werden (z.B. in der Hundesteuer zum 31.12. des Vorjahres), erfolgt jetzt wieder eine Warnung in der Maske Neu/\u00c4nderungen, sofern die Option \u201eObjektabmeldedatum ignorieren\u201c nicht gesetzt ist. Hintergrund: Fehlt dieses H\u00e4kchen bei r\u00fcckwirkenden Abmeldungen, wird der Zeitraum nach dem Abmeldedatum bei der Berechnung nicht mehr ber\u00fccksichtigt. Infolgedessen bleiben vorhandene Festsetzungen bestehen und werden nicht auf 0 gesetzt, obwohl dies in solchen F\u00e4llen fachlich erforderlich w\u00e4re. Durch die eingef\u00fchrte Warnmeldung wird sichergestellt, dass auf das fehlende Setzen der Option hingewiesen wird, um fehlerhafte oder unvollst\u00e4ndige Veranlagungen zu vermeiden.</p> <p>25.05.237 | Beim Neuerfassen oder Bearbeiten der Grundsteuer kam es bei einigen Kunden, abh\u00e4ngig von der Konfiguration in den Einnahmeartenstammdaten, zu einem Darstellungsproblem: Das Feld zur Eingabe des Datums des Finanzamtsbescheids war teilweise zu klein, sodass das eingegebene Datum nicht vollst\u00e4ndig sichtbar war. Dieses Anzeigeverhalten wurde \u00fcberarbeitet. Das Feld passt sich jetzt entsprechend an, sodass das Datum in allen F\u00e4llen vollst\u00e4ndig und korrekt dargestellt wird.</p> <p>25.05.238 | Die Nutzung von Suchfeldern mit Auswahlfunktion ist wieder m\u00f6glich ohne dass es zu einer Fehlermeldung kommt. </p> <p>25.07.067 | Die Funktion der Sonderkorrektur bei der Verwendung von Sammeleinnahmearten steht wieder wie gewohnt zur Verf\u00fcgung.</p> <p>25.08.003 | Beim Hinzuf\u00fcgen einer weiteren Jahresscheibe zu einer bereits begonnenen Mehrjahres-Veranlagung kam es in bestimmten Konstellationen zu einem schwerwiegenden Fehler: Bei der \u00dcbernahme der neuen Jahresscheibe wurde die zugeh\u00f6rige Tarifzeile des Vorg\u00e4ngerbescheids (sofern vorhanden) versehentlich aus der Datenbank gel\u00f6scht. Die Veranlagung war nach der ersten Speicherung und dem Verlassen der Erfassungsmaske zun\u00e4chst noch korrekt. Bei einer erneuten Bearbeitung der Veranlagung fehlten jedoch die notwendigen Berechnungsgrundlagen, was in der Folge zu Buchungsfehlern f\u00fchrte. Eine Weiterverarbeitung der Mehrjahres-Veranlagung war dadurch nicht mehr m\u00f6glich. Dieses fehlerhafte Programmverhalten wurde behoben, sodass die Tarifzeilen der Vorg\u00e4ngerbescheide nun vollst\u00e4ndig erhalten bleiben und damit eine fehlerfreie Bearbeitung und Weiterverarbeitung der Veranlagung gew\u00e4hrleistet ist.</p> <p>25.08.093 | Der Druck bzw. Nachdruck von korrigierten Zinsbescheiden nach neuem Recht ist wieder m\u00f6glich, ohne das eine Fehlermeldung erscheint.</p> <p>25.08.181 | Bei der Erfassung von Veranlagungen \u00fcber die Funktion \u201eNeuerfassen/Bearbeiten\u201c kam es in einigen F\u00e4llen zu Problemen, wenn die \u201e+\u201c-Schaltfl\u00e4che mehrfach f\u00fcr ein bereits berechnetes Steuerjahr genutzt wurde. Diese Problematik f\u00fchrte dazu, dass nach Abschluss der Erfassung mehrere berechnete Veranlagungen f\u00fcr dasselbe Steuerjahr sichtbar waren. Das zugrunde liegende Problem wurde behoben indem eine Mehrfacherfassung f\u00fcr bereits berechnete Steuerjahre nun programmseitig ausgeschlossen ist. Zus\u00e4tzlich erfolgt nun ein optischer Hinweis, falls w\u00e4hrend einer begonnenen Veranlagung erneut die +-Schaltfl\u00e4che f\u00fcr ein bereits berechnetes Steuerjahr bet\u00e4tigt wird: In diesem Fall wird an der Schaltfl\u00e4che ein rotes Ausrufezeichen ! eingeblendet, um auf den m\u00f6glichen Fehler hinzuweisen.</p> <p>25.08.180 | Beim Bearbeiten einer bereits begonnenen (berechneten) Veranlagung und dem nachtr\u00e4glichen Hinzuf\u00fcgen weiterer Jahresscheiben kam es zu einem Fehler: F\u00fcr die neu hinzugef\u00fcgten Steuerjahre wurden die Berechnungsgrundlagen (Tarifzeile) aus dem jeweils vorangegangenen Bescheid (sofern vorhanden) nicht \u00fcbernommen. Infolgedessen fehlte der bisher festgesetzte Sollbetrag, was dazu f\u00fchrte, dass der zu buchende Sollbetrag im \u00c4nderungsbescheid in diesen Steuerjahren fehlerhaft berechnet wurde. Dieses Problem wurde behoben, indem ab sofort bei der Veranlagung alle bisherigen Berechnungsgrundlagen korrekt ausgewiesen werden, sodass der Sollbetrag bei \u00c4nderungsbescheiden wieder richtig ermittelt wird.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#841-aufkommen","title":"841 - Aufkommen","text":"<p>Behoben: 25.05.241 | Der Filter auf die Haushaltsjahre wurde bislang nicht korrekt vom Programm angewendet. Dieses Problem wurde behoben, sodass die Anzeige jetzt den in den Suchfeldern angegebenen Haushaltsjahren des Bearbeiters entspricht.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#843-objektdaten","title":"843 - Objektdaten","text":"<p>Verbesserung: 25.05.062 | Im Men\u00fcpunkt 843 \u2013 Auswertungen wurden verschiedene kleinere Probleme im Zusammenhang mit der Bedienung sowie dem Auswertungsergebnis behoben und Verbesserungen umgesetzt:</p> <ul> <li>Schaltfl\u00e4che \u201eAbfrage \u00e4ndern\u201c entfernt: Der Wechsel zwischen Abfragedefinition und Abfrageergebnis erfolgt nun \u00fcber die neue Schaltfl\u00e4che mit einem Pfeil nach links, da die bisherige Nutzung der Schaltfl\u00e4che \u201eAbfrage \u00e4ndern\u201c in der Ergebnissicht unbeabsichtigt zum Verlassen des Men\u00fcpunktes f\u00fchrte.</li> <li>Druckfunktion \u00fcberarbeitet: Die Funktion zum Drucken des Abfrageergebnisses wurde angepasst, da es in bestimmten Konstellationen zu Fehlern oder Ausf\u00e4llen beim Ausdruck kam.</li> <li>Anzeigeposition der Datensatzanzahl verbessert: Die ermittelte Datensatzanzahl wird nun zentriert im oberen Bereich der Maske angezeigt, um die \u00dcbersichtlichkeit zu erh\u00f6hen.</li> <li>Korrektur bei der Nutzung bestimmter Auswertungsvorlagen: Die Speicherung von Auswertungsvorlagen wurde \u00fcberarbeitet. Bisher kam es bei Vorlagen, die gleichnamige Felder aus unterschiedlichen Kategorien enthielten, zu fehlerhaften Positionsangaben in der Auswertungsdefinition.</li> </ul> <p>Bitte beachten: Sollten in Ihrer Verwaltung betroffene Auswertungsvorlagen im Einsatz sein, wird empfohlen, diese mit dem Release 5.3.0 neu zu erstellen und die bisherigen fehlerhaften Vorlagen zu l\u00f6schen.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#86x-meldungen","title":"86x - Meldungen","text":"<p>Neu: 25.06.033 | In der Detailansicht einer Grundsteuermeldung bzw. Gewerbesteuermeldung steht jetzt eine neue Funktion zur Verf\u00fcgung: \u00dcber eine zus\u00e4tzliche Schaltfl\u00e4che mit Drucker-Symbol, die im Register \u201eGRDS-Meldung bearbeiten\u201c bzw. \u201eGWST-Meldung bearbeiten\u201c rechts neben den Navigationsschaltfl\u00e4chen eingebunden wurde, k\u00f6nnen die angezeigten Meldungsdetails direkt als PDF ausgegeben werden. Das erzeugte PDF kann zur weiteren Verwendung genutzt werden, z.B. f\u00fcr den Druck, die Dateiablage oder die interne Dokumentation.</p> <p>Verbesserung: 25.05.226 | Zur Verbesserung der Benutzerfreundlichkeit bei der Pr\u00fcfung von Meldungsdetails wurden folgende Optimierungen umgesetzt:</p> <ul> <li>Gr\u00f6\u00dfenverstellbare Detailtabelle: Die Tabelle mit den Detailangaben ist jetzt nach unten gr\u00f6\u00dfenverstellbar, wodurch mehr Inhalt direkt sichtbar ist. Die individuell eingestellte Gr\u00f6\u00dfe wird vom Programm gespeichert, sodass sie auch bei zuk\u00fcnftigen Meldungsaufrufen automatisch wiederhergestellt wird.</li> <li>Scroll Funktion f\u00fcr umfangreiche Meldungen: Bei sehr umfangreichen Meldungen, wie sie insbesondere in der Gewerbesteuer vorkommen k\u00f6nnen, ist es jetzt m\u00f6glich, die gesamte Detailansicht per Scrollbalken horizontal und vertikal zu verschieben, um alle Inhalte komfortabel einsehen zu k\u00f6nnen.</li> </ul>"},{"location":"aktuelles/release-notes/5.3.0.html#861-gewerbesteuer-meldungen","title":"861 - Gewerbesteuer-Meldungen","text":"<p>Behoben: 25.05.231 | Bei der Aktion \u201ePK/Objekt bearbeiten/anlegen\u201c wurden aufgrund einer programmseitigen Eingrenzung nicht alle Steuerobjekte angezeigt, die der in der Meldung enthaltenen Steuernummer (AZ) zugeordnet sind. Dieses Problem wurde behoben. Ab sofort werden in der Auswahlmaske wieder alle aktiven Objekte angezeigt, die die Steuernummer aus der Meldung f\u00fchren.</p> <p>25.06.094 | In einigen F\u00e4llen wurden nicht alle an das H2R \u00fcbergebenen Felder einer Gewerbesteuer-Meldung korrekt in den Meldungsdetails angezeigt. Das zugrunde liegende Versionierungsproblem wurde behoben. Dadurch werden nun wieder alle relevanten Felder in den Meldungsdetails dargestellt \u2013 sofern diese laut Stammdatenkonfiguration der DTA-Meldungen zur Anzeige vorgesehen sind.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#862-grundsteuer-meldungen","title":"862 - Grundsteuer-Meldungen","text":"<p>Neu: 25.03.123 | Die zwei neuen Datentypen (GMBAX,GMBVX) k\u00f6nnen \u00fcber das H2R eingelesen und verarbeitet werden. Ggfs. m\u00fcssen diese beim Finanzamt noch beantragt und im ELSTER-Transfer als Datenabholung eingerichtet werden. Im H2R ist beim Einlesen der Schnittstellen zu beachten, dass ELSTER-Transfer einen separaten Dateiordner f\u00fcr die GMBAX/ GMBVX-Meldungen erstellt. Dies muss beim Einlesen der Schnittstellen im H2R ber\u00fccksichtigt werden. Bei den GMBVX-Meldungen (Grundsteuermessbetragsverzeichnis) werden Abweichungen im Men\u00fc 862 als zu kl\u00e4rende Meldungen angezeigt, Meldungen ohne Differenzen zum H2R, werden auf bescheidunwirksam gesetzt. Zur Unterst\u00fctzung der Datenabstimmung im H2R mit den GMBVX-Datens\u00e4tzen stehen ab sofort zwei neue Auswertungen im Men\u00fc 68 zur Verf\u00fcgung:</p> <ul> <li>FQ7770 \u2013 Suche abweichende Veranlagungen Grundsteuer Diese Auswertung zeigt Differenzen zwischen bestehenden Veranlagungen und den GMBVX-Daten auf.</li> <li>FQ7780 \u2013 Veranlagungen ohne Zuordnung zum Messbetragsverzeichnis (MBV) Mit dieser Auswertung werden Veranlagungen identifiziert, zu denen laut GMBVX keine Meldung vorliegt.</li> </ul> <p>Diese neuen Funktionen unterst\u00fctzen eine gezielte Pr\u00fcfung und Nachverfolgung von Abweichungen und tragen zur Qualit\u00e4tssicherung der Veranlagungsdaten bei.</p> <p>Verbesserung: 25.03.168 | Die L\u00f6schung bzw. Stornierung (XM) ist nur noch m\u00f6glich, wenn die Steuernummer eindeutig zugeordnet werden kann. Befindet sich dieselbe Steuernummer sowohl im Bereich A als auch B, ist eine L\u00f6schung/Stornierung nicht zul\u00e4ssig, um Fehlzuweisungen zu vermeiden.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#9-barkasse","title":"9 - Barkasse","text":""},{"location":"aktuelles/release-notes/5.3.0.html#92-einnahme-und-ausgabe-kasse","title":"92 - Einnahme und Ausgabe Kasse","text":"<p>Neu: 24.05.160 | Die Barkassenfunktion wurde grundlegend \u00fcberarbeitet und an neue Anforderungen angepasst. In den Stammdaten des Ausgangsrechnungsjournals im Men\u00fc 55 m\u00fcssen nun neue Tarifgruppen angelegt werden, die auf Ausgabearten zugreifen. Diese Tarifgruppen sind anschlie\u00dfend im Men\u00fc 911 den jeweiligen Kassen zuzuordnen, um eine korrekte Verbuchung sicherzustellen.</p> <p>Zus\u00e4tzlich wurde der Erfassungsdialog in der Barkasse neu strukturiert:</p> <ol> <li>Zu Beginn w\u00e4hlt der Mitarbeitende den entsprechenden Gesch\u00e4ftsvorfall (z.B. Einnahme, Ausgabe, Zwischen- oder Kassenumbuchung).</li> <li>Diese Auswahl ist entscheidend f\u00fcr die sp\u00e4tere Verbuchung.</li> <li>Danach ist es jetzt m\u00f6glich direkt Personenkonten anzusprechen.</li> </ol> <p>F\u00fcr Gesch\u00e4ftsvorf\u00e4lle ohne sofortige Kontierung steht der Button \u201eNachkontieren\u201c zur Verf\u00fcgung. Bei diesen muss \u00fcber diesen im Nachgang die passende Einnahme- oder Ausgabeart erg\u00e4nzt werden. Sobald alle buchungsrelevanten Informationen vollst\u00e4ndig erfasst sind, erfolgt die \u00dcbergabe der Belege \u00fcber die Funktion \u201eStapelbuchen\u201c.</p> <p>Weiterf\u00fchrende Informationen entnehmen Sie bitte der bereitgestellten Schulungsunterlage sowie dem Tutorial, welches Ihnen als Link zur Verf\u00fcgung steht.</p> <p>Behoben: 25.05.165 | Bei der Auswahl von debitorischen OP's in der Barkasse ist es wieder m\u00f6glich, mehrere offene Posten gleichzeitig anzusprechen und zu verbuchen.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":""},{"location":"aktuelles/release-notes/5.3.0.html#allgemein_1","title":"Allgemein","text":"<p>Verbesserung: 25.04.125 | Im Rahmen der Weiterentwicklung der Anlagenbuchhaltung wurden folgende Verbesserungen und Anpassungen in den Men\u00fcs vorgenommen:</p> <ul> <li>Der Button \u201eAfA Sichten\u201c wurde in allen relevanten Men\u00fcpunkten optisch vereinheitlicht und an das aktuelle Design angepasst.</li> <li>Die Anzeigen in der Anlagenbuchhaltung, z.B. die Anzeige der berechneten AfA, aktualisieren sich jetzt automatisch, ohne dass ein manueller Refresh erforderlich ist.</li> <li>Im Men\u00fcpunkt b11 \u2013 Anlage wurde der Button \u201eProdukte erw.\u201c in \u201eZuordnung Produkt\u201c umbenannt, um die Funktion eindeutiger zu beschreiben.</li> <li>Im Men\u00fc b11 wurde das Feld \u201eMa\u00df.\u201c zur besseren Verst\u00e4ndlichkeit in \u201eMa\u00dfnahme\u201c umbenannt.</li> <li>In den Men\u00fcs b11 und b21 wurde im Reiter Bruttozuschuss/Inventarzuordnung die Spaltenbezeichnung \u201eAHK-Wert (aktuell)\u201c wieder in \u201eZug. Zuschussbetrag\u201c zur\u00fcckge\u00e4ndert.</li> <li>In den Men\u00fcs b11 und b21 wird der Reiter \u201eAfA Tabelle\u201c nun standardm\u00e4\u00dfig immer ausgeklappt dargestellt.</li> <li>Im Men\u00fc b31 wurde in der Auswahlspalte (Checkbox) die Tabellen\u00fcberschrift um \u201ezu aktivieren\u201c erg\u00e4nzt.</li> <li>Im Men\u00fc b33 werden die Nebensuchfelder beim Aufruf nun stets vollst\u00e4ndig aufgeklappt und sichtbar dargestellt.</li> <li>Im Men\u00fc b35 werden beim Klick auf den Button \u201eBuchungss\u00e4tze\u201c die zugeh\u00f6rigen S\u00e4tze jetzt automatisch aufgeklappt angezeigt.</li> <li>Die Listenansicht im Men\u00fc b135 wurde umfassend \u00fcberarbeitet und neu gestaltet, um eine verbesserte \u00dcbersichtlichkeit und Bedienbarkeit zu gew\u00e4hrleisten.</li> </ul> <p>25.06.123 | Das standardm\u00e4\u00dfige Verhalten der F6-Taste funktioniert im Bereich der Anlagenbuchhaltung wieder korrekt.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#b11-bearbeiten","title":"b11 - Bearbeiten","text":"<p>Behoben: 25.04.118 | Beim Abspeichern eines Anlagegutes trat ein Datenbankfehler auf, wenn zuvor eine Rechnung mit leerem Steuerbetrag aus \u201eER+\u201c \u00fcbernommen wurde. Dieses Problem wurde behoben, sodass das Abspeichern jetzt fehlerfrei funktioniert.</p> <p>25.05.185 | Die im Filterfeld \u201eStandort\u201c angezeigte Dropdown-Liste kann jetzt aufsteigend und absteigend sortiert werden. Die vorher fehlende Sortierfunktion wurde erg\u00e4nzt.</p> <p>25.07.082 | Es wurde ein Fehler behoben, bei dem in bestimmten Konstellationen die Produktaufteilung von Abschreibungen bzw. Aufl\u00f6sungen nicht korrekt gespeichert wurde. Dies f\u00fchrte dazu, dass keine Verteilungsbuchung auf die zugeordneten Produkte erfolgte. Durch die Korrektur wird jetzt sichergestellt, dass die Produktaufteilung ordnungsgem\u00e4\u00df gespeichert und die entsprechende Verteilungsbuchung korrekt durchgef\u00fchrt wird.</p> <p>25.08.008 | Betrifft nur s\u00e4chsische Kommunen: F\u00fcr Finanzanlageg\u00fcter, die im Rahmen einer Bewertung, z.B. nach der Eigenkapitalspiegelmethode, eine negative kumulierte Abschreibung (entspricht einem positiven Jahresergebnis) erhalten haben, ist ab sofort ein Switch ins Neuanlageverm\u00f6gen m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#b121-nachaktivieren","title":"b121 - Nachaktivieren","text":"<p>25.08.131 | Beim Nachaktivieren \u00fcber die Datumsauswahl im Kalender wird nun gepr\u00fcft, ob das gew\u00e4hlte Datum innerhalb des korrekten Haushaltsjahres liegt. Dadurch wird verhindert, dass Nachaktivierungen versehentlich einem falschen Haushaltsjahr zugeordnet werden.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#b122-abgang-bearbeiten","title":"b122 - Abgang bearbeiten","text":"<p>Behoben: 25.08.116 | In der Infobox \u201eZuschussanteile zur Sonderposten-Aufl\u00f6sung/Umbuchung\u201c wird jetzt der zugeh\u00f6rige Sonderposten korrekt angezeigt.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#b21-bearbeiten","title":"b21 - Bearbeiten","text":"<p>Behoben: 25.05.016 | Bei gr\u00f6\u00dferen Zoom-Stufen war es nicht m\u00f6glich, den hinteren Teil der Tabelle durch Scrollen zu erreichen, da die Scrollbar nicht sichtbar war. Mit diesem Release ist die Scrollbar wieder sichtbar und kann uneingeschr\u00e4nkt bedient werden.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#b611-anlagennachweis","title":"b611 - Anlagennachweis","text":"<p>Verbesserung: 25.06.030 | Das Men\u00fc b611 \u2013 Anlagennachweis wurde im aktuellen Release \u00fcberarbeitet. Neu hinzugekommen ist ein Auswahlfeld zur Steuerung der Umbuchungsdarstellung. Mit der neuen Funktion \u201eUmb. unterdr\u00fccken\u201c kann gezielt festgelegt werden, dass Umbuchungen im Anlagennachweis nicht angezeigt werden. Diese Einstellung erm\u00f6glicht eine gezieltere Auswertung, insbesondere wenn ausschlie\u00dflich Zug\u00e4nge, Abg\u00e4nge oder andere Bewegungsarten ohne Umbuchungen betrachtet werden sollen.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#f-steuerbewertung","title":"f - Steuerbewertung","text":""},{"location":"aktuelles/release-notes/5.3.0.html#f1-steuerkompass","title":"f1 - Steuerkompass","text":"NEU:  25.06.099 | Im Bereich Liegenschafts- und Geb\u00e4udemanagement wurden folgende wichtige neue Praxisf\u00e4lle f\u00fcr die steuerliche Bewertung mittels Steuerkompass hinterlegt: Gewerbliche Nutzer / B\u00fcroraum Gewerbliche Nutzer / Lagerfl\u00e4che Sonstige dingliche Rechte / Gestattungsvertrag Sonstige Gegenst\u00e4nde / Vermietung Photovoltaikanlage Bauleitplanung / St\u00e4dtebaulicher Vertrag"},{"location":"aktuelles/release-notes/5.3.0.html#k-kostenrechnungcontrolling","title":"k - Kostenrechnung/Controlling","text":""},{"location":"aktuelles/release-notes/5.3.0.html#k62-kostenstellen","title":"k62 - Kostenstellen","text":"<p>Behoben: 25.07.028 | Unter bestimmten Konstellationen wurden in der Datenbank gespeicherte Kostenstellen nicht angezeigt oder neu angelegte Kostenstellen nach dem Speichern sofort wieder ausgeblendet, obwohl diese korrekt in der Datenbank gespeichert waren. Dieser Fehler wurde behoben, sodass alle Kostenstellen zu jedem Zeitpunkt korrekt angezeigt werden.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#s-system","title":"s - System","text":""},{"location":"aktuelles/release-notes/5.3.0.html#s11-konfigurationen","title":"s11 - Konfigurationen","text":"<p>Neu: 25.03.156 | Beim E-Mail-Versand besteht jetzt die M\u00f6glichkeit, die E-Mail-Adresse des Benutzers als Absender zu verwenden. Hierf\u00fcr muss in dem Reiter \u201eMail\u201c die Option \u201eAbsender ersetzen\" auf \"True\u201c gesetzt werden und es ist eine entsprechende Konfiguration am Mailserver notwendig. Zus\u00e4tzlich l\u00e4sst sich dort eine abweichende, zentrale E-Mail-Adresse hinterlegen, die verwendet wird, wenn beim Benutzer keine eigene E-Mail-Adresse gespeichert ist. Diese Erweiterung bietet mehr Flexibilit\u00e4t bei der Gestaltung des Absenders.</p>"},{"location":"aktuelles/release-notes/5.3.0.html#s21-benutzerverwaltung","title":"s21 - Benutzerverwaltung","text":"<p>Neu: Der Reiter \u201eDruck\u201c soll vorrangig Auswertungs- und Dokumentationszwecken dienen. Aus diesem Grund wurde er wie im Folgenden beschrieben erweitert und \u00fcberarbeitet.</p> <ol> <li>Layout-Anpassung im Nutzerreport Das Layout des Nutzerreports wurde \u00fcberarbeitet, sodass die Inhalte jetzt korrekt und vollst\u00e4ndig dargestellt werden.</li> <li> <p>Filteroption f\u00fcr aktive/inaktive Nutzer Eine neue Filteroption erm\u00f6glicht die gezielte Auswahl von aktiven oder inaktiven Nutzern:</p> <ul> <li>Im Nutzerdruck werden nur aktive Nutzer ausgegeben, sofern die Checkbox \u201enur aktive Nutzer\u201c aktiviert ist.</li> <li>Ist die Checkbox nicht aktiviert, werden im Nutzerdruck ausschlie\u00dflich inaktive Nutzer angezeigt. Hinweis: Im Reiter \u201eNutzer\u201c ist weiterhin ein Export aller vorhandenen Nutzer m\u00f6glich.  </li> <li>Ist die Checkbox nicht aktiviert, werden im Rechtedruck dagegen alle Nutzer ausgewertet.  </li> </ul> <p>Hinweis: Im Reiter \u201eGruppen\u201c werden ab sofort nur noch aktive Nutzer angezeigt. 3. Darstellung und Auswertung von Werterechten - Alle vorhandenen Werterechte werden in der Tabellenansicht sowie im Druck gem\u00e4\u00df der getroffenen Auswahl angezeigt. - Falls kein Wert vorhanden ist oder ein Wert explizit einem negativen Recht (Wert \u201e0\u201c) entspricht, wird dies als \u201enicht vorhanden\u201c gekennzeichnet. - F\u00fcr \"0\"/\"1\"-Rechte ist jetzt eine Filterung auf negative/positive Rechte m\u00f6glich. Hinweis: Diese Funktion steht nicht f\u00fcr Sonderrechte wie z.\u202fB. das AO-Best\u00e4tigungsrecht zur Verf\u00fcgung, da die vorhandenen Werte zu detailliert vergeben werden. 4. Erweiterte Auswertungsm\u00f6glichkeiten im Rechtdruck - Je nach gew\u00e4hlter Sortierung (nach Nutzer oder nach Recht) erfolgt die Ausgabe entsprechend als:     1. Gruppe \u2192 Nutzer     2. Nutzer \u2192 Gruppe     (Es werden nur aktive Nutzer ber\u00fccksichtigt.) 5. \u00dcber den Filter Einzelrecht kann nun detailliert ausgewertet werden: 1. Alle Nutzer/Gruppen, die ein bestimmtes Recht besitzen 2. Alle Nutzer/Gruppen, denen das Recht fehlt 3. Komplette \u00dcbersicht \u00fcber das Recht</p> <p>Hinweis: Gruppen ohne zugeordnete Nutzer werden nicht angezeigt.</p> </li> </ol> <p>Verbesserung: 25.05.083 | Das Feld \u201ePLZ\u201c wurde vergr\u00f6\u00dfert, sodass die Postleitzahl jetzt vollst\u00e4ndig angezeigt wird.</p> <p>25.06.143 | In der Benutzerverwaltung wurde das Maskenlayout f\u00fcr die Mandantengruppen \u00fcberarbeitet, um die Benutzerf\u00fchrung zu verbessern und die Bedienung zu vereinfachen. Im Zuge dieser \u00dcberarbeitung ist jetzt auch die Mandantenzuordnung wieder uneingeschr\u00e4nkt m\u00f6glich. Zus\u00e4tzlich wurde die Funktionalit\u00e4t erweitert: Mehrfachzuordnungen von Mandanten zu mehreren Mandantengruppen k\u00f6nnen jetzt problemlos vorgenommen werden</p>"},{"location":"aktuelles/release-notes/5.3.0.html#s42-wartungsoperationen","title":"s42 - Wartungsoperationen","text":"<p>Verbesserung: 25.05.154 | Wartungsskripte k\u00f6nnen jetzt auch nachtr\u00e4glich angepasst werden.</p>"},{"location":"aktuelles/release-notes/5.3.1.html","title":"Release Notes 5.3.1","text":"<p>Ver\u00f6ffentlichungsdatum des Updates: 23.09.2025</p>"},{"location":"aktuelles/release-notes/5.3.1.html#ubergreifende-funktionen","title":"\u00fcbergreifende Funktionen","text":""},{"location":"aktuelles/release-notes/5.3.1.html#allgemein","title":"Allgemein","text":"<p>Neu: 25.09.006 | \u00dcber den Button \u201eAlle anderen eigenen Sitzungen beenden\u201c  in der oberen Toolbar k\u00f6nnen ab sofort s\u00e4mtliche eigenen, nicht mehr aktiven (verwaisten) Sitzungen gezielt beendet werden. Solche Sitzungen entstehen in der Regel durch ein inkorrektes Schlie\u00dfen von SASKIA.H2R, beispielsweise wenn lediglich der Browser-Tab oder der gesamte Browser geschlossen wird, ohne dass zuvor eine ordnungsgem\u00e4\u00dfe Abmeldung im Programm erfolgt ist. Diese Sitzungen verbleiben bis zum automatischen Timeout auf dem Server im Hintergrund aktiv. </p> <p>Durch die neue Funktion k\u00f6nnen Anwender Bearbeitungssperren eigenst\u00e4ndig und unmittelbar aufheben, ohne das serverseitige Sitzungs-Timeout abwarten zu m\u00fcssen. Dies ist insbesondere dann hilfreich, wenn in einer noch ge\u00f6ffenen Sitzung bereits Objekte wie z.B. Anlageg\u00fcter, Eingangsrechnungen, Auftr\u00e4ge, usw. in Bearbeitung waren und dadurch eine erneute Bearbeitung blockiert wird.  </p> <p>Zudem ist zu beachten: Sollte die Netzwerkverbindung zum Server einmal unterbrochen werden, muss das Programm nicht sofort geschlossen werden. Nach Wiederherstellung der Verbindung baut SASKIA.H2R die Kommunikation mit dem Webserver automatisch wieder auf, sodass die Arbeit ohne zus\u00e4tzlichen Eingriff fortgesetzt werden kann.</p>"},{"location":"aktuelles/release-notes/5.3.1.html#theme-erscheinungsbild","title":"Theme (Erscheinungsbild)","text":"<p>Behoben: Nicht ausgef\u00fcllte Comboboxen welche als Pflichtfelder definiert sind werden wieder mit einem roten Hintergrund hervorgehoben. Dies betrifft beispielsweise das Feld \u201eWeiterleitung an\u2026\u201c im Men\u00fc 36 \u2013 Anordnungsverwaltung.</p>"},{"location":"aktuelles/release-notes/5.3.1.html#dms-ubergabe","title":"DMS \u00dcbergabe","text":"<p>Verbesserung: Die technischen Optionen zur \u00dcbergabe von Dokumenten an ein angebundenes DMS-System wurden erweitert. Im Men\u00fc 1y2 Verwaltung der Ausgabeklassen steht nun eine neue Eigenschaftsspalte \u201eAutomatische Verarbeitung\u201c zur Verf\u00fcgung.  </p> <p>Wird f\u00fcr ein Ausgabek\u00fcrzel ein Haken in dieser Spalte gesetzt, greift k\u00fcnftig die Variante Druckkontrollansicht (Variante 2). Ohne gesetzten Haken bleibt die bisherige Variante Druckvorschau (Variante 1) erhalten.</p> <p>Funktionsweise im Detail:</p> <p>1. Druckvorschau (Variante 1 \u2013 ohne Haken): </p> <ul> <li>Der Anwender sieht das erzeugte Dokument (z. B. Anordnung, Ausgangsrechnung).  </li> <li>\u00dcber den Button \u201eWeiterverarbeitung\u201c kann selbst entschieden werden, ob das Dokument an das DMS \u00fcbergeben werden soll (sofern f\u00fcr den Dokumententyp/Druckvorlage konfiguriert).  </li> </ul> <p>2. Druckkontrollansicht (Variante 2 \u2013 mit Haken): </p> <ul> <li>Das erzeugte Dokument wird lediglich angezeigt.  </li> <li>Nach dem Schlie\u00dfen der Ansicht wird es automatisch an das DMS \u00fcbergeben (sofern f\u00fcr den Dokumententyp/Druckvorlage konfiguriert).  </li> <li>Eine Entscheidungsm\u00f6glichkeit des Anwenders entf\u00e4llt.  </li> </ul> <p>Zweck und Einsatzempfehlung:  Die neue Konfigurationsm\u00f6glichkeit soll insbesondere f\u00fcr Anordnungen eine verl\u00e4sslichere \u00dcbergabe ans DMS sicherstellen. Damit entf\u00e4llt die bisherige Abh\u00e4ngigkeit vom manuellen Klick auf \u201eWeiterverarbeitung\u201c.</p> <p>Die Entscheidung \u00fcber den Einsatz dieser Option obliegt dem Kunden. </p> <ul> <li>Geeignete Ausgabek\u00fcrzel: F20061 AO-Formular und F20062 AO-Liste.  </li> <li>Weniger geeignet: z. B. Ausgangsrechnungen oder Veranlagungsbescheide, da hier sonst jede Druckvorschau automatisch ans DMS \u00fcbergeben w\u00fcrde.</li> </ul> <p>Hinweis:  Diese neue Druckvorschau-Eigenschaft kann als Alternative zum virtuellen Men\u00fcrecht 361 Weiterverarbeitungshinweis (\u201eDieser Druckauftrag erfordert zwingend eine Weiterverarbeitung\u2026\u201c, rote Visualisierung) betrachtet werden.</p>"},{"location":"aktuelles/release-notes/5.3.1.html#3-buchung","title":"3 - Buchung","text":""},{"location":"aktuelles/release-notes/5.3.1.html#311-einzelbuchung","title":"311 - Einzelbuchung","text":"<p>Behoben: 25.08.170 | Bei Erfassung von Zahlungsbuchungen im Rahmen der Mehrfachauswahl wird die Kontierung in der Buchungs\u00fcbersicht wieder korrekt angezeigt, </p> <p>25.09.072 | Unter bestimmten Konstellationen konnte es vorkommen, dass bei Verwendung des Buchungsschl\u00fcssels 221 der Buchungsbetrag eines Auszahlschwebepostens (U-Liste), welcher aus einem Gutschriftslauf entstanden ist, f\u00e4lschlicherweise verdoppelt wurde.</p> <p>25.09.085 | Die Mehrfachauswahl in Kombination mit dem Buchungsschl\u00fcssel 731 funktioniert wieder korrekt.</p>"},{"location":"aktuelles/release-notes/5.3.1.html#3a2-kontoauszugsabgleich","title":"3a2 - Kontoauszugsabgleich","text":"<p>Behoben: 25.09.003 | Die sporadisch auftretende l\u00fcckenhafte Darstellung von Offenen Posten in den Spalten Personenkonto, OP-Nummer und F\u00e4lligkeit im manuellen Abgleich der Kontoauszugsverbuchung sowie in der Personenkontenauskunft wurde korrigiert.</p>"},{"location":"aktuelles/release-notes/5.3.1.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":""},{"location":"aktuelles/release-notes/5.3.1.html#48-vollstreckung-avviso-xfinanz-schnittstelle","title":"48 - Vollstreckung (avviso XFinanz Schnittstelle)","text":"<p>Behoben: 25.08.041 &amp; 25.08.086 | Ein Zusteller, welcher einem Debitor zugeordnet wurde, wird wieder korrekt an avviso \u00fcbergeben. Voraussetzung ist, dass der Zusteller entweder mit der Funktion Debitor oder mit der Funktion 08 \u2013 Zusteller angelegt und anschlie\u00dfend dem entsprechenden Schuldner-Personenkonto zugeordnet wurde. Personenkonten, die \u00fcber die Checkbox \u201ejuristische Person\u201c gekennzeichnet wurden, werden nun wieder korrekt als solche an avviso \u00fcbergeben. Gleiches gilt f\u00fcr Zusteller, die als Debitor angelegt, als juristische Person gekennzeichnet und mit dem Schuldner verkn\u00fcpft sind. Bei Debitoren, die als juristische Person gekennzeichnet sind, werden nur noch die Namensfelder Name 1, Name 2 und Name 3 an avviso \u00fcbergeben; ein Vorname wird richtigerweise nicht mehr \u00fcbertragen.</p> <p>25.09.077 | Das Mehrfachl\u00f6schen von Offenen Posten aus einem \u00dcbergabelauf an avviso ist wieder m\u00f6glich. Hierf\u00fcr kann im Tabellenzeilenkopf (erste Spalte) entweder ein Doppelklick oder die ++ delete ++-Taste verwendet werden. Alternativ lassen sich alle S\u00e4tze gleichzeitig durch einen Doppelklick auf den Tabellenkopf der ersten Spalte l\u00f6schen.</p>"},{"location":"aktuelles/release-notes/5.3.1.html#4b1-mitteilungsverordnung","title":"4b1 - Mitteilungsverordnung","text":"<p>Neu: 25.08.122 | Wird eine Rechnung mittels Zahlungsvorschlag in SASKIA.H2R beglichen, wird die dort verwendete Bankverbindung beim Erstellen der Meldungen im Rahmen der Mitteilungsverordnung in den Meldedaten gespeichert. Das bedeutet im Umkehrschluss, dass Zahlungen au\u00dferhalb von SASKIA.H2R (Buchungsschl\u00fcssel 731) immer selbst\u00e4ndig mit der jeweiligen Bankverbindung des Zahlungsempf\u00e4ngers zu f\u00fcllen sind. </p>"},{"location":"aktuelles/release-notes/5.3.1.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":""},{"location":"aktuelles/release-notes/5.3.1.html#52-eingangsrechnungsjournal","title":"52 - Eingangsrechnungsjournal","text":"<p>Behoben: 25.09.091 | Werden mehrere Rechnungen erfasst und diese anschlie\u00dfend alle markiert, so wird beim Verbuchen ein Anordnungs-Druck aller markierten Eingangsrechnungen mit unterschiedlichen Belegnummern erstellt. Diese Anordnungen h\u00e4ngen nun wieder getrennt nach der jeweiligen Belegnummer an der dazugeh\u00f6rigen Eingangsrechnung.</p>"},{"location":"aktuelles/release-notes/5.3.1.html#6-auswertungen","title":"6 - Auswertungen","text":""},{"location":"aktuelles/release-notes/5.3.1.html#623-summen-und-saldenliste","title":"623 - Summen- und Saldenliste","text":"<p>Behoben: 25.09.077 | Auf der Summen- und Saldenliste wird der Saldo wieder korrekt angezeigt.</p>"},{"location":"aktuelles/release-notes/5.3.1.html#6622-zahlungsvorschlag","title":"6622 - Zahlungsvorschlag","text":"<p>Behoben: 25.09.060 | Bei Zahlungen mit Skontoabzug werden nun die korrekten Controlling-Informationen der Sollstellung \u00fcber die Offene-Posten-Historie ermittelt und f\u00fcr die Buchung des Skontobetrags verwendet. Somit tritt der Fehler \u201eKostenstelle (bel.): Ein Wert ist erforderlich!\u201c nicht mehr auf.</p>"},{"location":"aktuelles/release-notes/5.3.1.html#674-buchung-abziehbare-vorsteuer","title":"674 - Buchung abziehbare Vorsteuer","text":"<p>Behoben: 25.09.068 | Die Funktion zur Einschr\u00e4nkung auf eine oder mehrere Perioden und / oder die Einschr\u00e4nkung auf verschiedene Produkte ist nun wieder m\u00f6glich. Hier erfolgt die korrekte Berechnung der Aufteilungbetr\u00e4ge in den abziehbaren und den nicht abziehbaren Anteil der Vorsteuer. </p>"},{"location":"aktuelles/release-notes/5.3.1.html#731-verwaltung-der-rechnungsabgrenzungsposten","title":"731 - Verwaltung der Rechnungsabgrenzungsposten","text":"<p>Behoben 25.08.194 | Bei einer Belegerfassung in Kombination mit einem Rechnungsabgrenzungsposten und einem Verbundkennzeichen (zum Beispiel Kauf von Waren im europ\u00e4ischen Ausland) wird nun der Abgrenzungsbetrag korrekt ermittelt. Die Ermittlung erfolgt auf Basis des Bruttobetrages. Wird ein solcher Kauf ohne den Abzug eines Vorsteuerbetrages durchgef\u00fchrt, wird ebenfalls die Bemessungsgrundlage als Abgrenzungsbetrag verwendet. </p>"},{"location":"aktuelles/release-notes/5.3.2.html","title":"Release Notes 5.3.2","text":"<p>Ver\u00f6ffentlichungsdatum des Updates: 02.10.2025</p>"},{"location":"aktuelles/release-notes/5.3.2.html#3-buchung","title":"3 - Buchung","text":""},{"location":"aktuelles/release-notes/5.3.2.html#311-einzelbuchung","title":"311 - Einzelbuchung","text":"<p>Behoben: 25.09.141 | Die Auswahl der Sachkonten bei Buchungsschl\u00fcssel 240 wurde um die Kontoart 13 erweitert. Damit k\u00f6nnen z.B. Rundungsdifferenzen vom Umsatzsteuerverrechnungskonto in den Ergebnishaushalt umgebucht werden ohne Finanzrechnung.</p>"},{"location":"aktuelles/release-notes/5.3.2.html#37-anordnungsfreigabe","title":"37 - Anordnungsfreigabe","text":"<p>Behoben: 25.09.120 | Das Men\u00fc 37 Anordnungsfreigabe wurde hinsichtlich der Best\u00e4tigungsstufen \u00fcberarbeitet. Die einzelnen Stufen \"sachllich\" oder \"rechnerisch\" sind wieder jeweils einzeln verf\u00fcgbar und es \u00f6ffnet sich im Anschluss wie gewohnt der Weiterleitungsdialog.</p>"},{"location":"aktuelles/release-notes/5.3.2.html#6-auswertungen","title":"6 - Auswertungen","text":""},{"location":"aktuelles/release-notes/5.3.2.html#69-auswertungszentrale-ehem-gesetzliche-drucklisten","title":"69 - Auswertungszentrale (ehem. Gesetzliche Drucklisten)","text":"<p>Behoben: 25.09.155 | Der Druck von Listen(Teilfinanzhaushalt B, Instandhaltungsliste usw.) mit dem Parameter \"Ma\u00dfnahme gilt bis\" ist wieder uneingeschr\u00e4nkt m\u00f6glich. Das Feld ist kein Pflichtfeld mehr.</p>"},{"location":"aktuelles/release-notes/5.3.2.html#8-veranlagung","title":"8 - Veranlagung","text":""},{"location":"aktuelles/release-notes/5.3.2.html#861-gewerbesteuer-meldungen","title":"861 - Gewerbesteuer-Meldungen","text":"<p>Behoben: 25.09.137 | Gewerbesteuermeldungen (861) &gt; Druck der Meldungsdetails: Der Druck der Meldungsdetails einer Gewerbesteuermeldung wurde korrigiert. Statt der 3 Fragezeichen (???)  als Feldname wird nun wieder der korrekte Feldname angezeigt. Die Kopdfaten des Meldungsdrucks wurden um die Angabe \"Steuerjahr\" erweitert.</p>"},{"location":"aktuelles/release-notes/5.3.2.html#9-barkasse","title":"9 - Barkasse","text":""},{"location":"aktuelles/release-notes/5.3.2.html#92-einnahme-und-ausgabe-kasse","title":"92 - Einnahme und Ausgabe Kasse","text":"<p>Behoben:  25.09.101 | Die Ansicht der Unterkassen einer Hauptkasse werden nun erst wieder angezeigt, wenn man die entsprechende Auswahl vornimmt.</p>"},{"location":"aktuelles/release-notes/5.3.2.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":""},{"location":"aktuelles/release-notes/5.3.2.html#b11-anlagegut-bearbeiten-b21-zuschuss-bearbeiten-b121-nachaktivieren-b221-nachpassivierung","title":"b11 - Anlagegut bearbeiten | b21 - Zuschuss bearbeiten | b121 - Nachaktivieren | b221 - Nachpassivierung","text":"<p>Behoben: 25.02.096 | Die \u00dcbernahme der Belegdaten aus der Gesch\u00e4ftsbuchhaltung \u00fcber den Button ER+ wurde optimiert. Folgende \u00dcberarbeitungen wurden vorgenommen:</p> <ul> <li>Aufteilung nach zwei Ansichten - der Anwender muss sich entscheiden, ob die Sicht nach den Offenen Posten erfolgen soll oder die Buchungen der nicht abziehbaren Vorsteuer angezeigt werden sollen (Im Bild rot umrahmt)</li> <li>Die bisherigen Gruppierungen: \"best\u00e4tigte Zahlungen/bereits zugeordnete offene Posten\", \"noch nicht best\u00e4tigte nicht zugeordnete offene Posten\", \"NAV - teil-/ zugeordnet (Korrektur nichtabzugsf\u00e4higer Vorsteuer)\", \"NAV - offen (Korrektur Nichtabzugsf\u00e4higer Vorsteuer)\" wurden f\u00fcr eine bessere \u00dcbersichtlichkeit entfernt und passend zu den genannten Ansichten integriert.</li> <li>Bisher wurden bei Doppelklick darunterliegende Folgezeilen zu einer bestehenden Rechnung angelegt. Mit diesem Release wird der letzte offene Rechnungsbetrag angezeigt und mit einem Doppelklick zur \"\u00c4nderung VR\" \u00fcbernommen.</li> <li>Eine Rechnungshistorie der Teilbetr\u00e4ge eines offenen Postens ist nach wie vor im Men\u00fcpunkt b134 - Zuordnungsauskunft FR-VR m\u00f6glich.</li> </ul> <p></p>"},{"location":"aktuelles/release-notes/5.3.3.html","title":"Release Notes 5.3.3","text":"<p>Ver\u00f6ffentlichungsdatum des Updates: 10.11.2025</p>"},{"location":"aktuelles/release-notes/5.3.3.html#schulungsmaterial-mitteilungsverordnung","title":"Schulungsmaterial Mitteilungsverordnung","text":"<p>Mit der SASKIA.H2R Version 5.3.3 stehen zus\u00e4tzliche Funktionen im Rahmen der Mitteilungsverordnung bereit (Details unter: 4 \u2013 OP-Bearbeitung). Wie in den Release Notes 5.3.0 angek\u00fcndigt, wird mit diesem Update ein Schulungsvideo sowie ein begleitendes Handout bereitgestellt. Beide Materialien sind nachstehend verf\u00fcgbar.</p> Schulungsvideo Mitteilungsverordnung - von den Stammdaten bis zur Meldung Hinweis: Um die Aufzeichnung des Schulungsvideos anzusehen, ist eine Anmeldung mit Name und E-Mail-Adresse erforderlich. Handout SASKIA.H2R: Mitteilungsverordnung - Meldung durchf\u00fchren"},{"location":"aktuelles/release-notes/5.3.3.html#ubergreifende-funktionen","title":"\u00fcbergreifende Funktionen","text":""},{"location":"aktuelles/release-notes/5.3.3.html#tabellen","title":"Tabellen","text":"<p>Behoben: 25.10.016 | Die individuelle Anordnung und Speicherung von eigenen und globalen Tabellenansichten wurde \u00fcberarbeitet. Die Spalteneigenschaft \u201eSpalten festhalten\u201c wurde optimiert und kann jetzt pro gespeicherter Tabellenansicht individuell konfiguriert werden.</p>"},{"location":"aktuelles/release-notes/5.3.3.html#1-stammdaten","title":"1 - Stammdaten","text":""},{"location":"aktuelles/release-notes/5.3.3.html#1277-mahnstaffel","title":"1277 - Mahnstaffel","text":"<p>Behoben: 25.10.032 | Bei der Anlage einer neuen Mahnstaffelzeile \u00fcber den +-Button in der Sidebar werden jetzt alle erforderlichen Initialwerte gesetzt, sodass die Zeile erfolgreich gespeichert wird.</p>"},{"location":"aktuelles/release-notes/5.3.3.html#3-buchung","title":"3 - Buchung","text":""},{"location":"aktuelles/release-notes/5.3.3.html#311-einzelbuchung","title":"311 - Einzelbuchung","text":"<p>Verbesserung: 25.10.096 | Wurde in der Buchungsmaske eine Zahlungsbuchung (z. B. mit Buchungsschl\u00fcssel 731) erfasst und anschlie\u00dfend \u00fcber den +-Button eine weitere Buchung mit dem Buchungsschl\u00fcssel 220 zur Aufl\u00f6sung eines Schwebepostens erzeugt, wurde bisher die OP-Nummer der vorherigen Zahlung \u00fcbernommen und konnte nicht angepasst werden. Eine Buchung in dieser Konstellation ist jetzt wieder m\u00f6glich, ohne dass die Einzelbuchungsmaske zuvor geschlossen werden muss.</p> <p>25.10.232 | F\u00fcr eine effizientere Belegerfassung in der Einzelbuchungsmaske wurde die Ergonomie verbessert: Nach dem Buchen steht der Cursor nun direkt im Buchungsschl\u00fcssel, sodass ein sofortiges Weiterarbeiten per Tastatur m\u00f6glich ist.</p> <p>25.11.004 / 25.11.012 | In der Einzelbuchungsmaske (bei Kombinationen wie BS 731 \u2192 BS 221 bzw. BS 631 \u2192 BS 220) wurden beim Erfassen einer neuen Buchung \u00fcber den +-Button f\u00e4lschlicherweise Betrag und Buchungstext aus der vorherigen Buchung \u00fcbernommen. Dieses Verhalten wurde korrigiert.</p>"},{"location":"aktuelles/release-notes/5.3.3.html#3521-eingangsschnittstelle-einlesen","title":"3521 - Eingangsschnittstelle Einlesen","text":"<p>Behoben: 25.08.117 | Bei dem Einsatz des Schnittstellenkonverters wird nun neben der Originaldatei auch die konvertierte Datei im Rahmen der Stapelverarbeitung automatisch ins Archiv verschoben. Diese \u00c4nderung stellt sicher, dass die konvertierte Datei nicht versehentlich erneut eingelesen und verarbeitet wird, falls sie zuvor nicht manuell ins Archiv verschoben wurde. </p>"},{"location":"aktuelles/release-notes/5.3.3.html#37-anordnungsfreigabe","title":"37 - Anordnungsfreigabe","text":"<p>Behoben: 25.10.027 | In bestimmten F\u00e4llen konnten Nutzer mit eingeschr\u00e4nkten Anordnungsrechten f\u00e4lschlicherweise s\u00e4mtliche Best\u00e4tigungsstufen ausw\u00e4hlen. Dieses Verhalten wurde korrigiert. Der Button \u201eZusatz-Best\u00e4tigung\u201c ist im Gegen\u00fcberstellungsdialog wieder wie vorgesehen verf\u00fcgbar. Im Men\u00fc 37 wird der Button nun nur noch angezeigt, wenn dem Nutzer tats\u00e4chlich eine Zusatzbest\u00e4tigungsstufe zugewiesen ist.</p>"},{"location":"aktuelles/release-notes/5.3.3.html#396-liquiditatsanzeige","title":"396 - Liquidit\u00e4tsanzeige","text":"<p>Behoben: 25.09.110 | Eine aufsteigende Sortierung der Liquidit\u00e4tsanzeige ist jetzt m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.3.3.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":""},{"location":"aktuelles/release-notes/5.3.3.html#421-bearbeiten","title":"421 - Bearbeiten","text":"<p>Behoben: 25.10.194 | Der Stundungsraten-Erfassungsdialog wurde im Kontext Dezimalzahlen \u00fcberarbeitet.</p>"},{"location":"aktuelles/release-notes/5.3.3.html#4b2-meldungen-zur-mitteilungsverordnung","title":"4b2 - Meldungen zur Mitteilungsverordnung","text":"<p>Neu: 24.03.030 | Mit diesem Update ist es m\u00f6glich nach dem Abholen von Meldungen, die im Rahmen der Mitteilungsverordnung an die Finanzbeh\u00f6rden versendet wurde, die Informationen als Anschreiben an den Betroffenen direkt im Anschluss zu Versenden. Die Anschreiben werden pro Mitteilung erzeugt, hat ein Betroffener mehrere Zahlungen mit unterschiedlichen MV-Details erhalten, so erh\u00e4lt er mehrere Schreiben. Dazu kann es beispielsweise kommen, wenn ein Kreditor Geld im Rahmen von Mietzahlungen erh\u00e4lt und gleichzeitig aber auch ein Ehrenamt begleitet. Wiederkehrende Zahlungen, deren MV-Details identisch sind, werden in einer Mitteilung an das Finanzamt und damit auch in einem Anschreiben zusammengefasst.</p> <p>Das Anschreiben wird als Report F-60171 ausgeliefert und steht in den bekannten Formaten \"breit\" und \"hoch\" zur Verf\u00fcgung. Sowohl die Reporttextbausteine wie auch die Basistextbausteine werden \u00fcber den Releaswechsel zur Verf\u00fcgung gestellt. Die Texte stehen damit als Vorschlag zur Verf\u00fcgung und k\u00f6nnen angepasst werden - die Inhalte in Kontext der Mitteilungsdetails sind unver\u00e4nderbar in der Software definiert.</p> <p>Verbesserung 25.10.040 | Die Schnittstelle des Finanzamtes erm\u00f6glicht jetzt das Zusammenfassen von identischen Meldedetails im Rahmen der Mitteilungsverordnung. Werden Zahlungen mit identischen MV-Details erfasst \u2013 wobei \u201eidentisch\u201c bedeutet, dass alle angegebenen Informationen \u00fcbereinstimmen \u2013 werden diese zu einer Mitteilung zusammengefasst.</p> <p>Beispiel:</p> <p>Es werden 12 Mietzahlungen f\u00fcr 2 Wohnobjekte an den gleichen Zahlungsempf\u00e4nger ausgezahlt und f\u00fcr beide Mietobjekte werden die Grundst\u00fccksinformationen mitgeteilt. Dann entstehen 2 Mitteilungen mit je 12 Zahlungen.  \u00c4ndert sich jedoch beispielsweise im Monat Oktober die Bankverbindung f\u00fcr beide Mietzahlungen, so entstehen 4 Mitteilungen. 2 Mitteilungen f\u00fcr Objekt 1 - wobei eines die Zahlungen f\u00fcr die Perioden 1-9 auf Bankverbindung 1 ber\u00fccksichtigt und das zweite die Zahlungen von Periode 10-12 auf Bankverbindung 2 ber\u00fccksichtigt. Das gleiche gilt dann f\u00fcr Objekt 2 mit den unterschiedlichen Bankverbindungen, so dass in der Folge die 4 genannten Mitteilungen zu einer Person mit 24 Zahlungen entstehen. </p>"},{"location":"aktuelles/release-notes/5.3.3.html#6-auswertungen","title":"6 - Auswertungen","text":""},{"location":"aktuelles/release-notes/5.3.3.html#672-umsatzsteuermeldungen","title":"672 - Umsatzsteuermeldungen","text":"<p>Behoben: 25.10.043 | Die Funktion der Zahllastbuchung funktioniert wieder korrekt. Die Buchungsstelle wird nun wieder wie vorgesehen automatisch bef\u00fcllt.</p>"},{"location":"aktuelles/release-notes/5.3.3.html#674-buchung-abziehbare-vorsteuer","title":"674 - Buchung abziehbare Vorsteuer","text":"<p>Behoben: 25.11.005 | Beim Buchungslauf der nicht abziehbaren Vorsteuer kam es in bestimmten Konstellationen zu einem Timeout, wenn die Verf\u00fcgbarkeit im laufenden Haushalt \u00fcberschritten wurde und Vorjahresmittel zur Bedarfsdeckung eingesetzt werden sollten. Mit diesem Release ist es m\u00f6glich, Buchungsstellen desselben Deckungskreises zu verwenden, wenn die Mittel zur Deckung teilweise aus dem Vorjahr und teilweise aus dem aktuellen Haushaltsjahr stammen.</p>"},{"location":"aktuelles/release-notes/5.3.3.html#69-auswertungszentrale","title":"69 - Auswertungszentrale","text":"<p>Verbesserung: 25.10.217 | F\u00fcr die Zweckverb\u00e4nde wird die Haushaltssatzung nun korrekt angedruckt.  Der Report wurde um eine zus\u00e4tzliche Vorlagenoption erweitert. In der Vorlagenverwaltung kann f\u00fcr jeden Mandanten die passende Vorlage eingerichtet werden, sodass die jeweilige Vorlagenoption automatisch ber\u00fccksichtigt wird. Damit ist der Standard f\u00fcr Zweckverb\u00e4nde nun sichergestellt.</p>"},{"location":"aktuelles/release-notes/5.3.3.html#9-barkasse","title":"9 - Barkasse","text":""},{"location":"aktuelles/release-notes/5.3.3.html#92-einnahme-und-ausgabe-kasse","title":"92 - Einnahme und Ausgabe Kasse","text":"<p>NEU: 25.09.151 | In der Barkasse ist beim Gesch\u00e4ftsvorfall \u201eEinnahme auf OP\u201c jetzt die \u00c4nderung von Vorzeichen und Summe m\u00f6glich. Zus\u00e4tzlich wurde der Gesch\u00e4ftsvorfall \u201eAusgabe auf OP\u201c eingef\u00fchrt, der mit Buchungsschl\u00fcssel 731 gebucht wird.</p>"},{"location":"aktuelles/release-notes/5.4.0.html","title":"Release Notes 5.4.0","text":"<p>Ver\u00f6ffentlichungsdatum des Updates: 09.12.2025</p>"},{"location":"aktuelles/release-notes/5.4.0.html#ubergreifende-funktionen","title":"\u00dcbergreifende Funktionen","text":""},{"location":"aktuelles/release-notes/5.4.0.html#allgemein","title":"Allgemein","text":"<p>Verbesserung: 25.10.020 | Die visuelle Kennzeichnung von Men\u00fcpunkten mit Leserechten wurde umgesetzt. Im jeweiligen Reiter wird nun links neben der Nomenklatur bzw. Bezeichnung des Men\u00fcpunktes ein durchgestrichener Stift angezeigt.</p> <p>Behoben: 25.10.235 | Die Eingabe eines Tabulators \u00fcber die Tab-Taste in Textfeldern ist wieder m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#navigationsbar-menubaum","title":"Navigationsbar / Men\u00fcbaum","text":"<p>Behoben:  25.08.111 | Es wurde ein Fehler behoben, durch den sich der Men\u00fcbaum in der horizontalen Ansicht willk\u00fcrlich wieder geschlossen hat.</p> <p>Empfehlung: Aufruf des Men\u00fcbaums in der horizontalen Ansicht \u00fcber die eingeklappte Navigationsleiste auf. Diese l\u00e4sst sich per Klick auf das SASKIA.H2R-Logo ein- und ausklappen.</p> <p>Vorteil: Die horizontale Ansicht bietet eine bessere \u00dcbersichtlichkeit und eine ergonomischere Bedienung.</p> <p></p>"},{"location":"aktuelles/release-notes/5.4.0.html#filter-nach-funktion-debitorkreditor","title":"Filter nach Funktion Debitor/Kreditor","text":"<p>Verbesserung:  25.11.085 | Die zuvor eingef\u00fchrte Adresslogik im Zusammenhang mit Einheitspersonenkonten wurde revidiert. Die Ermittlung der anzuzeigenden Adresse erfolgt wieder gem\u00e4\u00df dem bisherigen Verhalten:</p> <ul> <li>Bei eindeutiger Personenzuordnung wird die Adresse direkt angezeigt.</li> <li>Bei mehreren PK-Zuordnungen erfolgt die Darstellung als Mehrfachauswahl (Debitor/Kreditor).</li> </ul>"},{"location":"aktuelles/release-notes/5.4.0.html#filterlogik-tabellen","title":"Filterlogik Tabellen","text":"<p>Verbesserung: Die Filterfunktion innerhalb von Tabellenspalten wurde optimiert. Einschr\u00e4nkungen, die in einem Spaltenfilter gesetzt werden, wirken sich nun auch auf die angezeigten Werte der \u00fcbrigen Filter in den Tabellenk\u00f6pfen aus. Dadurch werden die ausw\u00e4hlbaren Filteroptionen mit jedem gesetzten Filter dynamisch weiter eingegrenzt, was die gezielte Datenauswahl erleichtert.</p> <p>Behoben: Die Filterfunktion innerhalb von Tabellenspalten wurde korrigiert und arbeitet nun wieder fehlerfrei. Eine pr\u00e4zise Einschr\u00e4nkung der angezeigten Ergebnismenge ist damit wieder vollst\u00e4ndig m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#vop-verification-of-payee","title":"VoP (Verification of Payee)","text":"<p>Mit der Einf\u00fchrung der europaweiten Empf\u00e4ngerpr\u00fcfung der Banken und Sparkassen ist es notwendig die korrekte Kontoinhaberbezeichnung bei \u00dcberweisungen und Lastschriften anzugeben. Da bisher die Bezeichnung des Kontoinhabers der Bezeichnung des Namens im Personenkonto entsprochen hat, wurden Programmanpassungen durchgef\u00fchrt, um hier eine Separierung zu erm\u00f6glichen. </p> <ol> <li> <p>Neue Personenkonten-Funktion \u201eI \u2013 Kontoinhaber\u201c:</p> </li> <li> <p>Die PK-Nummernbildung f\u00fcr die Personenkontofunktion \u201eKontoinhaber\u201c (I) erfolgt entsprechend der definierten PK-L\u00e4nge mit <code>#T\u2026</code>.</p> </li> <li>Ein I-Kontoinhaber kann sowohl mit als auch ohne Adressangaben angelegt werden. Die Steuerung erfolgt im Men\u00fc 12a3 \u00fcber die bekannte Option \u201eohne Anschrift\u201c.</li> <li>Bei Bedarf kann der I-Kontoinhaber einem konkreten Personenkonto (z.\u202fB. Kreditor) als abweichender Kontoinhaber im gewohnten Eingabefeld hinterlegt werden.</li> <li> <p>Die Funktion dient als Erg\u00e4nzung zur Hinterlegung tats\u00e4chlicher abweichender Kontoinhaber.</p> </li> <li> <p>Abweichungen bei Firmenbezeichnungen:</p> </li> <li> <p>Um Unterscheidungen zwischen der Kontoinhaberbezeichnung und den Angaben zu juristischen Personen im SASKIA.H2R treffen zu k\u00f6nnen, kann mit der genannten Funktion \u201eKontoinhaber\u201c auch in diesen F\u00e4llen agiert werden.</p> </li> <li>Bei der \u00dcbertragung der Kontoinhaberbezeichnung im SEPA-\u00dcberweisungsprozess werden grunds\u00e4tzlich nur die Felder \"Vorname\" und \"Name1\" \u00fcbergeben, um die maximale VoP-L\u00e4nge von 70 Zeichen einzuhalten.</li> <li>Eine Verkettung von \"Name2\" und \"Name3\" erfolgt bewusst nicht.</li> <li>Bei sehr langen Firmenbezeichnungen, die die maximale L\u00e4nge von \"Name1\" (45 Zeichen) \u00fcberschreiten, sollte beim I-Kontoinhaber zus\u00e4tzlich das Feld Vorname genutzt werden.</li> </ol>"},{"location":"aktuelles/release-notes/5.4.0.html#dms","title":"DMS","text":"<p>Verbesserung: 25.08.061 | Im Men\u00fc s11 wurde im Bereich DMS ein neuer Parameter DMSBATCHCRITICALERROR eingef\u00fchrt.</p> <p>Bei DMS-\u00dcbergaben werden standardm\u00e4\u00dfig bis zu 10 \u00dcbergabeversuche durchgef\u00fchrt, um ein Dokument erfolgreich zu \u00fcbertragen. In der Praxis k\u00f6nnen jedoch sehr unterschiedliche Fehlerkonstellationen auftreten. Insbesondere bei Massendatenverarbeitungen k\u00f6nnen diese Wiederholungsversuche die Leistungsf\u00e4higkeit des H2R-Jobservers beeintr\u00e4chtigen, obwohl ein erneuter Versuch in vielen F\u00e4llen weder sinnvoll noch notwendig ist.</p> <p>In der Aufgaben\u00fcberwachung (s59) werden im Fehlerfall die entsprechenden Fehlermeldungen in der Spalte Fehler textlich ausgewiesen.</p> <p>Programmintern wird bereits eine Vielzahl solcher Fehlermeldungen abgefangen. Diese werden im Fehlerfall direkt auf 10.000 Versuche gesetzt, was bedeutet, dass keine erneuten \u00dcbergabeversuche erfolgen und der Vorgang sofort abgebrochen wird.</p> <p>F\u00fcr folgende F\u00e4lle wurde das Verhalten entsprechend angepasst (Abbruch nach dem ersten Fehler):</p> <ul> <li>Eingangsrechnung mit der ID '0' konnte nicht gefunden werden.</li> <li>Keine Metadaten f\u00fcr die Allgemeine Liste im Mandanten '&lt;&gt;' konfiguriert.</li> <li>Fehler bei der \u00dcbergabe einer AO an das DMS! Die Anordnung mit der ID=&lt;&gt; hat keine registrierte PDF-Datei im DAT-Verzeichnis.</li> </ul> <p>Da derartige Fehlermeldungen sehr unterschiedlich ausfallen k\u00f6nnen, wurde mit dem neuen Parameter eine flexible Konfigurationsm\u00f6glichkeit geschaffen. Diese bewirkt ebenfalls, dass keine 10 \u00dcbergabeversuche ausgef\u00fchrt werden, sondern der Vorgang direkt auf 10.000 Versuche gesetzt und somit sofort abgebrochen wird. Es k\u00f6nnen mehrere Fehler-Muster hinterlegt werden, getrennt durch das Literal \"PIPE\" ( | ).</p> <p>Hinweis: Vorhandene Klammern m\u00fcssen mit einem Schr\u00e4gstrich / maskiert werden.</p> <p>Beispiel:</p> <p>(The HTTP status code of the response was not expected (400)|hat keine registrierte PDF-Datei im DAT-Verzeichnis)</p> <p>25.09.078 | Der technologische Prozess zur \u00dcbergabe von Dokumenten in ein angebundenes DMS wurde optimiert. Besonders bei Mehrfach\u00fcbergaben (z. B. Mahnungen, Veranlagungsbescheide oder Ausgangsrechnungsrechnungen) wurde die Aufsplittung von Gesamt-PDFs in Einzel-PDFs strukturell \u00fcberarbeitet. Durch diese \u00dcberarbeitung entf\u00e4llt das erneute Rendern der PDF-Dateien w\u00e4hrend der Zerlegung. Dies verbessert die Performance der \u00dcbergabe und stellt sicher, dass die \u00fcbergebenen PDFs optisch unver\u00e4ndert bleiben.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#0-global","title":"0 - Global","text":""},{"location":"aktuelles/release-notes/5.4.0.html#011-aufgabenverwaltung","title":"011 - Aufgabenverwaltung","text":"<p>Behoben: 25.08.037 | Das Men\u00fc kann nun nach dem Abschluss offener Aufgaben ohne Anzeige des Speicher-Dialogs geschlossen werden. \u00c4nderungen werden in diesem Men\u00fcpunkt automatisch gespeichert.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#1-stammdaten","title":"1 - Stammdaten","text":""},{"location":"aktuelles/release-notes/5.4.0.html#11-pflege-mandant","title":"11 - Pflege Mandant","text":"<p>WICHTIGE \u00c4NDERUNG: 25.11.148 | Es wurde eine Anpassung der Bagatellgrenzenpr\u00fcfung in Bezug auf die Mitteilungsverordnung vorgenommen!</p> <p>Die selbst einzustellende Bagatellgrenze von derzeit 3.000 EUR im Mandantenstamm wird nun auch f\u00fcr \u00a72 MV gepr\u00fcft. Das hei\u00dft, der eingegebene Betrag im Mandantenstamm wird in allen F\u00e4llen vom System beim Erstellen der Mitteilungen gem\u00e4\u00df Mitteilungsveordnung gep\u00fcrft.</p> <p>In der Folge bedeutet dies, dass entweder eine manuelle Freigabe der Mitteilungen erfolgen muss, dass auch Meldungen unter der eingegebenen Bagatellgrenze \u00fcbermittelt werden oder der Betrag der Bagatellgrenze wird entgegen der gesetzlichen Vorgaben auf einen anderen Betrag eingestellt. </p> <p>Neu: 25.09.057 | Sind Kontenbereiche im Register \"Kostenrechnung\" hinterlegt und es werden in der Sachkontenverwaltung (124) neue Sachkonten angelegt, stehen diese im Kostenartenassistenzen (k61) \u00fcber die neue Funktion \"Assistent\" zur Verf\u00fcgung. </p> <p>Bei Auswahl eines oder mehrerer Kostenarten k\u00f6nnen diese im Verh\u00e4ltnis 1:1 zu den Sachkonten angelegt werden. Dabei werden die Kontonummer als Kostenartennummer und die Sachkontenbezeichnungen als Kostenartenbezeichnungen \u00fcbernommen.  Ertragskonten werden mit dem Kostenartentyp \"Erl\u00f6se\" angelegt und Aufwandskonten mit dem Kostenartentyp \"Einzel- und Gemeinkosten\". </p> <p>Besteht der Wunsch der neu anzulegenden Kostenart bereits im Assistenten ein Produkt zur Einschr\u00e4nkung der Verwendung dieser Kostenarten auf die genannte Buchungsstelle zu hinterlegen, kann dies mit dem entsprechenden Feld \"zugeordnete Produkte\" erfolgen. </p>"},{"location":"aktuelles/release-notes/5.4.0.html#123-listenpositionsverwaltung","title":"123 - Listenpositionsverwaltung","text":"<p>Verbesserung: 25.10.222 | In der Listenpositionsverwaltung wurden die Spalten \"Nutzer\" und \"Datum\" hinzugef\u00fcgt. Damit ist nun sehr gut erkennbar, wann eine Liste aus dem Schattenmandanten abgeleitet wurde. </p>"},{"location":"aktuelles/release-notes/5.4.0.html#1274-ausgabearten","title":"1274 - Ausgabearten","text":"<p>Verbesserung: 25.09.004 | Es ist nun m\u00f6glich, ein Ablaufjahr zu hinterlegen. Wenn ein Ablaufjahr angegeben ist und eine Tarifgruppe (Men\u00fc 55 - Stammdaten Ausgangsrechnungsjournal ) mit der entsprechenden Ausgabeart verkn\u00fcpft wurde, wird automatisch eine \u201eGilt bis\u201c-Periode f\u00fcr den letzten Monat dieses Jahres eingetragen. Dadurch werden die Ausgabeart und die zugeh\u00f6rige Tarifgruppe nicht in das neue Jahr \u00fcbernommen.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#1278-banken","title":"1278 - Banken","text":"<p>Behoben: 25.09.113 | Der Bankenimport (BIC/BLZ) im Format Win1252 (ANSI) funktionierte f\u00fcr die von der Bundesbank bereitgestellten Importdateien nicht korrekt. Die Unterst\u00fctzung f\u00fcr Win1252 (ANSI) wurde zus\u00e4tzlich zum UTF-8-Format implementiert.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#12a3-personenkontenverwaltung","title":"12a3 - Personenkontenverwaltung","text":"<p>Verbesserung: 25.08.096 | In der \u00dcbersicht der Personenkonten wird die Standardbankverbindung eines Kreditors nun mit dem Wort \"Standard\" gekennzeichnet.</p> <p>Behoben:  25.09.150 | Die Flexibilit\u00e4t von Reports mit Logobezug wurde erweitert. Es k\u00f6nnen nun separate Logoh\u00f6hen f\u00fcr den oberen und unteren Bereich individuell definiert werden. Damit wird den zunehmend unterschiedlichen Corporate Design Vorgaben in Verwaltungen Rechnung getragen. Die Logoparameter sind als Vorlagenoption pro Report verf\u00fcgbar. Standardm\u00e4\u00dfig sind sie mit dem bisherigen Wert von 40\u202fmm vorbelegt und m\u00fcssen nur bei Bedarf angepasst werden.</p> <p>25.10.091 | Die Spalte \u201eTitel\u201c wird in der \u00dcbersicht der Personenkontenauskunft nun wieder separat angezeigt. Dadurch ist sie sowohl auswertbar als auch f\u00fcr den Export nach Excel verf\u00fcgbar.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#12a4-adressdruck","title":"12a4 - Adressdruck","text":"<p>Behoben: 25.09.082 | Die Drucklisten-Option \u201eFreie Personenkonten\" listet mit der Einschr\u00e4nkung \u201eNur Bereichsauflistung\" alle frei verwendbaren Personenkonten-Nummernbereiche auf. Als Grundeinschr\u00e4nkung muss eine Funktion (z. B. Debitor, Kreditor) gew\u00e4hlt werden. Damit k\u00f6nnen freie Bereiche identifiziert und gezielt aufgef\u00fcllt werden, um unn\u00f6tige L\u00fccken in der Nummerierung zu schlie\u00dfen.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#1y1-textbausteinverwaltung","title":"1y1 - Textbausteinverwaltung","text":"<p>Verbesserung: 25.09.011 | Die Verwendung von Options-Textbausteinen (OTB) wurde \u00fcberarbeitet. Im Men\u00fc 1y1 k\u00f6nnen solche Optionstextbausteine im Reiter \u201eDruckoptionen\" definiert werden. F\u00fcr jeden OTB sollte ein aussagekr\u00e4ftiger Name vergeben werden.</p> <p>In den Druckoptionen der jeweiligen Reports (z. B. Ausgangsrechnung) kann der OTB dann optional verwendet werden, um spezielle Anforderungen an eine Bescheid- und Rechnungsschreibung umzusetzen. So kann beispielsweise f\u00fcr den Auskunftsblock RTB_4 wahlweise eine Auskunft mit oder ohne Vorname gew\u00e4hlt werden.</p> <p>Der OTB liefert einen Zustandswert zur\u00fcck (1 = aktiviert, 0 = deaktiviert), der an den Datenstrom \u00fcbergeben und entsprechend der Konfiguration der Basistextbausteine (BTB) aufgel\u00f6st wird. Der zugeh\u00f6rige BTB muss in Kombination mit dem OTB-Namen gebildet werden.</p> Beispiel OTB-Definition OTB_ohneVorname Hinterlegung im Report RTB_4 {BTB_Briefb{OTB_ohneVorname}} Funktionsweise Wenn die Druckoption f\u00fcr den OTB aktiviert wird, wird BTB_BriefbohneVorname aufgel\u00f6st und entsprechend visualisiert. <p>25.10.021 | Das Layout der Textbausteinverwaltung (Basistextbausteine \u2013 BTB, Vorlagentextbausteine \u2013 VTB, Reporttextbausteine \u2013 RTB) wurde \u00fcberarbeitet und die einzelnen Elemente neu positioniert:</p> <ul> <li>Die Tabelle im oberen Bereich zeigt den jeweiligen Textbaustein (BTB/VTB/RTB) an.</li> <li>Der Texteditor befindet sich im unteren Bereich mit Formatierungsoptionen, die rechts angedockt sind.</li> <li>Die Einf\u00fcgeoptionen wurden nach rechts neben das Textfeld verschoben und werden nun in Tabellenform dargestellt.</li> <li>Textbausteine aus den Einf\u00fcgeoptionen k\u00f6nnen wie gewohnt durch Doppelklick auf den gew\u00fcnschten Baustein in das Textfeld \u00fcbernommen werden.</li> </ul>"},{"location":"aktuelles/release-notes/5.4.0.html#2-planung","title":"2 - Planung","text":""},{"location":"aktuelles/release-notes/5.4.0.html#23-budgetzuordnung","title":"23 - Budgetzuordnung","text":"<p>Verbesserung: 25.08.138 | Im Men\u00fc 23 \u2013 Budgetzuordnung wurde f\u00fcr die Filteroption \u201ekein Budget zugeordnet\" ein dritter Checkbox-Status hinzugef\u00fcgt. Die Klickreihenfolge erm\u00f6glicht nun die Auswahl zwischen:</p> <ul> <li>Ausgew\u00e4hlt (Haken)</li> <li>Nicht ausgew\u00e4hlt (leer)</li> <li>Mischstatus (Bindestrich | - |) \u2013 neu</li> </ul> <p>Verhalten und Empfehlungen: Beim ersten \u00d6ffnen der Budgetzuordnung (Men\u00fc 23) ist diese Option standardm\u00e4\u00dfig auf Mischstatus gesetzt, was sowohl zugeordnete als auch nicht zugeordnete Buchungsstellen einschlie\u00dft. Dies ist f\u00fcr die Erstbearbeitung sinnvoll, beeinflusst aber die Filterung \u00fcber das Suchfeld \u201eBudget\".</p> <p>Sollen bereits zugeordnete Buchungsstellen \u00fcber das Suchfeld \u201eBudget\" gefiltert werden, muss die Checkbox deaktiviert werden. Nur dann wird die korrekte Anzeige erreicht; andernfalls werden alle Buchungsstellen (auch von anderen Budgets) angezeigt.</p> <p>Um alle Buchungsstellen ohne Budget anzuzeigen, wird die Checkbox aktiviert und anschlie\u00dfend die Anzeige aktualisiert. Dies erm\u00f6glicht eine z\u00fcgige Budgetzuordnung aller Buchungsstellen vor einer Plan\u00fcbernahme.</p> <p>Empfehlung f\u00fcr andere Suchfelder: Bei der Filterung von Buchungsstellen \u00fcber andere Suchfelder (z. B. Produkt, Sachkonto, usw.) unabh\u00e4ngig von der Budgetzuordnung wird empfohlen, die Checkbox im Mischstatus (Bindestrich | - |) zu belassen, um alle relevanten Datens\u00e4tze zu erhalten.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#242-ergebnisplan","title":"242 - Ergebnisplan","text":"<p>Behoben: 25.10.202 | Die Eingabemaske von Planerl\u00e4uterungstexten wurde hinsichtlich der Einblendung des Editor-Panels \u00fcberarbeitet. </p>"},{"location":"aktuelles/release-notes/5.4.0.html#27-neue-buchungsstelle","title":"27 - Neue Buchungsstelle","text":"<p>Verbesserung: 25.08.077 | Im Men\u00fcpunkt 27 wurde bei der Anlage neuer Buchungsstellen eine Plausibilit\u00e4tspr\u00fcfung f\u00fcr das Bundesland Sachsen-Anhalt integriert. Das System f\u00fchrt dabei eine automatische Pr\u00fcfung gem\u00e4\u00df den Vorgaben des Statistischen Landesamtes durch und \u00fcberpr\u00fcft, welche Produkt- und Sachkonto-Kombinationen gem\u00e4\u00df der ver\u00f6ffentlichten Vorgaben der \u201ePr\u00fcfdatei 2024\" zul\u00e4ssig oder nur optional zul\u00e4ssig sind. Sollte eine nicht zul\u00e4ssige Kombination erkannt werden, erscheint ein entsprechender Hinweis. Die Anwender werden in diesem Fall gefragt, ob sie die Kombination dennoch anlegen m\u00f6chten.</p> <p>Die Entscheidung f\u00fcr eine optionale Abfrage statt einer restriktiven Verfahrensweise wurde bewusst getroffen, da die Aktualit\u00e4t der Pr\u00fcfdatei nicht tagesgenau gew\u00e4hrleistet werden kann. Dies erm\u00f6glicht den Anwendern weiterhin, eigenverantwortlich zu handeln und bei Bedarf von den Vorgaben abzuweichen.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#3-buchung","title":"3 - Buchung","text":""},{"location":"aktuelles/release-notes/5.4.0.html#311-einzelbuchung","title":"311 - Einzelbuchung","text":"<p>Verbesserung: 25.10.233 | Um eine bessere Tastaturbedienbarkeit zu gew\u00e4hrleisten, wurde die Funktion der Mnemonik in der Einzelbuchungsmaske aktiviert. Die unterstrichenen Buchstaben auf den Funktionsfelder stehen in diesem Zusammenhang zur Verf\u00fcgung. Eine Tastenkombination aus der Taste Alt plus den Buchstaben f\u00fchrt die Funktion aus.</p> <p>Somit sind nun mittels Tastaturbedienung die Funktionen \u00dcbernehmen und Buchen mit AO erreichbar. F\u00fcr ein \u00dcbernehmen wird die Tastenkombination Alt+B verwendet und f\u00fcr das Buchen mit AO ist die Kombination Alt+M vorgesehen. An dieser Stelle ist keine individuelle Tastaturvorbelegung verf\u00fcgbar; hier sind zwingend die vorgegebenen Werte zu verwenden.</p> <p>25.11.014 | Bei der Nutzung eines SOLL-IST-Buchungsschl\u00fcssels in Kombination mit einer Buchungsvorlage werden \u00c4nderungen an den Werten (z. B. Produkt) nun automatisch auf den zugeh\u00f6rigen Zahlungsbuchungssatz \u00fcbertragen. Ein separates Anklicken bzw. Aktualisieren des Buchungssatzes in der Buchungs\u00fcbersicht ist nicht mehr erforderlich.</p> <p>Behoben: 25.09.033 | Beim Buchen eines maschinellen Zahlungseingangs (BS 633) oder -ausgangs (BS 733) bestand bisher die M\u00f6glichkeit, den Buchungsschl\u00fcssel auf einen manuell erfassten Zahlungsein- bzw. -ausgang zu \u00e4ndern. In diesen F\u00e4llen musste der zugeh\u00f6rige Schwebeposten anschlie\u00dfend manuell gel\u00f6scht werden. Mit diesem Release erfolgt die L\u00f6schung des Schwebepostens nun automatisch.</p> <p>25.11.010 | Beim L\u00f6schen eines Teilsatzes einer SOLL=IST-Buchung, wird sowohl der Datensatz f\u00fcr die SOLL-Buchung, als auch f\u00fcr die IST-Buchung gel\u00f6scht. Bisher wurde beim L\u00f6schen der IST-Buchung, der Datensatz der SOLL-Buchung bei den Buchungsschl\u00fcsseln 421/621 bzw. 521/721 stehen gelassen.</p> <p>25.11.150 | Die Anzeige im Panel \"Kostenrechnung\" wurde \u00fcberarbeitet, so dass nun die Tabellen vollst\u00e4ndig angezeigt werden, ohne ein Aktualisieren durchf\u00fchren zu m\u00fcssen. </p> <p>25.11.151 | Wenn bei der Erfassung eines Beleges ein Aufteilungsbetrag angegeben wird, wird der Differenzbetrag nun wieder automatisch als Buchungsbetrag in die neu hinzugef\u00fcgte Zeile hinterlegt.</p> <p>25.11.155 | Bei Zahlungen von Vorg\u00e4ngen mit verbundenen Steuerkennzeichen wurde der Betrag nicht korrekt ber\u00fccksichtigt. Dieses Verhalten wurde behoben.</p> <p>25.09.124 | Bei Budgetumbuchungen wird die Bedarfsermittlung des restlichen offenen Betrags nach einer Aktualisierung wieder korrekt durchgef\u00fchrt. Zudem wurde die Checkbox \u201enicht deckungsf\u00e4hige Buchungsstellen\u201c erg\u00e4nzt.  Damit k\u00f6nnen Buchungsstellen angezeigt werden, die nicht als deckungsf\u00e4hig gelten, aber ggf. in der \u00dcbersicht erwartet werden. Hierzu z\u00e4hlen z.?B. die Konten 60xx bis 61xx, ausgenommen 614x und 619x in Sachsen. Die korrespondierenden Ergebniskonten werden nur bei aktiver Checkbox angezeigt.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#312-dauerbuchung","title":"312 - Dauerbuchung","text":"<p>Behoben: 25.10.033 | Dauerbuchungen mit dem Buchungsschl\u00fcssel 511 k\u00f6nnen nun wieder ordnungsgem\u00e4\u00df bearbeitet werden. </p>"},{"location":"aktuelles/release-notes/5.4.0.html#314-storno-buchungen","title":"314 - STORNO-Buchungen","text":"<p>Behoben: 25.09.142 | Der Buchungsschl\u00fcssel 513 wird im Men\u00fc 314 nicht mehr zur Auswahl angezeigt, da es in der Vergangenheit bei dessen Verwendung zu Fehlern in der Verf\u00fcgbarkeitspr\u00fcfung kam.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#32-tagesabschluss","title":"32 - Tagesabschluss","text":"<p>Verbesserung: 25.09.118 | Bei Durchf\u00fchrung des Tagesabschlusses wurde eine Sicherheitsabfrage integriert: </p> <p>Info:</p> <p>Wollen Sie den Tagesabschluss wirklich durchf\u00fchren? JA / NEIN</p> <p>Die Abfrage soll verhindern, dass der Tagesabschluss versehentlich durch einen Klick auf die danebenliegende Schaltfl\u00e4che \u201e\u00dcbersicht drucken\u201c ausgel\u00f6st wird.</p> <p>25.10.219 | Zahlwege, die nicht auf der Tagesabschluss\u00fcbersicht erscheinen, werden k\u00fcnftig auch bei der Abfrage der Banktage im aktuellen Tagesabschluss nicht mehr aufgef\u00fchrt.</p> <p>Behoben: 25.10.001 | Die Tagesabschluss\u00fcbersicht und der Tagesabschluss werden beim Druck standardm\u00e4\u00dfig wieder im Hochformat ausgegeben. Ein Druck im Querformat erfolgt nur, wenn in den Druckvorlagen explizit die Option \u201eQuerformat\u201c ausgew\u00e4hlt wird.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#33-buchungsstapel","title":"33 - Buchungsstapel","text":"<p>Behoben: 25.09.117 | Die Verwendung der Buchungsschl\u00fcssel 231 und 233 wurde \u00fcberarbeitet. Unter bestimmten Konstellationen wurde vereinzelt ein bei BS231 ausgew\u00e4hltes Steuerkennzeichen auch an den Buchungssatz einer nachfolgenden Zahlwegsumbuchung mit BS233 geschrieben. Ein Verbuchen im Buchungsstapel war dadurch nicht m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#351-schnittstellen-einrichten","title":"351 - Schnittstellen Einrichten","text":"<p>Neu: 25.09.031 | Es wurde eine neue Ausgangsschnittstelle S_AUSGANG_ADR entwickelt, die den Export von Personenkontendaten einschlie\u00dflich Adressangaben erm\u00f6glicht. Die exportierten Daten k\u00f6nnen f\u00fcr die Weiterverwendung in Vorsystemen genutzt werden, beispielsweise in Verbindung mit ARCHIKART \u00fcber einen zyklischen Export \u00fcber den SASKIA.H2R-Jobserver.</p> <p>\u00dcber die Schnittstelle werden alle relevanten Felder aus den Personenkonten exportiert. \u00dcber Filteroptionen (z.\u202fB. PK-Bereiche, Debitor/Kreditor) k\u00f6nnen die zu exportierenden Daten entsprechend des Verwendungszweckes eingeschr\u00e4nkt werden.</p> <p>Die Schnittstelle ist eng mit der bereits vorhandenen SEPA-Exportschnittstelle verbunden.  </p>"},{"location":"aktuelles/release-notes/5.4.0.html#353-ausgangsschnittstellen","title":"353 - Ausgangsschnittstellen","text":"<p>Behoben: 25.09.061 | Das Men\u00fc 353 Ausgabe Schnittstellen wurde hinsichtlich der Aktualisierung von Schnittstellenparametern und dem Wechsel zwischen einzelnen Schnittstellen \u00fcberarbeitet. </p>"},{"location":"aktuelles/release-notes/5.4.0.html#391-personenkontenauskunft","title":"391 - Personenkontenauskunft","text":"<p>Verbesserung: 25.08.119 | In der Kassenakte, welche \u00fcber folgende Men\u00fcpunkte aufgerufen werden kann: - Men\u00fc 391: \u00fcber das \u201eEingangsregister\u201c  - Men\u00fc 311: \u00fcber das Gl\u00fchbirnen-Symbol am Personenkonto</p> <p>wird ab sofort eine Historie zu Mahn- und OP-Sperren gef\u00fchrt.  Dokumentiert werden das Anlegen, L\u00f6schen und \u00c4ndern von Sperren sowie der jeweilige Zeitpunkt und der verantwortliche Nutzer.</p> <p>Hinweis: Bei einer gesetzten OP-Sperre wird der Status mit \u201e1\u201c vermerkt, beim Entfernen der Sperre mit \u201e0\u201c.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":""},{"location":"aktuelles/release-notes/5.4.0.html#421-stundung","title":"421 - Stundung","text":"<p>Neu: 25.08.187 | Im Men\u00fc 421 besteht nun die M\u00f6glichkeit, die Stundungsraten hinsichtlich des Stundungsbetrags und der F\u00e4lligkeit anzupassen.</p> <p>Verbesserung: 25.10.225 | Die Erfassungsm\u00f6glichkeit zur Stundung mehrerer Offener Posten wurde verbessert.  Bisher war es erforderlich, in den Rateneditor f\u00fcr jeden einzelnen Offenen Posten \"abzutauchen\". Nun steht zus\u00e4tzlich die Schnelleingabe direkt in der Spalte \"Ratenschl\u00fcssel\" zur Verf\u00fcgung.  </p> <p>Beispiel:</p> <p>Monatlich = 1 Anzahl Raten = 3 Entspricht dem Ratenschl\u00fcssel 103 </p> <p>Dieser Wert kann direkt in die jeweilige Zelle des Offenen Postens eingetragen werden. Anschlie\u00dfend werden automatisch die entsprechenden Ratenzeilen erstellt, die wie gewohnt manuell bearbeitet werden k\u00f6nnen. Mit \u00dcbernehmen werden die gebildeten Raten gespeichert.  </p> <p>Behoben: 25.08.186 | Der Ratenassistent in der Stundung beachtet nun die Wochenend- und Feiertage korrekt. F\u00e4llt eine Stundungsrate auf einen Feiertag oder auf ein Wochenende, so wird der n\u00e4chste Werkttag als F\u00e4lligkeit verwendet. </p>"},{"location":"aktuelles/release-notes/5.4.0.html#45-pauschalwertberichtigung","title":"45 - Pauschalwertberichtigung","text":"<p>Behoben: 25.08.215 | Beim Abweisen von Anordnungen, welche mit der durchgef\u00fchrten Pauschalwertberichtigung in Verbindung stehen wird nun die \"AO-Druck\"-Checkbox zur\u00fcckgesetzt. Damit ist eine erneute Bearbeitung der Pauschalwertberichtigung wieder m\u00f6glich.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#4bx-mitteilungsverordnung","title":"4bx - Mitteilungsverordnung","text":"<p>WICHTIGE \u00c4NDERUNG: 25.11.148 | Es wurde eine Anpassung der Bagatellgrenzenpr\u00fcfung in Bezug auf die Mitteilungsverordnung vorgenommen!</p> <p>Die selbst einzustellende Bagatellgrenze von derzeit 3.000 EUR im Mandantenstamm (Men\u00fc 11) wird nun auch f\u00fcr \u00a72 MV gepr\u00fcft. Das hei\u00dft, der eingegebene Betrag im Mandantenstamm wird in allen F\u00e4llen vom System beim Erstellen der Mitteilungen gem\u00e4\u00df Mitteilungsveordnung gep\u00fcrft.</p> <p>In der Folge bedeutet dies, dass entweder eine manuelle Freigabe der Mitteilungen erfolgen muss, dass auch Meldungen unter der eingegebenen Bagatellgrenze \u00fcbermittelt werden oder der Betrag der Bagatellgrenze wird entgegen der gesetzlichen Vorgaben auf einen anderen Betrag eingestellt. </p> <p>Verbesserung:  25.11.149 | Zur besseren Bearbeitung der F\u00e4lle und f\u00fcr mehr \u00dcbersichtlichkeit wurden die Men\u00fcpunkte 4b1 und 4b2 angepasst:</p> <ul> <li> <p>Men\u00fc 4b2: </p> </li> <li> <p>Die Summen werden nun pro Steuer-ID ermittelt und als Gruppensumme beim Erstellen der Mitteilungen dargestellt.  </p> </li> <li> <p>Standardm\u00e4\u00dfig erfolgt die Gruppierung nach Steuer-ID, Rechtsgrundlage und Zahlungsgrund.</p> </li> <li> <p>Men\u00fc 4b1: </p> </li> <li> <p>Zur besseren \u00dcbersicht wurde im Rahmen der Pr\u00fcfungsfunktion die Gruppierung angepasst.  </p> </li> <li>Standardm\u00e4\u00dfig erfolgt die Gruppierung nach Steuer-ID, Vorgang und Offenen Posten (OP).</li> </ul> <p>25.11.156 | Die Anzeige in den Men\u00fcpunkten 4b1 und 4b2 zur Mitteilungsverordnung reagiert nun auf die Angabe des Haushaltsjahres - das bedeutet, dass Offene Posten eines zuk\u00fcnftigen Haushaltsjahres nicht mit angezeigt werden. </p> <p>Beispiel:</p> <p>Nach Auswahl des Haushaltsjahres 2024 werden keine OPs des Haushaltsjahres 2025 angezeigt, Im Jahre 2025 k\u00f6nnen jedoch noch OPs aus 2024 angezeigt werden, wenn diese nicht gemeldet wurden bzw. eine Vorgangsnummer vergeben wurde, die in 2025 weitergef\u00fchrt wird und erst dort zu melden ist. </p>"},{"location":"aktuelles/release-notes/5.4.0.html#4b1-ubersicht-mitteilungsverordnung","title":"4b1 - \u00dcbersicht Mitteilungsverordnung","text":"<p>Behoben: 25.09.127 | Zum L\u00f6schen von MV-relevanten Daten muss die Funktion \u00fcber das Papierkorb-Symbol auf der linken Seite der Tabelle verwendet werden. Dabei werden alle zugeh\u00f6rigen Informationen gel\u00f6scht. Aus diesem Grund werden jene offenen Zahlungen anschlie\u00dfend bei Auswahl des Filters \u201eOPs ohne MV-Informationen\u201c ebenfalls angezeigt.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":""},{"location":"aktuelles/release-notes/5.4.0.html#52-eingangsrechnungsjournal","title":"52 - Eingangsrechnungsjournal","text":"<p>Verbesserung: 25.05.051 | Im Men\u00fc 11 wurde im Reiter \u201eSchalter\u201c der neue Schalter \"F64 - maximale Anzahl ER-Positionen bei eRechnungen\u201c integriert. Mit diesem Schalter kann ein Maximalwert festgelegt werden, bis zu dem im Eingangsrechnungsjournal automatisch ER-Positionen aus eRechnungen angelegt werden.</p> <p>Standardm\u00e4\u00dfig ist der Schalter auf 100 eingestellt, sodass bei importierten Rechnungen alle enthaltenen Positionen automatisch angelegt werden. Es ist jedoch m\u00f6glich, einen beliebigen Wert zwischen 1 und 100 einzugeben. Wird beispielsweise der Wert 1 gew\u00e4hlt, wird nur eine Position automatisch erstellt.  </p> <p>25.10.062 | Wie bereits in der Einzelbuchungsmaske, wurde nun auch das Eingangsrechnungsjournal hinsichtlich der verpflichtenden Erfassung eines Steuerkennzeichens \u00fcberarbeitet.</p> <p>Bei der Verwendung eines Produktes oder eines Sachkontos mit Steuert 0 - keine Steuer, wird \"nicht steuerbar\" im Steuerkennzeichen eingetragen. In allen anderen F\u00e4llen handelt es sich um eine Pflichtfeldpr\u00fcfung, so dass bei Steuerart 1 - mit beliebiger Steuer immer ein Steuerkennzeichen anzugeben ist. Die Interpretation in diesem Zusammenhang auf \"nicht steuerbar\" entf\u00e4llt und muss manuell eingetragen werden.</p> <p>25.10.234 | Bei der DMS-Abfrage kann nun durch einen Doppelklick die R\u00fcckgabe der gew\u00fcnschten Rechnung direkt an die Erfassungsmaske ausgel\u00f6st werden. Das Verwenden der Schaltfl\u00e4che Daten zur\u00fcckgeben kann somit entfallen.</p> <p>Behoben: 25.10.057 | Beim Erstellen von Eingangsrechnungen mit mehreren Positionen, deren Buchungsstellen sich im gleichen Deckungskreis befinden, wird nun wieder korrekt die Deckung gepr\u00fcft, so dass ein \u00dcberziehen des Deckungskreises nicht m\u00f6glich ist. </p>"},{"location":"aktuelles/release-notes/5.4.0.html#54-ausgangsrechnungsjournal","title":"54 - Ausgangsrechnungsjournal","text":"<p>Behoben: 25.09.008 | Bei der Erfassung im Ausgangsrechnungsjournal k\u00f6nnen die Preise der einzelnen Positionen wieder korrekt ge\u00e4ndert werden.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#6-auswertungen","title":"6 - Auswertungen","text":""},{"location":"aktuelles/release-notes/5.4.0.html#6622-zahlungsvorschlag","title":"6622 - Zahlungsvorschlag","text":"<p>Behoben: 25.10.023  | Wird im Zahlungsvorschlag nachtr\u00e4glich der Skontobetrag hinterlegt, wird dieser nun wieder korrekt ausgewiesen und verbucht</p>"},{"location":"aktuelles/release-notes/5.4.0.html#6223-kontoauszug","title":"6223 - Kontoauszug","text":"<p>Behoben: 25.10.058 | Bei der Erstellung von Kontoausz\u00fcgen f\u00fcr mehrere Personenkonten mittels Mehrfachauswahl werden die \u00dcbertr\u00e4ge zu den folgenden Anschreiben nun korrekt dargestellt</p>"},{"location":"aktuelles/release-notes/5.4.0.html#623-summen-und-saldenliste","title":"623 - Summen- und Saldenliste","text":"<p>Behoben: 25.09.093 | Auf der Summen- und Saldenliste wird der Saldo wieder korrekt ausgewiesen.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#69-auswertungszentrale","title":"69 - Auswertungszentrale","text":"<p>Verbesserung: 25.08.097 | Die Datenaufbereitung der Verbindlichkeits\u00fcbersicht im Kontext \u201eKredite\u201c wurde f\u00fcr das Bundesland Sachsen \u00fcberarbeitet. Die Einteilung erfolgt nun ausschlie\u00dflich (Schalter F51 = Ja) anhand des in den Kreditstammdaten hinterlegten \u201eLaufzeit bis\u201c-Datums und nicht mehr anhand der Laufzeitenspalten (Verbindlichkeiten zum Ende des Haushaltsjahres mit einer Restlaufzeit). Die bisherige Ermittlung anhand der gebildeten Raten hatte eine gewisse Unsch\u00e4rfe, insbesondere im Zusammenhang mit m\u00f6glichen Zinsbindungen. Somit wird dem nachfolgenden FAQ Rechnung getragen:</p> <p>5.5 Gliederung von Forderungen und Verbindlichkeiten nach Fristen - Kommunale Verwaltung - sachsen.de  </p> <p>Info:</p> <p>\"\u2026Zinsbindungsfristen oder eine durch einen (fiktiven) Tilgungsplan errechnete Laufzeit bis zum Zeitpunkt der vollst\u00e4ndigen R\u00fcckzahlung (zum Beispiel eines Darlehens) sind f\u00fcr die Laufzeitberechnung unerheblich.\"</p> <p>Mit der Druckoption \u201eKonten-/Kreditnachweis\u201d wird nun je ausgewiesenem Kredit mehr Transparenz und Nachvollziehbarkeit geschaffen. Neben der Laufzeit werden auch die gebildeten Raten \u00fcbersichtlich aufgef\u00fchrt.</p> <p>25.08.171 | Bei der Eingabe eines Produktes oder einer Ma\u00dfnahme im Sachkontenauszug reagiert das Programm mit der ausschlie\u00dflichen Auswahlm\u00f6glichkeit des Druckes \"nach Buchungsstellen\". Bisher konnte man es auch nach Sachkonto anzeigen, allerdings hat das Programm dann keine Einschr\u00e4nkungen mehr ber\u00fccksichtigt. </p> <p>25.08.184 | Beim Sachkontenauszug ist die Eingabereihenfolge nun:  1. Produkt  2. Sachkonto  3. Ma\u00dfnahme  </p> <p>Behoben:  25.10.131 | In der Auswertung \"M30 - Anlagespiegel\" (Anlage\u00fcbersicht) wurde die Option Gesamtsummenzeile hinzugef\u00fcgt.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#7-jahresabschluss","title":"7 - Jahresabschluss","text":""},{"location":"aktuelles/release-notes/5.4.0.html#731-rap-verwaltung","title":"731 - RAP-Verwaltung","text":"<p>25.10.171 | Manuell \u00fcber das Men\u00fc 731 erfasste Rechnungsabgrenzungsposten (RAP), deren Status noch \"erfasst\" ist, k\u00f6nnen mit der Abgrenzung und Aufl\u00f6sung weiter in die Zukunft verschoben werden. Dies kann beispielsweise erforderlich sein, wenn eine Anpassung im Rahmen des Jahresabschlusses vergessen wurde.  </p> <p>Voraussetzungen: - Das Belegdatum muss angepasst werden. - Der \"von\"-Zeitraum und ggf. der \"bis\"-Zeitraum m\u00fcssen verschoben werden. - Diese Funktion ist nur f\u00fcr noch nicht gebuchte Abgrenzungen und Aufl\u00f6sungen verf\u00fcgbar.  </p> <p>Hinweis: Wenn der RAP zusammen mit der OP-Erfassung erfasst wurde (Status \"offen\"), sind die Abgrenzung im Ursprungsjahr sowie die RAP-Aufl\u00f6sung im ersten Jahr bereits gebucht. In diesem Fall kann \u00fcber das Bearbeiten des RAP im Men\u00fc 731 nur noch die Aufl\u00f6sungsbuchung durch Verschiebung des Zeitraums beeinflusst werden.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#735-dk-budgetausgleich-neuer-menupunkt-menurechte-beachten","title":"735 - DK-Budgetausgleich (Neuer Men\u00fcpunkt - Men\u00fcrechte beachten!)","text":"<p>Neu: 25.08.137 | Bei der Arbeit mit Deckungskreisen kann, abh\u00e4ngig vom Schalter \"F62 \u2013 Buchungsstelle im Deckungskreis automatisch \u00fcberbuchen\", ein automatischer, systemseitig gesteuerter Ausgleich der Buchungsstellen im Deckungskreis erfolgen. Die dann eigentlich \u00fcberzogenen Buchungsstellen werden gegen einen Saldo von 0,00 Euro im Rahmen der Bedingungen des Deckungskreises ausgeglichen.</p> <p>Um den fortgeschriebenen Planansatz mit dem tats\u00e4chlichen Wert darstellen zu k\u00f6nnen, wurde das Men\u00fc \"735 \u2013 DK Budgetausgleich\" f\u00fcr Deckungskreise geschaffen.</p> <p>Nach der Auswahl des auszugleichenden Deckungskreises werden alle Buchungsstellen des Deckungskreises sowie die dazugeh\u00f6rigen Ausgleichszahlungen angezeigt. Nach Auswahl der auszugleichenden Buchungsstellen kann unter Angabe eines Buchungstextes und eines Buchungsdatums die Budgetumbuchung im Rahmen der bereits get\u00e4tigten Mittelbewirtschaftung als Planbuchung ausgef\u00fchrt werden. </p>"},{"location":"aktuelles/release-notes/5.4.0.html#8-veranlagung","title":"8 - Veranlagung","text":""},{"location":"aktuelles/release-notes/5.4.0.html#81-einzelveranlagung","title":"81 - Einzelveranlagung","text":"<p>Behoben: 25.05.220 | Der Prozess zur Neuanlage von Objekten aus der Grundsteuermeldung wurde \u00fcberarbeitet. Dabei wurde eine bislang teilweise fehlerhafte Zuordnung des Buchungs- und Rundungscodes zu neu angelegten Objekten korrigiert.</p> <p>25.09.079 | Bei der Auswahl eines Personenkontos werden mit jedem Aktualisierungsvorgang ab sofort wieder alle aktiven Objekte zur weiteren Bearbeitung angezeigt. In den vergangenen Monaten kam es in diesem Zusammenhang zu Problemen, durch die nicht immer alle Objekte unmittelbar sichtbar waren. Dieses Verhalten wurde korrigiert.</p> <p>25.10.136 | In bestimmten F\u00e4llen wurden die Veranlagungsarten zur Abrechnung nicht mehr vorgeblendet. Dieses Verhalten wurde korrigiert, sodass nun wieder alle im Kontext der letzten Veranlagung eines Steuerjahres m\u00f6glichen Folge-Veranlagungsarten zur Auswahl angezeigt werden.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#844-freie-auswertungen","title":"844 - Freie Auswertungen","text":"<p>Verbesserung: 25.10.127 | Die Auswertung FQ7780 wurde um den Parameter \u201eOhne 0-Summenbescheide\u201c erweitert. Wird dieser Parameter mit \u201eJ\u201c bef\u00fcllt, werden bei der Auswertung alle Bescheide von der Pr\u00fcfung ausgeschlossen, deren letzte Veranlagungssumme 0 betr\u00e4gt. Dadurch werden beispielsweise Eigent\u00fcmerwechsel nicht mehr als unn\u00f6tige Eintr\u00e4ge in der Liste ausgewiesen.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#861-gewerbesteuer-meldungen","title":"861 - Gewerbesteuer-Meldungen","text":"<p>Verbesserung: 25.08.136 | Die Darstellung der Meldungsdetails wurde vereinheitlicht, um eine konsistente und einheitliche Anzeige von Informationen in allen relevanten Bereichen sicherzustellen.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#862-grundsteuer-meldungen","title":"862 - Grundsteuer-Meldungen","text":"<p>Verbesserung: 25.08.047 | F\u00fcr die Ansicht mehrerer Meldungen in den Details m\u00fcssen diese nun vorher markiert werden. Es werden nicht mehr automatisch alle Meldungen der Tabelle geladen, wodurch bei einer gro\u00dfen Anzahl an Meldungen die Ladezeit verk\u00fcrzt wird. Empfohlen wird weiterhin, die Selektion \u00fcber das Aktenzeichen vorzunehmen.</p> <p>Behoben: 25.10.174 | Das Leeren des Notizfeldes in den Details einer Grundsteuermeldung ist ab sofort wieder m\u00f6glich.</p> <p>25.11.007 | Ab sofort wird bei der Aktion Messbetrags\u00e4nderung bei \u00c4nderungsveranlagungen die korrekte Veranlagungsart \"VB\" bzw. \"AB\" gesetzt. Bisher wurde auch bei \u00c4nderungsveranlagungen immer die Veranlagungsart \"V\" in die Tarifzeile \u00fcbernommen.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#9-barkasse","title":"9 - Barkasse","text":""},{"location":"aktuelles/release-notes/5.4.0.html#911-kassen","title":"911 - Kassen","text":"<p>Verbesserung: 25.10.110 | In den Stammdaten der Barkasse (Men\u00fc 911) wurde das neue Feld \u201eAusgabeklasse des Bondruckers\u201c erg\u00e4nzt. Um eine korrekte Zuordnung des Bondruckers f\u00fcr eine Barkasse sicherzustellen, muss im Men\u00fc 1y2 eine Ausgabeklasse mit dem entsprechenden Bondrucker verkn\u00fcpft und anschlie\u00dfend in der 911 zugeordnet werden.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#92-einnahme-und-ausgabe-kasse","title":"92 - Einnahme und Ausgabe Kasse","text":"<p>Neu: 25.09.048 | Benutzer haben nun die M\u00f6glichkeit Standardwerte zu definieren. Folgende Optionen stehen zur Verf\u00fcgung:</p> <ul> <li>Standard-Tarif pro Kasse, GV und Mitarbeiter</li> <li>Standard-GV pro Kasse und Mitarbeiter</li> <li>Standard-Kasse pro Mitarbeiter</li> </ul> <p>25.12.021 | Beim Tagesabschluss besteht nun die M\u00f6glichkeit, Schwebeposten aus der Barkasse zusammenzufassen. Hierf\u00fcr wurde in den Stammdaten der Barkasse (Men\u00fc 911) ein Indikator f\u00fcr die Zusammenfassung von Schwebeposten der Kartenzahlungen (EC-Terminal ID) eingef\u00fchrt:</p> <ul> <li>Ist in diesem Feld nichts eingetragen, werden weiterhin alle Schwebeposten einzeln gebildet.</li> <li>Ist ein Wert hinterlegt, erfolgt die Zusammenfassung der Schwebeposten anhand der Scheck-Nr. bzw. EC-Terminal ID, die variabel festgelegt werden kann.</li> </ul> <p>Verbesserung: 25.09.050 | Wenn f\u00fcr einen Gesch\u00e4ftsvorfall eine Notiz eingegeben wird, wird diese nun sowohl auf der Quittung als auch im Kassenbuch als eigene Spalte angezeigt. Auf der Quittung kann die Notiz \u00fcber die Vorlagenoption bei Bedarf auch ausgeblendet werden. </p> <p>25.09.109 | Aus der Barkasse heraus ist es nun m\u00f6glich Buchungsstapel variabel umzubenennen. Hierf\u00fcr wurde ein neuer Men\u00fcpunkt 914 \u2013 Buchungsinformationen eingef\u00fchrt.  In diesem kann die Umbenennung des Stapelnahmen entweder auf Basis einer dynamischen Vorlage gebildet werden, welche durch die Fachberatung eingerichtet werden muss, oder der Stapelname kann manuell bei jedem \"Stapelbuchen\" in der Barkasse vergeben werden.</p> <p>25.10.195 | Gesch\u00e4ftsvorf\u00e4lle k\u00f6nnen nun pro Benutzer und Mandant berechtigt werden. In der Benutzerverwaltung wurde daf\u00fcr das neue Recht \u201eBarkasse Gesch\u00e4ftsvorf\u00e4lle\u201c eingef\u00fchrt. Mit diesem Recht l\u00e4sst sich steuern, welche Gesch\u00e4ftsvorf\u00e4lle einem Benutzer zur Auswahl stehen.</p> <p>25.11.075 | F\u00fcr Einzahlungen und Auszahlungen mit Personenkonto (PK) ist es nun m\u00f6glich, einen abweichenden Einzahler bzw. Empf\u00e4nger auf der Quittung einzutragen. Der Zahlungspflichtige (PK) wird dabei ebenfalls auf der Quittung ausgewiesen. Hierf\u00fcr wurde die Vorlagenoption \"abweichendes PK nicht drucken\" integriert, \u00fcber die gesteuert werden kann, ob das PK auf der Quittung gedruckt werden soll oder nicht.</p> <p>Behoben: 25.09.116 | Bei Einnahmen auf offene Posten (OP) kann der Betrag eines offenen Postens nun ver\u00e4ndert werden.</p> <p>25.10.112 | Bei Buchungen \u00fcber die Einzelbuchungsmaske wird der Einzahler/Empf\u00e4nger nun korrekt in das Barkassenmodul \u00fcbernommen.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":""},{"location":"aktuelles/release-notes/5.4.0.html#b11-anlagegut-bearbeiten-b21-zuschuss-bearbeiten","title":"b11 - Anlagegut bearbeiten | b21 - Zuschuss bearbeiten","text":"<p>Behoben: 25.08.112 | In den Men\u00fcpunkten b11 und b21 wird auf der rechten Seite bei Bedarf ein vertikaler Scrollbalken eingeblendet, wenn die Ansicht stark vergr\u00f6\u00dfert ist.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#f1-steuerkompass","title":"f1 - Steuerkompass","text":"<p>Neu: 25.10.100 | Es stehen neue Kategorien zur Pr\u00fcfung im Rahmen des Steuerkompass zur Verf\u00fcgung. </p> Im Bereich Liegenschafts- und Geb\u00e4udemanagement stehen folgende Erweiterungen zur Verf\u00fcgung: \u00f6ffentliche Fl\u00e4chen / Grundst\u00fccksverkauf (Hinweis: au\u00dferhalb der Boden- und Siedlungspolitik!) kulturelle Einrichtungen/Bibliothek Im Bereich der Leistungs- und Lieferbeziehungen umfasst die Erweiterung die folgenden Themenbereiche: innere Verwaltung/ Verkaufsgesch\u00e4fte Gemeindeveranstaltungen/ Seniorenfahrt Gemeindeveranstaltungen/ Gemeindeabend Gemeindeveranstaltungen/ Feiern und Feste"},{"location":"aktuelles/release-notes/5.4.0.html#k-kostenrechnungcontrolling","title":"k - Kostenrechnung/Controlling","text":""},{"location":"aktuelles/release-notes/5.4.0.html#allgemein_1","title":"Allgemein","text":"<p>Verbesserung: 25.11.056 | Im Modul Controlling  wurden die Drop-down-Men\u00fcs angepasst. So kann beispielsweise bei der Sachkontenauswahl das Men\u00fc in der Breite angepasst werden, um auch Sachkonten mit \u00e4hnlichen Bezeichnungen besser unterscheiden und ausw\u00e4hlen zu k\u00f6nnen.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#k2-buchung","title":"k2 - Buchung","text":"<p>Verbesserung: 25.09.014 | Die Schaltfl\u00e4chen + (Neuer Datensatz) und \"Papierkorb\" wurden in die Toolbar verschoben.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#k61-kostenarten","title":"k61 - Kostenarten","text":"<p>Verbesserung: 25.11.057 | Die im Men\u00fcpunkt 11 \u2013 Pflege Mandant festgelegten Einschr\u00e4nkungen f\u00fcr Konten werden nun auch bei der Sachkontenauswahl im Men\u00fcpunkt k61 ber\u00fccksichtigt. Es werden nur die Sachkonten angezeigt, die im Men\u00fcpunkt 11 definiert wurden.</p> <p>Behoben: 25.10.135 | Im Men\u00fc k61 wurde der Eintrag \"Leer\" hinzugef\u00fcgt. Damit ist es nun m\u00f6glich, die ausgew\u00e4hlte Kostenstelle oder den ausgew\u00e4hlten Kostentr\u00e4ger zu entfernen, ohne eine andere Kostenstelle oder einen anderen Kostentr\u00e4ger ausw\u00e4hlen zu m\u00fcssen.</p> <p>25.11.095 | Es wurde ein Fehler korrigiert, durch den \u00c4nderungen im Men\u00fc k61 nicht gespeichert werden konnten. \u00c4nderungen k\u00f6nnen nun wieder wie vorgesehen \u00fcbernommen und gespeichert werden.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#k64-gruppenbereiche","title":"k64 - Gruppen/Bereiche","text":"<p>Verbesserung: 25.02.057 | Kostenartengruppen, Kostenstellenbereiche oder Kostentr\u00e4gerbereiche k\u00f6nnen per Ins / Del Taste eingef\u00fcgt bzw. gel\u00f6scht werden.</p>"},{"location":"aktuelles/release-notes/5.4.0.html#systemverwaltung","title":"Systemverwaltung","text":""},{"location":"aktuelles/release-notes/5.4.0.html#s31-releasewechsel","title":"s31 - Releasewechsel","text":"<p>Neu: 25.10.093 | Der Releasewechselpunkt \"L\u00f6schen \u00fcberfl\u00fcssiger Steuernummern in Hauptobjekten der Grundsteuer\" ist optional und  nur f\u00fcr Kunden relevant, welche in der Grundsteuer mit Unterobjekten arbeiten. Hintergrund sind Aktenzeichen des Finanzamtes welche sowohl am Hauptobjekt als auch am Unterobjekt hinterlegt sind und somit zu fehlerhaften Auswertungsergebnissen f\u00fchren. Dieser Releasewechselpunkt l\u00f6scht alle Aktenzeichen am Hauptobjekt sofern es eine aktives Unterobjekt dazu gibt.</p>"},{"location":"aktuelles/releasehistorie/index.html","title":"Releasehistorie","text":""},{"location":"aktuelles/releasehistorie/index.html#releasehistorie","title":"Releasehistorie","text":"<p>Release 4.1.0072 Release 4.1.0071 Release 4.1.0070 Release 4.1.0069 Release 4.1.0068 Release 4.1.0067 Release 4.1.0066 Release 4.1.0065 Release 4.1.0064 Release 4.1.0063 Release 4.1.0062 </p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/index.html","title":"Release 4.1.0048","text":""},{"location":"aktuelles/releasehistorie/release4.1.0048/index.html#release-410048","title":"Release 4.1.0048","text":"<p>Installation Checkliste Release 4.1.0048 </p> <p>Programm\u00e4nderungen Release 4.1.0048 </p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/installation_checkliste_relea2.html","title":"Installation Checkliste Release 4.1.0048","text":""},{"location":"aktuelles/releasehistorie/release4.1.0048/installation_checkliste_relea2.html#installation-checkliste-release-410048","title":"Installation Checkliste Release 4.1.0048","text":"<p>Vorg\u00e4ngerrelease ist Release 47 </p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/installation_checkliste_relea2.html#update-releasewechsel","title":"Update / Releasewechsel","text":"<p>1. Alle SASKIA\u00ae.de IFR-Nutzer abmelden  (auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 48.</p> <p>3. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>F\u00fchren Sie den Releasewechsel f\u00fcr das Release 48 durch. </p> <p> Bei SQL-Server-Kunden kann es zu einem l\u00e4ngeren Releasewechsel kommen. Der vierte Punkt des Releasewechsels (\u201eUmstellen der Tabelle KP_VKZ_WERTE bzgl. ROWID-Spalte\u201c) muss vollst\u00e4ndig erf\u00fcllt sein, bevor weiter gearbeitet werden kann. </p> <p>Nach Abschluss von Online-Update und Releasewechsel kann die Weiterarbeit im Finanzwesen erfolgen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html","title":"Programm\u00e4nderungen Release 4.1.0048","text":""},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html#programmanderungen-release-410048","title":"Programm\u00e4nderungen Release 4.1.0048","text":""},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html#allgemein","title":"Allgemein","text":"<p>Umstellung der Hilfefunktion auf eine Webhilfe </p> <p>Um eine bessere Aktualit\u00e4t der IFR-Hilfe zu erreichen, kann diese nun online abgerufen werden. Damit sind Anpassungen schneller m\u00f6glich. Voraussetzung ist ein Internetzugang bei allen Client-Rechnern. Ein weiterer Vorteil besteht darin, dass sich die Downloadzeit erheblich verk\u00fcrzt, da nicht bei jedem Release die gesamte Hilfe heruntergeladen werden muss.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html#stammdaten","title":"Stammdaten","text":"<p>1278 \u2013 Banken </p> <p>Die Verlinkung auf die Bundesbankwebseite zum Import von BICs wurde aktualisert.</p> <p>127c \u2013 Verteilungsringe </p> <p>Das Anlegen und die Bearbeitung der Verteilungsringe wurde grundlegend \u00fcberarbeitet. Somit ist ein nutzerfreundliches Bedienen der Verteilungsringe m\u00f6glich. Weiterhin wurde die Pr\u00fcfung bei der Verwendung der Verteilungsringe in der Buchungsmaske (311) dahingehend erweitert, dass er beim \u00dcbernehmen der Buchung nochmalig pr\u00fcft, ob der ausgew\u00e4hlte Verteilungsring \u00a0zu der eingegebenen Buchungsstelle passt.</p> <p>12a1 \u2013 Adressstammdaten </p> <p>Bei der Umschl\u00fcsselung k\u00f6nnen Satzarten ausgew\u00e4hlt und \u00fcbernommen werden. Wenn keine Daten \u00fcbernommen worden sind, wird nun eine Info-Box mit der Meldung 'Keine Protokoll-Eintr\u00e4ge vorhanden.' ausgegeben. Damit ist der Anwender informiert, dass kein Protokoll generiert worden ist, weil keine Umschl\u00fcsselung stattgefunden hat.</p> <p>12a3 \u2013 Adressverwaltung </p> <p>Zusatzadressen k\u00f6nnen aktiviert und deaktiviert werden. Die Angabe dazu ist bereits im Tab 'Zusatzadressen' \u00a0erkennbar.</p> <p>In den Kontoverbindungen zum Personenkonto ist ein neues Kennzeichen \"F\u00fcr alte F\u00e4lligkeiten\" zur besseren Steuerung der Abbuchbarkeit von OP's eingef\u00fchrt wurden. Das Kennzeichen steht Standardm\u00e4\u00dfig auf \"Nein\", was bedeutet dass bei der Vorschlagsliste f\u00fcr Lastschriften nur OP's mit einbezogen werden deren F\u00e4lligkeit innerhalb der Mandatsg\u00fcltigkeit liegen. Bei \"Ja\" werden auch OP's mit zur\u00fcckliegenden F\u00e4lligkeiten ber\u00fccksichtigt.</p> <p>Historische Bankverbindungen werden im \u00a0Adressstammblatt nicht mehr angezeigt.</p> <p>Das Adressstammblatt wurde dahingehend erweitert, da\u00df er jetzt die am Personenkonto vorhandenen Sperren getrennt nach OP-Sperren und Sperren aus Wertberichtigungen mitausweist.</p> <p>In der \u00dcbersichtsmaske ist jetzt auch das L\u00f6schdatum des Mandats ersichtlich.</p> <p>12a7 \u2013 SEPA-Verwaltung </p> <p>Auf der Mandatsliste wird jetzt das L\u00f6schdatum mit angedruckt.</p> <p>Es ist nun m\u00f6glich, den Namen eines Kreditinstituts (Bankname) in Ausdrucken der SEPA-Verwaltung (12a7) mit zu drucken, wenn das Feld Bank: {sbank} im entsprechenden Textbaustein (1y1) an der gew\u00fcnschtren Stelle eingef\u00fcgt ist. Davon betroffen sind die Reportlsiten F00071, F00072 und F00073.</p> <p>12a8 \u2013 Auswertung Infotext </p> <p>Die \u00dcbersicht der Infotexte ist um die Spalte des PK-Namen erweitert wurden.</p> <p>12a9 \u2013 Mandate l\u00f6schen </p> <p>Es ist jetzt m\u00f6glich, nicht genutzte Mandate zu l\u00f6schen. Das kann \u00fcber den Schalter F38 gesteuert werden. Derzeit 36 Monate nicht genutzte Mandate. Au\u00dferdem gibt einen neuen Report (FR_00075_SepaMandateloeschbar.mrt) mit dem Sie jetzt die M\u00f6glichkeit haben, die zur L\u00f6schung bereitstehenden Mandate in einer Liste auszudrucken.</p> <p>152 \u2013 Einnahmearten </p> <p>In der Einrichtung der Einnahmeart kann man ein Kennzeichen setzen, dass Unterobjekte zul\u00e4ssig sind.</p> <p>153 \u2013 Eigent\u00fcmerwechsel </p> <p>Die Filterung nach der Adressnummer funktioniert wieder im Men\u00fc 153 \u00a0Eigent\u00fcmerwechsel.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html#planung","title":"Planung","text":"<p>242 \u2013 Ergebnisplan </p> <p>RTF-Edit Komponente wurde eingef\u00fcgt, sodass die Textbearbeitung im Ergebnisplan nun einfacher zu bedienen ist.</p> <p>27 \u2013 Neue Buchungsstelle </p> <p>Im Men\u00fc 27 Neue Buchungsstelle Reiter \"\u00dcbernahme Buchungsstellen Vorjahr\" werden jetzt alle Bilanzkonten unabh\u00e4ngig von der Kontoart zur \u00dcbernahme angeboten.</p> <p>294 \u2013 Druckliste Mittelanforderung </p> <p>In der Mittelanforderung sind die einzelnen Druckreports f\u00fcr Antrag, Nachtrag und Formular zu einerm Druckreport zusammengefasst. Gleichzeitig ist die Selektionsmaske f\u00fcr die Mittelanforderung dahingehend \u00fcberarbeitet wurden.</p> <p>29a \u2013 Voraussichtlich f\u00e4llige Auszahlungen aus VE </p> <p>Der Report ist dahingehend angepasst wurden, da\u00df bei einem Doppelhaushalt im ersten Doppelhaushaltsjahr die f\u00fcr das jeweilige Haushaltsjahr geplanten Verpflichtungserm\u00e4chtigungsbetr\u00e4ge zusammenadiert werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html#buchung","title":"Buchung","text":"<p>311 \u2013 Einzelbuchung </p> <p>Es werden keine Buchungen auf historische oder nicht aktive Bankverbindungen zugelassen. Macht man eine Buchung auf einen OP der urspr\u00fcnglich auf die historische Bankverbindung gebucht wurde, wird die aktuelle aktive Standardbankverbindung verwendet. Wird ein OP bebucht, der urspr\u00fcnglich eine andere aktive Bankverbindung hinterlegt hatte (diese Bankverbindung ist derzeit nicht mehr aktiv) , so kommt ein entsprechendes Infofenster. Die alte Bankverbindung wird dann zwar mit ausgewiesen, kann aber nicht f\u00fcr die Buchung ausgew\u00e4hlt und verwendet werden.</p> <p>In der Vergangenheit war es m\u00f6glich, auf schon beendete Ma\u00dfnahmen (Gilt bis &lt; aktuelles Tagesadatum) zu buchen. Das wird zuk\u00fcnftig verhindert. Wird eine Buchungsstelle in der Buchungsmaske oder im Eingangsrechnungsjournal ausgew\u00e4hlt bzw. soll ein Auftrag mit einem Liefertag nach dem Endedatum der Ma\u00dfnahme angelegt werden, kommt eine Informationsmeldung, dass die Ma\u00dfnahme zu diesem Zeitpunkt nicht mehr g\u00fcltig ist.</p> <p>313 \u2013 Sicherheitseinbehalt </p> <p>Die Liste Sicherheitseinbehalte im Men\u00fc 313 wurde hinsichtlich des korrekten Ausweises von stornierten Sicherheitseinbehalten \u00fcberarbeitet.</p> <p>32 \u2013 Tagesabschluss </p> <p>In den Report FR_20071_Tagesabschluss_Uebersicht ist eine neue Druckoption \u00a0 (rechter Mausklick auf \u201e\u00dcbersicht drucken\u201c, Reiter Voelagenoption) \u00a0integriert wurden. Sie dient dazu die Spalte \"Schwebeposten\" in der Tagesabschluss\u00fcbersicht auszublenden. Denn wenn der Mandantenschalter F24 = Nein, dann ist die Spalte immer Null.</p> <p>In der Istfortschreibung des Tagesabschluss werden Buchungen mit Buchungsschl\u00fcssel 331 korrekt als Ein- / Auszahlungen ber\u00fccksichtigt. Dadruch ist eine korrekte Zahlwegsumbuchung mit Hilfe der Buchungsschl\u00fcssel 231 und 331 (ohne diversen Debitor / Kreditor) m\u00f6glich.</p> <p>Bei der Verwendung von Slashes \"/\" am Anfang und Ende bzw. bei Verwendung von zwei Slashes \"//\" im Verwendungszweck, kam es zum Abweisen von Zahlungsdateien (keine g\u00fcltige SEPA-Datei). Hintergrund ist die neue im Herbst 2016 in Kraft getretene SEPA-Spezifikation, die so was nicht mehr erlaubt. Kommt es trotzdem zu solchen Eintr\u00e4gen im Verwendungszweck, werden diese aus dem Verwendungszweck entfernt.</p> <p>33 \u2013 Buchungsstapel </p> <p>Anzeige der fehlerhaften Buchungen in einem Buchungsstapel (in der oberen Tabelle) z\u00e4hlt wirklich nur die fehlerhaften Buchungen.</p> <p>Im Buchungsstapel (Men\u00fc 33) werden der Name des Debitors bzw. Kreditors wieder als Tooltipp angeboten, d. h. um den Namen angezeigt zu bekommen muss man mit dem Mauszeiger kurz \u00fcber der PK-Nummer stehen bleiben.</p> <p>Buchungen ( u. A. Auszifferungen) k\u00f6nnen wieder \u00fcber den Buchungsstapel bearbeitet werden. </p> <p>351 \u2013 Schnittstellen Einrichten </p> <p>Beim Anlegen der Schnittstelle Ausgang_Plus (s_ausgang_plus.stf) kam es zu einem Installationsfehler. Der Fehler ist beseitigt, die Schnittstelle l\u00e4\u00dft sich jetzt ordentlich mandantenweise installieren und deinstallieren.</p> <p>3521 \u2013 Eingangsschnittstelle einlesen </p> <p>Die Schnittstellenparameter sind um die Parameter \"Standard FV-Gruppe Debitor\" und \"Standard FV-Gruppe Kreditor\" erweitert wurden. Standardm\u00e4\u00dfig stehen die Parameter auf \"DP\" oder \"KP\". Der Parameter f\u00fcllt das Schnittstellenfeld \"FV_Gruppe\" wenn dieses aus Vor-System als \"leer\" in der Schnittstellendatei \u00fcbergeben wird. Ist in der Schnittstellendatei die \"FV_Gruppe\" gef\u00fcllt, wird auch diese in der Schnittstelle behalten.</p> <p>Umstellung des MT940 Formates auf das neue Format CAMT053. Dazu wurde eine neue Eingangsschnittstelle S_CAMT043.STF erstellt. Damit werden die Kontoauszugsdaten komplett in einem XML-Datenformat dargestellt.</p> <p>353 \u2013 Ausgabeschnittstellen </p> <p>Bei der Pr\u00fcfung der Daten f\u00fcr die Erstellung der SEPA-XML-Dateien wurde eine Erweiterung der Hinweismeldung \u00a0(Mand: 0668/U-1-000055 IBAN: sind(ist) ung\u00fcltig.) f\u00fcr die Protokolldatei vorgenommen, damit ist jetzt schneller ersichtlich bei welchem Mandanten und in welchem Lastschrift-/Zahllauf der Fehler liegt.</p> <p>36 \u2013 Anordnungsverwaltung </p> <p>AO-Listen mit \u00fcber 1.000 Buchungen k\u00f6nnen \u00fcber das Programm abgewiesen werden.</p> <p>F\u00fcr Kunden mit DMS  Die Best\u00e4tigung der Anordnung kann zuk\u00fcnftig auch im DMS erfolgen. Dazu wird ein Webservice im IFR zur Verf\u00fcgung gestellt, an den das DMS die Best\u00e4tigung zur\u00fcckgeben kann.</p> <p>Auf dem Anordnungsformular wird jetzt wieder korrekt das H\u00e4kchen f\u00fcr die Auszahlungssperre ausgewiesen.</p> <p>391 \u2013 Personenkontenauskunft </p> <p>Personenkontenausz\u00fcge f\u00fcr Kreditoren k\u00f6nnen auch in diesem Men\u00fc gedruckt werden. Der Reiter \u00c4nderungsvereinbarung wurde um die Fukntion \"L\u00f6schen\" erg\u00e4nzt. Eine \u00c4nderungsvereinabrung kann daher auch im Status \"gedruckt\"(noch nicht AO-Druck) \u00a0zur\u00fcckgenommen werden.</p> <p>Nach dem Abtauchen in die Personenkontensuche kam es verschiedentlich zu Problemen (falsche Anzeige von Buchungsdaten, OP's, Verbuchung auf falsche Mandanten) wenn das Kennzeichen D und K, der Mandant bzw. der Buchungsschl\u00fcssel gewechselt wurde. Das Verhalten ist dahingehend ver\u00e4ndert wurden, da\u00df beim Wechsel zwischen D und K, Mandant, Buchungsschl\u00fcssel die gespeicherten Suchergebnisse in der Personenkontensuche gel\u00f6scht werden.</p> <p>392 \u2013 Sachkontenauskunft </p> <p>Im Register \u201cVerf\u00fcgbarkeitsdetails\u201c werden nun die Daten aus den Vorjahren angezeigt: - \u00dcbertrag aus Vorjahren - davon in Anspruch genommen - noch verf\u00fcgbare Mittel aus Vorjahren</p> <p>Ebenso ist in den Verf\u00fcgbarkeitsdetails eine neue Zeile \"reservierte Finanzrechnungsmittel\" eingef\u00fcgt wurden. In dieser Zeile werden, in der Spalte Auszahlungen, die noch nicht verbrauchten Mittel einer SOLL-Stellungsbuchung angezeigt. Weiterhin ist eine \u00c4nderung bei der Anzeige der Verf\u00fcgbarkeitsdetails durchgef\u00fchrt wurden, es werden jetzt immer beide Spalten (SOLL-Stellung, Auszahlungen) angezeigt egal ob nach einem Bilanz-/ER- /FR-Konto selektiert wurde.</p> <p>394 \u2013 Budget\u00fcbersicht </p> <p>In de Budget\u00fcbersicht wurde die Bezeichnung der Spalte F in \"Plan insgesamt\" ge\u00e4ndert, da lt. S\u00e4chsKomHVO-Doppik Sperren nicht ber\u00fccksichtigt werden und somit ein korrekter Abgleich mit der Ergebnisrechnung erfolgen kann.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html#op-bearbeitung","title":"OP-Bearbeitung","text":"<p>41 \u2013 Auszifferung </p> <p>In der Auszifferungsmaske wurde der Ablauf der buchungsrelevanten Felder mittels Tastatur ( Tabulatator-Taste) optimiert.</p> <p>421 \u2013 Stundung </p> <p>Beseitigung des SQL-Fehlers, wenn eine erfasste Stundung editiert wird.</p> <p>422 \u2013 Stundung Druckliste </p> <p>Auf der Stundungsliste wurde ein offener OP-Betrag doppelt f\u00fcr einen F\u00e4lligkeitszeitpunkt ausgewiesen. Dies wurde korrigiert.</p> <p>441/ 442/ 444 \u2013 Niederschlagung, Einzelwertberichtigung </p> <p>Die Niederschlagung sowie Einzelwertberichtigung wurden auch auf Nebenbuchwerke umgestellt. Niederschlagung und Einzelwertberichtigungs-AOs k\u00f6nnen \u00fcber die Anordnungsverwaltung (Men\u00fc 36) mehrstufig best\u00e4tigt (beim Arbeiten mit einem DMS) oder abgewiesen werden. Bisher galten die AOs gleich als best\u00e4tigt. Durch das Abweisen ist eine weitere Bearbeitung oder Korrektur der Niederschlagung oder EWB m\u00f6glich.</p> <p>Desweiteren wird bei der Neuanlage eine Niederschlagung gepr\u00fcft, ob f\u00fcr den niederzuschlagenden OP zwischenzeitlich eine Zahlung eingegangen ist, welche noch im Buchungsstapel ist. Diese schwebenden Zahlungen sind in der Spalte \"angew. Betrag\" sichtbar. Somit k\u00f6nnen keine Niederschlagungen ohne Buchwert erzeugt werden. Es kommt die Meldung \"KEINE Wertberichtigung m\u00f6glich, weil Offener Betrag = 0\". </p> <p>443 \u2013 Wertberichtigungsliste </p> <p>Die Auswertungen f\u00fcr Niederschlagungen wurden um einen Niederschlagungsnachweis erweitert. Somit kann f\u00fcr Niederschlagungen ein Einzelnachweis gedruckt werden. Hierf\u00fcr ist in den Ausgabeformen (Rechtsklick auf Drucken) der Report \"Niederschlagung Nachweisblatt\" auszuw\u00e4hlen.</p> <p>48 \u2013 Vollstreckung </p> <p>Op-Bewegungss\u00e4tze die durch das Setzen oder Entfernen von Sperren entstehen, werden nicht mehr an Avviso \u00fcbergeben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html#auftrag-faktura","title":"Auftrag / Faktura","text":"<p>51 \u2013 Auftragsverwaltung </p> <p>Beim Anlegen von Musterauftr\u00e4gen kam es zu einem Fehler, wenn keine Position hinterlegt wurde. Dieser Fehler wurde beseitigt, so da\u00df es jetzt wieder m\u00f6glich ist, Auftragsmuster mit und ohne Positionszeile anzulegen.</p> <p>Das Anlegen von einem Muster bedingt nicht mehr die Eingabe einer Adresse. Voraussetzung ist jedoch, dass bei dem Anlegen eines neuen Musters zwingend der Haken in der Erfassungsmaske mitgegeben wird, dass es sich um ein Muster handelt. Andererseits wird das Adressfeld wieder ein Pflichtfeld.</p> <p>52 \u2013 Eingangsrechnungsjournal </p> <p>Das Auswahlfeld f\u00fcr den Buchungskreis neben den Buchungsdatum wurde entfernt. Hier kam es zu Problemen, wenn in der Erfassung der Eingangsrechnung ein anderer Buchungskreis ausgew\u00e4hlt wurde, als der im Men\u00fc 1271 definierte Standardbuchungskreis. Das hatte zur Folge, da\u00df beim Druck der Eingangsrechnungsvorkontierung der Buchungskreis aus der Erfassung angedruckt wurde und wenn man den Buchungskreis f\u00fcr den AO-Druck nicht auch ge\u00e4ndert hat, ist auf der AO der falsche Buchungskreis angedruckt wurden.</p> <p>Wird beim Neuanlegen einer Position ein Auftrag ausgew\u00e4hlt, so wird die Auftragsnummer in den Buchungstext 2 \u00fcbertragen. Beim Anlegen einer Position ohne Auftrag bleibt der Buchungstext 2 leer und steht f\u00fcr eigene Eintragungen zur Verf\u00fcgung.</p> <p>Auf dem Ausdruck des Eingangsrechnungsjournals wurde nicht der ganze Freitext angedruckt. Dieser Fehler ist korriegiert, jetzt wird der gesamte Freitext angedruckt.</p> <p>Nutzerbezogene Budgetrechte k\u00f6nnen in der Abfragemaske neuer zu bearbeitender Eingangsrechnungen als Einschr\u00e4nkung vorbelegt werden. Bei Kunden mit CC-Webdienst besteht aktuell jedoch noch keine M\u00f6glichkeit der Angabe einer like-Verkn\u00fcpfung, da der Webdienst immer nur eindeutige Key-Value-Paare zul\u00e4sst. Like-Verkn\u00fcpfungen werden erst mit dem neuen Winyard-Webdienst m\u00f6glich.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html#auswertungen","title":"Auswertungen","text":"<p>Grafikoptionen </p> <p>Die Auswertunglisten sollen zuk\u00fcnftig auch mit Grafiken erg\u00e4nzt werden. Zun\u00e4chst wurden die Diagramme am Gesamtergebnisplan erg\u00e4nzt. Diese sind \u00fcber die Vorlagenoption (Rechsklick auf Drucken) steuerbar. Eine Ausweitung auf andere Auswertungen ist je nach Feedback geplant. W\u00fcnsche oder Hinweise k\u00f6nnen Sie gern der Fachberatung mitteilen. </p> <p>6 - Allgemein Korrektur von Anzeigeproblem der Buttons \"Abbrechen\" und \"Drucken\" in den Masken: - 6422 - Teilergebnisrechnung - 6522 - Teilfinanzrechnung A - 6523 - Teilfinanzrechnung B</p> <p>613 \u2013 Quartalsstatistik </p> <p>Korrektur der Bezeichnungen in den Codes T21 und T22 in der Quartalsstatistik.</p> <p>6223 \u2013 Kontoauszug </p> <p>\u00dcber den Men\u00fcpunkt Personenkontenauszug ist es m\u00f6glich auch eine Saldenbest\u00e4tigung zum Stichtag an Debitoren und Kreditoren zu schicken.</p> <p>632 \u2013 Bilanzlisten Forderungen / Verbindlichkeiten f\u00fcr Kunden aus Brandenburg </p> <p>Die Verbindlichkeits\u00fcbersicht zur Planung f\u00fcr das Land Brandenburg wurde hinsichtlich des korrekten Ausweises der Werte des Vorvorjahres angepasst.</p> <p>6512 \u2013 Teifinanzplan A </p> <p>F\u00fcr den Nachtrag des Teilfinanzhaushaltes A wurde einer neuer Report erstellt, der es erm\u00f6glicht die Liste Hochkant zu drucken. Dieser kann in Druckmen\u00fc (Rechtsklick) \u00fcber die Vorlagenoption (\u201eAusgabe in A4 hochkant) \u00a0angesteuert werden. </p> <p>6513 \u2013 Teilfinanzplan B f\u00fcr Kunden aus Sachsen-Anhalt </p> <p>Im Report waren die Spalten vertauscht. Der Report wurde korrigiert, so das die Einzahlungen unter den Ertr\u00e4gen und die Auszahlungen unter den Aufwendungen ausgewiesen werden.</p> <p>Im Report f\u00fcr Sachsen-Anhalt waren die Spalten vertauscht. Der Report wurde korrigiert, so das die Einzahlungen unter den Ertr\u00e4gen und die Auszahlungen unter den Aufwendungen ausgewiesen werden.</p> <p>6612 \u2013 Lastschriftvorschlag </p> <p>Es k\u00f6nnen wieder Lastschrift-Vorschl\u00e4ge \u00fcber alle Mahngrade (0-2) erstellt werden, ohne dabei eine Eingrenzung in den daf\u00fcr vorgesehenen Zeilen treffen zu m\u00fcssen.</p> <p>Beim Lastschriftlauf wird jetzt gepr\u00fcft, ob das Mandat noch g\u00fcltig ist, wenn es l\u00e4nger als 36 Monate (Schalter F38) nicht genutzt wurde.</p> <p>6619 \u2013 Mahnnachdruck </p> <p>Beim Nachdruck der Mahnungen (Men\u00fc 6619) kam es vereinzelt zu dem Verhalten, da\u00df er die Mahnung beim Druck verdoppelt hat (doppelte Seitenanzahl). Das Verhalten ist korrigiert wurden, so das jetzt die Mahnung wieder nur einmal gedruckt wird.</p> <p>68 \u2013 Freie Auswertungen </p> <p>Die Freie Auswertung FS8800 \"gezahlte Rechnungen\" wurde hinsichtlich einiger Buchungsspezialf\u00e4lle angepasst.</p> <p>69 \u2013 Gesetzliche Drucklisten </p> <p>F\u00fcr den Teilhaushalt B ist nun eine l\u00e4ngere Ma\u00dfnahmenbezeichnung anzeigbar. Beim Listendruck ist eine Einstellung vorzunehmen, ob bei der Ma\u00dfnahmenbezeichnung die Kurz- oder Langbezeichnung gedruckt werden soll. Durch Rechtsklick auf den \"Drucken\"-Button kann in der Registerkarte Vorlagen-Optionen ein Haken bei \"Lange Ma\u00dfnahmebezeichnung verwenden\" gesetzt werden. Ist dieser Haken gesetzt, wird die Bezeichnung verwendet, die in der Ma\u00dfnahmeverwaltung unter \"Langbezeichnung\" hinterlegt ist. Ohne Setzen dieses Hakens wird wie gewohnt die Kurzbezeichnung gedruckt.</p> <p>In der gesetzlichen Druckliste \"\u00dcbersicht Instandhaltungsma\u00dfnahmen\" gibt es einen neuen Druckparameter \"mit Planerl\u00e4uterung\", dieser bewirkt,dass auf dieser Druckliste die erfassten Planerl\u00e4uterungstexte mit ausgewiesen werden.</p> <p>Der Druckparameter \"Ausweis Nullpositionen\" kann wieder an- und abgew\u00e4hlt werden.</p> <p>Parameter \"Ma\u00dfnahme gilt bis\" fasst Ma\u00dfnahmen, die ein Datum &lt;= das Datum \"Ma\u00dfnahme gilt bis\" in der Ma\u00dfnahmenverwaltung \u00a0haben auf der Druckliste zu einer Position ALTMASSNAHMEN zusammen.</p> <p>Die Druckliste Teilergebnisplan/Nachtrag weist in der Spalte \"erh\u00f6ht um\" die korrekten Planwerte aus.</p> <p>Die gesetzlichen Drucklisten im Bereich Ergebnis- und Finanzhaushalt, als auch Ergebnis- und Finanzrechnung wurden entsprechend den gesetzlichen Muster angepasst.</p> <p>6s \u2013 Dokumentenmappe </p> <p>Die Funktion des L\u00f6schens der Dokumentenmappe wurde insoweit ge\u00e4ndert, dass nur Dokumentenmappen gel\u00f6scht werden k\u00f6nnen, die noch in Bearbeitung sind und somit den Status Offen (\"O\") haben. Sobald eine Dokumentenmappe abgeschlossen wird (Status \"G\"), wird der L\u00f6schen- Button inaktiv.</p> <p>Die Mischfunktion in der Dokumentenmappe erfasst nun auch die erste Seite eines externen Dokuments an richtiger Stelle, sodass das Mischen mehrerer Dokumente in korrekter Reihenfolge funktioniert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html#jahresabschluss","title":"Jahresabschluss","text":"<p>7111 \u2013 Mittel\u00fcbertragung ins Folgejahr aus offenen Auftr\u00e4gen </p> <p>Die Bearbeitung eines zu \u00fcbertragenden Auftrages ist wieder m\u00f6glich.</p> <p>732 \u2013 Bagatellbetragsbereinigung </p> <p>Das Stornieren von Bagatelll\u00e4ufen, die mit der Option Forderungen niederschlagen erstellt wurden, ist jetzt m\u00f6glich.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html#veranlagung","title":"Veranlagung","text":"<p>F\u00fcr Kunden mit DMS </p> <p>Es ist eine elektronische Ablage der Bescheide m\u00f6glich. Die Ablage der Bescheide in einem extra anzulegenden Verzeichnis sichert nachhaltige Zugreifbarkeit. Hierf\u00fcr sind Kontakt mit der Fachberatung und kundenspezifische Anpassungen erforderlich.</p> <p>Verbundbescheid </p> <p>Es sind jetzt auch Bescheide mit mehreren Objekten m\u00f6glich (Verbundbescheid). Hierf\u00fcr ist bei der Einnahmeart folgende Einrichtung n\u00f6tig: Unterobjekte ausw\u00e4hlen Der Anwender kann dann im Objekt die entsprechende Unterobjekte anlegen und die  Veranlagung von den verschiedenen Unterobjekten in einem Bescheid drucken. F\u00fcr genauere Infos zur Einrichtung der Verbundbescheide wenden Sie sich bitte an die Fachberatung</p> <p>81 \u2013 Einzelveranlagung </p> <p>In den Gewerbesteuerbescheiden werden die Abbucherinformationen korrekt ermittelt, auch wenn neben dem Mandat f\u00fcr die Gewerbesteuer noch ein Bankverbindung f\u00fcr Gutschriften existiert.</p> <p>Der abweichende Steuerpflichtige wird korrekt dargestellt.</p> <p>Tarifzeilen in bestehenden Veranlagungen k\u00f6nnen nicht gel\u00f6scht werden. Die Veranlagung f\u00fcr die Zeilen muss vor dem L\u00f6schen auf 0,00 EUR gesetzt werden.</p> <p>Bei Geb\u00fchrenbescheiden mit Layout L3 (Niederschlagswassergeb\u00fchren in Tabellenform) wird die Spalte \"Summe in EUR\" korrekt dargestellt.</p> <p>Geb\u00fchren k\u00f6nnen Bestandteil eines Sammelbescheids im IFR werden. Es ist somit z. B. m\u00f6glich Trink- und Abwassergeb\u00fchren gemeinsam in einem Bescheid zu behandeln.</p> <p>Das Verbuchungsprotokoll aus der Veranlagung kann jetzt wahlweise als Protokoll oder als Anordnung genutzt werden. </p> <p>Ebenso wurde eine M\u00f6glichkeit geschaffen, aus der Veranlagung heraus einen vollst\u00e4ndigen Personenkontenauszug zu drucken. Dieser stellt eine zus\u00e4tzliche Auswertungsm\u00f6glichkeit zum Men\u00fcpunkt 6223 dar.</p> <p>843 \u2013 Analyse der Objektdaten </p> <p>\u00dcber die Auskunft der Objektdaten k\u00f6nnen f\u00fcr Veranlagungs-EArten, die auf verschiedene Buchungsstellen verteilt werden (z.B. Mieten / Pachten / Betreuungskosten / ....) die am Objekt hinterlegten Buchungseinnahmearten beauskunftet werden.</p> <p>Im Men\u00fcpunkt 843 Objektanalyse wurde der Paramete \"aktuell\" auf \"historisch\" ge\u00e4ndert und die Funktionalit\u00e4t der Abfrage mit J/N wurde wieder hergestellt.</p> <p>852 \u2013 Jahreswechsel Bescheide </p> <p>F\u00fcr Veranlagungen nach Eigent\u00fcmerwechsel zum 31.12.2016 sind die bisher nicht erkennbaren Daten beim Neueigent\u00fcmer (Jahresscheibe in Veranlagung und Raten im Bescheid) wieder sichtbar und k\u00f6nnen im Bescheid ausgewiesen werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html#kreditedarlehn","title":"Kredite/Darlehn","text":"<p>a2 \u2013 Freigabe/Buchung Beim Buchen der Raten aus der Kreditverwaltung erfolgt eine Pr\u00fcfung, so dass nur Raten des gew\u00e4hlten Haushaltsjahres verbucht werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html#anlagenbuchhaltung","title":"Anlagenbuchhaltung","text":"<p>b11 \u2013 Auswahl Anlagegut </p> <p>Das L\u00f6schen eines erfassten Anlagegutes, dem schon ein Zuschuss zugeordnet wurde, erfolgt nun fehlerfrei, wenn der Zuschuss zuvor wieder gel\u00f6st wurde.</p> <p>b123 \u2013 Umbuchung bearbeiten </p> <p>In der Umbuchungsmaske f\u00fcr Anlageg\u00fcter kann nun auf Wunsch die vorgeschlagene AfA ge\u00e4ndert werden. Daf\u00fcr ist ein Haken in das Feld Umb.AfA zu setzen.</p> <p>Wenn Altg\u00fcter umgebucht werden, k\u00f6nnen nun \u00fcber die Referenz ableiten-Funktion Neug\u00fcter angelegt werden (und andersherum).</p> <p>b13 \u2013 Auswahl Zuschuss </p> <p>Bei der Zuschusszuordnung von mehreren Zusch\u00fcssen zu einem Anlagegut oder umgekehrt kann nun der Anhaltewert wieder fehlerfrei aufgeteilt werden.</p> <p>b19 \u2013 Zuordnungsauskunft FR-VR </p> <p>In der Maske wird wieder korrekt die Suchmaske Zuschuss beim zugeh\u00f6rigen Button angezeigt.</p> <p>b311 \u2013 Anlagennachweis </p> <p>Im Anlagennachweis kann \u00fcber die zus\u00e4tzliche Option \"Zuordnung detaillieren\" zu den Inventarg\u00fctern die einzelnen Zusch\u00fcsse mit den jeweiligen Zuordnungsbetr\u00e4gen dargestellt werden. Analog ist auch f\u00fcr Zusch\u00fcsse die Darstellung m\u00f6glich, welchen Anlageg\u00fctern der Zuschuss mit welchem Betrag zugeordnet ist.</p> <p>b37 \u2013 Anlagespiegel </p> <p>Bisher wurden im Anlagespiegel in der Spalte EB-Korrekturen falsche Werte ausgewiesen, da unabh\u00e4ngig von Abgang oder Zugang eine Summe abgebildet wurde. Dies wurde korrigiert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html#kosten-leistungsrechnung","title":"Kosten- Leistungsrechnung","text":"<p>C1 \u2013 Umlagedefinitionen </p> <p>Bei Umlageart 01 (dynamische Umlage mit Referenzkosten) wird bei den Umlageempf\u00e4ngern nur noch das Empf\u00e4ngerprodukt zur Eingabe angeboten, da sich der Anteil aus den Referenzkosten ergibt.</p> <p>Bei Umlageart 02 (Anteils-/Prozentumlage) und 03 (Festwertumlage) wird f\u00fcr die Empf\u00e4nger die Summe der Anteile angeboten. Dies erm\u00f6glicht eine einfachere Pr\u00fcfung, welcher Gesamtbetrag umgelegt wird. \u00a0Es wird nun gepr\u00fcft, dass beim Verwenden der Prozentspalte, die Empf\u00e4nger in Summe genau 100 Prozent erreichen m\u00fcssen. Eine Summenzeile erleichtert die Eingabe.</p> <p>Bei Umlageart 03 (Festwertumlage) wird bei den Umlageempf\u00e4ngern neben dem Empf\u00e4ngerprodukt nur noch der Wert zur Eingabe angeboten. Die Pr\u00fcfungen bei der Eingabe einer Umlageart 03 wurden optimiert.</p> <p>Ebenso wurde ein Problem beseitigt, was auftreten konnte, wenn man bei einer 03- oder 04-Umlage kein Sachkonto angegeben hat. Dann wurde diese Umlage nicht berechnet, obwohl das Sachkonto keinerlei Rolle spielt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0048/programmaenderungen.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s12 \u2013 DMS-Anbindung In der Einrichtung zum DMS k\u00f6nnen nun auch die META-Daten f\u00fcr die Veranlagungsbescheide eingerichtet werden. Setzen Sie sich hierf\u00fcr bitte mit der Fachberatung in Verbindung. </p> <p>s21 \u2013 Benutzerverwaltung Nutzer-Anlegen wurde so optimiert, dass ein Nicht-Administrator keinen Administrator mehr anlegen kann. \u00a0 Beim Druck der Nutzerrechte (Men\u00fcrecht), werden jetzt auch neue Men\u00fcpunkte mit ausgegeben. Bisher wurden diese nicht mit ber\u00fccksichtigt solange sie nicht ausgew\u00e4hlt wurden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/hinweise_zum_releasewechsel_-_.html","title":"Hinweise zum Releasewechsel - Stand 06.06.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/hinweise_zum_releasewechsel_-_.html#hinweise-zum-releasewechsel-stand-06062018","title":"Hinweise zum Releasewechsel - Stand 06.06.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/hinweise_zum_releasewechsel_-_.html#aktualisierung-des-schattenmandanten-nur-sachs-anwender","title":"Aktualisierung des Schattenmandanten (nur s\u00e4chs. Anwender)","text":"<p>F\u00fcr alle s\u00e4chsischen Anwender  ist zwingend der Schattenmandant mit den unten dargestellten Releasewechsel-Punkten zu aktualisieren!</p> <p>Mit dem aktuellen Programmstand werden ausschlie\u00dflich f\u00fcr s\u00e4chsischen Kunden  die aktuellen Statistikvorgaben 2017 ausgeliefert. F\u00fcr die Brandenburger Anwender sind keine Aktualisierungen seitens des Statistischen Landesamtes bekannt.</p> <p>Der Schattenmandant enth\u00e4lt die FR-Liste Nr.6 \u201eFinanzstatistik\u201c, welche in 2017 in der Listenpositionsverwaltung Men\u00fc_123  mit der Schattenmandantversion 0001 abgeleitet werden kann. Es kann auch die aus 2016 \u00fcbertragene Liste verwendet werden, da sich an der ma\u00dfgeblichen Systematik f\u00fcr die Jahresstatistik 2017 in Bezug auf den Kontenrahmen im Vergleich zu 2016 nichts ge\u00e4ndert hat.</p> <p>Weiterhin wurde die Datengrundlage zur Ermittlung der \u201eunzul\u00e4ssig bebuchten Kombinationen\u201c \u00a0- Anlage C aktualisiert.Diese Druckliste kann im Men\u00fcpunkt 68  \u2013 Freie Auswertungen \u2013 Jahresstatistik FS601J erstellt werden.</p> <p>In der Systemverwaltung ist es zwingend  notwendig, eine aktualisierte Hierarchie S f\u00fcr die Jahresstatistik 2017 zu erstellen, da es \u00c4nderungen an den Produktgruppen seitens des Statistischen Landesamtes gab (Anlage A - Jahresrechnungsstatistik ma\u00dfgebliche Systematik - Produktrahmen). Beim Einspielen des Schattenmandanten (\u00fcber Systemverwaltung: Men\u00fc s31  \u2013 Releasewechsel oder IFR: Men\u00fc 124  \u2013 Stammdaten \u2013 Kontierung \u2013 Sachkonten \u2013 Reiter: Schattenmandant \u2013 Funktion: Aktualisierung) muss die aktuelle Hierarchie S f\u00fcr die Jahresrechnungsstatistik neu angelegt werden bzw. bei Vorhandensein mit der aktuell g\u00fcltigen Hierarchie \u00fcberschrieben werden. Hierbei ist auf den Parameter F41 im Mandantenstamm zu achten, welcher auf 0001 stehen muss. Damit ist gew\u00e4hrleistet, dass die aktuellste Version des Schattenmandanten verwendet wird.</p> <p>Folgende Punkte sind im Releasewechsel auszuf\u00fchren: </p> <p>ListenSachkontenStatistik ladenLaden der Stammdaten f\u00fcr die Statistik-Hierarchie S in den SchattenmandantenHierarchie f\u00fcr Statistiken aus Schattenmandant in konkreten Mandanten kopieren und Produkte zuordnen </p> <p>Anwender, bei denen in den Vorjahren noch gar keine Jahresstatistik-Hierarchie S vorhanden ist, setzen sich bitte mit der SASKIA-IFR Fachberatung in Verbindung, da hier zun\u00e4chst stammdatenseitig eine Hierarchie S im IFR angelegt werden muss.</p> <p></p> <p>Mandant (im Beispiel: 1973) und Zieljahr 2017 eingeben:</p> <p> </p> <p>Die folgende Frage ist unbedingt mit JA zu beantworten:</p> <p></p> <p>Im Men\u00fcpunkt 123  \u2013 Stammdaten \u2013 Kontierung \u2013 Listenpositionsverwaltung \u2013 Registerkarte \u201eFR-Positionen\u201c \u2013 Funktion \u201eFR-Liste kopieren\u201c ist die Liste 6 \u2013 Finanzstatistik (f\u00fcr jeden doppischen Mandanten im Haushaltsjahr 2017) neu abzuleiten.</p> <p>Die Sachkontenzuordnungen zur Liste 6 Finanzstatistik erfolgen auf Basis der ma\u00dfgeblichen Systematik der Anlage Teil B zur Jahresrechnungsstatistik 2017 Doppisches Rechnungswesen. Im Kontenbereich 7851 Bauma\u00dfnahmen wurden bewusst auch die Sachkonten der vorhergehenden Systematiken \u00a0(7851 Hochbauma\u00dfnahmen, 7852 Tiefbauma\u00dfnahmen und 7853 sonstige Bauma\u00dfnahmen) zugeordnet, da oftmals eine Umstellung dieser FR-Konten in den Verwaltungen erst ab 2014 oder noch gar nicht erfolgte. Weitere m\u00f6gliche Abweichungen zu vorhergehenden Systematiken sind nicht ber\u00fccksichtigt.</p> <p>Vor der Erstellung der Jahresrechnungsstatistik 2017 ist eine \u00dcberpr\u00fcfung derzul\u00e4ssigen Kombinationen von Produkt und Sachkonten im Men\u00fc_68 Freie Auswertungen mit der Freien Auswertung FS601J zu empfehlen. Die Auswertungsliste weist alle unzul\u00e4ssig bebuchten Kombinationen aus. Diese Pr\u00fcfung erfolgt auf Basis der ma\u00dfgeblichen Systematik der Anlage Teil C zur Jahresrechnungsstatistik 2017 Doppisches Rechnungswesen.</p> <p></p> <p>Im Anschluss sollten die aufgezeigten unzul\u00e4ssigen Kombinationen korrigiert werden, da sonst die zu erstellende Datei f\u00fcr die Jahresrechnungsstatistik Abweichungen zwischen Summen- und Einzelpositionen aufweisen w\u00fcrde. Die Summenpositionen je Kontenklasse 6 oder 7 ergeben sich aus allen  bebuchten FR-Konten (au\u00dfer Kontenklasse 67 und 77) ohne R\u00fcckschluss auf die ma\u00dfgeblichen Systematik der Anlage Teil B zur Jahresrechnungsstatistik 2017 Doppisches Rechnungswesen. Wenn also abweichende Sachkonten vorhanden sind, welche nicht der Systematik entsprechen, sind diese zumindest in den Summenpositionen je Kontenklasse 6 und 7 enthalten, da es hier keine logische Programmpr\u00fcfung geben kann. Diese Sachkonten sind dann auf Basis der o.g. Freien Auswertung FS601J zu korrigieren. Die Kontenklasse 67 und 77 wird in dieser Auswertung ggf. mit ausgewiesen, kann aber ignoriert werden.</p> <p>F\u00fcr die Korrektur der unzul\u00e4ssigen Kombinationen gibt es zwei Umbuchungsm\u00f6glichkeiten, wobei die Entscheidung z.B. auf der Grundlage der Angaben im Reiter Verkehrszahlen der Sachkontenauskunft im Men\u00fcpunkt 394 zu treffen w\u00e4re:</p> <p>Umbuchung mit BS200 oder BS201 auf eine zul\u00e4ssige Kombination, wenn der Saldo vom f\u00fchrenden ER-Konto und angehangenen FR-Konto gleich ist. OP-genaue Umbuchung auf eine zul\u00e4ssige Kombination, wenn der Saldo vom f\u00fchrenden ER-Konto und angehangenen FR-Konto ungleich ist. Sofern ein bebuchtes FR-Konto nicht der ma\u00dfgeblichen Systematik der Anlage Teil B zur Jahresrechnungsstatistik 2017 Doppisches Rechnungswesen entspricht, besteht neben den Umbuchungsm\u00f6glichkeiten auch die Variante, dass ein abweichendes gesetzliches Sachkonto eingetragen wird oder das FR-Konto einer bestimmten Listenposition der Liste F6 Finanzstatistik manuell zugeordnet wird. Im Anschluss kann die Jahresrechnungsstatistik 2017 im Men\u00fcpunkt 6522  \u2013 Auswertungen \u2013 Finanzrechnung \u2013 Finanzlisten \u2013 Teilfinanzrechnung A \u2013 erstellt werden. Dabei ist es notwendig die Listennummer 6 und die Produkthierarchie S (Ebene 1) auszuw\u00e4hlen. \u00dcber den Button \u201eDrucken\u201c wird die entsprechende Ausgabeform gew\u00e4hlt.</p> <p></p> <p>Datentr\u00e4ger \u2013 Jahresstatistik \u00a0=&gt; Erstellung der Datei</p> <p>Report \u2013 Jahresstatistik Druck =&gt; Ausgabe einer PDF-Datei</p> <p></p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/installation_checkliste_releas.html","title":"Installation Checkliste Release 4.1.0049","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/installation_checkliste_releas.html#installation-checkliste-release-410049","title":"Installation Checkliste Release 4.1.0049","text":"<p>Vorg\u00e4ngerrelease ist Release 48</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/installation_checkliste_releas.html#update","title":"Update","text":"<p>1. Alle SASKIA\u00ae.de IFR-Nutzer abmelden </p> <p>(auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 49.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/installation_checkliste_releas.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>2.a Korrektur fehlerhafter Datens\u00e4tze von Bankverbindungen </p> <p>Durch den Releaswechselpunkt \u201eung\u00fcltige BVs aus KA_KOPPL entfernen\u201c werden fehlerhafte Datens\u00e4tze von Bankverbindungen korrigiert. Voraussetzung ist die Durchf\u00fchrung der Releasewechselpunkte \u201eDatenbankstruktur anpassen\u201c und \u201eErg\u00e4nzung der Adressverwaltung um Mandanteninformationen\u201c.</p> <p>2.b Entfernung der Felder ROWID (nur SQL-Kunden) </p> <p>F\u00fcr SQL-Kunden sind bei der Durchf\u00fchrung des Releasewechsels f\u00fcr das Release 49 folgende Punkte zu beachten:</p> <ul> <li> <p>Der Releasewechsel kann unter Umst\u00e4nden sehr lange dauern, da jede Buchungstabelle und damit eine sehr gro\u00dfe Datenmenge betroffen ist.F\u00fchren Sie zun\u00e4chst alle Releasewechselpunkte durch, bei denen keine ROWID's betroffen sind: </p> </li> <li> <p>Die Releasewechselpunkte, welche die ROWID's betreffen, m\u00fcssen nicht direkt nach dem Update durchgef\u00fchrt werden und k\u00f6nnen sp\u00e4ter nachgeholt werden. Gegebenenfalls ist es sinnvoll, die Releasewechselpunkte einzeln durchzuf\u00fchren, um die Arbeiten im IFR nicht zu lange am St\u00fcck zu blockieren. </p> </li> <li> <p>Auch die Durchf\u00fchrung \u00fcber Nacht ist m\u00f6glich. Wichtig ist hierbei, die Sicherung f\u00fcr diesen Zeitraum abzuschalten, dass diese den Releasewechselvorgang nicht unterbricht. 3. Aktualisierung des Schattenmandanten </p> </li> </ul> <p>Mit Release 49 wird ein neuer Schattenmandant ausgeliefert, um die notwendigen gesetzlichen \u00c4nderungen (Muster, Konten, Produkte und Zahlwege) abzubilden. Hierf\u00fcr ist in der Systemverwaltung Men\u00fc s31 - Datenbankaktualisierung oder im IFR im Men\u00fc 124 - Sachkontenverwaltung der Schattenmandant zu aktualisieren. Folgende Punkte sind dabei zwingend auszuf\u00fchren:</p> <ul> <li>Hierarchie ladenListen ladenSachkonten ladenUmsatzsteuervorbelegung Mandantenstamm </li> </ul> <p>Im n\u00e4chsten Schritt ist f\u00fcr das Haushaltsjahr 2018 und sp\u00e4tere im Men\u00fc 11 - Pflege Mandant auf der Registerkarte \"Schalter\" unter F41 die Version f\u00fcr den Schattenmandanten auf 0002 zu \u00e4ndern und zu \u00fcbernehmen.</p> <p></p> <p>Danach m\u00fcssen ab Haushaltsjahr 2018 im Men\u00fc 123 - Listenpositionsverwaltung die Listen neu abgeleitet (Button Liste kopieren) werden. Hierbei ist die Version des Schattenmandanten zu beachten. Es ist dabei ausreichend, f\u00fcr die neuen Listen nur die obere Tabelle mit einem H\u00e4kchen zu versehen und diese zu \u00fcbernehmen. Die folgende Frage ist dann mit \"ja\" zu best\u00e4tigen.</p> <p></p> <p>Im Schattenmandanten sind auch die neuen Konten f\u00fcr Abschreibung sowie Aufl\u00f6sung von Sonderposten enthalten und auch an den entsprechenden Sammelkonten hinterlegt (bei Neuanlage). Neue Konten haben eine \"1\" an f\u00fcnfter oder sechster Stelle (letzte Stelle der Vorgabe). Dies ist notwendig, damit die automatische Zuordnung funktioniert.</p> <p></p> <p>Nach Abschluss von Online-Update und Releasewechsel kann die Weiterarbeit im Finanzwesen erfolgen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_4..html","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 24.05.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_4..html#programmanderungen-release-410049-stand-24052018","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 24.05.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_4..html#buchung","title":"Buchung","text":"<p>311 \u2013 Einzelbuchung </p> <p>Bei der Verbuchung einer Rechnung mit unterschiedlichen Leistungsperioden der Rechnungspositionen mittels Aufteilungsbuchung kam es zu einem Fehler in der Budgetumbuchung, sofern nicht gen\u00fcgend Budgetmittel auf einer Buchungsstelle vorhanden waren. Hierzu ist eine Korrektur in der Form vorgenommen worden, dass die Mittel f\u00fcr die Budgetumbuchung nun aus dem richtigen Jahr genommen und auch im richtigen Jahr verbucht werden.</p> <p>Bilanzkonten mit zwei angeh\u00e4ngten Finanzrechnungskonten (Ein-/Auszahlungskonto) k\u00f6nnen nicht mehr mit den Buchungsschl\u00fcsseln 200 bzw. 201 bebucht werden, um Fehlbuchungen durch die Wahl des falschen Finanzrechnungskontos zu vermeiden. F\u00fcr diese Konten ist zuk\u00fcnftig eine Buchung mit dem Buchungsschl\u00fcssel 240 bzw. 241 und eine Buchung mit dem Buchungsschl\u00fcssel 260 bzw. 261 durchzuf\u00fchren. Im IFR wird auf diesen Fall durch eine eindeutige Fehlermeldung hingewiesen. F\u00fcr alle fr\u00fcheren, bereits get\u00e4tigten Umbuchungen mit derartigen Konten f\u00fchrt ein separater Releasewechselpunkt eine entsprechende Pr\u00fcfung durch und erstellt einen Korrekturbuchungsstapel falls notwendig. Bitte beachten Sie dazu die Hinweise in der Protokollierung.</p> <p>3521 \u2013 Eingangsschnittstelle einlesen / 3522 \u2013 Eingangsschnittstelle verarbeiten </p> <p>Beim Einlesen und Verarbeiten der der XFinanz-Bankdateien mittels Eingangsschnittstelle wird wieder der korrekte Zahlweg gesetzt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_4..html#auftragfaktura","title":"Auftrag/Faktura","text":"<p>54 \u2013 Ausgangsrechnungsjournal </p> <p>Nach der Neuerfassung einer Ausgangsrechnung wird die Spalte Debitor nun korrekt ausgewiesen ohne den Button \u201eAktualisieren\u201c (F5) bet\u00e4tigen zu m\u00fcssen.</p> <p>Bei der Neuanlage einer Tarifgruppe oder eines Tarifes werden nun die zu erfassenden Felder korrekt geleert.</p> <p>55 \u2013 Stammdaten Ausgangsrechnungsjournal </p> <p>Es ist nun nicht mehr m\u00f6glich, Tarifgruppen und Tarife in den Stammdaten zu l\u00f6schen, sofern diese bereits zur Rechnungserstellung genutzt wurden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_42.html","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 29.05.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_42.html#programmanderungen-release-410049-stand-29052018","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 29.05.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_42.html#buchung","title":"Buchung","text":"<p>3 \u2013 Buchung </p> <p>Durch die ver\u00e4nderte Bebuchung von Bilanzkonten mit zwei angeh\u00e4ngten Finanzrechnungskonten kam es u.a. bei der Verbuchung der Lohnschnittstelle zu Fehlermeldungen. Dies wurde korrigiert.</p> <p>Bei Buchungen, bei denen ein Bilanzkonto mit zwei angeh\u00e4ngten FR-Konten angesprochen wird, ergibt sich die FR-Buchung aus dem Soll/Haben-Kennzeichen des FR-Gegenkontos.  Beispiel: bei einer Buchung mit dem Konto 401200 (FR-Konto 701200) an ein Verrechnungskonto 279910 (FR-Konto 679910 und daran h\u00e4ngt wiederum 779910) landet die FR-Buchung auf dem Konto 779910 und 701200 und nicht auf dem Konto 679910.</p> <p>Buchungsstapel, welche nach dem letzten Releasestand aufgrund der angeh\u00e4ngten FR-Konten nicht verbucht werden konnten, k\u00f6nnen nun verbucht werden. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_43.html","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 06.06.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_43.html#programmanderungen-release-410049-stand-06062018","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 06.06.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_43.html#planung","title":"Planung","text":"<p>242 \u2013 Ergebnisplan </p> <p>Bei eingeschr\u00e4nktem Budget kann in der Planung nun wieder korrekt nach Produkten und Sachkonten gefiltert werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_43.html#auswertungen","title":"Auswertungen","text":"<p>613 \u2013 Quartalsstatistik </p> <p>Die Daten f\u00fcr die Quartalsstatistik werden nicht mehr nur nach Zeitbuchnummer sondern zus\u00e4tzlich noch nach Periode ermittelt.</p> <p>68 - Freie Auswertungen </p> <p>Es wurde au\u00dferdem die Liste aller bebuchten, aber unzul\u00e4ssigen Kombinationen von Produkt und Sachkonto gepr\u00fcft und angepasst, sodass nunmehr keine zul\u00e4ssigen Kombinationen mit ausgegeben werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_43.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s31 - Releasewechsel </p> <p>Die ge\u00e4nderte Hierarchie (Produktgruppen) f\u00fcr die Jahresstatistik ber\u00fccksichtigt nun ordnungsgem\u00e4\u00df den Schalter F41 zur Version des Schattenmandanten.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_44.html","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 6.09.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_44.html#programmanderungen-release-410049-stand-06092018","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 06.09.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_44.html#allgemein","title":"Allgemein","text":"<p>Anmeldedialog </p> <p>F\u00fcr einen Single-Sign-On via Citrix oder Domain k\u00f6nnen die Anmeldedaten der Domain jetzt zus\u00e4tzlich in der Nutzerverwaltung gespeichert werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_44.html#stammdaten","title":"Stammdaten","text":"<p>11 - Mandant </p> <p>Die USt-ID ist ab sofort kein Pflichtfeld mehr. Sie kann in den USt-Stammdaten unausgef\u00fcllt bleiben, wenn die Verwaltung keine ID vom Finanzamt zugeordnet bekommen hat.</p> <p>152 - Einnahmearten Es ist nun m\u00f6glich verschieden Forderungsintervalle (monatlich, quartalsweise und j\u00e4hrlich) innerhalb einer Veranlagungseinnahmeart und \u00fcber ein Layout abzubilden. Die Option \"Monatliche Sollstellung\" muss auf J bzw. J mit SR stehen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_44.html#buchung","title":"Buchung","text":"<p>32 - Tagesabschluss </p> <p>Wird mit Buchungsschl\u00fcssel 734 (kred. Zahlungsausgang auf Verr.-Scheck) \u00a0mit Mehrfachauswahl gebucht, wird der Freitext nun wieder korrekt gef\u00fcllt, somit kann die Offene Schwebepostenliste wieder korrekt gedruckt werden.</p> <p>Im Kopf der Tagesabschluss\u00fcbersicht wurde das verkehrte Zeitformat, 12h statt 24h angezeigt. Ist korrigiert.</p> <p>36 \u2013 Anordnungsverwaltung </p> <p>Das Problem, dass bei Abweisung einer AO die Angabe des Grundes im Eingabefenster nicht gespeichert wurde, ist behoben. Ebenso erfolgte Fehlerbehebung, dass das Eingabefenster f\u00fcr die Erfassung des Abweisungsgrundes gar nicht eingeblendet wurde. Die Umsetzung Grundangabe bei Abweisung einer AO im Men\u00fc 311 ist in Arbeit.</p> <p>369 - Liquidit\u00e4tsanzeige </p> <p>Liquidit\u00e4tsanzeige kann nun erfolgreich angezeigt werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_44.html#op-bearbeitung","title":"OP-Bearbeitung","text":"<p>48 - Vollstreckung </p> <p>AVVISO XML-SST Der Buchungsbetrag wird nun mit dem richtigen Vorzeichen \u00fcbergeben</p> <p>491 - Erlass </p> <p>Der Fehler bei der Aufhebung eines Erlasses wurde behoben. Die Aufhebung eines Erlasses kann wieder gebucht werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_44.html#auftrag-faktura","title":"Auftrag / Faktura","text":"<p>52 \u2013 Eingangsrechnungsjournal </p> <p>Mit dem ERJ k\u00f6nnen nun wieder RAP's gebildet werden.</p> <p>54 - Ausgangsrechnungsjournal </p> <p>Im ARJ wird jetzt bei der Funktion \"Neue Rechnung\" analog der Funktion \"Neu aus Auswahl\" das Belegdatum anhand dem aktuellen Tagesdatum vorgeblendet.</p> <p>Korrekturen im Ausgangsrechnungsjournal bez\u00fcglich Rundungsdifferenzen bei Bruttotarifen sowie \u00c4nderungsm\u00f6glichkeit der Gr\u00f6\u00dfe des Freitextfeldes. Beim Buchen mit Mehrfachauswahl werden alle ausgew\u00e4hlten Rechnungen verbucht.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_44.html#auswertungen","title":"Auswertungen","text":"<p>613 - Quartalstatistik Die Viertelj\u00e4hrlichen Kassenstatistik wurde auf eine periodengerechte Auswertung umgestellt. Im 1.Quartal werden ausschlie\u00dflich Buchungen der Perioden 1-3 ber\u00fccksichtigt. Sofern im 2.Quartal Buchungen mit Periode 1-3 enthalten sein sollten (z.B. Umbuchungen), werden diese unter Ber\u00fccksichtigung der letzten Zeitbuchnummer des 1.Quartals \u00a0dem 2.Quartal zugerechnet. </p> <p>6611 - deb. OP-Listen </p> <p>Beim Druck der debitorischen OP-Liste mit Stichtag und der Option inkl. Referenz-PK's wurde der Fehler bereinigt, dass kreditorischen OP-Positionen des Referenzkontos mehrfach ausgewiesen wurden.</p> <p>69 - gesetzliche Drucklisten </p> <p>Informationsbox \"Bilanzposition f\u00fcr die Berechnung des Jahres\u00fcberschusses / -fehlbetrags Vorjahr nicht gefunden.\" und \"Bilanzposition f\u00fcr die Berechnung des Jahres\u00fcberschusses / -fehlbetrags aktuelles Jahr nicht gefunden.\" \u00a0wird beim Druck einer Bilanz nicht mehr angezeigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_44.html#veranlagung","title":"Veranlagung","text":"<p>81 - Einzelveranlagung </p> <p>In Feld sKIban des Druckstroms f\u00fcr Veranlagungsbescheide kann die IBAN anonymisiert werden (z.B. \u00a0DE03***890). Voraussetzung daf\u00fcr ist Schalter F08 = JA.</p> <p>Auch auf Gewerbesteuerbescheiden, die sowohl Steuerfestsetzungen mit Gewerbesteuerzinsen als auch Vorauszahlungen / Festsetzungen ohne Zinsen enthalten. Es wird der eingerichtete Vorl\u00e4ufigkeitsvermerk f\u00fcr die Zinsermittlung ausgewiesen.</p> <p>Im Geb\u00fchrenbescheid werden auch mehrere Sonderraten korrekt ausgewiesen.</p> <p>82 \u2013 Gesamtveranlagung </p> <p>Im Ratenteil des Geb\u00fchrenbescheides werden die gebildeten Raten komplett ausgewiesen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_44.html#anlagenbuchhaltung","title":"Anlagenbuchhaltung","text":"<p>b6 - Auswertungen </p> <p>Die Listen Anlagenspiegel und Sonderposten\u00fcbersicht stellen die Gesamtsummenzeile wieder korrekt dazu ist es notwendig im Men\u00fc 123 Reiter \"Bilanz-Positionen\" die Listennummer 4 und 6 neu abzuleiten.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_44.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s31 - Releasewechsel </p> <p>Die ge\u00e4nderte Hierarchie (Produktgruppen) f\u00fcr die Jahresstatistik ber\u00fccksichtigt nun ordnungsgem\u00e4\u00df den Schalter F41 zur Version des Schattenmandanten. Es wurde au\u00dferdem die Liste aller bebuchten, aber unzul\u00e4ssigen Kombinationen von Produkt und Sachkonto gepr\u00fcft und angepasst, so dass nunmehr keine zul\u00e4ssigen Kombinationen mit ausgegeben werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_45.html","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 4.10.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_45.html#programmanderungen-release-410049-stand-04102018","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 04.10.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_45.html#allgemein","title":"Allgemein","text":"<p>Zensus </p> <p>Wir weisen darauf hin, dass die im Nachgang zur ersten Testdatenlieferung (vom Juni 2018) von der Statistik im September 2018 erneut versandten Hinweise Beachtung finden mussten.  In diesem Zusammenhang m\u00f6chten wir einen der Anwendungs-Hinweise besonders herausgreifen:\u00a0 Die zur \u00dcbertragung an die Statistik erzeugte Datei darf nicht bzw. nur, wenn unbedingt n\u00f6tig, ausschlie\u00dflich mit dem Editor bzw. Notepad, ge\u00f6ffnet werden. Denn das \u00d6ffnen mit einem anderen Programm kann Datenver\u00e4nderungen nach sich ziehen, die zu gravierenden Fehlern f\u00fchren.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_release_45.html#planung","title":"Planung","text":"<p>391 - Personenauskunft </p> <p>Auswertungen des Planbuchungsjournal sind mit diesem Update wieder m\u00f6glich.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_09.0.html","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 10.04.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_09.0.html#programmanderungen-release-410049-stand-10042018","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 10.04.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_09.0.html#stammdaten","title":"Stammdaten","text":"<p>152 \u2013 Einnahmearten </p> <p>Es wurde die neue Option \"Druck kann entfallen\" f\u00fcr die Veranlagungseinnahmearten geschaffen, mit der nach der Berechnung der Veranlagung direkt auch der Druck-Schalter freigegeben wird. F\u00fcr die so eingestellten Einnahmearten (z. B. Mieten) ist damit nicht mehr zwangsweise ein Druck notwendig.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_09.0.html#planung","title":"Planung","text":"<p>In den Men\u00fcpunkten 242 - Ergebnisplan, 243 - Ma\u00dfnahmenplan, 244 - Finanzplan und 245 - Bilanzplan wurde ein Fehler behoben, welcher das Speichern der Standardansicht verhinderte, nachdem der jeweilige Men\u00fcpunkt geschlossen wurde oder die Eingrenzung auf ein Produkt oder Sachkonto ge\u00e4ndert wurde. Nach Einspielen des Updates muss einmalig die Standardansicht mit einem Rechtsklick im Kontextmen\u00fc wiederhergestellt werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_09.0.html#buchung","title":"Buchung","text":"<p>311 \u2013 Einzelbuchung </p> <p>Es wurde ein Fehler behoben, welcher zum Programmabsturz f\u00fchrte, wenn nach dem Abtauchen in den \"Offenen Posten\" die Historiens\u00e4tze eines OP \u00fcber das \"Plus\"-Symbol angezeigt werden sollten und dieser mit einer Bankverbindung verkn\u00fcpft war. </p> <p>Mit den Buchungsschl\u00fcsseln 231 und 331 kann nun wieder mit den korrekten Vorzeichen gebucht werden.</p> <p>312 \u2013 Dauerbuchung </p> <p>Bei der Erstellung von Dauerbuchungen mit manuellen Belegnummern gab es ein Problem mit der Fortschreibung der Belegnummern in den einzelnen Buchungsperioden. Hierzu erfolgte eine \u00c4nderung, sodass jetzt die Belegnummern korrekt fortgeschrieben werden.</p> <p>32 \u2013 Tagesabschluss </p> <p>Bei einer Tagesabschluss\u00fcbersicht mit vielen Zahlwegen und/oder vielen Jahren bei der \u00dcbersicht der Ist-Fortschreibung konnte es bei einigen Konstellationen dazu f\u00fchren, dass die Unterschriftenzeile auf der neuen Seite verschoben ausgewiesen wurde. Der Report ist in diesem Bereich angepasst worden.</p> <p>Das Erstellen des LUSI-Reports f\u00fcr Ein- und Ausgangsschecks ist wieder problemlos m\u00f6glich.</p> <p>33 \u2013 Buchungsstapel </p> <p>Es wurde ein Fehler behoben, welcher die Verbuchung eines Buchungsstapels aus der Veranlagung heraus ohne vorherige endg\u00fcltige Best\u00e4tigung im Men\u00fc 36 - Anordnungsdruck zulie\u00df.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_09.0.html#auftrag-faktura","title":"Auftrag / Faktura","text":"<p>592 \u2013 Stammdaten der Fakturierung </p> <p>Auf dem Report FR_20151_FAKTURIERUNG.MRT werden Netto- und Bruttobetrag nun in der richtigen Reihenfolge ausgewiesen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_09.0.html#auswertungen","title":"Auswertungen","text":"<p>69 \u2013 Gesetzliche Drucklisten </p> <p>F\u00fcr den Ausdruck der neu integrierten Diagramme ist ein Farbdrucker ratsam.</p> <p>6s \u2013 Dokumentenmappen </p> <p>Beim Erstellen der Dokumentenmappe kam es bei der Verwendung der Option \"Mischen\" zu einer fehlerhaften Einsortierung der Dokumente in die Gliederungsstruktur der Dokumentenmappe.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_09.0.html#veranlagung","title":"Veranlagung","text":"<p>81 \u2013 Einzelveranlagung </p> <p>Mit der neuen Vorlageoption \"mit An- und Abmeldedatum\" kann beim Druck von Bescheiden \u00fcber die Men\u00fcpunkte 81 - Einzelveranlagung, 82 - Gesamtveranlagung oder global \u00fcber Men\u00fcpunkt 1y2 - Verwaltung der Ausgabek\u00fcrzel gesteuert werden, ob das An- und Abmeldedatum, welches im Objekt bzw. Unterobjekt angegeben wurde, auf dem Bescheid mit ausgegeben werden soll.</p> <p>Beim Eigent\u00fcmerwechsel erfolgt jetzt der richtige Ausweis des Alteigent\u00fcmers.</p> <p>Korrektur der Ratenermittlung (Sonderraten/Kleinstbetragsregelung)</p> <p>82 \u2013 Gesamtveranlagung </p> <p>Druck der Gewerbesteuerbescheide m\u00f6glich.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_27.0.html","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 02.05.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_27.0.html#programmanderungen-release-410049-stand-02052018","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 02.05.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_27.0.html#buchung","title":"Buchung","text":"<p>311 \u2013 Einzelbuchung </p> <p>Ob die Vorsteuer einer kreditorischen Sollstellung in den Zeitraum der Zahlungsbuchung verlagert wird, entscheidet nunmehr auch bei Ratenbuchungen allein die Checkbox \"Istversteuerung\". Bisher hat die Aktivierung der Option \"Periode lt. F\u00e4lligkeit\" bei Ratenbuchungen eine Verschiebung der Vorsteuer in die Zahlungsperiode verursacht. Soll dieser Vorgang k\u00fcnftig bei Ratenbuchungen weiterhin erfolgen, muss zus\u00e4tzlich die Checkbox \"Istversteuerung\" aktiviert werden. Dies gilt auch in Men\u00fc 52 - Eingangsrechnungsjournal.</p> <p>33 \u2013 Buchungsstapel </p> <p>Bei der Selektion auf eine AO-Nummer, welche zu einer Aufteilungsbuchung geh\u00f6rt, werden jetzt wieder alle zugeh\u00f6rigen Buchungen der Aufteilungsbuchung im Buchungsstapel angezeigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_27.0.html#auftragfaktura","title":"Auftrag/Faktura","text":"<p>52 \u2013 Eingangsrechnungsjournal </p> <p>Bei kreditorischen Buchungen wird die Bildung der Steuerperiode am Eingangsrechnungsdatum bzw. Wertstellungsdatum entschieden. Liegt die Leistungsperiode zeitlich sp\u00e4ter als das Eingangsrechnungs- bzw. Wertstellungsdatum, so ist die Leistungsperiode f\u00fcr die Steuerperiode ausschlaggebend.</p> <p>54 \u2013 Ausgangsrechnungsjournal </p> <p>Bei der Zuordnung von Tarifen mit und auch ohne Steuer kam es bei bestimmten Kombinationen zu einem Fehlverhalten bei der Berechnung der Steuer. Damit diese F\u00e4lle nicht mehr auftreten, gibt es eine neue Funktion mit dem Namen \"Basis\". Hier kann eingestellt werden, ob die Rechnung nach Brutto- bzw. Nettobetrag berechnet werden soll. Ein Tool-Tip an der Auswahl erl\u00e4utert nochmal kurz das jeweilige Verhalten.</p> <p>Im Report FR_5001_Ausgangsrechnung_B.mrt wurde die Formatierung des Umsatzsteuerbetrages korrigiert sowie weitere kleinere Optimierungen vorgenommen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_27.0.html#auswertungen","title":"Auswertungen","text":"<p>6421 \u2013 Gesamtergebnisrechnung, 6521 \u2013 Gesamtfinanzrechnung </p> <p>Gesamtergebnisrechnung und Gesamtfinanzrechnung lassen sich nun wieder korrekt drucken.</p> <p>6617 \u2013 Auszifferung (debitorisch) </p> <p>Wenn bei einer Auszifferung ein negativer OP-Betrag \u00fcbrig blieb, wurde auf der OP-Liste bisher immer 0,00 \u20ac bei \u201eoffen nach Ausz.\u201c ausgewiesen. Jetzt wird der aktuelle neue OP-Betrag nach Auszifferung in der OP-Liste angezeigt.</p> <p>6s \u2013 Dokumentenmappen </p> <p>Beim Druck der Dokumentenmappe werden l\u00e4ngere \u00dcberschriften am Ende einer Zeile nicht mehr abgeschnitten.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_27.0.html#jahresabschluss","title":"Jahresabschluss","text":"<p>7333 \u2013 Einzelbewegungsabstimmung (Registerkarte Steuerbuchungen) </p> <p>In der Buchhaltungsabstimmung gibt es nun auch f\u00fcr Steuern eine Einzelwertberichtigung. Diese greift bei Buchungen, die in eine andere Steuerperiode verschoben wurden, deren Verkehrszahlen aber f\u00e4lschlicherweise nicht verschoben wurden. Die neue Buchhaltungsabstimmung korrigiert die Verkehrszahlen. Die USt-Zusammenstellung kann somit wieder korrekt dargestellt werden. Um die Suchfelder zu nutzen, muss der Pr\u00fcf-Button als Best\u00e4tigung genutzt werden. Eine Aktivierung der \u201eAuto-Korrektur\u201c sorgt bei Verwendung des Pr\u00fcf-Buttons f\u00fcr die Berichtigung der Verkehrszahlen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungen_stand_27.0.html#veranlagung","title":"Veranlagung","text":"<p>81 \u2013 Einzelveranlagung </p> <p>Beim Anlegen eines neuen Objektes wird generell keine Buchungs-Einnahmeart vorgeblendet.  Wird dieses Objektfeld bei der Objekterfassung leer gelassen, erfolgt beim Speichern der Objektdaten der Eintrag Veranlagungs-Einnahmeart = Buchungs-Einnahmeart.</p> <p>Beim Eigent\u00fcmerwechsel erfolgt der exakte Ausweis des Alt- und Neueigent\u00fcmers.</p> <p>Der Kurzkontoauszug der Veranlagungsbescheide wurde \u00fcberarbeitet, so dass die korrekten Werte zu Einnahmeart / Objekt ausgewiesen werden.</p> <p>In bestimmten Konstellationen wurden bei \u00c4nderungsbescheiden die Sonderraten nicht richtig gebildet. Dies wurde behoben.</p> <p>Mit der Hundesteuermarkenverwaltung kann eine vorher unter Men\u00fc 152 \u2013 Einnahmearten definierte Marke vergeben werden. Die Marke wird initial im Objekt hinterlegt (Ausgabedatum = Tagesdatum). Bei einem Wechsel der Marke ohne Bescheiddruck kann ein Wechsel im Objekt erfolgen (Wechseldatum = Tagesdatum). Wird die Markennummer im Rahmen der Veranlagung ge\u00e4ndert (Veranlagungszeile), so wird in der Historie der Wechsel wahlweise zum Bescheiddatum oder zum Wechseldatum in der Tarifzeile durchgef\u00fchrt (VEArt-Option \"Z\u00e4hlerwechsel = Bescheiddatum\" im Men\u00fc 152).</p> <p>Auf den Bescheiden werden die jeweiligen Unterobjektnummern mit gedruckt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 19.03.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html#programmanderungen-release-410049-stand-19032018","title":"Programm\u00e4nderungen Release 4.1.0049 - Stand 19.03.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html#allgemein","title":"Allgemein","text":"<p>Systemvoraussetzungen f\u00fcr die elektronische \u00dcbermittlung der USt-Voranmeldung an ELSTER </p> <p>Um die USt-Voranmeldung elektronisch an ELSTER \u00fcbermitteln zu k\u00f6nnen, muss \u201eVisual C++ Redistributable f\u00fcr Visual Studio 2015\u201c in der 64bit-Version installiert werden. Es ist au\u00dferdem eine zus\u00e4tzliche Lizenz erforderlich, um das Formular der USt-Voranmeldung anzuzeigen und elektronisch zu \u00fcbermitteln (inklusive Ausgabe der Sendeprotokolle).</p> <p>Speicherm\u00f6glichkeit bei Rechenzentrumsl\u00f6sung ohne Excel-Installation </p> <p>F\u00fcr Kunden, die ihren Excel-Export \u00fcber ein Rechenzentrum durchf\u00fchren, wo kein Excel installiert ist, wurde eine L\u00f6sung zum Abspeichern in Form eines neuen Systemparameters USER\\EXCELEXPORTAUSGABE entwickelt. Ist der Parameter aktiv (= 1), so werden beim Export nach Excel die Daten als HTML-Datei in dem Verzeichnis abgespeichert, welches unter SYSTEM\\AUSGABEDIR angegeben ist.</p> <p>DMS-\u00dcbertragungsfehler bei Erlass </p> <p>In der Maske f\u00fcr das Erstellen eines neuen Erlasses (Men\u00fc 491) gibt es einen neuen Button \"Drucken\". Dieser stellt auch sicher, dass der Erlass an das DMS \u00fcbergeben wird, bevor die AO gedruckt wird</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html#stammdaten","title":"Stammdaten","text":"<p>11 \u2013 Mandant bearbeiten (Registerkarte Schalter) </p> <p>Der Mittel\u00fcbertrag f\u00fcr Buchungsstellen mit Ma\u00dfnahme ist jetzt \u2013 unabh\u00e4ngig der Mandantenschalterstellung F31 \u2013 bis maximal 13 Jahre m\u00f6glich. F\u00fcr Buchungsstellen ohne Ma\u00dfnahme bleibt es bei der maximalen \u00dcbertragbarkeit von 2 Jahren. Der Mittel\u00fcbertrag aus Auftr\u00e4gen, ist jetzt ebenfalls auch unabh\u00e4ngig der Mandantenschalterstellung F31 f\u00fcr maximal 13 Jahre m\u00f6glich.</p> <p>Es wurde ein neuer Schalter K21 f\u00fcr die Einwohnermeldewesen-Zugangsdaten integriert. Hier sind Benutzername und Passwort getrennt durch \u201e / \u201c zu hinterlegen.</p> <p>Mit Hilfe des neuen Mandantenschalters F44 kann festgelegt werden, ob Buchungen mit negativen Betr\u00e4gen als Storno betrachtet werden sollen (F44 = nein) bzw. ob es zur Buchung einer Generalumkehr kommt (F44=ja). Dabei wird z. B. im Falle einer Lieferantengutschrift keine Rotabsetzung vorgenommen, sondern automatisch der Buchungssatz gedreht und ein positiver Betrag gebucht. Die Standardeinstellung ist zun\u00e4chst F44 = nein und bleibt damit wie die bisherige Vorgehensweise. Nach einer Forderung aus der Zertifizierung sollen jedoch nur Stornoanordnungen aus den tats\u00e4chlichen Stornomen\u00fcs (314 \u2013 Stornobuchungen, 52 \u2013 Eingangsrechnungsjournal Stornierung, 54 \u2013 Ausgangsrechnungsjournal Stornierung, 59 \u2013 Fakturierung Stornierung, 81 \u2013 Veranlagung Stornierung, usw.) heraus erzeugt werden, die blo\u00dfe Buchung eines negativen Buchungsbetrages ist hierbei jedoch nicht gemeint.</p> <p>11 \u2013 Mandant bearbeiten (Registerkarte Umsatzsteuer) </p> <p>Die Buchungen der Umsatz- und Vorsteuer werden mit Hilfe von Steuerkennzeichen erfasst. Damit das Formular bzw. die elektronische \u00dcbermittlung der Umsatzsteuervoranmeldung korrekt verfahren kann, ist es notwendig, die Steuerkennzeichen den Kennzeichen/Inhalten der Umsatzsteuervoranmeldung zuzuordnen. Hierzu gibt es im Men\u00fc der Mandantenverwaltung eine neue Registerkarte \"Umsatzsteuer\". Die Tabelle der Kennzeichen aus der USt-Voranmeldung wird j\u00e4hrlich \u00fcber den Schattenmandant eingelesen. Der Anwender muss nun lediglich die vorhandenen Steuerkennzeichen der Verwaltung zu den Inhalten aus der USt-Voranmeldung zuordnen. Dabei sind auch Mehrfachzuordnungen m\u00f6glich. Es sollte darauf geachtet werden, dass jedes vorhandene Steuerkennzeichen mindestens einmal zugeordnet sein muss, da die \u00dcbermittlung der Voranmeldung sonst nicht m\u00f6glich ist.</p> <p>Die Umsatzsteuer-ID des Mandanten wird bei Eingabe nun auf die korrekte L\u00e4nge gepr\u00fcft.</p> <p>Die \u00dcbernahme der Daten in der Registerkarte \u201eUmsatzsteuer\" ist nun auch ohne Eingabe des Pfades des ELSTER-Portalzertifikats m\u00f6glich. Die Nicht-Eingabe verhindert jedoch die elektronische \u00dcbermittlung der Daten an das Finanzamt.</p> <p>Die Werte aus den Steuerbuchungen werden automatisch in die Umsatzsteuer-Voranmeldung \u00fcbernommen. Trotzdem ist die M\u00f6glichkeit f\u00fcr den Anwender offen gelassen, die Werte in der Umsatzsteuer-Voranmeldung zu \u00e4ndern und auch ge\u00e4ndert an das Finanzamt zu \u00fcbermitteln. F\u00fcr die Korrektheit der \u00fcbermittelten Werte \u00fcbernimmt SASKIA\u00ae Informations-Systeme GmbH keine Gew\u00e4hr.</p> <p>122 \u2013 Hierarchieverwaltung </p> <p>Es ist jetzt m\u00f6glich, sich eine Vorschau des Produktblattes anzeigen zu lassen.</p> <p>124 \u2013 Sachkontenverwaltung </p> <p>Die automatische Listenzuordnung wurde auch auf die individuellen Listen (1xx) erweitert. Beim Anlegen von Sachkonten, Kopieren von Sachkonten und beim Bet\u00e4tigen des Button \"Listen-Neuzuordnung\", wird jetzt die automatische Listenzuordnung f\u00fcr Listen &gt;= 100 (individuelle Listen) laut bestehenden Kontorange mit durchgef\u00fchrt.</p> <p>Es wurden die Spalte \"Bebuchbar\" und das Filterkriterium \"Bebuchbar\" eingef\u00fcgt. Damit ist es nun m\u00f6glich nach Sachkonten zu filtern, welche nicht bebuchbar sind und umgekehrt. In den Buchungsfunktionalit\u00e4ten (z.B. Men\u00fc 311 &amp; 52) werden beim \"Abtauchen\" in die Sachkontenauswahl nur bebuchbare Sachkonten angezeigt. In Funktionen, welche der Auswertung dienen, kommen die Filterm\u00f6glichkeiten wie in der Sachkontenverwaltung zur Anwendung.</p> <p>Im Zuge der k\u00fcnftig anstehenden Umsatzsteuer\u00e4nderungen, ist es nun auch m\u00f6glich beim Anlegen bzw. Kopieren eines Aufwandskontos, ein Steuerkennzeichen anzuh\u00e4ngen, welches Umsatzsteuer f\u00fcr einen innergemeinschaftlichen Erwerb oder eine Leistung nach \u00a7 13b UStG bucht.</p> <p>In der Funktion Konten zu kopieren, ist nun auch die Pflege der Kurzbezeichnungen der Sachkonten m\u00f6glich.</p> <p>1271 \u2013 Buchungskreise </p> <p>Das Ausgangsrechnungsjournal wurde als m\u00f6glicher Buchungskreis aufgenommen, um eine automatische Vorbelegung des Buchungskreises zu erm\u00f6glichen.</p> <p>1272 \u2013 Zahlwege </p> <p>In der neuen SEPA-Definition gibt es keinen Unterschied mehr zwischen Core und Cor1. Deshalb ist in den Zahlwegen die Auswahlm\u00f6glichkeit entfernt worden. Des Weiteren werden alle als Cor1 definierten Zahlwege mit dem Releasewechsel auf Core umgestellt.</p> <p>1273 \u2013 Steuerkennzeichen </p> <p>Es ist nicht m\u00f6glich Steuerkennzeichen zu verkn\u00fcpfen, wenn nicht f\u00fcr mindestens eines der Steuerkennzeichen das Kennzeichen f\u00fcr Erwerbssteuer hinterlegt wurde.</p> <p>Das Feld sowie die Spalte der \"Abgeschlossenen Steuerperiode\" wurde entfernt, da dieses Merkmal nun im Men\u00fcpunkt der Umsatzsteuermeldung (672) gesteuert wird.</p> <p>F\u00fcr das Buchen von innergemeinschaftlichen Erwerben und Leistungen gem. \u00a713b UStG ist der Leistungsempf\u00e4nger zur Zahlung der Umsatzsteuer verpflichtet und im Falle, dass es sich bei der zu betrachtenden Buchungsstelle im Produkt um ein BGA handelt, ist unter Beachtung der gesetzlichen Regelung die Vorsteuer zu ziehen. Somit ist es m\u00f6glich, dass bei einer Buchung sowohl Umsatzsteuer, als auch Vorsteuer zu erfassen sind. Hierf\u00fcr wurde in der Steuerkennzeichenverwaltung die M\u00f6glichkeit geschafften, Steuerkennzeichen anzulegen, die sowohl das ben\u00f6tigte Umsatz- als auch das Vorsteuerkonto enthalten. Dieses Steuerkennzeichen kann nun in der Sachkontenverwaltung mit einem Aufwandskonto verkn\u00fcpft werden. Bei Einbuchung eines Aufwandes unter Verwendung des nun neu angelegten Kontos (mit einem Steuerkennzeichen aus Umsatz- und Vorsteuer) wird neben der Aufwandsbuchung gleichzeitig die Steuerbuchung betreffend der Umsatz- UND Vorsteuer abgesetzt.</p> <p>Steuerkennzeichen, welche 2 Steuerkonten enthalten, d\u00fcrfen nur in der Reihenfolge VSt --&gt; USt angelegt werden. Somit darf ein Umsatzsteuerkennzeichen auch kein verbundenes Steuerkennzeichen enthalten. Die Bildung eines Vorsteuerkennzeichens, welches \u00fcber kein verbundenes Umsatzsteuerkennzeichen verf\u00fcgt, darf nicht den Vermerk \"EG-Land\" haben.</p> <p>127c \u2013 Verteilungsringe </p> <p>Die M\u00f6glichkeit zur manuellen Eingabe (und damit \u00c4nderung) der Verteilungsringnummer besteht nicht mehr.</p> <p>12a3 \u2013 Adressverwaltung </p> <p>Der aktuelle Status des SEPA-Mandates (aktiv, ruhend, gesperrt usw.) eines Personenkontos wird nun direkt auf dem Stammblatt in der Adressverwaltung ausgewiesen.</p> <p>Bei den kreditorischen Adressen wurde unter der Registerkarte \"Weiteres\" ein neues Kennzeichen \"Freistellungsbescheinigung\" integriert. Das Kennzeichen ist wichtig, ob die Bauabzugssteuer abzuf\u00fchren ist, weil der Auftragnehmer keine Freistellungsbescheinigung vorgelegt hat.</p> <p>In der Registerkarte der Kontierung konnte bereits die Umsatzsteuer-ID des Personenkontos eingepflegt werden. Neu ist jedoch die Lupe, die sich rechts neben dem Feld befindet. Ein Klick auf diesen Button sendet eine Abfrage auf Korrektheit der ID an das Bundeszentralamt f\u00fcr Steuern, welches wiederrum innerhalb weniger Sekunden eine R\u00fcckantwort sendet. Wichtig ist dies k\u00fcnftig f\u00fcr Buchungen, welche aus dem Programm eingegeben werden und ausl\u00e4ndische Personenkonten betreffen.</p> <p>F\u00fcr die Druckaufbereitung von Mandatsschreiben wurde der Datenstrom ge\u00e4ndert. Bei der Verwendung eines abweichenden Kontoinhabers, wird nun das Feld sAdrKopf mit der kompletten Anschrift dieses abweichenden PK's bef\u00fcllt, ansonsten werden weiter die Angaben des verwendeten Debitors genutzt. Au\u00dferdem sind die Felder sOrt und sStrasse einzeln im Datenstrom enthalten und k\u00f6nnen so f\u00fcr die Vorbef\u00fcllung von Formularzeilen \u00fcber die Textbausteinverwaltung genutzt werden.</p> <p>Die Zugangs- / Config-Daten der Schalter zun\u00e4chst gepr\u00fcft und getestet, ob eine Verbindung zum MESO-WebService aufgebaut werden kann, bevor der Einwohnerwesen-Abgleich gestartet wird.</p> <p>12a6 \u2013 Einwohnerwesen Abgleich </p> <p>Die Zugangs- / Config-Daten der Schalter werden zun\u00e4chst darauf gepr\u00fcft und getestet, ob eine Verbindung zum MESO-WebService aufgebaut werden kann, bevor der Einwohnerwesen-Abgleich gestartet wird.</p> <p>12a8 \u2013 Auswertung Infotext </p> <p>Die Auswertung der Info-Texte in der Adressverwaltung wurde um das Selektionskriterium Debitor/Kreditor erweitert.</p> <p>141 \u2013 Budgetverwaltung </p> <p>Es k\u00f6nnen angelegte Budgets gel\u00f6scht werden mit der Einschr\u00e4nkung, dass das Budget keine Verkehrszahlen hat und auch nicht in Planvarianten, Ma\u00dfnahmen oder Journals\u00e4tzen vorkommt. </p> <p>151 \u2013 Allgemeine Veranlagungsstammdaten </p> <p>Unter dem Reiter Branchen k\u00f6nnen individuelle Branchenschl\u00fcssel mandantenspezifisch gepflegt werden. Diese k\u00f6nnen dann in den Objekten genutzt werden. Bereits angelegte Objekte m\u00fcssen bei Wegfall oder \u00c4nderung der Branchenschl\u00fcssen ggf. angepasst werden. Sobald eine \u00c4nderung am im Standard hinterlegten Branchenschl\u00fcssel-Set \u00fcbernommen wird, wird dieses in den individuellen Mandanten gespeichert. Nach dem L\u00f6schen der letzten \u00c4nderung des individuellen Schl\u00fcssel-Sets erfolgt eine R\u00fccksetzung auf den Standard.</p> <p>152 \u2013 Einnahmearten </p> <p>Unterobjekte aus der Veranlagung k\u00f6nnen nun auch f\u00fcr Sammel-Einnahmearten genutzt werden.</p> <p>1y1 \u2013 Textbausteinverwaltung </p> <p>Um eine weitere Flexibilisierung im Layout der Reports zu erreichen, gibt es f\u00fcr die folgenden Reports die M\u00f6glichkeit \u00fcber den Textbaustein 9, die Informationen zu \u00d6ffnungszeiten, Bankverbindungen usw. in der Fu\u00dfzeile einzurichten. Allerdings ist dann kein Druck mehr mit Zahlschein m\u00f6glich. Die M\u00f6glichkeit besteht bei Stundung, Fakturierung, Ausgangsrechnung und Auszifferungserkl\u00e4rung.</p> <p>1y2 \u2013 Verwaltung der Ausgabek\u00fcrzel </p> <p>Sobald in der Vorlagenverwaltung (1y2) die elektronische Aktie als Standard definiert ist oder beim Druck in der AO-Verwaltung ausgew\u00e4hlt wird, wird die AO an das DMS \u00fcbergeben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html#planung","title":"Planung","text":"<p>242 \u2013 Ergebnisplan </p> <p>In den Men\u00fcpunkten 242 ff. (Ergebnisplan, Ma\u00dfnahmenplan, Finanzplan usw.) werden jetzt in den Spalten \"RE VVj\" und \"Ansatz Vj\" Summen gebildet.</p> <p>27 \u2013 Neue Buchungsstelle </p> <p>Es k\u00f6nnen wieder Buchungsstellen f\u00fcr Bilanzkonten ohne Budget angelegt werden. Dies gilt nicht f\u00fcr Bilanzkonten mit angeh\u00e4ngtem FR-Konto. In diesem Fall ist die Eingabe eines Budgets weiterhin zwingend erforderlich.</p> <p>291 \u2013 Planbuchungsjournal </p> <p>In der Selektion zur Auswahl der Belegart wurde die Belegart RF = Reservierung Finanzrechnungsmittel erg\u00e4nzt.</p> <p>294 \u2013 Mittelanforderung </p> <p>Beim Druck der Mittelanforderung mit der Option Formular kam es bei Nachtragsplanvarianten zu einem fehlerhaften Ausweis der Werte beim Druck.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html#buchung","title":"Buchung","text":"<p>311 \u2013 Einzelbuchung </p> <p>In der Buchungsmaske kann nun die OP-Auswahl \"OP's letztes HH-Jahr\" getroffen werden. Dadurch besteht die M\u00f6glichkeit f\u00fcr den Anwender, die Buchungseingaben, welche auch letztes Jahr eingegeben wurden, \u00fcber den OP des letzten Jahres zu ziehen und gleich in den aktuellen OP zu \u00fcbernehmen. Dies bedeutet weniger Eingabeaufwand f\u00fcr den Anwender.</p> <p>Im Men\u00fc 311 Einzelbuchung wird nach Eingabe des PK's, des Buchungsschl\u00fcssels und einer bekannten OP-Nummer der OP mit der j\u00fcngsten F\u00e4lligkeit automatisch geladen. Bisher wurden die Daten des \u00e4ltesten OP' vorgeblendet. Mit dieser Umstellung wird die Wahrscheinlichkeit h\u00f6her sein, dass die Pr\u00fcfung auf das Vorhandensein der Buchungsstelle aus dem OP erfolgreich ist. Bei einer Einzelbuchung mit Verteilungsring wird das Feld der Buchungsstelle automatisch anhand des ausgew\u00e4hlten Verteilungsringes gef\u00fcllt.</p> <p>Bei Umbuchungen mit den Buchungsschl\u00fcsseln 240/241 k\u00f6nnen jetzt auch Buchungsstellen mit Ma\u00dfnahmen und Kontoart A0, die kein FR-Konto haben, zur Buchung ausgew\u00e4hlt werden. Bisher lie\u00df sich bei solchen Buchungsstellen die Ma\u00dfnahme nicht mit ausw\u00e4hlen.</p> <p>Beim Wechsel einer Einnahmeart, welche f\u00e4lschlicher Weise ausgew\u00e4hlt wurde, wird jetzt die komplette Buchungsstelle ersetzt. Damit wird die Infoanzeige, dass die Buchungsstelle nicht existiert, verhindert.</p> <p>Es wurde eine neue Checkbox \"Istversteuerung\" integriert. Bei der Buchung mit dem Buchungsschl\u00fcssel 411 ist diese entsprechend der Schaltereinstellung des Schalters F03 gef\u00fcllt und kann nicht manuell genutzt werden. Anders ist dies bei Buchungen mit dem Buchungsschl\u00fcssel 511. Hierbei kann der Anwender aus der Buchung einen Fall nach Istversteuerung im Programm erzeugen. Eine Sicherheitsabfrage nach dem \u00dcbernehmen der Buchung sch\u00fctzt vor nicht gewollter Aktivierung der Checkbox.</p> <p>Die Buchung der ausl\u00e4ndischen Steuer ist nun im IFR m\u00f6glich. Sowohl innergemeinschaftliche Erwerbe als auch Leistungen nach \u00a7 13b UStG werden korrekt abgebildet. Voraussetzung f\u00fcr die Durchf\u00fchrung der Buchungen mit einem ausl\u00e4ndischen Personenkonto ist, dass dieses eine g\u00fcltige USt-ID in der Adressverwaltung enth\u00e4lt und die Steuerkennzeichen f\u00fcr diese Art der Buchungen korrekt eingerichtet sind.</p> <p>Es ist m\u00f6glich, dass Umbuchungen (Buchungsschl\u00fcssel 200, 201, 240 und 241) mit Umstatz- / Vorsteuer erfolgen.</p> <p>312 \u2013 Dauerbuchung </p> <p>Beim Stornieren von Dauerbuchungen die mit Steuer gebucht wurden, kam es zu einem Fehler bei der Verbuchung. Hierzu erfolgte eine Korrektur.</p> <p>Bei steuerpfl. Eingangsrechnungen wird zun\u00e4chst unabh\u00e4ngig von der Einstellung in den Stammdaten von einer Soll-Versteuerung ausgegangen. Davon kann nun auch abgewichen werden, wenn es der Fall erfordert. Hier ist dann die Markierung bei \"Ist-Versteuerung\" innerhalb der Buchung zu setzen.</p> <p>Die Zuordnung der Parameter f\u00fcr die Dauerbuchung wie bspw. die Anzahl der Buchungen, dem zeitlichen Abstand, ob die Buchung zum Monatsletzten oder ob er die Feiertage ber\u00fccksichtigen soll, ist jetzt unter dem Button \"Eigenschaften\" zu finden.</p> <p>Zur besseren Selektion der Dauerbuchungen kann jetzt nach der Dauerbuchungsvorgangsnummer (nur ganze Nummer, ohne Wildcards m\u00f6glich) und Leistungsperiode selektiert werden. Zuk\u00fcnftig werden die historischen Dauerbuchungen zur besseren \u00dcbersichtlichkeit standardm\u00e4\u00dfig ausgeblendet. Um sich die historischen Dauerbuchungen anzeigen zu lassen, gibt es das Selektionsfeld \"Historische Dauerbuchungen\"</p> <p>313 \u2013 Sicherheitseinbehalt </p> <p>Das Anlegen von Sicherheitseinbehalten mit demselben F\u00e4lligkeitsdatum wie der Basis-OP wird verhindert.</p> <p>Beim Ausweis der erstellten Sicherheitseinbehalte kam es unter bestimmten Konstellationen zu einem fehlerhaften Ausweis der Sicherheitseinbehalte. Die Liste wurde dahingehend umgestellt.</p> <p>Beim Erstellen des Sicherheitseinbehaltes f\u00fcr eine Buchung mit R0-Konto wurde intern das FR-Konto nicht mit ber\u00fccksichtigt. Beim Stornieren von Sicherheitseinbehalten werden die Sicherheitseinbehalte, die m\u00f6glich sind, jetzt besser farblich gekennzeichnet.</p> <p>32 \u2013 Tagesabschluss </p> <p>In der \u00dcbersicht der Verarbeitungsnachweise gibt es eine neue Spalte \"erstes Druckdatum\". Hier erfolgt der Ausweis des Datums f\u00fcr den ersten Druck des Verarbeitungsnachweises.</p> <p>In der Ist-Fortschreibung des Tagesabschlusses werden Buchungen mit Buchungsschl\u00fcssel 331 korrekt als Ein- / Auszahlungen ber\u00fccksichtigt. Dadurch ist eine korrekte Zahlwegsumbuchung mit Hilfe der Buchungsschl\u00fcssel 231 und 331 (ohne diversen Debitor / Kreditor) m\u00f6glich.</p> <p>33 \u2013 Buchungsstapel </p> <p>Bei Buchungen, welche aus dem Eingangsrechnungsjournal kamen, traten Fehler beim Verbuchen des Buchungsstapels aufgrund des Steuerkennzeichens auf \u2013 insbesondere dann, wenn die Zahlung vor der Eingangsrechnung verbucht wurde. Dieser Fehler ist nun behoben.</p> <p>Es erfolgte eine Korrektur der Doppik-Schnittstelle hinsichtlich der Verarbeitung von Buchungsf\u00e4llen, die mit einem Steuerkennzeichen (Steuersatz 0%) per Schnittstelle kommen, wo aber dem zugeh\u00f6rigen Sachkonto im IFR kein Steuerkennzeichen zugeordnet ist. Deshalb erfolgt jetzt in der Schnittstelle eine Pr\u00fcfung, ob das Steuerkennzeichen in der Schnittstelle zum Steuerkennzeichen im Sachkonto passt. Wenn das Steuerkennzeichen im Sachkonto leer ist und in der Schnittstelle steht ein Steuerkennzeichen f\u00fcr 0%, dann wird das Steuerkennzeichen von der Schnittstelle leer gemacht. Wenn das Steuerkennzeichen in der Schnittstelle andernfalls vom Sachkonto abweicht, wird eine Fehlermeldung eingeblendet.</p> <p>35 \u2013 Schnittstellen (Plandatenschnittstelle) </p> <p>Innerhalb der Plandatenschnittstelle besteht nun die M\u00f6glichkeit, den Ergebnishaushalt in den Finanzhaushalt abzuleiten. Dabei gewinnt die letzte ER-FR Zuordnung, alle vorherigen werden \u00fcberschrieben.</p> <p>35 \u2013 Schnittstellen (Jahresstatistik und Vierteljahresstatistik) </p> <p>Bei der Ausgangsschnittstelle f\u00fcr die Jahresstatistik und die Vierteljahresstatistik gibt es nun f\u00fcr den Parameter \"Ausgabe im CSV- oder Textformat\" die Auswahlm\u00f6glichkeit von CSV (CSV-Format) und TXT (Textformat).</p> <p>36 \u2013 Anordnungsdruck </p> <p>Beim Abweisen von einzelnen AO-Listenpositionen ist die Hinweismeldung, welche Aktionen durchgef\u00fchrt werden, jetzt aussagekr\u00e4ftiger gestaltet.</p> <p>Beim der Druck der AO-Liste wird jetzt, wenn es Buchungen mit \"Sperre\" gibt, diese mit auf der AO-Liste ausgewiesen.</p> <p>Bei einer Ratenbuchung kommt es sehr oft zu einer Rundungsbuchung in der letzten Periode. Auf der AO wurde diese allerdings unter den weiteren Teilbuchungen nicht immer korrekt an die letzte Stelle eingeordnet. Hierzu ist die Sortierung angepasst worden, so dass die Rundungsbuchung jetzt an letzter Stelle kommt.</p> <p>Die Druckaufbereitung f\u00fcr Einzelanordnungen und Anordnungslisten wurde um die Vorlagenoption \"Abstand Unterschrift f\u00fcr DMS angepasst\" erweitert. Mit Hilfe dieser Einstellung wird mehr Platz im Bereich der Unterschriftsfelder bereitgestellt. Dadurch k\u00f6nnen beim Zeichnungsprozess im DMS (fortgeschrittene Signatur) Signaturobjekte in Form einer Grafik besser eingebettet werden.</p> <p>391 \u2013 Personenkontenauskunft </p> <p>Der aktuelle Status des SEPA-Mandates (aktiv, ruhend, gesperrt usw.) eines Personenkontos wird nun direkt auf der Einstiegsmaske der Personenkontenauskunft ausgewiesen.</p> <p>F\u00fcr die bessere Selektion wurden in der Registerkarte \u201eBuchungen\u201c weitere Selektionsfelder eingef\u00fcgt. Zus\u00e4tzlich werden jetzt beim Markieren der Buchungen die Werte in der unteren Zeile addiert.</p> <p>Es wurde die Spalte \"IBAN\" integriert. Diese zeigt bei kreditorischen OP\u2019s die Bankverbindung an, mit welcher der OP verkn\u00fcpft bzw. an welche Bankverbindung die Zahlung get\u00e4tigt wurde. Bei debitorischen OP\u2019s wird die Spalte IBAN nur bei automatischen Zahlungsl\u00e4ufen ausgewiesen. \u00c4nderungen der Bankverbindung \u00fcber das Men\u00fc 4a - OP-Anpassung werden in der Spalte \"IBAN\" historisch mit aufgef\u00fchrt.</p> <p>Bei der Anzeige der Verkehrszahlen zu den Forderungs-/Verbindlichkeitskonten gab es ein Anzeigeproblem der Werte zwischen gebuchter Summe des Vorjahres und der angezeigten EB-Summe des Folgejahres, in Abh\u00e4ngigkeit ob der Jahresabschluss f\u00fcr das Jahr schon durchgef\u00fchrt ist oder nicht. Sofern das Vorjahr zum Sachkonto abgeschlossen wurde, steht in EB-Soll (SummeVorjahrSoll - SummeVorjahrHaben).</p> <p>392 \u2013 Produkt-/Sachkontenauskunft </p> <p>F\u00fcr die bessere Selektion wurden in der Registerkarte \u201eBuchungen\u201c weitere Selektionsfelder eingef\u00fcgt, insbesondere f\u00fcr die Selektion nach dem Rechnungseingangsdatum. Wenn das Eingangsdatum nicht genau bekannt ist, kann mit den Operatoren &gt;, &lt;, AND und OR sowie dem Befehl NULL auch nach Datumsbereichen selektiert werden. Zus\u00e4tzlich werden jetzt beim Markieren der Buchungen die Werte in der unteren Zeile addiert.</p> <p>Nach einer \u00c4nderung in der Sachkontenauskunft verhindert eine unzul\u00e4ssig kombinierte Buchungsstelle nicht mehr jede weitere Aktion in dieser Maske wie bisher. Wenn nach einer Auskunft \u00fcber eine zul\u00e4ssige Kombination auf die n\u00e4chste Buchungsstelle gewechselt wird und dabei kurzzeitig eine unzul\u00e4ssige Kombination in der Maske steht, wird zwar weiter eine Information ausgegeben, es kann danach aber sofort weitergearbeitet werden.</p> <p>393 \u2013 Buchungsrecherche </p> <p>Es wurde ein neues Selektionsfeld f\u00fcr die Auswertung des Eingangsdatums der Buchungen geschaffen. Wie im Men\u00fc 392 \u2013 Sachkontenauskunft kann auch hier bei der Selektion mit Operatoren gearbeitet werden.</p> <p>394 \u2013 Budget\u00fcbersicht </p> <p>Um einen besseren Maskendurchlauf mittels der Tab-Taste zu erreichen, ist die Tab-Reihenfolge und Selektionsmaske angepasst worden. Bei der Selektion des Sachkontos wird jetzt die Auswahlliste der Sachkonten auf die dem Budget zugeordneten begrenzt, sofern das Budget mit angegeben wurde.</p> <p>Budgetumbuchungen auf Mittel aus dem Vorjahr werden in der Budget\u00fcbersicht in einer anderen Spalte ausgewiesen. Dabei werden nur die abgehenden Mittel in einer anderen Spalte ausgewiesen - und nicht wie bisher die als in Anspruch genommenen Mittel. Auf der Zielbuchungsstelle werden die Mittel weiterhin in der Spalte Mittel aus Vorjahr dargestellt.</p> <p>Beim Doppelklick auf den Laufzeitbalken wird die Aktualisierung der Budget\u00fcbersicht beendet. Er zeigt dann nur die Daten an, die er schon bis zu dem Zeitpunkt zusammengestellt hat.</p> <p>396 \u2013 Liquidit\u00e4tsanzeige </p> <p>In der Liquidit\u00e4tsauskunft wurde ein zus\u00e4tzliches F\u00e4lligkeitsdatum eingef\u00fcgt, um alte (noch nicht berichtigte) Forderungen anders bewerten zu k\u00f6nnen als aktuelle Forderungen.</p> <p>Der Nachdruck von gespeicherten Ausk\u00fcnften ist wieder m\u00f6glich. Nach dem \u00d6ffnen der Maske kann die gespeicherte Auswertung ge\u00f6ffnet und gedruckt werden.</p> <p>3a4 \u2013 Kontoauszugsdruck </p> <p>Bei einer Bankenfusion erhalten viele Kommunen eine neue IBAN f\u00fcr Ihre Bankverbindung. Da dies nicht wirklich eine neue Bankverbindung ist, wird der vorhandene Zahlweg angepasst. Das f\u00fchrt allerdings dazu, dass bei Nutzung des Kontoauszugsverfahrens nicht mehr auf die alten, schon vorhandenen Kontoausz\u00fcge zugegriffen werden konnte. Damit der Zugriff wieder m\u00f6glich ist, wurde intern ein Zahlwegskriterium eingef\u00fchrt.</p> <p>3b1 \u2013 Verwahrg\u00fcter </p> <p>Zu einem Verwahrgut k\u00f6nnen zus\u00e4tzliche Informationen unter dem Reiter \"weitere Angaben\" erfasst werden. Bevor dies erfolgen kann, m\u00fcssen unter den Stammdaten zum Verwahrgelass (18 - Stammdaten Reiter weitere Angaben) die gew\u00fcnschten Informationsfelder definiert werden.</p> <p>Die Bearbeitung von einzelnen Positionszeilen eines Verwahrgelasses ist nun wieder m\u00f6glich.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html#op-bearbeitung","title":"OP-Bearbeitung","text":"<p>41 \u2013 Auszifferung </p> <p>In der Auszifferung wird f\u00fcr die korrekte Periodenbildung nun das Belegdatum beachtet.</p> <p>421 \u2013 Stundung </p> <p>Die falsche Anzeige in der \u00dcbersicht der Stundungen nach der Verbuchung einer \u00c4nderungsvereinbarung im Buchungsstapel wurde korrigiert.</p> <p>Zur besseren \u00dcbersichtlichkeit im Stundungsbescheid kann mit einer neuen Vorlagenoption der Block \"neue Raten\" unterdr\u00fcckt werden, da sich diese Angaben weitgehend mit dem Block \"Zahlungstermine\" decken. Au\u00dferdem ist es jetzt m\u00f6glich, ein Dienstsiegel in den Report einzubinden und damit den unteren Bescheidtext zu vervollst\u00e4ndigen. Im Stundungsreport FR_20121 wurde dazu ein gesonderter Bereich eingerichtet, in dem eine entsprechende Grafik des Siegels dargestellt werden kann. Voraussetzung hierf\u00fcr ist eine Grafikdatei mit der Bezeichnung logo_4_F20121.jpg die im Template-Ordner mandantenneutral oder -spezifisch gespeichert wurde.</p> <p>Bei der Erstellung der Stundung und dem darauffolgenden Druck kam es zu einem unterschiedlichen Verhalten wenn die Stundung mehrmals hintereinander gedruckt wurde. Dieses Verhalten ist korrigiert worden, so dass der Stundungsdruck jetzt immer gleich aussieht.</p> <p>45 \u2013 Pauschalwertberichtigung </p> <p>Bei dem Ausweis der zweifelhaften Forderungen aus AdV in der PWB kam es nicht immer zu einer korrekten Anzeige der Werte. Zuk\u00fcnftig werden alle OP's einbezogen, die bis einschlie\u00dflich des PWB-Jahres bebucht sind. Also wenn PWB in 2013 erfolgt, dann werden alle Forderungen kleiner gleich 2013 dargestellt.</p> <p>48 \u2013 Vollstreckung (Schnittstelle AVVISO im XFinanz Format) </p> <p>Die \u00dcbergabe der Betr\u00e4ge erfolgt nun in EUR. Zus\u00e4tzlich wird das Mahndatum \u00fcbergeben und die Rechtsform bei juristischen Personen weggelassen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html#auftrag-faktura","title":"Auftrag / Faktura","text":"<p>Ausgangsrechnungsjournal </p> <p>Das Ausgangsrechnungsjournal (ARJ) stellt eine neue Form der Fakturierung dar, bei der neue Technologien zum Einsatz kommen. Ziel war es, im Gegensatz zur Fakturierung mehre Einnahmearten in einer Rechnung abzubilden. Daher ist die Einnahmeart anders als bei der Fakturierung innerhalb der Position hinterlegt (analog ERJ). Mit dem ARJ kann grunds\u00e4tzlich jede Rechnung als Musterrechnung genutzt werden. Die alte Fakturierung wird vorerst im IFR erhalten bleiben. \u00a0</p> <p>Wenn das ARJ zum Einsatz kommen soll, bitten wir im Vorfeld um eine kurze Abstimmung mit der SASKIA\u00ae IFR Fachberatung. Unsere n\u00e4chste Schulung zum ARJ findet am 09.04.2018 satt oder ein individueller Vororttermin kann vereinbart werden. \u00a0</p> <p>51 - Auftragsverwaltung </p> <p>Der Druck der Bestellung wurde \u00fcberarbeitet. Es wurde bspw. ein Block eingef\u00fcgt, der die Auftragsnummer enth\u00e4lt. Au\u00dferdem ist der RTB_9 nun einpflegbar. Um diese Erweiterungen nutzen zu k\u00f6nnen ist allerdings der Report \"FR_20171_BESTELLUNG_B.MRT\" mit der breiten Variante des Briefkopfes zu verwenden.</p> <p>52 \u2013 Eingangsrechnungsjournal </p> <p>Beim ersten \u00d6ffnen des Eingangsrechnungsjournals im Rel. 49 sollte per Rechtsklick die Standardansicht hergestellt werden, da es neue Status gibt. Die Stornofunktion des Eingangsrechnungsjournals greift nur im Status B.</p> <p>Es ist eine neue M\u00f6glichkeit geschaffen worden, in der \u00dcbersicht der erfassten Eingangsrechnungen nach dem Rechnungseingangsdatum zu selektieren. Wenn das Eingangsdatum nicht genau bekannt ist, kann mit den Operatoren &gt;, &lt;, AND und OR sowie dem Befehl NULL auch nach Datumsbereichen selektiert werden. In der Maske zur Erfassung der Eingangsrechnung ist im Block der Positionserfassung das Feld zur Anzeige des zugeh\u00f6rigen Verbindlichkeitskontos eingef\u00fcgt worden. Das Verbindlichkeitskonto ergibt sich aus den dem Personenkonto und Sachkonto zugeordneten FV-Gruppen.</p> <p>Der AO-Druck f\u00fcr eine erfasste Eingangsrechnung die noch keine Rechnungspositionen enth\u00e4lt wird jetzt unterbunden.</p> <p>Wird in der Eingabemaske f\u00fcr die Eingangsrechnungen in dem Feld \"Vermerk Weiterleitung\" etwas eingetragen, so wird dieser Text auf dem Rechnungseingangsjournaldruck mit ausgewiesen.</p> <p>Ist nach dem Stornieren der Eingangsrechnung die dazugeh\u00f6rige Storno-AO abgewiesen worden, so blieb die Eingangsrechnung im Status \"Storno\". Hierzu ist die Systematik f\u00fcr die Stornierung der Eingangsrechnungen \u00fcberarbeitet worden.</p> <p>Nach einer \u00dcbernahme der Rechnung aus dem DMS in die Erfassungsmaske des Eingangsrechnungsjournals, wird neben dem Namen jetzt die Standardbankverbindung mit angezeigt, wenn ein passendes PK im IFR gefunden wird.</p> <p>Es wurde eine neue Checkbox \"Istver.\" integriert. Bei der Buchung mit dem Buchungsschl\u00fcssel 411 ist diese entsprechend der Schaltereinstellung des Schalters F03 gef\u00fcllt und kann nicht manuell genutzt werden. Anders ist dies bei Buchungen mit dem Buchungsschl\u00fcssel 511. Hierbei kann der Anwender aus der Buchung einen Fall nach Istversteuerung im Programm erzeugen. Eine Sicherheitsabfrage nach dem \u00dcbernehmen der Buchung sch\u00fctzt vor nicht gewollter Aktivierung der Checkbox.</p> <p>54 \u2013 Ausgangsrechnungsjournal (neuer Men\u00fcpunkt) </p> <p>Im Einstiegsfenster des Ausgangsrechnungsjournals werden entsprechend der in den Suchfeldern angegebenen Kriterien die vorhandenen Ausgangsrechnungen aufgelistet. Die Rechnungen k\u00f6nnen je nach Stand ihrer Bearbeitung aus dieser Maske heraus neu erfasst, bearbeitet, gebucht, gedruckt (Rechnung oder Anordnung) storniert, oder gel\u00f6scht werden.</p> <p>Im ARJ besteht die Besonderheit, dass jede bereits erfasste Rechnung als Musterrechnung dienen kann, d.h. die Rechnung wird kopiert und kann demnach wieder als neue Rechnung bearbeitet bzw. ge\u00e4ndert werden.</p> <p>\u00dcber den Button \u201eNeue Rechnung\u201c k\u00f6nnen beliebig viele Rechnungspositionen mit unterschiedlichen Einnahmearten sowie mit und ohne Umsatzsteuer erfasst werden. Zus\u00e4tzlich ist es m\u00f6glich, einen individuellen Freitext ohne Zeichenbegrenzung einzugeben. Der Freitext kann durch die integrierte RTF-Komponente spezifisch formatiert werden. Die im Men\u00fc 55 festgelegten Stammdaten lassen grunds\u00e4tzlich bei der Rechnungserfassung pro Rechnungsposition \u00e4ndern, wie z.B. die Erfassung von Ratenf\u00e4lligkeiten oder eines Skontos. Davon ausgenommen ist die Einnahmeart.</p> <p>55 \u2013 Stammdaten (neuer Men\u00fcpunkt) </p> <p>Der Men\u00fcpunkt 55 unterteilt sich in die Registerkarten Tarifgruppenverwaltung und Tarifverwaltung. \u00a0</p> <p>In der Registerkarte Tarifgruppenverwaltung lassen sich die Tarifgruppen anlegen und k\u00f6nnen einem oder mehreren Tarifen zugeordnet werden. Es lassen sich folgende Datenfelder definieren: Tarifgruppe (eindeutige Tarifgruppennummer) | Bezeichnung | Einnahmeart | Buchungstext 2 | Buchungsschl\u00fcssel | Anzahl Raten| Raten-Code (Ratenabstand).</p> <p>Eine Tarifgruppe kann mit einem Artikel verglichen werden, welcher mehrere Preise haben kann. </p> <p>Im Reiter Tarifverwaltung lassen sich die Tarife anlegen und k\u00f6nnen einen oder mehreren Tarifgruppen zugeordnet werden. \u00a0Es lassen sich folgende Datenfelder definieren: Tarifnummer | Bezeichnung | Mindestmenge | Bruttobetrag | Nettobetrag | Skontosatz.</p> <p>Die Felder Brutto- und Nettobetrag dienen dazu, Satzungen mit Brutto- oder Nettowerden abbilden zu k\u00f6nnen. Ein Tarif kann mit dem Preis eines Artikels (Tarifgruppe) verglichen werden. </p> <p>Es lassen sich somit beliebig viele Tarifgruppen mit beliebig vielen Tarifen anlegen. Ein Tarif kann grunds\u00e4tzlich mehreren Tarifgruppen zugeordnet werden.</p> <p>562 \u2013 Auswertung Eingangsrechnungen </p> <p>Es ist eine neue M\u00f6glichkeit geschaffen worden, nach dem Rechnungseingangsdatum zu selektieren. Wenn das Eingangsdatum nicht genau bekannt ist, kann mit den Operatoren &gt;, &lt;, AND und OR sowie dem Befehl NULL auch nach Datumsbereichen selektiert werden. Im entsprechenden Report ist das Rechnungseingangsdatum ebenfalls mit eingef\u00fcgt worden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html#auswertungen","title":"Auswertungen","text":"<p>6223 \u2013 Kontoauszug </p> <p>Die Selektion f\u00fcr den Ausweis der \u00fcberf\u00e4lligen OP's ist angepasst worden. Sobald man den Punkt \"\u00fcberf\u00e4llige OP's\" ausw\u00e4hlt, wird bei \"F\u00e4lligkeit bis\" das aktuelle Tagesdatum eingetragen.</p> <p>623 \u2013 Summen- und Saldenliste </p> <p>Es ist nun m\u00f6glich eine SUSA-Liste der Personenkonten zu drucken.</p> <p>636 \u2013 R\u00fcckstellungs\u00fcbersicht Jahresrechnung </p> <p>In der R\u00fcckstellungs\u00fcbersicht Jahresrechnung kam es in der Berechnung der Spalte \"voraussichtlicher Stand zum 31.12. des HH-Jahres\" zu einem Fehler in der Berechnung der Werte. Dies ist behoben, so dass die Werte mit der Bilanz \u00fcbereinstimmen.</p> <p>651 \u2013 Gesamtfinanzplan / 652 \u2013 Gesamtfinanzrechnung </p> <p>Die M\u00f6glichkeit, Diagramme auf den Reports mit auszugeben, wurde auch auf Gesamtfinanzplan und Gesamtfinanzrechnung ausgeweitet.</p> <p>6513 \u2013 Teilfinanzplan B </p> <p>Beim Druck in Verbindung mit der Option \"Ausweis Nullpositionen\" kam es zu einem Fehlverhalten. Der Report wurde korrigiert, so dass jetzt je nach gesetzter Option der richtige Listendruck erfolgt.</p> <p>6611 \u2013 Debitorische OP-Liste erstellen </p> <p>Beim Druck einer OP-Liste mit der Sortierreihenfolge \"nach Buchungsstellen\" und Stichtagsbezug wurde eine Zwischensumme pro Buchungsstelle implementiert.</p> <p>6614 \u2013 Mahnvorschlag </p> <p>Wird bei einem Personenkonto ein Zusteller eingerichtet, dem als OP-Bezug \"MAHN\" zugeordnet ist, so wird immer dieser als Mahnempf\u00e4nger beim Mahndruck herangezogen. Gibt es keinen derart definierten Zusteller, so wird ein anderer Zusteller mit passenden OP-Bezug genommen. Wenn gar kein Zusteller zugeordnet ist, gilt die Personenkonten-Adresse.</p> <p>Im Mahnreport besteht \u00fcber die neue Vorlagenoption \"als Ank\u00fcndigung der Vollstreckung\" die M\u00f6glichkeit, die Bezeichnung der Zwischensummenzeile (bei Ausweis der sonstigen Forderungen) bzw. der Gesamtsummenzeile zu ver\u00e4ndern. Dabei wird der Standardtext \"Forderungen aus dieser Mahnung\" durch den abweichenden Text \"Gesamtbetrag der Forderung\" ersetzt.</p> <p>6619 \u2013 Mahnnachdruck </p> <p>Beim Mahnnachdruck \u00fcber mehrere ausgew\u00e4hlte Mahnungen kam es zu einem Fehler beim Druckausweis. Es wurde immer das Mahndatum der letzten selektierten Mahnung f\u00fcr alle zu druckenden Mahnungen verwendet. Das ist korrigiert, jetzt wird f\u00fcr jede selektierte Mahnung das richtige Mahndatum angedruckt</p> <p>671 \u2013 Umsatzsteuerjournal </p> <p>F\u00fcr das Steuerjournal sind weitere Selektionsfelder (Zeitbuchjahr, Zeitbuchnummer) integriert worden.</p> <p>671 \u2013 Umsatzsteuerjournal (Registerkarte Buchungsrecherche) </p> <p>Die Steuerbuchungsrecherche, die neu als Registerkarte im Men\u00fc des Umsatzsteuerjournals eingebunden wurde, stellt alle Buchungen mit Steuer dar. Es gibt zahlreiche Einschr\u00e4nkungsm\u00f6glichkeiten, die bei Abstimmungsarbeiten bez\u00fcglich der Umsatzsteuervoranmeldung helfen sollen. Beispiele hierf\u00fcr sind Filterm\u00f6glichkeiten der Spalte \"USt-VA\", um herauszufinden, welche Buchungen in welche Meldung eingebunden sind. Au\u00dferdem ist es m\u00f6glich \u00fcber die Filterung der Spalte \"Steuerbuchung Soll bzw. Haben\" in Verbindung mit der Periode, die Summen der entstandenen Vor- und Umsatzsteuer zu ermitteln. Auch ist es m\u00f6glich, dass nach Produkten gefiltert werden kann. Somit kann die Steuerlast pro Produkt und Periode ermittelt werden.</p> <p>672 \u2013 Umsatzsteuervoranmeldung </p> <p>\u00dcber den Button \"Steuerformular anzeigen/versenden\" wird das Formular der Umsatzsteuervoranmeldung ausgef\u00fcllt angezeigt. Auch der Druck des Formulars ist m\u00f6glich. Per Tooltips werden die Werte der Voranmeldung konkretisiert dargestellt, aus welchen Steuerkennzeichen sich diese zusammensetzen. Hierf\u00fcr muss nur der Mauszeiger \u00fcber den Wert gelegt werden. Nach Pr\u00fcfung durch den Anwender kann die Voranmeldung nun auch elektronisch an das Finanzamt \u00fcbermittelt werden. Dies ist \u00fcber den Sendebutton m\u00f6glich. Nach Versendung der Umsatzsteuervoranmeldung ist die Meldung nicht mehr editierbar. \u00c4nderungen, welche die bereits versendete Umsatzsteuermeldung betreffen, m\u00fcssen nunmehr in einer Korrekturmeldung dargestellt werden. Au\u00dferdem werden \u00fcber den Button Sendeprotokolle ausgegebene. Die Eingangsmaske des Men\u00fcpunktes der Umsatzsteuervoranmeldung zeigt die Perioden an, in denen eine Voranmeldung abzugeben ist. Dabei gibt es zu jedem Monat eine darunterliegende Tabelle, welche angibt in welchem Status sich die Umsatzsteuervoranmeldung der entsprechenden Periode befindet und ob es ggf. noch weitere Meldungen (sog. \"Korrekturmeldungen\") gibt. Per Rechtsklick in die entsprechende Zeile k\u00f6nnen sowohl die Voranmeldung als auch das Formular selbst gedruckt werden. Ebenfalls mittels Rechtsklick k\u00f6nnen die Buchungen angezeigt werden, welche in der Meldung enthalten sind. Damit erh\u00e4lt der Anwender eine Abstimmfunktion bzw. ein Tool zur Fehlersuche bei ggf. nicht zu erkl\u00e4renden Werten.</p> <p>Die Tabellenstrukturen und somit auch die Such-/ Filterm\u00f6glichkeiten wurden verbessert. Bei diesen neuen Tabellen gibt es nun die M\u00f6glichkeit, jede Spalte nach Werten dieser Spalte zu selektieren, nach dem Vorbild von Excel.</p> <p>Damit das Formular der Umsatzsteuervoranmeldung korrekte Werte erh\u00e4lt, m\u00fcssen die Steuerkennzeichen, die vom Anwender \u00fcber die Buchungsm\u00f6glichkeiten im IFR bebucht werden, mit den jeweiligen Feldern der Umsatzsteuervoranmeldung verkn\u00fcpft werden. Dies geschieht \u00fcber die Mandantenverwaltung (Men\u00fc 11) in der Registerkarte \"Umsatzsteuer\". Um zu gew\u00e4hrleisten, dass kein Steuerkennzeichen bei der Zuordnung vergessen wurde, welches ggf. bereits bebucht und somit relevant f\u00fcr die Voranmeldung ist, wurde im Men\u00fc der Umsatzsteuermeldung eine Pr\u00fcfung hinterlegt, welche eine Warnung ausgibt, sollte nicht jedes Steuerkennzeichen zugeordnet sein. Das Formular erscheint zwar auch ohne eine vollst\u00e4ndige Zuordnung und auch der Sendevorgang an das Finanzamt ist m\u00f6glich, es besteht dadurch jedoch die M\u00f6glichkeit f\u00fcr den Anwender, noch einzuschreiten, wenn es erforderlich ist.</p> <p>Auf dem Druck der Umsatzsteuerzusammenstellung weist die Spalte \"nicht f\u00e4llige USt\" im Falle der Ist-Versteuerung den Steueranteil aus, bei welchem zur Sollstellung im zu betrachtenden Monat noch keine Ist-Buchung vorhanden ist. Erfolgt die Ist-Buchung in einem Folgemonat, so mindert sich der Wert in dieser Spalte wieder um die H\u00f6he des Steueranteils, der nun mit der Ist-Buchung einhergeht. Zuvor war es ein Unterschied, ob der Periodendruck in Bezug auf die Spalte \"nicht f\u00e4llige USt\" monatsgenau (bspw.5-5) oder monats\u00fcbergreifend (0-5) geschieht. Im Ersten Falle wurde die Soll-Stellung nicht mit beachtet und es konnte somit zu negativen, nicht f\u00e4lligen Umsatzsteuern kommen. Dies geschieht nun nicht mehr. Die Sollstellung wird nun immer mit in die Berechnung dieser Spalte eingebunden.</p> <p>Um die letzte Spalte \u201enicht f\u00e4llige USt\u201c besser nachvollziehen zu k\u00f6nnen, wird nun der VKZ-Wert vom Sachkonto mit ausgewiesen.</p> <p>Auf einer zweiten Registerkarte \u201e\u00dcbersicht der Dauerfristverl\u00e4ngerungen\u201c kann die entsprechende Dauerfristverl\u00e4ngerung angelegt sowie elektronisch an das Finanzamt \u00fcbermittelt werden. Das Formular f\u00fcr die Dauerfristverl\u00e4ngerung kann erstmalig f\u00fcr das HH-Jahr 2018 eingerichtet werden.</p> <p>Umsatzsteuervoranmeldungen k\u00f6nnen erst versandt werden, wenn auch die Vorperiode versandt wurde. (Ausnahme: wenn die Vorperiode r\u00fcckgesetzt wurde, kann die Folgeperiode trotzdem versandt werden).</p> <p>Nach erfolgreicher \u00dcbermittlung der Umsatzsteuervoranmeldung erscheint automatisch das \u00dcbertragungsprotokoll. Dieses kann auch sp\u00e4ter erneut aufgerufen werden. Dies funktioniert mittels Rechtsklick auf die bereits versendete USt-Meldung in der Eingangsmaske. Nun kann das Steuerformular erneut angezeigt werden und unter dem Button Sendeprotokolle befindet sich auf der ersten Registerkarte das \u00dcbertragungsprotokoll</p> <p>Die Erstellung, sowie die elektronische \u00dcbermittlung der Umsatzsteuervoranmeldung sind mit einer gesonderten Lizenzberechtigung hinterlegt. Bei nicht lizensierter Version kann das Umsatzsteuervoranmeldungsformular somit weder angezeigt noch elektronisch an das Finanzamt \u00fcbermittelt werden.</p> <p>Ist keine Lizenz f\u00fcr die elektronische \u00dcbertragung nach ELSTER vorhanden, ist die Checkbox im Umsatzsteuerregister Men\u00fc 11 nicht aktiviert. Um trotzdem die Meldung im Men\u00fc 672 \u00a0als gesendet zu kennzeichnen, gibt es die M\u00f6glichkeit, diese \u00fcber einen Rechtsklick als \"Versendet zu markieren\".</p> <p>Umsatzsteuervoranmeldungen, die versehentlich erstellt wurden, sind mittels Rechtsklick auf die Meldung und Auswahl \"Meldung l\u00f6schen\" zu entfernen. Die darin enthaltenen Buchungen sind nunmehr wieder in den ausstehenden Buchungen zu finden. Voranmeldungen, welche nicht versandt werden sollten, k\u00f6nnen mit dem aktuellen Tagespasswort zur\u00fcckgesetzt werden. Das Erstellen, L\u00f6schen, Versenden und R\u00fccksetzen von Umsatzsteuermeldungen kann in der Systemverwaltung, unter Protokolle im Modul \"IFR\" im Bereich der \"Umsatzsteuer \" nachvollzogen werden. Hierbei werden Nutzer, Datum und Uhrzeit hinterlegt.</p> <p>673 \u2013 Umsatzsteuerverprobung </p> <p>Mandanten oder einzelne Buchungen, die nach Ist-Versteuerung behandelt werden, werden nun \u00fcber das Finanzrechnungskonto verprobt, da die Vereinnahmung die Grundlage f\u00fcr die Umsatzsteuerf\u00e4lligkeit ist. In der Umsatzsteuerverprobung sind sowohl die Buchungen aus den bereits erstellten Steuermeldungen enthalten als auch die Buchungen, welche noch in den sog. \"ausstehenden Buchungen\" zu finden sind.</p> <p>Es wurde au\u00dferdem die Ausgabe der Verprobung erg\u00e4nzt. Der Verprobungsdruck kann nun nach Sachkonto, Produkt oder der kompletten Buchungsstelle erfolgen.</p> <p>68 \u2013 Freie Auswertungen </p> <p>Der Report FS12A4 (Adressen \u2013 Auswertung gesperrter Belege) wurde um die Parameter \"Mahnsperre bis\" und \"OP-Bezug\" erweitert.</p> <p>69 \u2013 Gesetzliche Drucklisten </p> <p>Die M\u00f6glichkeit, Diagramme auf den Reports auszuweisen wurde nun auch f\u00fcr die l\u00e4nderspezifischen Reports umgesetzt.</p> <p>F\u00fcr den Druck der Teilliste B (Investitionsprogramm) kann mit Hilfe der neuen Vorlagen-Option \"Lange Ma\u00dfnahmenbezeichnung verwenden\" nun auch in Brandenburg der ausgewiesene Beschreibungstext zur Einzelma\u00dfnahme gesteuert werden.</p> <p>Definierte Standarddruck Vorlagenoptionen werden im Men\u00fc 69 - Gesetzliche Drucklisten nicht mit \u00fcbernommen. Damit wird sichergestellt, dass beim Druck der gesetzlichen Listen standardm\u00e4\u00dfig keine Diagramme mit angedruckt werden.</p> <p>In der Liste M9 - Instandhaltungsma\u00dfnahmen wird jetzt bei Doppelhaushalten die richtige \u00dcberschrift f\u00fcr die Haushaltsjahre angezeigt.</p> <p>Im Einf\u00fchrungssatz der Haushalts- bzw. Nachtragssatzung wird das Einf\u00fcgen des Beschlussdatums in Men\u00fc 22 (Planvarianten) gesteuert. Da die Haushalts- bzw. Nachtragssatzung beim \u00f6ffentlichen Auslegen noch kein Beschlussdatum hat, wurde der Report angepasst. Ist das Feld \u201eBeschlussdatum\u201c in Men\u00fc 22 leer, so wird jetzt eine gepunktete Linie als Platzhalter angedruckt.</p> <p>Die Werte f\u00fcr das zweite Jahr des Doppel-HH werden in den Planlisten jetzt in einer extra Spalte ausgewiesen. Das gilt ebenso f\u00fcr die Nachtragswerte und die VE's.</p> <p>6s \u2013 Dokumentenmappen </p> <p>Zuk\u00fcnftig k\u00f6nnen auf den Zwischenbl\u00e4ttern der Dokumentenmappe individuelle Texte erfasst und Bilder eingef\u00fcgt werden. Es gibt zwei verschiedene M\u00f6glichkeiten Texte zu erfassen. Texte die auf allen Zwischenbl\u00e4ttern gleich erscheinen sollen, k\u00f6nnen unter RTB_1 und dem Report F60141 - Dokumentenmappe direkt erfasst werden. F\u00fcr individuelle Texte zu jedem einzelnen Zwischenblatt k\u00f6nnen unter RTB_1 mit der Befehlsfolge \"{BTB_Deckblatt{RPT}}\" und den zugeh\u00f6rigen Basistextbausteinen in der Form \"BTB_DeckblattA\" die Texte erfasst werden. Um die individuellen Textbausteine den einzelnen Zwischenbl\u00e4ttern der Dokumentenmappe zuzuordnen, ist es erforderlich den Textbaustein unter \"Bearbeiten\" noch den einzelnen Dokumentenmappenpositionen zuzuordnen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html#jahresabschluss","title":"Jahresabschluss","text":"<p>7111 \u2013 Mittel\u00fcbertragung ins Folgejahr aus offenen Auftr\u00e4gen </p> <p>Es wurden neue Suchfelder (Auftragsnummer, Adresse, Budget, Produkt, Sachkonto, Ma\u00dfnahme) zur besseren Selektion der zu \u00fcbertragenden Mitteln aus Auftr\u00e4gen hinterlegt. Es ist nun au\u00dferdem m\u00f6glich, die einzelnen Spalten der Tabelle auf- oder absteigend zu sortieren.</p> <p>731 \u2013 RAP-Verwaltung </p> <p>Auf dem Report wird nun ausgewiesen, wann und durch wen ein RAP abgewiesen wurde. Es \u00e4ndert sich au\u00dferdem auf der Druckliste die Bezeichnung \"zuletzt ge\u00e4ndert durch/am\" in \"abgewiesen durch/am\", sobald der entsprechende RAP abgewiesen wurde.</p> <p>Beim Abweisen der Storno-AO f\u00fcr einen RAP wird dieser jetzt in den richtigen Status \"Gebucht\" zur\u00fcckgedreht, damit ist ein erneutes Verbuchen des RAP's nicht mehr m\u00f6glich.</p> <p>Bei der Selektion auf den Status V werden nun wieder alle RAP's mit dem Status \u201eNeu\u201c und \u201eVorl\u00e4ufig\u201c angezeigt.</p> <p>732 \u2013 Bagatellbetragsbereinigung </p> <p>Beim duplizieren der Buchungstexte kam es zu einem Problem bei der \u00dcbernahme. Der Fehler wurde behoben.</p> <p>7332 \u2013 Buchhaltungsabstimmung </p> <p>Erweiterung der Pr\u00fcfung OP-Konsistenz in der Buchhaltungsabstimmung. Es wird nun gepr\u00fcft, ob die OP-Historie konsistent ist. Falls die KB_OP_PID innerhalb eines OP nicht konstant ist, wird eine Fehlermeldung ausgegeben.</p> <p>Wird ein offener Posten mit Hilfe des Zahlungs-, Auszifferungs-, Lastschrift- oder Gutschriftvorschlags teilweise oder komplett ausgeglichen, der Lauf ist aber noch nicht komplett vergebucht, so ist noch eine angewiesene Zahlung im OP. Korrekterweise muss der Lauf erstellt, best\u00e4tigt und verbucht werden, damit der OP korrekt beglichen ist. Ist der Vorgang noch nicht beendet bzw. steht noch eine angewiesene Zahlung im OP, so kann in der Buchhaltungsabstimmung unter der Registerkarte \"OP-Korrektur\" herausgefunden werden, woran dies liegt. Unter Eingabe der PK-Nummer und Setzen des Hakens \"Programmseitig keine Fehler\" kann erkannt werden, wo der OP noch h\u00e4ngt. Auch noch nicht verbuchte Vorg\u00e4nge, die noch im Buchungsstapel stehen, werden angegeben. Auch OP's aus der Kontoauszugsverbuchung werden angegeben.</p> <p>74 \u2013 Endg\u00fcltiger Jahresabschluss </p> <p>Im IFR-Jahresabschluss wird nun im Protokoll das abgeschlossene AnBu-Jahr angezeigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html#veranlagung","title":"Veranlagung","text":"<p>81 \u2013 Einzelveranlagung </p> <p>Die zum Objekt geh\u00f6renden Unterobjekte werden im Men\u00fc 81 (Einzelveranlagung) als Baumstruktur angezeigt. Der Baum kann auf- (\u00fcber +) und zugeklappt (\u00fcber -) werden.</p> <p>Es wurde die M\u00f6glichkeit geschaffen, Sammelbescheide f\u00fcr Geb\u00fchren (z. B. Trink- und Abwasser) in der Veranlagung zu verwalten.</p> <p>Es wurde f\u00fcr die Veranlagung die M\u00f6glichkeit der \u00dcbergabe der Veranlagungsbescheide ans DMS realisiert.</p> <p>Wenn bei einem vorhandenen Objekt ein neues Unterobjekt angelegt werden soll, k\u00f6nnen die Daten des Objektes inkl. Beschreibung, Veranlagungen etc. in ein erstes Unterobjekt \u00fcbergeben werden. Danach kann regul\u00e4r ein weiteres Unterobjekt hinzugef\u00fcgt werden. Die Veranlagung auf dem Hauptobjekt ist dann ausgeschlossen.</p> <p>\u00dcber das Men\u00fc 152 kann je Einnahmeart die \u00dcberschrift f\u00fcr die Ratenf\u00e4lligkeiten (laufendes und Folgejahre) individualisiert werden. Im Standard wird \"Ratenf\u00e4lligkeit\" vorgegeben. Au\u00dferdem k\u00f6nnen hier je nach Einnahmeart individuelle Bezeichnungen f\u00fcr die Zahlungs-/Steuerpflichtigen hinterlegt werden.</p> <p>Im Reiter \"1 Veranlagung\" ist in den Kopfdaten zur Veranlagung eine neue Spalte \"Einnahmeartbezeichnung\" eingef\u00fcgt worden. Zus\u00e4tzlich ist im Men\u00fc 152 bei der Bearbeitung in der Registerkarte \u201eTeilnehmer\u201c f\u00fcr die Sammeleinnahmearten S* bei den Einnahmearten noch die Bezeichnung erg\u00e4nzt worden.</p> <p>F\u00fcr die Auswahl der Buchungs-Einnahmeart gibt es jetzt in der Objektbearbeitung eine aufklappbare Auswahlliste f\u00fcr die im Men\u00fc 1275 angelegten Einnahmearten.</p> <p>In bestimmten Konstellationen wurden Tarifwerte ohne Nachkommastellen ausgewiesen. Wird neu veranlagt, werden die urspr\u00fcnglich fehlenden Nachkommastellen jetzt mit gedruckt. Die Summenfelder waren davon nicht betroffen und wurden bereits bisher richtig gedruckt.</p> <p>Neue Vorlage-Option \"Objektbeschreibung mit Schl\u00fcssel ausgeben\" beim Druck der Gewerbesteuerbescheide eingef\u00fchrt, mit welcher gesteuert werden kann, ob die Schl\u00fcssel vor den Werten in der Objektbeschreibung (Betriebsst\u00e4tte) angedruckt werden oder entfallen sollen. Standardm\u00e4\u00dfig ist die Option aktiviert, so dass es keine Unterschiede zum bisherigen Druck gibt.</p> <p>Das Layout Gewerbesteuerbescheides wurde hinsichtlich der Darstellung und Schriftgr\u00f6\u00dfen bei der Angabe der Steuerpflichtigen angeglichen.</p> <p>Beim Wirtschaftsjahr wird auf dem Bescheid unter der Veranlagungstabelle das jeweilige Wirtschaftsjahr vollst\u00e4ndig inkl. Jahreszahlen mit ausgegeben.</p> <p>Auf dem Bescheid wird nun das Steuerpflichtende anhand des Abmeldedatums ausgewiesen. Wenn es sich um Einnahmearten mit Unterobjekten handelt, wird das Steuerpflichtende erst ausgewiesen, wenn alle Unterobjekte abgemeldet sind.</p> <p>82 \u2013 Gesamtveranlagung </p> <p>Verbuchte Bescheide k\u00f6nnen jetzt \u00fcber die Gesamtveranlagung nachtr\u00e4glich gedruckt werden. Dieser Nachdruck wird mit den Daten erstellt, welche zum Zeitpunkt des Druckes im System hinterlegt sind. Wurden bspw. Adressen oder Bankverbindungen ge\u00e4ndert, werden diese ge\u00e4nderten Angaben ausgedruckt.</p> <p>843 \u2013 Analyse der Objektdaten </p> <p>In der Objektauswertung k\u00f6nnen jetzt auch die Jahreswechselwerte ausgewertet werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html#kredite-darlehen","title":"Kredite / Darlehen","text":"<p>a1 \u2013 Kredit/Darlehen bearbeiten </p> <p>Die Anpassung der Zinsen in den Raten der Abzahl- und Zinskredite kann f\u00fcr beliebig viele Raten erfolge, ohne dass diese Eingaben einzeln \u00fcbernommen werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html#anlagenbuchhaltung","title":"Anlagenbuchhaltung","text":"<p>Neue Men\u00fcstruktur Anlagenbuchhaltung </p> <p>Im Zuge der Erweiterung des AnBu-Moduls wurde die Men\u00fcstruktur \u00fcberarbeitet und umgestellt. Die nachfolgend beschriebenen Men\u00fcpunkte beziehen sich bereits auf die neue Men\u00fcstruktur.</p> <p></p> <p>b11 \u2013 Bearbeiten von Anlageg\u00fctern / b21 \u2013 Bearbeiten von Zusch\u00fcssen </p> <p>Das L\u00f6schen von nicht aktivierten Anlageg\u00fctern bzw. nicht passivierten Zusch\u00fcssen, welche Teile einer Umbuchung sind, ist nun nicht mehr m\u00f6glich, selbst wenn die Umbuchung bereits storniert ist. Es ist nun zwingend eine Buchung erforderlich.</p> <p>Es gab in der Vergangenheit wiederholt Probleme bei der Erfassung mehrerer Positionen bei der Neuanlage eines Anlagegutes oder eines Zuschusses. Dieser Fehler wurde bereinigt.</p> <p>Das Problem bei der Vergabe von Inventarnummern bzw. Zuschussnummern wurde ebenfalls behoben. Die Nutzung des entsprechenden Wartungsscriptes in der Systemverwaltung ist nur noch im Ausnahmefall n\u00f6tig.</p> <p>Zuschusszuordnungen zu 0,00 \u20ac k\u00f6nnen nun wieder problemlos gel\u00f6scht werden.</p> <p>Bei der Zuordnung von Zusch\u00fcssen wird nun das Positionsdatum der Zuordnung nicht mehr vorgeblendet, sondern ist vom Anwender auszuf\u00fcllen.</p> <p>b611 \u2013 Anlagennachweis </p> <p>Auf den Wunsch einiger Pr\u00fcfer wurde in den Anlagennachweis eine neue Spalte unter der Rubrik Abschreibungen eingef\u00fcgt, in der nun die Zuschreibungen extra und mit positivem Vorzeichen ausgewiesen werden. Die Auswahl ist \u00fcber die Vorlagen-Optionen im Druckdialog m\u00f6glich.</p> <p>b721 \u2013 Pr\u00fcfung fehlende AfA </p> <p>Es k\u00f6nnen zur Pr\u00fcfung nun einzelne Anlageg\u00fcter bzw. Zusch\u00fcsse ausgew\u00e4hlt werden.</p> <p>b73 \u2013 Jahresabschluss (AnBu) </p> <p>In der IFR-Hilfe ist nun eine Checkliste zum Jahresabschluss Anlagenbuchhaltung hinterlegt.</p> <p>Mit dieser neuen Funktion ist es m\u00f6glich, AfA-Stamms\u00e4tze einzelner Anlageg\u00fcter bzw. Zusch\u00fcsse von dem in der Bearbeitungsmaske vorgeblendeten Haushaltsjahr in das Folgejahr zu \u00fcbertragen. Werden beim \u00dcbertrag Fehler festgestellt, so werden diese angezeigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html#kosten-und-leistungsrechnung","title":"Kosten- und Leistungsrechnung","text":"<p>Neue Men\u00fcstruktur KLR </p> <p>Im Zuge der Erweiterung des KLR-Moduls wurde die Men\u00fcstruktur \u00fcberarbeitet und umgestellt. Die nachfolgend beschriebenen Men\u00fcpunkte beziehen sich bereits auf die neue Men\u00fcstruktur</p> <p></p> <p>c33 \u2013 R\u00fcckgabe an die Bewirtschaftung </p> <p>Die Belegnummer f\u00fcr die \u00dcbergabe der Daten aus der KLR in den Buchungsstapel, ist um die Umlagebezeichnung erweitert worden. Hinweis! Ist die Umlagenummer l\u00e4nger als 6 Stellen, und damit die Belegnummer l\u00e4nger als 20 Zeichen, wird sie auf 20 Zeichen gek\u00fcrzt und verbucht.</p> <p>Auf der Programmmaske wird jetzt der im Men\u00fc 1271 f\u00fcr Umbuchungen definierte Buchungskreis vorgeblendet. Es gilt folgende Definition der Vorblendung des Buchungskreises: Gibt es einen Buchungskreisnutzer und den Haken bei Umbuchungen, so wird dieser Buchungskreis genommen. Gibt es einen Haken bei Umbuchungen bzw. einen eingetragenen Buchungskreisnutzer, so wird der Buchungskreis vorgeblendet, bei welchem der erste Haken bei Umbuchungen gefunden wird oder der erste eingetragene Buchungskreisnutzer beginnend in der Liste von oben.</p> <p>c41 \u2013 Berechnung (ehemals Men\u00fcpunkt c4) </p> <p>Die Umlageart 03 wird bei der Plankostenrechnung nun als Monatswert behandelt. Daher wird sie in der Jahresplanung nun mit 12 multipliziert angezeigt und berechnet und damit an die Kostenrechnung angepasst. In der Kostenrechnung wird es weiterhin als Monatswert betrachtet.</p> <p>Vor dem Berechnungslauf in der KLR wurde eine Pr\u00fcfung erg\u00e4nzt, ob \u00fcberhaupt Daten in der KLR Vorliegen (Daten\u00fcbernahme im Men\u00fc c31).</p> <p>c42 \u2013 Buchungsstellen (neuer Men\u00fcpunkt) </p> <p>Im neuen Men\u00fcpunkt \"Buchungsstellen\" k\u00f6nnen die in der KLR vorhandenen VKZ f\u00fcr Plan und Ist-Kostenrechnung ausgewertet werden. Es werden au\u00dferdem die KLR-Buchungen angezeigt.</p> <p>c43 \u2013 Umlageprotokoll (neuer Men\u00fcpunkt) </p> <p>Im neuen Men\u00fcpunkt \"Umlageprotokoll\" kann der BAB in einer Kreuztabelle im System ausgewertet werden.</p> <p>c51 \u2013 Einzelbuchung (neuer Men\u00fcpunkt) </p> <p>In der KLR-Einzelbuchung werden bei Buchungsschl\u00fcssel 912 nicht mehr alle K0-Konten angeboten, sondern nur noch K0-Konten, welche als KLR-Bestandskonten deklariert sind.</p> <p>c62 \u2013 BAB-Auswertung (ehemals Men\u00fcpunkt c6) </p> <p>Zuk\u00fcnftig werden deaktivierte KLR-Umlagen beim Druck des Umlageprotokolls nicht mehr mit beachtet.</p> <p>Beim Druck des BAB f\u00fcr Buchwerte wurden die Vorjahreswerte erg\u00e4nzt.</p> <p>c65 \u2013 Umlagedefinitionen (neuer Men\u00fcpunkt) </p> <p>Der Druck einer Liste der angelegten Umlagen und Rechenzeilen (ehemals Men\u00fcpunkt c1) wurde in den neuen Men\u00fcpunkt c65 ausgelagert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0049/programmaenderungenrelease4.1.0049-stand4.10.2018/programmaenderungen_stand_19.0.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s12 \u2013 DMS-Konfiguration </p> <p>Im Menu s12 k\u00f6nnen individuelle Suchfelder f\u00fcr den DMS-Abfragedialog im Eingangsrechnungsjournal definiert werden. Hierbei handelt es sich um solche Felder, welche im DMS als Metadatum vorhanden sind, wo es aber in Bezug auf den Rechnungseingangsworkflow in der Datenstruktur des IFR kein \u00e4quivalentes Metadatum gibt. Es k\u00f6nnen bis zu 10 individuelle Abfragefelder definiert werden. Diese Feldnamen sind mit Query01, Query02 usw. bezeichnet. Im Men\u00fc s12 erfolgt dann wie gewohnt das Mapping auf den Feldnamen im IFR. Der Labeltext dieser individuellen Abfragefelder kann entsprechend des konkreten Metafeldes angepasst werden. Dazu wird im DMS-Mapping-Einrichtungsdialog in der Spalte Beschreibung der gew\u00fcnschte Labeltext hinterlegt mit der Syntax Labeltext; Beschreibung z.B. Produkt; Hier kann man dann das Produkt filtern Die Einrichtung sollte gemeinsam mit Ihrem IFR-Fachberater vorgenommen werden.</p> <p>s21 \u2013 Benutzerverwaltung (Registerkarte Rechte) </p> <p>Das Einlesen und Verarbeiten von bestimmten Schnittstellen kann nun \u00fcber die Nutzerrechte in der Systemverwaltung eingegrenzt werden.</p> <p>s31 \u2013 Releasewechsel </p> <p>Im Releasewechsel ist ein Punkt \"Erstellung von Steuermeldungen f\u00fcr Jahre vor 2018 und Zuordnung der Buchungen\" eingebaut. Dieser sorgt daf\u00fcr, dass beim erstmaligen \u00d6ffnen der Ausstehenden Buchungen nicht s\u00e4mtliche Buchungen darin stehen, welche steuerlich je im IFR gebucht wurden. Deshalb werden f\u00fcr alle Buchungen, die vor dem HHJ 2018 gebucht wurden, pauschal Meldungen in dem HHJ und der Periode erstellt, in der diese gebucht wurden. Der viertelj\u00e4hrliche Voranmeldungszeitraum wird hierbei nicht ber\u00fccksichtigt.</p> <p>s51 \u2013 \u00c4nderungsprotokolle </p> <p>In der Systemverwaltung ist der Men\u00fcpunkt f\u00fcr die Protokollierung der System\u00e4nderungen (bisher \u00fcber Trigger im Men\u00fc s42) umfangreich \u00fcberarbeitet und erweitert worden.</p> <p>Es sind jetzt auch f\u00fcr die Planungsfunktionen (IFR-Men\u00fcpunkte 23, 24*) die Protokolleintr\u00e4ge zur Anzeige vorhanden. Gleichzeitig ist unter s41 noch eine Registerkarte zur Protokollbereinigung hinzugef\u00fcgt worden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/installation_checkliste_release50.html","title":"Installation Checkliste Release 4.1.0050","text":""},{"location":"aktuelles/releasehistorie/release4.1.0050/installation_checkliste_release50.html#installation-checkliste-release-410050","title":"Installation Checkliste Release 4.1.0050","text":"<p>Vorg\u00e4ngerrelease ist Release 49</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/installation_checkliste_release50.html#update","title":"Update","text":"<p>1. Alle SASKIA\u00ae.de IFR-Nutzer abmelden </p> <p>(auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 49.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/installation_checkliste_release50.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>1.a Releasewechsel 49 </p> <p>Offene Punkte aus dem Releasewechsel 49 m\u00fcssen zun\u00e4chst erfolgreich durchgef\u00fchrt werden.</p> <p></p> <p>1.b Releasewechsel 50 </p> <p>Danach kann der Releasewechsel f\u00fcr Release 50 druchgef\u00fchrt werden.</p> <p></p> <p>Durch Markieren des entsprechenden Punktes in der linken Tabelle werden die Punkte des Releasewechsels wie gewohnt in der rechten Tabelle dargestellt.</p> <ul> <li> <p>Historisch bebuchte kreditorische Bankverbindungen wieder aktiv Mit diesem Punkt wird gepr\u00fcft ob es bebuchte kreditorische Bankverbindungen gibt. Wenn ja werden diese wieder aktiv gekennzeichnet, da eine bebuchte kreditorische Bankverbindung nicht ver\u00e4ndertoder gel\u00f6scht werden darf.</p> </li> <li> <p>Erweiterung des OP-Schl\u00fcssels um das Steuerkennzeichen Der Releasewechselpunkt pr\u00fcft ob es innerhalb eines OP\u2019s unterschiedliche Steuerkennzeichen gibt. Wenn ja werden diese gleich gesetzt.</p> </li> <li> <p>\u00dcberpr\u00fcfung des Kennzeichens bebuchbar Sachkonten, die im Jahr 2018 nicht bebuchbar sind, wurden teilweise bei der Planer\u00f6ffnung 2019 wieder als bebuchbar gekennzeichnet. Mit dem Releasewechselpunkt \"\u00dcberpr\u00fcfung des Kennzeichen Bebuchbar\" erfolgt eine Pr\u00fcfung auf Sachkonten, die im Jahr 2018 das Kennzeichen \"nicht bebuchbar\" haben und durch die Er\u00f6ffnung des neuen Planjahres 2019 wieder bebuchbar sind. Das Ergebnis wird im Protokoll mit ausgewiesen und sollte an die zust\u00e4ndigen Mitarbeiter der K\u00e4mmerei weitergeleitet werden. Bei Bedarf ist im Men\u00fc 124 \"Sachkontenverwaltung\u201c das Kennzeichen \"bebuchbar\" f\u00fcr die entsprechenden Konten wieder zu entfernen. Ist die Anzahl der Konten sehr hoch, k\u00f6nnen Sie sich gern an die Fachberatung wenden.</p> </li> <li> <p>Entfernung der Felder ROWID (nur SQL-Kunden) F\u00fcr SQL-Kunden sind bei der Durchf\u00fchrung des Releasewechsels f\u00fcr das Release 50 folgende Punkte zu beachten:</p> </li> </ul> <p></p> <p>Die Releasewechselpunkte, welche die ROWID\u2019s betreffen, m\u00fcssen nicht direkt nach dem Update durchgef\u00fchrt werden und k\u00f6nnen sp\u00e4ter nachgeholt werden. Gegebenenfalls ist es sinnvoll, die Releasewechselpunkte einzeln durchzuf\u00fchren, um die Arbeiten im IFR nicht zu lange am St\u00fcck zu blockieren.</p> <ul> <li> <p>Vergabe von notwendigen Berechtigungen f\u00fcr das DBMS_LOCK_Package (nur f\u00fcr ORACLE Kunden) Der Releasewechsel kann nur mit dem ORACLE-SYS-Nutzer durchgef\u00fchrt werden. Bitte diese Anmeldedaten beim Releasewechsel bereithalten. ORACLE-Anwender m\u00fcssen den Datenbanknutzer (z.B. sasadm) \u00fcber den sys-Nutzer f\u00fcr das Package DBMS_LOCK ein Ausf\u00fchrungsrecht erteilen. GRANT execute ON DBMS_LOCK TO sasadm</p> </li> <li> <p>Test auf fehlende Gwst-Objekt Mit diesem Releasewechselpunkt wird gepr\u00fcft ob es in der Veranlagung gel\u00f6schte Gewerbesteuerobjekte gibt. Nachdem der Punkt den Status erfolgreich hat muss zwingend das Protokoll auf eventuell gel\u00f6schte Gewerbesteuerobjekte gepr\u00fcft werden. Werden Gewerbesteuerobjekte im Releasewechselprotokoll ausgewiesen muss wie in Punkt 3.9 Veranlagung in der Releasebeschreibung verfahren werden.</p> </li> <li>IFR-Doktypen anpassen Mit diesem Releasewechselpunkt werden bereits abgelegte Rechnungen aus dem DMS wieder korrekt angezeigt.</li> </ul> <p>2. Aktualisierung des Schattenmandanten </p> <p>Mit Release 50 wird ein neuer Schattenmandant ausgeliefert, um die notwendigen gesetzlichen \u00c4nderungen (Muster, Konten, Produkte und Zahlwege) abzubilden. Hierf\u00fcr ist in der Systemverwaltung Men\u00fc s31 \u2013 Datenbankaktualisierung oder im IFR im Men\u00fc 124 \u2013 Sachkontenverwaltung der Schattenmandant zu aktualisieren. Folgende Punkte sind dabei zwingend auszuf\u00fchren:</p> <p>\u2022Hierarchie laden \u2022Listen laden \u2022Sachkonten laden</p> <p></p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#letzte-programmanderungen","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#auslieferung-zum-15022019","title":"Auslieferung zum 15.02.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#stammdaten","title":"Stammdaten","text":"<p>Personenkontenverwaltung - Men\u00fc 12a3 </p> <p>Der Parameter \"Name aufbereiten\" kann wieder aktiv und inaktiv gesetzt werden und bleibt so erhalten.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#auftrag-faktura","title":"Auftrag / Faktura","text":"<p>Ausgangsrechnungsjournal / Stammdaten - Men\u00fc 54 / 55 </p> <p>In den Mengeneinheiten wird auch eine \"leere\" Zeile \u00a0als Auswahl angezeigt. Die Combobox Mengeneinheit wurde unter dem Feld \"Skonto\" in der Rechnungserfassung eingef\u00fcgt. Hier sind sowohl eine \"leere\" Zeile als auch alle bisher erfassten Mengeneinheiten ausw\u00e4hlbar. Die Auswahl 'Vorlagenoptionen' wirkt auch, wenn nur ein Report in der Druckdialogmaske zur Auswahl steht.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#auswertungen","title":"AuswertungEN","text":"<p>Dauerfristverl\u00e4ngerung - Men\u00fc 672 </p> <p>Die Dauerfristverl\u00e4ngerung kann elektronisch versendet werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#veranlagung","title":"Veranlagung","text":"<p>Einzelveranlagung - Men\u00fc 81 </p> <p>Der nicht korrekte Verweis 'Keine Daten im Auswahlbereich' wurde unterbunden. Damit sind die Bescheide an Tag der Erstellung wieder im Men\u00fc 81 druckbar.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#auslieferung-zum-21012019","title":"Auslieferung zum 21.01.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#allgemein","title":"Allgemein","text":"<p>WICHTIG - s341 Parameter Aus aktuellem Anlassen empfehlen wir Ihnen in der Systemverwaltung zu pr\u00fcfen ob die OnlineUpdate Benachrichtigung korrekt konfiguriert ist. Unter Men\u00fcpunkt \u00a0s341 - Parameter k\u00f6nnen diese Konfigurationen nach gepr\u00fcft werden.</p> <p></p> <p>Dabei muss der Abschnitt \"eMail Benachrichtigung\" komplett gef\u00fcllt sein. Sollte dies nicht der Fall sein melden sie sich bitte bei der Fachberatung.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#stammdaten_1","title":"Stammdaten","text":"<p>12a3 - Personenkontenverwaltung </p> <p>Es k\u00f6nnen wieder mehrere neue Personenkonten hintereinander angelegt werden ohne das die vorher angelegte Person \u00fcberschrieben wird.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#buchungen","title":"Buchungen","text":"<p>311 - Einzelbuchung </p> <p>Kunden mit Windows 7 und gro\u00dfen Datenmengen k\u00f6nnen die Einzelbuchungsmaske wieder korrekt bedienen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#auswertung","title":"Auswertung","text":"<p>613 - Quartalsstatistik </p> <p>In der viertelj\u00e4hrlichen Kassenstatistik werden die Kreditkonten wieder korrekt dargestellt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#anlagenbuchhaltung","title":"Anlagenbuchhaltung","text":"<p>Anlagenbuchhaltung </p> <p>Es wurde ein Fehler behoben welcher nach Vollabgang/ Vollumbuchung von Anlagegut/ Zuschuss zu einem negativen Restbuchwert f\u00fchrte. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#auslieferung-zum-11012019","title":"Auslieferung zum 11.01.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#veranlagung_1","title":"Veranlagung","text":"<p>81 - Einzelveranlagung </p> <p>Nachtr\u00e4gliche \u00c4nderungen f\u00fcr Vorjahre bilden bei \"monatlichen Sollstellungen\" eine korrekte Rate im neuen Jahr.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#releasewechsel","title":"Releasewechsel","text":"<p>Releasewechselpunkt - \"IFR-Doktypen anpassen\" </p> <p>Mit diesem Releasewechselpunkt werden bereits abgelegte Rechnungen aus dem DMS wieder korrekt angezeigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#auslieferung-zum-04012019","title":"Auslieferung zum 04.01.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#dms-eingangsrechnung","title":"DMS / Eingangsrechnung","text":"<p>\u00dcber Schalter F50 kann jetzt gesteuert werden, ob vor der DMS-Abfrage das Budget-Abfragefeld angepasst werden kann. Die \u00c4nderung ist aufgrund einer Limitation des DMS CC von LCS notwendig, da es nur die ersten 100 Dokumente liefert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#eingangrechnung","title":"Eingangrechnung","text":"<p>Es konnte zu einem Fehler kommen, wenn ohne Auswahl eines Personenkontos eine Kundennummer eingetragen wurde.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#auslieferung-zum-21122018","title":"Auslieferung zum 21.12.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#haushalt","title":"Haushalt","text":"<p>Instabilit\u00e4ten bei der Budgetumbuchung beseitigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#dms-eingangsrechnung_1","title":"DMS / Eingangsrechnung","text":"<p>Im Abfragedialog Eingangsrechnung wurde bei \u00c4nderung der Tabellensortierung nicht das richtige Dokument an die Bearbeitung \u00fcbergeben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#systemverwaltung","title":"Systemverwaltung","text":"<p>Vorlagenverwaltung: Es k\u00f6nnen wieder komplett neue Vorlagen eingepflegt werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#auslieferung-zum-14122018","title":"Auslieferung zum 14.12.2018","text":""},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#veranlagung_2","title":"Veranlagung","text":"<p>Unter speziellen Umst\u00e4nden konnte es zu einer fehlerhaften Textbausteindarstellung kommen. Es wurde eine Zeichenkette \u201a\\par\u2018 mit ausgewiesen.</p> <p>Gewerbesteuer, Einzelveranlagung, Eingabefelder f\u00fcr die Vermerke waren ggf. nicht sichtbar/verrutscht.</p> <p>Fehlende Zusteller/Adressen bei der Bescheiderstellung, siehe Releasewechsel</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderung_14.12.2018.html#releasewechsel_1","title":"Releasewechsel","text":"<p>Im Releasewechsel wurde der Punkt \u201e\"Umspeichern Adressinformationen\u201c aus R49 erneut mit aufnommen, da es in Ausnahmef\u00e4llen aufgrund bestimmter Datenkonstellationen nicht alle Adressen korrekt \u00fcbernommen hatte. Dies f\u00fchrt in der Regel dazu, dass im Bescheiddruck Zustelladressen unvollst\u00e4ndig dargestellt werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderungen_release_50.html","title":"Programm\u00e4nderungen Release 4.1.0050 - Stand 09.12.18","text":""},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderungen_release_50.html#programmanderungen-release-410050","title":"Programm\u00e4nderungen Release 4.1.0050","text":""},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderungen_release_50.html#allgemein","title":"Allgemein","text":"<p>Sonstiges </p> <p>011 \u2013 Aufgabenverwaltung </p> <p>Die \u00c4nderungsanzeige kann ab Release 50 auch von Rechenzentrumskunden genutzt werden.</p> <p>Aus der Aufgabenverwaltung werden Nachrichten wieder korrekt versendet.</p> <p>In der Systemverwaltung werden Termine mit dem Status \"erledigt\" und \"gel\u00f6scht\" mit neuer Anmeldung am IFR nicht mehr im Men\u00fcbaum angezeigt</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderungen_release_50.html#stammdaten","title":"Stammdaten","text":"<p>11 \u2013 Mandant </p> <p>Die Mandantenschalter wurden neu angeordnet. Damit wird eine leichtere Erkennbarkeit der f\u00fcr den jeweiligen Bereich relevanten Einstellungen erreicht.</p> <p>Neuer Schalter F46 zur Festlegung einer generellen Bekanntgabefrist f\u00fcr Bescheide / Rechnungen, die nur ins Ausland zugestellt werden. Standard ist 30 Tage. </p> <p>Neuer Schalter A60 zur Festlegung ob der Buchungstext 1+2, beim Hinzuf\u00fcgen neuer Positionen \u00fcber den \u201eER+\u201c - Button zu einem neuen Anlagegut/ Zuschuss, in die Bezeichnung 1+2 \u00fcbernommen werden soll. Zus\u00e4tzlich werden in den Reiter \u201eZusatztext\u201c folgende Angaben \u00fcbernommen: Buchungstext 1+2 | Belegnummer | Buchungsdatum | F\u00e4lligkeitsdatum | Freitext. M\u00f6gliche Schalterstellungen \u201eJ\u201c = JA | \u201eN\u201c = Nein (Standard) | \u201eI\u201c = Interaktiv (Nachfrage bei jeder Positions\u00fcbernahme) </p> <p>Neuer Schalter F10 zur Festlegung der Verteilung von steuerlichen Rundungsdifferenzen im ARJ (Details unter Punkt 3.6).</p> <p>Der Schalter V10 aktiviert die automatische Bekanngabefrist. Beim Berechnen in der Veranlagung erfolgt daher immer die Pr\u00fcfung, ob ein Original-Bescheidempf\u00e4nger im Inland existiert. Wenn einer existiert, dann wird die Bekanntgabefrist f\u00fcr das Inland (f\u00fcr Veranlagungen lt. Men\u00fc 152) gesetzt. \u00a0 Sofern f\u00fcr alle Original-Bescheidempf\u00e4nger ein Auslandskennzeichen gesetzt ist, wird die Auslands-Bekanntgabefrist genutzt.</p> <p>Der Zeitpunkt der Vereinnahmung der Umsatzsteuer bei vereinnahmten Entgelten ist gesetzlich geregelt. Hierbei spielt die Schaltereinstellung F24 eine tragende Rolle. Steht diese auf \"Ja\", ist das Wertstellungsdatum des Schwebepostens ausschlaggebend f\u00fcr die Steuer- und Belegperiode. Steht der Schalter auf \"Nein\" entscheidet das Belegdatum beim Verbuchen des Lastschriftlaufes im Men\u00fc 6612 \u00fcber die Steuerperiode. Die USt-ID ist ab sofort kein Pflichtfeld mehr. Sie kann in den USt-Stammdaten unausgef\u00fcllt bleiben, wenn die Verwaltung keine ID vom Finanzamt zugeordnet bekommen hat.</p> <p>Kommunen, die im Jahr weniger als 1000 \u20ac Umsatzsteuerzahllast haben, k\u00f6nnen Ihre Umsatzsteuererkl\u00e4rung auch nur j\u00e4hrlich durchf\u00fchren. Die Option zur Auswahl des \"j\u00e4hrlichen\" Voranmeldezeitraums wurde erg\u00e4nzt.</p> <p>Mit der Abgleichsfunktion in der Registerkarte Umsatzsteuer k\u00f6nnen die Zeilen f\u00fcr die UST-VA 2019, sowie f\u00fcr die Umsatzsteuererkl\u00e4rung des Jahres 2018 eingelesen werden. Dabei gilt ab Release 50 folgendes Farbschema: Gr\u00fcn: neue Kennzeichen im Formular  Rot: Kennzeichen die es im alten, nicht aber im neuen Formular gibt (werden nach dem \u00dcbernehmen entfernt) Gelb: ge\u00e4nderte Beschreibung im Kennzeichen</p> <p>F\u00fcr einen MESO-Abgleich ist Benutzername und Passwort aus dem MESO n\u00f6tig. Die Nutzer haben nun die M\u00f6glichkeit dies am Mandantenschalter K21 zu hinterlegen oder aber der Benutzer gibt vor jedem Abgleich Benutzername und Passwort ein. (Bundesdatenschutzgesetz / DSGVO)</p> <p>123 \u2013 Kontierung \u2013 Listenpositionsverwaltung </p> <p>In den Listen Finanzhaushalt, Finanzrechnung, Teilfinanzhaushalt A und B k\u00f6nnen nun laut Muster die entsprechenden Spalten unterdr\u00fcckt werden. Der neue Parameter wird mit dem Schattenmandant aktualisiert. Es m\u00fcssen die 4 Listen nochmal aus dem Schattenmandant kopiert werden um die \u00c4nderungen nicht manuell einpflegen zu m\u00fcssen.</p> <p>124 \u2013 Kontierung \u2013 \u00a0Sachkontenverwaltung </p> <p>Mit der Steuerart BELIEBIG (Kennzeichen 1) ist es in den Buchungsmasken nun m\u00f6glich, sowohl ein beliebiges Steuerkennzeichen auszuw\u00e4hlen, als auch ohne Steuer zu arbeiten, durch die Auswahl \"ohne Steuer\". Somit ist es nicht mehr notwendig, das Konto f\u00fcr denselben Sachverhalt zu vervielfachen, um alle Sachverhalte rund um die USt abbilden zu k\u00f6nnen. Es ist m\u00f6glich nicht steuerbare, steuerfreie, sowie steuerpflichtige Vorg\u00e4nge mit einem Ertrags-/ Aufwandskonto abbilden zu k\u00f6nnen.</p> <p>125 \u2013 Kontierung \u2013 Ma\u00dfnahmen </p> <p>Beim Erfassen von neuen Ma\u00dfnahmen im Men\u00fc 125 wurde im Erfassungsdialog ein Button \"Neu\" integriert, sodass man mehrere Ma\u00dfnahmen hintereinander anlegen kann ohne den Dialog verlassen zu m\u00fcssen. Somit ist auch die Verwendung der IFR-Zwischenablage (F6-Taste oder Shift+F6) m\u00f6glich.</p> <p>1272 \u2013 Kontierung \u2013 Zusatzstammdaten \u2013 Zahlwege </p> <p>Im Zuge des Releasewechsels auf Release 50 mussten die Zahlwege alle auf \"abgeschlossen\" gesetzt werden. Somit ist die m\u00f6gliche Einstellung, die zuvor evtl. getroffen wurde, dass der Zahlweg als NICHT abgeschlossen gekennzeichnet werden soll, gel\u00f6scht. Diese Einstellung m\u00fcsste somit im Men\u00fc 1272 nochmals getroffen werden.</p> <p>1275 \u2013 Kontierung \u2013 Zusatzstammdaten \u2013 Einnahmearten </p> <p>Der OP-Abgleich ist nicht mehr passwortgesch\u00fctzt und kann nun vom Kunden selbst vorgenommen werden. Mit Auswahl der Einnahmeart und Bet\u00e4tigung \"OP-Abgleich\" k\u00f6nnen die offenen Posten, deren Einnnahmeart ge\u00e4ndert wurde, angepasst werden.</p> <p>12a3 \u2013 Kontierung \u2013 Adressen \u2013 Personenkontenverwaltung </p> <p>Adressverwaltung wurde in Personenkontenverwaltung umbenannt. </p> <p>In der Personenkontenverwaltung gibt es eine neue Kennzeichnung f\u00fcr die Gruppierung mehrerer Personenkonten. In einem neuen, zus\u00e4tzlichen Feld ist die Angabe einer max. 20-stelligen, alphanumerischen Eingabe einer \u00a0\"B\u00fcrgerkontonummer\" m\u00f6glich. Nach manueller Zusammenfassung der betreffenden PK's zu einem B\u00fcrgerkonto k\u00f6nnen so Ausk\u00fcnfte und Auswertungen \u00fcber z.B. eine nat\u00fcrliche Person erstellt werden.</p> <p>Da es bei angelegten Mahnsperren mit der Kombination 0000 und * beim OP-Bezug zu Problemen bei der Mahnung hinsichtlich der Selektion der OP's f\u00fcr die Mahnung kam, gab es hier eine \u00c4nderung. Zuk\u00fcnftig k\u00f6nnen keine Mahnsperren mehr mit der Kombination 0000 und * beim OP-Bezug gleichzeitig angelegt werden. Bei neu eingegebenen Mahnsperren mit 0000 wird das 0000 durch * ersetzt. F\u00fcr alle Altkombinationen mit 0000 und * in der Datenbank wird bei der Vorschlagserstellung f\u00fcr die Mahnung die Mahnsperre mit dem * bevorzugt.</p> <p>Es stehen im Kommentarfeld bei Mahnsperre jetzt 254 Zeichen zur Verf\u00fcgung.</p> <p>Es besteht nun die M\u00f6glichkeit bei Zusatzadressen die Einnahmeart \u00fcber einen Button \"E\" auszuw\u00e4hlen, Bei der Bankverbindung kann dies ebenso \u00fcber den Button \"Auswahl Einnahmeart...\" erfolgen.</p> <p>Bei bebuchten kreditorischen Bankverbindungen kann nun wieder die BIC ge\u00e4ndert/korrigiert werden.</p> <p>Auf Bescheiden k\u00f6nnen auch Personen, f\u00fcr die keine Anschrift erfasst werden kann und kein Zusteller oder \u00e4hnliches vorhanden ist, als vom Bescheid Betroffene ausgewiesen werden. Es ist dazu unbedingt eine Funktion (z.B. 7* - Mitglied einer Erbengemeinschaft -- nur Ausweis auf dem Bescheid), f\u00fcr die kein eigener Bescheid erstellt wird zu w\u00e4hlen.</p> <p>Bei der Erfassung eines neuen Personenkontos ist das Feld \"Stra\u00dfe\" kein Pflichtfeld mehr, dies gilt jedoch nur bei Neuanlage eines PK\u2019s.</p> <p>Die Schnittstelle \u201eS_KSV_I_D_IBAN\u201c kann nun wieder korrekt verarbeitet werden.</p> <p>1y1 \u2013 Ausgabesystem \u2013 Textbaustein </p> <p>Um eine weitere Flexibilisierung im Layout der Reports zu erreichen, gibt es f\u00fcr die folgenden Reports die M\u00f6glichkeit \u00fcber den Textbaustein 9, die Informationen zu \u00d6ffnungszeiten, Bankverbindungen usw. in der Fu\u00dfzeile einzurichten. Allerdings ist dann kein Druck mehr mit Zahlschein m\u00f6glich. Die M\u00f6glichkeit besteht bei Mahnung, Stundung, Fakturierung, Ausgangsrechnung und Auszifferungserkl\u00e4rung. Dabei wurde der Zahlschein im \"Mahnbescheid breit\" entfernt.</p> <p>1y2 \u2013 \u00a0Ausgabesystem \u2013 Vorlagen </p> <p>Durch die beiden neu erg\u00e4nzten Suchfelder \"Bezeichnung\" und \"Vorlage\" ist jetzt eine noch genauere Suche nach bestimmten Vorlagen m\u00f6glich.</p> <p>Mit Hilfe eines Releasewechselpunktes wird in der Vorlagenverwaltung f\u00fcr das Muster 21 der Parameter \"Dok.-mappe\" aktiv gesetzt.</p> <p>1w \u2013 Import </p> <p>Beim Einlesen von Mandaten \u00fcber die Schnittstelle, gab es einen Fehler, wenn das betreffende Personenkonto nicht vorhanden ist. Die Schnittstelle ist dahingehend \u00fcberarbeitet worden, dass er alle Mandate einliest wo er ein Personenkonto findet und f\u00fcr alle anderen Mandate die nicht zugeordnet werden k\u00f6nnen eine Fehlermeldung bringt. Nach Anlegen der fehlenden Personenkonten kann die Schnittstelle erneut ausgef\u00fchrt werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderungen_release_50.html#planung","title":"Planung","text":"<p>21 \u2013 Neues Planjahr anlegen </p> <p>Sachkonten, die in 2018 nicht bebuchbar sind, wurden teilweise bei der Planer\u00f6ffnung 2019 wieder als bebuchbar gekennzeichnet. Mit dem Releasewechselpunkt \"\u00dcberpr\u00fcfung des Kennzeichen Bebuchbar\" erfolgt eine Pr\u00fcfung auf Sachkonten, die im Jahr 2018 das Kennzeichen \"nicht bebuchbar\" haben und durch die Er\u00f6ffnung des neuen Planjahres in 2019 wieder bebuchbar sind. Das Ergebnis wird im Protokoll mit ausgewiesen und sollte an die zust\u00e4ndigen Mitarbeiter der K\u00e4mmerei weitergeleitet werden. Bei Bedarf ist im Men\u00fc 124 \"Sachkontenverwaltung\" \u00a0das Kennzeichen \"bebuchbar\" f\u00fcr die entsprechenden Konten wieder zu entfernen. Ist die Anzahl der Konten sehr hoch, k\u00f6nnen Sie sich gern an die Fachberatung wenden.</p> <p>23 \u2013 Budgetzuordnung </p> <p>F\u00fcr KU-Konten (Umlagekostenart-Konten) kann nun auch im Men\u00fc 23 eine Budgetzuordnung erfolgen.</p> <p>241 \u2013 Teilplanentwurf \u2013 Budget\u00fcbersicht \u2013 Planwerte </p> <p>In der Budget\u00fcbersicht ist es nun wieder m\u00f6glich, Budgetvorgaben mit dem bereits geplanten Werten zu vergleichen.</p> <p>242 \u2013 Teilplanentwurf \u2013 Ergebnisplan </p> <p>In den Men\u00fcpunkten 242 | 243 | 244 | 245 wurde ein Fehler behoben, welcher das Speichern der Standardansicht verhindert hat, nachdem der jeweilige Men\u00fcpunkt geschlossen oder die Eingrenzung auf ein Produkt oder Sachkonto ge\u00e4ndert wurde. Nach Einspielen des Updates muss einmalig die Standardansicht mit einem Rechtsklick im Kontextmen\u00fc wiederhergestellt werden.</p> <p>Bei eingeschr\u00e4nktem Budget kann in der Planung nun wieder korrekt nach Produkten und Sachkonten gefiltert werden.</p> <p>291 \u2013 \u00a0Auswertungen \u2013 Planbuchungsjournal </p> <p>Das Planbuchungsjournal kann wieder genutzt werden. Es wurde die Spalte \u201eNutzer\u201c erg\u00e4nzt. Daran l\u00e4sst sich der Nutzer erkennen welcher die Plan-/ Budgetbuchung durchgef\u00fchrt hat. Bei Auswahl (sowohl h\u00e4ndisch als auch \u00fcber \"abtauchen\") des Produktes wird wieder die damit verkn\u00fcpfte Ma\u00dfnahme im Query-Feld eingeblendet. Ohne die Auswahl eines Produkts werden zudem im Feld Ma\u00dfnahme alle unter dem aktuellen Mandanten erfassten Ma\u00dfnahmen eingeblendet.</p> <p>29a \u2013 Auswertungen \u2013 Vorausz. f\u00e4llige Ausz. Aus VE </p> <p>Beim Druck der Liste \"\u00dcbersicht der aus VE f\u00e4llig werdenden Auszahlungen\" kam es durch eine Datenkonstellation zu dem Verhalten, dass er einzelne HH-Jahre in der Liste ausgelassen hat. Hier erfolgte eine \u00c4nderung der Datenaufbereitung f\u00fcr die Liste.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderungen_release_50.html#buchung","title":"Buchung","text":"<p>311 \u2013 Buchen \u2013 Einzelbuchung </p> <p>Ebenso wie beim Buchungsschl\u00fcssel 511 kann nun auch beim Buchungsschl\u00fcssel 411 unabh\u00e4ngig von der Grundeinstellung \"Soll-Versteuerung\" bei der Buchung das Kennzeichen Ist-Versteuerung gesetzt werden, so dass diese Buchung dann als Ist-Versteuerung gef\u00fchrt wird. Damit k\u00f6nnen Sonderf\u00e4lle im Bereich Umsatzsteuer vom Anwender entsprechend ber\u00fccksichtigt werden.</p> <p>Es wird nun auf der Anordnung (sowohl auf der einzelnen AO, als auch auf dem AO-Summenblatt), bei Buchung mit Steuerkennzeichen vermerkt, ob es sich bei dem erstellten OP, um den Fall der Soll- oder Istversteuerung handelt. Ob die Vorsteuer einer kreditorischen Sollstellung in den Zeitraum der Zahlungsbuchung verlagert wird, entscheidet nun mehr auch bei Ratenbuchungen allein die Checkbox \"Istversteuerung\". Bisher hat die Aktivierung von \"Periode lt. F\u00e4lligkeit\" bei Ratenbuchung eine Verschiebung der Vorsteuer in die Zahlungsperiode verursacht. Soll dieser Zustand k\u00fcnftig bei Ratenbuchungen weiterhin erfolgen, muss zus\u00e4tzlich die Checkbox \"Istversteuerung\" aktiviert werden.</p> <p>Bei Umbuchungen mit den Buchsschl\u00fcsseln 24; 20 und 26* wird keine Steuer ber\u00fccksichtigt. Es erfolgt eine Bruttoumbuchung. Steuerpflichtige Korrekturen sind ausschlie\u00dflich \u00fcber personenbezogene Buchungen vorzunehmen.</p> <p>Beim Abweisen einer AO erscheint das Hinweisfeld \"Grundangabe\" bei Einzelbuchung analog zum Eingangsrechnungsjournal eingeblendet.</p> <p>Bei einer Aufteilungsbuchung von einem Posten ohne Steuer auf eine steuerpflichtige Buchungsstelle werden die Felder Steuerkennzeichen und Steuer wieder korrekt gef\u00fcllt.</p> <p>Bei der Verbuchung einer Rechnung mittels Aufteilungsbuchung und unterschiedlicher Leistungsperiode der Rechnungspositionen kam es, wenn nicht gen\u00fcgend Budgetmittel auf einer Buchungsstelle vorhanden sind, zu einem Fehler in der Budgetumbuchung. Hierzu ist eine Korrektur vorgenommen worden, dass jetzt die Mittel f\u00fcr die Budgetumbuchung aus dem richtigen Jahr genommen und auch im richtigen Jahr verbucht werden.</p> <p>In der Einzelbuchungsmaske sind k\u00fcnftig nach Eingabe der Buchungsstelle und Datenangaben nur noch die Ma\u00dfnahmen ausw\u00e4hlbar, die den Einschr\u00e4nkungen nach Produkt und Datum entsprechen. Passt eine Ma\u00dfnahme bspw. nach Eingabe von Beleg- und Wertstellungsdatum nicht in den G\u00fcltigkeitszeitraum, die in den Stammdaten der Ma\u00dfnahmen gepflegt wird, so wir diese Ma\u00dfnahme nicht mehr in der Auswahl der Abtauchfunktion angegeben. Auch in der Dauerbuchung und Auftragsverwaltung ist diese Neuerung umgesetzt. Im ERJ ist diese Funktion bereits enthalten.</p> <p>Es kann nun wieder mit der Mehrfachauswahl auf mehrere OP's gebucht werden. Die Buchungsstelle wird ausgegraut dargestellt und der Buchungsbetrag wird vorgeblendet und kann bei Bedarf \u00fcberschrieben werden.</p> <p>Mit der OP-Schl\u00fcsselerweiterung durch das Steuerkennzeichen k\u00f6nnen nun auch Teilzahlungen auf eine Rechnung gemacht haben, die mehrere Steuerkennzeichen enthalten, da somit pro Steuerkennzeichen ein eigener OP gebildet wird.</p> <p>312 \u2013 Buchen \u2013 Dauerbuchungen </p> <p>Bei der Erstellung von Dauerbuchungen mit manuellen Belegnummern, gab es ein Problem mit der Fortschreibung der Belegnummern in den einzelnen Buchungsperioden. Hierzu erfolgte eine \u00c4nderung, so dass jetzt die Belegnummern korrekt fortgeschrieben werden.</p> <p>Das Dauerbuchungsmodul wurde auf Nebenbuchwerk umgestellt. Damit werden Dauerbuchungen, deren Anordnungen in der FiBu abgewiesen werden, auch in der Dauerbuchung zur\u00fcckgesetzt. Hinweis: Wenn Anordnungen zu Dauerbuchungsvorg\u00e4ngen abgewiesen werden, achten Sie bitte darauf, dass alle zusammenh\u00e4ngenden Anordnungen abgewiesen werden. Beispiel: Sie \u00fcbergeben auf einen Schlag Periode 1 - 12 und stellen beim AO-Druck (Formular) einen Fehler fest, dann weisen Sie dann bitte alle 12 Anordnungen ab!</p> <p>32 \u2013 \u00a0Tagesabschluss </p> <p>Im Kopf der Tagesabschluss\u00fcbersicht wurde das verkehrte Zeitformat, 12h statt 24h angezeigt. Ist korrigiert.</p> <p>Bei einer Tagesabschluss\u00fcbersicht mit vielen Zahlwegen und/oder vielen Jahren bei der \u00dcbersicht der Istfortschreibung konnte es bei einigen Konstellationen dazu f\u00fchren, dass die Unterschriftenzeile auf die neue Seite kommt und dort verschoben dargestellt wird. Um das besser verhindern zu k\u00f6nnen ist der Report in diesem Bereich angepasst worden.</p> <p>Im Men\u00fc (LUSI) wurde ein Fehler behoben, welcher die Erstellung des Reports f\u00fcr Ein- und Ausgangsschecks verhinderte.</p> <p>Wird mit Buchungsschl\u00fcssel 734 (kred. Zahlungsausgang auf Verr.-Scheck) \u00a0mit Mehrfachauswahl gebucht, ist der Freitext wieder korrekt gef\u00fcllt und somit kann die Offene Schwebepostenliste wieder korrekt gedruckt werden.</p> <p>33 \u2013 Buchungsstapel </p> <p>Bei der Selektion auf eine AO-Nummer, die zu einer Aufteilungsbuchung geh\u00f6rt, werden jetzt wieder alle zugeh\u00f6rigen Buchungen der Aufteilungsbuchung im Buchungsstapel angezeigt.</p> <p>Ein Filterfeld f\u00fcr Buchungsstapelnummer wurde erg\u00e4nzt.</p> <p>351 \u2013 Schnittstellen \u2013 Einrichten \u2013 \u00a0Textschnittstelle Archikart </p> <p>Nach dem Wegfall der Unterst\u00fctzung von Informix-DB kam es durch eine fehlerhafte Passage im Schnittstellenmakro zu einem Programmabsturz bei der Installation der Schnittstelle. Nach \u00dcberarbeitung des Makros ist jetzt die Installation wieder problemlos m\u00f6glich.</p> <p>352 \u2013 Schnittstellen \u2013 \u00a0Eingang \u2013 XFinanz </p> <p>Bei der Schnittstellen-Verarbeitung der XFinanz-Bankdateien wird wieder der korrekte Zahlweg gesetzt.</p> <p>3522 \u2013 Schnittstelle \u00a0\u2013 \u00a0Eingang \u00a0\u2013 \u00a0Verarbeiten </p> <p>Die Verarbeitung einer Schnittstelle kann einem konkreten Nutzer zugewiesen werden. Wenn der Nutzer das Recht 351 (Einrichten einer Schnittstelle) \u00a0nicht hat, ist eine \u00c4nderung der Parameter \u00a0beim Verarbeiten nicht m\u00f6glich.</p> <p>36 \u2013 Anordnungen </p> <p>Das Problem, dass bei Abweisung einer AO die Angabe des Grundes im Eingabefenster nicht gespeichert wurde, ist behoben. Ebenso erfolgte Fehlerbehebung, dass das Eingabefenster f\u00fcr die Erfassung des Abweisungsgrundes gar nicht eingeblendet wurde. </p> <p>3a2 \u2013 Kontoauszug \u2013 Abgleich </p> <p>Um eine bessere \u00dcbersicht der zugeordneten OP's zu einer Kontoauszugsposition zu erm\u00f6glichen, ist es jetzt m\u00f6glich den Bereich durch ziehen mit der Maus zu vergr\u00f6\u00dfern oder zu verkleinern.</p> <p>391 \u2013 Auskunft \u2013 Personenkontenauskunft </p> <p>Im Report FR_60101_KONTOAUSZUG_B.MRT wird jetzt das Druckdatum und die Seitenanzahl (Blatt 1 von ...) ausgewiesen sowie der RTB_4 Briefkopf wurde an die breite Reportvorgabe angepasst.</p> <p>Die Spalte \"IBAN\" wurde integriert. Diese zeigt bei kreditorischen OP\u2019s die Bankverbindung an, mit welcher der OP verkn\u00fcpft bzw. an welche Bankverbindung die Zahlung get\u00e4tigt wurde. Bei debitorischen OP\u2019s wird die Spalte IBAN nur bei automatischen Zahlungsl\u00e4ufen ausgewiesen. \u00c4nderungen der Bankverbindung \u00fcber das Men\u00fc 4a - OP-Anpassung werden in der Spalte \"IBAN\" historisch mit aufgef\u00fchrt.</p> <p>Es ist jetzt m\u00f6glich, beliebig viele Personenkonten gemeinsam aufzurufen. Dabei ist es unerheblich, ob es sich dabei um mehrere debitorische, mehrere kreditorische oder debitorische und kreditorische Personenkonten handelt. Die Auswahl der betreffenden Personenkonten erfolgt dazu entweder durch Eintrag der PK-Nummern semikolon-getrennt in das Auswahlfeld oder durch den Aufruf der PK-Verwaltung \u00fcber den Button am Auswahlfeld. Dort k\u00f6nnen die gew\u00fcnschten Personenkonten ausgefiltert und/oder mit Hilfe der STRG-Taste gemeinsam markiert und \u00fcber den Button \"Daten zur\u00fcckgeben\" ausgew\u00e4hlt werden. Auf diese Weise kann schnell ein Gesamt\u00fcberblick aller Buchungen oder Offenen Posten f\u00fcr zusammenh\u00e4ngende Personenkonten z. B. einer nat\u00fcrlichen Person erreicht werden. Au\u00dferdem ist es m\u00f6glich, f\u00fcr diesen ausgew\u00e4hlten Bereich auch sofort das Journal, eine OP-Liste oder ein PK-Auszug zu erstellen.</p> <p>392 \u2013 Produkt-/ Sachkontenauskunft </p> <p>Im Reiter \u201ePlanbuchungen\u201c wurde die Spalte \u201eNutzer\u201c erg\u00e4nzt. Daran l\u00e4sst sich der Nutzer erkennen welcher die Plan-/ Budgetbuchung durchgef\u00fchrt hat.</p> <p>394 \u2013 \u00a0Auskunft \u2013 Budget\u00fcbersicht </p> <p>In der Budget\u00fcbersicht Men\u00fc 394 wurde die Datenermittlung der Spalte (L) \"Mehr/Minder\" in Bezug auf \u00fcbertragene Vorjahresmittel und somit auch die Spalte (N) \"Verf\u00fcgbarer Rest gesamt\" angepasst.</p> <p>396 \u2013 Auskunft / Liquidit\u00e4tsanzeige </p> <p>Bei Kredittilgungsbuchungen kam es zu einer Fehlanzeige in den Verf\u00fcgbarkeitsdetails.</p> <p>Es bestand bei der aktuellen Darstellung der Nummerierung der Positionsnummern ein Missverst\u00e4ndnis in der Interpretation der Werte. Aktuell wurde von einigen Kunden bei den Werten f\u00fcr die Position 2 davon ausgegangen, dass es sich hier um eine Summe der darunterliegenden Positionen 2.1 bis 2.4 handelte. Um hier mehr Klarheit zu schaffen, wurde die Nummerierung der Positionen umgestellt.</p> <p>In der Liquidit\u00e4tsanzeige werden nun auch Ausgangsrechnungen betrachtet.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderungen_release_50.html#op-bearbeitung","title":"OP-Bearbeitung","text":"<p>421 \u2013 Stundung \u2013 Bearbeiten </p> <p>F\u00fcr den Report des Wiederrufes gibt es nun eine neue Vorlagen-Option (Rechtsklick auf Button \u201eDrucken\u201c) \u00a0Namens \"nur Restschuld ausgeben\". Es ist empfehlenswert die Option beim Druck immer auszuw\u00e4hlen, da sonst zum Beispiel Teilzahlungen nicht korrekt ber\u00fccksichtigt werden. Au\u00dferdem sollte die Option \"Kontoauszug unterdr\u00fccken\" ebenfalls angehakt werden.</p> <p>431 \u2013 AdV \u2013 AdV-Verwaltung </p> <p>Das Anlegen einer AdV ohne das eine Einnahmeart zur Buchungsstelle hinterlegt ist funktioniert weiterhin. Erst beim Widerruf w\u00fcrde dann eine entsprechende Hinweismeldung kommen, dass die Einnahmeart zur Buchungsstelle noch fehlt. Nach dem Anlegen der Einnahmeart kann der AdV-Widerruf dann ordnungsgem\u00e4\u00df durchgef\u00fchrt werden.</p> <p>432 \u2013 AdV \u2013 AdV-Liste </p> <p>Beim Ausweis des gesperrten AdV-Betrags auf der AdV-Liste sind nicht immer die richtigen Werte angezeigt worden. Hierzu erfolgte eine Korrektur, so dass jetzt die richtigen Werte angezeigt werden.</p> <p>441 \u2013 Wertberichtigung \u2013 Niederschlagung </p> <p>Beim Verbuchen von Wertberechtigungen f\u00fcr unbefristete Niederschlagungen und deren Anpassung, wird der Buchungssatz wieder korrekt gebildet.</p> <p>Ab Release 50 wird \u00a0bei der Niederschlagung die abgef\u00fchrte Umsatzsteuer korrigiert. Dies passiert sowohl bei befristeter Niederschlagung, als auch bei unbefristeter Niederschlagung (sollten beide nacheinander erfolgen, wird bei unbefristeter NDS nicht erneut die USt korrigiert). Es werden auch alle Korrekturen der Steuer an das USt-Modul weitergegeben. Zu beachten ist, dass bei befristeter Niederschlagung (Buchungsschl\u00fcssel 111) wie gewohnt kein Personenkonto angesprochen wird. Im USt-Modul kann somit nicht nach dem Personenkonto bei Suche der Steuerkorrektur aus befristeter Niederschlagung gefiltert werden.</p> <p>443 \u2013 Wertberichtigung \u2013 Wertberichtigungsliste </p> <p>Es wurde eine neue Auswertung erstellt, welche alle wertberichtigten OPs ausweist, die noch angepasst werden m\u00fcssen, weil sich der urspr\u00fcnglich wertberichtigte OP-Wert ver\u00e4ndert hat (z.B. durch Zahlung oder Sollabgang), aber der WB-Betrag noch nicht aktualisiert wurde. Hierf\u00fcr muss der Haken bei Option \"nur offen ungleich wertberichtigt\" gesetzt werden. </p> <p>46 \u2013 Sperren </p> <p>Im Men\u00fc zum Setzen der OP-Sperre werden jetzt auch die AdV angezeigt, die durch eine Teilsperre aufgehoben worden sind.</p> <p>48 \u2013 Vollstreckung </p> <p>Wenn bei der \u00dcbergabe der Vollstreckungsdaten vor der Mahnung bei dem OP eine Sperre gesetzt/gel\u00f6st wurde, ist der Vollstreckungsmahngrad dann von 3 auf 0 beim OP zur\u00fcckgesetzt worden. Nach der \u00c4nderung bleibt der Vollstreckungsmahngrad am OP erhalten. </p> <p>AVVISO XML-SST - Der Buchungsbetrag wird nun mit dem richtigen Vorzeichen \u00fcbergeben.</p> <p>491 \u2013 Erlass / Bearbeiten </p> <p>Das Buchen eines Erlasses funktioniert wieder. Ebenso wurde der Fehler bei der Aufhebung eines Erlasses behoben. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderungen_release_50.html#auftragfaktura","title":"Auftrag/Faktura","text":"<p>51 \u2013 Auftragsverwaltung </p> <p>Der Druck der Bestellung wurde \u00fcberarbeitet. Es wurde bspw. ein Block eingef\u00fcgt, der die Auftragsnummer enth\u00e4lt. Au\u00dferdem ist der RTB_9 nun einpflegbar. Um diese Erweiterungen nutzen zu k\u00f6nnen ist allerdings der Report \"FR_20171_BESTELLUNG_B.MRT\" mit der breiten Variante des Briefkopfes zu verwenden. Beim Stornieren von Auftr\u00e4gen mit Teilabruf, kam es zu einer nicht richtigen Anzeige der Restauftragswerte. Hierzu erfolgte eine Korrektur.</p> <p>Bei Druck eines eingegeben l\u00e4ngeren Bemerkungstextes f\u00fcr den Auftragsbegleitschein, erfolgte kein Zeilenumbruch. Dies f\u00fchrte dazu, dass die Schriftgr\u00f6\u00dfe angepasst wurde. Durch eine Korrektur wird nun der Zeilenumbruch durchgef\u00fchrt und die Schriftgr\u00f6\u00dfe beibehalten.</p> <p>52 \u2013 Eingangsrechnungsjournal </p> <p>Bei der Erfassung einer Eingangsrechnung im lfd. Jahr f\u00fcr eine Leistung des Vorjahres kann die abweichende Leistungsperiode genutzt werden. Bei der Benutzung eines Auftrages aus dem Vorjahr in dieser Konstellation, kam es zu Problemen mit den internen Plausibilit\u00e4tspr\u00fcfungen des Programms. Hierzu erfolgte eine Anpassung, so dass solche Erfassungen jetzt m\u00f6glich sind. Daf\u00fcr ist eine Mittel\u00fcbernahme des benutzten Auftrages in das Folgejahr notwendig.</p> <p>Durch die erweiterte Anzeige von weiteren Informationen zur Bankverbindung reichte der Platz f\u00fcr die Anzeige der Personenkonteninformationen nicht mehr aus. Darum erweitert sich jetzt das Informationsfeld wenn man mit der linken Maustaste daraufklickt. Auch k\u00f6nnen die Informationen jetzt aus dem Feld herauskopiert werden.</p> <p>Beim Anlegen einer Eingangsrechnung mit RAP, wurde immer ein automatisierter Text in das Bemerkungsfeld des RAP's geschrieben. Hierzu erfolgte eine \u00c4nderung dahingehend, dass jetzt der individuelle Text aus Buchungstext1 hinterlegt wird.</p> <p>Mit dem ERJ kann nun wieder ein RAP gebildet werden.</p> <p>Bei kreditorischen Buchungen wird die Bildung der Steuerperiode am Eingangsrechnungsdatum bzw. Wertstellungsdatum entschieden. Liegt die Leistungsperiode zeitlich sp\u00e4ter als das Eingangsrechnungs- bzw. Wertstellungsdatum, so ist die Leistungsperiode f\u00fcr die Steuerperiode ausschlaggebend.</p> <p>54 \u2013 Ausgangsrechnungsjournal und dazugeh\u00f6rig Men\u00fc 55 \u2013 Stammdaten </p> <p>Die Rechte der Buchungsschl\u00fcssel und Einnahmeart sowie das Budgetrecht zur Beschr\u00e4nkung wirken im ARJ Men\u00fcpunkt 54 bei der Rechnungserfassung sowie im Men\u00fcpunkt 55 bei Anlage der Tarifgruppen/ Tarife.</p> <p>Es wurde der Mandantenschalter F10 \u201eMethode der Steuerberechnung im ARJ\u201c (jahres\u00fcbergreifend) im Men\u00fc 11 erg\u00e4nzt. Die Methode \u201eHorizontal\u201c (Standard) oder \u201eVertikal\u201c definiert, wie die Umsatzsteuer berechnetet wird und m\u00f6gliche Rundungsdifferenzen verteilet werden. Die Anzeige im Men\u00fc 54 ist nicht ausw\u00e4hlbar, sondern nur informativ.</p> <p></p> <p>Funktion \u201eBasis \u201c im Kopfdatenbereich der Rechnungserfassungsmaske erg\u00e4nzt. Bei einer Rechnung die sich aus Brutto- und Nettotarifen (gemischt) zusammensetzten soll, dient diese Auswahl als Berechnungsgrundlage f\u00fcr die Umsatzsteuer und die Darstellung der Rechnung. Laut Tarif : Ist standardm\u00e4\u00dfig vorbelegt. Die Berechnung richtet sich nach der Tarifart in der ersten Rechnungsposition, d.h. ob ein Brutto- oder Nettotarif ausgew\u00e4hlt wurde. Eine gemischte Erfassung der Tarifarten ist nicht zul\u00e4ssig. Die Ausgangsrechnung wird dann entweder als Brutto oder Nettorechnung dargestellt und eine Umrechnung findet nicht statt. Brutto oder Netto : \u00a0Erm\u00f6glicht die Erfassung von Rechnungen, welche sowohl Brutto- als auch Nettotarife gemischt enthalten k\u00f6nnen. Die Ausgangsrechnung wird entweder als Brutto oder Nettorechnung dargestellt und es erfolgt eine Umrechnung des Tarifes, wenn dieser von der ausgew\u00e4hlten Basis abweicht. Durch die Umrechnung kann es zu Rundungsdifferenzen kommen.</p> <p>Im Report FR_5001_Ausgangsrechnung_B.mrt wurde die Formatierung des Umsatzsteuerbetrages korrigiert sowie weitere kleinere Optimierungen vorgenommen. </p> <p>Auf dem Report \u201eAusgangsrechnung breit\u201c wurde die Positionierung der Falzmarken korrigiert und die Vorlagenoption \u201eTarifgruppenbezeichnung unterdr\u00fccken\u201c hinzugef\u00fcgt. Die Vorlagenoption dient zur Gruppierung von nacheinander folgenden Rechnungspositionen, welche die selbe Tarifgruppe enthalten um Mehrfachnennungen zu unterdr\u00fccken.</p> <p>Im Kopf-Datenstrom f\u00fcr die Textbausteinverwaltung wurde die Spalte \"KZ_Orpr\" erg\u00e4nzt, welches z.B. zur Steuerung des Titels im RTB_8 (z.B. Rechnung oder Bescheid) verwendet werden kann. Dieses Kennzeichen leitet sich aus der ersten Rechnungsposition ab und wird mit \"O\" f\u00fcr \u00f6ffentlich-rechtlich oder \"P\" f\u00fcr privatrechtlich belegt.  Au\u00dferdem wurde das Kennzeichen \"MehrAlsEineRate\" aufgenommen. Dieses kann mit 0 = keine Raten innerhalb der Rechnung oder 1 = mehrere Raten innerhalb der Rechnung belegt sein. Damit wird es m\u00f6glich, die Textbausteine noch individueller zu steuern. Des Weiteren wurde das Kennzeichen \u201eAbbucherStati\u201c erg\u00e4nzt. Welches mit 0 = kein SEPA-Mandat liegt f\u00fcr die Rechnung vor | 1 = ein SEPA-Mandant mit gleicher Bankverbindung liegt f\u00fcr die Rechnung vor | 2 = ist eine Mischform des Status 1+2 ab mindestens 2 Rechnungspositionen, d.h. es gibt f\u00fcr die einzelnen Positionen anhand der Einnahmeart f\u00fcr die Rechnung mehrere SEPA-Mandate bzw. es liegt f\u00fcr eine Position kein SEPA-Mandat vor. \u00a0</p> <p>Felder Tarifgruppenbezeichnung sowie Tarifbezeichnung wurden in Multiline-Felder umgewandelt. Nach der Neuerfassung einer Ausgangsrechnung wird die Spalte Debitor nun korrekt ausgewiesen, ohne den \"Aktualisierung-Button\" bet\u00e4tigen zu m\u00fcssen.</p> <p>Bei Rechnungserstellung/-bearbeitung werden f\u00fcr die einzelnen Rechnungspositionen die Tarife jetzt Haushaltsjahrspezifisch angezeigt.</p> <p>Im ARJ wird jetzt bei der Funktion \"Neue Rechnung\" analog der Funktion \"Neu aus Auswahl\" das Belegdatum anhand des aktuellen Tagesdatums vorgeblendet.</p> <p>Die Anzahl der m\u00f6glichen Zeichen in den Feldern Traifgruppenbezeichnung und Tarifbezeichnung wurde von 60 auf 100 erh\u00f6ht.</p> <p>Die unterschiedlichen Stati des Ausgangsrechnungsjournales werden in der Journaltabelle farblich hervorgehoben. \u00a0 \u00a0</p> <p>Bei Neuanlage einer Tarifgruppe oder eines Tarifes werden nun die zu erfassenden Felder korrekt geleert.</p> <p>Im Men\u00fc 55 - Stammdaten Ausgangsrechnungsjournal wurde das Layout ge\u00e4ndert. In der Einstiegsmaske wird jetzt zuerst der Mandant und das Haushaltsjahr vorgeblendet. Damit kommt es beim Wechsel zwischen den Reitern Tarifgruppen und Tarifarten, was auch weiterhin m\u00f6glich ist, nicht mehr zu unterschiedlichen Anzeigen Mandant/HHJ. Der Wechsel zwischen den Reitern kann auch durch die neue Funktion \"geteilter Bildschirm\" ersetzt werden. Die benutzerdefinierte Einstellung \"geteilter Bildschirm\" merkt sich das System, so dass die zuletzt verwendete Einstellung bei erneutem Aufrufen angezeigt wird.</p> <p>Die \u00dcbergabe von Ausgangsrechnungen, welche \u00fcber das Ausgangsrechnungsjournal bzw. Fakturierung erstellt sind, k\u00f6nnen an das DMS \u00fcbertragen werden.</p> <p>592 \u2013 Fakturierung / Stammdaten </p> <p>Die \u00dcbergabe von Ausgangsrechnungen, welche \u00fcber das Ausgangsrechnungsjournal bzw. Fakturierung erstellt sind, k\u00f6nnen an das DMS \u00fcbertragen werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderungen_release_50.html#auswertungen","title":"Auswertungen","text":"<p>6 \u2013 Auswertungen </p> <p>Um die eingebundenen Diagramme in Auswertungen drucken zu k\u00f6nnen, ist ein Farbdrucker erforderlich.</p> <p>613 \u2013 Zeitbuch / Quartalsstatistik </p> <p>Die viertelj\u00e4hrliche Kassenstatistik wurde auf eine periodengerechte Auswertung umgestellt. Im 1.Quartal werden ausschlie\u00dflich Buchungen der Perioden 1-3 ber\u00fccksichtigt. Sofern im 2.Quartal Buchungen mit Periode 1-3 enthalten sein sollten (z.B. Umbuchungen), werden diese unter Ber\u00fccksichtigung der letzten Zeitbuchnummer des 1.Quartals \u00a0dem 2.Quartal zugerechnet.</p> <p>F\u00fcr RZ-Kunden wurde der Button \u201eZusatzangaben\u201c hinzugef\u00fcgt, um vor Erstellung der Statistik die Eingabe von Zusatzdaten wie Hebes\u00e4tze, Schulden, usw. durch den Anwender selbst zu erm\u00f6glichen.</p> <p>Die Vierteljahresstatistik kann nun wieder als CSV-Datei ausgegeben werden. Dies muss in der Schnittstelle (Men\u00fc 351) am Parameter angepasst werden.</p> <p>6213 \u2013 Kontenbl\u00e4tter \u2013 Sachkontenbl\u00e4tter \u2013 Mittelbindung </p> <p>Der Report zur Mittelbindung ist \u00fcberarbeitet worden, so dass das Ein-/Ausblenden von Inhalten per Interaktion mit Plus/Minus-K\u00e4stchen wieder funktioniert. Zus\u00e4tzlich kann \u00fcber die Druckoptionen die Kontobezeichnung mit angezeigt werden.</p> <p>6223 \u2013 Kontenbl\u00e4tter \u2013 Sachkontenbl\u00e4tter \u2013 Kontoauszug </p> <p>Die OP's auf dem Personenkonto werden nun sortiert nach F\u00e4lligkeit ausgegeben, um die Darstellung f\u00fcr den Zahlungspflichtigen \u00fcbersichtlicher zu gestalten.</p> <p>Im Report FR_60101_KONTOAUSZUG_B.MRT wird jetzt das Druckdatum und die Seitenanzahl (Blatt 1 von ...) ausgewiesen sowie der RTB_4 Briefkopf wurde an die breite Reportvorgabe angepasst.</p> <p>6225 \u2013 Kontenbl\u00e4tter \u2013 Sachkontenbl\u00e4tter \u2013 Infoschreiben </p> <p>Der RTB_4 Briefkopf wurde im Report FR_60102_INFOSCHREIBEN_B.MRT an die breite Reportvorgabe angepasst.</p> <p>623 \u2013 Kontenbl\u00e4tter \u2013 Summen- und Saldenlisten </p> <p>Eine Mehrfachauswahl ist jetzt in den Selektionsfeldern der SuSa-Listen m\u00f6glich.</p> <p>634 \u2013 Bilanzlisten \u2013 Anlagespiegel </p> <p>Anlagenspiegel kann jetzt laut des neuem Musters gedruckt werden</p> <p>6412 \u2013 Ergebnisrechnung \u2013 \u00a0Planlisten - Gesamtergebnisplan </p> <p>Beim Druck der Listen in Verbindung mit einem Doppelhaushalt, kam es in einigen Reports zur verkehrten Anzeige des Haushaltsjahres im Listenkopf.</p> <p>6513 \u2013 Finanzrechnung \u2013 \u00a0Planlisten - Teilfinanzplan B </p> <p>Beim Druck des Teilfinanzhaushaltes B im 2. Doppelhaushaltsjahr kam es zu einer fehlerbehafteten Berechnung der Gesamteinzahlungen/-auszahlungen (Spalte 11). Hierzu erfolgte eine Korrektur, so dass der Ausweis der Werte jetzt korrekt ist.</p> <p>6611 \u2013 OP-Listen \u2013 Debitorisch - OP-Listen </p> <p>In der OP-Liste wird am Debitor ein Kennzeichen als Hinweis ausgegeben, wenn f\u00fcr diesen Debitor ein Infotext vorhanden ist.</p> <p>Bei der Saldobildung zwischen den beiden Referenzkonten kam es zu einem Anzeigefehler der Summenwerte. Hier erfolgte eine Korrektur. Weiterhin erfolgte eine kleine Anpassung des Layouts, da in manchen Konstellationen nur der PK-Namen ohne Positionen auf eine Seite unten geschrieben wurde.</p> <p>Beim Druck der debitorischen OP-Liste mit Stichtag und der Option inkl. Referenz-PK's kam es zu einem Fehler beim Ausweis der kreditorischen OP-Positionen des Referenzkontos. Hier erfolgte ein mehrfacher Ausweis desselben OP's.</p> <p>6612 \u2013 OP-Listen \u2013 \u00a0Debitorisch - Lastschriftvorschlag </p> <p>Durch den Releasewechselspunkt \"ung\u00fcltige BVs aus KA_KOPPL entfernen\" werden fehlerhaften Datens\u00e4tze von Bankverbindungen korrigiert. Voraussetzung ist die Durchf\u00fchrung der Releaswechselpunkte \"Datenbankstruktur anpassen\" \u00a0und \"Erg\u00e4nzung der Adressverwaltung um Mandanteninformationen\".</p> <p>Der Zeitpunkt der Vereinnahmung der Umsatzsteuer bei vereinnahmten Entgelten ist gesetzlich geregelt. Hierbei spielt die Schaltereinstellung F24 eine tragende Rolle. Steht diese auf \"Ja\", ist das Wertstellungsdatum des Schwebepostens ausschlaggebend f\u00fcr die Steuer- und Belegperiode. Steht der Schalter auf \"Nein\" entscheidet das Belegdatum beim Verbuchen des Lastschriftlaufes im Men\u00fc 6612 \u00fcber die Steuerperiode.</p> <p>6613 \u2013 OP-Listen \u2013 Debitorisch - Gutschriftvorschlag </p> <p>Durchf\u00fchrung eines Gutschriftlaufes, kam es zu einem Fehler bei der Darstellung des Laufes in der Tagesabschluss\u00fcbersicht - LUSI-Liste. Der Gutschriftlauf wurde irrt\u00fcmlich unter den Lastschriften ausgewiesen. Hier erfolgte eine Korrektur, so dass der Gutschriftlauf wieder bei den \u00dcberweisungen angezeigt wird.</p> <p>6614 \u2013 OP-Listen \u2013 Debitorisch - Mahnvorschlag </p> <p>Die Nebenforderungen werden nun korrekt ohne Skontobetrag ausgewiesen, wenn eine skontierte Hauptforderung zu Grunde liegt.</p> <p>6617 \u2013 OP-Listen \u2013 Debitorisch - Auszifferung </p> <p>Wenn bei einer Auszifferung ein negativer OP-Betrag \u00fcbrig blieb, wurde auf der OP-Liste bisher immer 0,00 \u20ac bei \"offen nach Ausz.\" ausgewiesen. Jetzt wird der aktuelle neue OP-Betrag nach Auszifferung in der OP-Liste angezeigt.</p> <p>In der Vorschlagsliste der maschinellen Auszifferung wird in der Betragsspalte der Auszifferungsbetrag zu jedem aufrechenbaren Offenen Posten wieder ordnungsgem\u00e4\u00df dargestellt.</p> <p>6622 \u2013 OP-Listen \u2013 Kreditorisch - Zahlungsvorschlag </p> <p>Aus der LUSI-Liste k\u00f6nnen jetzt Zahlungsavisschreiben an die Kunden versendet werden. Nach dem Erstellen der LUSI-Liste k\u00f6nnen \u00fcber den Button \"Druck Avis\" und der m\u00f6glichen Selektion auf ein konkretes PK / Anzahl der enthaltenen Positionen die Avisschreiben f\u00fcr die Kunden erzeugt werden. Die Anpassung der Texte erfolgt \u00fcber die Textbausteine, Men\u00fc 1y1.</p> <p>671 \u2013 Umsatzsteuer \u2013 Journal </p> <p>F\u00fcr die Spalte der Buchungsperiode in der Steuerbuchungsrecherche, wurde bei abweichendem Haushaltsjahr vom Aktuellen, noch die Angabe des Jahres in der genannten Spalte erg\u00e4nzt. Diese F\u00e4lle geschehen h\u00e4ufig \u00fcber den Jahreswechsel oder auch bei Angabe einer abweichenden Leistungsperiode.</p> <p>In der Vorschlagsliste der maschinellen Auszifferung wird in der Betragsspalte der Auszifferungsbetrag zu jedem aufrechenbaren Offenen Posten wieder ordnungsgem\u00e4\u00df dargestellt.</p> <p>672 \u2013 Umsatzsteuer \u2013 Meldungen </p> <p>Ab Release 50 ist die Steuerart 1 \"beliebige Steuer\" wieder ausw\u00e4hlbar. Somit kann nun ein Sachkonto f\u00fcr verschiedene Steuervorg\u00e4nge genutzt werden. Die Einstellung beginnt in der Sachkontenverwaltung. Wenn hierbei die Steuerart \"beliebig\" gew\u00e4hlt wird, muss kein Steuerkennzeichen ausgew\u00e4hlt werden. Wird das Konto nun bei der Buchung gew\u00e4hlt, kann direkt in der Buchungsmaske das Steuerkennzeichen herausgesucht werden. Das Steuerkennzeichen ist somit ein Merkmal des offenen Postens geworden. Wird bspw. eine Aufteilungsbuchung vorgenommen, \u00a0welche in den verschiedenen Vorg\u00e4ngen/ Positionszeilen das gleiche Sachkonto inne hat, aber in denen das Steuerkennzeichen jeweils unterschiedlich ist (bspw. 7% und 19%), so werden auch 2 offene Posten gebildet.</p> <p>Das Formular f\u00fcr die Umsatzsteuer-Voranmeldung 2019 ist hinterlegt.</p> <p>Das Formulars der Dauerfristverl\u00e4ngerung kann nun auch ohne Sondervorauszahlung versendet werden. Somit wird rein nur die Dauerfristverl\u00e4ngerung beantragt und keine Sondervorauszahlung angemeldet.</p> <p>Steuerperiode wird aus Eingangsdatum des ERJ bzw. Wertstellungsdatum abgeleitet.</p> <p>Sollten Steuerkennzeichen mit Kommastellen eingepflegt sein, werden diese nun korrekt in der Prozentspalte der Umsatzsteuerzusammenstellung dargestellt.</p> <p>In der Umsatzsteuermeldung ist noch eine weitere Registerkarte \"\u00dcbersicht der Jahresumsatzsteuermeldung\" hinzugekommen. Diese wird analog der Umsatzsteuervoranmeldungen erstellt (\u00fcber die \"Ausstehenden Buchungen\" in der Registerkarte, werden die Buchungen dem Jahr zugeordnet). Sollte die elektronische \u00dcbermittlung \u00fcber das IFR erfolgen, werden die Stammdaten (Zuordnung der Steuerkennzeichen zu der jeweiligen Zeile in der Jahresmeldung) im Men\u00fc 11 gepflegt (die Vorlage kann \u00fcber den Button Abgleich herangezogen werden). \u00dcber \"Steuerformular anzeigen/versenden\" wird nun das Formular f\u00fcr die Umsatzsteuererkl\u00e4rung ge\u00f6ffnet. Sollte es beim Senden der Erkl\u00e4rung sogenannte \"Validierungsfehler\" geben, finden Sie die Fehler unter dem Button \"Sendeprotokolle\" und der Registerkarte \"Validierungsauskunft\". Hier werden die Fehler genauer beschrieben (meist auch mit Zeilenangabe), die anzeigen, weshalb nicht versendet werden kann.</p> <p>Eine weitere Registerkarte im Men\u00fc 672 ist die der Zusammenfassenden Meldung. Das Programm sucht anhand der Steuerkennzeichen eigenst\u00e4ndig die F\u00e4lle heraus, die laut Eigenschaften im Steuerkennzeichen relevant f\u00fcr die zusammenfassende Meldung sind. Der Anwender kann die einzelnen F\u00e4lle l\u00f6schen, ver\u00e4ndern, sowie weitere hinzuf\u00fcgen. Auch dies kann elektronisch via ELSTER aus dem IFR heraus \u00fcbermittelt werden. Es gibt folgende Kennzeichen:</p> <p>laut Formular  im IFR  Leer LInnergemeinschaftliche Warenlieferung 1 S Innergemeinschafliche Sonstige Leistungen 2  D Dreiecksgesch\u00e4fte</p> <p>69 \u2013 Gesetzliche Drucklisten </p> <p>Es ist nun m\u00f6glich Blatt 1 und Blatt 2 des Musters 21 als ein PDF zu drucken. Daf\u00fcr muss in der Listenpositionsverwaltung jeweils bei ER-Positionen und KLR-Positionen die Liste 6 abgeleitet werden.</p> <p>Bisher wurde in der Liste f\u00fcr den voraussichtlichen Stand der Verbindlichkeiten in der Spalte f\u00fcr die Umschuldungen immer ein Wert 0 Euro ausgewiesen. Da das nach Ansicht der Rechnungspr\u00fcfer nicht korrekt war, ist jetzt eine Korrektur der Liste erfolgt, so dass hier jetzt beim Druck der Liste der geplante Umschuldungsbetrag f\u00fcr das Haushaltsjahr mit ausgewiesen wird. Sollte der Wert bei Ihnen noch nicht angezeigt werden, wenden Sie sich bitte an Ihre Fachberater.</p> <p>Informationsbox \"Bilanzposition f\u00fcr die Berechnung des Jahres\u00fcberschusses / -fehlbetrags Vorjahr nicht gefunden.\" und \"Bilanzposition f\u00fcr die Berechnung des Jahres\u00fcberschusses / -fehlbetrags aktuelles Jahr nicht gefunden.\" \u00a0wird beim Druck einer Bilanz nicht mehr angezeigt.</p> <p>In der Teilergebnisrechnung werden die Beschreibungstexte aus der Hierarchieverwaltung wieder korrekt \u00fcbergeben.</p> <p>Erg\u00e4nzung von Fu\u00dfnoten f\u00fcr die Spalten 7, 8 und 10 gem\u00e4\u00df gesetzlicher Anforderung am Muster 14 (Anlagen\u00fcbersicht)</p> <p>Bei der Darstellung der Diagramme, erfolgte eine \u00dcberarbeitung des Layouts. Die in den Diagrammen ausgewiesen Werte, sind die jeweiligen Summenzeilen der Listen. Beim Druck der Teilergebnispl\u00e4ne, ist der Druck mit Diagrammen nur f\u00fcr die oberste Ebene (Teilhaushalte) gegeben.</p> <p>Beim Druck des Ergebnishaushaltes, wird nun bei einem Nachtrag eines Doppelhaushaltes das Haushaltsjahr richtig ausgewiesen.</p> <p>Bei den Einstellungen f\u00fcr die Listenparameter, wurde f\u00e4lschlicher Weise f\u00fcr die Listen M17 bis 20 eine Eingabem\u00f6glichkeit f\u00fcr die Startseite mitangezeigt. Das wurde korrigiert. </p> <p>Die Spalte der Umschuldungen im Haushaltsjahr wurde lt. den Rechnungspr\u00fcfern bisher nicht korrekt bef\u00fcllt. Hierzu erfolgte jetzt eine \u00c4nderung im Ausweis der Umschuldungsbetr\u00e4ge. In der Summe f\u00fcr die Umschuldungen wird jetzt immer der positive Umschuldungsbetrag ausgewiesen, f\u00fcr die Pr\u00fcfer, bei Abgabe der Liste ohne Kontennachweis. Zum Abgleich in der Verwaltung werden beim Druck mit Kontennachweis beide Werte (positiv/negativ) angedruckt.</p> <p>6s \u2013 Dokumentenmappe </p> <p>In der Dokumentenmappe wird nun der Erstellungszeitpunkt eines Dokumentes mit dem Format [dd.MM.yyyy-hh.mm.ss] dargestellt.</p> <p>Bei der Erstellung einer Dokumentenmappe, kam es bei Verwendung der Option Mischen in der Gliederung zu einem nicht korrekten Ergebnis bei der Einsortierung der Dokumente in die Gliederungsstruktur der Dokumentenmappe.</p> <p>Beim Druck der Dokumentenmappe werden l\u00e4ngere \u00dcberschriften am Ende einer Zeile nicht mehr abgeschnitten.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderungen_release_50.html#jahresabschluss","title":"Jahresabschluss","text":"<p>712 \u2013 Vorbereitung Kassen-JW \u2013 Aktualisierung Stammdaten </p> <p>In der erweiterten Faktura gibt es nun eine neue Funktion, um Tarifgruppen und Tarife in das n\u00e4chste Haushaltsjahr zu heben. Es werden nur die Tarife ins n\u00e4chste Jahr gewechselt, die einer Tarifgruppe zugeordnet sind und in dem aktuellen Jahr verwendet worden sind. Die Jahreswechselfunktion f\u00fcr ARJ Tarifgruppen und Tarife wurde unter dem Men\u00fc 712 erg\u00e4nzt.</p> <p>72 \u2013 Kassenjahreswechsel </p> <p>Um die Kassenjahreswechsel, trotz noch offener Jahresabschl\u00fcsse durchf\u00fchren zu k\u00f6nnen, war es bisher notwendig sich das Tagespasswort geben zulassen, um die Pr\u00fcfung \"auf abgeschlossenes Jahr pr\u00fcfen\" zu deaktivieren. Die Eingabe des Tagespasswortes entf\u00e4llt zuk\u00fcnftig. Hintergrund ist, dass viele Kommunen noch keine aktuellen Jahresabschl\u00fcsse aus unterschiedlichen Gr\u00fcnden durchf\u00fchren k\u00f6nnen und damit nicht den Kassenjahreswechsel ohne Fachberater durchf\u00fchren konnten.</p> <p>731 \u2013 Vorbereitung endg. JAB \u2013 RAP-Verwaltung </p> <p>Nach \u00dcbertrag des RAP ins Folgejahr kam es zu Problemen mit der Verbuchung des RAP's. Der Fehler ist behoben, so dass die Buchungen wieder funktionieren.</p> <p>Bei der Verbuchung von RAP's die erst in der Zukunft beginnen, z.B. Grabverl\u00e4ngerungen, kam es zu einer Fehlermeldung. Hierzu erfolgte eine Anpassung, so dass diese RAP's jetzt ohne Abgrenzung von einem Jahr ins n\u00e4chste Jahr geschoben werden, bis der Zeitraum f\u00fcr den RAP beginnt.</p> <p>732 \u2013 Vorbereitung endg. JAB \u2013 Bagatellbereinigungen </p> <p>Mit Release 50 ist die Bagatellbetragsbereinigung mit allen drei Optionen (Unterzahlung- Forderungsausbuchung oder Niederschlagung/ \u00dcberzahlung) sowohl bei Soll-, als auch bei Istversteuerung nun nutzbar. Die Umsatzsteuerkorrekturen werden sowohl buchhalterisch, als auch im USt-Modul korrekt ausgewiesen.</p> <p>7331 \u2013 Vorbereitung endg. JAB \u2013 Buchhaltungsabstimmung \u2013 Kontenabstimmung </p> <p>Der Testschritt C bei der Kontenabstimmung \"Endsaldo zu EB\" wird nun wieder korrekt mit dem Vorjahr verglichen.</p> <p>7333\u2013 \u00a0Vorbereitung endg. JAB \u2013 Buchhaltungsabstimmung \u2013 OP-Abstimmung </p> <p>In der Buchhaltungsabstimmung gibt es nun auch f\u00fcr Steuerbuchungen eine Einzelwertberichtigung. Diese greift bei Buchungen, die in eine andere Steuerperiode verschoben wurden, deren Verkehrszahlen aber f\u00e4lschlicherweise nicht verschoben wurden. Die neue Buchhaltungsabstimmung korrigiert die Verkehrszahlen. Die USt-Zusammenstellung kann somit wieder korrekt dargestellt werden. Um die Suchfelder zu nutzen muss der Pr\u00fcf-Button als Best\u00e4tigung genutzt werden. Eine Aktivierung der \"Auto-Korrektur\" sorgt bei Verwendung des Pr\u00fcf-Buttons f\u00fcr die Berichtigung der Verkehrszahlen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderungen_release_50.html#veranlagung","title":"Veranlagung","text":"<p>152 \u2013 Stammdaten \u2013 Veranlagung \u2013 Einnahmearten </p> <p>Es ist m\u00f6glich verschieden Forderungsintervalle (monatlich, quartalsweise und j\u00e4hrlich) innerhalb einer Veranlagungseinnahmeart abzubilden. Die Option \"Monatliche Sollstellung\" muss daf\u00fcr auf 'J' bzw. 'J mit SR\u2019 stehen und die Anzahl der zu zahlenden Raten muss ein Teiler von 12 sein.  Gew\u00fcnschte Umstellungen sind mit der Fachberatung abzustimmen.</p> <p>Es ist jetzt m\u00f6glich, f\u00fcr eine Veranlagungs-EArt eine Standard-Umlenkungs-EArt einzurichten. Damit kann erreicht werden, dass Veranlagungen im neuen Haushaltsjahr auf eine andere Buchungsstelle als im alten Jahr gebucht werden, ohne alle Objekte \u00e4ndern zu m\u00fcssen.</p> <p>81 \u2013 Einzelveranlagung / 82 \u2013 Gesamtveranlagung </p> <p>Die Suche nach Zusatzadressen (Zusteller, weitere Bescheidempf\u00e4nger usw.) \u00a0ist auch aus der Einzelveranlagungsmaske heraus m\u00f6glich. F\u00fcr die Bearbeitung der konkreten Veranlagung ist aber immer das Veranlagungs-PK anzugeben.</p> <p>Beim Buchen aus der Veranlagung besteht die M\u00f6glichkeit auf Buchungsstellen mit Ma\u00dfnahme (z.B. Ausbaubeitr\u00e4ge) zu buchen.</p> <p>Auch auf Gewerbesteuerbescheiden k\u00f6nnen Folgejahresraten ausgewiesen werden. Diese Funktionalit\u00e4t ist analog \u201aAllgemeine Steuern\u2018 \u00fcber die Veranlagungs-Stammdaten (Men\u00fc 152) zu pflegen. Bei gew\u00fcnschtem Ausweis der Folgejahresraten werden diese jedoch nur ausgewiesen, wenn f\u00fcr das Folgejahr kein abweichender Messbetrag hinterlegt wurde.</p> <p>Ist zum Zeitpunkt der Erstellung von Bescheiden bereits eine neue Bankverbindung hinterlegt, wird die Abbucherinformation auf Basis des g\u00fcltigen Mandats der ersten Rate ausgewiesen.</p> <p>Beim Eigent\u00fcmerwechsel von Jahressteuern (z.B. Grundsteuern) wird das Datum \u201aEigent\u00fcmerwechsel am\u2018 mit 01.01. vorgeschlagen, das Jahr muss erg\u00e4nzt werden. Beim \u201a\u00dcbernehmen\u2018 oder \u201a\u00dcbernehmen/Drucken\u2018 erfolgt eine Gegenpr\u00fcfung, ob der Schalter \"Jahressteuer anteilig\" und Wechseldatum zusammenpassen.</p> <p>In den Veranlagungs-Objektdaten wird die Buchungs-EArt nur noch gef\u00fcllt, wenn sie f\u00fcr das gew\u00e4hlte Objekt abweichend vom Standard festgelegt wird. Diese Eintragung erfolgt im Men\u00fc 152. Damit kann erreicht werden, dass Veranlagungen im neuen Haushaltsjahr auf eine andere Buchungsstelle als im alten Jahr gebucht werden, ohne alle Objekte \u00e4ndern zu m\u00fcssen. Bitte pr\u00fcfen Sie in diesem Zusammenhang die vorhandenen OP-Bez\u00fcge f\u00fcr die Last- und Gutschriften, damit die Bankverbindungen / Mandate sowohl auf den Bescheiden als auch bei den Kassenfunktionen zur Verf\u00fcgung stehen.</p> <p>Das L\u00f6schen von Gewerbesteuerobjekten, zu denen Veranlagungsdaten existieren, ist generell nicht mehr m\u00f6glich. Sollten in ihrem System Veranlagungsdaten zu gel\u00f6schten Objekten vorliegen, werden diese Objekte im Releasewechselprotokoll ausgewiesen. Die Objektdaten dieser Objekte sind neu zu erfassen, die bereits erfolgten Veranlagungen sind damit im neu angelegten Objekt wieder vorhanden. Bitte setzen Sie sich mit der Fachberatung in Verbindung, wenn die fehlende Objektnummer nicht angelegt werden kann, da bereits Objekte mit einer h\u00f6heren Objektnummer existieren. Das Protokoll vom Releaswechsel mit eventuell gel\u00f6schten GwSt-Objekten wird unter... SaskiaServer/release/400050 gespeichert und kann dort jederzeit eingesehen werden.</p> <p>Prinzipiell besteht nun die M\u00f6glichkeit, spezielle Textbausteine f\u00fcr die Beendigung eines Veranlagungsfalls einzurichten. Bitte kontaktieren Sie bei Bedarf f\u00fcr die notwendigen Einrichtungen die Fachberatung.</p> <p>84 \u2013 Freie Auswertungen </p> <p>Mit der Auswertung FS0032 stehen die notwendigen Meldungen f\u00fcr mitteilungspflichtige Hunde (gef\u00e4hrliche Hunde) zur Verf\u00fcgung.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderungen_release_50.html#kredite-darlehen","title":"Kredite / Darlehen","text":"<p>a1\u2013 Bearbeiten </p> <p>Bei Krediten, die im aktuellen HH-Jahr aufgenommen wurden, aber die erste Rate erst im Folgejahr haben, kam es bei den Auswertungen zu einem nicht bzw. nicht richtigen Ausweis des Kredites. Um die Darstellung des Kredites bei dieser Konstellation zu gew\u00e4hrleisten, wird zum 31.12. des Jahres eine 0-Rate gebildet, die intern gleich freigegeben und gebucht ist. Es entsteht dabei kein Buchungssatz in der Finanzbuchhaltung.</p> <p>In der Einstiegsmaske zu den Krediten wurden die Spalte \"Vertragsnr\" erg\u00e4nzt, um die Kredite schon dort besser einordnen zu k\u00f6nnen.</p> <p>a1 \u2013 Bearbeiten, a2 \u2013 Freigabe/Buchung, a42 \u2013 Zins-/Tilgungsplan </p> <p>Das Auswahlfeld \"Kredit-Buchungsst.\" wurde in den Men\u00fcs a1, a2 und a42 erg\u00e4nzt.  Zus\u00e4tzlich wurde die Spalte \"Buchungsstelle\" (= Kreditbuchungsstelle) in den genannten Men\u00fcs eingef\u00fcgt.</p> <p>Der Zins- und Tilgungsplan eines Kredites ist auch bei umfangreichem Tilgungsplan im Men\u00fc a1 und a42 druckbar.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderungen_release_50.html#anlagenbuchhaltung","title":"Anlagenbuchhaltung","text":"<p>Allgemein </p> <p>Neuer Schalter A60 zur Festlegung ob der Buchungtext 1+2, beim Hinzuf\u00fcgen neuer Positionen \u00fcber den \u201eER+\u201c - Button zu einem neuen Anlagegut/ Zuschuss, in die Bezeichnung 1+2 \u00fcbernommen werden soll. Zus\u00e4tzlich werden in den Reiter \u201eZuzatztext\u201c folgende Angaben \u00fcbernommen: Buchungstext 1+2 | Belegnummer | Buchungsdatum | F\u00e4lligkeitsdatum | Freitext. M\u00f6gliche Schalterstellungen \u201eJ\u201c = JA | \u201eN\u201c = Nein (Standard) | \u201eI\u201c = Interaktiv (Nachfrage bei jeder Positions\u00fcbernahme) </p> <p>Diverse Optimierungen der \u201e\u00c4nderungsanzeige\u201c und eindeutige Kennzeichnung der Anlageg\u00fcter welche aus einem Vorsystem stammen.</p> <p>b11 \u2013 Anlagegut bearbeiten </p> <p>Ein Fehler wurde behoben, welcher die Zuordnung eines neuen Zuschusses \u00fcber den Reiter \"Bruttozuschuss\" und den Button \"Neuer Zuschuss\" verhinderte.</p> <p>Fehler behoben welcher bei bestimmten Konstellationen die Verkn\u00fcpfung von Zuschuss und Anlagegut \u00fcber die \"normalen\" Wege verhinderte, sondern nur manuell \u00fcber das Men\u00fc b223 \u2013 Umbuchung durchgef\u00fchrt werden konnte.</p> <p>b21 \u2013 Zuschuss bearbeiten </p> <p>Fehler behoben welcher bei bestimmten Konstellationen die Verkn\u00fcpfung von Zuschuss und Anlagegut \u00fcber die \"normalen\" Wege verhinderte, sondern nur manuell \u00fcber das Men\u00fc b223 \u2013 Umbuchung durchgef\u00fchrt werden konnte.</p> <p>b124 \u2013 Anlageg\u00fcter \u2013 Zusatzfunktionen \u2013 \u00a0Zuschreibungen </p> <p>F\u00fcr Verm\u00f6gensgegenst\u00e4nde bei dem das Festwertverfahren zur Anwendung kommt, ist nun sichergestellt, dass (au\u00dferplanm\u00e4\u00dfige) Zu- und Abschreibungen \u00a0fehlerfrei vorgenommen werden k\u00f6nnen. \u00a0 </p> <p>b126 \u2013 Anlageg\u00fcter \u2013 Zusatzfunktionen \u2013 \u00a0Stornierung </p> <p>Fehler behoben welcher bei der Stornierung von Umbuchungen in bestimmten Konstellationen ein einseitiges Storno von produzierte und daraus resultierend der AHK-Wert falsch darstellt wurde. </p> <p>b67 \u2013 Anlagespiegel </p> <p>Die Listen Anlagenspiegel und Sonderposten\u00fcbersicht stellen die Gesamtsummenzeile wieder korrekt dar, dazu ist es notwendig im Men\u00fc 123 Reiter \"Bilanz-Positionen\" die Listennummer 4 und 6 neu abzuleiten.</p> <p>b68 \u2013 Sonderposten\u00fcbersicht </p> <p>Die Listen Anlagenspiegel und Sonderposten\u00fcbersicht stellen die Gesamtsummenzeile wieder korrekt dazu ist es notwendig im Men\u00fc 123 Reiter \"Bilanz-Positionen\" die Listennummer 4 und 6 neu abzuleiten. Der EB-Korrekturwert bei der Sonderposten\u00fcbersicht wird nicht in der Summe Stand 31.12 ber\u00fccksichtigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0050/programmaenderungen_release_50.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s13 \u2013 System \u2013 Einrichtung \u2013 Aufgabenplanung </p> <p>Mit der Jobklasse \"Anordnungsdruck\" k\u00f6nnen in einem RZ-Druckjob die noch ungedruckten AO's gedruckt werden. Diese werden dann in die Jobdruckschlange in den RZ-Funktionen eingestellt.</p> <p>s21 \u2013 System \u2013 Rechte und Sicherheit \u2013 Benutzerverwaltung </p> <p>Integration eines LDAP-Abgleichs in die Systemverwaltung - Im Reiter Nutzer wurde die M\u00f6glichkeit geschaffen, neue Nutzer \u00fcber das Lightweight Directory Access Protocol (LDAP) aus dem Windows Verzeichnisdienst Active Directory (AD) zu importieren bzw. die Nutzerinformationen zu aktualisieren.</p> <p>F\u00fcr einen Single-Sign-On via Citrix oder Domain k\u00f6nnen die Anmeldedaten der Domain jetzt zus\u00e4tzlich in der Nutzerverwaltung gespeichert werden.</p> <p>Die Verarbeitung einer Schnittstelle kann einem konkreten Nutzer zugewiesen werden. Wenn der Nutzer das Recht 351 (Einrichten einer Schnittstelle) \u00a0nicht hat, ist eine \u00c4nderung der Parameter nicht m\u00f6glich.</p> <p>In der Systemverwaltung kann nun nach \"nur aktiven Nutzern\" gefiltert werden.</p> <p>s31 \u2013 System \u2013 Update \u2013 Releasewechsel </p> <p>Die ge\u00e4nderte Hierarchie (Produktgruppen) f\u00fcr die Jahresstatistik ber\u00fccksichtigt nun ordnungsgem\u00e4\u00df den Schalter F41 zur Version des Schattenmandanten. Es wurde au\u00dferdem die Liste aller bebuchten, aber unzul\u00e4ssigen Kombinationen von Produkt und Sachkonto gepr\u00fcft und angepasst, so dass nunmehr keine zul\u00e4ssigen Kombinationen mit ausgegeben werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/installation_checkliste_relea3.html","title":"Installation Checkliste Release 4.1.0051","text":""},{"location":"aktuelles/releasehistorie/release4.1.0051/installation_checkliste_relea3.html#installation-checkliste-release-410051","title":"Installation Checkliste Release 4.1.0051","text":"<p>Vorg\u00e4ngerrelease ist Release 50</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/installation_checkliste_relea3.html#update","title":"Update","text":"<p>1. Alle SASKIA\u00ae.de IFR-Nutzer abmelden </p> <p>(auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 51.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/installation_checkliste_relea3.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>1. Releasewechsel 51 </p> <p>Nach herunterladen und installieren des Updates kann der Releasewechsel f\u00fcr Release 51 durchgef\u00fchrt werden.</p> <p></p> <p>Durch Markieren des entsprechenden Punktes in der linken Tabelle werden die Punkte des Releasewechsels wie gewohnt in der rechten Tabelle dargestellt.</p> <ul> <li> <p>Datenbankstruktur anpassen. Interne Anpassung der allgemeinen Datenbankstruktur in der Datenbank. Dieser Releasewechselpunkt hat keine Auswirkung auf den aktuellen Datenbestand.</p> </li> <li> <p>Datenbank\u00e4nderungen </p> </li> <li> <p>Spalten AO_NR in Tabelle KB_AO, sowie KB_Journal_ID und Journal_PID in Tabelle KB_OP in Integer-Datentypen umwandeln. Interne Datentypen Anpassung in der Datenbank f\u00fcr die genannten Spalten in ganze Zahlen.</p> </li> <li> <p>Entfernung der Felder ROWID (nur SQL-Kunden) F\u00fcr SQL-Kunden sind bei der Durchf\u00fchrung des Releasewechsels f\u00fcr das Release 51 folgende Punkte zu beachten:</p> </li> <li>Entfernung des Feldes ROWID aus Tabelle KB_ZWZAHLVP.</li> <li> <p>Entfernung des Feldes ROWID aus Tabelle KB_BUDGET.</p> </li> <li> <p>Aktualisierung der Finanzamts-Tabelle \u00dcber diesen Releasewechselpunkt kann Zuk\u00fcnftig die Finanzamtsliste von Deutschland f\u00fcr die Veranlagung aktualisiert werden. Finanz\u00e4mter die es nicht mehr gibt, werden nicht aus der Liste herausgel\u00f6scht, sondern bekommen ein Kennzeichen (hist.)</p> </li> <li> <p>generiere f\u00fcr MRT mit RTB/ bei OE_OPTION=D ggf. leere RTB's f\u00fcr Mandant=0000 Mit diesem Releasewechselpunkt werden ggf. leere RTB's in der Textbausteinverwaltung gebildet, vorausgesetzt in der Reportvorlage ist die Option \"Textbaustein\" gesetzt. Damit wird sichergestellt, dass alle Reports vom Nutzer gedruckt werden k\u00f6nnen.</p> </li> <li> <p>Anpassung der Reportvorlagen </p> </li> </ul> <p>2. Aktualisierung des Schattenmandanten </p> <p>Mit Release 51 wird ein neuer Schattenmandant ausgeliefert, um die notwendigen gesetzlichen \u00c4nderungen (Muster, Konten, Produkte und Zahlwege) abzubilden. Hierf\u00fcr ist in der Systemverwaltung Men\u00fc s31 \u2013 Datenbankaktualisierung oder im IFR im Men\u00fc 124 \u2013 Sachkontenverwaltung der Schattenmandant zu aktualisieren. Folgende Punkte sind dabei zwingend auszuf\u00fchren:</p> <ul> <li>Hierarchie laden Listen laden Sachkonten laden* Statistik ladenLaden der Stammdaten f\u00fcr die Statistik-Hierarchie S in den SchattenmandantUmsatzsteuervorbelegung Mandantenstamm </li> </ul>"},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#letzte-programmanderungen","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#auslieferung-zum-03052019","title":"Auslieferung zum 03.05.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#stammdaten","title":"Stammdaten","text":"<p>12a3 - Personenkontenverwaltung </p> <p>Bei der Suche nach PK-Nummern wird das vorgegebene Auslandskennzeichen ber\u00fccksichtigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#op-bearbeitung","title":"OP-Bearbeitung","text":"<p>431 - AdV-Verwaltung </p> <p>Beim Druck des Erlass-/AdV-Bescheides \u00fcberdeckte das Datumsfeld, beim Druck den letzten Buchstaben von \"Ihre Antragstellung auf AdV/Erlass vom\". Damit sah es im Ausdruck aus als ob dort \"von\" statt \"vom\" steht. </p> <p>443 - Wertberichtigungsliste </p> <p>In der Wertberichtigungsliste gibt es nun die neue Vorlagen-Option \"nur Summen ausgeben\". Mit dieser Vorlagen-Option k\u00f6nnen laut Sortier-Option Einzelpositionen zusammengefasst und als Summen ausgegeben werden. Die Liste kann somit als verk\u00fcrzte Summen-\u00dcbersicht ausgegeben werden. </p> <p>491 - Erlass </p> <p>Beim Druck des Erlass-/AdV-Bescheides \u00fcberdeckte das Datumsfeld, beim Druck den letzten Buchstaben von \"Ihre Antragstellung auf AdV/Erlass vom\". Damit sah es im Ausdruck aus als ob dort \"von\" statt \"vom\" steht.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#auftrag-faktura","title":"Auftrag / Faktura","text":"<p>52 - Eingangsrechnungsjournal </p> <p>Bei der Erfassung einer Eingangsrechnung im Feld \"Weiterleitung\" wird nun Name, Vorname und in Klammern der Loginname angezeigt um die Eindeutigkeit bei der Auswahl gew\u00e4hrleisten zu k\u00f6nnen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#auswertung","title":"Auswertung","text":"<p>672 - Umsatzsteueranmeldungen </p> <p>F\u00fcr die Bildung der Steuerperiode, bei Buchung mit BS421 wird jetzt, sowie bei BS411, das OP-Belegdatum daf\u00fcr herangezogen. Bei Angabe einer abweichenden Leistungsperiode wird diese als Steuerperiode bei einer Forderungsbuchung herangezogen.</p> <p>68 - Individuelle Auswertungen </p> <p>Die Liste \"Auswertung Gesperrte Belege\" \u00a0FS12A4 kann wieder ohne Fehlermeldung gedruckt werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#veranlagung","title":"Veranlagung","text":"<p>Allgemein </p> <p>Im Gewerbesteuerbescheid wird f\u00fcr den Bereich der Gewerbesteuerzinsen die Tabellen\u00fcberschrift nicht mehr auf einer anderen Seite als die zugeh\u00f6rigen Berechnungsdaten ausgewiesen, der Zinsblock wird je Jahr zusammengehalten. Auch beim Gewerbesteuerbescheid kann \u00fcber Vorlagen-Optionen das Aktenzeichen Finanzamt im Bescheidkopf ausgeblendet werden. In diesen F\u00e4llen sollte es in den Objektdaten mit ausgewiesen werden. </p> <p>81 - Einzelveranlagung </p> <p>Auch bei einem abweichendem Wirtschaftsjahr vom 01.12 - 30.11. erfolgt ein korrekter Ausweis der Quartalsangaben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#auslieferung-zum-10042019","title":"Auslieferung zum 10.04.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#stammdaten_1","title":"Stammdaten","text":"<p>12a3 - Personenkontenverwaltung </p> <p>Beim Anlegen eines Kreditors, vergibt das Programm nun auch wieder im Buchstabenbereich korrekt die n\u00e4chste freie Nummer.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#buchung","title":"Buchung","text":"<p>392 - Sachkontenauskunft </p> <p>Bei \u00dcbertragungen von Haushaltsresten auf Bilanz-Quellkonten mit zwei angehangenen FR-Konten wird die eigentliche Mittel\u00fcbertragung auf dem ersten FR-Konto gebucht. Die sp\u00e4tere Inanspruchnahme z.B. im ERJ wird auch gegen das erste FR-Konto gebucht. Somit werden die Verf\u00fcgbarkeiten in der SK-Auskunft, Budget\u00fcbersicht und Verf\u00fcgbarkeit im ERJ einheitlich korrekt dargestellt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#op-bearbeitung_1","title":"OP-Bearbeitung","text":"<p>421 - Stundung </p> <p>Unter SQL-Server wird dass AO-Formular f\u00fcr Stundungsvorg\u00e4nge wieder korrekt erstellt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#veranlagung_1","title":"Veranlagung","text":"<p>8 - Veranlagung </p> <p>Ist kein extern abgelegtes Logo f\u00fcr die Bescheiderstellung vorhanden, so wird auf allen Veranlagungsbescheiden das Logo aus dem Mandantenstamm genutzt.</p> <p>Bei Beendigung einer Veranlagung wird die Angabe 'Ende der Steuerpflicht' wieder ausgewiesen, wenn die Ausgabe des Steuer-/Abgabenpflichtige auf dem Bescheid erfolgt.</p> <p>Im Gewerbesteuerbescheid wird f\u00fcr den Bereich der Gewerbesteuerzinsen die Tabellen\u00fcberschrift nicht mehr auf einer anderen Seite als die zugeh\u00f6rigen Berechnungsdaten ausgewiesen, der Zinsblock wird je Jahr zusammengehalten</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s31 - Releasewechsel </p> <p>\"Korrektur Fremdzugriff Anbu-View Sachkonten\" --- f\u00fcr Anwender, die hallokai! oder ARCHIKART im Einsatz haben Mit diesem Releasewechselpunkt wird der Abfragenutzer \u00a0von hallokai! / ARCHIKART \u00a0wieder f\u00fcr den Zugriff ins IFR berechtigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#auslieferung-zum-29032019","title":"Auslieferung zum 29.03.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#stammdaten_2","title":"Stammdaten","text":"<p>12a3 - Personenkontenverwaltung </p> <p>Beim anlegen eines Kreditors, vergibt das Programm nun auch wieder im Buchstabenbereich korrekt die n\u00e4chste freie Nummer.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#buchung_1","title":"Buchung","text":"<p>314 - Storno-Buchungen </p> <p>In der STORNO-Funktion werden nun nur noch Buchungen laut des hinterlegten Budgetrechts angezeigt. Au\u00dferdem kann ein Anwender nur Buchungen stornieren laut des hinterlegten Buchungsschl\u00fcsselrechts.</p> <p>Beim verbuchen eines Stornos kann nun ein Weiterleitungsvermerk mit gegeben werden.</p> <p>In der \u00dcbersicht werden nun keine AR, ER und Stundungen angezeigt, da diese nicht \u00fcber die STORNO-Funktion zu stornieren sind.</p> <p>3522 - Eingangsschnittstellen verarbeiten </p> <p>Bei Einlesen von Adresssaten kam es unter bestimmten Umst\u00e4nden zu einer Fehlermeldung bzl. der Kundennummer. Dies wurde korrigiert und die Adressdaten k\u00f6nnen wieder ohne Fehler eingelesen werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#veranlagung_2","title":"Veranlagung","text":"<p>86 - Meldung vom FA </p> <p>Bei DTA-S\u00e4tzen die mit Satzart \"Adress\u00e4nderung\" vom Finanzamt geliefert werden, steht Ihnen die M\u00f6glichkeit \u00fcber den Button \"Adress\u00e4nderung\" zur Verf\u00fcgung die ge\u00e4nderten Adressstammdaten in die Personenkontenverwaltung (12a3) zu \u00fcbernehmen. \u00dcber die hellgelben Pfeile k\u00f6nnen die Daten einzeln \u00fcbernommen werden. F\u00fcr die Komplett\u00fcbernahme gibt es den dunkelgelben Pfeil. Zur schnelleren Bearbeitung der unterschiedlichen GWST-Meldungen gibt es im Meldungsdetailsfenster am unteren Rand Navigationspfeile.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/letzte_programmaenderungen.html#anlagenbuchhaltung","title":"Anlagenbuchhaltung","text":"<p>b33/ b34 - Buchung Anlageg\u00fcter/ Buchung Zusch\u00fcsse </p> <p>Nur zutreffend f\u00fcr Oracle Anwender: die Verbuchung der Abschreibung/ Aufl\u00f6sung funktioniert nun wieder korrekt. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html","title":"Programm\u00e4nderungen Release 4.1.0051","text":""},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html#programmanderungen-release-410051","title":"Programm\u00e4nderungen Release 4.1.0051","text":""},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html#allgemein","title":"Allgemein","text":""},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html#stammdaten","title":"Stammdaten","text":"<p>11 - Mandant </p> <p>F\u00fcr die Veranlagung wurde der neue Schalter V01 eingerichtet. Er erm\u00f6glicht eine Vorgabe f\u00fcr die Erstellung der Buchungsprotokolle der Veranlagung (Einzel- und Gesamtveranlagung).  Schalter: \u00a0\"Kein\" \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0- \u00a0 \u00a0 \u00a0 Es wird niemals ein Buchungsprotokoll erzeugt.   \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0\"IMMER\" \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0- \u00a0 \u00a0 \u00a0Es werden - wie in der bisherigen Funktionalit\u00e4t - immer Buchungsprotokolle erzeugt.   \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \"NUR VORSCHAU\" \u00a0 \u00a0- \u00a0 \u00a0 \u00a0 Es werden ausschlie\u00dflich Vorschau-Buchungsprotokolle erzeugt, Buchungsprotokolle ohne Vorschau-Charakter werden nicht angeboten.  Werden keine Buchungsprotokolle ben\u00f6tigt, so kann durch die neuen Schalterstellungen Zeit gespart werden.</p> <p>124 - Sachkontenverwaltung </p> <p>Die Kontenkopierfunktion kann nun auch f\u00fcr die Steuerart 1 verwendet werden. </p> <p>12a3 - Personenverwaltung  Debitoren und Kreditoren k\u00f6nnen nun mit gleicher Personenkontennummer angelegt werden. </p> <p>Der Parameter \"Name aufbereiten\" kann wieder aktiv und inaktiv gesetzt werden.</p> <p>Ist der Mandantenschalter F15 aktiv, wirkt beim Anlegen von Personenkonten eine Dublettenpr\u00fcfung. Durch diese Pr\u00fcfung soll verhindert werden, dass Personenkonten doppelt angelegt werden.</p> <p>12a8 - Auswertung Infotexte </p> <p>Es gab bis zum letzten Programmstand ausschlie\u00dflich die M\u00f6glichkeit, an der Personenkontennummer Informationen zu hinterlegen, welche auch jederzeit wieder l\u00f6schbar sind. Auf Kundenwunsch wurde die zus\u00e4tzliche M\u00f6glichkeit geschaffen, nicht l\u00f6schbare Texte zur Personenkontennummer zu erfassen. Hierf\u00fcr gibt es in der Informationsbox einen zus\u00e4tzlicher Reiter 'Kassenakte'. Diese Kassenakteneintr\u00e4ge werden als nicht l\u00f6schbare Eintragungen nachhaltig gespeichert.  Im Programm werden diese Eintr\u00e4ge im Men\u00fcpunkt '391 Personenkontenverwaltung' als Kassenakte sichtbar gemacht. Im Men\u00fcpunkt '12a8 Auswertung Infotexte' werden alle Informationen in einer gemeinsamen durchsuchbaren Liste gef\u00fchrt. </p> <p>1278 - Banken </p> <p>Link zur Bundesbankwebsite wurde aktualisiert, da diese umgezogen ist. Ab sofort f\u00fchrt der \u201eButton Bundesbank Webseite\u201c zu einer Google-Suche: \u201eBundesbank Zahlungsverkehr Download\u201c um von zuk\u00fcnftigen \u00c4nderungen seitens der Bundesbank unabh\u00e4ngig zu sein.</p> <p>127c - Verteilungsringe </p> <p>In den Verteilungsringen wurde das Steuerkennzeichen erg\u00e4nzt, sodass nun auch Kombinationen mit Sachkonten m\u00f6glich sind, welche die Steuerart beliebig (1) nutzen.</p> <p>128 - Adressverwaltung </p> <p>Es werden nun standardm\u00e4\u00dfig nur aktive Personenkonten im Men\u00fc 128 - Adressverwaltung in einer eindeutigen Person angezeigt. Wird die Option \"nur aktive Personenk.\" inaktiv gesetzt werden auch Debitoren und Kreditoren die inaktiv sind angezeigt. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html#planung","title":"Planung","text":"<p>21 - Neues Planjahr anlegen </p> <p>Bei der Ableitung von Planvarianten in einen DHH sind bisher die Folgejahre nicht ordentlich mit Werten gef\u00fcllt worden. Hier erfolgte eine Korrektur.</p> <p>22 - Planvarianten </p> <p>Die \u00dcbersicht zur Anlage der Buchungsstellen mit Ma\u00dfnahme (Kontotyp \"M\") wurde \u00fcberarbeitet. Neben dem Sachkonto (Darstellung pro Zeile) und dem Produkt (Darstellung pro Spalte), wird nun auch noch die Ma\u00dfnahme selbst in den Spalten unter dem entsprechenden Produkt eingegliedert. So ist eine \u00fcbersichtlichere Darstellungsweise zum Anlegen der Ma\u00dfnahmebuchungsstellen gegeben.</p> <p>242 - Ergebnisplan </p> <p>Die Spalte Sperre wird nun wieder korrekt ausgewiesen.</p> <p>245 - Bilanzplan </p> <p>Bei der Planung auf Bilanzkonten kam es zu einem Problem bei der Anzeige der zu planenden Bilanzkonten. Hierzu erfolgte eine \u00c4nderung.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html#buchung","title":"Buchung","text":"<p>311 - Einzelbuchungen </p> <p>Beim Weiterleiten einer Anordnung im IFR kann eine E-Mail Benachrichtigung versendet werden. Hierzu ist der Schalter F49 auf JA zu stellen. In der Systemverwaltung wurden zwei Systemparameter hinzugef\u00fcgt (Mail/Server Pflichtparameter, wenn man die Benachrichtigung nutzen m\u00f6chte und Mail/Port Optional, wenn der SMTP Port abweichend eingerichtet werden muss). Die Versendung der Mail muss ohne Nutzeridentifikation m\u00f6glich sein, d.h. f\u00fcr bekannte E-Mail-Konten darf kein Nutzer/Passwort vom Mail-Server verlangt werden. Es findet nur eine Default-Authentifizierung statt (Windows-Nutzer = Mail-Server-Nutzer)</p> <p>Eine Manuelle Steuereingabe ist wieder m\u00f6glich, wenn das Steuerkennzeichen entsprechend eingerichtet ist. </p> <p>Bei der Verbuchung von OP's mit BS 733, indem ein Personenkonto ohne Bankverbindung existiert, erfolgt jetzt eine Meldung, dass so eine Buchung nicht zugelassen ist.</p> <p>Mit dem BS 521 ist es nun m\u00f6glich Skonto zu erfassen. Dies wurde entwicklet, wenn der BS 521 als Umbuchungsschl\u00fcssel ( durch Aufteilung = 0\u20ac) verwendet wird. Wenn dieser genutzt werden soll, um auf eine andere BSt umzubuchen, wird das Feld Skonto nun ge\u00f6ffnet, sodass beim Bruttoumbuchen der Skontobetrag von der alten BSt weggebucht und auf die neue BSt gebucht wird.</p> <p>Es besteht ab sofort f\u00fcr die Buchungsmaske (Men\u00fc 311) sowie das Eingangs- und das Ausgangsrechnungsjournal die M\u00f6glichkeit einer sofortigen KLR-Verteilung der Buchungsbetr\u00e4ge mittels fester Verteilungsringe oder durch individuelle Verteilung. Dazu wird in den genannten Funktionen \u00fcber die Schaltfl\u00e4che (Auf- bzw. Verteilung) ein Dialogfenster zur Eingabe von Kostenstellen, Kostentr\u00e4gern, usw. ge\u00f6ffnet. Bei Verteilung auf beliebige KLR-Elemente f\u00fchrt der Abschluss der Buchung \u00fcber die Aufteilungsmaske (analog Splittbuchungen) und zeigt dort neben der klassischen Sollstellung auch alle entstehenden KLR-Buchungen (Buchungsschl\u00fcssel 90x). </p> <p>312 - Dauerbuchungen </p> <p>Es werden nun nur noch Dauerbuchungen angezeigt, die dem hinterlegten Budgetrecht entsprechen.</p> <p>Beim Buchen einer Dauerbuchung kann nun der Weiterleitungsvermerk mit gegeben werden.</p> <p>Bei Eigenschaften einer Dauerbuchung kann nun das Feld \"Anzahl Buchungen\" frei gelassen werden um zu kennzeichnen, dass es eine unbegrenzte Dauerbuchung ist. Mit \u00dcbernehmen wird automatisch in das Feld \"unbegrenzt\" geschrieben.</p> <p>313 - Sicherheitseinbehalt </p> <p>Wird ein Aufwand mit Aktiver Istversteuerung eingebucht, so wird dieses Merkmal k\u00fcnftig auch an den Sicherheitseinbehalt weitergegeben. Somit wird automatisch aus einem Istversteuerten OP, auch der OP des Sicherheitseinbehaltes istversteuert.</p> <p>314 - Stornobuchungen </p> <p>Die Stornierung von Eingangsrechnungen soll \u00fcber den Men\u00fcpunkt 52 durchgef\u00fchrt werden, deshalb wird die Stornierung von Eingangsrechnungen mit BS 511 im Men\u00fc 314 verhindert. Aktuell war es noch m\u00f6glich im Men\u00fc 314 Eingangsrechnungen mit BS 513 zu stornieren, hierzu erfolgte jetzt eine Anpassung des Programm, sodass dieses jetzt auch verhindert wird. </p> <p>35 - Schnittstellen </p> <p>Mit der neuen Standard-Schnittstelle V4 k\u00f6nnen unter anderem jetzt auch Mandate aus Fremdsystemen in das IFR \u00fcbernommen werden. </p> <p>351 - Einrichten </p> <p>Zum Einlesen der vom Finanzamt gelieferten DTA-GWST-Daten gibt es jetzt im Men\u00fc 351 eine neue Schnittstelle VeranGwDta zur Einrichtung .</p> <p>3521 - Schnittstelle - einlesen </p> <p>Beim Einlesen von Archikartdaten, die einen RAP beinhalten der keinen jahres\u00fcbergreifenden RAP-Zeitraum (z.B. 01.01.19 bis 15.12.2019) hat, kam es zu einer Fehlermeldung in der Schnittstelle. Hierzu erfolgte eine Korrektur der Schnittstellenpr\u00fcfung, damit ist jetzt das Einlesen solcher S\u00e4tze wieder gew\u00e4hrleistet.</p> <p>3522 - Schnittstelle - verarbeiten </p> <p>Bei Einlesen von Adresssaten kam es unter bestimmten Umst\u00e4ndern zu einer Fehlermeldung bzl. der Kundennummer. Dies wurde korrigiert und die Adressdaten k\u00f6nnen wieder ohne Fehler eingelesen werden.</p> <p>36 - Anordnungen </p> <p>In einigen F\u00e4llen funktionierte nach \"Abweisen\" einer Anordnung der \"L\u00f6sch-AO Druck\" nicht korrekt, dies wurde behoben. (Fehler AO-Druck Men\u00fc 52 | 311 | 36)</p> <p>F\u00fcr das Formular \"Anordnung\" wurde eine Vorlagenoption \"Duplexdruck\" implementiert.</p> <p>F\u00fcr den Listendruck wurde ein Fehler behoben, welcher den Freitext auf der Anordnungsliste zum Teil abgeschnitten hat.</p> <p>F\u00fcr Kunden mit DMS Es wurde eine M\u00f6glichkeit geschaffen, beim AO-Druck mit der Option nach Liste und Sortierung nach Buchungsstelle diese getrennt, nach Buchungsstelle, an das DMS zu \u00fcbergeben. Voraussetzung daf\u00fcr ist, dass der Mandantenschalter F45 auf Ja gesetzt wurde. Dies gilt vorerst nur f\u00fcr normale AO's (Men\u00fc 36). \u00a0F\u00fcr AO's aus dem ERJ sind noch weitere Systemanpassungen notwendig. Diese werden demn\u00e4chst umgesetzt.</p> <p>392 - Auskunft - Sachkonten </p> <p>In der Haushaltssatzung ist darauf zu achten, dass die letzte Festsetzung unter \u00a71 \"Ver\u00e4nderung des Bestandes an Zahlungsmitteln im Haushaltsjahr auf\" der Position 53 des Finanzhaushaltes entspricht. Derzeit wird hier der Wert analog Position 47 des Finanzhaushaltes ausgewiesen. Es wurde wegen dieser \u00c4nderung der Schattenmandant angepasst. Um die Aktualisierung gew\u00e4hrleisten zu k\u00f6nnen, ist in der Systemverwaltung der Schattenmandant zu aktualiseren und im IFR dann die Liste nochmals neu abzuleiten. </p> <p>3a2 - Kontoauszug - Abgleich </p> <p>Beim Einlesen von Kontoausz\u00fcgen die mit dem CAMT053-Format kommen, werden die Kontoauszugspositionen nicht mehr S/H-gerecht und nach Betrag sortiert in die Kontoauszugsverwaltung eingestellt. Um hier weiterhin eine M\u00f6glichkeit der Sortierung zu schaffen, wurden zwei Radiobutton (nach Position, nach S/H und Betrag) in die Selektionsmaske mit aufgenommen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html#op-bearbeitung","title":"OP-Bearbeitung","text":""},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html#auftragfaktura","title":"Auftrag/Faktura","text":"<p>51 - Auftragsverwaltung </p> <p>Wird bei einer Eingangsrechnung die mit Auftrag und Schlussrechnungskennzeichen eingegeben wurde, die dazu erstellte AO in der AO-Verwaltung (Men\u00fc 36) abgewiesen, so wird der darin gebundene reservierte Auftragswert nicht mehr den allgemein verf\u00fcgbaren Mittel gutgeschrieben sondern wieder dem Auftrag. Damit steht dieser Betrag f\u00fcr eine erneute Verbuchung mit Auftrag zur Verf\u00fcgung.</p> <p>52 - Eingangsrechnungsjournal </p> <p>Der Buchungskreis wird bei Erfassung einer Eingangsrechnung wieder korrekt vorgeblendet, wenn dieser in den Stammdaten hinterlegt ist.</p> <p>Die Istversteuerung kann nun auch im Eingangsrechnungsjournal, bei F\u00e4llen des innergemeinschaftlichen Erwerbs (Eigenschaft \"EG_Land\" im Steuerkennzeichen) durchgef\u00fchrt werden. Die Einhaltung der Vorschriften des Umsatzsteuergesetzes liegt hierbei ausschlie\u00dflich bei dem Anwender!</p> <p>F\u00fcr Kunden mit DMS Bei der Abfrage von Eingangsrechnungen aus dem DMS werden individuelle Spaltenverschiebungen zuk\u00fcnftig f\u00fcr jeden Nutzer abgespeichert. Beim erneuten Aufruf der Maske m\u00fcssen die Spalten daher nicht wieder neu verschoben werden. </p> <p>Es ist nun wieder m\u00f6glich, die Kopfdaten und bspw. den Buchungstext 2 einer Position im Eingangsrechnungsjournal zu \u00fcbernehmen, ohne dabei die Buchungsstelle angeben zu m\u00fcssen. Wird in der Position allerdings ein Rechnungsabgrenzungsposten angegeben, muss auch zwingend die Buchungsstelle mitgef\u00fchrt werden.</p> <p>54 - Ausgangsrechnungsjournal </p> <p>Eine Ausgangsrechnung mit Steuer kann nur gebucht werden wenn dies sowohl am Sachkonto als auch am Produkt hinterlegt ist.</p> <p>Das Layout des Reportes f\u00fcr Ausgangsrechnungen wurde optimiert. Zus\u00e4tzlich wurde der Ratenblock standardm\u00e4\u00dfig unter dem \"Unterem Bescheidtext\" positioniert und die neue Vorlagenoption \"Ratenblock vor Unterem Bescheidtext\" \u00a0hinzugef\u00fcgt. Au\u00dferdem kann das aktuelle Tagesdatum mittels der Vorlagen-Option \"drucke heute als Bescheid-Datum\" als Rechnungsdatum verwendet werden.</p> <p>Ausgangsrechnungen lassen sich ohne Positionen nicht mehr \"\u00dcbernehmen\" </p> <p>Im Datenstrom wurde das Kennzeichen \"SumOpOffen\" erg\u00e4nzt. In dieser Spalte werden offene Forderungen aus dem ARJ und der Fakturierung anhand der OP-Nummer AR.../FAK... als Summe dargestellt. Dieses Kennzeichen kann somit auf dem Report mittels Textbaustein verkn\u00fcpft werden.</p> <p>55 - Stammdaten </p> <p>Mengeneinheiten k\u00f6nnen an den Tarifen hinterlegt werden.</p> <p>Tarife k\u00f6nnen nun auch ohne Mengeneinheit erfasst werden, auch wenn zuvor eine Mengeneinheit hinterlegt war. Dies funktioniert sowohl am Tarif selbst \u00fcber Men\u00fc 55 als auch bei der Erfassung einer Ausgangsrechnung.</p> <p>Die G\u00fcltigkeit von Tarifgruppen und Tarifen kann anhand der Periode festgelegt werden. Dadurch ung\u00fcltige Tarife werden bei Stammdaten\u00fcbernahme ins n\u00e4chste Planjahr nicht ber\u00fccksichtigt. \u00a0 \u00a0</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html#auswertungen","title":"Auswertungen","text":"<p>613 - Quartalstatistik </p> <p>F\u00fcr KISA-Kunden Es gibt einen neuen Schalter K33 = Q-Statistik Druck-/Bearbeitungssperre. Dieser bewirkt, wenn er auf \"Ja\" steht, dass wenn man kein Admin-Nutzer ist, er im Men\u00fc 613 die beiden Button \"Buchungsstellen und \"Drucken\" ausblendet. Damit sind f\u00fcr den Nutzer nur noch die Pflege der Zeitbuchnummer und der Zusatzangaben m\u00f6glich. </p> <p>6223 - Kontoauszug </p> <p>Mit der neuen Vorlagen-Option \"Titel aus RTB8\" ist es nun m\u00f6glich individuelle \u00dcberschriften f\u00fcr einen Kontoauszug zu hinterlegen. Ist die Vorlagen-Option aktiv, wird der RTB \"Titel\" aus der Textbausteinverwaltung verwendet.</p> <p>6412 - Teilergebnisplan </p> <p>Beim Ausweis der Planerl\u00e4uterungstexte f\u00fcr Buchungsstellen mit Ma\u00dfnahmen kam es unter bestimmten Konstellationen vor, das er nicht alle Planerl\u00e4uterungstexte angezeigt hat. Dieser Fehler wurde behoben.</p> <p>6614 - Mahnvorschlag </p> <p>Es wurde der Ausweis der Vorlagenoption \"Zahlungspflichtiger anstelle Debitor drucken\" f\u00fcr diverse debitorische Reportvorlagen (b\u00fcrgerfreundliche Darstellung des Mahn-PK) eingebaut. </p> <p>6619 - Mahnnachdruck </p> <p>Wird im Filterfeld \"Vorschlagsnummer\" eine Nummer mit Platzhalter z.B. % oder * etc. eingegeben, kommt es nun nicht mehr zum Programmabsturz. </p> <p>671 - Umsatzsteuer - Journal </p> <p>In der Steuerbuchungsrecherche werden nun f\u00fcr die Spalten Steuer- und Buchungsperiode auch die Jahre mit angezeigt. Es werden immer alle Steuerbuchungen des angegebenen Steuerjahres angezeigt. Nun kann gefiltert werden, welche Buchungen hiervon buchhalterisch, aber in einem anderen HHJ stehen. Dies erleichtert die Abstimmarbeiten in Bezug auf die Umsatzsteuererkl\u00e4rung, sowie auf Abstimmung zwischen steuerlicher und buchhalterischer Sichtweise.</p> <p>F\u00fcr die Tabellenanzeige der Masken in den Men\u00fcpunkten 67* gilt nun: Verschobene und ausgeblendete Spalten bleiben \u00fcber die Programmschlie\u00dfung hinaus erhalten. Gruppierungen und Fixierungen werden wieder aufgehoben.</p> <p>672 - Umsatzsteuer - Meldungen </p> <p>Alle Istversteuerten F\u00e4lle waren bisher nicht mit Sollstellung im Men\u00fc 672 sichtbar. Erst mit Zahlung sind diese f\u00e4llig und kommen somit auch erst zu diesem Zeitpunkt in die ausstehenden Buchungen. Damit die Abstimmung zum Sachkonto trotzdem besser durchgef\u00fchrt werden kann, gibt es nun die Liste \"Nicht f\u00e4llige Steuer\". Hier werden Umsatzsteuer und Vorsteuer angezeigt, die noch nicht f\u00e4llig sind, aber auf dem Steuerkonto schon gebucht wurden.</p> <p>Wird in der Dauerfristverl\u00e4ngerung im Feld 23 eine \"1\" hinterlegt, wird daneben ein Button ge\u00f6ffnet. In diesem sind erg\u00e4nzende Angaben zum Feld 23 zu machen, damit die Dauerfristverl\u00e4ngerung erfolgreich \u00fcbermittelt werden kann.</p> <p>Mit Hilfe des Tagespasswortes kann nun das Kennzeichen 83 (Verbleibende Umsatzsteuer-Vorauszahlung) manuell ge\u00e4ndert werden und nach Wunsch, an die tats\u00e4chlich gebuchten Werte angepasst werden. Somit k\u00f6nnen Rundungsdifferenzen zwischen der Buchhaltung und tats\u00e4chlichen der Zahlung/Erstattung an das Finanzamt vermieden werden.</p> <p>Bei der Umsatzsteuer-Voranmeldung werden nun nur noch die Werte/ Kennzeichen \u00fcbermittelt, die tats\u00e4chlich gef\u00fcllt sind. Es werden somit keine 0-Werte mehr \u00fcbermittelt.</p> <p>69 - Gesetzliche Auswertungen </p> <p>F\u00fcr den Druck der Muster 11/12 (Ergebnis-/Finanzrechnung) gibt es eine neue Druck-Vorlagenoption f\u00fcr das Ausblenden der Spalte \"Planansatz des Haushaltsjahres\". Damit werden wir den Anforderungen der unterschiedlichen Pr\u00fcfer gerecht, die zum Teil auch f\u00fcr die Jahre &lt; 2014 diese Spalte bei der Pr\u00fcfung der Listen sehen m\u00f6chten.</p> <p>In der Haushaltssatzung ist darauf zu achten, dass die letzte Festsetzung unter \u00a71 \"Ver\u00e4nderung des Bestandes an Zahlungsmitteln im Haushaltsjahr auf\" der Position 53 des Finanzhaushaltes entspricht. Der Zeit wird hier der Wert analog Position 47 des Finanzhaushaltes ausgewiesen. Es wurde wegen dieser \u00c4nderung der Schattenmandant angepasst. Um die Aktualisierung gew\u00e4hrleisten zu k\u00f6nnen wird in der Systemverwaltung der Schattenmandant aktualisiert und im IFR kann die Liste nochmals neu abgeleitet werden. </p> <p>Das Muster 17 - \"\u00dcbersicht \u00fcber die aus Verpflichtungserm\u00e4chtigungen voraussichtlich f\u00e4llig werdenden Auszahlungen\" kann nun sowohl in TEUR \u00a0als auch in EUR gedruckt werden. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html#jahresabschluss","title":"Jahresabschluss","text":"<p>712 - Aktualisierung Stammdaten </p> <p>Zuk\u00fcnftig k\u00f6nnen die Kunden bestimmen welche Budgets ins Folgejahr (Men\u00fc 21 - Stammdaten) \u00fcbertragen werden sollen. Dazu besteht im Men\u00fc 141 die M\u00f6glichkeit, diese dementsprechend zu markieren.  Sollte ein Budget mit Planwerten als nicht \u00fcbertragbar f\u00fcr das Folgejahr gekennzeichnet werden, werden die beplanten Buchungsstellen im Hintergrund (KP_PLAN) ins Folgejahr \u00fcbertragen. Damit ist allerdings eine vorl\u00e4ufige Haushalts\u00fcbernahme (siehe Plan\u00fcbernahmeprotokoll) nicht mehr m\u00f6glich. Als Korrektur kann der Kunde dann: das fehlende Budget anlegen (Men\u00fc 141), die Buchungsstellen einem neuen Budget (Men\u00fc 23) zuordnen oder die Buchungsstellen aus der Planvariante (Men\u00fc 22) entfernen. Als Absicherung k\u00f6nnen schon einmal \u00fcbertragene Budgets nicht mehr ins Folgejahr \u00fcbernommen werden, wenn eine vorl\u00e4ufige Haushaltsf\u00fchrung im Folgejahr besteht.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html#veranlagung","title":"Veranlagung","text":"<p>11 - Mandant </p> <p>F\u00fcr die Veranlagung wurde der neue Schalter V01 eingerichtet. Er erm\u00f6glicht eine Vorgabe f\u00fcr die Erstellung der Buchungsprotokolle der Veranlagung (Einzel- und Gesamtveranlagung).  Schalter: \u00a0\"Kein\" \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0- \u00a0 \u00a0 \u00a0 Es wird niemals ein Buchungsprotokoll erzeugt.   \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0\"IMMER\" \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0- \u00a0 \u00a0 \u00a0Es werden - wie in der bisherigen Funktionalit\u00e4t - immer Buchungsprotokolle erzeugt.   \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \"NUR VORSCHAU\" \u00a0 \u00a0- \u00a0 \u00a0 \u00a0 Es werden ausschlie\u00dflich Vorschau-Buchungsprotokolle erzeugt, Buchungsprotokolle ohne Vorschau-Charakter werden nicht angeboten.  Werden keine Buchungsprotokolle ben\u00f6tigt, so kann durch die neuen Schalterstellungen Zeit gespart werden.</p> <p>151 - \u00a0Stammdaten-Veranlagung- Allgemeines  Die Aktualisierung der 'Finanzamtsliste von Deutschland', enthalten im Men\u00fc 151 erfolgt automatisiert \u00fcber den Releasewechsel. Finanz\u00e4mter die es nicht mehr gibt, werden nicht aus der Liste herausgel\u00f6scht, sondern mit dem Kennzeichen (hist.) versehen.</p> <p>8 - Veranlagung </p> <p>Aus der Gesamtveranlagung heraus besteht die M\u00f6glichkeit die Buchungsstapel einnahmeartenweise anzulegen, z.B. als 'VERAN_ASWE0202' , \u00a0'VERAN_ASWE0309'.</p> <p>F\u00fcr Buchungsstapel, die aus der Einzelveranlagung aufgebaut werden, bleibt es beim bisherigen Buchungsstapelnamen.</p> <p>Wenn Jahresbescheide erstellt werden, kann mittels Vorlagenoption der Kurzkontoauszug zugeschalten werden.</p> <p>81 - Einzelveranlagung </p> <p>Jahreswechselwerte f\u00fcr das Folgejahr k\u00f6nnen nur erfasst werden, wenn auch f\u00fcr das Folgejahr der Einnahmeartenrten-Stammsatz und die Tarife vorhanden sind.Der Ausweis der Mehrwertsteuer wurde in Layout L9 und L11 umgesetzt. Voraussetzung daf\u00fcr ist die korrekte Produkt/Sachkontenauswahl. </p> <p>Gewerbesteuerbescheide Werden im Block \"Gewerbesteuerveranlagung\" so viele Jahre dargestellt, dass ein Seitenwechsel erfolgt, so werden Angaben je Steuerjahr zusammengehalten, d.h. der gesamte Block des Jahres (= die 3 Zeilen: \"bisher\", neu\" und \"Wirtschaftsjahr\".) wird auf einer Seite ausgewiesen.  Werden in einem Steuerbescheid f\u00fcr mehr als 2 Jahre Zinsen festgesetzt, so werden die Zinsbl\u00f6cke in einer Tabelle dargestellt und der Erl\u00e4uterungstext zu den Zinsen wird nur einmalig am Ende des Zinsabschnittes angedruckt. Bei einem Seitenwechsel werden die Zinsbl\u00f6cke eines Steuerjahres zusammengehalten.  Im Gewerbesteuerbescheid wird auch f\u00fcr Raten Folgejahr \u00a0$19 Gewerbesteuergesetz ber\u00fccksichtigt.</p> <p>82 - Gesamtveranlagung </p> <p>Werden Bescheiddrucke nach Anschrift sortiert, erfolgt die Sortierung unter Ber\u00fccksichtigung des Auslands-Kennzeichens. Steht im Auslandskennzeichen ein D, so werden diese \u00a0wie Anschriften ohne \u00a0hinterlegtes Auslands-Kennzeichen (Inland) einsortiert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html#kreditedarlehen","title":"Kredite/Darlehen","text":"<p>a46 - Statistik </p> <p>Bei Ausweis der Kreditwerte in der Kreditstatistik kam es zu einem Anzeigefehler, was die aufgenommenen Kredite in einem Jahr betraf. Bei den Tilgungszahlungen f\u00fcr ein Jahr wurden zum Teil nicht die richtigen Werte ermittelt, wenn eine Sondertilgungsrate auf das gleiche Datum wie die letzte Kreditrate eingegeben wurde. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html#anlagebuchhaltung","title":"Anlagebuchhaltung","text":"<p>b126 - Stornierung </p> <p>Fehler behoben welcher bei der Stornierung von Umbuchungen in bestimmten Konstellationen ein einseitiges Storno von produzierte und daraus resultierend der AHK-Wert falsch darstellt wurde. </p> <p>b31 / b32 - Aktivierung / Buchung </p> <p>Der in den Stammdaten festgelegte Buchungskreis wird in den Men\u00fcs b31/ \u00a0b33 wieder vorbelegt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html#kosten-leistungsrechnung","title":"Kosten-/Leistungsrechnung","text":""},{"location":"aktuelles/releasehistorie/release4.1.0051/programmaenderungen_release_46.html#systemverwaltung","title":"Systemverwaltung","text":"<p>r6 - Zahlungsverkehr </p> <p>RZ-SEPA-ErstellungBei Erstellung der SEPA-Datei werden jetzt, falls es doch nach den vorherigen Pr\u00fcfungen noch ein fehlerhafter Satz (fehlende IBAN, negative Betr\u00e4ge im Gutschriftslauf, ...) bis hierher geschafft hat, die S\u00e4tze als fehlerhaft ins Protokoll geschrieben, aber die SEPA-Verarbeitung geht f\u00fcr den Mandanten und die Clearingstellen weiter.</p> <p>s12 - DMS-Konfiguration </p> <p>Die \u00dcbergabe der Felder Buchungstext 1/2 und Freitext aus der AO ans DMS wurde realisiert.</p> <p>s21 - Benutzerverwaltung </p> <p>Es besteht das Problem, dass im RZ-Betrieb (KISA) bei der Auswahl f\u00fcr den Weiterleitungsnutzer immer alle angelegten Nutzer zur Auswahl angeboten werden, da sie in der Nutzerverwaltung alle in einer Mandantengruppe hinterlegt sind. Jetzt kann man mandantenbezogene Mandantengruppen anlegen und die jeweiligen Nutzer mit seinen Rechten dort zuordnen. Zentrale \u00c4nderungen bei Nutzerrechten sind weiterhin pro Mandantengruppe m\u00f6glich.</p> <p>s31 - Releasewechsel </p> <p>Zuk\u00fcnftig kann die Aktualisierung der Finanzamtsliste von Deutschland, f\u00fcr die Veranlagung (Men\u00fc 151), \u00fcber den Releasewechsel durchgef\u00fchrt werden. Finanz\u00e4mter die es nicht mehr gibt, werden nicht aus der Liste herausgel\u00f6scht, sondern bekommen ein Kennzeichen (hist.)</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/installation_checkliste_relea4.html","title":"Installation Checkliste Release 4.1.0052","text":""},{"location":"aktuelles/releasehistorie/release4.1.0052/installation_checkliste_relea4.html#installation-checkliste-release-410052","title":"Installation Checkliste Release 4.1.0052","text":"<p>Vorg\u00e4ngerrelease ist Release 51</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/installation_checkliste_relea4.html#update","title":"Update","text":"<p>1. Alle SASKIA\u00ae.de IFR-Nutzer abmelden </p> <p>(auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 52.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/installation_checkliste_relea4.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>1. Releasewechsel 52 </p> <p>Nach herunterladen und installieren des Updates kann der Releasewechsel f\u00fcr Release 52 durchgef\u00fchrt werden. </p> <p>Durch Markieren des entsprechenden Punktes in der linken Tabelle werden die Punkte des Releasewechsels wie gewohnt in der rechten Tabelle dargestellt.</p> <ul> <li> <p>Datenbankstruktur anpassen. Interne Anpassung der Datenbankstruktur in der Datenbank. Dieser Releasewechselpunkt hat keine Auswirkung auf den aktuellen Datenbestand.</p> </li> <li> <p>Datenbank\u00e4nderungen Anpassung des Datenbestandes an die neue Relaeseversion.</p> </li> <li>Anpassung der Reportvorlagen. Installation von neuen und Entfernung von veraltenden Reportvorlagen.</li> <li>F\u00fcllen des Feldes VS_DTADATEN.AZ_FINAMT Aktualisierung der Finanzamtsstammdaten.</li> <li>GWST-Veranlagungsart AOM.AOZ l\u00f6schen und VZ anlegen Interne Anpassung der Veranlagungsarten.</li> <li> <p>Erg\u00e4nzung Prim\u00e4rschl\u00fcssen in Tabelle KB_ZWesen_P Interne Anpassung der Datenbank.</p> </li> <li> <p>Erg\u00e4nzung der RTB 2, 5 und 8 um die drei Freitexte Mit diesem Releasewechselpunkt werden neue Textbausteine zugelassen</p> </li> <li>Anrede-Mapping f\u00fcr Schnittstelle Avviso 52 installiert F\u00fcr Avviso ist ein Anredecode erforderlich, der entsprechend der im IFR verwendeten Anrede gebildet werden muss.</li> <li>Korrektur Fremdzugriff DMS auf Kreditoren Externe Zugriffsview f\u00fcr CC/Winyard wird angepasst.</li> <li>Mandantenspezifischen Bescheidlogos in Unterverzeichnisse verschieben Mandantenspezifische Logos (logo_1_0001.bmp) werden vom SaskiaServer\\Template Ordner in den mandantenspezifischen Ordner SaskiaServer\\Template\\0001 verschoben, dabei wird die Mandatennummer aus dem Datei-Name entfernt (neuer Name: logo_1.bmp).</li> </ul> <p>2. Aktualisierung des Schattenmandanten </p> <p>Mit Release 52 wird ein neuer Schattenmandant ausgeliefert, um die notwendigen gesetzlichen \u00c4nderungen (Muster, Konten, Produkte und Zahlwege) abzubilden. Hierf\u00fcr ist in der Systemverwaltung Men\u00fc s31 \u2013 Datenbankaktualisierung oder im IFR im Men\u00fc 124 \u2013 Sachkontenverwaltung der Schattenmandant zu aktualisieren. Folgende Punkte sind dabei zwingend auszuf\u00fchren:</p> <ul> <li>Hierarchie laden Listen laden Sachkonten laden Statistik ladenLaden der Stammdaten f\u00fcr die Statistik-Hierarchie S in den SchattenmandantUmsatzsteuervorbelegung Mandantenstamm HINWEIS:*  F\u00fcr das Muster 21 wurden Behelfskonten im Schattenmandant hinterlegt. Diese k\u00f6nnen zum bef\u00fcllen des 2. Blattes des Muster 21 herangezogen werden. Diese Konten sind im Kontenbereich der entsprechenden Positionszeilen zugeordnet (Daf\u00fcr m\u00fcssen die Listen nochmal neu aus dem Schattenmandant geladen werden.</li> </ul>"},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#letzte-programmanderungen","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#auslieferung-zum-09072019","title":"Auslieferung zum 09.07.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#buchen","title":"Buchen","text":"<p>36 - Anordnung Hinter dem Anordnungsbetrag befindet sich nun ein Soll- bzw. Haben-Kennzeichen. Dieses verweist auf die angegebene Buchungsstelle auf der Anordnung. Somit kann der Anwender sofort erkennen, ob auf der Buchungsstelle ein Zu- oder Abgang erfolgte.</p> <p></p> <p>Lediglich Storno-Buchungen werden auf der Anordnung mit negativem Betrag dargestellt. Die Buchungsinformation wird weiterhin SOLL an HABEN gelesen. Der angegebene Anordnungsbetrag wird mit dem Vorzeichen ausgegeben, mit dem er im Programm eingegeben wurde.</p> <p></p> <p>Sollte eine Eingabe \u00a0mehrerer Teilbuchungen mit sich bringen, wie bspw. bei einer Aufteilungsbuchung, so gibt es auch hier am Brutto-Betrag ein Soll- oder Haben-Kennzeichen. Dieses bezieht sich auf die Spalte \u201eBuchungsstelle\u201c in der Tabelle. </p> <p></p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#auftragfaktura","title":"Auftrag/Faktura","text":"<p>52 - Eingangsrechnungsjournal </p> <p>Mit der Checkbox \u201eAO-Formular\u201c k\u00f6nnen nun einzelne Eingangsrechnungen ausgew\u00e4hlt werden und durch die aktive Check-Box \u201eAO-Formular\u201c direkt mit dem Button \u201eBuchen\u201c AO-gedruckt werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#auslieferung-zum-02072019","title":"Auslieferung zum 02.07.2019","text":"<p>Wichtiger HInWEIS</p> <p></p> <p>F\u00fcr die korrekte Erstellung der Jahresstatistik 2018 ist die Einspielung dieses Programmstandes zwingend notwendig. Mit der M\u00f6glichkeit der CSV-Ausgabe wird der Vorgabe des StaLa entsprochen. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#stammdaten","title":"Stammdaten","text":"<p>12a3 - Personenkontenverwaltung </p> <p>SEPA-Mandatsschreiben:  Soll die R\u00fcckantwort f\u00fcr eine Mandatswerbung nicht an die Anschrift der werbenden Gemeinde, sondern an eine abweichende Adresse (z.B. bei Verwaltungsgemeinschaften) gehen, dann kann f\u00fcr die Reportvorlage 'F00073' \u00a0des jeweiligen Mandanten \u00fcber den Reportbaustein 'RTB_7' eine abweichende Adresse vorgegeben werden. Die Mandatswerbung ist in diesen F\u00e4llen mit Vorlagenoption 'R\u00fccksendeadresse aus RTB_7' zu erstellen. Diese Option sollte f\u00fcr diese Vorlage und die jeweiligen Mandanten \u00a0\u00fcber das Men\u00fc 1y2 voreingestellt werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#buchen_1","title":"Buchen","text":"<p>311 - Einzelbuchung </p> <p>Beim Einf\u00fcgen von neuen Aufteilungspositionen in der Zwischenbuchungsmaske, konnte es passieren, dass man die Aufteilungsbuchung verbuchen konnte obwohl der Aufteilungsbetrag noch nicht wieder vollst\u00e4ndig erreicht war. Dieser Fehler wurde behoben.</p> <p>36 - Anordnung Der Anordnungsbetrag bezieht sich immer auf die Buchungsstelle (Nicht auf die Gegenbuchungsstelle). Dies kann dazu f\u00fchren, dass der Wert negativ dargestellt wird, obwohl er vom Anwender positiv eingegeben wurde. Das Programm rechnet je nach Soll/Haben-Kennzeichen bei Soll-Konten= Soll- Haben UND bei Haben-Konten=Haben-Soll.</p> <p>Die Buchungsinformation ist in jedem Fall \u201eSOLL an HABEN\u201c zu lesen. Der angezeigte Buchungswert, entspricht dem in der Buchungsmaske eingegebenen Wert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#auswertung","title":"Auswertung","text":"<p>6522 - Teilfinanzrechnung A </p> <p>Die Summen der Jahresrechnungsstatistik k\u00f6nnen nun wieder korrekt im CSV-Format ausgegeben werden.</p> <p>6614 - Mahnvorschlag </p> <p>\u00dcber die neue Druckoption \"mit Druck der Einzugserm\u00e4chtigung\" kann jetzt an den Mahnbescheid noch die Vorlage zum Ausf\u00fcllen der Einzugerm\u00e4chtigung angeh\u00e4ngt werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#auslieferung-zum-25062019","title":"Auslieferung zum 25.06.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#auswertung_1","title":"Auswertung","text":"<p>6612 - Lastschriftvorschlag </p> <p>Bezugnehmend auf das Geldw\u00e4schegesetz gab es im Bereich der DTAUS\u2013Erstellung n\u00f6tige \u00c4nderungen im IFR, welche Schlussendlich zur NICHT\u00fcbergabe der Lastschriftinformation in die DTAUS f\u00fchren kann. Zur Erl\u00e4uterung: Nach der SEPA-Umstellung, war es n\u00f6tig, in den Adressen den Kontoinhaber manuell nachzupflegen.  Ist dies bis heute nicht geschehen, werden bei solchen Adressen bei Erzeugung eines Lastschriftlauf, Betr\u00e4ge gr\u00f6\u00dfer 1000,00 \u20ac nicht mit an die DTAUS weitergegeben.  Dies wurde mit diesem Update wieder ge\u00e4ndert, sodass es hierbei keine Probleme mehr wird.  Beachten Sie bitte, dass Sie die notwendigen Einpflegungen der Kontoinhaber in den Mandaten (Kontoverbindungen) ggf. nachholen. </p> <p>6614 - Mahnvorschlag </p> <p>Statt \"Debitor\" oder \"Zahlungspfllichtiger\" kann nun auch \"F\u00fcr:\" als Vorlagen-Option f\u00fcr den Druck von Mahnbescheiden ausgew\u00e4hlt werden. Dabei ist zu beachten, dass kein H\u00e4kchen bei: \"Zahlungspflichtiger anstelle Debitor drucken\" gesetzt ist. Wenn dies der Fall ist, wird die Auswahl \"F\u00fcr:\" ignoriert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#auslieferung-zum-14062019","title":"Auslieferung zum 14.06.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#planung","title":"Planung","text":"<p>246 - Pflege Planerl\u00e4uterungstexte </p> <p>Die Druckkategorien der Plan-Texte, insbesondere die internen \"Infos...\" \u00a0im Men\u00fc 246 sind mit Hilfe der IFR-Fachberatung erweiterbar und k\u00f6nnen anschlie\u00dfend genutzt werden.Eine separate Programmfunktion f\u00fcr eine Neuanlage einer neuen Druckkategorie ist derzeit nicht vorgesehen. Durch die flexible Implementierung weiterer INFO-Druckkategorien, besteht z.B. bei einer dezentralen Planerfassung die M\u00f6glichkeit, dass die Fach\u00e4mter Hinweise hinterlegen k\u00f6nnen und in einer anderen Kategorie kann die Finanzverwaltung entsprechende eigene Bemerkungen erfassen. Beides ist anschlie\u00dfend im Men\u00fc 246 \u00fcber die Druckfunktion auswertbar.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#auftrag-faktura","title":"AUFTRAG / FAKTURA","text":"<p>5.2 - Eingangsrechnungsjournal </p> <p>Zur Vereinheitlichung der Nebenbuchwerke und Optimierung des elektronischen Rechnungsworkflows, k\u00f6nnen nun Eingangsrechnungen im ERJ mit dem Button \"Buchen\" festgesetzt werden. Alle festgesetzten Anordnungen k\u00f6nnen somit direkt mit Bet\u00e4tigung des \"AO-Druck\" im Men\u00fc 36 ohne nochmaliges markieren gedruckt werden. Mit diesem Umbau ergab sich eine \u00c4nderung der Handhabung im Eingangsrechnungsjournal, dies betrifft die Button \"AO-Druck\" und \"Buchen\". Eine n\u00e4here Erkl\u00e4rung finden Sie unter folgendem Link:  Handlings\u00e4nderung   oder aus dem entsprechenden Men\u00fcpunkt mit der F1-Taste.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#veranlagung","title":"Veranlagung","text":"<p>Veranlagung - Allgemein </p> <p>Der Ausweis des Kurzkontoauszugs auf den Steuer-/Abgabebescheiden erfolgt entsprechend der gew\u00e4hlten Option 'Kontoauszug'</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/letzte_programmaenderungen2.html#systemverwaltung","title":"SYSTEMVERWALTUNG","text":"<p>s31 - Releasewechsel </p> <p>Der Releasewechselpunkt \"Anrede-Mapping f\u00fcr Schnittstelle Avviso 52 installiert\" muss durchgef\u00fchrt werden. </p> <p>Der Schattenmandant sollte noch einmal aktualisiert werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html","title":"Programm\u00e4nderungen Release 4.1.0052","text":""},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html#programmanderungen-release-410052","title":"Programm\u00e4nderungen Release 4.1.0052","text":""},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html#allgemein","title":"Allgemein","text":"<p>DMS </p> <p>Mit Release 52 wurde das sp\u00e4te Scannen von Zusatzdokumenten, also das Hinzuf\u00fcgen weiterer elektronischer Unterlagen zu einem Vorgang mit bereits vorhandenen DMS-Dokument(en), umgesetzt.  Dazu wird im Dialogfenster zur Anzeige vorhandener DMS-Dokumente \u00fcber den neuen Button \"+\" in das Filesystem verzweigt, um beliebige Dateiformate in die betreffende elektronische Akte aufzunehmen. Durch diesen Vorgang erh\u00e4lt das Zusatzdokument einen eigenen Zuordnungssatz und ist von da an jederzeit im IFR aufrufbar. Das Hochladen der Datei in das DMS erfolgt mit den Methoden der DMS-API und nutzt zur Ablage den Pfad bzw. den Ordner des bereits existierenden Dokuments. \u00a0</p> <p>Allgemein </p> <p>Es wurde ein Fehler behoben, welcher bei Benutzung der Filterfunktion in den bisherigen IFR-Tabellen (Rechtsklick) zum Programmabsturz f\u00fchrte, diese kann nun wieder uneingeschr\u00e4nkt genutzt werden. </p> <p>011 - Aufgabenverwaltung </p> <p>Die Aufgabenverwaltung wurde im Bereich \"Eingang\" und \"Ausgang\" um die Kategorie \"Erledigte\" erweitert. Nachdem Aufgaben, Termine usw. als \"Erledigt\" markiert wurden (gr\u00fcner Haken), werden diese automatisch in die Kategorie \"Erledigte\" verschoben. Dadurch wird zuk\u00fcnftig eine bessere \u00dcbersichtlichkeit, besonders im Zusammenspiel mit der \u00c4nderungsanzeige, gew\u00e4hrleistet.</p> <p>Das L\u00f6schen von Aufgaben/ Terminen usw. funktioniert nun wieder korrekt. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html#stammdaten","title":"Stammdaten","text":"<p>11 - Mandant </p> <p>Der Schalter F44 (Soll-Haben gerechtes Buchen) l\u00e4sst sich nun jahresbezogen einstellen und wirkt nicht mehr jahres\u00fcbergreifend.</p> <p>Neuer Schalter A61 \u201eJ/N AfA-Modus 2018 (nur Sachsen)\u201c zur Festlegung nach welchem Prinzip, die Neuregelung des Haushaltsausgleiches ab 2018 (betrifft nur die s\u00e4chsischen Kommunen), innerhalb der Anlagenbuchhaltung umgesetzt werden soll. Die Schalter Stellung: \u201eJa\u201c= neues Prinzip ab Release 51 und \u201eNein\u201c= bisheriges Prinzip ab Release 49 (Details in der Rubrik Anlagebuchhaltung). Der Schalter wird mit dem Releasewechsel f\u00fcr die s\u00e4chsischen Anwender ab dem Haushaltsjahr 2018 (Planjahr wird nicht ber\u00fccksichtigt) automatisch auf \u201eJa\u201c gestellt. Wenn nicht nach dem neuen Prinzip gearbeitet werde soll, so ist der Schalter auf \u201eNein\u201c zu stellen.  \u00a0 \u00a0</p> <p>1y1 - Textbausteine </p> <p>Im Men\u00fcpunkt 1y1wurde die Formatierung von Texten folgenderma\u00dfen verbessert: Das Absatzkennzeichen kann zugeschalten werden.  Wenn neue Textbausteine angelegt werden, wird au\u00dferdem die voreingestellte Schriftart vorgeblendet. Zu finden ist diese Schriftart unter \"Fenster -&gt; Eigenschaften -&gt; Standardschriftart -&gt; f\u00fcr RTF-Texte\". </p> <p>1y2 - Vorlagen </p> <p>Im \"Men\u00fc 1y2 - Vorlagen\" kann \u00fcber den Button \"Jobs\" die Ausf\u00fchrung von Veranlagungsl\u00e4ufen (Men\u00fc 82) gesteuert werden, ob diese auf dem Client-PC oder Serverseitig ausgef\u00fchrt werden.</p> <p>Um ein besseres Handling f\u00fcr die Steuerung der Druckvorlagen\u00e4nderungen zu erreichen, gibt es jetzt in der Systemverwaltung unter FR -&gt; DRUCK -&gt; VORLOPT einen neuen Systemparameter. Damit wird bestimmt wer die \u00c4nderungen an den Druckvorlagenoptionen \u00fcbernehmen darf. \u00a0 \u00a0 \u00a0 \u00a0</p> <p>152 - Einnahmearten </p> <p>Option \"Druck kann entfallen\" wurde \u00a0in die Sammeleinnahmearten eingearbeitet.</p> <p>128 - Adressverwaltung </p> <p>Es wurde eine Anzeige integriert, welche den Briefkopf der eingetragenen Daten als Vorschau darstellt.</p> <p>12a3 - Personenkontenverwaltung </p> <p>Beim Anlegen eines Kreditors, vergibt das Programm nun auch wieder im Buchstabenbereich korrekt die n\u00e4chste freie Nummer.</p> <p>Bei der Suche nach PK-Nummern wird das vorgegebene Auslandskennzeichen ber\u00fccksichtigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html#planung","title":"Planung","text":"<p>21 - Neues Planjahr anlegen </p> <p>Eine in einem Vor-HH-Jahr abgespeicherte Liquidit\u00e4tsanzeige mit manuell angelegten Positionen, kann jetzt in dem aktuellen HH-Jahr ausgew\u00e4hlt werden. Damit ist jetzt die \u00dcbernahme der individuell erstellten Gliederung von einem HH-Jahr ins n\u00e4chste m\u00f6glich.</p> <p>241 - Budget\u00fcbersicht - Planwerte </p> <p>Es kann nun auch mit der Ma\u00dfnahme gefiltert werden.</p> <p>Das L\u00f6schen eines Budgets wurde durch eine Pr\u00fcfung verhindert, wenn es in den Planbuchungsstellen zu der Konstellation kam, dass die Buchungsstelle nicht mehr planbar war, aber noch ein Budget zugeordnet hatte. Auftreten kann so eine Datenkonstellation wenn im Men\u00fc 22 in der Planvariante die Buchungsstelle abgehakt wird ohne vorher im Men\u00fc 23 die Budgetzuordnung zu l\u00f6sen.</p> <p>Es wurden die Spalten \"Ansatz Vorjahr\" und \"Rechnungsergebnis Vorvorjahr\" erg\u00e4nzt.</p> <p>242 - Ergebnisplan </p> <p>Per Option k\u00f6nnen die IST-Werte des Vorjahres als Spalte mit eingeblendet werden. Bei Benutzung der Option ist auf eine ordentliche Selektion der zu planenden Buchungsstellen zu achten, da die Ermittlung der IST-Werte unter Umst\u00e4nden sehr lang dauern kann.</p> <p>Es kann nun auch mit der Ma\u00dfnahme gefiltert werden.</p> <p>243 - Ma\u00dfnahmenplan </p> <p>F\u00fcr den Ausweis der f\u00fcr Investitionen geplanten Kredite (KREDFIN) bei Doppelhaushalt, k\u00f6nnen jetzt auch die Kreditwerte f\u00fcr das 2. Doppelhaushaltjahr im Plan eingegeben werden. Weiterhin erfolgte eine Korrektur des Reports, f\u00fcr den Ausweis der Kredite unter Nachrichtlich.</p> <p>244 - Finanzplan </p> <p>Per Option k\u00f6nnen die IST-Werte des Vorjahres als Spalte mit eingeblendet werden. Bei Benutzung der Option ist auf eine ordentliche Selektion der zu planenden Buchungsstellen zu achten, da die Ermittlung der IST-Werte unter Umst\u00e4nden sehr lang dauern kann.</p> <p>245 - Bilanzplan </p> <p>Per Option k\u00f6nnen die IST-Werte des Vorjahres als Spalte mit eingeblendet werden. Bei Benutzung der Option ist auf eine ordentliche Selektion der zu planenden Buchungsstellen zu achten, da die Ermittlung der IST-Werte unter Umst\u00e4nden sehr lang dauern kann.</p> <p>263 - Budgetanpassungen </p> <p>Bei Planungsbuchungen von Bilanz-Quellkonten mit 2 angehangenen FR-Konten wird bei Budgetumbuchungen und Inanspruchnahmen von Mitteln ausschlie\u00dflich das erste angehangene FR-Konto gebucht. Damit wird eine korrekte Verf\u00fcgbarkeitsdarstellung gew\u00e4hrleistet.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html#buchung","title":"Buchung","text":"<p>311 - Einzelbuchungen </p> <p>Die Verteilungsringe wurden in FIBU-Verteilung umbenannt.</p> <p>Saldenvortr\u00e4ge k\u00f6nnen nun auch mit Produkt gebucht werden. ACHTUNG: Anwender sollten genau wissen warum sie solch eine Buchung t\u00e4tigen.</p> <p>Bei Zahlungsbuchungen (BS 6 / 7) ist jetzt die Korrektur des Skontobetrages m\u00f6glich. Das ist vorallem notwendig, wenn sich durch die Zahlung mehrere Einzel_OP's mit Skonto in einer Gesamtsumme abzgl. Skonto, eine Rundungsdifferenz beim angesetzten Gesamtskonto gegen\u00fcber der Summe aus den Einzelskonto ergeben hat. </p> <p>Bei Schlatereinstellung \"Ja\" f\u00fcr den Schalter F44 (Soll-Haben gerechtes Buchen) f\u00fchrte es bei Stornierungsbuchungen mit BS 513 dazu, dass die Verf\u00fcgbarkeitsanzeige nicht korrekt dargestellt wurde. Die Verf\u00fcgbarkeit verdoppelte sich. Der Fehler wurde korrigiert.</p> <p>Bei der Verbuchung kam es zu einem Problem, wenn man nach Auswahl des Schwebeposten den Buchungsschl\u00fcssel, z.B. von 220 auf 221, nochmal ge\u00e4ndert hat. Um dies zuk\u00fcnftig zu vermeiden, werden jetzt bei \u00c4nderung des Buchungsschl\u00fcssels die Felder Buchungsbetrag und Schwebeposten geleert.</p> <p>In der Buchungsmaske konnte es beim Wechsel zwischen 2 PK's, nach Auswahl des OP's passieren, dass er den OP-Betrag des vorherigen PK's beim nachfolgenden PK vorgeblendet hat. Hierzu erfolgte eine Programmkorrektur, die dieses Verhalten nicht mehr zul\u00e4sst. </p> <p>313 - Sicherheitseinbehalt </p> <p>Das Abweisen von Sicherheitseinbehalten funktioniert nun wieder korrekt.</p> <p>Beim Stornieren von Sicherheitseinbehalten wird das Feld f\u00fcr die Angabe des Stornierungsbetrags nach dem AO-Druck geleert, um versehentlich doppelte Stornierungsbuchungen zu vermeiden.</p> <p>Der Fehler beim Stornieren von Sicherheitseinbehalten, wenn der Schalter F44 auf \"Ja\" f\u00fcr Soll-Haben-gerechetes Buchen eingestellt ist, wurde behoben.</p> <p>32 - Tagesabschluss </p> <p>Bei Erstellung von Zahll\u00e4ufen (Men\u00fcpunkt 6622) mit der Option \"\u00dcberzahlungen mit einbeziehen\" kann es immer mal wieder passieren, dass bei einem PK am Ende ein negativer \u00dcberweisungsbetrag \u00fcbrig bleibt. Bisher f\u00fchrte das neben der Auszifferung zur Erstellung einer negativen Zahllaufposition im Men\u00fc 32. Hierzu erfolgte eine \u00c4nderung hinsichtlich des \"Warntextes\" beim Best\u00e4tigen des Zahllaufes und das jetzt nur noch die Auszifferung vorgenommen wird. </p> <p>33 - Buchungsstapel </p> <p>Bei Bagatellbereinigungsbuchungen wurde f\u00fcr die Buchungen mit BS 6* im Buchungsstapel nicht das H\u00e4ckchen beim richtigen Status V = verbuchbar gesetzt, sondern bei U = unbest\u00e4tigte AO. Hierzu erfolgte eine Korrektur. </p> <p>3522 - Verarbeiten </p> <p>Mit Hilfe des Buttons \"Bemerk. bearb.\" kann nun an jeder verarbeiteten Schnittstelle eine Bemerkung erfasst werden. Es \u00f6ffnet sich f\u00fcr die Erfassung ein Eingabedialog, dieser umfasst 200 Zeichen.</p> <p>Nach der Reaktivierung der Steuerart 1 in der Sachkontenverwaltung, musste jetzt auch eine Anpassung der Pr\u00fcfungen f\u00fcr die Steuerkennzeichen in der Standard-Schnittstelle vorgenommen werden. Bei Steuerart 0/2 erfolgt eine Pr\u00fcfung, so wie bisher, ob das Steuerkennzeichen in der Schnittstelle mit dem im Sachkonto \u00fcbereinstimmt. Nur f\u00fcr Steuerart 1 (beliebiges Steuerkennzeichen) gibt es keine Pr\u00fcfung mehr, hier verbucht er die Schnittstellendaten mit dem Steuerkennzeichen so wie er Sie bekommt. </p> <p>36 - Anordnungen </p> <p>Im Men\u00fc 36 sowie 52 werden zur Weiterleitung keine inaktiven Nutzer mehr angezeigt. Die Weiterleitung kann daher nur noch an aktive Nutzer erfolgen. </p> <p>Unter SQL-Server wird das AO-Formular f\u00fcr Stundungsvorg\u00e4nge wieder korrekt erstellt.</p> <p>391 - Personenkonten </p> <p>In der Personenkontenauskunft ist die Beauskunftung der kameralen PK-Buchungen (pro F\u00e4lligkeit und Einzelbuchungen) wieder m\u00f6glich.  Die gleiche Auskunft steht auch im Men\u00fc 81-Einzelveranlagung in der Gewerbesteuer zur Verf\u00fcgung.</p> <p>Niederschlagungen werden nun besser in der Personenkonteninformation dargestellt. Es wird die entsprechende OP-Nummer angezeigt und wann diese f\u00e4llig war sowie die zugeh\u00f6rige Belegnummer der Niederschlagung. Somit ist die Recherche der Niederschlagung einfacher.</p> <p>Wurden Mahnsperren am Personenkonto gesetzt, wurde bisher nur angezeigt, dass eine Mahnssperre vorliegt. Die Kommentare und das Befristungsdatum werden in der Personenkontenauskunft mit R52 zus\u00e4tzlich angezeigt.</p> <p>Der Kassenakteneintrag wurde um die Spalte Nutzer erg\u00e4nzt, an jedem Eintrag stehen nunmehr automatisch der Nutzer und das Datum. Das letzte Nutzungsdatum der Info-Box wird unter 'zuletzt ge\u00e4ndert' vermerkt.</p> <p>Im Reiter \"Doppische OP's' wurde das Feld \"Freitext\" um die Angabe der Auftragsgeber-IBAN erg\u00e4nzt, wenn es sich um eine Zahlungseingangsbuchung aus der Kontoauszugsverbuchung handelt. An der grundlegenden Aufteilung des Verwendungszwecks auf Buchungstext1,2 und Freitext hat sich nichts ge\u00e4ndert. Durch diese Zusatzinformastion ist es jetzt m\u00f6glich bei Zahlungseing\u00e4ngen innerhalb der Kontoauszugsverbuchung auch direkt in der Personenkontenauskunft die verwendete Bankverbindung zu erkennen. </p> <p>Mit R52 werden zum besseren \u00dcberblick in der Personenkontenauskunft unter Men\u00fcpunkt 391 gebuchte Stundungen angezeigt. Dem Anwender wird aufgelistet, welche Stundungen zum entsprechenden PK vorhanden sind. Weitergehende Informationen liefert Men\u00fcpunkt 42 \"Stundung\", die Bearbeitung der Stundung erfolgt nach wie vor an gleicher Stelle. Ob gestundete OP ausgeglichen sind, ist weiterhin in den OP-Auswertungen sowie in 422 \"Stundung - Drucklist\"e ersichtlich. \u00a0</p> <p>394 - Budget\u00fcbersicht </p> <p>In der Budget\u00fcbersicht k\u00f6nnen die Finanzrechnungskonten bei Auswahl des Produkts oder der Ma\u00dfnahme wieder mit angezeigt werden. Hierf\u00fcr kann der Haken \u201einkl. FR-Konten\" gesetzt werden. Nach dem Auktualisieren der Maske erscheinen dann die zugeh\u00f6rigen FR-Konten. Beim Wechsel des Haushaltsjahres bleiben die eingegeben Suchkriterien nun erhalten. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html#op-bearbeitung","title":"OP-Bearbeitung","text":"<p>41- Aufrechnung (ehemals: Auszifferung) </p> <p>Die Men\u00fcpunkte 41 und 6617 wurden in Aufrechnung (bisher Auszifferung) umbenannt. Au\u00dferdem wurden die damit verbunden Reports entsprechend angepasst, um Missverst\u00e4ndnisse in der externen Korrespondenz zu vermeiden. Es besteht ein Unterscheid zwischen den Begrifflichkeiten \u201eAuszifferung\u201c (Geldfluss welcher den Bankbestand ver\u00e4ndert) und \u201eAufrechnung\u201c (kein Geldfluss - nur Ausgleich Offener Posten). </p> <p>421 - \u00a0Bearbeiten </p> <p>Wenn der Schalter F44 auf \"JA\" f\u00fcr Soll-Haben gerechtes Buchen gestellt ist, wies eine Stundungsanordnung bislang einen Anordnungsbetrag aus. Die Stundungsanordnung wurde nun so angepasst, dass auf der Anordnung ein Anordnungsbetrag wieder mit \"Null\" ausgewiesen wird. F\u00fcr die Zinsen gibt es weiterhin eine separate Anordnung \u00fcber den Zinsbetrag.</p> <p>431 - AdV-Verwaltung </p> <p>Nach einem AdV-Widerruf blieb in der Personenkontenauskunft (391) im Reiter \"OP's\" in der Spalte \"Teilsperrung\" der bis dahin gesperrte AdV-Betrag stehen. Die Spalte wird nun korrekt zur\u00fcckgesetzt.</p> <p>Bei der Berechnung der Zinsmonate kam es in einer bestimmten Konstellation zu einem Fehler. Der Fehler trat auf, wenn bei angelegter AdV eine komplette Zahlung des OP's erfolgte und ein Teilbetrag wieder storniert wurde.</p> <p>Die AdV ist mit R52 nebenbuchwerksf\u00e4hig gemacht worden. Das hei\u00dft, gedruckte sowie best\u00e4tigte AO's k\u00f6nnen abgewiesen werden, wenn sie nicht im Haushalt verbucht werden sollen: Im Men\u00fcpunkt 431 wurde deshalb der Button 'Best\u00e4tigung-AO' \u00a0ersetzt durch den Button 'Buchen'. Au\u00dferdem kommt der Button 'AO-Druck' hinzu, nach dem 'Buchen' sowie anschlie\u00dfendem 'AO-Druck' muss die AO entgegen vorherigem Programmstand \u00fcber den Men\u00fcpunkt 36 best\u00e4tigt werden. Dies entspricht der allgemeinen Arbeitsweise mit dem Nebenbuchwerk.  In diesem Zusammenhang gibt es die neu geschaffene M\u00f6glichkeit, AO's \u00fcber Men\u00fc 36 nicht nur zu best\u00e4tigen, sondern auch abzuweisen. Das Abweisen der AO erm\u00f6glicht das erneute Bearbeiten der AdV, wenn beispielsweise die AdV im falschen Haushaltsjahr angelegt oder falsche OP gew\u00e4hlt wurden. Dies war bisher f\u00fcr den Anwender nicht m\u00f6glich. </p> <p>Allgemeiner buchungstechnischer Hinweis R52:  Liegen die Aussetzung und das Ende der Aussetzung im selben Haushaltsjahr, wird in beiden F\u00e4llen gegen das Aufwands-Konto \"Wertberichtigung\" gebucht. Ist das HH-Jahr f\u00fcr das Ende der Aussetzung gr\u00f6\u00dfer als das Aussetzungsjahr, erfolgt die Verbuchung bei Beendigung der AdV wie bisher auf einem Ertrags-Konto. \u00a0 \u00a0 </p> <p>Wenn ein Erlass oder eine AdV in dem Jahr aufgehoben werden, in dem sie auch eingebucht wurden, erfolgt keine Ergebnisverl\u00e4ngerung mehr. Diese Buchungen werden dann gegen Aufwand gebucht. In den Folgejahren erfolgt eine Aufhebung dann wieder gegen das hinterlegte Ertragskonto.</p> <p>Die Bescheiderstellung war bei Widerruf stets m\u00f6glich, bei Erfolg jedoch nicht. Mit R52 \u00a0k\u00f6nnen bei Bedarf Bescheide \u00fcber das erfolgreiche Ende der Aussetzung der Vollziehung, wie nachfolgend erl\u00e4utert, erstellt werden:  Alle Anwender dr\u00fccken den Taster 'Drucken / Buchen' und somit wird der Erfolg sofort verbucht, der 'AO-Druck' wird m\u00f6glich und best\u00e4tigt wird \u00fcber Men\u00fc 36. F\u00fcr die speziellen Anwendungsf\u00e4lle, in denen gedruckte Beendigungs-Bescheide ben\u00f6tigt werden, ist der Taster 'Drucken / Buchen' noch einmal zu bet\u00e4tigen. Die wiederholte Bet\u00e4tigung erzeugt einen Bescheid \u00fcber das Ende der Aussetzung. In der \u00dcbersicht wird der Status der AdV angezeigt. Das Abweisen von gedruckten AO's \u00a0erm\u00f6glicht das erneute Bearbeiten als Erfolg oder Widerruf. </p> <p>441 - Niederschlagung </p> <p>Wenn bei einer durchgef\u00fchrten Niederschlagung im Anschluss die zugeh\u00f6rige AO abgewiesen wurde, wurde der Status des niedergeschlagenen OP's nicht richtig zur\u00fcckgesetzt (Men\u00fc 391 \u00a0--&gt; OP-Sperre blieb erhalten, Haken Niederschlagung). Damit wurde diese abgewiesene Niederschlagung weiterhin in der Wertberichtigungsliste (Men\u00fc 443) aufgef\u00fchrt und er konnte nicht erneut Niedergeschlagen werden. Niederschlagungen werden beim Abweisen der Anordnungen wieder ordnungsgem\u00e4\u00df zur\u00fcckgesetzt.</p> <p>443 - Wertberichtigungsliste </p> <p>Auf der Wertberichtigungsliste wird nun das urspr\u00fcngliche Soll mit ausgewiesen.</p> <p>46 - Sperren </p> <p>Die Maske des Fensters \"OP-Sperren\" wurde vergr\u00f6\u00dfert.</p> <p>48 - Vollstreckung </p> <p>Beim Erstellen eines Vollstreckungslaufes gibt es nun ein weiteres Filterfeld \"Einnahmearten\".  Beim Bearbeiten eines Vollstreckungslaufes gibt es nun folgende neue Selektionsfelder: Einnahmeart, Buch.-Schl., Sollbuchungen, Habenbuchungen.</p> <p>F\u00fcr die richtige \u00dcbergabe der Personen an Avviso ist es notwendig in der Schnittstelle das Mapping vor zu nehmen. In diesem Mapping wird festgelegt ob die Anrede auf eine nat\u00fcrliche oder eine juristische Peron hinweisen soll. Dies kann im Men\u00fcpunkt 351 \u00fcber den Button \"Mapping ...\" eingerichtet werden. Dabei steht der Wert 0 f\u00fcr juristische Person und der Wert 1 f\u00fcr nat\u00fcrliche Person.</p> <p>Beim Protokoll f\u00fcr die AVVISO-\u00dcbergabe (Report FR_20201_VOLLSTRECKUNG.MRT) wurde die Einnahmeart sowie das Mahndatum erg\u00e4nzt. Bei Zahlungen (KZ ZA) kann per Vorlagenoption au\u00dferdem noch die F\u00e4lligkeit zus\u00e4tzlich zum Buchungsdatum mit ausgewiesen werden.</p> <p>491 - Erlass Bearbeiten </p> <p>Der Report f\u00fcr Erlass wurde angepasst, hier ist nicht mehr von AdV die Rede, sondern richtigerweise von einer Verzichtserkl\u00e4rung.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html#auftragfaktura","title":"Auftrag/Faktura","text":"<p>52 - Eingangsrechnungsjournal </p> <p>Im Men\u00fc 36 sowie 52 werden zur Weiterleitung keine inaktiven Nutzer mehr angezeigt. Die Weiterleitung kann daher nur noch an aktive Nutzer erfolgen. </p> <p>Um auf die m\u00f6gliche Doppelerfassung von Rechnungen zu vermeiden, pr\u00fcft das Eingangsrechnungsjournal bei der Erfassung auf m\u00f6gliche Dubletten. Existiert zum gew\u00e4hltem Kreditor bereits ein Beleg mit identischer Rechnungsnummer (OP-Nummer), wird durch das Programm jetzt ein entsprechender Hinweis ausgegeben. Die Erfassung kann dann wahlweise abgebrochen oder fortgesetzt werden.</p> <p>Werden im ERJ in einer Rechnung mehrere Positionen mit Istversteuerung belegt, kommt k\u00fcnftig nur noch eine Sicherheitsabfrage nach der Verschiebung des Vorsteuerabzugs.</p> <p>Anordnungen k\u00f6nnen nun direkt aus dem Men\u00fc gedruckt werden. Mit Bet\u00e4tigung des Buttons \"AO-Druck\" \u00f6ffnet sich direkt das Men\u00fc f\u00fcr den AO-Druck, die AO kann nun gedruckt werden. Mit diesem Umbau ergab sich eine \u00c4nderung der Handhabung im Eingangsrechnungsjournal, dies betrifft die Button \"AO-Druck\" und \"Buchen\". Eine n\u00e4here Erkl\u00e4rung finden Sie unter folgendem Link:  Handlings\u00e4nderung </p> <p>54 - Ausgangsrechnungsjournal </p> <p>Mit R52 ist es m\u00f6glich geworden, im Men\u00fcpunkt 55 Musterrechnungen anzulegen und diese als Vorlage f\u00fcr die Rechnungslegung unter Men\u00fcpunkt 54 zu verwenden.  Des weiteren kann im Mp. 54 eine Rechnung zum Muster deklariert werden, welche eine Musterbelegnummer erh\u00e4lt. Die 'F\u00e4lligkeit' kann als Datum oder auch als Frist eingegeben werden.  Die vorbelegte Frist 'F\u00e4lligkeit in Tagen' betr\u00e4gt 14 Tage und ist individuell \u00e4nderbar. Das Belegdatum der Musterrechnung wird mit dem aktuellen Datum vorbelegt und ist ebenfalls \u00e4nderbar, in diesem Zusammenhang sind die Auswirkungen auf die individuell festgelegten Leistungsperioden zu beachten.</p> <p>Der \"AbbucherStati\" im Textbaustein-Datenstrom wird jetzt korrekt gesetzt (0), nur wenn eine Bankverbindung statt eines SEPA-Mandates am Debitor hinterlegt wurde.</p> <p>Mit R52 sind Freitexte m\u00f6glich. Daf\u00fcr wurden im Men\u00fcpunkt 54 zus\u00e4tzliche Tabellenreiter entwickelt: individuelle Betreff/Titel-texte sowie individuell bef\u00fcllbare Zusatztexte: \u00fcber und unter dem Berechnungsblock.  Die Freitexte k\u00f6nnen bei Bedarf individuell beschrieben werden, wobei die Positionen zur Rechnung nach wie vor zwingend auszuf\u00fcllen sind.</p> <p>Es k\u00f6nnen Duplikate von Rechnungen erzeugt werden, welche auch gleichzeitig ge\u00f6ffnet sein d\u00fcrfen.  Das Bl\u00e4ttern zwischen ge\u00f6ffneten Rechnungen und Musterrechnungen ist erm\u00f6glicht worden. \u00a0</p> <p>Individuelle Rechnungen k\u00f6nnen \u00fcber die Freitexte erstellt werden.  F\u00fcr diese speziellen F\u00e4lle der Rechnungslegung sind die Positionen zu bef\u00fcllen, jedoch kann bei Bedarf der Berechnungsblock auf der gedruckten Rechnung ausgeblendet werden.  Die Einrichtung der individuell gestalteten Rechnungen stellen Spezialf\u00e4lle der Rechnungslegung dar und sind kein Standard. Die g\u00fcltigen Rechnungslegungsvorschriften sind zu beachten. </p> <p>Wenn Ausgangsrechnungen weitergeleitet werden sollen, wird dies \u00fcber den Men\u00fcpunkt 36 AO-Druck erm\u00f6glicht.</p> <p>Werden im Men\u00fcpunkt 54 gebuchte Rechnungen storniert, erhalten sie je nach Bearbeitungsstufe den Status STORNIEREN oder STORNIERT.  Der zugeh\u00f6rige Beleg erh\u00e4lt ab dem R52 den Stempel  in roter Farbe. Der Anwender bekommt somit einen Storno-Beleg f\u00fcr diese Rechnung.  Sollte die Storno-AO abgewiesen werden, erfolgt der Rechnungsdruck gem\u00e4\u00df dem vorherigen Status gebucht, demzufolge ohne den Stempel . (Wir empfehlen zum Zwecke der Kontrolle sowie des eindeutigen Beleg-Nachweises, vor dem STORNIEREN die gebuchte Rechnung nochmals auszudrucken und danach zu stornieren.) </p> <p>Wird die F\u00e4lligkeit als Datum eingegeben, berechnen sich die Tage auf Basis des Belegdatums.  Wird die F\u00e4lligkeit in Tagen eingegeben, berechnet sich das F\u00e4lligkeitsdatum unter der Ber\u00fccksichtigung der Sonn- und Feiertagsregelung anhand des Belegdatums.</p> <p>Im Bearbeiten der Rechnung werden die Tarife und Tarifgruppen in der Auswahlbox sortiert angeboten. </p> <p>55 - Stammdaten </p> <p>Mit R52 ist es m\u00f6glich geworden, im Men\u00fcpunkt 55 Musterrechnungen anzulegen und diese als Vorlage f\u00fcr die Rechnungslegung unter Men\u00fcpunkt 54 zu verwenden.  Des weiteren kann im Mp. 54 eine Rechnung zum Muster deklariert werden, welche eine Musterbelegnummer erh\u00e4lt. Die 'F\u00e4lligkeit' kann als Datum oder auch als Frist eingegeben werden.  Die vorbelegte Frist 'F\u00e4lligkeit in Tagen' betr\u00e4gt 14 Tage und ist individuell \u00e4nderbar. Das Belegdatum der Musterrechnung wird mit dem aktuellen Datum vorbelegt und ist ebenfalls \u00e4nderbar, in diesem Zusammenhang sind die Auswirkungen auf die individuell festgelegten Leistungsperioden zu beachten.</p> <p>\"\u00dcbernehmen-Button\" wird aktiv vorgeblendet, sobald man einen erfassten Tarif mit einer TG aus der Tariferfassung heraus verkn\u00fcpfen will. Tarif l\u00f6schen: Tarif ausw\u00e4hlen--&gt; rotes Kreuz bet\u00e4tigen--&gt; Meldung wollen sie wirklich l\u00f6schen--&gt; JA--&gt; Tarif ist gel\u00f6scht----&gt; Kein zus\u00e4tzliches \u00dcbernehmen mehr notwendig!</p> <p>Wird die F\u00e4lligkeit als Datum eingegeben, berechnen sich die Tage auf Basis des Belegdatums.  Wird die F\u00e4lligkeit in Tagen eingegeben, berechnet sich das F\u00e4lligkeitsdatum unter der Ber\u00fccksichtigung der Sonn- und Feiertagsregelung anhand des Belegdatums.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html#auswertungen","title":"Auswertungen","text":"<p>613 - Quartalsstatistik </p> <p>Bei der Erstellung der Quartalsstatistik wird bei Verwendung der Option \"Werstellungsdatum\" jetzt auch der Buchungsschl\u00fcssel 111 korrekt \u00a0ber\u00fccksichtigt.</p> <p>6223 - Kontoauszug </p> <p>Nachdem es jetzt m\u00f6glich ist, einen Debitor bzw. Kreditor unter der gleichen Personenkontennummer anzulegen, kann es beim Druck des Kontoauszuges zu dem Problem kommen, dass die OP-Daten von beiden PK's ausgewiesen werden. Hierzu erfolgte eine Korrektur, sodass jetzt nach Auswahl des Personenkonto durch Abtauchen in die Personenkontenverwaltung nur die Kontoauszugsdaten des gew\u00e4hlten Personenkonto kommen.</p> <p>Beim Druck des Kontoauszuges, mit der Option Duplex beim Drucker, kam es beim Lochen des Ausdruckes zu dem Problem, dass die Betr\u00e4ge in der letzten Spalte auf der R\u00fcckseite des Ausdrucks \u00a0ggf. nicht mehr zu sehen waren, dies ist nun behoben.</p> <p>6224 - \u00a0Kontoauszug intern </p> <p>Auch im internen Kontoauszug wird das Budget-Recht der Nutzer ausgewertet.</p> <p>631 - Bilanz </p> <p>Es gibt einen neuen Mandantenschalter \"F50 = Bilanz Ausweis Fehlbetrag\" \u00fcber den die Berechnung und Ausweis auf der Bilanz von Gewinn/Verlust bzw. der Vortrag aus Vorjahren gesteuert werden kann. Dieser unterschiedliche Ausweis ist bei der Unterscheidung zwischen Kommunen und Eigenbetrieben notwendig. Erforderlich hierzu ist die Auswahl von J oder V in der Listenpositionsverwaltung (Men\u00fc 123).</p> <p>635 - Sonderposten\u00fcbersicht </p> <p>Der Report f\u00fcr Muster 21 - Seite 2 wurde dahingehend angepasst, da\u00df jetzt der Ausweis f\u00fcr den DHH enthalten ist. </p> <p>6611 - OP-Listen </p> <p>Wurde in der Info-Box die Kassenakte gef\u00fcllt, so erscheint mit R52 auf der OP-Liste in der Spalte Mahnsperre ein kleines i. Dieses beinhaltet die Information f\u00fcr den Anwender, dass die Info-Box (Info-Text oder Kassenakte) \u00a0gef\u00fcllt ist. </p> <p>6612 - Lastschriftenvorschlag </p> <p>Laut EU-Geldtransferverordnung, sind bei Lastschriften \u00fcber 1.000\u20ac aus dem nicht EU/EWR-Raum, die Adressdaten des Zahlungspflichtigen im SEPA-Datensatz mitzugeben. Hierzu erfolgte eine Erweiterung bei der Bildung des XML-Datentr\u00e4gers.</p> <p>6614 - Mahnvorschlag </p> <p>\u00dcber die neue Druckoption \"mit Druck der Einzugserm\u00e4chtigung\" kann jetzt an den Mahnbescheid die Vorlage zum Ausf\u00fcllen der Einzugserm\u00e4chtigung angeh\u00e4ngt werden.</p> <p>Im Mahnbescheid (Report FR_20102_MAHNBESCHEID.MRT) kann \u00fcber die Vorlagenoption \"Freitext der Hauptforderung ausgeben\" der Freitext mit angesteuert werden. Dieser erscheint bei Auswahl hinter dem Buchungstext 2 im Mahnbescheid. Standardm\u00e4\u00dfig wird der Freitext nicht mit ausgegeben. Bei Bedarf ist diese Vorlagenoption auszuw\u00e4hlen. </p> <p>Beim Druck der AO-Liste f\u00fcr die Nebenforderungen der Mahnung, wurde das Forderungs-/Verbindlichkeitskonto nicht im Buchungssatz mit ausgewiesen. Hierzu erfolgte eine Korrektur.</p> <p>6617 - Aufrechnung (ehemals Auszifferung) </p> <p>Die Men\u00fcpunkte 41 und 6617 wurden in Aufrechnung (bisher Auszifferung) umbenannt. Au\u00dferdem wurden die damit verbunden Reports entsprechend angepasst, um Missverst\u00e4ndnisse in der externen Korrespondenz zu vermeiden. Es besteht ein Unterscheid zwischen den Begrifflichkeiten \u201eAuszifferung\u201c (Geldfluss welcher den Bankbestand ver\u00e4ndert) und \u201eAufrechnung\u201c (kein Geldfluss - nur Ausgleich Offener Posten).</p> <p>6622 - Zahlungsvorschlag </p> <p>Bei Erstellung von Zahll\u00e4ufen mit der Option \"\u00dcberzahlungen mit einbeziehen\" kann es immer mal wieder passieren, dass bei einem PK am Ende ein negativer \u00dcberweisungsbetrag \u00fcbrig bleibt. Bisher f\u00fchrte das neben der Auszifferung zur Erstellung einer negativen Zahllaufposition im Men\u00fc 32. Hierzu erfolgte eine \u00c4nderung hinsichtlich des \"Warntextes\" beim Best\u00e4tigen des Zahllaufes und das jetzt nur noch die Auszifferung vorgenommen wird. </p> <p>671 - Journal </p> <p>Im Umsatzsteuermodul k\u00f6nnen die Ansichten ver\u00e4ndert werden, in dem mit Rechtsklick auf die Tabelle, die Soll- und Haben-gerechte Ansicht ausgeblendet wird. Somit wird die Spalte des Nettobetrages in Soll- und Haben aufgeteilt. </p> <p>672 - Meldungen </p> <p>F\u00fcr die Bildung der Steuerperiode bei Buchungen mit Buchungsschl\u00fcssel \"421\" wird jetzt wie bei Buchungsschl\u00fcssel \"411\", das OP-Belegdatum daf\u00fcr zu Grunde gelegt. Bei der Angabe einer abweichenden Leistungsperiode, wird diese als Steuerperiode bei einer Forderungsbuchung herangezogen.</p> <p>68 - Freie Auswertungen </p> <p>Die Liste \"Auswertung Gesperrte Belege\" \u00a0FS12A4 kann wieder ohne Fehlermeldung gedruckt werden. </p> <p>Die bisherige Auswertung FS3004 wird ersatzlos gestrichen, die Auswertungen FS3001 und FS3002 wurden in Auswertung FS0022 integriert.</p> <p>69 - Gesetzliche Drucklisten </p> <p>Die R\u00fcckstellungs\u00fcbersicht in nun auch f\u00fcr den Doppelhaushalt abbildbar.</p> <p>Die 2-seitige Druckaufbereitung des Musters 21 ist jetzt sowohl \u00fcber das Men\u00fc 69 als auch einzeln \u00fcber die Men\u00fcpunkte 6411 (Seite1) und 635 (Seite 2) m\u00f6glich. Aufgrund der problematischen Datenbeschaffung bei Kunden mit mehreren offenen Jahresabschl\u00fcssen kann die Wertbef\u00fcllung von Seite 2 nur durch Hilfskonten mit entsprechenden Planwerten bzw. durch Nachbearbeitung z.B. in MS-WORD erfolgen.</p> <p>In den Gesetzlichen Drucklisten wird das Auswahlfeld \"Budget\" beim Druck von \"Teilplan- und rechnungslisten\" f\u00fcr die Datenaufbereitung ber\u00fccksichtigt. Dadurch ist es auch m\u00f6glich, eine konkrete Auswahl eines Produktes oder Produktbereiches vorzunehmen.</p> <p>Die Teilhaushaltslisten k\u00f6nnen nun mit einzelnen Teilhaushalten gedruckt werden. Daf\u00fcr wird mit dem Parameter \"Auswahl\" auf die entsprechenden Teilhaushalte eingegrenzt.  Die Planungslisten M18 bis M20 sind auch f\u00fcr den Doppelhaushalt druckbar. Pro Positionszeile/Kontenzeile werden 2 Unterzeilen angezeigt in denen die Werte der jeweiligen Haushaltsjahre ersichtlich sind.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html#jahresabschluss","title":"Jahresabschluss","text":"<p>72 - Kassenjahreswechsel </p> <p>Ab sofort gibt es im Men\u00fcpunkt des Kassenjahreswechsels eine Pr\u00fcfung \"Korrektur der Zahlwegskonten - Kontierung n\u00f6tig\". Diese stellt fest, ob es die Zahlwegskonten mit den zugeh\u00f6rigen FR-Konten bereits im Folgejahr gibt und zeigt ggf. einen Fehler an. </p> <p>731 - \u00a0RAP-Verwaltung </p> <p>Anordnungen k\u00f6nnen nun direkt aus dem Men\u00fc gedruckt werden. Mit Bet\u00e4tigung des Buttons \"AO-Druck\" \u00f6ffnet sich direkt das Men\u00fc f\u00fcr den AO-Druck, die AO kann nun gedruckt werden</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html#veranlagung","title":"Veranlagung","text":"<p>81 - Einzelveranlagung </p> <p>Anordnungen k\u00f6nnen nun direkt aus dem Men\u00fc gedruckt werden. Mit Bet\u00e4tigung des Buttons \"AO-Druck\" \u00f6ffnet sich direkt das Men\u00fc f\u00fcr den AO-Druck, die AO kann nun gedruckt werden. </p> <p>In der Einzelveranlagung ist es, wenn gew\u00fcnscht, mit R52 m\u00f6glich, Tarifbezeichnung 1 und Tarifbezeichnung 2 anzeigen zu lassen.  Die notwendige Voraussetzung daf\u00fcr ist im Men\u00fc 152 zu treffen. Bei Bedarf bitte Kontakt mit der Fachberatung aufnehmen.</p> <p>In Abh\u00e4ngigkeit vom neuen Mandantenschalter 'F37 - vollst\u00e4ndiger Ausweis weiterer Bescheidempf\u00e4nger' \u00a0besteht die M\u00f6glichkeit, die Angaben zu den weiteren Bescheidempf\u00e4ngern/vom Bescheid betroffenen Personen zu anonymisieren. F37 \u00a0= Ja, Ausweis der kompletten Adresse (wie bisher) = Standard F37 = Nein, nur noch Ausweis von Anrede - Titel - \u00a0Name </p> <p>Wird f\u00fcr die Gewerbesteuerbescheide die Option 'Druck Kontoauszug' im Men\u00fc 152 gesetzt, so wird dieser auf den Bescheiden ausgewiesen. F\u00fcr Jahresbescheide ist daf\u00fcr zus\u00e4tzlich die Vorlagen-Option 'Kontoauszug bei Jahresbesch.' \u00a0zu setzen. Wird der Bescheid \u00fcber die Historik neu gedruckt (d.h. kein Aufruf des hinterlegten Archivsatzes), wird der Kontoauszug nur beim letzten erstellten Bescheid ausgewiesen.</p> <p>Auf \u00c4nderungsbescheiden wird bei erteiltem Mandat die Bankverbindung ausgewiesen, die zum zeitlich n\u00e4chsten F\u00e4lligkeitsdatum verbindlich ist.</p> <p>Die Debitorenbezeichnung in den Stammdaten-Einstellungen f\u00fcr die Einnahmearten kann dazu verwendet werden, um den Satz 'Ihre Steuerpflicht endet' in 'Ihre Zahlungspflicht endet' \u00e4ndern zu k\u00f6nnen. Handelt es sich um die Einnahmeart AS und GW, so bleibt die Bezeichnung 'Ihre Steuerpflicht endet' erhalten. Sollte es sich um die Einnahmeart SB oder WE handeln, so wird sich der Satz jetzt nach der Bezeichnung Debitor richten.</p> <p>82 - Gesamtveranlagung </p> <p>Im \"Men\u00fc 1y2 - Vorlagen\" kann \u00fcber den Button \"Jobs\" die Ausf\u00fchrung von Veranlagungsl\u00e4ufen (Men\u00fc 82) gesteuert werden, ob diese auf dem Client-PC oder Serverseitig (RZ-Jobs) ausgef\u00fchrt werden. </p> <p>Anordnungen k\u00f6nnen nun direkt aus dem Men\u00fc gedruckt werden. Mit Bet\u00e4tigung des Buttons \"AO-Druck\" \u00f6ffnet sich direkt das Men\u00fc f\u00fcr den AO-Druck, die AO kann nun gedruckt werden</p> <p>In der j\u00e4hrlichen Festsetzung der Vorauszahlungsbescheide der Gewerbesteuer im Rahmen der Jahressollstellungsarbeiten ist es jetzt m\u00f6glich, nur Vorauszahlungsbescheide der Abgabepflichtigen zu drucken, die noch kein SEPA-Mandat erteilt haben.  Im Reiter \"Drucken\" der Funktion \"Gesamtveranlagung\" steht daf\u00fcr die neue Option \"Bescheide ohne aktives Mandant\" zur Verf\u00fcgung. Werden zus\u00e4tzlich zu dieser Option auch die Optionen \"nur ver\u00e4nderte Bescheide\" und /oder \"oder Vorg\u00e4nger \u00c4nd.bescheid\" aktiviert, werden zus\u00e4tzlich diese Bescheide f\u00fcr die Abbucher erzeugt.</p> <p>Wird f\u00fcr die Gewerbesteuerbescheide die Option 'Druck Kontoauszug' im Men\u00fc 152 gesetzt, so wird dieser auf den Bescheiden ausgewiesen. F\u00fcr Jahresbescheide ist daf\u00fcr zus\u00e4tzlich die Vorlagen-Option 'Kontoauszug bei Jahresbesch.' \u00a0zu setzen. Wird der Bescheid \u00fcber die Historik neu gedruckt (d.h. kein Aufruf des hinterlegten Archivsatzes), wird der Kontoauszug nur beim letzten erstellten Bescheid ausgewiesen.</p> <p>Auf \u00c4nderungsbescheiden wird bei erteiltem Mandat die Bankverbindung ausgewiesen, die zum zeitlich n\u00e4chsten F\u00e4lligkeitsdatum verbindlich ist.</p> <p>844 - Freie Auswertungen </p> <p>Mit Rel. 52 wurde im Men\u00fcpunkt #68 die freie Auswertung 'Objekte ohne Veranlagung' um einen Parameter erweitert. Er erm\u00f6glicht 2 verschiedene Sortierungen. Je nach Anwendungsfall kann die gew\u00fcnschte Liste nach Personenkonto oder \u00a0nach Steuerjahr sortiert werden. \u00a0</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html#kreditedarlehen","title":"Kredite/Darlehen","text":"<p>a2 - Freigabe/Buchungen </p> <p>Anordnungen k\u00f6nnen nun direkt aus dem Men\u00fc gedruckt werden. Mit Bet\u00e4tigung des Buttons \"AO-Druck\" \u00f6ffnet sich direkt das Men\u00fc f\u00fcr den AO-Druck, die AO kann nun gedruckt werden</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html#anlagebuchhaltung","title":"Anlagebuchhaltung","text":"<p>Allgemein - Anlagenbuchhaltung </p> <p>Es wurde ein Fehler behoben, welcher in einigen seltenen Konstellation dazu f\u00fchren konnte, dass Neuerfassungen von Anlageg\u00fctern und Zusch\u00fcssen nachdem AnBu-Jahresabschluss im vorher abgeschlossenen AnBu-Jahr noch zul\u00e4ssig waren.</p> <p>Neuer Schalter A61 \u201eJ/N AfA-Modus 2018 (nur Sachsen)\u201c zur Festlegung nach welchem Prinzip, die Neuregelung des Haushaltsausgleiches ab 2018 (betrifft nur die s\u00e4chsischen Kommunen), innerhalb der Anlagenbuchhaltung umgesetzt werden soll. Die Schalter Stellung: \u201eJa\u201c= neues Prinzip ab Release 51 und \u201eNein\u201c= bisheriges Prinzip ab Release 49 (Details nachstehend). Der Schalter wird mit dem Releasewechsel f\u00fcr die s\u00e4chsischen Anwender ab dem Haushaltsjahr 2018 (Planjahr wird nicht ber\u00fccksichtig) automatisch auf \u201eJa\u201c gestellt. Wenn nicht nach dem neuen Prinzip gearbeitet werde soll, so ist der Schalter auf \u201eNein\u201c zu stellen.  \u00a0 \u00a0</p> <p>Umsetzung der Neuregelung des Haushaltsausgleiches ab 2018 </p> <p>Mit dem Release 51 wurde innerhalb der Anlagenbuchhaltung ein neues Prinzip zur Neuregelung des Haushaltsausgleiches ab 2018 realisiert und im Release 52 weiter ausgebaut.</p> Vergleich neues Prinzip ab Release 51 Bisheriges Prinzip ab Release 49 Kennzeichnung bei Neuerfassung von \u201eNeuanlageg\u00fctern\u201c/ \u201eNeuzusch\u00fcssen\u201c vorhanden (\u201eAfA 2018\u201c) nicht vorhanden, sondern nur \u00fcber Kommunale Gruppe m\u00f6glich (bisherige Gruppe +500) Dopplung der Bilanzkonten * entf\u00e4llt die VR-Kontierung muss nicht angepasst werden, folgende Konten m\u00fcssen mit der Eins an 5. Stelle angelegt sein (im Schattenmandant vorhanden): - Aufwand- /Ertragskonto f\u00fcr Abg\u00e4nge - Ertr\u00e4ge aus Zuschreibungen- Aufwand Apl.- &amp; Sonder-AfAz.B. Buchung Abgang \u201eNeuanlagegut\u201c neues Konto (513910 statt 513900) wird automatisch vorgeschlagen neues AfA-Konto wird automatisch gefunden z.B.:aus 471100 wird 471110aus 316100 wird 316110 Wichtig das an der 5. Stelle die Eins steht zur korrekten Abbildung des Musters 21 notwendig mit der entsprechenden VR-Kontierung (5. Stelle eine Eins \u2013 im Schattenmandant vorhanden) Switch \u201eAltanlage\u201c/ \u201eNeuanlage\u201c * durch Wechsel des AfA-Kontos in der Maske \u201eBilanzrechtlich-AfA\u201c mit Eingabe der Periode (analog zur \u201eneuen Gesamtnutzungsdauer\u201c), nachdem * Selbstverweis des Switches in den \u201eBewegungen\u201c, evtl. Nachdruck zur Anzeige des Restbuchwertes f\u00fcr sp\u00e4tere Umbuchung in die R\u00fccklageein oder mehrere verkn\u00fcpfte Zusch\u00fcsse k\u00f6nnen automatisch mit geswitcht werden keine neue Inventar- / Zuschussnummer * nachdem Wechsel kann die eigentliche Buchung durchgef\u00fchrt werden, welche den Wechsel zum Neuanlagegut begr\u00fcndet!WICHTIG: der Wechsel l\u00e4sst sich nicht r\u00fcckg\u00e4ngig machen! durch Umbuchung von Anlagegut und Zuschuss mit Anpassung des Bilanzkontos sowie der Kommunalen Gruppe unter Vergabe einer neuen Inventar- / Zuschussnummer Filterm\u00f6glichkeiten * m\u00f6gliche Filter \u201eAfA 2018\u201c:\u201eAlle\u201c\u201enur Neue\u201c\u201enur Umgestellte\u201c\u201eNeue und Umgestellte\u201c\u201eAlte, nicht umgestellte\u201c in den Men\u00fcs: b11 - b21 - b31 - b33 - b34 - b611 - Anlagennachweis b611: Gegen\u00fcberstellung von \u201eSwitch-Gut\u201c mit Auswahl der Sortierung \u201eSachkonto mit AfA-Konto\u201c nur nach Bilanzkonto und Kommunaler Gruppe bzw. AfA-Konto <p>Wichtig  der Switch des AfA-Kontos kann nur erfolgen, wenn die Abschreibung im entsprechenden Haushaltsjahr noch nicht gebucht wurde bzw. m\u00fcsste diese f\u00fcr die entsprechenden G\u00fcter erst storniert werden. Die Stornierung ist auch einzeln m\u00f6glich \u00fcber b41 Berechnung f\u00fcr Anlagegut/ Zuschuss Periode 0 \u00e0 anschlie\u00dfend Verbuchung \u00fcber b33/ b34 \u00e0 erzeugt in b35 Stornobuchung der Abschreibung (negativer Betrag in Finanzbuchhaltung). Wurde eine Anlagegut/ Zuschuss f\u00e4lschlicherweise geswitcht, kann dies nur durch die Fachberatung korrigiert werden. \u00a0  Ob eine Zuschussverkn\u00fcpfung geswitcht (\u201eAfA-2018\u201c) wurde, l\u00e4sst sich jetzt an der einzelnen Verkn\u00fcpfung erkennen im Men\u00fc b11 \u201eBruttozuschuss\u201c\u00e0 \u201eBearbeiten\u201c oder Men\u00fc b21 \u201eInventarzuordnung\u201c\u00e0 \u201e\u00c4ndern\u201c, oder am AfA-Konto. Soll auch der Zuschussstamm (ohne Inventarverkn\u00fcpfung) das Kennzeichen \u201eAfA-2018\u201c bekommen, da alle Anteile geswitcht wurden, so muss dies in der Maske \u201eBilanz-AfA\u201c noch einzeln get\u00e4tigt werden . \u00a0 \u00a0 </p> <p>b11 - Anlagegut bearbeiten </p> <p>Es wurde ein Fehler behoben welcher es verhinderte bei Neuanlage eines Anlagegutes/ Zuschusses das Sachkonto mittels Doppelklick zu \u00fcbernehmen.</p> <p>b21 - Zuschuss bearbeiten </p> <p>Es wurde ein Fehler behoben welcher es verhinderte bei Neuanlage eines Anlagegutes/ Zuschusses das Sachkonto mittels Doppelklick zu \u00fcbernehmen.</p> <p>b33 - Buchung Anlageg\u00fcter </p> <p>Mit dem Releasewechsel werden fehlerhaft in Datenbank hinterlegte AfA-Konten aus der Doppik-Anfangszeit bereinigt. Dies konnte zu Folgefehlern bei Verbuchung der Abschreibung/ Aufl\u00f6sung f\u00fchren oder Fehlbuchungen in der Finanzbuchhaltung ausl\u00f6sen. \u00a0</p> <p>b34 - Buchung von Zusch\u00fcssen </p> <p>Mit dem Releasewechsel werden fehlerhaft in Datenbank hinterlegte AfA-Konten aus der Doppik-Anfangszeit bereinigt. Dies konnte zu Folgefehlern bei Verbuchung der Abschreibung/ Aufl\u00f6sung f\u00fchren oder Fehlbuchungen in der Finanzbuchhaltung ausl\u00f6sen. \u00a0</p>"},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html#kosten-leistungsrechnung","title":"Kosten-/Leistungsrechnung","text":""},{"location":"aktuelles/releasehistorie/release4.1.0052/programmaenderungen_release_47.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s11 - Systemparameter </p> <p>Um ein besseres Handling f\u00fcr die Steuerung der Druckvorlagen\u00e4nderungen zu erreichen, gibt es jetzt in der Systemverwaltung unter FR -&gt; DRUCK -&gt; VORLOPT einen neuen Systemparameter. Damit wird bestimmt wer die \u00c4nderungen an den Druckvorlagenoptionen \u00fcbernehmen darf</p> <p>s12 - DMS-Konfiguration </p> <p>Es wurden weitere Felder bei der \u00dcbergabe von AO-Daten an das DMS-System definiert. Zus\u00e4tzlich werden jetzt die Felder zu DAT_FAELL, GPROD_BEZ, GKTO_BEZ und GMAS_BEZ mit gef\u00fcllt.</p> <p>s33 - \u00a0Nutzersperre </p> <p>Das Setzen des Hakens bei Nutzersperre durch einen Administrator bewirkt jetzt wieder, dass alle NICHT-administrativen Nutzer f\u00fcr die Arbeit im Programm gesperrt sind und sich nicht anmelden k\u00f6nnen.</p> <p>s41 - Datenbereinigung </p> <p>F\u00fcr die Datenbereinigung der beiden Tabellen KS_DMS_BATCH und O_JOB_EXECUTION stehen Ihnen jetzt zwei neue Reiter zur Verf\u00fcgung.Hier k\u00f6nnen Sie je nach ausgew\u00e4hlter Option, die fehlerfreien S\u00e4tze die \u00e4lter als 1 Monat sind oder alle S\u00e4tze die vor einem von Ihnen gew\u00e4hlten Zeitpunkt liegen l\u00f6schen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/installation_checkliste_relea5.html","title":"Installation Checkliste Release 4.1.0053","text":""},{"location":"aktuelles/releasehistorie/release4.1.0053/installation_checkliste_relea5.html#installation-checkliste-release-410053","title":"Installation Checkliste Release 4.1.0053","text":"<p>Vorg\u00e4ngerrelease ist Release 52</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/installation_checkliste_relea5.html#update","title":"Update","text":"<p>1. Alle SASKIA \u00ae .de IFR-Nutzer abmelden </p> <p>(auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 53.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/installation_checkliste_relea5.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>1. Releasewechsel 53 </p> <p>Nach herunterladen und installieren des Updates kann der Releasewechsel f\u00fcr Release 53 durchgef\u00fchrt werden.  Falls aus Vorg\u00e4nger-Releases noch offene Releasepunkte angezeigt werden, sind diese vorab - beginnend mit dem kleinsten noch offenem Release - auszuf\u00fchren </p> <p> </p> <p>Durch Markieren des entsprechenden Punktes in der linken Tabelle werden die Punkte des Releasewechsels wie gewohnt in der rechten Tabelle dargestellt.</p> <ul> <li> <p>Datenbankstrukturen anpassen Interne Anpassung der Datenbankstruktur in der Datenbank. Dieser Releasewechselpunkt hat keine Auswirkung auf den aktuellen Datenbestand.</p> </li> <li> <p>Datenbank\u00e4nderungen Anpassung des Datenbestandes an die neue Relaeseversion.</p> </li> <li> <p>Abstimmung Periode 14 von Bilanz- und F3-Konten Bildung zus\u00e4tzlicher Daten (Vorjahreswerte), um Auswertungen zuk\u00fcnftig schneller erstellen zu k\u00f6nnen.</p> </li> <li> <p>Anpassung Feldl\u00e4ngen Anpassung der Adressfelder an den XMeld-Standard (Strasse auf 55 Zeichen, Ort auf 40 Zeichen)</p> </li> <li> <p>Spalte Prio in Tabellen KP_VKZ in Integer-Datentyp umwandeln Interne erforderliche Struktur\u00e4nderung.</p> </li> <li> <p>Pr\u00fcfung Personendaten Mit diesem Releasewechselpunkt wird gepr\u00fcft und gegebenenfalls korrigiert, wenn es in der KA_NAME einen Satz gibt, der auf einen Satz in der KA_ADRNR verweist aber die Mandanten unterschiedlich sind. Sollte dies zutreffen, wird der Satz in der KA_NAME mit dem richtigen Mandanten aus der KA_ADRNR gedoppelt. Damit erfolgt wieder eine Anzeige des PK's im Men\u00fc 12a3.</p> </li> <li> <p>Spalte Payload in Tabelle O_Jobqueue in CLOB-Datentyp umwandeln Interne erforderliche Struktur\u00e4nderung.</p> </li> <li> <p>Anrede-Mapping f\u00fcr Schnittstelle Avviso (Text und X-Finanz) initialisieren Das Mapping ist notwendig, weil Avviso nicht alle im IFR m\u00f6glichen Anredeformen beherrscht.</p> </li> <li> <p>F\u00fcgt in die Um_Ini Queries f\u00fcr das Ifr-Datawarehouse Vorbereitung f\u00fcr den m\u00f6glichen Einsatz des IFR-Datawarehouse. </p> </li> <li> <p>InfoFR Debitor/Kreditor-Korrektur  Erg\u00e4nzung des korrektem D/K Kennzeichens in den PK-Informationen, kreditorische Informationen wurden bisher mit dem Kennzeichen D angelegt.</p> </li> </ul> <p>2. Aktualisierung des Schattenmandanten </p> <p>Mit Release 53 wird ein neuer Schattenmandant ausgeliefert, um die notwendigen gesetzlichen \u00c4nderungen (Muster, Konten, Produkte und Zahlwege) abzubilden. Hierf\u00fcr ist in der Systemverwaltung Men\u00fc s31 \u2013 Datenbankaktualisierung oder im IFR im Men\u00fc 124 \u2013 Sachkontenverwaltung der Schattenmandant zu aktualisieren. Folgende Punkte sind dabei zwingend auszuf\u00fchren:</p> <ul> <li>Listen ladenSachkonten laden</li> </ul> <p></p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html#letzte-programmanderungen","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html#auslieferung-zum-06012020","title":"Auslieferung zum 06.01.2020","text":""},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html#jahresabschluss","title":"Jahresabschluss","text":"<p>72 - Kassenjahreswechsel </p> <p>Eine Pr\u00fcfung der Auftragsdaten verhindert den Kassenjahreswechsel.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html#_1","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html#auslieferung-zum-08112019","title":"Auslieferung zum 08.11.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html#_2","title":"Letzte Programm\u00e4nderungen","text":"<p>Releasewechselpunkt bitte bei Installation des Updates im Men\u00fc S31 ausf\u00fchren </p> <p></p> <p>Datenbank\u00e4nderungen </p> <ul> <li>Korrektur bestehender Positionen - betrifft bereits erfolgte Buchungen bei denen ein Anlagegut bzw Zuschuss zum Neuverm\u00f6gen ab 2018 geswitcht wurde.### Buchungen</li> </ul> <p>36 - Anordnungen </p> <p>Bei der Abweisung einer Anordnung, welche mit Buchungsschl\u00fcssel 233 durchgef\u00fchrt wurde, wurde die Buchung nicht vollst\u00e4ndig abgewiesen, was zu Problemen beim Tagesabschluss f\u00fchrte. Hierzu erfolgte eine Korrektur.</p> <p>Im Men\u00fc 36 werden sowohl dem Admin-Nutzer als auch Nutzern mit eingeschr\u00e4nkten Budgetrechten alle Teilbuchungen bei Anordnungen angezeigt, wenn mehrere gleichartige RE-Positionen mit der gleichen Tarifgruppe und dem Tarif erfasst wurden.</p> <p>3a2 - Abgleich Es ist m\u00f6glich eine \u00dcberzahlung auf ein Personenkonto beim Abgleich \u00fcber die maschinelle Kontoauszugsverbuchung zu verbuchen, wenn kein OP auf dem Personenkonto vorhanden ist.</p> <p>394 - Budget\u00fcbersicht </p> <p>Wenn der Nutzername mit einem Gro\u00dfbuchstaben beginnt (z. B. FMusterdorf) und er sich im Men\u00fc 394 verschiedene Ansichten mit dieser Kennung abspeichert hat, werden diese dem Nutzer beim Rechtsklick wieder zur Auswahl angeboten. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html#auftrag-faktura","title":"Auftrag / Faktura","text":"<p>51 - Auftragsverwaltung In der Auftragsverwaltung k\u00f6nnen wieder Auftr\u00e4ge auf Verpflichtungserm\u00e4chtigungen erfasst werden.</p> <p>54 - Ausgangsrechnungsjournal </p> <p>Eine KLR Verteilung im ARJ zu 100% gegen\u00fcber dem Gesamtbruttobetrag nun m\u00f6glich.</p> <p>Beim Stornieren einer Ausgangsrechnung, wurde auf der AO nicht ersichtlich, dass es sich um eine Storno-AO handelt, da der Aufdruck \"Storno\" fehlte. Hierzu erfolgte eine Korrektur.</p> <p>Nach dem Rechnungsdruck wurde der Status auf \"gedruckt\" noch nicht ganz ordentlich aktualisiert. Hierzu erfolgte ein Anpassung.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html#auslieferung-zum-04102019","title":"Auslieferung zum 04.10.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html#buchungen","title":"Buchungen","text":"<p>394 - Budget\u00fcbersicht </p> <p>Die Budgeteinschr\u00e4nkung greift wieder im Men\u00fc 394. Im Filterfeld \"Budget\" wurde ein ToolTip eingebaut, welcher dem Nutzer anzeigt, welche Budgetrechte im ausgew\u00e4hlten Mandanten und HHJ zur Verf\u00fcgung stehen. </p> <p>Wichtiger HInWEIS Ein Doppelklick auf die Bezeichnung der einzelnen Gruppierungen (\u00dcbersichtskategorien/Spaltenbezeichnung) ist ohne Funktionalit\u00e4t. Nur mit einmaligem Klick auf den schwarzen Pfeil neben der jeweiligen Gruppierung (HHJ/Ertr\u00e4ge usw.) \u00f6ffnen bzw. schlie\u00dfen sich die einzelnen Gruppierungselemente in der Budget\u00fcbersicht. Mit einem Rechtsklick und Auswahl \"Alles aufklappen\" werden alle Datens\u00e4tze je nach Gruppierung angezeigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html#auswertungen","title":"Auswertungen","text":"<p>6s - Dokumentenmappe </p> <p>Fremddokumente, die per Upload in die Dokumentenmappe eingepflegt werden, werden nicht mehr doppelt in der erstellten Dokumentenmappe angezeigt. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html#auslieferung-zum-26092019","title":"Auslieferung zum 26.09.2019","text":"<p>Neuer Releasewechselpunkt - diesen bitte bei Installation im Men\u00fc S31 ausf\u00fchren </p> <p></p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html#buchungen_1","title":"Buchungen","text":"<p>3a2 - Kontoauszug - Abgleich </p> <p>In der Kontoauszugsverbuchung wurde beim maschinellen Abgleich die automatische Bildung des Buchungsschl\u00fcssels korrigiert. OP-Nummer und F\u00e4lligkeit des zugeordneten OP's sind wieder sichtbar.</p> <p>36 - Anordnung </p> <p>Anordnungen werden nun wieder analog der in der Systemverwaltung hinterlegten Budgetrechte dem Mitarbeiter angezeigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html#auslieferung-zum-20092019","title":"Auslieferung zum 20.09.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0053/letzte_programmaenderungen3.html#buchungen_2","title":"Buchungen","text":"<p>33 - Buchungsstapel </p> <p>F\u00fcr die Verbuchung von Zahlungsbuchungen, bei denen am Umsatzsteuer-Konto kein FR-Konto hinterlegt wurde, wurde eine M\u00f6glichkeit geschaffen, diese Buchungen auch ohne FR-Konto durchzuf\u00fchren.</p> <p>3522 - Verarbeitung Schnittstelle Bei der Verarbeitung von Schnittstellen kam es unter einer bestimmten Konstellation zu einer Fehlermeldung. Hierzu erfolgte eine Anpassung.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html","title":"Programm\u00e4nderungen Release 4.1.0053","text":""},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#programmanderungen-release-410053","title":"Programm\u00e4nderungen Release 4.1.0053","text":""},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#auslieferung-zum-16092019","title":"Auslieferung zum 16.09.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#_1","title":"Programm\u00e4nderungen Release 4.1.0053","text":""},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#allgemein","title":"Allgemein","text":"<p>F\u00fcr Kunden mit DMS </p> <p>F\u00fcr eine bessere Recherche im Dokumentenmanagementsystem wurde in verschiedenen Men\u00fcpunkten noch der DMS-Button erg\u00e4nzt:  Men\u00fc 52 zur Recherche von historischen Rechnungen Men\u00fc 931 im Reiter OPs Men\u00fc 54 in der Journalmaske Men\u00fc 81 in der Historie </p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#stammdaten","title":"Stammdaten","text":"<p>12a1 - Adressstammdaten </p> <p>Zusatzadressen zu einem bestehenden Personenkonto k\u00f6nnen auch ohne Adresse angelegt werden, daf\u00fcr muss im Men\u00fc 12a1 - im Reiter 'Funktionen' \u00a0die Option \"Ohne Adresse erlauben\" ausgew\u00e4hlt werden. Diese Einstellung kann pro PK-Funktion angegeben werden. Achtung: Diese Einstellung kann nicht r\u00fcckg\u00e4ngig gemacht werden.</p> <p>12a2 - Gebietsgliederung </p> <p>Bei der Meldung: 'Der Datenbestand beinhaltet ung\u00fcltige Daten, diese werden jetzt angezeigt' \u00a0erfolgt nur die Anzeige der H\u00e4user mit fehlerhafter Hausnummer, z.B. Hausnummerzusatz in der Hausnummer statt im Feld 'Zusatz'.</p> <p>12a3 - Personenkontenverwaltung </p> <p>Wird ein Mandat auf ruhend, gesperrt oder gel\u00f6scht gesetzt, wird der Aktivhaken am Mandatssatz vom PK automatisch entfernt. </p> <p>Das Selektionsfeld \"Gruppenkennzeichen\" in der Personenkontenverwaltung wurde erweitert, so dass mehr als 3 Gruppenkennzeichen selektiert werden k\u00f6nnen.</p> <p>Nach einer erfolgten \u00c4nderung von Eintr\u00e4gen im PK, wird der Button \"\u00dcbernehmen\" korrekt angeboten. Es folgt eine Anpassung.</p> <p>1y1 - Textbausteine </p> <p>Der RTB 7 erzeugt nur (noch) ein Beiblatt, wenn f\u00fcr ihn ein Text hinterlegt ist.</p> <p>1y2 - Ausgabesystem-Vorlagen </p> <p>Das L\u00f6schen von mandantenspezifischen MRT-Vorlagen wurde z.T. nicht durchgef\u00fchrt. Hierzu gab es eine Anpassung. Das L\u00f6schen der Vorlagen ist jetzt in der Reihenfolge 1. mandantenspezifische Vorlage und 2. Vorlage Mandant 0000 m\u00f6glich.</p> <p>Da es in der Vergangenheit zeitweise zu Problemen beim Druck der Absenderadressformate (DIN5008 / ePost) gegeben hat, gibt es jetzt bei einer Vielzahl von Reports, eine Druckvorlagenoption f\u00fcr den expliziten Druck nach ePost-Format. Die Einstellung erfolgt \u00fcber das Men\u00fc 1y2 - Vorlagenverwaltung bzw. direkt beim Druck \u00fcber die Druckvorlagenoptionen.</p> <p>Bei mandantenspezifischen \u00c4nderungen an den Vorlagenoptionen, wurde der Eintrag f\u00fcr den Mandanten 0000 \u00fcberschrieben. Jetzt werden die mandantenspezifischen Optionen erg\u00e4nzt. \u00a0</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#planung","title":"Planung","text":"<p>21 - Neues Planjahr anlegen </p> <p>Bei der Planableitung aus dem zweiten Jahr eines DHH in das erste Jahr des neuen DHH wurden die Planans\u00e4tze f\u00fcr die letzten Folgejahre zum Teil nicht korrekt vorgetragen. Hierzu erfolgte eine Korrektur.</p> <p>241 - Budget\u00fcbersicht - Planwerte </p> <p>Beim \u00c4ndern des Haushaltsjahres mit anschlie\u00dfenden Aktualisieren der Auswahl, kam es zu einem Fehlverhalten der Spaltenk\u00f6pfe. Die Aktualisierung erfolgt nun korrekt.</p> <p>242 - Ergebnisplan In den Men\u00fcs 242 und 243 (Ergebnisplan und Finanzplan) wurde \u00a0eine \"\u00fcbergeordnete\" Gesamt-Summenzeile f\u00fcr Buchungsstellen mit und ohne Ma\u00dfnahme integriert.</p> <p>27 - Neue Buchungsstelle </p> <p>Buchungsstellen die kein Produkt/Budget haben, z.B. Bilanzbuchungsstellen, k\u00f6nnen wieder gel\u00f6scht werden.</p> <p>29a - Voraus. f\u00e4llig. Ausz. aus VE </p> <p>Gibt es in der Druckliste Jahresspalten, die keine Werte enthalten (alles Nullen), k\u00f6nnen diese mit der neuen Vorlagenoption \"nicht betroffene HH-Jahre ausblenden\" auf der Liste ausgeblendet werden.</p> <p>29c - Planvariantenvergleich </p> <p>F\u00fcr den Planvariantenvergleich gibt es 3 neue Druckvorlagenoptionen zur Summierung der aufgef\u00fchrten Werte; nach Deckungskreis, Budget und Gesamtsumme.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#buchung","title":"Buchung","text":"<p>311 - Einzelbuchungen </p> <p>Die sofortige Zuordnung von Buchungen auf KLR-Elemente (Kostenstellen, Kostentr\u00e4ger,...) mit Hilfe der KLR-Aufteilung ist jetzt nur noch zu max. 100% des Buchungsbetrages m\u00f6glich. Eine \u00dcberschreitung des Aufteilungsbetrages verhindert das Programm mit einer entsprechenden Meldung.</p> <p>Der neue Buchungsschl\u00fcssel 290 l\u00e4sst das Bebuchen der Umsatz-/ bzw. Vorsteuerkonten zu. Entwickelt wurde er f\u00fcr die Verrechnung der Konten mit dem USt- Verrechnungskonto. Er ist grunds\u00e4tzlich nicht zum Umbuchen der Umsatz- bzw. Vorsteuer-Konten untereinander gedacht, da der Buchungsschl\u00fcssel 290 keine Daten in das Umsatzsteuermodul im Men\u00fc 67* liefert.</p> <p>Mit dem neuen Buchungsschl\u00fcssel 233 kann nun direkt eine Zahlwegsumbuchung zwischen zwei Zahlwegskonten erfasst werden. Bei einer Buchung zwischen einer Bank und einer Kasse entsteht somit eine AO auf Kassenseite und ein Ein-bzw. Ausgangsscheck auf Seite des Bank-Zahlwegs, der mittels Ein-bzw. Auszahlungsschwebeposten best\u00e4tigt wird. Auch die Zahlwegsumbuchung zwischen 2 Banken ist m\u00f6glich. Achtung: Hierbei entstehen 2 Schwebeposten. Zum Einen der Schwebeposten im Bereich der \"\u00dcberweisungen\", f\u00fcr den ausgebenden Zahlweg. Zum Anderen ein Schwebeposten im Bereich des \u00b4\"Eingangschecks\" f\u00fcr den einnehmenden Zahlweg.</p> <p>Gibt es zum Personenkonto einen Infotext und/oder einen Kassenakteneintrag wird in beiden F\u00e4llen der Infoknopf gr\u00fcn.</p> <p>Sollen Buchungsanordnungen (Einzelformulare) aus der Einzelbuchungsfunktion (Men\u00fc 311) oder der AO-Verwaltung (Men\u00fc 36) k\u00fcnftig den Zusatz STORNO ausweisen, wird dies nicht mehr automatisch am negativen Vorzeichen des Buchungsbetrages festgemacht, sondern erfordert die bewusste Auswahl der neuen Checkbox [STORNO] auf der Buchungsmaske. Die Checkbox wird NICHT in die Tab-Reihenfolge aufgenommen, sodass sie den gewohnten Umgang mit der Maske nicht st\u00f6rt. Allerdings l\u00e4sst sie sich mit ALT+S anw\u00e4hlen. Hinweis: Die Auswahl der Checkbox hat keinen Einfluss auf die \u00dcberschrift einer AO-Liste, da dort \u00fcber die Buchungsmenge keine Auschlie\u00dflichkeit von Stornovorg\u00e4ngen gew\u00e4hrleistet werden kann.</p> <p>32 - Tagesabschluss </p> <p>F\u00fcr die Druckausgabe des Zahlungsavis gibt es folgende neue Druckvorlagenoptionen:  - \"Umsatzsteuer unterdr\u00fccken\" Steuerspalte wird auf der Druckliste nicht mit gedruckt - \"nur OP-Summen pro F\u00e4lligkeit ausgeben\" Zusammenfassen der OP's mit gleicher OP-Nummer nach F\u00e4lligkeit.</p> <p>351 - Schnittstelle - Einrichten </p> <p>In den Standard-Schnittstellen V3 und V4 erlaubt ein neuer Parameter, dass Inhalte gek\u00fcrzt werden, wenn diese die vorgegebenen Feldl\u00e4ngen \u00fcberschreiten. Au\u00dferdem wird, wenn der Inhalt im \"Name1\" zu lang ist dieser auf die Felder \"Name2\" und \"Name3\" verteilt, sofern f\u00fcr diese keine Inhalte mitgeliefert werden.</p> <p>3522 - Schnittstellen - Verarbeiten </p> <p>Es erfolgte eine \u00c4nderung bei der Aktivierung/Deaktivierung der Button \"Protokoll\" und \"Zur\u00fccksetzen\". Der Button \"Protokoll\" wird nur noch bei Schnittstellen \"aktiv\", wenn der Parameter \"Protokolldruck an/aus\" auf \"Ja\" gesetzt ist.  Das Zur\u00fccksetzen von verarbeiteten Schnittstellendateien ist nur noch m\u00f6glich, wenn der Parameter \"R\u00fccksetzbar?\" mit \"1\" hinterlegt wurde. Dieser Parameter steht nur in bestimmten Schnittstellen zur Verf\u00fcgung.</p> <p>36 - Anordnungsverwaltung </p> <p>Mit der neuen Vorlagen-Option \"mit Budgetumbuchungen\" werden auf einer Anordnung nun die beteiligten Budgetumbuchungen als Tabelle ausgewiesen. Dieser Ausweis kann f\u00fcr alle AO-Buchungen erfolgen, au\u00dfer beim Nachdruck von Daueranordnungen</p> <p>391 - Personenkonten </p> <p>Zur korrekten Darstellung von Offenen Posten in der PK-Auskunft (Men\u00fc 391) wurden 2 neue, zus\u00e4tzliche Spalten zur Ver\u00e4nderung von Sollstellungen bzw. Zahlungen eingef\u00fchrt. Dadurch k\u00f6nnen die nachrichtlichen Werte auf den PK-Kontoausz\u00fcgen auch bei Absetzungen, Stornierungen bzw. negativen Zahlungen immer korrekt dargestellt werden. Au\u00dferdem wurden die Titel der Wertespalten auf den PK-Kontoausz\u00fcgen kundenfreundlich umbenannt (ehem. Soll und Haben hei\u00dfen nun Forderung und Einzahlung bzw. Verbindlichkeit und Auszahlung).</p> <p>Bei der Hinterlegung von OP-Informationen / Aktennotizen am Personenkonto im Men\u00fc 391 wurden diese, wenn die Bezeichnung \"K\" oder \" D\" nicht ausgew\u00e4hlt wurde, immer f\u00fcr den Debitor der ausgew\u00e4hlte PK-Nummer angelegt und waren zB. im Eingangsrechnungsjournal nicht sichtbar. Hierzu erfolgte eine Anpassung.</p> <p>392 - Auskunft - Sachkonten </p> <p>Beim Wechsel des Sachkontos im Men\u00fcreiter Auswahl, erfolgte nicht immer eine korrekte Aktualisierung der Sachkontenbezeichnung in den einzelnen Men\u00fcreitern - Funktion wurde \u00fcberarbeitet.</p> <p>394 - Budget\u00fcbersicht </p> <p>Die Budget\u00fcbersicht wurde auf das Telerikcontrol umgestellt. Die alten Grundfunktionen wie Umsortieren der Spalten, Sortieren innerhalb der Spalten, Ein- oder Ausblenden von Spalten, Fixieren einer Spalte sowie der Export bspw. nach Excel sind weiterhin mit Rechtsklick ausw\u00e4hlbar. Zus\u00e4tzlich besteht nun die M\u00f6glichkeit, nach bestimmten Spalten zu gruppieren und verschieden Filter zu setzen. Die Nutzereinstellungen werden pro Nutzer gespeichert und es k\u00f6nnen auch mehrere verschiedene Ansichten f\u00fcr jeden Nutzer hinterlegt werden ( Rechtsklick: Ansicht\u00e0 Ansicht speichern unter).</p> <p>Ebenso k\u00f6nnen in den Spalten mit roten F\u00e4hnchen (per Doppelklick auf die einzelne Zelle) die dazugeh\u00f6rigen Planungs-bzw. Bewirtschaftungsbuchungen eingesehen werden. </p> <p>F\u00fcr die FR-Mittel\u00fcbertragungen wurden zwei neue Spalten erg\u00e4nzt. Die Spalte \u201eFR-Erm\u00e4chtigung Vorjahr\u201c \u00a0zeigt die \u00fcbertragenen FR-Erm\u00e4chtigungen, die aus den Vorjahr \u00fcbertragen wurden und im aktuellen HH-Jahr zur Verf\u00fcgung stehen. Dies wird auch \u00a0im fortgeschriebenen Planansatz des FR-Kontos mit ber\u00fccksichtigt. Die Spalte \u201eFR-Erm\u00e4chtigungen\u201c wei\u00dft alle FR-Reservierungen aus dem laufenden Jahr (Reservierung mit Soll-Stellung) abz\u00fcglich die Mittel\u00fcbertragung ins n\u00e4chste Jahr (Periode 13) aus.</p> <p>Achtung: Ertr\u00e4ge werden zuk\u00fcnftig im Men\u00fc 394 mit negativer Verf\u00fcgbarkeit dargestellt, solange der Planansatz in der Bewirtschaftung noch nicht erreicht wurde. </p> <p>3a2 - Kontoauszugsabgleich </p> <p>Der manuelle Abgleich in der Kontoauszugsverbuchung ist um einige Funktionen erweitert worden. Es ist jetzt \u00a0m\u00f6glich einen debitorischen Gesch\u00e4ftsvorfall einem Kreditor zuzuordnen und auch umgekehrt. Beispiel-Awendungsf\u00e4lle sind Gutschriften von Versorgern, die im IFR als negativer Aufwand auf dem Kreditor gebucht sind. Auch k\u00f6nnen erfolgte \u00dcberweisungen an Debitoren (was einem kreditorischen Gesch\u00e4ftsvorfall entspricht) einem Debitor im IFR zugeordnet werden, wo auf dem debitorichen Personenkonto ein negativer Ertrag gebucht wurde. \u00a0Weiterhin ist es m\u00f6glcih eine \u00dcberzahlung auf einen bereits ausgeglichenen OP zu erzeugen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#op-bearbeitung","title":"OP-Bearbeitung","text":"<p>421 - Stundung - Bearbeiten </p> <p>Betrifft nur Bundesland Sachsen-Anhalt: Auf Grund gesetzlicher Anpassungen werden jetzt bei Stundungen die auf Grundlage des KAG erhoben werden, die Verzinsung taggenau und betragsgenau ohne Abrundung auf den n\u00e4chsten durch 50 teilbaren Betrag vorgenommen. Sollten durch den Gesetzgeber (Bund) Anpassungen am Bundesbankbasiszinssatz vorgenommen werden, sind die Stundungen durch die Kommunen anzupassen. Die S\u00e4umniszuschl\u00e4ge werden weiter mit 1% pro angefangenen Monat, auf den n\u00e4chsten durch 50 teilbaren Betrag abgerundet, berechnet.</p> <p>431 - AdV - Verwaltung </p> <p>Beim Markieren von OP's, die f\u00fcr eine AdV herangezogen werden sollen, kam es unter Umst\u00e4nden vor, dass die falsche Zinsmethode (\u00f6ffentlich-rechtlich / privatrechtlich) f\u00fcr die AdV verwendet wurde, es erfolgte hierzu eine Korrektur.</p> <p>Beim Ausweis von \"Zins gesamt\" auf dem Ausdruck des AdV-Widerrufes kam es zu einem Fehlverhalten bei der Rundung des Betrages. Hierzu erfolgte eine Korrektur, so dass jetzt korrekt bei \u00f6ffentlich-rechtlichen F\u00e4llen der Zinsbetrag nicht gerundet wird und bei privat-rechtlichen F\u00e4llen keine Rundung mehr erfolgt.</p> <p>48 - Vollstreckung </p> <p>Das Protokoll zur Erstellung der Ausgabedatei f\u00fcr Avviso wurde \u00fcberarbeitet und weist jetzt in der tabellarischen Darstellung eine saubere Trennung zwischen PK-S\u00e4tzen und OP-S\u00e4tzen aus.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#auftragfaktura","title":"Auftrag/Faktura","text":"<p>51 - Auftragsverwaltung </p> <p>Musterauftr\u00e4ge k\u00f6nnen in das Folgejahr \u00fcbernommen werden. Dazu im aktuellen HHJ die Auftragsart \"Muster\" w\u00e4hlen und das H\u00e4kchen \"alle\" setzen. Es werden nun die Musterauftr\u00e4ge aus dem Vorjahr eingeblendet. Den entsprechenden Auftrag mit Klick in den Spaltenkopf ausw\u00e4hlen. Der Button \"nach 2019 \u00fcbernehmen\" wird aktiviert und kann f\u00fcr die \u00dcbernahme angeklickt werden. Der Auftrag erh\u00e4lt automisch eine Muster-Auftragsnummer aus Bereich des jeweiligen HHJ. </p> <p>52 - Eingangsrechnungsjournal </p> <p>F\u00fcr einen direkten AO-Druck der Eingangsrechnung gibt es jetzt die M\u00f6glichkeit, dies \u00fcber die neue Checkbox \"AO-Formular\" zu steuern. Die AO wird nach Klick auf den Button \"Buchen\" erstellt. Wurde der Haken einmal gesetzt, wird dies f\u00fcr den entsprechenden Nutzer gespeichert.Au\u00dferdem kann beim Klick auf den Button \"AO-Druck\" nun das HH-Jahr im Reiter \"AO-Bearbeiten\" ge\u00e4ndert werden, es erfolgt lediglich eine Vorbelegung mit dem aktuellen HH-Jahr. Diese Anpassung ist f\u00fcr Buchungen mit abweichender Leistungsperiode notwendig - wenn diese im vorherigem HH-Jahr liegt. Wichtig ist, dass erst die Anordnung f\u00fcr das Vorjahr zu erzeugen ist Danach ist auf das aktuelle Haushaltsjahr zu wechseln, um die Folgeanordnung zu erzeugen, die dann die Anordnung aus dem Vorjahr mit ausweist.</p> <p>F\u00fcr Ratenbuchungen steht im Auswahlmen\u00fc zum Ratenabstand jetzt zus\u00e4tzlich noch die Option \"viermonatlich\" zur Verf\u00fcgung. </p> <p>Beim Druck der ER-Vorkontierung konnte es vorkommen, dass bei Eingangsrechnungen mit Ratenaufteilung, eine Rate zu viel angezeigt wurde, dies wurde nun behoben.</p> <p>Nachdem sich im vorherigen Update (Release 52) mit der Umstellung des Eingangsrechnungsjournals (ERJ) auf das standardm\u00e4\u00dfige Nebenbuchwerksverhalten die notwendigen Bearbeitungsschritte ge\u00e4ndert haben, wurde jetzt erg\u00e4nzend auch die Status-Vorbelegung der \u00dcbersichtsmaske angepasst. Der vorherige Status \"AO-Best\u00e4tigung\" wurde in \"AO\" umbenannt und ist standardm\u00e4\u00dfig beim Start des ERJ immer vorbelegt. Dieser Status fasst k\u00fcnftig alle Rechnungen \u00fcber die Teilschritte \"Buchen\" - \"AO-Drucken\" - \"AO-Best\u00e4tigung\" hinweg zusammen.</p> <p>54 - Ausgangsrechnungsjournal </p> <p>Die SEPA-Lastschriftwerbung wird, analog wie in der Veranlagung, bei der Auswahl der Option 'mit Ausdruck der Einzugserm\u00e4chtigung' mit ausgedruckt.</p> <p>Beim Bearbeiten einer Rechnung werden die Tarife und Tarifgruppen in der Auswahlbox sortiert angeboten.</p> <p>Die im Filterfeld \"Status\" ausgew\u00e4hlten Status werden jetzt nutzerspezifisch gespeichert und sind somit beim Neuaufruf des Men\u00fcpunktes wieder entsprechend gesetzt.</p> <p>Das L\u00f6schen von Musterrechnungen wurde erm\u00f6glicht. Diese Muster werden, nachdem die Sicherheitsabfrage mit 'Ja' best\u00e4tigt wurde, unwiederbringlich gel\u00f6scht. </p> <p>Musterrechnungen sind unabh\u00e4ngig vom gew\u00e4hlten HH-Jahr druckbar und stehen als Rechnungsvorlage haushaltjahres\u00fcbergreifend zur Verf\u00fcgung. </p> <p>Der Schreibschutz von verbuchten Rechnungen wurde verbessert. </p> <p>Die Mandatsinformationen werden auf Rechnungen analog den Veranlagungsbescheiden anonymisiert.</p> <p>F\u00fcr das Ausgangsrechnungjournal wurde die Anbindung an die ePayment-Funktion der SASKIA\u00ae.de-Online-Service-Komponente (OSK) geschaffen.</p> <p>Der Report f\u00fcr das ARJ wurde dahingehend neu gestaltet, dass zuk\u00fcnftige ePayment Vorg\u00e4nge abgebildet werden k\u00f6nnen. Die zugeh\u00f6rige neue Vorlagenoption ist vorbereitet. \u00a0</p> <p>55 - Stammdaten </p> <p>Die Bezeichnung des Eingabefeldes 'G\u00fcltigkeit' \u00a0wurde ge\u00e4ndert in 'Gilt bis Periode' f\u00fcr die Erfassung von Tarifen und Tarifgruppen.</p> <p>Musterrechnungen werden in den Stammdaten gepflegt. Die Liste der Musterrechnungen wird nun nur noch im Men\u00fc 55 aufgezeigtt. Im Men\u00fcpunkt 54 sind alle Rechnungen aufgelistet.</p> <p>592 - Fakturierung - Bearbeitung </p> <p>Bei Eingabe von Rechnungspositionen ohne Auswahl eines Tarifes, erfolgte immer standardm\u00e4\u00dfig eine Rundung des Tarifwertes und der Menge auf ganzzahlige Werte. Hierzu erfolgte eine \u00c4nderung, so dass jetzt die beiden Nachkommastellen mit ber\u00fccksichtigt werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#auswertungen","title":"Auswertungen","text":"<p>6 - Auswertungen </p> <p>In der Instandhaltungs\u00fcbersicht (Muster 9) werden nun die Gesamtsummen laut Muster ausgewiesen.</p> <p>613 - Quartalsstatistik </p> <p>Bei Erstellung der Vierteljahresstatistik f\u00fcr zuk\u00fcnftige Quartale, werden bei Eingabe der Zusatzangaben (z.B. finanzielle Transaktionen) nur noch nummerische Zeichenfolgen zugelassen. Die Eingabe von alphanumerischen Zeichenfolgen verhinderte nach Berechnung der Statistik die Ausgabe.</p> <p>672 - Umsatzsteuer - Meldungen </p> <p>Durch eine \u00c4nderung im Programm kam es zu einem Fehlverhalten in der Sortierung was dazu f\u00fchrte, dass die Bl\u00f6cke zur Vorsteuer und Umsatzsteuer nicht mehr zusammenh\u00e4ngend dargestellt wurden. Hierzu erfolgte eine Korrektur.</p> <p>Mit der Umsatzsteuererkl\u00e4rung kann nun ebenfalls die Anlage UN gef\u00fcllt und elektronisch \u00fcbermittelt werden, wenn die entsprechenden Angaben bzgl. des \"Im Ausland ans\u00e4ssigen Unternehmers\" get\u00e4tigt wurden.</p> <p>Bei Ist-Versteuerung wurde in der Umsatzsteuermeldung bislang unter der Spalte \"Zahlung\" der Bruttowert ausgewiesen, der aber als Nettowert behandelt wurde. D. h. es wurde auf den Bruttowert nochmal f\u00fcr die Spalte \"Steuer aus Zahlung\" der steuerliche Prozentsatz drauf gerechnet. Damit war die Umsatzsteuermeldung falsch. Zudem kam es zu hohen Differenzwerten. Dieser Fehler ist nun bereinigt. Zudem wurden die Spaltenbezeichnungen ge\u00e4ndert.</p> <p>68 - Freie Auswertungen </p> <p>Die Auswertung \u00a0\"1. Planungsauswertung als Erg\u00e4nzung zum Teilfinanzplan B\" wurde um den Parameter VE \"Verpflichtungserm\u00e4chtigungen\" erweitert. Damit kann man sich im Zeitraum der Planungsphase eine \u00dcbersicht \u00fcber die geplanten VE's verschaffen.</p> <p>69 - Gesetzliche Drucklisten </p> <p>Beim Druck von Teilplanungs- und rechnungslisten wird das Auswahlfeld \"Budget\" f\u00fcr die Datenaufbereitung zuk\u00fcnftig mit \u00a0ber\u00fccksichtigt. Dadurch ist es auch m\u00f6glich eine konkrete Auswahl eines Produktes oder Produktbereiches vorzunehmen.</p> <p>Mit dem Schalter F51 k\u00f6nnen Sie festlegen, wie die Darstellung der Kredite in der Verbindlichkeits\u00fcbersicht erfolgen soll. Schalterstellung \"JA\" - Kredite werden in der Spalte der letzten F\u00e4lligkeit dargestellt. Ist der Schalter auf \"NEIN\" gesetzt, wird der Betrag eines Kredites entsprechend der F\u00e4lligkeiten in die Spalten \"bis zu 1 Jahr\", \"&lt;1 und &gt;5 Jahre\" oder \"&gt; 5 Jahre\" gesplittet. Diese Einstellung entspricht der bis Release 52 \u00fcblichen Darstellung von Krediten in der Verbindlichkeits\u00fcbersicht. </p> <p>Betrifft nur Bundesland Sachsen-Anhalt: F\u00fcr den Teilergebnishaushalt sowie den Teilfinanzhaushalt A und B gibt es die neue Vorlagenoption \"verk\u00fcrzte Hierarchie\". Unter Aktivierung dieser Option wird beim Druck in der \u00dcberschrift nur noch der jeweilige Teilhaushalt und die letzte Ebene angegeben. Der Produktbereich sowie die Produktgruppe und weitere Stufen vom Teilhaushalt zur letzten Stufe - dem Produkt, werden in den \u00dcberschriften bei Auswahl dieser Druckoption nicht mehr eingeblendet.</p> <p>6s - Dokumentenmappen </p> <p>Die einzelnen Gliederungspunkte in der Dokumentenmappe (PDF) k\u00f6nnen mittels Lesezeichen angesteuert werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#jahresabschluss","title":"Jahresabschluss","text":"<p>72 - Kassenjahreswechsel </p> <p>F\u00fcr den Kassenjahreswechsel wurden die Pr\u00fcfungen, sowie die Verlinkungen zur Problembehebung konkretisiert.</p> <p>7331 - Kontenabstimmung </p> <p>Bei der Pr\u00fcfung der Sachkontensalden f\u00fcr die Kontenabstimmung zum Jahreswechsel kam es zu einer Fehlermeldung (Saldo \u00fcber gesamten Kontenrahmen &lt;&gt;0...), die nunmehr mit Release 53 behoben wurde.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#veranlagung","title":"Veranlagung","text":"<p>152 - \u00a0Einnahmearten </p> <p>Die M\u00f6glichkeit der Festlegung objektbeschreibender Felder, die als Suchkriterium \u00a0genutzt werden k\u00f6nnen, ist nicht mehr auf 3 Felder begrenzt. Damit k\u00f6nnen beliebig viele Felder genutzt werden. </p> <p>8 - Veranlagung </p> <p>F\u00fcr die Verbuchung aus der Veranlagung wurde die Bildung der Buchungsperioden entsprechend 'Kommentar zum S\u00e4chs. Haushaltsrecht zu \u00a7 37 S\u00e4chsKomHVO (Doppik) Nr. 36 und SSG \u2013 Mitgliederrundschreiben Nr. 516/10 vom 08.09.2010' \u00a0\u00fcberarbeitet: </p> <p>Nur Abrechnungen der Gewerbesteuer f\u00fcr die der FA-Bescheid bereits im alten Haushaltsjahr eingegangen ist und die Bescheidschreibung in der Verwaltung erst im neuen Jahr erfolgt, werden ins alte Haushaltsjahr gebucht, wenn die Option 'Abrechnungsbuchungen ins Vorjahr' gesetzt ist und aus der Festsetzung eine Verbindlichkeit resultiert. </p> <p>81 - Einzelveranlagung </p> <p>Auch wenn im Reiter 'Stornierung' eine Umsortierung erfolgte, wird der gew\u00e4hlte Bescheid korrekt storniert.</p> <p>In der Einzelveranlagung besteht analog der Gesamtveranlagung die M\u00f6glichkeit, einen gew\u00fcnschten Buchungstext 2 zu verwenden.</p> <p>Einzelne Konstellationen bei der Ratenbildung wurden programmseitig \u00fcberarbeitet. </p> <p>Werden im VERGW die Folgejahre angedruckt, so erscheinen die Folgejahresraten bei AWJ-F\u00e4llen in der entsprechend abweichenden Reihenfolge.</p> <p>852 - Jahreswechsel Bescheide </p> <p>Liegt das bereits vorab eingetragene Abmeldedatum eines Objektes (bzw. Unterobjektes) im neuen Haushaltsjahr, wird - wenn im Men\u00fc 152 die Option \"Abmeldedatum wird in die Tarifzeile \u00fcbernommen\" \u00a0f\u00fcr die jeweilige EArt aktiviert ist - das Abmeldedatum beim Jahreswechsel der Bescheide in das Feld 'Datum bis' / 'Monat bis' automatisch eingesetzt. Die Berechnung erfolgt dann ggf. anteilig.</p> <p>844 - Freie Auswertungen </p> <p>Der Auswertung \"Gewerbebetriebe nach Steueraufkommen\" wurde \u00fcberarbeitet. Die Liste liefert ausschlie\u00dflich Werte zu gebuchten Bescheiden je Steuerjahr.  Zus\u00e4tzlich wird in der Auswertung das Objekt aufgef\u00fchrt, im Titel erscheint das gew\u00e4hlte Steuerjahr.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#kreditedarlehen","title":"Kredite/Darlehen","text":"<p>a2 - Freigabe/Buchung </p> <p>Eine Kreditumschuldungen ohne Geldfluss (z.B. bei Prolongation) ist im Men\u00fc Kredite/Darlehen jetzt m\u00f6glich. </p> <p>Voraussetzung daf\u00fcr ist, dass im bestehenden Kredit alle zu leistenden Zahlungen (Tigungsraten \u00a0und Zinsen) bereits korrekt verbucht sind und somit f\u00fcr diesen Kredit keinerlei Forderungen mehr entstehen. </p> <p>Dann kann sowohl bei der Umschuldung als auch bei der Neuer\u00f6ffnung die Option 'ohne Buchung gew\u00e4hlt werden. </p> <p>Bei der Neuer\u00f6ffnung eines Kredites k\u00f6nnen in der 'Auswahl Umschuldung' auch mehrere Kredite ausgew\u00e4hlt werden. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#anlagenbuchhaltung","title":"Anlagenbuchhaltung","text":"<p>Anlagenbuchhaltung allgemein </p> <p>Betrifft nur die s\u00e4chsischen Kommunen!  In den nachstehenden Men\u00fcs wurde der Filter \u201eAfA 2018\u201c noch integriert: Anlagenkarte | Sonderpostenkarte | Nachweis kalkulatorische Zinsen | Bestandsverzeichnis | Prognose | Zu-/Abgangsliste | Versicherungsliste | Anlagenspiegel | Sonderpostenspiegel| Anlagen\u00fcbersicht | AfA-Berechnung | Zinsberechnung </p> <p>b11 - Anlageg\u00fcter-Bearbeiten </p> <p>Es wurde ein Fehler behoben, welcher bei Zuschusszuordnung als Positionsdatum, dass Datum der letzten Anlagegut-Position statt der Zuschuss-Basis-Position bzw. die Position der konkreten Zuordnung vorgeschlagen hat.</p> <p>Betrifft nur die s\u00e4chsischen Kommunen: Es wurde ein Fehler behoben, welcher bei Zuschusszuordnung der Verkn\u00fcpfung von Anlagegut und Zuschuss ein falsches Aufl\u00f6sungskonto (Aufwandskonto) vererbt hat.  In diesem Zusammenhang wurde bei Zuschusszuordnung die neue Checkbox \u201eAfA 2018\u201c integriert. Mit dieser kann festgelegt werden, ob es sich bei Zuordnung, um eine Verkn\u00fcpfung nach altem oder neuem Recht vor oder nach 2018 handelt. Dieses Kennzeichen wird nur automatisch gesetzt, wenn der zuzuordnende Zuschuss bzw. das Anlagegut, je nachdem von welcher Seite aus die Zuordnung erfolgen soll (b11 oder b21), bereits geswitcht oder nach neuem Recht/ Verfahrensweise angelegt wurde (\u201eAfA 2018\u201c-Kennzeichen in den Kopfdaten des Anlagegutes/ Zuschusses). Ist dies nicht der Fall, muss bei Zuordnung manuell entscheiden werden worum es sich handelt.</p> <p>b21 - Zusch\u00fcsse-Bearbeiten </p> <p>Es wurde ein Fehler behoben, welcher bei Zuschusszuordnung als Positionsdatum, dass Datum der letzten Anlagegut-Position statt der Zuschuss-Basis-Position bzw. die Position der konkreten Zuordnung vorgeschlagen hat.</p> <p>Betrifft nur die s\u00e4chsischen Kommunen! Es wurde ein Fehler behoben, welcher bei Zuschusszuordnung der Verkn\u00fcpfung von Anlagegut und Zuschuss ein falsches Aufl\u00f6sungskonto (Aufwandskonto) vererbt hat.  In diesem Zusammenhang wurde bei Zuschusszuordnung die neue Checkbox \u201eAfA 2018\u201c integriert. Mit dieser kann festgelegt werden, ob es sich bei Zuordnung, um eine Verkn\u00fcpfung nach altem oder neuem Recht vor oder nach 2018 handelt. Dieses Kennzeichen wird nur automatisch gesetzt, wenn der zuzuordnende Zuschuss bzw. das Anlagegut, je nachdem von welcher Seite aus die Zuordnung erfolgen soll (b11 oder b21), bereits geswitcht oder nach neuem Recht/ Verfahrensweise angelegt wurde (\u201eAfA 2018\u201c-Kennzeichen in den Kopfdaten des Anlagegutes/ Zuschusses). Ist dies nicht der Fall, muss bei Zuordnung manuell entscheiden werden worum es sich handelt.</p> <p>b611 - Anlagennachweis </p> <p>Betrifft nur die s\u00e4chsischen Kommunen! F\u00fcr Zusch\u00fcsse, welche nachdem neuen Haushaltsausgleich, komplett geswitch oder nur einzelne Zuordnungen umgestellt wurden, ist nun auch die Gegen\u00fcberstellung nach \u201ealten/ neuen\u201c AfA-Konto \u00fcber die Sortierung: \u201eSachkonto mit AfA-Konto\u201c analog zum Anlagegut auf einer Seite m\u00f6glich.  Au\u00dferdem wurde im Filter: \u201eAfA 2018\u201c die Parameter \u201eNeue und Umgestellte\u201c sowie \u201eAlte und Umgestellte\u201c integriert. Diese Parameter lassen sich mit der Sortierung: \u201eSachkonto mit AfA-Konto\u201c wie folgt kombinieren:</p> <p>Filter: \u201eAfA 2018\u201c- Auswahl: \u201eNeue und Umgestellte\u201c - in Kombination mit der Sortierung: \u201eSachkonto mit AfA-Konto\u201c - zeigt z.B. den Anteil der unterj\u00e4hrigen AfA auf dem \u201eneuen\u201c AfA-Konto nach dem Switch des Anlagegutes/ Zuschusses an.</p> <p>Filter: \u201eAfA 2018\u201c- Auswahl: \u201eAlte und Umgestellte\u201c - in Kombination mit der Sortierung: \u201eSachkonto mit AfA-Konto\u201c - zeigt z.B. den Anteil der unterj\u00e4hrigen AfA auf dem \u201ealten\u201c AfA-Konto nachdem Switch des Anlagegutes/ Zuschusses an.</p> <p>Des Weiteren wird der Restbuchwert bei beiden Parametern anhand des AfA-Kontos entsprechend ausgewiesen</p> <p>\u00c4nderungsanzeige  Es wurde ein Fehler behoben, welcher in bestimmten F\u00e4llen das R\u00fccksenden einer erfolgreich abgearbeiteten \u00c4nderungsanzeige ans ARCHIKART verhinderte. Au\u00dferdem wurde in diesem Zusammenhang die Anzeige der Export-XML in die Aufgabenverwaltung (Men\u00fc 011) integriert. Darin werden die Daten angezeigt, welche zur\u00fcck ans ARCHIKART \u00fcbergeben werden. Des Weiteren wurde in der Aufgabenverwaltung ein Fehler beseitigt, welcher zum Programmabsturz f\u00fchrte. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#kosten-leistungsrechnung","title":"Kosten-/Leistungsrechnung","text":""},{"location":"aktuelles/releasehistorie/release4.1.0053/programmaenderungen_release_48.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s21 - Benutzerverwaltung </p> <p>Nutzerbezogenes, neues Recht \u201eAO-Email-Benachrichtigung\u201c erg\u00e4nzt. Dieses Recht wirkt ab sofort allein f\u00fcr die Mailbenachrichtigung im Bereich Anordnungsverwaltung und ersetzt gleichzeitig den Schalter F49 \u2013 \u201eEmail-Benachrichtigung bei Weiterleitung\u201c im Men\u00fc 11. Diesen Schalter gibt es nicht mehr. Voraussetzung f\u00fcr eine reibungslose Wirkung des Rechtes ist die korrekte FR-Konfiguration der Mailserver im Men\u00fc s11 (Systemparameter), \u00a0die Pflege der Benutzerverwaltung im Reiter \u201eNutzer\u201c (Emailadresse) und die entprechenden Einstellungen in den Schaltern F47 und F48 im Men\u00fc 11.</p> <p>s41 - Datenbereinigung In der Systemverwaltung Men\u00fc s341 werden die Parameter f\u00fcr die automatisch generierte Online-Update- Benachrichtigungs-Mail konfiguriert. </p> <p>In dieser E-Mail wird jetzt die zur Verf\u00fcgung stehende IFR-Versionsnummer \u00fcbertragen. Weiterhin wird die SASKIA\u00ae. de- IFR Updatebeschreibung als PDF-Anlage mit angef\u00fcgt. </p> <p>s51 - Protokoll-System </p> <p>\u00c4nderungen in den Adressdaten (Personenkonto) im Men\u00fc 128 werden im Men\u00fc s51 protokolliert und als alter und neuer Wert ausgewiesen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/installation_checkliste_relea6.html","title":"Installation Checkliste Release 4.1.0054","text":""},{"location":"aktuelles/releasehistorie/release4.1.0054/installation_checkliste_relea6.html#installation-checkliste-release-410054","title":"Installation Checkliste Release 4.1.0054","text":"<p>Vorg\u00e4ngerrelease ist Release 53</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/installation_checkliste_relea6.html#update","title":"Update","text":"<p>1. Alle SASKIA \u00ae .de IFR-Nutzer abmelden </p> <p>(auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 54.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/installation_checkliste_relea6.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>1. \u00a0 Releasewechsel 54 </p> <p>Nach herunterladen und installieren des Updates kann der Releasewechsel f\u00fcr Release 54 durchgef\u00fchrt werden.  Falls aus Vorg\u00e4nger-Releases noch offene Releasepunkte angezeigt werden, sind diese vorab - beginnend mit dem kleinsten noch offenem Release - auszuf\u00fchren </p> <p></p> <p>Durch Markieren des entsprechenden Punktes in der linken Tabelle werden die Punkte des Releasewechsels wie gewohnt in der rechten Tabelle dargestellt.</p> <ul> <li> <p>Datenbankstruktur anpassen Interne Anpassung der Datenbankstruktur in der Datenbank. Dieser Releasewechselpunkt hat keine Auswirkung auf den aktuellen Datenbestand.</p> </li> <li> <p>Datenbank\u00e4nderungen Anpassung des Datenbestandes an die neue Relaeseversion.</p> </li> <li> <p>KA_ADRNR jur_Pers-&gt;ohne_anschr Erg\u00e4nzung Adressverwaltung um ein Flag \u201eJuristische Person\u201c.</p> </li> <li> <p>Erg\u00e4nzt die Konfigurationsdaten f\u00fcr das DMS \"Enaio\" in den Schattenmandant Erg\u00e4nzung des OS Enaio DMS.</p> </li> <li> <p>entf. RechteArt.Prod Ehemaliges kamerales Recht \"Produkt\" wird entfernt.</p> </li> <li> <p>Erg\u00e4nzung der Budgetwerte f\u00fcr Ma\u00dfnahmenpl\u00e4ne in den zugeordneten E/B-Buchungsstellen Aus dem Budget-Segment der Finanzbuchungsstellen mit Ma\u00dfnahmen werden die Werte aus den Perioden 01-12 ausgelesen und in die zugeh\u00f6rigen Bilanzbuchungsstellen geschrieben. Die Perioden 01-12 werden ausschl. bei Plan\u00fcbernahmen \u00a0bebucht. Bei Plan\u00fcbernahmen wurden bisher jedoch die FR-Konto-Kaskaden nicht mit einbezogen. Ab Release 54 werden diese Kaskaden mit einbezogen und somit die Ma\u00dfnahmepl\u00e4ne, welche auf Finanzrechnungs-Konten geplant werden, automatisch auch auf den Bilanzkonten landen.</p> </li> <li> <p>Entfernt die RowID aus der Tabelle Vs_Eart. Interner Datenbankstrukturanpassung.</p> </li> <li> <p>Umstellung des Schalters F44 (S-H gerechtes Buchen) Interne Typanpassung des Schalters F44 von Zeichenkette auf einen numerischen Wert.</p> </li> <li> <p>Erg\u00e4nzung der Felder OP_SOLLIST und OP_ZAHLNG zur besseren Darstellung des S-H gerechten Buchens. </p> </li> <li> <p>Konvertierung der Datentypen aus der Tabelle Vs-Eart (VS_TAGNACH, VS_TAGGUT, VS_TAGKARENZ, VS_ANZRATEN, VS_ABSTRATEN, VS_ANZJAHRE) und VO_VERAN (VO_OBJ_NR) Interner Datenbankstrukturanpassung.</p> </li> <li> <p>Erg\u00e4nzt Parameter in der Um_Ini bei den Queries f\u00fcr das IFR-Datawarehouse Erg\u00e4nzung des SASKIA\u00ae-DWS f\u00fcr das IFR. </p> </li> <li> <p>Entfernt die RowId aus der Tabelle Ks_St_Def und konvertiert die Decimal-Spalten in Integer Interner Datenbankstrukturanpassung.</p> </li> <li> <p>Entfernung des Assembly-Binding-Redirect aus der App-config Anpassung von Config-Dateien</p> </li> </ul> <p>Releasewechselpunkt: Entfernung des Assembly-Binding-Redirect aus der App-config</p> <p>Nach Einspielung des Releases kann es beim Start der Systemverwaltung zu einer Fehlermeldung kommen. Hierzu muss \"h\u00e4ndisch\" eine \u00c4nderung der Datei Systemverwaltung.exe.config vorgenommen werden. Alle anderen config-Dateien werden durch den Releasewechsel automatisch angepasst.</p> <p></p> <p>Die Systemverwaltung.exe.config finden Sie im \"Progs\"-Ordner des SASKIA-Servers.</p> <p></p> <p>Die Datei ist mittels Editor oder Notepad++ zu \u00f6ffnen und die Anpassung wie untenstehend beschrieben vorzunehmen und abzuspeichern.</p> <p></p> <p>2. Aktualisierung des Schattenmandanten </p> <p>Mit Release 54 wird ein neuer Schattenmandant ausgeliefert. Bitte die Aktualisierung durchf\u00fchren f\u00fcr: </p> <ul> <li>DMS Konfigurationen laden </li> </ul>"},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#letzte-programmanderungen","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#auslieferung-zum-31012020-version-33115","title":"Auslieferung zum 31.01.2020 - VERSION 33115","text":""},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#buchung","title":"Buchung","text":"<p>394 - Budget\u00fcbersicht </p> <p>Die Anzeige der investiven Planans\u00e4tze auf Buchungsstellen mit Ma\u00dfnahmen und Verpflichtungserm\u00e4chtigungen (VEs) wurde korrigiert. \u00a0</p> <p>WICHTIG! Zur Korrektur der falschen Plan-Verkehrszahlen ist nach der Einspielung des aktuellen Programmstandes die Ausf\u00fchrung des nachfolgend markierten Releasewechselpunktes erforderlich! Planen Sie f\u00fcr diese Aktion etwas mehr Zeit (ca. 30 - 45 min) ein.</p> <p></p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#auslieferung-zum-20012020-version-32975","title":"Auslieferung zum 20.01.2020 - VERSION 32975","text":""},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#stammdaten","title":"Stammdaten","text":"<p>11 - Mandantenverwaltung </p> <p>Im Schalter F44 gibt es eine weitere Einstellungsm\u00f6glichkeit: \"PK-Einzelbuchung\". Diese steuert nur die \u00dcbernahme der offnen Betr\u00e4ge aus der OP-Auswahl, bei negativem Betr\u00e4gen bspw. bei \u00dcberzahlungen. Wird die Auswahl \"PK-Einzelbuchung\" im Schater F44 getroffen, so wird bspw. eine \u00dcberzahlung beim Ziehen des OP's positiv und mit umgekehrtem S/H-Kennzeichen dargestellt.Die Buchung wird bei BEIDEN Einstellungen weiterhin mit negativem Betrag verbucht.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#planung","title":"planung","text":"<p>Allgemein </p> <p>Zur getrennten Darstellung von Verf\u00fcgbarkeiten auf investiven Finanzrechnungskonten (Kontenart F1 und F2) und deren verbundenen Quellkonten (Kontenart A0) wurde es erforderlich, die Finanzplanung proforma auch auf die bilanziellen Quellkonten saldiert zu \u00fcbertragen. Dadurch wird keine extra Bilanzplanung notwendig! Dies geschieht ausschlie\u00dflich f\u00fcr bilanzielle Quellkonten.  Ergebniskonten der Kontenart A0, die f\u00fcr Instandhaltung/Instandsetzung gebraucht werden und ebenfalls mit einer Ma\u00dfnahme versehen sind, werden wie bisher weiter im ER- und FR-Bereich einzeln geplant.</p> <p>242 - Ergebnisplanerfassung </p> <p>Beim Ausweis der Vorjahreswerte (Haken gesetzt bei \"mit Vorjahr-Spalte\") in der Planmaske kam es unter bestimmten Datenkonstellationen zu keiner Anzeige der im Vorjahr gebuchten Werte. Hierzu erfolgte eine Programmkorrektur.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#buchung_1","title":"Buchung","text":"<p>394 - Budget\u00fcbersicht </p> <p>In der Budget\u00fcbersicht wurde die Datenaufbereitung der gebuchten Werte, insbesondere Spalte \"gebucht\", an eine Soll/Haben-gerechte Darstellung unter Ber\u00fccksichtigung der verschiedenen Buchungsschl\u00fcssel und Kontenarten angepasst.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#auswertungen","title":"Auswertungen","text":"<p>6523 - Druck Teilergebnisrechnung </p> <p>Es wurden Korrekturen f\u00fcr die Erstellung des Druckberichts \"Teilfinanzrechnung B\" bei Buchung \u00dcPL/APL sowie Budgetanpassungen vorgenommen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#jahreswechsel","title":"Jahreswechsel","text":"<p>72 - Kassenjahreswechsel </p> <p>Die Pr\u00fcfung auf offene Auftr\u00e4ge im Kassenjahreswechsel wurde angepasst und pr\u00fcft jetzt wieder ausschlie\u00dflich VE-Auftr\u00e4ge.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#auslieferung-zum-20122019-version-32740","title":"Auslieferung zum 20.12.2019 - Version 32740","text":""},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#stammdaten_1","title":"Stammdaten","text":"<p>11 - Mandant </p> <p>Die Vorgabe im Schalter F37 f\u00fcr den Ausweis der weiteren Bescheidempf\u00e4nger / betroffenen Personen in allen Bescheiden) wirkt nur noch auf diese Angaben, der Debitor/Kreditor wird stets mit Anschrift ausgewiesen.  Bei F37 (vollst\u00e4ndiger Ausweis weiterer Bescheidempf\u00e4nger) = Nein werden soweit gef\u00fcllt die Felder 'Name1, Name2, Name3 und Vorname' ausgewiesen.Schalter F05 und Schalterstellung \"JA\": Der im Men\u00fc 311 (Einzelbuchung) eingegebene (Raten)-Betrag wird auf die eingegebene Ratenanzahl hochgerechnet.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#buchung_2","title":"Buchung","text":"<p>311 - Einzelbuchung </p> <p>Schalter F05 und Schalterstellung \"JA\": Der im Men\u00fc 311 (Einzelbuchung) eingegebene (Raten)-Betrag wird auf die eingegebene Ratenanzahl hochgerechnet.</p> <p>Im Schalter 44 gibt es eine weitere Einstellungsm\u00f6glichkeit: \"PK-Einzelbuchung\". Diese steuert nur die \u00dcbernahme der offnen Betr\u00e4ge aus der OP-Auswahl, bei negativem Betr\u00e4gen bspw. bei \u00dcberzahlungen. Wird die Auswahl \"PK-Einzelbuchung\" im Schater F44 getroffen, so wird bspw. eine \u00dcberzahlung beim Ziehen des OP's positiv und mit umgekehrtem S/H-Kennzeichen dargestellt.Die Buchung wird bei BEIDEN Einstellungen weiterhin mit negativem Betrag verbucht.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#jahresabschluss","title":"Jahresabschluss","text":"<p>72 - Kassenjahreswechsel </p> <p>F\u00fcr den Kassenjahreswechsel m\u00fcssen zwingend Auftr\u00e4ge aus Verpflichtungserm\u00e4chtigungen in das Folgejahr \u00fcbernommen werden. F\u00fcr alle weiteren Auftr\u00e4ge ist es nicht notwendig diese ins Folgejahr zu \u00fcbernehmen, um den Kassenjahreswechsel durchzuf\u00fchren.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#veranlagung","title":"Veranlagung","text":"<p>82 - Gesamtveranlagung </p> <p>Die vor\u00fcbergehend unterschiedlich wirkenden Vorlagenoptionen in der Einzelveranlagung und der Gesamtveranlagung wurden wieder auf gleiche Wirkungsweise gestellt. \u00a0 </p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#auslieferung-zum-17122019-version-32702","title":"Auslieferung zum 17.12.2019 - Version 32702","text":""},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#buchungen","title":"Buchungen","text":"<p>311 - Einzelbuchung </p> <p>Aufgrund der angek\u00fcndigten Umstellung der Einzelbuchungsmaske (Buchungsbetrag mit Soll/Haben-Kennzeichen) kam es bei der Verbuchung mit Buchungsschl\u00fcssel 421 / 521 zu einer fehlerhaften Ausf\u00fchrung der Zahlung. Dieser Fehler wurde behoben.</p> <p>Der OP-Betrag wird bei einer Buchung mit Buchungsschl\u00fcssel 631 / 731 wieder in das Betragsfeld \u00fcbernommen und kann ordnungsgem\u00e4\u00df verbucht werden. Genauso ist auch die Mehrfachauswahl von OP's gew\u00e4hrleistet.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/letzte_programmaenderungen4.html#veranlagung_1","title":"Veranlagung","text":"<p>81 - Veranlagung</p> <p>Die Auswahl eines Objektes \u00fcber den Button \"Objekt\" f\u00fchrte unter bestimmten Bedingungen zur Beendigung des Programms. Dieser Fehler wurde beseitigt, so dass der gewohnte Objektaufruf wieder genutzt werden kann.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html","title":"Programm\u00e4nderungen Release 4.1.0054","text":""},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#programmanderungen-release-410054","title":"Programm\u00e4nderungen Release 4.1.0054","text":""},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#auslieferung-zum-13122019","title":"Auslieferung zum 13.12.2019","text":""},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#_1","title":"Programm\u00e4nderungen Release 4.1.0054","text":""},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#global","title":"Global","text":"<p>0332 - automatisches Ausblenden des Navigators </p> <p>Wurde diese Option in einer Sitzung gew\u00e4hlt, steht der Navigator beim erneuten Anmelden am Programm sofort wieder zur Verf\u00fcgung. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#stammdaten","title":"Stammdaten","text":"<p>12a3 - Personenkontenverwaltung </p> <p>Das PK-Stammblatt wurde um die externe Kundennummer erweitert.</p> <p>In der Personenkundenverwaltung k\u00f6nnen f\u00fcr Kreditoren deren Freistellungsbescheinigungen detailliert erfasst werden.</p> <p>(\u00dcbergabe an avviso) </p> <p>F\u00fcr die eindeutige Kennzeichnung eines Personenkontos als Juristische Person, wurde in der Personenkontenverwaltung unter dem Reiter \u201eKontierung\u201c, das Kennzeichen \u201ejuristische Person\u201c integriert. Dieses Kennzeichen erm\u00f6glicht, eine eindeutige sowie korrekte Adress\u00fcbergabe (Juristische Person | Nat\u00fcrliche Person) \u00fcber das Men\u00fc \u201e48 - Vollstreckung\u201c an avviso. Die Kennzeichnung Juristische Person wird \u00fcber den Releasewechsel anhand des Anrede-Mappings in der avviso Schnittstelle entsprechend automatisch gesetzt.</p> <p>12a9 - Mandate l\u00f6schen </p> <p>Um die Nachvollziehbarkeit zu verbessern, zu wem ein Mandat geh\u00f6rt - was gel\u00f6scht werden kann - wurden die Spalten Name1 und Name 2 erg\u00e4nzt. </p> <p>152 - Veranlagung/Einnahmearten </p> <p>F\u00fcr spezielle Einnahme- / Abgabearten der Veranlagung kann mittels neuem Parameter 'Mindestbetrag Vorauszahlung' ein Wert vorgegeben werden, bis zu dem keine Vorauszahlungen festgesetzt werden.  Die jeweilige Geb\u00fchr wird erst bei der Abrechnung festgesetzt und damit f\u00e4llig.</p> <p>Eine Umstellung vorhandener Veranlagungen ist mit der IFR-Fachberatung abzustimmen</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#planung","title":"Planung","text":"<p>2 - \u00a0Allgemein </p> <p>In den Planungsmasken sowie Planauskunftsmasken kann eine Produktauswahl getroffen werden, auch wenn der Nutzer eingeschr\u00e4nkte Budgetrechte hat. </p> <p>243 - Ma\u00dfnahmenplan </p> <p>Beim Aktualisieren der Anzeige f\u00fcr die \"VE aus Vorjahr\" \u00fcber die Option \"Standardansicht herstellen\" kam es zu dem Problem, dass in den Spaltenk\u00f6pfen die HH-Jahre verschwanden. Diese Verhalten wurde korrigiert.</p> <p>242 - \u00a0Ergebnisplan </p> <p>Es gibt zuk\u00fcnftig die M\u00f6glichkeit die Aktualisierung der Planvariante, \u00fcber Doppelklick auf den Laufbalken, zu unterbrechen, wenn man ausversehen die Maskenaktualisierung ohne Selektionseinschr\u00e4nkung oder ung\u00fcnstige Selektionseingaben gestartet hat. Des Weiteren gibt es jetzt auch eine Gesamtsummenzeile, wenn man mit der Vergleichsplanvariante arbeitet.</p> <p>246 - Pflege Planerl\u00e4uterungstexte </p> <p>Planerl\u00e4uterungstexte k\u00f6nnen ab diesem Release je Budget gedruckt werden. Daf\u00fcr wurde das Filterfeld \"Budget\" in der Maske erg\u00e4nzt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#buchung","title":"Buchung","text":"<p>311 - Einzelbuchung </p> <p>Wenn bei Sachkonten die Steuerart \"1\" (beliebige Steuerkennzeichen) hinterlegt ist, muss nun zwingend bei der Buchung ein Steuerkennzeichen angegeben werden, anderenfalls kommt es zu einer Fehlermeldung und eine Buchung ist nicht m\u00f6glich. Wenn eine Buchung ohne Angabe eines Steuerkennzeichens erfolgen soll (nicht steuerbare Vorg\u00e4nge), dann ist die Steuerart \"0\" (ohne Steuerkennzeichen) zu hinterlegen.</p> <p>Bei Zahlwegsumbuchung mit den Buchungsschl\u00fcsseln 231 und 331 wurde die Anzeige der Finanzrechnungskonten in der Buchungsmaske korrigiert. \u00a0Beim Buchungsschl\u00fcssel 231 wird nun das Einzahlungskonto angezeigt und beim BS 331 das Auszahlungskonto, was nun auch den Buchungen entspricht. </p> <p>Bei der Auswahl der externen Kundennummern auf der Buchungsmaske erfolgte die Anzeige der Kundennummern doppelt. Dies wurde behoben.</p> <p>Buchungsschl\u00fcssel 290 - bei Beginn der Auswahl der Buchungsstelle mit dem Sachkonto gab es ein Problem mit der Auswahl des zugeh\u00f6rigen Produktes. Hierzu erfolgte eine Korrektur.</p> <p>Nach der \u00dcbernahme der Buchung liegt jetzt der Fokus in der Weiterleitungsbox auf dem Button \"OK\". </p> <p>In der Einzelbuchungsmaske ist es m\u00f6glich mittels Soll/Haben Kennzeichen, welches sich hinter dem Buchungsbetrag befindet, Rotbuchungen zu vermeiden. Standardm\u00e4\u00dfig wird das Soll-/Habenkennzeichn korrekt und bezugnehmend auf das Aufwands- bzw. Ertragskonto dargestellt. Es besteht die M\u00f6glichkeit, dies durch Eingabe eines \"S\" bzw \"H\" zu \u00e4ndern und somit Konto und Gegenkonto zu vertauschen.  </p> <p>Wenn im Zuge der Einzelbuchungsmaske das Soll/Haben Kennzeichen gedreht wird, um eine Negativbuchung zu vermeiden, sollte in Verbindung mit der Auswertung im USt-Modul folgendes beachtet werden: Die \"Soll-Haben gerechte Darstellung\" sollte mittels Rechtsklick auf die Tabelle abgew\u00e4hlt werden und die neue Spalte \"Bemessungsgrundlage (BMG)\" mit hinzugezogen werden, um eine bessere \u00dcbersicht der Sachlage zu bekommen.</p> <p>36 - Anordnung </p> <p>Die Budgeteinschr\u00e4nkung (Einschr\u00e4nkung Nutzerrechte) wirkt jetzt im Men\u00fc 36 Anordnungsverwaltung sowie in allen anderen relevanten Men\u00fcpunkten.</p> <p>Bei der Abweisung einer Anordnung, welche mit Buchungsschl\u00fcssel 233 durchgef\u00fchrt wurde, wurde die Buchung nicht vollst\u00e4ndig abgewiesen, was zu Problemen beim Tagesabschluss f\u00fchrte. Hierzu erfolgte eine Korrektur.</p> <p>391 - Personenkonten </p> <p>In der OP-Anzeige der Personenkontenauskunft gibt es zwei neue Spalten: \"Ford./Verb.\", sowie \"Einz./Ausz.\". Beide zeigen jeweils kumulierte Werte an. Mit der neuen Schalterm\u00f6glichkeit F44 sollen k\u00fcnftig Negativbuchungen auch Soll/Haben vertauscht gebucht werden k\u00f6nnen. Dies hat ebenso Auswirkungen auf die OP-Anzeige. Mit diesen neuen Ansichten wird eine ordnungsgem\u00e4\u00dfe Darstellung des OP's gew\u00e4hrleistet. Die aktuellste Zeile des OP's zeigt hierbei \u00a0in der Spalte: \"Ford./Verb.\" an, ob die Forderung bzw. Verbindlichkeit insgesamt ausgeglichen ist (Wert =0) oder ob noch Ausst\u00e4nde bestehen. Die Ein- bzw. Auszahlungsspalte, zeigt den gesamten Zahlungsbestand des OP's an (kumuliert!).</p> <p>393 - Buchungsrecherche </p> <p>In der Buchungsrecherche wurde die Recherchefunktionalit\u00e4t \"Abgrenzung Quartalsstatistik\" um die Option \"kumulativ\" erweitert.</p> <p>Die Suchfelder werden nach dem L\u00f6schen der Inhalte korrekt geleert und die richtige Werte nach dem Start einer neuen Suche angezeigt. </p> <p>394 - Budget\u00fcbersicht </p> <p>Das Speichern und der Wiederaufruf von nutzerbezogenen Ansichten in der Budget\u00fcbersicht erfolgt nun auch f\u00fcr Nutzer deren Loginname mit Gro\u00dfbuchstaben (zB. FMustermann) beginnt fehlerfrei.</p> <p>Es wurde die noch Spalte \"Gebucht + Reserviert\" in die Budget\u00fcbersicht integriert.</p> <p>3a11 - Abgleichsregeln </p> <p>Im Men\u00fc 3a11 Abgleichsregeln wurde der grahisch-unterst\u00fctzte Abgleichsregelgenerator um einige Funktionalit\u00e4ten erweitert. Damit k\u00f6nnen mehr Sachverhalte abgebildet werden, ohne den Makroeditor nutzen zu m\u00fcssen.</p> <p>3a2 - Kontoauszug / Abgleich </p> <p>Es gibt ein neues Selektionsfeld f\u00fcr die Kontoauszugsnummer. In diesem k\u00f6nnen die Kontoauszugsnummern einzeln, als Aufz\u00e4hlung mit Doppelpunkt bzw. Semikolon angegeben werden.</p> <p>3a4 - Kontoauszugsdruck </p> <p>Im Men\u00fc 3a4 Kontoauszugsdruck wurden \u00a0bei Verwendung der Zusatzinformation \"Kontierung\" \u00a0die Angaben um den Buchungsschl\u00fcssel und im gebildeten Kassenzeichen die Kennzeichnung D (f\u00fcr Debitor) und K (f\u00fcr Kreditor) erg\u00e4nzt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#op-bearbeitung","title":"OP-Bearbeitung","text":"<p>41 - Aufrechnung </p> <p>F\u00fcr eine bessere Auswahl der OP's k\u00f6nnen jetzt die Spalten mit den Werten unter dem Reiter \"Aufrechnung\" sortiert werden.</p> <p>Die Bezeichnung Buchungstext2 und der Name des Buchungsstapels hei\u00dfen jetzt Aufrechnung(en).</p> <p>42 - Stundung </p> <p>Auch im Nebenbuch \"Stundung\" ist die Buchung statt negativer Betr\u00e4ge, nun mit umgekehrtem Buchungssatz (Soll/Haben vertauscht) \u00fcber den Schalter F44 m\u00f6glich. Der neue Widerrufsbescheid der Stundung weist die Restschuld f\u00fcr die jeweils betroffenen F\u00e4lligkeiten aus. Dabei bestehen zus\u00e4tzlich \u00fcber die Vorlagenoptionen die M\u00f6glichkeiten, die 'Erl\u00e4uterungen der Restschuld' \u00a0auszuweisen und die bei dieser Option enthaltenen Informationen zu den \u00a0einzelnen Festsetzungen der Stundungszinsen zu belegen oder diese auszublenden.</p> <p>421 - Stundung - Bearbeiten </p> <p>Der neue Widerrufsbescheid der Stundung weist die Restschuld f\u00fcr die jeweils betroffenen F\u00e4lligkeiten aus. Dabei besteht zus\u00e4tzlich \u00fcber die Vorlagenoptionen die M\u00f6glichkeit, die 'Erl\u00e4uterungen der Restschuld' \u00a0auszuweisen und die bei dieser Option enthaltenen Informationen zu den \u00a0einzelnen Festsetzung der Stundungszinsen zu belegen oder diese auszublenden.</p> <p>431 - AdV-Verwaltung </p> <p>Wird der Schalter F44 gesetzt, gibt es f\u00fcr die AdV keine \u00c4nderung der Buchungsweise.</p> <p>441 - Niederschlagung </p> <p>Wenn der Schalter F44 f\u00fcr die Niederschlagung aktiviert wird, kommt es k\u00fcnftig bei Aufhebung und Anpassung einer NDS zur Drehung des Buchungssatzes, so dass kein negativer Buchungsbetrag zustande kommt. Ist der Schalter f\u00fcr die Niederschlagung inaktiv, wird bei den genannten Sachverhalten wie bisher gebucht.</p> <p>444 - Wertberichtigungsbearbeitung </p> <p>Der Schalter F44 hat bei der \u00c4nderung der Einzelwertberichtigung keine Auswirkung. Wird eine Forderung einzelwertberichtigt und in einem Folgejahr verringert, so wird in jedem Fall die Forderung an den Ertrag mit positivem Wert gebucht.</p> <p>46 - Sperren </p> <p>Um eine schnellere Entscheidung zu erm\u00f6glichen ob ein OP gesperrt werden soll, gibt es zwei neue Spalten \"offener Betrag\" und \"urspr. offener Betrag\" zum jeweiligen OP. </p> <p>48 -Vollstreckung </p> <p>(\u00dcbergabe an avviso) </p> <p>F\u00fcr die eindeutige Kennzeichnung eines Personenkontos als Juristische Person, wurde in der Personenkontenverwaltung unter dem Reiter \u201eKontierung\u201c, das Kennzeichen \u201ejuristische Person\u201c integriert. Dieses Kennzeichen erm\u00f6glicht, eine eindeutige sowie korrekte Adress\u00fcbergabe (Juristische Person | Nat\u00fcrliche Person) \u00fcber das Men\u00fc \u201e48 - Vollstreckung\u201c an avviso. Die Kennzeichnung Juristische Person wird \u00fcber den Releasewechsel anhand des Anrede-Mappings in der avviso Schnittstelle entsprechend automatisch gesetzt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#auftragfaktura","title":"Auftrag/Faktura","text":"<p>51 - Auftragsverwaltung </p> <p>Musterauftr\u00e4ge k\u00f6nnen ab diesem Release gel\u00f6scht werden. Dazu den Musterauftrag markieren und mit Klick auf den Button \"L\u00f6schen\" unwiderbringlich l\u00f6schen. Der L\u00f6schbutton steht nur f\u00fcr Musterauftr\u00e4ge zur Verf\u00fcgung.</p> <p>Die Best\u00e4tigung der Auftr\u00e4ge in der Auftragsverwaltung ist wieder \u00fcber den Doppelklick in die Box vor den Auftrag zu setzen (Haken setzen). Die Best\u00e4tigung mittels Markierung der Zeile entf\u00e4llt.</p> <p>52 - Eingangsrechnungsjournal </p> <p>Wenn der Mandantenschalter F34 auf \"JA\" gesetzt wurde, dann wird der aktuelle Budgetverantwortliche (Men\u00fc 141) f\u00fcr diese Buchungsstelle ermittelt und als Weiterleitungsnutzer eingetragen. Sollte der Budgetverantwortliche nicht als aktiver IFR-Nutzer angelegt sein, wird beim Weiterleitungsnutzer der aktuell am IFR angemeldete Nutzer eingetragen.</p> <p>Ist der Schalter F44 f\u00fcr das Eingangsrechnungsjournal aktiviert, werden bei einer Stornierung einer Eingangsrechnung anstatt einer Negativbuchung die Konten vertauscht und der Betrag positiv gebucht. Der Schalter darf nicht unterj\u00e4hrig  ver\u00e4ndert werden! Bitte stimmen Sie sich im Vorfeld mit der Fachberatung IFR ab.</p> <p>Bei der \u00dcbernahme eines Dokumentes (Rechnung) aus einem angeschlossenen DMS in das Eingangsrechnungsjournal wird eine Hinweis angezeigt, wenn das Dokument bereits von einem anderen Nutzer bearbeitet wird.</p> <p>54 - Ausgangsrechnungsjournal </p> <p>Die Einschr\u00e4nkung, dass bei Rechnungserfassung und PK-Auswahl die Eingrenzung auf Debitoren im Feld \"Funktion\" beschr\u00e4nkt ist, wirkt wieder. Nach dem Abtauchen im Feld \"Debitor\" wird das Feld \"Funktion\" mit einem \"D\" f\u00fcr Debitor vorbelegt.</p> <p>Die Angabe eines Ratenabstandes ist bei Tarifen bei den nur eine Rate als Standard definiert ist nicht mehr notwendig.</p> <p>Beim Erzeugen von Ausgangsrechnungen \u00fcber die Musterauswahl kam es zu einer fehlerhaften Vorbelegung des Feldes \"Debitor\" mit einem Strich, was die Auswahl eines PK's behinderte.</p> <p>Nach dem Rechnungsdruck wurde der Status \"gedruckt\" noch nicht ordentlich aktualisiert. Hierzu erfolgte ein Anpassung.</p> <p>Beim Stornieren einer Ausgangsrechnung, wurde auf der AO nicht ersichtlich, dass es sich um eine Storno-AO handelt, da der Aufdruck \"Storno\" fehlte. Hierzu erfolgte eine Korrektur.</p> <p>Wird der Schalter F44 beim Nebenbuch ARJ gesetzt, erfolgt die Soll/Haben-gerechte Buchung. Der Schalter darf nicht unterj\u00e4hrig  ver\u00e4ndert werden! Bitte stimmen Sie sich im Vorfeld mit der Fachberatung IFR ab.</p> <p>Wenn eine Ausgangsrechnung mit dem Status \"gedruckt\", \"AO\" oder \"verbucht\" \u00a0im Bearbeitungsmodus dupliziert wird, dann wird nur die duplizierte (neue) Ausgangsrechnung f\u00fcr den Rechnungsdruck (und Ablage im DMS) ber\u00fccksichtigt. Wird eine Ausgangsrechnung mit Status \"Erfasst\" im Bearbeitungsmodus dupliziert, dann werden beide Ausgangsrechnungen f\u00fcr den Rechnungsdruck und die Ablage im DMS ber\u00fccksichtigt.</p> <p>Wird eine neue Ausgangsrechnung mit ein oder mehreren Positionen der gleichen EArt erfasst und diese EArt ist als OP-Bezug einer Zustelleradresse zugeordnet, dann wird der Bescheid/die Rechnung korrekterweise mit der hinterlegten Zustelleradresse ausgewiesen.</p> <p>Es werden in den Rechnungspositionen ausschlie\u00dflich die Buchungsschl\u00fcssel 411 und 413 zur Auswahl zugelassen.</p> <p>Wird ein umsatzsteuerpflichtiger Sachverhalt im ARJ negativ ausgewiesen, wird die gesamte Umsatzsteuer auf dem Report ausgewiesen. \u00a0 </p> <p>55 - Stammdaten </p> <p>Nach Aufruf des Men\u00fcpunktes werden jetzt alle Tarife und Tarifegruppen des voreingestellten Mandanten sofort angezeigt. Es bedarf keiner zus\u00e4tzlichen Aktualisierung mehr.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#auswertungen","title":"Auswertungen","text":"<p>6 - Allgemein </p> <p>Allgemeine Drucklisten k\u00f6nnen nach entsprechender Einrichtung durch die Fachberatung auch mit an ein DMS \u00fcbergeben werden. </p> <p>623 - Summen- und Saldenliste </p> <p>Bei der Summierung der Summen-Salden-Liste kam es zu einem Fehler beim Ausweis der Summen. Hierzu erfolgte eine Korrektur, so dass jetzt wieder die richtigen Summen angezeigt werden. </p> <p>631 - Bilanz </p> <p>Beim \u00dcbertrag des Ergebnisvortrages (Listenergebnisposition = V) von einem Bilanzjahr auf das n\u00e4chste kam es zu einem Fehlverhalten in der Berechnung. Hierzu erfolgte eine Korrektur. </p> <p>67 - Umsatzsteuer </p> <p>Mit dem Rel 54 ist das USt-VA-Formular f\u00fcr 2020 nutzbar, sowie die Umsatzsteuerjahreserkl\u00e4rung f\u00fcr 2019.</p> <p>Wenn im Zuge der Einzelbuchungsmaske das Soll/Haben Kennzeichen gedreht wird, um eine Negativbuchung zu vermeiden, sollte in Verbindung mit der Auswertung im USt-Modul folgendes beachtet werden: Die \"Soll-Haben gerechte Darstellung\" sollte mittels Rechtsklick auf die Tabelle abgew\u00e4hlt werden und die neue Spalte \"Bemessungsgrundlage (BMG)\" mit hinzugezogen werden, um eine bessere \u00dcbersicht der Sachlage zu bekommen.</p> <p>672 - Meldung </p> <p>Auch in der Umsatzsteuererkl\u00e4rung (Jahresmeldung) werden die eingetragenen Formularwerte ausschlie\u00dflich anhand der zugeordneten Buchungen berechnet. Die ausstehenden Buchungen des Jahres, die noch nicht zugeordnet wurden, bleiben f\u00fcr die Wert\u00fcbertragung in das Formular unber\u00fccksichtigt.</p> <p>Wird f\u00fcr die Tabellen des USt-Moduls, die \"Soll-Haben gerechte Darstellung\" deaktiviert, so kann ab sofort (nachdem die Gruppierung auf das Steuerkennzeichen gesetzt wurde) direkt die Bemessungsgrundlage f\u00fcr das Steuerkennzeichen abgelesen werden (bisher wurde hier SOLL und HABEN getrennt angezeigt). Dies ist eine neue Spalte, welche der Gruppierungsfunktion dient. Somit kann auch in den Tabellen, die die steuerbehafteten Buchungen f\u00fchren, auf einen Blick festgestellt werden, wie hoch die Bemessungsgrundlage pro Steuerkennzeichen ist.</p> <p>Bisher brauchte der Anwender Zugriffsrechte auf den Ordner, indem die ELSTER logs gespeichert werden, um die USt-Meldung elektronisch zu versenden zu k\u00f6nnen. Gab es dieses Zugriffsrecht nicht, kam es zum Initialisierungsfehler beim Senden der Meldung.</p> <p>Gibt es nun eingeschr\u00e4nkte Zugriffsrechte, erscheint nun zun\u00e4chst die Fehlerausschrift \"Ungen\u00fcgende Zugriffsrechte f\u00fcr Elster-Log-Verzeichnis\".</p> <p>Au\u00dferdem kann der Admin nun einen eigenes Log-Verzeichnis f\u00fcr Elster bestimmen (dadurch braucht der Anwender nicht mehr zwingend Zugriffsrechte auf den progs-Ordner des SASKIA SERVERS).</p> <p>Dazu wird ein neuer Eintrag in die Ifr.exe.config erg\u00e4nzt : </p> <p>Ist dieser Eintrag in der Config-Datei nicht erg\u00e4nzt, gilt der Pfad wie bisher.</p> <p>K\u00fcnftig zeigt die UST-Zusammenstellung alle vorhandenen, wenn auch nicht bebuchten Steuerkennzeichen an. Grund hierf\u00fcr ist, dass Istversteuerte Vorg\u00e4nge in der Spalte \"Nicht f\u00e4llige Stuer\" nicht angezeigt wurden, wenn das Steuerkennzeichen in der Periode noch keine f\u00e4lligen Steuern beinhaltete.</p> <p>Zur Information: Ausstehende Buchungen der zu betrachtenden Periode, die noch nicht zugeordnet wurden, werden ebenfalls in die Spalte der \"nicht f\u00e4llige Steuer\" geschrieben.</p> <p>68 - Freie Auswertungen </p> <p>Die \u00dcberschrift der freien Auswertung FS7001 ist an die aktuelle Gesetzgebungsnamen angepasst worden (ge\u00e4ndert von \"gem. \u00a746 S\u00e4chs. KomHVO-Doppik\" auf \"gem. \u00a746 S\u00e4chs. KomHVO\").</p> <p>6s - Dokumentenmappe </p> <p>Es erfolgt keine Verdopplung der Dokumente in den Gliederungspunkten mehr. Beim lokalen Abspeichern der Dokumentenmappe als PDF sind die Lesezeichen enthalten.</p> <p>Fremddokumente, die per Upload in die Dokumentenmappe eingepflegt werden, werden nicht mehr doppelt in der erstellten Dokumentenmappe angezeigt. </p> <p>Nach dem Bearbeiten und \u00dcbernehmen der Dokumentenmappe und dem Zur\u00fcckgehen in die \u00dcbersichtsmaske, wird der Focus auf die urspr\u00fcnglich ausgew\u00e4hlte Dokumentenmappe gelegt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#jahresabschluss","title":"Jahresabschluss","text":"<p>713 - Umbuchung GwSt Erstattungszins </p> <p>Bei der Druckliste f\u00fcr die Umbuchung der Erstattungszinsen, gab es eine falsche Spalten\u00fcberschrift. Es erfolgte eine \u00c4nderung von \"Bescheiddatum\" auf \"F\u00e4lligkeit\".Au\u00dferdem wurde die Datenbereitstellung \u00fcberarbeitet, so dass die Summe der Erstattungszinsen pro Bescheid gerundet wird und nicht mehr die Erstattungszinsen einer Periode. </p> <p>Bei der Druckliste f\u00fcr die Umbuchung der Erstattungszinsen, gab es eine falsche Spalten\u00fcberschrift. Es erfolgte eine \u00c4nderung von \"Bescheiddatum\" auf \"F\u00e4lligkeit\". Au\u00dferdem wurde die Datenbereitstellung \u00fcberarbeitet, so dass die Summe der Erstattungszinsen pro Bescheid gerundet wird und nicht mehr die Erstattungszinsen einer Periode. </p> <p>74 - endg\u00fcltiger Jahresabschluss </p> <p>Bei der Pr\u00fcfung zum Jahresabschluss wird jetzt zus\u00e4tzlich \u00fcberpr\u00fcft, ob ein Sachkonto bzw. Produkt im Folgejahr das Flag \"bebuchbar\" hat, um eventuelle Saldenvortr\u00e4ge zu \u00fcbernehmen. Betroffene Sachkonten/Produkte bei denen dieses fehlt, werden im Protokoll aufgelistet. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#veranlagung","title":"Veranlagung","text":"<p>8 - Veranlagung </p> <p>F\u00fcr die Verbuchung aus der Veranlagung wurde die Bildung der Buchungsperioden entsprechend 'Kommentar zum S\u00e4chs. Haushaltsrecht zu \u00a7 37 S\u00e4chsKomHVO (Doppik) Nr. 36 und SSG \u2013 Mitgliederrundschreiben Nr. 516/10 vom 08.09.2010' \u00a0\u00fcberarbeitet: Festsetzungen, die als Abrechnungen erfasst werden (Art: A / AB / AV \u00a0- soweit in den jeweiligen Einnahmearten in Anwendung, z.B. Gewerbesteuer ) und Festsetzungen mit Art VB, f\u00fcr die im Stammdatenmen\u00fc 152 die Einnahmearten-Option '\u00c4nderung \u00a0= Abrechnung' gesetzt ist, werden in die Periode lt. Bescheiddatum gebucht. Zus\u00e4tzlich erfolgt \u00a0in derartigen Einnahmearten f\u00fcr die \u00a0FA-Bescheide. die \u00a0bereits im alten Haushaltsjahr eingegangen sind und deren Bescheidschreibung in der Verwaltung erst im neuen Jahr durchgef\u00fchrt wird, die Buchung ins alte Haushaltsjahr, wenn die Option 'Abrechnungsbuchungen ins Vorjahr' gesetzt ist und aus der Festsetzung eine Verbindlichkeit resultiert.</p> <p>81 - Einzelveranlagung </p> <p>Wird der Schalter F44 gesetzt, wird Soll / Haben- gerecht verbucht.</p> <p>82 - Gesamtveranlagung </p> <p>Mit der Funktionalit\u00e4t 'Jahreswechselwerte zur\u00fccksetzen' \u00a0im Men\u00fc 82 - Gesamtveranlagung - Reiter 'Sonstiges' \u00a0werden f\u00fcr die allgemeinen Steuern und wiederkehrenden Einnahmen die Angaben zu den F\u00e4lligkeiten ab dem neuen Jahr (Datum 1. F\u00e4lligkeit, Anzahl der Raten, Ratenabstand), f\u00fcr die Gewerbesteuern die Werte 'Messbetrag' und 'Soll neues Jahr' zur\u00fcckgesetzt. Dieser Punkt ist nach dem Verbuchen der Jahresbescheide durchzuf\u00fchren. </p> <p>841 - Aufkommen </p> <p>Der Men\u00fcpunkt wurde \u00fcberarbeitet und steht f\u00fcr die Einnahmearten der Gewerbesteuer zur Verf\u00fcgung. Die Auswertung enth\u00e4lt zus\u00e4tzlich zu den Gewerbesteuerertr\u00e4gen die Zuschl\u00e4ge und Zinsen.  Ausgehend vom aktuellen Haushaltsjahr k\u00f6nnen bis maximal 7 Jahre r\u00fcckblickend betrachtet werden. Die Summen der Vorauszahlungen und Festsetzungen sind je Haushaltsjahr ermittelt. Zus\u00e4tzliche Filterm\u00f6glichkeiten erm\u00f6glichen die bedarfsgerechte Auswertung. Die Anzahl der veranlagten Objekte sowie die Anzahl der Gewerbe stehen dabei zur Verf\u00fcgung. Der Druck ist mit Datum und Druck-Uhrzeit versehen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#kreditedarlehen","title":"Kredite/Darlehen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#anlagenbuchhaltung","title":"Anlagenbuchhaltung","text":"<p>b-Allgemein </p> <p>Anlagenbuchhaltung Schalter F44 Wird der Mandantenschalter F44 f\u00fcr die Anlagenbuchhaltung (Schalterstellung: \u201eAnlagenbuchhaltung\u201c und \u201eAlle Nebenbuchwerke\u201c) aktiviert so werden s\u00e4mtliche Stornobuchungen Soll/Haben gerecht dargestellt, d.h. es erfolgt keine Buchung mit negativem Betrag mehr, sondern der Buchungssatz wird gedreht.</p> <p>b11 - Anlageg\u00fcter / Bearbeiten (\u00c4nderungsanzeige) </p> <p>Es wurde ein Fehler behoben, welcher nach Neuanlage eines Anlagegutes aus der \u00c4nderungsanzeige heraus mit anschlie\u00dfender Zuschusszuordung, dass R\u00fccksenden nach Erledigung der Aufgabe ans ARCHIKART verhinderte. </p> <p>b221 - Nachpassivierung </p> <p>Bei der Nachpassivierung von Alt-Zusch\u00fcssen kam es zu einem Problem mit der Behandlung der Ma\u00dfnahmen. Hierzu erfolgte eine Korrektur, so dass jetzt nicht mehr auf eine aktuell vorhandene g\u00fcltige Ma\u00dfnahme gepr\u00fcft wird.</p> <p>b67 - Anlagespiegel </p> <p>Betrifft Bundesland Brandenburg:</p> <p>Im Report Anlagen\u00fcbersicht (anlbu_2471_anlagenspiegel.mrt) wurde der Ausweis der aufgelaufenen Abschreibung bei Umbuchung korrigiert (statt 6. Spalte in 9. Spalte). </p> <p>Im Report anlbu_2471_Anlagenspiegel.mrt wurde ein Fehler behoben, welcher in bestimmten Buchungs-Konstellationen die AfA unkorrekt ausgewiesen hat.</p> <p>b68 - Sonderpostenspiegel </p> <p>Im Report anlbu_2472_Sonderpostenspiegel.mrt wurde ein Fehler behoben, welcher in bestimmten Buchungs-Konstellationen die Aufl\u00f6sung unkorrekt ausgewiesen hat.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#kosten-leistungsrechnung","title":"Kosten-/Leistungsrechnung","text":""},{"location":"aktuelles/releasehistorie/release4.1.0054/programmaenderungen_release_49.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s13 - Aufgabenplanung </p> <p>Das SASKIA-DWH kann mit Hilfe eines Jobs regelm\u00e4\u00dfig aktualisiert werden. Dazu ist der SASKIA-JOBServer erforderlich.</p> <p>s21 - Benutzerverwaltung </p> <p>Produktrecht in Men\u00fc s21 \"Gruppen-Bearbeitung\" mit Releasewechsel 54 entfernt.</p> <p>Als weiteres Abfragekriterium f\u00fcr den LDAP-Abgleich wurde ein Gruppen- sowie Nutzerfilter integriert. Mit dem Gruppenfilter kann bereits vor Abfrage die LDAP-Gruppe eingegrenzt werden. Der Nutzerfilter kann vor oder nach LDAP-Abfrage angewendet werden. Der Splitter zwischen der Nutzerliste und den Nutzerdetails kann nun verschoben werden und speichert die Position ab.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/installation_checkliste_relea7.html","title":"Installation Checkliste Release 4.1.0055","text":""},{"location":"aktuelles/releasehistorie/release4.1.0055/installation_checkliste_relea7.html#installation-checkliste-release-410055","title":"Installation Checkliste Release 4.1.0055","text":"<p>Vorg\u00e4ngerrelease ist Release 54</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/installation_checkliste_relea7.html#update","title":"Update","text":"<p>1. Alle SASKIA \u00ae .de IFR-Nutzer abmelden </p> <p>(auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 55.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/installation_checkliste_relea7.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>1. \u00a0 Releasewechsel 55 </p> <p>Nach herunterladen und installieren des Updates kann der Releasewechsel f\u00fcr Release 55 durchgef\u00fchrt werden.  Falls aus Vorg\u00e4nger-Releases noch offene Releasepunkte angezeigt werden, sind diese vorab - beginnend mit dem kleinsten noch offenem Release - auszuf\u00fchren </p> <p></p> <p></p> <p>Durch Markieren der entsprechenden Version der verf\u00fcgbaren Datenbankin der linken Tabelle werden die Punkte des Releasewechsels wie gewohnt in der rechten Tabelle dargestellt.</p> <ul> <li> <p>Datenbankstruktur anpassen Interne Anpassung der Datenbankstruktur in der Datenbank. Dieser Releasewechselpunkt hat keine Auswirkung auf den aktuellen Datenbestand.</p> </li> <li> <p>Datenbank\u00e4nderungen Anpassung des Datenbestandes an die neue Relaeseversion.</p> </li> <li> <p>\u00dcberf\u00fchrung der Personenkontenl\u00e4nge in die Mandantenschalter F53 und F54 Die urspr\u00fcnglich im Mandantenstamm hinterlegten Festlegungen f\u00fcr Personenkontenl\u00e4nge und F\u00fcllzeichen werden in die Mandantenschalter F53 und F54 \u00fcberf\u00fchrt. </p> </li> <li> <p>Abstimmung und Erg\u00e4nzung der Budgetwerte f\u00fcr Ma\u00dfnahme-Pl\u00e4ne in den zugeordneten B-A0-Buchungsstellen Korrektur von Verf\u00fcgbarkeitswerte. Solange dieser Punkt nicht ausgef\u00fchrt wurde, k\u00f6nnen falsche Verf\u00fcgbarkeitswerte in der Budgetauskunft und Verf\u00fcgbarkeitspr\u00fcfungen auftreten. Die Ausf\u00fchrung dieses Releasewechselpunktes kann einige Zeit in Anspruch nehmen!</p> </li> <li> <p>ORACLE: Unicode-F\u00e4higkeit: VARCHAR zu CLOB Als Vorbereitung f\u00fcr m\u00f6gliche Unicode-Umstellungen von Kundendatenbanken, m\u00fcssen bestimmte Felder vom Datentyp angepasst werden.  Die Ausf\u00fchrung dieses Releasewechselpunktes kann einige Zeit in Anspruch nehmen!</p> </li> <li> <p>SQL: Entfernt f\u00fcr Sql-Server RowId nochmals aus allen Tabellen, deren Rowid-Spalten bisher entfernt wurden Datenbank-Pflegemassnahme. Die vormals ben\u00f6tigten Spalten Rowid werden entfernt. Dies verbessert die Stabilit\u00e4t und Parallelit\u00e4t der Datenbankzugriffe.Die Ausf\u00fchrung dieses Releasewechselpunktes kann einige Zeit in Anspruch nehmen! Diese RW-Punkt kann nachgelagert ausgef\u00fchrt werden. </p> </li> <li> <p>Erg\u00e4nzung von Konfigurationseintr\u00e4gen Konfiguration f\u00fcr weitere DMS werden im System eingepflegt.</p> </li> <li> <p>F\u00fcgt in die Um_ini Queries f\u00fcr die Anordnungsbest\u00e4tigung in SASKIA-Web ein Erg\u00e4nzung der Datenabfragen f\u00fcr  SASKIA-Web. </p> </li> <li> <p>Sperrbuchungen f\u00fcr B-A0-Buchungsstellen in allen Mandanten und HH-Jahren durchf\u00fchren.  Es werden fehlende Sperren in den A0 Konten erg\u00e4nzt und damit die Verf\u00fcgbarkeitswerte korrigiert.</p> </li> </ul> <p>2. Aktualisierung des Schattenmandanten </p> <p>Sachsen: Mit Release 55 wird f\u00fcr Sachsen eine neue Version (0003) des Schattenmandantes ausgeliefert Sachsen-Anhalt und Brandenburg: \u00c4nderungen sind in der aktuellen Versionen integriert</p> <p>Bitte die Aktualisierung durchf\u00fchren f\u00fcr die auf \"Ausf\u00fchren\" gesetzten Punkte.</p> <p></p> <p>SACHSEN:Im Men\u00fc 11 muss der Schalter F41 nach der Aktualisierung f\u00fcr das HHJ 2020 auf die Version 0003 ge\u00e4ndert werdenSACHSEN / SACHSEN-ANHALT / BRANDENBURGIm Men\u00fc 123 sind die aktuellen Listen aus dem Schattenmandant neu abzuleiten, um diese auf den aktuellsten Stand f\u00fcr das HHJ 2020 zu bringen</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/letzte_programmaenderungen5.html","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0055/letzte_programmaenderungen5.html#letzte-programmanderungen","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0055/letzte_programmaenderungen5.html#auslieferung-zum-18052020-version-34320","title":"Auslieferung zum 18.05.2020 - Version 34320","text":""},{"location":"aktuelles/releasehistorie/release4.1.0055/letzte_programmaenderungen5.html#buchungen","title":"Buchungen","text":"<p>311 - Einzelbuchungen </p> <p>Eine Inanspruchnahme der \u00fcbertragenen Mittel bei Einnahmen mit Buchungsschl\u00fcssel 413 ist nun wieder m\u00f6glich. Die Pr\u00fcfung der verf\u00fcgbaren Mittel beim Buchen wurde korrigiert. </p> <p>392 - Sachkontenauskunft </p> <p>Die Verf\u00fcgbarkeitsermittlung- und Darstellung der Verpflichtungserm\u00e4chtigungen wurde entsprechend der generellen Umstellung der Verf\u00fcgbarkeiten f\u00fcr Bilanz-A0-Konten angepasst. Neben der bisherigen FR-Planungsbuchung wird parallel eine Planungsbuchung auf dem Quellkonto erzeugt. F\u00fcr bisher schon gebuchte Verpflichtungserm\u00e4chtigungen ist im Releasewechsel ein Punkt implementiert, welcher die Quellkontenplanbuchungen nachzieht.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/letzte_programmaenderungen5.html#veranlagung","title":"Veranlagung","text":"<p>861 - GWST-Meldungen </p> <p>Die Meldung \"Betriebsende\" verursacht einen Fehler bei der Verarbeitung.</p> <p>Die Meldung \"Messbetrags\u00e4nderung\" wurde nicht verarbeitet.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/letzte_programmaenderungen5.html#auslieferung-zum-07042020-version-33946","title":"Auslieferung zum 07.04.2020 - Version 33946","text":""},{"location":"aktuelles/releasehistorie/release4.1.0055/letzte_programmaenderungen5.html#_1","title":"Letzte Programm\u00e4nderungen","text":"<p>ACHTUNG! Es zwingend erforderlich, das Update bis sp\u00e4testens 17.04.2020 zu installieren. Sollte dies nicht m\u00f6glich sein, muss mindestens das Update heruntergeladen werden. Dies geschieht durch Starten des Online-Updates \u00fcber die Systemverwaltung und anschlie\u00dfend Wahl der Aktion \"Herunterladen\". Durch die Aktion \"Herunterladen\" wird der OnlineUpdate-Client aktualisiert und funktioniert auch nach dem 17.04.2020.</p> <p></p> <p>Hintergrund ist, das der OnlineUpdate-Client aus R54 noch mit dem Sicherheitsprotokoll TSL 1.0 arbeitet und dieses Protokoll auf unsere zentraler Bereitstellungsserver service.saskia.de zu dem genannten Termin abgeschaltet wird. Durch die Abschaltung des Protokolls ist der alte Update-Client nicht mehr in der Lage, das Update herunterzuladen und es erscheint eine Fehlermeldung.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/letzte_programmaenderungen5.html#quartalsstatistik-bundeslander-sachsen-sachsen-anhalt","title":"Quartalsstatistik - bundesl\u00c4nder Sachsen / SAchsen-Anhalt","text":"<p>F\u00fcr die Erstellung der Quartalsstatistik ist \u00fcber die Systemverwaltung Men\u00fc s31 eine Aktualisierung des Schattenmandantes durchzuf\u00fchren, dabei sind alle Punkte zu aktualisieren die auf \"Ausf\u00fchren\" stehen.</p> <p>Folgende Punkte wurden mit diesem Updatestand \u00fcberarbeitet:</p> <ul> <li>In der Datei f\u00fcr die Quartalsstatistik wurden f\u00fcr die korrekte \u00dcbermittlung an .core Leerzeichen und Leerzeilen entfernt. </li> <li>Es erfolgte eine Aktualisierung der Konten lt. Vorgaben des Statistischen Landesamtes</li> </ul> <p>F\u00fcr die vom Statistischen Landesamt geforderte Ausgabe der Zusatzangaben \"Finanzielle Transaktionen\"  sind f\u00fcr die Codes T1, T6 und T7 \u00a0Nullwerte zu hinterlegen, da diese ohne Relevanz f\u00fcr die Ausgabe der Kassenstatistik ab 2020 sind.</p> <p>Sachsen: </p> <p></p> <p>Sachsen-Anhalt: </p> <p></p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/letzte_programmaenderungen5.html#auslieferung-zum-20032020-version-33781","title":"Auslieferung zum 20.03.2020 - Version 33781","text":""},{"location":"aktuelles/releasehistorie/release4.1.0055/letzte_programmaenderungen5.html#_2","title":"Letzte Programm\u00e4nderungen","text":"<p>Nachtrag zur Readme f\u00fcr Release 55 vom 09.03.2020 </p> <p>311 - Einzelbuchungsmaske - Buchungsdatum </p> <p>Das Buchungsdatum wird in der manuellen Buchung (Men\u00fc 311), der Verbuchung der elektron. Kontoauszugsverbuchung sowie in der OP-Bearbeitung (Stundung, Wertberichtigung, AdV und Erlass) und den Jahresabschlussfunktionen nur noch als chronologischer Zeitstempel im Hintergrund gef\u00fchrt.  Dadurch entf\u00e4llt die manuelle Eingabe dieses Datums in den genannten Masken und es bestehen k\u00fcnftig bessere Recherchem\u00f6glichkeiten z. B. nach Buchungsvorg\u00e4ngen in einem bestimmten Zeitraum. Dazu findet eine generelle und automatische Belegung des Buchungsdatums mit dem aktuellen Systemdatum statt. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/letzte_programmaenderungen5.html#buchungen_1","title":"Buchungen","text":"<p>3a2 - Ablgeich </p> <p>Beim manuellen Abgleich im Men\u00fc 3a2 werden wieder alle Verwendungszwecke angezeigt.</p> <p>3a4 - Drucken </p> <p>Es ist die Druckoption \"Sortierung nach S/H und Betrag\" deaktiviert worden, da die Funktionalit\u00e4t inzwischen \u00fcber eine eigene Maskenoption ausw\u00e4hlbar ist. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/letzte_programmaenderungen5.html#auftragfaktura","title":"Auftrag/Faktura","text":"<p>51 - Auftragsverwaltung </p> <p>Nach erfolgter Stornierung eines Auftrages werden die Mittel nun wieder freigegeben. </p> <p>54 - Ausgangsrechnungsjournal </p> <p>Es wurde ein Fehler behoben, welcher beim Duplizieren einer Ausgangsrechnung, dass Allgemeine Kennzeichen am OP f\u00fcr die Soll-/ Ist-Versteuerung aus der zu duplizierenden Rechnung, statt aus der aktuellen Stellung des Schalters F03 ableitete. Dies trat nur durch eine vorangegangene \u00c4nderung des Schalter F03 (Soll-/ Ist-Versteuerung) auf.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/letzte_programmaenderungen5.html#auswertungen","title":"Auswertungen","text":"<p>6622 - Zahlungsvorschlag </p> <p>Bei einer Sortierung der Zahlungsvorschlagsliste zB. nach Betrag, werden die zusammengeh\u00f6rigen Zeilen zu einem Zahlvorschlag nicht mehr \"auseinander gerissen\".</p> <p>671 - Journal </p> <p>Bei der Darstellung der (Steuer-)Buchungen im Steuerjournal, kam es bei Buchungen mit Skonto zu einer nicht korrekten Darstellung. Hierzu erfolgte eine Korrektur. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/letzte_programmaenderungen5.html#anlagenbuchhaltung","title":"Anlagenbuchhaltung","text":"<p>ARCHIKART Verm\u00f6gensschnittstelle (betrifft nur die S\u00e4chsischen Verwaltungen!  )</p> <p>Die Kennzeichnung \"AfA 2018\" (Haushaltsrecht ab 2018) wird nun auch automatisch \u00fcber die ARCHIKART Verm\u00f6gensschnittstelle f\u00fcr Anlageg\u00fcter/ Zusch\u00fcsse und Zusch\u00fcsse mit Inventarzuordnung gesetzt. Dies ist nur aktiv, wenn der Schalter A61 auf \u201eJa\u201c gestellt und das Haushaltsjahr 2018 oder gr\u00f6\u00dfer zur Bearbeitung ausgew\u00e4hlt wurde.</p> <p>\u00c4nderungsanzeige </p> <p>Es wurde ein Fehler behoben, welcher bei Abarbeitung der Aufgaben aus der \u00c4nderungsanzeige, f\u00e4lschlicherweise unbegr\u00fcndete Fehlermeldungen ausgab, obwohl die Verarbeitung (z.B. Ausgabe Restwert\u00e4nderung ans ARCHIKART) ohne Fehler durchlief.</p> <p>Men\u00fc b21 und b11 </p> <p>Der Excel-Export von Buchungsdaten im Reiter \"Bewegungen\" eines Anlagegutes/ Zuschusses funktioniert nun wieder korrekt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/programmaenderungen_release_10.html","title":"Programm\u00e4nderungen Release 4.1.0055","text":""},{"location":"aktuelles/releasehistorie/release4.1.0055/programmaenderungen_release_10.html#programmanderungen-release-410055-version-33628","title":"Programm\u00e4nderungen Release 4.1.0055 - VERSION 33628","text":""},{"location":"aktuelles/releasehistorie/release4.1.0055/programmaenderungen_release_10.html#global","title":"Global","text":"<p>Die ver\u00f6ffentlichten gesetzlichen \u00c4nderungen bei den Listen, Produkten und Sachkonten zum Stichtag 01.01.2020 sind f\u00fcr Sachsen in den Schattenmandant 0003, Sachsen-Anhalt \u00a00002 und Brandenburg 0000 integriert.</p> <p>In der Einzelbuchungsmaske sowie in den Dauerbuchungen k\u00f6nnen nun auch direkt Dokumente aus dem DMS abgerufen werden, mit dem Belegetyp \"AllgBuchbeleg\". Diese Dokumente m\u00fcssen wie die Eingangsrechnungen, zun\u00e4chst mit einem neuen Belegtyp im DMS abgespeichert werden. </p> <p>Betrifft Bundesland Sachsen - Quartals- und Jahresstatistik: Die Anforderungen vom \u00a0Statistischem Landesamt bez\u00fcglich des Ausweises der korrekten Identnummer in der Quartals- und Jahresstatistik wurden f\u00fcr Sachsen mit R55 umgesetzt. Das im Men\u00fc 11 hinterlegte Bundesland (014 - Sachsen) und der Gemeindeschl\u00fcssel werden nach Vorgaben von der STALA entsprechend automatisch bei der Erstellung der Statistik zusammengefasst: \"Bei Kommunen entspricht die Identnummer dem Regionalschl\u00fcssel, die L\u00e4nderkennung (14 f\u00fcr Sachsen) ist zwingend  davor zu setzen, z.B. 14521280</p> <p>Verwaltungsverb\u00e4nde haben anstelle der drei Ziffern f\u00fcr die Gemeinde eine \"999\", die letzten beiden Stellen sind mit einer fortlaufenden Nummer gef\u00fcllt, z.B. 1473099903</p> <p>Anders verh\u00e4lt es sich mit Zweckverb\u00e4nden und anderen \u00f6ffentlichen Fonds, Einrichtungen und Unternehmen. Diese haben 7stellige Identnummern, in Sachsen meist mit 89 beginnend.</p> <p>Hier ist keinesfalls  die Landeskennung davor zu setzen, nicht ben\u00f6tigte Stellen bleiben leer und werden nicht mit \"0\" aufgef\u00fcllt.\"</p> <p> </p> <p>In den neuen Tabellen, in denen gruppiert sowie direkt am Spaltenkopf gefiltert werden kann, (Men\u00fc 67* und 394) ist das Aufheben aller Filter und/ oder Gruppierungen durch einen Rechtsklick und das Ausw\u00e4hlen auf den Kontext \"alle Filter/Gruppierungen aufheben\" nun m\u00f6glich</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/programmaenderungen_release_10.html#stammdaten","title":"Stammdaten","text":"<p>124 - Sachkontenverwaltung </p> <p>Eine Auswahl des Steuerkennzeichen bei Steuerart 1 oder 2 ist wieder \u00fcber die Auswahlbox m\u00f6glich.</p> <p>12a3 </p> <p>Im Stammblatt der Personenkonten \u00a0und im Men\u00fc 391 - Reiter 'Auswahl' ist der jeweils gew\u00e4hlte Stundungstitel (Stundung/Ratenzahlungsvereinbarung/Zahlungserleichterung), der im Men\u00fc '421- Stundung' genutzt wurde sichtbar.</p> <p>Beim Anlegen einer neuen BV (Mandatsreferenz) im Men\u00fc 12a3 werden neben der aus Men\u00fc 11 \"standartm\u00e4\u00dfigen\" Gl\u00e4ubiger-ID, welche fest vorgeblendet wird, alle \"aktiven\" ID's \u00fcber Abtauchen ausw\u00e4hlbar angezeigt.</p> <p>Zusatzadressen k\u00f6nnen G\u00fcltigkeitszeitr\u00e4ume mitgegeben werden. Dadurch ist die \u00c4nderung von Zusatzadressen nachvollziehbar.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/programmaenderungen_release_10.html#planung","title":"Planung","text":"<p>242 - \u00a0Ergebnisplan </p> <p>Beim Ausweis der Vorjahreswerte (Haken gesetzt bei \"mit Vorjahr-Spalte\") in der Planmaske kam es unter bestimmten Datenkonstellationen zu keiner Anzeige der im Vorjahr gebuchten Werte. Hierzu erfolgte eine Programmkorrektur.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/programmaenderungen_release_10.html#buchung","title":"Buchung","text":"<p>311 - Einzelbuchung </p> <p>Bei der Buchung einer Zahlung mit Skonto wurde in der Meldung \"Achtung Skonto-Buchung\" ein gerundeter Buchungsbetrag ausgewiesen und auch der Zahlbetrag in dieser Meldung falsch dargestellt. Die Buchung selber erfolgte aber mit den korrekten Werten. Der Darstellungsfehler wurde behoben, so dass jetzt die richtigen Betr\u00e4ge ausgewiesen werden. </p> <p>Bei der Buchung \u00fcber die Einzelbuchungsmaske wird wieder mit Bet\u00e4tigung der F6 Taste im Feld \"Buchungsbetrag\" , der zuletzt eingegebene Betrag vorbelegt.</p> <p>Bei den Buchungsschl\u00fcsseln 421/521 f\u00fcr Soll/Ist-Buchungen, erfolgte eine nicht korrekte Anzeige von Zahlwegen zur Auswahl. Nach der Programmkorrektur werden jetzt alle f\u00fcr das HH-Jahr nicht abgeschlossenen Zahlwege zur Auswahl angeboten.</p> <p>In der Einzelbuchungsmaske \u00a0k\u00f6nnen nun auch direkt Dokumente aus dem DMS abgerufen werden, mit dem Belegetyp \"AllgBuchbeleg\". Diese Dokumente m\u00fcssen wie die Eingangsrechnungen, zun\u00e4chst mit einem neuen Belegtyp im DMS abgespeichert werden. </p> <p>312 - Dauerbuchungen </p> <p>Beim Druck der angelegten Dauerbuchungen kamen in der Ergebnisliste immer alle Dauerbuchungen gemischt nach Debitor / Kreditor. Es erfolgte eine Erg\u00e4nzung der Selektion, so dass nun getrennt nach Debitor, Kreditor oder alles in der Druckliste angezeigt werden kann.</p> <p>In der Dauerbuchungsmaske k\u00f6nnen nun auch direkt Dokumente aus dem DMS abgerufen werden, mit dem Belegetyp \"AllgBuchbeleg\". Diese Dokumente m\u00fcssen wie die Eingangsrechnungen, zun\u00e4chst mit einem neuen Belegtyp im DMS abgespeichert werden. </p> <p>33 - Buchungsstapel </p> <p>Bei der Verbuchung von Kreditumschuldungsbuchungen im Buchungsstapel kam es zu einer Fehlermeldung, dass das abweichende FR-Konto nicht \u00fcbereinstimmt. Hintergrund zum Fehler, er versucht die Umschuldungsbuchung auf einen schon mit diesem F\u00e4lligkeitsdatum und OP-Nummer vorhandenen OP (Zins, Tilgung) zu buchen. Als L\u00f6sung wird jetzt bei der Umschuldungsbuchung die OP-Nummer um \"/UMB\" erg\u00e4nzt.</p> <p>3521 - Eingang - Einlesen </p> <p>Beim Einlesen von Plandaten \u00fcber die Plandatenschnittstelle gab es ein Fehlverhalten beim Verarbeiten. Folgende Korrekturen sind umgesetzt: - kein Anlegen von Plandatens\u00e4tzen ohne FR-Sachkonten mehr, wenn am ER-Konto kein FR-Konto h\u00e4ngt und die Option \"FR-Plan ableiten = J\" ist - beim Simulieren der Plandatenschnittstellenverarbeitung werden keine Plandatens\u00e4tze in der KP_PLAN mehr angelegt - treten bei der Schnittstellenverarbeitung, Fehler bei einigen der eingelesenen S\u00e4tzen auf, wird die Verarbeitung mit dem Status \"Fehler\" gekennzeichnet, nicht mehr als \"Verarbeitet\"</p> <p>353 - Ausgeben </p> <p>Die GDPdU-Schnittstellen wurden um einen Parameter \"Ung\u00fcltige XML-Zeichen ersetzen\" Ja/Nein erg\u00e4nzt. Somit ist eine problemlose Datenausgabe m\u00f6glich, wenn ein eigentlich g\u00fcltiges IFR-ASCII-Zeichen m\u00f6glicherweise nicht \u00a0dem vorgegebenen XML-Zeichensatz entspricht.</p> <p>36 - Anordnung </p> <p>Bzgl. des Auswahlfeld \"Buchungsstapel\" erfolgte eine Anpassung mit der Auswirkung, dass nur noch Buchungsstapel aus dem Haushaltsjahr der Maske angezeigt werden. Beim Wechsel des Haushaltsjahres werden auch die zur Auswahl stehenden Buchungsstapel in diesem Feld aktualisiert.</p> <p>Die Auswahl eines Weiterleitungsnutzers ist jetzt Pflicht f\u00fcr den AO-Druck sowie \u00a0f\u00fcr sachliches und rechnerisches Zeichnen. Beim endg\u00fcltigen Zeichnen muss kein Weiterleitungsnutzer ausgew\u00e4hlt werden.</p> <p>Die Angaben im Auswahlfeld \"Buchungsstapel\" werden entsprechend \u00a0dem Haushaltsjahre der Maske angepasst. Es werden nur noch Buchungsstapel aus dem aktuell gew\u00e4hlten Haushaltsjahr angezeigt. Beim Wechsel des Haushaltsjahres werden die zur Auswahl stehenden Buchungsstapel im Auswahlfeld \"Buchungsstapel\" aktualisiert.</p> <p>391 - Personenkontenauskunft </p> <p>Im Stammblatt der Personenkonten und im Men\u00fc 391 - Reiter 'Auswahl' ist der jeweils gew\u00e4hlte Stundungstitel (Stundung/Ratenzahlungsvereinbarung/Zahlungserleichterung), der im Men\u00fc '421- Stundung' genutzt wurde sichtbar. \u00a0 </p> <p>Im Reiter \"OP's\" wurde bei den get\u00e4tigten Buchungen die Spalte zur Kundennummer nicht mehr gef\u00fcllt. Hierzu erfolgte eine Programmanpassung.</p> <p>393 - Buchungsrecherche - Journal drucken </p> <p>Das Buchungsjournal kann mit der neu geschaffenen Vorlagenoption die KLR-Journal-Summe separat ausweisen.</p> <p>394 - Budget\u00fcbersicht </p> <p>In der Budget\u00fcbersicht wurde die Datenaufbereitung der gebuchten Werte, insbesondere Spalte \"gebucht\", \u00a0an eine Soll/Haben gerechte Buchungsweise unter Ber\u00fccksichtigung der verschiedenen Buchungsschl\u00fcssel und Kontenarten angepasst.</p> <p>Unter \"Kontentypen\" wurde die Option \"Langtexte\" integriert, diese erm\u00f6glicht es f\u00fcr die Spalten: Sachkonto, Produkt und Ma\u00dfnahme die Lang- oder Kurzbezeichnung einzublenden. Au\u00dferdem wird diese Option nutzerspezifisch abgespeichert und bei Neuaufruf des Men\u00fcpunktes wieder entsprechend gesetzt.</p> <p>Bei den Spalten \"fortgeschriebener Planansatz\" und \"Gebucht + reserviert\" fehlten die Summenzeilen, diese wurden erg\u00e4nzt.</p> <p>396 - Liquidit\u00e4tsanzeige </p> <p>In der Liquidit\u00e4tsanzeige werden jetzt in der Position 6.1 - \"ER ohne Anordnung mit F\u00e4lligkeit bis ...\" auch die vorerfassten ER's ohne Position (nur Kopfdaten) wertm\u00e4\u00dfig mit ausgewiesen.</p> <p>3a1 - Kontoauszug - Stammdaten </p> <p>In der maschinellen Kontoauszugsverbuchung wird bei der manuellen Mehrfach-OP-Zuordnung die jeweils neu entstandene Zuordnungspositionszeile aufsteigend oben in der Tabelle angelegt. Bisher wurde die neue Positionszeile immer unten angestellt, sodass bei vielen Zeilen u.U. ein aufwendiges Scrollen notwendig war.</p> <p>3a2 - Kontoauszug - Abgleich </p> <p>Beim Einlesen der Kontoausz\u00fcge gab es bei Positionen mit Sammel\u00fcberweisungen, ein Fehlverhalten hinsichtlich des Ausweises bei Auftraggeber und Verwendungszweck. Hier wurde bisher immer der Auftraggeber und Verwendungszweck des ersten in der Datendatei \u00fcbermittelten Kontoauszugsposition f\u00fcr die Sammel\u00fcberweisung eingetragen. Zuk\u00fcnftig wird beim Auftraggeber der Text \"Sammel\u00fcberweisung\" und beim Verwendungszweck die Schwebepostennummer eingetragen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/programmaenderungen_release_10.html#op-bearbeitung","title":"OP-Bearbeitung","text":"<p>421 - Stundung / Bearbeiten </p> <p>Der Titel des Schreibens, das bei der Stundung erstellt wird, kann individuell gesteuert werden: z.B. Stundungsbescheid f\u00fcr \u00f6ffentlich-rechtliche Forderungen, Stundungsvereinbarung f\u00fcr privat-rechtliche Forderungen oder Ratenzahlungsvereinbarung bzw. Zahlungserleichterung f\u00fcr spezielle Einnahmearten. </p> <p>Beim Stundungswiderruf kam es zu einem Fehlverhalten bei der Zinskorrektur der Stundung. Es wurde immer der gesamte Zinsbetrag ausgebucht, aber der korrigierte Zinsbetrag nicht wieder mit eingebucht. Hierzu erfolgte eine Korrektur.</p> <p>Der neue Widerrufsbescheid der Stundung weist die Restschuld f\u00fcr die jeweils betroffenen F\u00e4lligkeiten aus. Dabei besteht zus\u00e4tzlich \u00fcber die Vorlagenoptionen die M\u00f6glichkeit, die 'Erl\u00e4uterungen der Restschuld' \u00a0auszuweisen und die bei dieser Option enthaltenen Informationen zu den einzelnen Festsetzung der Stundungszinsen zu belegen oder auszublenden. Die Vorlagen-Optionen stehen f\u00fcr beide Reports der Stundung zur Verf\u00fcgung.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/programmaenderungen_release_10.html#auftragfaktura","title":"Auftrag/Faktura","text":"<p>51 - Auftragsverwaltung </p> <p>Es ist nun m\u00f6glich, aus einem bereits bestehenden Auftrag \u00fcber den Button \"Kopieren\" einen Musterauftrag zu erstellen, der dann als Vorlage f\u00fcr weitere Auftr\u00e4ge verwendet werden kann. Nach dem Klick auf den Button \"Kopieren\" muss das Lieferjahr best\u00e4tigt bzw. ge\u00e4ndert werden, um alle weiteren Eingabefelder zu aktivieren. Um einen Musterauftrag zu erfassen, muss bei der Auftragsart \"Muster\" ausgew\u00e4hlt werden. Dabei bleibt die Auswahl \"extern\" bzw. \"intern\" weiterhin mit aktiv. Bei der weiteren Erfassung der Daten ist wie gewohnt vorzugehen. Wird der Musterauftrag mit \"\u00dcbernehmen\" best\u00e4tigt, erh\u00e4lt er eine Auftragsnummer beginnend mit \"AUFM.....\". Es werde keine Planbuchungen bzw. Reservierungen von Mitteln vorgenommen.</p> <p>52 - Eingangsrechnungsjournal </p> <p>Beim gleichzeitigen Verbuchen von mehreren Eingangsrechnungen, die zu Budgetumbuchungen f\u00fchren, kam es zu einem Fehlverhalten beim Ausweis des Buchungstextes 2. Es wurde immer die Eingangsrechnungsnummer der ersten Budgetumbuchung eingetragen. Hierzu erfolgte eine Korrektur, so dass jetzt die richtige Eingangsrechnungsnummer im Buchungstext 2 hinterlegt wird. </p> <p>Die Funktionalit\u00e4t der Status-Auswahl wurde dem des Ausgangsrechnungsjournales gleichgezogen. Ab sofort werden die zuletzt ausgew\u00e4hlten Status nutzerspezifisch abgespeichert und bei Neuaufruf des ERJs wieder entsprechend vorbelegt.</p> <p>Bei Stornieren von Eingangsrechnungen wird ein Grund f\u00fcr das Stornieren abgefragt und bei der Stornierungsbuchung als Freitext hinterlegt. Somit ist jederzeit ersichtlich, warum die Rechnungen storniert wurden.</p> <p>Beim mehrmaligen Abweisen von Anordnungen von Eingangsrechnungen mit Auftr\u00e4gen und gesetztem Haken bei Schlussabruf im Men\u00fc 52-ERJ konnten unter bestimmten Konstellationen negative Reservierungen auf der betreffenden Buchungsstelle entstehen. Mit dem Abweisen der Anordnung wird die Reservierung nun korrekt zur\u00fcckgesetzt.</p> <p>54 - Ausgangsrechnungsjournal </p> <p>Die Summe der Teil-AO zur gleichen AR, welche aus positiven und negativen Betr\u00e4gen besteht, wird jetzt bei Bet\u00e4tigung des Schalters F44 richtig ausgewiesen. Bei Stornierung dieser AO lautet der Titel 'AO-Stornierung'. Der abgefragte Grund der Stornierung wird in den Freitext \u00fcbergeben und somit richtig auf der AO ausgewiesen. \u00a0</p> <p>Bei Stornieren von Ausgangsrechnungen wird ein Grund f\u00fcr das Stornieren abgefragt und bei der Stornierungsbuchung als Freitext hinterlegt. Somit ist jederzeit ersichtlich, warum die Rechnungen storniert wurden.</p> <p>Im Ausgangsrechnungsjournal kann jetzt per Druckoption der Girocode auf dem Druck mit eingeblendet werden. Voraussetzung ist, dass in den Mandantenschaltern bei K07 ein Standardzahlweg eingetragen ist. Eine weitere Bedingung ist, dass das in der Ausgangsrechnung verwendete PK kein Abbucher ist - nur Barzahler. Gibt es in der Ausgangsrechnung mehrere Zahlungstermine wird pro Rate ein Girocode generiert.</p> <p>APP (f\u00fcr IOS und Android) derzeit nutzbar in: - Sparkassen - Volks und Reifeisenbanken - Commerzbank - Postbank - Sparda-Bank - BW-Bank - Banking4 - BB-bank - GLS-Bank</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/programmaenderungen_release_10.html#auswertungen","title":"Auswertungen","text":"<p>6223 - Kontoauszug </p> <p>Bei manuellen OP-\u00c4nderungen (z.B. Sperren) wird immer ein eigener Historiensatz f\u00fcr den OP geschrieben, auch wenn es keine Soll-/Haben\u00e4nderungen gab. Das f\u00fchrte allerdings dazu, dass beim Druck des Kontoauszuges diese \u00fcberz\u00e4hligen OP-Positionen mit ausgewiesen wurden. Hierzu erfolgte jetzt eine Anpassung, so dass diese Positionen nicht mehr mit angedruckt werden.</p> <p>631 - Bilanz </p> <p>Beim Druck der Bilanz ab HHJ 2018 gibt es im gesetzlichen Muster auf der Passivaseite \"darunter\" Positionen. Hier kam es aktuell vermehrt zu Anfragen, dass der Ausweis und die Berechnung der Positionen beim Druck mit Kontennachweis so nicht korrekt w\u00e4re. Deshalb wurde jetzt eine neue Positionsart \"1 - entw. Aktiva oder Passiva ohne Sum.\" in der Listenpositionsverwaltung (Men\u00fc 123) definiert. Mit dieser Positionsart werden die der \"darunter\"-Position zugeordneten Sachkonto nicht mit in die \u00fcbergeordnete Position mit hineingerechnet.</p> <p>6511 - Gesamtfinanzplan </p> <p>Beim Druck des Finanzplans wurde die Position 54 in der Listenart \"\u00dcbersicht\" nicht korrekt mit einbezogen. Hierzu erfolgte eine Korrektur</p> <p>6513 - Teilfinanzplan B </p> <p>Beim Druck der Liste mit der Option \"Planerl\u00e4uterungen\" kam es zu einem Problem mit dem Layout bei der Summenbildung. Hierzu erfolgte eine Korrektur.</p> <p>69 - gesetzliche Drucklisten </p> <p>Beim Druck der Liste mit der Option \"Planerl\u00e4uterungen\" kam es zu einem Problem mit dem Layout bei der Summenbildung. Hierzu erfolgte eine Korrektur.</p> <p>Das s\u00e4chsische Muster 14 - Anlagenspiegel ist an die neue gesetzliche Form angepasst.</p> <p>6s - Dokumentenmappe </p> <p>In der Dokumentenmappe besteht jetzt auch die M\u00f6glichkeit des Dokumente-Mischens bei der Erstellung von Jahresabschlussunterlagen. Bisher fehlte hier in den Reportvorlagen Teilergebnis- und Teilfinanzrechnung noch die entsprechende Kennzeichnung , so dass bspw. Produktbeschreibungen aus externen Dokumenten nicht eingemischt werden konnten.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/programmaenderungen_release_10.html#veranlagung","title":"Veranlagung","text":"<p>8 - Allgemein </p> <p>Die Vorgabe im Schalter F37 f\u00fcr den Ausweis der weiteren Bescheidempf\u00e4nger / betroffenen Personen in den \u00a0Bescheiden wirkt nur noch auf diese Angaben; der Debitor/Kreditor wird stets mit Anschrift ausgewiesen.  Bei F37 (vollst\u00e4ndiger Ausweis weiterer Bescheidempf\u00e4nger) = Nein werden - soweit gef\u00fcllt - die Felder 'Name1, Name2, Name3 und Vorname' ausgewiesen.</p> <p>Die Samstags-, Sonntags- und Feiertagsregelung f\u00fcr Steuerf\u00e4lligkeiten (Schalter V08) wird auch bei Veranlagungen, f\u00fcr die die Kleinstbetragsregelung Anwendung findet, \u00a0korrekt ber\u00fccksichtigt.</p> <p>Die Buchungsperioden, die aus der Veranlagung heraus gebildet werden, wurde \u00fcberarbeitet. Die Art der Veranlagung (allg. Steuern (AS) / wiederkehrende Abgaben (WE) / Gewerbesteuern (GW) / Geb\u00fchren GB)), die Positionen 'VB=Abrechnung' und 'Abrechnungen ins Vorjahr' haben dabei grundlegende \u00a0Bedeutung.</p> <p> </p> <p>81 - Einzelveranlagung </p> <p>Werden in einem Steuerbescheid f\u00fcr mehr als 2 Jahre Zinsen festgesetzt, so werden die Zinsbl\u00f6cke in einer Tabelle dargestellt und der Erl\u00e4uterungstext zu den Zinsen wird nur einmalig am Ende des Zinsabschnittes angedruckt. Bei einem Seitenwechsel werden die einzelnen Zinsbl\u00f6cke zusammengehalten. Dabei ist ein Zinsblock die Zeile \"Jahr\" und die Zeile \"Berechnung\". Wenn mehr als 9 Berechnungszeilen im Jahr ausgegeben werden sollen, sollte die neuen Option 'alle Zinsberechnungen ausgeben' \u00a0genutzt werden.</p> <p>841 - Aufkommen </p> <p>Der Excel-Export wurde erm\u00f6glicht. Die Anpassung der Excel-Formatierung kann der Anwender selbst\u00e4ndig auf seine Bed\u00fcrfnisse zugeschnitten durchf\u00fchren. Der neue Button Excelexport erzeugt eine Excel-Datei. Der Anwender kann w\u00e4hlen, wohin und unter welchem Namen er diese Datei speichert. Der Anwender kann diese Datei entsprechend seinen Vorstellungen formatieren.</p> <p>845 - Auskunft offene Veranlagung </p> <p>Die mandantenspezifische Auswertung \u00fcber den Men\u00fcpunkt 845 schaut jetzt \u00fcber alle Haushaltjahre.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/programmaenderungen_release_10.html#anlagenbuchhaltung","title":"Anlagenbuchhaltung","text":"<p>b11 - Anlageg\u00fcter bearbeiten </p> <p>Der Excel-Export von Buchungsdaten im Reiter \"Bewegungen\" eines Anlagegutes/ Zuschusses funktioniert nun wieder korrekt.</p> <p>b21 - Zusatzfunktionen Nachaktivieren </p> <p>Der Excel-Export von Buchungsdaten im Reiter \"Bewegungen\" eines Anlagegutes/ Zuschusses funktioniert nun wieder korrekt.</p> <p>b35 - Buchung - Buchungslauf </p> <p>Es wurde ein Fehler behoben, welcher unter bestimmten Konstellationen den Status eines zur\u00fcckgesetzten Buchungslaufes nicht auf \u201eabgeschlossen\u201c stellte, sondern im Status \u201estorniert\u201c im Men\u00fc b35 stehen blieb.</p> <p>b67 - Anlagespiegel </p> <p>Es k\u00f6nnen wieder abweichende bzw. selbst definierte Listen, abweichend von der Standard-Listenvorbelegung, ausgew\u00e4hlt werden.</p> <p>Das s\u00e4chsische Muster 14 - Anlagenspiegel ist an die neue gesetzliche Form angepasst.</p> <p>b68 - Sonderpostenspiegel </p> <p>Es k\u00f6nnen wieder abweichende bzw. selbst definierte Listen, abweichend von der Standard-Listenvorbelegung, ausgew\u00e4hlt werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0055/programmaenderungen_release_10.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s31 - Releasewechsel </p> <p>Mit Auslieferung 55 ist es nicht mehr m\u00f6glich, nach Auswahl eines Releases einen weiteren RW/Punkteauswahl parallel durchzuf\u00fchren. Erst wenn ein RW vollst\u00e4ndig durchgef\u00fchrt wurde, kann ein weiterer angeschoben werden.</p> <p>In diesem Zusammenhang wurde auch die Visualisierung \u00fcber den laufenden Fortschritt (Bearbeitungsstatus) durch Einblendung einer Aktionsbox mit Fortschrittsbalken verbessert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/installation_checkliste_relea8.html","title":"Installation Checkliste Release 4.1.0056","text":""},{"location":"aktuelles/releasehistorie/release4.1.0056/installation_checkliste_relea8.html#installation-checkliste-release-410056","title":"Installation Checkliste Release 4.1.0056","text":"<p>Vorg\u00e4ngerrelease ist Release 55</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/installation_checkliste_relea8.html#update","title":"Update","text":"<p>1. Alle SASKIA \u00ae .de IFR-Nutzer abmelden </p> <p>(auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 56.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/installation_checkliste_relea8.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>1. \u00a0 Releasewechsel 56 </p> <p>Nach Herunterladen und Installation des Updates kann der Releasewechsel f\u00fcr Release 56 durchgef\u00fchrt werden.  Falls aus Vorg\u00e4nger-Releases noch offene Releasepunkte angezeigt werden, sind diese vorab - beginnend mit dem kleinsten noch offenem Release - auszuf\u00fchren. </p> <p></p> <p>Durch Markieren der entsprechenden Version der verf\u00fcgbaren Datenbank in der linken Tabelle werden die Punkte des Releasewechsels wie gewohnt in der rechten Tabelle dargestellt.</p> <ul> <li> <p>Datenbankstruktur anpassen Interne Anpassung der Datenbankstruktur in der Datenbank. Dieser Releasewechselpunkt hat keine Auswirkung auf den aktuellen Datenbestand.</p> </li> <li> <p>Datenbank\u00e4nderungen Anpassung des Datenbestandes an die neue Releaseversion.</p> </li> <li> <p>Anpassung der Reportvorlagen  Installation von neuen und Entfernung von nicht mehr ben\u00f6tigten Reportvorlagen.</p> </li> <li> <p>Schl\u00fcsseltabellen f\u00fcr DTA-GWST f\u00fcllen F\u00fcr die digitale Verarbeitung von Gewerbesteuerbescheiden sind Basisdaten erforderlich, diese werden hier erg\u00e4nzt.</p> </li> <li> <p>Korrektur KP_PLANVAR.FREITEXT Bei der Duplizierung von Planvarianten wurde der Freitext nicht immer korrekt kopiert. Dies wird hier nachgeholt. Es werden keine Daten ver\u00e4ndert.</p> </li> <li> <p>Korrektur GL_CONTAINER Die Basistabelle wird mit dem Mandanten erg\u00e4nzt.</p> </li> <li> <p>Schl\u00fcsseltabellen f\u00fcr die Gewerbekennzahlen der GWST-Veranlagung f\u00fcllen Gewerbekennzahlen k\u00f6nnen jetzt zugeordnet werden, die notwendigen Basisdaten werden hier zur Verf\u00fcgung gestellt.</p> </li> <li> <p>AN-Tabellen umstellen von Decimal auf Integer-Datentypen/RowID Strukturanpassung f\u00fcr die AnBu-Tabellen (Entfernung der Rowid)-</p> </li> </ul> <p>Dieser Releasewechselpunkt aktualisiert einige gro\u00dfe Anlagenbuchhaltungstabellen und kann somit mehr Zeit in Anspruch nehmen. Dieser Punkt ist aber die Voraussetzung f\u00fcr den darauffolgenden Releasewechselpunkt. </p> <ul> <li> <p>Korrigiere die Umbuchungs-AfA- bei Zuschuss-AfA2018 Switchposition Beim Switch eines Anlagegutes wird ein zugeordneter Zuschuss automatisch mit geswitcht. Dabei wurde die aufgelaufene AfA des Anlagegutes durchgereicht statt der aufgelaufenen AfA des Zuschusses (Verkn\u00fcpfung) und in den Zuschusspositionen zum Selbstverweis ausgewiesen. Dies wird mit diesem  Releasewechselpunkt korrigiert.</p> </li> <li> <p>Wiederherstellen der ID-Trigger nach RowId Entfernung wegen der DB-Protokollierung Interne Anpassung der Datenbankstruktur in der Datenbank. </p> </li> <li> <p>Erg\u00e4nzung der Gewerbekennziffer-Felder f\u00fcr bestehende Gewerbesteuer-Einnahmearten Damit die Gerwerbekennziffern auch f\u00fcr Bestandskunden sofort zur Verf\u00fcgung steht, wird hier die Objektbeschreibung erg\u00e4nzt.</p> </li> <li> <p>Zum Schluss - Korrektur KS_CONTAINER (kann unterbrochen werden) Dieser Releasewechselpunkt f\u00fchrt Korrekturen in der Tabelle KS_Container durch (Erg\u00e4nzung des Mandanten). </p> </li> </ul> <p>Die Ausf\u00fchrung dieses Releasewechselpunktes kann bei gr\u00f6\u00dferen Verwaltungen unter Umst\u00e4nden mehrere Stunden in Anspruch nehmen.Daher kann er jederzeit abgebrochen und nachgelagert ausgef\u00fchrt werden. Der Punkt ist f\u00fcr die Funktionsweise des Programms nicht zwingend erforderlich und kann auch parallel zum Betrieb vorgenommen werden.</p> <p>2. Aktualisierung des Schattenmandanten </p> <p>Bei der Aktualisierung des Schattenmandaten bitte alle Punkte aktualisieren, die auf \"Ausf\u00fchren\" stehen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html","title":"Letzte Programm\u00e4nderung","text":""},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html#letzte-programmanderungen","title":"Letzte Programm\u00e4nderungEN","text":""},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html#auslieferung-zum-02072020-version-34836","title":"Auslieferung zum 02.07.2020 - Version 34836","text":""},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html#releaswechselpunkte","title":"Releaswechselpunkte","text":"<p>Alle Kunden bei denen noch offene RW-Punkte angezeigt werden, k\u00f6nnen diese mit dem aktuellen Update-Stand ausf\u00fchren.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html#neue-beta-buchungsmaske","title":"Neue Beta-Buchungsmaske","text":"<p>In den Dauerbuchungen Men\u00fc 312 und im Buchungstapel Men\u00fc 33 wird nun bei der Bearbeitung wieder die \"alte\" Buchungsmaske eingeblendet.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":"<p>52 - Eingangsrechnungsjournal </p> <p>KLR-Aufteilungen sind nun aus dem ERJ wieder m\u00f6glich</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html#8-veranlagung","title":"8 - Veranlagung","text":"<p>81 - Einzelveranlagung </p> <p>Beim Vortragen von Jahreswechselwerten der Veranlagungen, die keine Unterobjekte nutzen, kam es unter Umst\u00e4nden zum sql-Fehler 'Der Wert Null kann nicht eingef\u00fcgt werden.  Der Fehler wurde behoben, die Wechselwerte k\u00f6nnen somit vorgemerkt werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html#auslieferung-zum-24062020-version-34760","title":"Auslieferung zum 24.06.2020 - Version 34760","text":""},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html#ausfuhrung-releasewechselpunkt","title":"Ausf\u00fchrung Releasewechselpunkt","text":"<p>Alle Punkte die im Men\u00fc s31 auf \"Ausf\u00fchren\" stehen sind zu aktualisieren. (Ausgenommen KS_Container, welcher auch zu einem sp\u00e4teren Zeitpunkt erfolgen kann - siehe Installationscheckliste).</p> <p>Sollten in der Jahresstatistik Produkte bzw. Ums\u00e4tze von Finanzkonten fehlen, sind ggf. die Releasewechselpunkte aus dem Schattenmandant 2,4,5 und 6 zu aktualisieren.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html#3-buchungen","title":"3 - BUchungen","text":"<p>311 - Einzelbuchung </p> <p>In der Beta-Buchungsmaske wurde bei der Best\u00e4tigungsbuchung des Auszahlschwebeposten (BS 221) die Buchung falsch iniziiert. Dieser Fehler wurde behoben.</p> <p>Bei R0 R\u00fcckstellungskonten erfolgt bei der Buchung keine Verf\u00fcgbarkeitspr\u00fcfung mehr.</p> <p>Im BS 290 ist ab sofort auch eine Ma\u00dfnahme bebuchbar.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html#5-auftrag-faktura_1","title":"5 - Auftrag / Faktura","text":"<p>51 - Auftragsverwaltung </p> <p>In der Auftragsverwaltung ist eine Budgetumbuchung nun wieder m\u00f6glich. Das entsprechende Fenster zur Budgetumbuchung wird wieder eingeblendet.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html#6-auswertungen","title":"6 - Auswertungen","text":"<p>6223 - Auswertungen </p> <p>Beim Druck des verk\u00fcrzten Personenkontenauszuges wurde unter bestimmten Konstellationen die Spalte Einzahlungen in den einzelnen Zeilen falsch aufsummiert. Die Gesamtsumme der offenen Forderungen wurde bisher schon korrekt ausgewiesen. </p> <p>68 - Freie Auswertungen </p> <p>Aktualisierung der nichtzul\u00e4ssigen Kombinationen f\u00fcr die Jahresstatistik f\u00fcr das HHJ 2019 ist erfolgt</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":"<p>b11 - Anlagegut bearbeiten | b21 - Zuschuss bearbeiten (betifft nur S\u00e4chsische Kommunen) </p> <p>Die fehlerhafte Einsortierung eines Anlagegutes/ Zuschusses (nach neuem Haushaltsrecht ab 2018) in den Filter \u201eAfA 2018\u201c wurde korrigiert. Dies trat auf, wenn das AHK-Datum eines Anlagegutes/ Zuschusses nach erfolgreicher Neuanlage (vor Aktivierung/ Passivierung) nochmals ge\u00e4ndert wurde. </p> <p>b123 - Abgang Anlagegut | b223 - R\u00fcckzahlung/ Abgang Erfolgte in der Periode 12 ein Vollabgang f\u00fcr ein Anlagegut/ Zuschuss so konnte unter bestimmten Konstellationen, die in der Periode 12 ausgeglichene Rundungsdifferenz bezogen auf den Jahresabschreibungsbetrag als negative Abschreibung stehen bleiben. Dies wurde behoben. b33 - Buchung Anlageg\u00fcter | b34 \u2013 Buchung Zusch\u00fcsse  Unter bestimmten Bedingungen wurde die Abschreibung/ Aufl\u00f6sung nicht auf das am Bilanzkonto (VR-Kontierung) angegebene AfA-Konto gebucht. Sondern an das AfA-Konto, welches zum Zeitpunkt der Erfassung eines Anlagegutes/ Zuschusses aus der VR-Kontierung in den AfA-Stammsatz \u00fcbertragen wurde. Dieser Fehler wurde behoben und nun wird in s\u00e4mtlichen Konstellationen das AfA-Konto aus der VK-Kontierung herangezogen. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html#auslieferung-zum-09062020-version-34620","title":"Auslieferung zum 09.06.2020 - Version 34620","text":""},{"location":"aktuelles/releasehistorie/release4.1.0056/letzte_programmaenderung_r56.html#auftragfaktura","title":"AUFtrag/Faktura","text":"<p>592 - Fakturierung / Bearbeiten </p> <p>Bei der Funktion 'Buchen' wurde ein erneutes Anzeigen ausgel\u00f6st, was den Buchungsvorhang verhindert, dies wurde behoben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html","title":"Programm\u00e4nderungen Release 4.1.0056","text":""},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html#programmanderungen-release-410056","title":"Programm\u00e4nderungen Release 4.1.0056","text":""},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html#allgemein","title":"Allgemein","text":"<p>Auswirkungen des Konjunktur- und Krisenbew\u00e4ltigungspakets der Bundesregierung </p> <p>Die im Ma\u00dfnahmenpaket vorgesehene Absenkung der Mehrwertsteuer f\u00fcr den Zeitraum vom 01.Juli 2020 bis 31.12.2020 hat auch Auswirkungen auf das Buchungsgesch\u00e4ft in . Um die korrekte steuerliche Behandlung zu gew\u00e4hrleisten, sind mit Release 56 alle steuerpflichtigen Buchungen im o.g. Zeitraum mit ge\u00e4nderten Steuers\u00e4tzen durchf\u00fchrbar. </p> <p>Dazu stehen in der aktuellen Version des Schattenmandanten entsprechende neue Steuerkennzeichen f\u00fcr die Einspielung in den/die betreffenden Produktivmandanten bereit. Nach dem Import k\u00f6nnen diese Steuerkennzeichen sofort in allen Buchungsfunktionen entsprechend ausgew\u00e4hlt und zugeordnet werden. Voraussetzung daf\u00fcr ist, dass den in der Buchung verwendeten Ergebnis- bzw. Bilanzkonten die Steuerart = 1 (beliebige Steuer) zugeordnet ist.  Bei der Verwendung von Ergebnis- bzw. Bilanzkonten mit der Steuerart = 2 (genau eine Steuer) ist ein Wechsel auf die Steuerart auf 1 (beliebige Steuer) m\u00f6glich.  Ist dieser Wechsel nicht m\u00f6glich/gew\u00fcnscht, so ist die zus\u00e4tzliche Bildung neuer Unterkonten, eventuell neuer dazugeh\u00f6riger Einnahmearten und auch ggfs. neuer Tarifgruppen f\u00fcr das Ausgangsrechnungsjournal erforderlich. Au\u00dferdem werden in diesem Fall neue Buchungsstellen (Produkt-Sachkonten) ben\u00f6tigt. </p> <p>Wenn Sie bei der jeweiligen Einrichtung in Ihrem System weitere Unterst\u00fctzung ben\u00f6tigen, wenden Sie sich bitte an die IFR-Fachberatung.</p> <p>Neue Buchungsmaske - ! BETA-Version ! </p> <p>Mit der Auslieferung des Release 56 steht den Anwendern des  f\u00fcr Einzelbuchungen eine neue Buchungsmaske in der Beta-Version zur Verf\u00fcgung.</p> <p>\u00dcber den Schalter F56 - \"Alternative Einzelbuchung\" kann f\u00fcr alle Anwender die neue Beta-Buchungsmaske im Men\u00fc 311 aktiviert werden. Mit Schalterstellung \"JA\" wird beim \u00d6ffnen des Men\u00fc 311 die neue Beta-Buchungsmaske eingeblendet. Gleichzeitig besteht aber die M\u00f6glichkeit Buchungen weiterhin in der gewohnten Buchungsmaske vorzunehmen. Mit Aktivierung der neuen Beta-Buchungsmaske wird dem Nutzer alternativ unter dem Men\u00fcpunkt 319 die alte Buchungsmaske f\u00fcr die Erfassung von Einzelbuchungen zur Verf\u00fcgung gestellt. F\u00fcr die Anzeige des Men\u00fc's 319 ist den Anwendern in der Systemverwaltung/Benutzerverwaltung Men\u00fc s21 das Recht auf diesen Men\u00fcpunkt zu vergeben. </p> <p></p> <p>In der neuen Buchungsmaske stehen zwei M\u00f6glichkeiten f\u00fcr die Erfassung von Buchungen zur Verf\u00fcgung. </p> <p>M\u00f6glichkeit 1: Erfassung der Buchungsinformationen, Bet\u00e4tigung des Button \"\u00dcbernehmen\" inkl. AO-Druck sofern angehakt - analog der alter Buchungsmaske </p> <p>M\u00f6glichkeit 2: Erfassung von mehreren Buchungen in einen Stapel im Men\u00fc 311 und sp\u00e4tere \u00dcbernahme und AO-Druck. Nach der Erfassung der ersten Buchung, wird mittels Klick auf    eine neue Buchungsmaske ge\u00f6ffnet. Die vorherige Buchung wird nun im unteren Teil der Buchungsmaske \"Buchungs\u00fcbersicht\" dargestellt. Es k\u00f6nnen auf diese Art eine beliebige Anzahl Buchungen erfasst werden. Der Vorteil dieser Erfassung besteht darin, dass die Buchungen jederzeit noch ge\u00e4ndert bzw. gel\u00f6scht werden k\u00f6nnen. Dazu w\u00e4hlt man eine Buchung der Buchungs\u00fcbersicht durch Anklicken aus und die Buchungsinformationen werden in die Erfassungsmaske geladen und k\u00f6nnen ge\u00e4ndert werden. Eine L\u00f6schung ist \u00fcber    in diesem Erfassungszustand problemlos m\u00f6glich. Erst mit \"\u00dcbernehmen\" werden die Buchungen in das Men\u00fc 36 bzw. 33 \u00fcbergeben.</p> Abtauchen um Informationen zu Personenkonto, Produkt, Sachkonto oder Ma\u00dfnahme (ggf. FR-Konto) in die Felder der Buchungsmaske zu \u00fcbernehmen. Unter diesem Button k\u00f6nnen Informationen, die in der Kassenakte zu einem Personenkonto hinterlegt wurden abgerufen werden. Mit Klick auf diesen Button werden die verf\u00fcgbaren Mittel f\u00fcr alle Buchungsstellen, die im Zusammenhang mit dem in der Buchungsmaske eingegebenen Produkt stehen, angezeigt. Durch weitere Eingabe des zu bebuchenden Sachkontos in der Buchungsmaske, werden nun die verf\u00fcgbaren Mittel f\u00fcr die eingegebene Produkt / Sachkontenkombination ausgewiesen. Eine weitere Eingrenzung kann durch die Eingabe einer Ma\u00dfnahme in der Buchungsmakse erfolgen. Nach Eingabe eines Buchungsbetrages wird in diesen Feldern der aktuelle Stand von Saldo und Verf\u00fcgbarkeiten auf einem Blick dargestellt. Ebenso ist sofort ersichtlich, welche Auswirkungen die Buchung auf diese beiden Kriterien hat. Soll bei einer Buchung ein RAP erfasst werden, werden nach Setzen des Hakens weitere Eingabefelder eingeblendet (RAP-Bildung \u00a0nach Laufzeit oder betragsm\u00e4\u00dfig / Eingabe eines Zeitraumes / Eingabe eines abzugrenzenden Betrages). \u00dcber diesen Button ist es m\u00f6glich eine Ratenbuchung zu erfassen. Nach Bet\u00e4tigung des Buttons \u00f6ffnet sich der Raten-Editor. In diesem Fenster k\u00f6nnen alle notwendingen Informationen wie Abstand, Anzahl usw. eingegeben werden. Die eingegebenen Details werden sofort in einem \"Ratenplan\" f\u00fcr den Anwender dargestellt und mit jeder Eingabe bzw. \u00c4nderung aktualisiert. Der Button \"\u00dcbernehmen\" best\u00e4tigt die Eingabe und \u00dcbernahme in die Buchungsmaske. In der neuen Beta-Buchungsmaske hat man die M\u00f6glichkeit Buchungen vorab in einem Stapel zu erfassen. Dazu klickt man nach Erfassung einer Buchung auf den gelben Button im unteren Teil der Buchungsmaske. Alle so erfassten Buchungen werden im unteren Teil der Maske \"Buchungs\u00fcbersicht\" dargestellt. \u00dcber die blauen Pfeilfelder kann zwischen den einzelnen Datens\u00e4tzen in der \u00dcbersicht gewechselt werden. Mittels Doppelklick auf eine erfasste Buchung, wird diese wieder in die Buchungsmaske geladen und kann an dieser Stelle ge\u00e4ndert werden. Ebenso ist es m\u00f6glich, eine erfasste Buchung zu \u00fcber den Button \"aktuellen Datensatz l\u00f6schen\" problemlos zu l\u00f6schen. Erst mit Klick auf den Button \"\u00dcbernehmen\" werden die Buchungen in das Men\u00fc 36 / 33 weitergereicht. Eine Buchung kann auch wie aus der alten Buchungsmaske gewohnt, \u00fcber den Button \"\u00dcbernehmen\" erfasst werden, <p>In der Beta-Buchungsmaske gibt es keinen Aufteilungsbutton mehr, da die untere \"Buchungs\u00fcbersicht\" f\u00fcr die Aufteilung sorgt. Die Gesamtsumme der Buchungs\u00fcbersicht kann analog der ehemaligen \"Gesamtsumme\" der Aufteilung verwendet werden. Somit k\u00f6nnen hintereinander die einzelnen Rechnungsteile eingegeben werden. Die Taste F6 holt wie gew\u00f6hnlich den letzten Wert der Zelle nach vorn, was die Eingabe optimiert.</p> <p>Die Darstellung der Buchungs\u00fcbersicht kann mittels Kontextmen\u00fc auf S/H-gerechtes Buchen umgestellt werden.</p> <p></p> <p>Durch die neu integrierte Kalenderfunktion k\u00f6nnen Datumseingaben in der Buchungsmaske schnell ausgew\u00e4hlt werden. Ein Wechsel zwischen den Monaten erfolgt \u00fcber die Pfeilbutton oder aber \u00fcber Klick in die Angabe \"Monat Jahr\" zwischen den Pfeilen. So kann auch schnell das Jahr ge\u00e4ndert werden.</p> <p></p> <p>Das Wertstellungsdatum wurde f\u00fcr Buchungen mit Buchungsschl\u00fcssel 411 ausgeblendet.</p> <p>Zusatzmodul Gesamtauftr\u00e4ge - ! BETA-Version ! </p> <p>Der Men\u00fcpunkt 51 Auftragsverwaltung ist um ein neues lizenzpflichtiges Zusatzmodul \u201eGesamtauftr\u00e4ge\u201c erweitert worden. Dieses Modul befindet sich mit Auslieferung des Release 56 im Status einer BETA-Version. </p> <p>Mit dieser neuen Funktion ist es m\u00f6glich, einen oder mehrere IFR-Einzelauftr\u00e4ge eines Kreditors unter einer gemeinsamen (au\u00dfenwirksamen) Gesamtauftragsnummer zu f\u00fchren. </p> <p>Auf diese Weise k\u00f6nnen bislang vorhandene Akzeptanzschwierigkeiten IFR-eigener Auftragsnummern im Muster AUFE20\u2026 vermieden werden, die aktuell bspw. bei verschiedenen Versorgungsdienstleistern wie Telekom, Stadtwerken, o.\u00e4. bestehen. Hier kann ab sofort die neue Gesamtauftragsnummer der rechnungsrelevanten Vertragsnummer des Versorgers entsprechen und so eine bessere und schnellere Auftragszuordnung im Eingangsrechnungsjournal erm\u00f6glichen. Auch k\u00f6nnen im Zuge von Vergabeverfahren durch die frei eingebbaren Gesamtauftragsnummern die tats\u00e4chlichen Vergabenummern Verwendung finden und so f\u00fcr h\u00f6here Transparenz sorgen. </p> <p>Durch eine Gruppierung mehrerer Einzelauftr\u00e4ge zu einer Gesamtauftragsnummer werden auch m\u00f6gliche kontierungsbedingte Einschr\u00e4nkungen der IFR-eigenen Auftr\u00e4ge (1:1 Beziehung zwischen Auftrag und Buchungsstelle) gel\u00f6st und erlauben so korrekte Rechnungskontierungen. Dazu wurde im Eingangsrechnungsjournal Men\u00fc 52 die Erfassung der Kopfdaten einer Rechnung um das Eingabefeld \"Gesamtauftrag\" erweitert und eine automatische Anlage von Rechnungspositionen auf Vorschlagsbasis implementiert. </p> <p>Es besteht auch bereits die M\u00f6glichkeit diese flexible Gesamtauftragsnummer im Kontext \u201eelektronischer Rechnungsworkflow\u201c zu nutzen. Dabei k\u00f6nnen sowohl im Scanprozess ausgelesene oder in E-Rechnungen enthaltene Auftragsnummern als IFR-Gesamtauftragsnummer interpretiert werden. </p> <p>Eine konkrete Einweisung in diesen Prozess erfolgt im Zusammenhang mit einer Lizenzierung des Moduls \u201eGesamtauftr\u00e4ge\u201c. </p> <p>Barkassenmodul - Men\u00fc 9 </p> <p>Das  wird mit Release 56 um das lizenzpflichtige Barkassenmodul als Nebenbuch erg\u00e4nzt. Unter diesem Men\u00fc ist es m\u00f6glich Haupt- und Nebenkassen zu administrieren, Einnahmen und Ausgaben zu erfassen und diese an das Hauptbuch zu \u00fcbergeben. </p> <p></p> <p></p> <p>Sollten Sie an der Einbindung des Barkassenmoduls in Ihr  interessiert sein, steht Ihnen unser Vertriebsteam jederzeit f\u00fcr ausf\u00fchrliche Informationen zur Verf\u00fcgung. Ebenso k\u00f6nnen Sie sich bei fachlichen Fragen zu unserem neuen Modul an unsere Mitarbeiter der Fachberatung wenden. </p> <p>Starter </p> <p>F\u00fcr das Anmelden an der IFR-Wartungskonsole (SASKIA-Symbol -&gt; rechte Maustaste -&gt; Wartungskonsole) ist der Anmeldedialog um ein Feld f\u00fcr einen abweichenden DB-Nutzer erweitert worden. Damit sind jetzt Anmeldungen mit anderen DB-Nutzern, als dem Standardnutzer, m\u00f6glich. Umgesetzt ist der Anmeldedialog in der Form, wenn sich mit dem Standard-DB-Nutzer angemeldet werden soll reicht die Eingabe des DB-Passwortes. Das Feld \"Abweichender DB-Nutzer\" kann dann leer bleiben. Bei Anmeldungen mit einem abweichenden DB-Nutzer sind beide Felder zu f\u00fcllen.</p> <p>AO-Client </p> <p>In der Anwendung verk\u00fcrzter AO-Dialog (IfrAo.exe) besteht jetzt in der Dokumentengegen\u00fcberstellung auch die M\u00f6glichkeit, zus\u00e4tzliche Dokumente zu einem Vorgang hinzuzuf\u00fcgen. Dazu \u00f6ffnet sich \u00fcber die Schaltfl\u00e4che \"Dokument erg\u00e4nzen\" das Explorerfenster und erlaubt das Anf\u00fcgen weiterer Dokumente.</p> <p>Integration einer Aktualisierungsfunktion inklusive Anzeige der Uhrzeit der letzten Aktualisierung. Damit k\u00f6nnen neue Anordnungen abgerufen werden, ohne an der Mandantenauswahl oder den Weiterleitungsempf\u00e4nger eine kurzzeitige \u00c4nderung vornehmen zu m\u00fcssen. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html#0-global","title":"0 - Global","text":"<p>036 - Eigenschaften </p> <p>In den Farbeinstellungen gibt es einen neuen Eintrag \"nur Lese-Modus\". Hier kann die Farbe definiert werden, die zur Anzeige im Hintergrund der einzelnen Men\u00fcpunkten kommt. Dies gilt nur, wenn der Nutzer ein Leserecht auf den Men\u00fcpunkt hat bzw. wenn einzelne HH-Jahre von der Bearbeitung ausgeschlossen sind (Men\u00fc s21 - Benutzerverwaltung -&gt; Reiter Rechte --&gt; Recht \"HH-Jahr\").</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html#1-stammdaten","title":"1 - Stammdaten","text":"<p>11 - Mandant </p> <p>Hat ein Nutzer nur ein Leserecht, kann er sich jetzt auch seine Mandanteneinstellungen ansehen, dass war vorher nicht m\u00f6glich.</p> <p>Neuer Schalter F55 f\u00fcr das Ausgangsrechnungsjournal \"Vermischung \u00f6ffentlichr. mit privatr. Einnahmearten verbieten\" im Men\u00fc 11 integriert (siehe Men\u00fc 54)</p> <p>12a3 - Personenkontenverwaltung </p> <p>Es kam bei Personenkonten (D/K) mit gleicher Personenkontennummer zu einem Problem beim L\u00f6schen des Personenkontos. Das L\u00f6schen des zB. unbebuchten Debitoren -Personenkontos war nicht m\u00f6glich wenn, das Kreditoren-Personenkonto eine Buchung hatte bzw. andersrum. Hierzu erfolgte eine Korrektur.</p> <p>Das Sortieren von selektierten PK's \u00fcber die Spaltenk\u00f6pfe funktionierte nicht, wenn es in den selektierten PK's kein PK gab, welches eine Bankverbindung hatte. Hierzu erfolgte eine Programmanpassung.</p> <p>124 - Sachkontenverwaltung </p> <p>Beim Kopieren von Sachkonten, gab es ein Problem mit der korrekten Anzeige des Fensters f\u00fcr die Auswahl des Steuerkennzeichens. Hierzu erfolgte eine Korrektur.</p> <p>151 - Allgemeines </p> <p>Im Bereich Stammdaten ist das Gewerbekennzahlenverzeichnis hinzugef\u00fcgt und zugeh\u00f6rige umfangreiche Filter- und Suchfunktionen sind eingebaut worden. Weil dieses Verzeichnis vom Gesetzgeber verbindlich festgelegt ist, sind individuelle \u00c4nderungen nicht vorgesehen. Nach R\u00fccksprache mit der FB k\u00f6nnen die Anwender diese Kennzahl f\u00fcr die Veranlagung nutzen. \u00a0</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html#2-planung","title":"2 - Planung","text":"<p>252 - Jahresplanbest\u00e4tigung </p> <p>Die Berechnung der Verf\u00fcgbarkeit beim Setzen einer manuellen Sperre bei der Planung wurde korrigiert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html#3-buchung","title":"3 - Buchung","text":"<p>311 - Einzelbuchung </p> <p>Beim \"Verwerfen/Neu\" einer in der Erfassung befindlichen Buchung wird nun auch das Feld \"Storno\" mit geleert, sofern hier der Haken gesetzt wurde.</p> <p>Bei Buchungen mit Buchungsschl\u00fcssel 511 wurde die Auswahl \"Periode laut F\u00e4lligkeit\" \u00a0beim Weitergehen zum Buchungstext gel\u00f6scht. Hierzu erfolgte eine Programmanpassung.</p> <p>Auf der Einzelanordnung, sowie auf der AO-Liste wird neben dem Steuerbetrag und Prozentsatz, auch das Steuerkennzeichnen mit ausgewiesen.</p> <p>Bei der Auswahl des FR-Kontos f\u00fcr eine R0-Buchung (R\u00fcckstellung, BS 514) ist nun m\u00f6glich. Im Hintergrund gab es eine Einschr\u00e4nkung, die korrigiert wurde. </p> <p>Bei einer Buchung auf eine zeitlich begrenzte Ma\u00dfnahme (von/bis), erfolgt die Pr\u00fcfung auf den Leistungszeitraum nicht mehr auf das Buchungsdatum. </p> <p>312 - Dauerbuchungen </p> <p>Bei der Anzeige abgeschlossener historischer Dauerbuchungen kam es zu einem Anzeigefehler in der \u00dcbersicht. Hierzu erfolgte eine Korrektur.</p> <p>Zur Information: Zur Erfassung und Bearbeitung einer Dauerbuchung, \u00f6ffnet sich zur Bearbeitung die neue Beta-Buchungsmaske, unabh\u00e4ngig von der Einrichtung des Schalter F56. Dies ist leider systemseitig nicht anders umsetzbar.</p> <p>33 - Buchungsstapel </p> <p>Zur Information: Wird in diesem Men\u00fcpunkt in die Bearbeitung einer Buchung abgesprungen, \u00f6ffnet sich zur Bearbeitung die neue Beta-Buchungsmaske, unabh\u00e4ngig von der Einrichtung des Schalter F56. Dies ist leider systemseitig nicht anders umsetzbar.</p> <p>35 - Schnittstellen </p> <p>Wird in der Camt053-Datei die Schecknummer mitgeliefert, wird diese auch mit an das IFR \u00fcbergeben und ist unter dem Feld \u00a0\"UMS_KREF\" sichtbar. </p> <p>351 - Einrichten </p> <p>Da es unter bestimmten Bedingungen beim Einlesen der Daten zu Abbr\u00fcchen kam, wurden Modifikationen an der Eingangsschnittstelle AVVISO_AO vorgenommen </p> <p>36 - Anordnung </p> <p>Beim Abweisen von gedruckten AO-Listen wurde keine AO auf dem Bildschirm angezeigt. Hierzu erfolgte eine Korrektur.</p> <p>397 - allgemeine Dokumentenauskunft </p> <p>Unter dem Dokumententyp \"Allg-Liste\" werden entsprechende Dokumente aus dem DMS angezeigt.</p> <p>3a12 - Gesch\u00e4ftsvorf\u00e4lle </p> <p>Wenn ein Gesch\u00e4ftsvorfall mit \"autom. Sperre\" gekennzeichnet ist, wird dieses Kennzeichen beim Verarbeiten der Camt53-Datei wieder korrekt ber\u00fccksichtigt. Insbesondere Sammel\u00fcberweisungs- und Sammellastschriftpositionen werden wieder entsprechend der Stammdateneinrichtung \"Autom.Sperre\" f\u00fcr den jeweiligen Gesch\u00e4ftsvorfall behandelt.</p> <p>3a2 - Abgleich </p> <p>F\u00fcr den automatischen Kontoauszugsabgleich gibt es einen neuen Mandantenschalter F57 - Kontoauszugsverbuchung Betragspriorisierung. Bei Schalterstellung auf \"Nein\" erfolgt der Abgleich wie bisher, er f\u00e4ngt den Ausgleich bei der \u00e4ltesten OP-F\u00e4lligkeit an. Bei \"Ja\" durchsucht er alle OP's ob er einen OP-Betrag findet der genau auf den Betrag der Kontoauszugsposition passt und gleicht diesen als erstes aus. Es wird ausdr\u00fccklich darauf hingewiesen, das dadurch \u00e4ltere F\u00e4lligkeiten offen bleiben und dies zu Mahnungen f\u00fchren kann.</p> <p>Beim manuellen Abgleich werden wieder alle Verwendungszwecke angezeigt.</p> <p>Beim Einlesen von Kontoausz\u00fcgen mit CAMT.053 kam es zu einem Einlesefehler, wenn der Gesch\u00e4ftsvorfall 109 vorhanden, dieser als Batch gekennzeichnet ist und die \"\" im XML-Datenstrom fehlt. Dies trat bisher nur bei der Commerzbank auf.</p> <p>3b1 - Verwaltung der Verwahrg\u00fcter </p> <p>Bei der Verwaltung der Verwahrg\u00fcter werden im Reiter 'Auswahl' zus\u00e4tzlich die Angaben 'Bezeichnung2' und Vermerk, sowie die Gesamtsumme und der Gesamtwert des Verwahrgutes angezeigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":"<p>41 - Aufrechnung </p> <p>Das Valutadatum wird nicht mehr anhand des Buchungsdatums sondern des Belegdatums gesetzt. </p> <p>422 - Stundung - Druckliste </p> <p>Erweiterung der Stundungsliste, bessere Auswahlkriterien zur Eingrenzung der auszuwertenden Daten, eine stichtagsbezogene Auswertung ist unter anderem jetzt m\u00f6glich.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":"<p>51 - Auftragsverwaltung </p> <p>Neuer Reiter \"Gesamtauftr\u00e4ge\" - siehe Abschnitt:  Allgemein | Zusatzmodul Gesamtauftr\u00e4ge - Beta-Version </p> <p>Nach erfolgter Stornierung eines Auftrages, werden die gebundenen Mittel nun wieder freigegeben.</p> <p>In der Eingangs\u00fcbersicht der Auftragsverwaltung wurde die Spalte \"Auftragswert brutto\" erg\u00e4nzt, sodass nun auch im Eingangsrechnungsjournal beim Ziehen des Auftrages der Bruttowert erkennbar ist. Um sowohl die Spalten \"Auftragswert brutto\" als auch \"Auftragswert netto\" sehen zu k\u00f6nnen, ist es notwendig in der Auftragsverwaltung die Standardansicht herzustellen. Mit einem Rechtsklick in der Auftrags\u00fcbersicht, wird die Funktion \"Standardansicht herstellen\" angeboten.</p> <p>52 -Eingangsrechnungsjournal </p> <p>Neues Eingabefeld in den Kopfdatensiehe Abschnitt:  Allgemein | Zusatzmodul Gesamtauftr\u00e4ge - Beta-Version </p> <p>Wenn in der Sachkontenverwaltung ein Konto mit Steuerart \"1\" (beliebig Steuer) und Steuerkennzeichen \"-\" eingerichtet wurde, wird dieses bei der Erfassung einer Rechnungsposition im ERJ wieder im Feld \"Steuerkennzeichen\" vorgeblendet. Da das Sachkonto mit Steuerart beliebig eingerichtet wurde, kann es bei der Erfassung aber auch jederzeit ge\u00e4ndert werden. </p> <p>Bei der \u00dcbernahme einer eingegebenen Eingangsrechnung, kam es zu einer Fehlermeldung wenn es eine bestimmte Konstellation von HH-Jahr, Leistungszeitraum und Mittel aus Vorjahren kam. Hierzu erfolgte eine Anpassung.</p> <p>54 - Ausgangsrechnungsjournal </p> <p>Neuer Schalter F55 f\u00fcr das Ausgangsrechnungsjournal \"Vermischung \u00f6ffentlichr. mit privatr. Einnahmearten verbieten\" im Men\u00fc 11 integriert. Schalter F55 auf NEIN --&gt; Es lassen sich \u201egemischte\u201c- Rechnungen/Bescheide erfassen, d.h. Tarife (Positionen) mit privatrechtlichen und \u00f6ffentlich-rechtlichen Einnahmearten in einer Rechnung/ Bescheid sind m\u00f6glich (Standartschalterstellung). Schalter F55 auf JA --&gt; Es lassen sich nur Tarife (Positionen) mit privatrechtlichen Einnahmearten oder Bescheide mit \u00f6ffentlich-rechtlichen Einnahmearten in einer Rechnung erfassen. Ein \u201evermischen\u201c ist somit nicht m\u00f6glich.  Steht der Schalter F55 auf JA und es werden Positionen (Tarifgruppe--&gt;Einnahmeart) erfasst, welche \u00f6ffentlich-rechtlich und privatrechtlich sind, wird das Feld \u201eEinnahmeart\u201c in den Positionen rot markiert. Ein Tool-Tip zeigt an, dass eine \u201eVermischung\u201c von \u00f6ffentlich-rechtlichen und privatrechtlichen Einnahmearten nicht zul\u00e4ssig ist!</p> <p>Wenn im ARJ eine Ausgangsrechnung mit mehreren Positionen erstellt wird und die Tarifgruppe ist bei allen dieser Positionen gleich, erfolgt eine Zusammenfassung der Buchungen.</p> <p>Rechnungen sind jetzt auch von einem HHJ in das n\u00e4chste HHJ duplizierbar. Dabei wird beim Duplizieren ein Abfragedialog eingeblendet, in dem festgelegt wird, in welches HHJ und mit welchem Belegdatum dupliziert werden soll. Dabei wird dem Anwender das aktuelle Tagesdatum als Belegdatum vorgeschlagen, welches jedoch ver\u00e4nderbar ist. Das F\u00e4lligkeitsdatum orientiert sich dann am eingegebenen Belegdatum.</p> <p>55 - Stammdaten </p> <p>Bei der Erfassung eines neuen Tarifs ist das Feld \"Mindestmenge\" jetzt ein Pflichtfeld und es muss eine Eingabe &gt; o erfolgen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html#6-auswertung","title":"6 - Auswertung","text":"<p>6211 - Produkt/Budgets </p> <p>F\u00fcr eine verbesserte Darstellung der Budgetliste kann jetzt ein Blattwechsel nach jedem Produkt bzw. Budget durch die neue Option \"Blattwechsel je Gruppe\" vorgenommen werden. Als weitere Verbesserung werden jetzt hinter jedem Produkt bzw. Budget der zugeh\u00f6rige Name mit angedruckt.</p> <p>6224 - Kontoauszug intern </p> <p>Die Erstellung eines internen Kontoauszuges erfolgt nun korrekt anhand der hinterlegten Budgetrechte auch in Bezug auf die Buchungsschl\u00fcssel 6 und 7.</p> <p>6622 - Zahlungsvorschlag </p> <p>Die \u00dcbergabe des Zahlbetrags und Bezahldatums einer Eingangsrechnung an das DMS-System wurde erweitert um eine Variante per Jobverarbeitung (Men\u00fc s13). Damit k\u00f6nnen jetzt auch die Zahlungsdaten \u00fcbergeben werden, wenn Sie per Zahlvorschlag vorgenommen wurden.</p> <p>6512 - Teilfinanzplan A </p> <p>Beim Druck der Liste mit der Druckoption \"Hochkant\" wurden nicht immer alle Spalten mit Werten richtig bef\u00fcllt. Eine Korrektur des Reports erfolgte.</p> <p>673 - Verprobung </p> <p>Die Verprobung ist auf das Soll/ Haben gerechte Buchen abgestimmt worden. Die Bemessungsgrundlagen werden nun wieder korrekt ausgegeben, auch wenn S/H Kennzeichen gedreht wurden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html#7-jahresabschluss","title":"7 - Jahresabschluss","text":"<p>7113 - zu \u00fcbertragende Erm\u00e4chtigungen </p> <p>Beim \u00dcbertrag von Mitteln kam es programmseitig zu Meldungen, die so nicht richtig waren. Hierzu erfolgte eine Korrektur. Hinweis zur Umsetzung: Die \u00fcbertragbaren FR-Mittel werden jetzt positiv angezeigt und m\u00fcssen auch mit einem positiven Wert ins Folgejahr \u00fcbertragen werden. Negative Werte kommen einer R\u00fcck\u00fcbertragung aus dem Folgejahr gleich.</p> <p>731 - RAP-Verwaltung </p> <p>In den Reitern f\u00fcr die RAP-Verwaltung wird jetzt neben der Personenkontennummer, der zugeh\u00f6rige Personenname mit angezeigt.</p> <p>7333 - Einzelbewegungen </p> <p>Reiter Steuerbuchungen: Der Fehler in der Autokorrektur bei den Steuerbuchungen wurde repariert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html#8-veranlagung","title":"8 - Veranlagung","text":"<p>151 - Stammdaten Veranlagung - Allgemeines Im Bereich der Stammdaten wurde das Gewerbekennzahlenverzeichnis hinzugef\u00fcgt, zugeh\u00f6rige umfangreiche Filter- und Suchfunktionen sind eingebaut.Dieses Verzeichnis ist von Seiten des Gesetzgebers verbindlich festgelegt. Individuelle \u00c4nderungen sind nicht vorgesehen.</p> <p>81 / 82 - Einzel- / Gesamtveranlagung </p> <p>Im Buchungsprotokoll werden zus\u00e4tzlich zur Gesamtsumme je Buchungsstelle auch die Summen je Buchungsstelle und Haushaltsjahr ausgewiesen.</p> <p>Der Ausweis der Angaben im Kurzkontoauszug der Gewerbesteuern wurde \u00fcberarbeitet. R\u00fcckrechnungen werden auch bei abweichendem Wirtschaftsjahr korrekt ber\u00fccksichtigt.</p> <p>81 - Einzelveranlagung  Eigent\u00fcmerwechsel:</p> <p>Wird f\u00fcr eine Einnahmeart mit der M\u00f6glichkeit der Verwendung von Unterobjekten ein Objekt ohne Unterobjekte oder nur ein Unterobjekt in ein neues Objekt ders Neueigent\u00fcmers gewechselt, so entsteht dabei kein Unterobjekt mehr</p> <p>Wechseldatum zum Ende des laufenden HHJ (2020):</p> <p>F\u00fcr die gewechselten Objekte/UO's \u00a0entstehen sofort Jahreswechselwerte im neuen PK/Obj./StJ , beim Jahrewechsel werden keine Daten mehr aus dem Alteigent\u00fcmer entnommen. Nachtr\u00e4gliche \u00c4nderungen im Alteigent\u00fcmer sind beim Neueigent\u00fcmer zu hinterlegen, wenn diese auch dort Bedeutung haben. </p> <p>Achtung: Bereits vor dem neuen Release erzeugte ETW zum 31.12.2020 m\u00fcssen diesbez\u00fcglich nachgearbeitet werden, d.h. im Objekt/Unterobjekt des Neueigent\u00fcmers sind die Wechselwerte f\u00fcr 2021 nachzutragen, sonst erfolgt in 2021 keine Veranlagung beim Neueigent\u00fcmer!</p> <p>Objektdaten - Button '\u00dcbernahme JW-Werte':  Bei Objekten mit Unterobjekten werden in der Objektsicht generell alle Veranlagungszeilen aller UO's des aktuellen Steuerjahres \u00fcbernommen. Wenn bereits Wechselwerte manuell oder durch einen Eigent\u00fcmerwechsel vorgetragen wurden, bleiben diese erhalten. Der Bearbeiter muss somit - vor dem &lt;\u00dcbernehmen&gt; pr\u00fcfen, dass keine Dopplungen entstehen! In der Unterobjektsicht wird bei &lt;\u00dcbernahme JW-Werte&gt; nur der Wechselwert des jeweiligen Unterobjektes \u00fcbernommen.</p> <p>843 - Auswertung der Objektdaten </p> <p>Die Auswertung der Objektdaten ist auch f\u00fcr Unterobjekte m\u00f6glich. Bitte dabei beachten dass Angaben, die f\u00fcr das Gesamtobjekt gelten auch nur beim Objekt und nicht beim Unterobjekt ausgewiesen werden.  Die \u00a0JW-Werte umfassen immer nur die f\u00fcr das Folgejahr des gew\u00e4hlten Auswertungsjahres \u00a0(d.h. Steuerjahr = HHJ +1) vorhandenen Werte.</p> <p>852 - Jahreswechsel Bescheide </p> <p>Nullbescheide werden generell ins neue StJ \u00a0\u00fcbernommen, solange das Objekt nicht abgemeldet ist.</p> <p>Bei Abmeldung zum Jahresende ergeht ein Nullbescheid, der \u00fcber das Veranlagungsende informiert, wenn die Abmeldung f\u00fcr das Vorjahr erfolgte und wenn in der Einnahmeart ein Mengenfeld existiert. Treffen diese Voraussetzungen nicht zu wird kein Nullbescheid im neuen Jahr erzeugt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html#9-barkasse","title":"9 - Barkasse","text":"<p>Mit der Auslieferung des Release 56 wird das  um das Barkassenmodul im neuen Men\u00fcpunkt 9 erweitert. Dieses Modul ist lizenzpflichtig. M\u00f6chten Sie gern das Modul in Ihr  einbinden, dann wenden Sie sich bitte bez\u00fcglich einer Pr\u00e4sentation oder einer Angebotserstellung an unsere Ansprechpartner im Vertrieb. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":"<p>\u00c4nderungsanzeige/ b11 - Anlagegut Bearbeiten </p> <p>Wurde per \u00c4nderungsanzeige ein neues Anlagegut angelegt, welches sp\u00e4ter mit einem Zuschuss verkn\u00fcpft wurde, so wurde die Vorsystemkennzeichnung (ARCHIKART) in der Datenbank auch auf die Zuschusszuordnung \u00fcbertragen. Gleiches passierte, wenn der Anlagegutstamm bearbeitet wurde und Zuschusszuordnungen vorhanden waren. Dies wurde durchs Programm als Doppelverkn\u00fcpfung erkannt und verhinderte den Reimport ans ARCHIKART. Dieser Fehler wurde behoben und mit dem Releasewechsel werden ggf. fehlerhaft vorhandene Zuschussverkn\u00fcpfungen korrigiert.</p> <p>b11 - Anlagegut Bearbeiten </p> <p>Beim Switch eines Anlagegutes wird ein zugeordneter Zuschuss automatisch mit geswitcht. Dabei wurde die aufgelaufene AfA des Anlagegutes durchgereicht, statt der aufgelaufenen AfA des Zuschusses (Verkn\u00fcpfung) in den Zuschusspositionen zum Selbstverweis ausgewiesen. Dieser Fehler wurde behoben und mit dem Releasewechselpunkt: \"Korrigiere die Umbuchungs-AfA- bei Zuschuss-AfA2018 Switchposition\" werden bereits durchgef\u00fchrte Switch-Effekte korrigiert.</p> <p>b62 - Bestandsverzeichnis </p> <p>Die Auswahl des Umfangs f\u00fcr die Erstellung des Bestandsverzeichnis war aktuell nicht m\u00f6glich. Dies wurde entsprechend korrigiert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0056/programmaenderungen_release_56.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s13 - Aufgabenplanung </p> <p>Es gibt eine neue Jobklasse \"Job-Queue \u00dcberwachung\" zur \u00dcberwachung von eingestellten Jobs in der Tabelle o_job. Die Protokollausgabe als Textdatei erfolgt einmal in das unter Men\u00fc r111 eingestellte Protokollordnerverzeichnis und in die Aufgabenverwaltung - Men\u00fc 011. Der Ansatz des Jobs ist jeden Status zu \u00fcberwachen, deshalb auch daf\u00fcr eine Filter. Ein gefundener Job in dem Status wird zur Laufzeit (Triggerzeitpunkt) der Job\u00fcberwachung als \"Fehler\" betrachtet. Es werden nur die eingestellten Jobs in der Tabelle o_job auf Ihren Status gepr\u00fcft, die in der Spalte oj_option ein N und Q haben. N wie Nachtstapel und Q wie Warteschlange (Queue).</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/installation_checkliste_relea9.html","title":"Installation Checkliste Release 4.1.0057","text":""},{"location":"aktuelles/releasehistorie/release4.1.0057/installation_checkliste_relea9.html#installation-checkliste-release-410057","title":"Installation Checkliste Release 4.1.0057","text":"<p>Vorg\u00e4ngerrelease ist Release 56</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/installation_checkliste_relea9.html#update","title":"Update","text":"<p>1. Alle SASKIA \u00ae .de IFR-Nutzer abmelden </p> <p>(auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 57.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/installation_checkliste_relea9.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>1. \u00a0 Releasewechsel 57 </p> <p>Nach Herunterladen und Installation des Updates kann der Releasewechsel f\u00fcr Release 57 durchgef\u00fchrt werden.  Falls aus Vorg\u00e4nger-Releases noch offene Releasepunkte angezeigt werden, sind diese vorab - beginnend mit dem kleinsten noch offenem Release - auszuf\u00fchren. </p> <p></p> <p>Durch Markieren der entsprechenden Version der verf\u00fcgbaren Datenbank in der linken Tabelle werden die Punkte des Releasewechsels wie gewohnt in der rechten Tabelle dargestellt.</p> <ul> <li> <p>Datenbankstruktur anpassen Interne Anpassung der Datenbankstruktur in der Datenbank. Dieser Releasewechselpunkt hat keine Auswirkung auf den aktuellen Datenbestand.</p> </li> <li> <p>Datenbank\u00e4nderungen Anpassung des Datenbestandes an die neue Releaseversion.</p> </li> <li> <p>Datenbank\u00e4nderungen GWST-DTA Anpassung der Datenbanktabellen f\u00fcr die DTA-Funktion Gewerbesteuer, um den neuen Anforderungen zu entsprechen.</p> </li> <li> <p>Datenbankdefinitionen GRDS-DTA Erg\u00e4nzung der notwendigen Datenbanktabellen f\u00fcr die DTA-Funktionen Grundsteuer.</p> </li> <li> <p>Erg\u00e4nzt die Konfigurationsdaten f\u00fcr das DMS \"VISkompakt\" in den Schattenmandant Konfigurationsdaten f\u00fcr die direkte Anbindung des DMS \"VISkompakt\".</p> </li> <li> <p>Anpassung der Reportvorlagen Erg\u00e4nzungen und Anpassungen bezugnehmend auf Reportvorlagen. </p> </li> <li> <p>Korrektur FR-Erm\u00e4chtigungen F\u00fcr den korrektem Ausweis der FR-Mittel\u00fcbertragungen im fortgeschriebenen Planansatz.  Die Ausf\u00fchrung dieses RW-Punktes kann eine l\u00e4ngere Zeit in Anspruch nehmen und kann nachgelagert durchgef\u00fchrt werden, dazu den Haken bei \"Ausf\u00fchren\" herausnehmen.  Zur Durchf\u00fchrung ist es nicht notwendig, dass alle Anwender aus dem IFR abgemeldet sind.</p> </li> <li> <p>Korrektur GL_Container (kann unterbrochen werden) Es werden fehlende Angaben in der Tabelle erg\u00e4nzt. Die Ausf\u00fchrung dieses RW-Punktes kann eine l\u00e4ngere Zeit in Anspruch nehmen und kann nachgelagert durchgef\u00fchrt werden, dazu den Haken bei \"Ausf\u00fchren\" herausnehmen.  Zur Durchf\u00fchrung ist es nicht notwendig, dass alle Anwender aus dem IFR abgemeldet sind.</p> </li> <li> <p>Korrektur KS_Contaner (kann unterbrochen werden) Es werden fehlende Angaben in der Tabelle erg\u00e4nzt. Die Ausf\u00fchrung dieses RW-Punktes kann eine l\u00e4ngere Zeit in Anspruch nehmen und kann nachgelagert durchgef\u00fchrt werden, dazu den Haken bei \"Ausf\u00fchren\" herausnehmen.  Zur Durchf\u00fchrung ist es nicht notwendig, dass alle Anwender aus dem IFR abgemeldet sind.</p> </li> </ul> <p>2. Aktualisierung des Schattenmandanten </p> <p>Bei der Aktualisierung des Schattenmandaten bitte alle Punkte aktualisieren, die auf \"Ausf\u00fchren\" stehen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/letzte_programmaenderungen6.html","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0057/letzte_programmaenderungen6.html#letzte-programmanderungen","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0057/letzte_programmaenderungen6.html#auslieferung-zum-05102020-version-36162","title":"Auslieferung zum 05.10.2020 - Version 36162","text":""},{"location":"aktuelles/releasehistorie/release4.1.0057/letzte_programmaenderungen6.html#sonderfunktion-anordnungsdialog-ao-client","title":"Sonderfunktion Anordnungsdialog / AO-Client","text":"<p>IfrAO.exe </p> <p>Die Filterung der Anordnungen in der Anzeige des AO-Clients wurde \u00fcberarbeitet und liefert jetzt nur noch S\u00e4tze, die der tats\u00e4chlich angezeigten Nutzerauswahl im Feld \"weitergeleitet an\" entsprechen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/letzte_programmaenderungen6.html#6-auswertungen","title":"6 - Auswertungen","text":"<p>672 - Umsatzsteuermeldung ELSTER </p> <p>Implementierung des Updates der ELSTER/Eric-Schnittstelle (Stand 01.10.2020). </p> <p>Mit der Aktualisierung der integrierten ELSTER-Komponente wurde ein Transferfehler zum ELSTER-Annahmeserver (siehe Sendeprotokolleintr\u00e4ge) behoben. Nach dem IFR-Programmupdate ist wieder ein fehlerfreier Meldungsversand m\u00f6glich.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/letzte_programmaenderungen6.html#8-veranlagung","title":"8 - Veranlagung","text":"<p>82 - Gesamtveranlagung </p> <p>Gewerbesteuern mit im Steuerjahr 2020 vorliegenden Messbetrag von 0 wurden nicht immer ins Folgejahr \u00fcbernommen. Jetzt ist nur noch das Objektabmeldedatum entscheidend, ob die \u00dcbernahme erfolgt oder nicht.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/letzte_programmaenderungen6.html#auslieferung-zum-25092020-version-36010","title":"Auslieferung zum 25.09.2020 - Version 36010","text":""},{"location":"aktuelles/releasehistorie/release4.1.0057/letzte_programmaenderungen6.html#3-buchung","title":"3 - Buchung","text":"<p>33 - Buchungsstapel </p> <p>Die neu eingef\u00fchrten Filter Budget und Produkt wirken jetzt auch bei der Aktion \"akt. Stapel verbuchen\". D.h. es werden auch nur die Stapels\u00e4tze verbucht, die im Dialog angezeigt werden.</p> <p>36 - Anordnung </p> <p>Die Report-Vorlagenoption \"sachl/rechn. zusammenfassen\" beim Druck einer Anordnung wurde wieder aktiviert. Damit ist die gewohnte Darstellung sowohl beim Druck von Papieranordnungen als auch im DMS-Betrieb m\u00f6glich. WICHTIG: Sollte in der Mandantenverwaltung die Einstellung im Schalter F22 \"Mehrstufige Anordnung mit Unterschriftenliste\" gew\u00e4hlt werden, entf\u00e4llt die Darstellung von Unterschriftenfeldern auf der Anordnung ganz. Da diese Einrichtung genutzt wird, um weitere zus\u00e4tzliche Best\u00e4tigungsstufen im Zeichnungsprozess abzubilden, werden danach alle Unterschriften auf einem separaten Dokument zur Anordnung dargestellt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/letzte_programmaenderungen6.html#6-auswertungen_1","title":"6 - Auswertungen","text":"<p>6223 - Kontoauszug </p> <p>Werden Kontoausz\u00fcge f\u00fcr mehrere PK's gemeinsam gedruckt, so wird auf den Bescheiden der korrekte Bezug zum Kassenzeichen wieder ausgewiesen.</p> <p>6614 - Mahnvorschlag </p> <p>Die Adressangaben werden wieder vollst\u00e4ndig unter \"Debitor/Zahlungspflichtiger\" angezeigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/letzte_programmaenderungen6.html#8-veranlagung_1","title":"8 - Veranlagung","text":"<p>81 - Einzelveranlagung </p> <p>Im Eigent\u00fcmerwechsel werden die Jahreswechselwerte des Alteigent\u00fcmers jetzt auch f\u00fcr Unterobjekte \u00fcbernommen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/letzte_programmaenderungen6.html#9-barkasse","title":"9 - Barkasse","text":"<p>92 - Einnahme und Ausgabe Kasse </p> <p>Der bei Verbuchung von Barkassenvorg\u00e4ngen festgelegte (vorbelegte) Betrag wird durch die Zuordnung bzw. Auswahl eines Offenen Postens nicht mehr ver\u00e4ndert. </p> <p>AO-Client </p> <p>Im AO-Client werden jetzt wieder die gefilterten Anordnungen auf den ausgew\u00e4hlten Nutzer angezeigt. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/programmaenderungen_release_4.1.0057.html","title":"Programm\u00e4nderungen Release 4.1.0057","text":""},{"location":"aktuelles/releasehistorie/release4.1.0057/programmaenderungen_release_4.1.0057.html#programmanderungen-release-410057","title":"Programm\u00e4nderungen Release 4.1.0057","text":""},{"location":"aktuelles/releasehistorie/release4.1.0057/programmaenderungen_release_4.1.0057.html#allgemein","title":"Allgemein","text":"<p>Men\u00fc 36 Anordnung Der digitale Anordnungsworkflow im SASKIA\u00ae.de-IFR wurde um ein neues lizenzpflichtiges Modul \u201eZusatzbest\u00e4tigung\u201c erweitert. Mit Hilfe dieses Modules ist es m\u00f6glich neben den gesetzlich vorgegeben AO-Stufen (sachlich, rechnerisch, Anordnung) bis zu 10 weitere verschiedene verwaltungsspezifische Zeichnungsstufen flexibel abzubilden. Diese zus\u00e4tzlichen Zeichnungstufen k\u00f6nnen individuell eingerichtet werden.</p> <p>Men\u00fc 127e - Zusatzbest\u00e4tigungen</p> <p></p> <p>Die Tabellenansicht der Anordnungsverwaltung wurde optional geteilt. Einerseits werden wie gewohnt die bisherigen AO-Angaben dargestellt. In der \u201eaufklappbaren\u201c 2. H\u00e4lfte werden alle Angaben zu den oben beschriebenen lizenzpflichtigen Zusatzbest\u00e4tigungen ausgewiesen.</p> <p>Weiterhin ist im unteren Teil eine AO-Weiterleitungshistorie transparent nachvollziehbar.</p> <p></p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/programmaenderungen_release_4.1.0057.html#1-stammdaten","title":"1 - Stammdaten","text":"<p>11 - Mandant </p> <p>\u00dcber den neuen Button \"Drucken\" kann ein Ausdruck der Mandantenschalter erfolgen. Mittels PDF-Drucker ist auch ein Abspeichern als PDF-Datei m\u00f6glich.</p> <p>Beim Anlegen von Erinnerungsterminen f\u00fcr eine AdV wurde einige Eintr\u00e4ge nicht korrekt bef\u00fcllt, des weiteren wurden Termine doppelt angelegt, wenn das AdV-Befristungsdatum ge\u00e4ndert wurde. Bei Niederschlagungen erfolgte keine korrekte Bef\u00fcllung mit der PK-Nummer. F\u00fcr beide Sachverhalte erfolgte eine Programmanpassung.</p> <p>122 - Hierarchieverwaltung </p> <p>Unter bestimmten Voraussetzungen wurden bei der Anlage von Beschreibungszeilen in der Produktverwaltung, diese nach dem Speichern und Aktualisieren doppelt dargestellt. Dies wurde behoben.</p> <p>123 - Sachkontenverwaltung </p> <p>Beim Kopieren von Sachkonten wurde nicht immer in allen Konstellationen das richtige Kontoabschlusskennzeichen gesetzt. Dies wurde behoben.</p> <p>1275 - Einnahmearten </p> <p>Beim Druck werden die E-Arten ausgewiesen, auf die mittels der Selektion im Feld \"Budget\" eingeschr\u00e4nkt wurde. </p> <p>12a9 - Mandate l\u00f6schen </p> <p>Es wurden nicht alle PK's mit ihren Mandaten angezeigt, die zum L\u00f6schen m\u00f6glichen sind. Hintergrund war eine \u00c4nderung an einer Datenbanktabelle. Die SQL-Abfrage wurde angepasst. \u00a0</p> <p>1w - Import </p> <p>Beim Anlegen von Zusatzadressen per Schnittstelle wurde der Feldinhalt der FV-Grp zur Hauptadresse entfernt. Hierzu erfolgte eine Korrektur. Verhalten betraf nur die Schnittstelle K_Adresse und S_Standard_v4.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/programmaenderungen_release_4.1.0057.html#2-planung","title":"2 - Planung","text":"<p>264 - Sperren </p> <p>Plansperren k\u00f6nnen jetzt auch f\u00fcr Ertragskonten \u00fcber das Men\u00fc 264 wieder aufgel\u00f6st werden.</p> <p>267 - Mittel\u00fcbertragung </p> <p>Im Men\u00fc 267 Mittel\u00fcbetragungen wurden die Validierungspr\u00fcfungen f\u00fcr das Vorhandensein der jeweils eingetragenen Buchungsstellen angepasst.</p> <p>27 - Buchungsstelle </p> <p>Bei der Anlage einer Buchungsstelle wird statt wie bisher \"-\" nun \"keinem Deckungskreis zugeh\u00f6rig\" bei der Auswahl im Feld \"Deckungskreis\" angezeigt.</p> <p>291 - Planbuchungsjournal </p> <p>Beim Druck des Planbuchungsjournals kam es zu einem nicht korrekten Ausweis von gebuchten Positionen bei Mittel\u00fcbertragungskorrektur.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/programmaenderungen_release_4.1.0057.html#3-buchung","title":"3 - Buchung","text":"<p>311 - Einzelbuchung </p> <p>Beim Buchen mit Buchungsschl\u00fcssel 73* gab es noch Konstellationen, die ein Verbuchen von \"Kreditorischen Lastschriften\" erlaubte. Das Programm wurde dahingehend korrigiert, dass nun eine Warnmeldung eingeblendet wird, wenn eine solche erkannt wird.</p> <p>Bei der Ermittlung des FR-Konto's in der Buchungsmaske, kam es unter einer bestimmten Konstellationen von verbuchten OP's und der Eingabe eines Sachkontos zu einer nicht korrekten Ermittlung des FR-Kontos, sondern zu einer Anzeige des \"abweichenden FR-Kontos\".</p> <p>Unter BS 290 ist ab sofort auch eine Ma\u00dfnahme bebuchbar.</p> <p>Bei Buchungen mit Buchungsschl\u00fcssel 631 kam es in einigen F\u00e4llen zu einer nicht Verbuchung der Daten trotz der Meldung \"Buchung erfolgreich\".</p> <p>Bereits \u00fcberbuchte Aufwandsbuchungsstellen k\u00f6nnen wieder bei einer neuen Buchung mittels Budgetumbuchung \u00a0komplett ausgeglichen werden. </p> <p>Bei nachtr\u00e4glicher Bearbeitung einer 621er Buchung wurde die Belegnummer geleert bzw. gel\u00f6scht. Dieser Fehler ist nun behoben.</p> <p>313 - Sicherheitseinbehalt </p> <p>Beim Buchen eines Sicherheitseinbehaltes im Men\u00fc 313 wird der ggf. eingetragene Buchungstext 2 (ist kein Pflichtfeld) \u00a0an den entstehenden Buchungsvorgang (OP) \u00fcbergeben.</p> <p>33 - Buchungsstapel </p> <p>Der Fehler, dass bei Bearbeitung einer Buchung aus dem Buchungsstapel heraus, die \u00c4nderungen nicht korrekt angezeigt bzw. \u00fcbernommen werden, wurde behoben.</p> <p>Im Men\u00fc f\u00fcr den Buchungsstapel sind einige Erweiterungen vorgenommen worden um notwendige Pr\u00fcfm\u00f6glichkeiten noch besser zu unterst\u00fctzen. - neue Auswahlfelder \"Produkt\" und \"Budget\" - Option \"Pr\u00fcfung DMS\" mit 3 m\u00f6glichen Varianten oAlle Buchungen \u00a0 oNur mit digitalem Buchungsbeleg \u00a0 oohne digitalem Buchungsbeleg \u00a0 Diese neue Pr\u00fcfm\u00f6glichkeit auf das Vorhandensein eines digitalen Buchungsbeleges ( gescannte Eingangsrechnung, erzeugte Ausgangsrechnung, angehangenes Zusatzdokument, ect.) wird in der Spalte \u201eDMS\u201c dargestellt. Sofern ein digitalen Buchungsbelege vorhanden ist, wird es durch ein H\u00e4kchen gekennzeichnet. Hinterlegte digitale Anordnungen sind explizit ausgeschlossen bei der Pr\u00fcfung, da diese immer entstehen beim Buchungsvorgang. \u00dcber den Button \u201eDMS\u201c kann man sich die buchungsbegr\u00fcndenden Belege ansehen.(analog Men\u00fc 36 AO-Verwaltung) . </p> <p>Das Aktualisieren der Anzeige der Buchungsstapel, bis der Button \"akt. Stapel verbuchen\" aktiv wird und eine Verbuchung des n\u00e4chsten Buchungsstapels m\u00f6glich ist, dauerte unter Umst\u00e4nden sehr lange. Hier erfolgte eine Programmerg\u00e4nzung der Abfragebedingungen.</p> <p>3521 - Einlesen Beim Druck der AO nach dem Einlesen der Schnittstellendatei wurde auf der AO die nicht korrekte Versteuerungsart ausgewiesen, wenn der Mandantenschalter F03=Ja ausweist. Hierzu erfolgte eine Korrektur.</p> <p>36 - Anordnung </p> <p>Eine vermeintliche doppelte AO-Best\u00e4tigung (sachl./rechn./Anordnung) ist nicht m\u00f6glich. Bei bereits geleistete Best\u00e4tigungen werden die Nutzernamen nicht \u00fcberschrieben. Es wird eine Infobox mit den betreffenden nicht nochmal zu best\u00e4tigenden AO's angezeigt \u00a0</p> <p>Die Report-VorlagenOption \"sachl/rechn.\" beim Druck einer Anordnung wird deaktiviert. \u00a0 Stattdessen wird der Schalter F22 \"AO-erweiterte Best\u00e4tigung\" entsprechend der dort hinterlegten AO-Stufigkeit (einfach, zweifachm, dreifach) bei der Druckaufbereitung ausgewertet, damit die notwendigen Unterschriftsfelder ausgeweisen werden.</p> <p>394 - Budget\u00fcbersicht </p> <p>Beim Abtauchen in die Bewirtschaftungsbuchungen in der Spalte \"gebucht\" wird bei Buchungen mit Buchungsschl\u00fcssel 4 und 5 die PK-Nummer wieder ausgewiesen.</p> <p>In der Budget\u00fcbersicht werden in der Spalte \"erreicht/verbraucht\" die prozentualen Verf\u00fcgbarkeiten je Buchungsstelle wieder angezeigt.</p> <p>Mittel\u00fcbertragungen auf Finanzrechnungsknoten (Men\u00fc 7113) werden in der Budget\u00fcbersicht und in der Finanzrechnung sowie Teilfinanzrechnung A und B im fortgeschriebenen Planansatz mit ausgewiesen. Somit werden die separaten Erm\u00e4chtigungs\u00fcbertragungen auf den Finanzrechnungskonten auch in den entsprechenden Listen dargestellt. </p> <p>3a2 - Abgleich Kontoauszug </p> <p>Im Men\u00fc 3a12 - Gesch\u00e4ftsvorf\u00e4lle k\u00f6nnen jetzt einzelne Gesch\u00e4ftsvorf\u00e4lle (z.B. 109, R\u00fccklastschrift) als \"manuell\" f\u00fcr den Kontoauszugsabgleich gekennzeichnet werden. Diese Kontoauszugspositionen bekommen beim Einlesen im Men\u00fc 3a2 gleich das H\u00e4kchen bei \"Man.\" gesetzt und sind damit vom automatischen Abgleich ausgenommen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/programmaenderungen_release_4.1.0057.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":"<p>422 - Druckliste </p> <p>Die Stundungsliste wurde um weitere Filterkriterien zur Eingrenzung der auszuwertenden Daten erweitert. Eine stichtagsbezogene Auswertung ist m\u00f6glich.</p> <p>431 - ADV-Verwaltung </p> <p>Die Belegnummer des ADV-Bescheides wird in der \u00dcbersicht mit ausgewiesen.</p> <p>443 - Wertberichtigungsliste </p> <p>Die EWB-Liste wurde erg\u00e4nzt um den Ausweis und Summierung des EWB-Betrages und des noch offenen Forderungsbetrages. Mit diesen Angaben k\u00f6nnen die PWB und die EWB-Konten besser abgeglichen werden. Allerdings weist die EWB-Liste bei steuerpflichtigen Betr\u00e4gen noch den Bruttobetrag beim EWB-Betrag aus, obwohl der Nettobetrag verbucht wird. Hier erfolgt noch eine Anpassung.</p> <p>45 - Pauschalwertberichtigung </p> <p>Beim mehrfachen Klicken mit der Maus, auf den Button \"Best\u00e4tigung AO\", zur Best\u00e4tigung der PWB-Angaben kam es zu einer mehrfach Verbuchung und Erstellung von AO's. Hierzu erfolgte eine Programmanpassung, so dass das Verhalten nicht mehr auftreten kann.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/programmaenderungen_release_4.1.0057.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":"<p>51 - Auftragsverwaltung  Reiter Gesamtauftr\u00e4ge: </p> <p>Bei dem Button \"Zuordnen\" von Einzelauftr\u00e4gen wurde die Auswahl der vorhandenen Einzelauftr\u00e4ge um weitere Angaben erweitert</p> <p>52 - Eingangsrechnungsjournal </p> <p>Das Freitextfeld wird wieder vollst\u00e4ndig f\u00fcr Beschreibung angezeigt. 225 Zeichen sind bei Eingabe m\u00f6glich.</p> <p>54 - Ausgangsrechnungsjournal </p> <p>Wenn im Sachkonto (Men\u00fc 124) das Allgemeine Kennzeichen \"Periodenbildung anhand F\u00e4lligkeit zulassen\" eingestellt ist, kann jetzt bei der Erfassung der Ausgangsrechnungsposition entschieden werden, ob die Buchungsraten alle in eine Buchungsperiode gebucht werden sollen oder die Buchungsperiodenbildung anhand der F\u00e4lligkeitsperiode vorgenommen wird. Bei Sachkonten die das Allgemeine Kennzeichen nicht haben, bleibt es dabei, dass alle Buchungsraten in eine Buchungsperiode gebucht werden.</p> <p>Es wurde ein Fehler behoben, bei dem bei der Erstellung einer AR aus einem Muster heraus, das PK-Feld bei fehlender Bef\u00fcllung rot markiert und ein Strich in das Feld geschrieben wurde. Tauchte man dann zur Auswahl des PK's ab, wurden keine PK's angezeigt, da in die Auswahlfilterung mit \"-\" bef\u00fcllt war.</p> <p>55 - Stammdaten </p> <p>Neue Mengeneinheiten f\u00fcr den Tarif, die \u00fcber Men\u00fc 55 angelegt werden, sind sofort in der Stammdatenverwaltung ARJ nach dem Anlegen ausw\u00e4hlbar.</p> <p>Im Men\u00fc 68 Freie Auswertungen wurde unter der Rubrik Stammdaten ein neuer Report FQ0001 \"Tarifgruppen\u00fcbersicht f\u00fcr ARJ\" hinterlegt. Damit kann man die an den jeweiligen Tarifgruppen hinterlegten Tarife detailliert auswerten.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/programmaenderungen_release_4.1.0057.html#6-auswertung","title":"6 - Auswertung","text":"<p>Allgemein </p> <p>Beim Druck der Kontoausz\u00fcgen und Mahnungen kam es in bestimmten Anzeigekonstellationen zu einem Aufteilen der OP-/Mahnbl\u00f6cke beim Seitenwechsel. Durch eine Anpassung werden nun die Bl\u00f6cke beim Seitenwechsel besser zusammengehalten.</p> <p>Bei den Reports f\u00fcr die Budgetbuchungsstellenzuordnung, dem Kontoauszug, den Produkt-/Budgets und den Veranlagungsreports erfolgten Anpassungen am Layout f\u00fcr den Druck um bei Seitenumbr\u00fcchen die Druckbl\u00f6cke besser zusammenzuhalten.</p> <p>6622 - Zahlungsvorschlag </p> <p>Es wurde bei der detaillierten Anzeige der Einzelpositionen des Zahlungslaufes (Button - \u00a0Bearbeiten) ein DMS-Button zur Anzeige der Buchungsbegr\u00fcndenden Belege integriert. Die Funktionalit\u00e4t der Option \"Pr\u00fcfung DMS\" entspricht analog dem Buchungsstapel Men\u00fc 33. </p> <p>Es wurde ein Fehler behoben, bei dem der urspr\u00fcngliche Skontobetrag durch Aufrechnung mit einer Gutschrift ebenfalls reduziert wurde. Wenn im Zahllauf nun eine Eingangsrechnung mit Skonto und eine Gutschrift (ohne Skonto) gleichzeitig behandelt werden, dann wird zuerst der Skontobetrag f\u00fcr die (komplette) Eingangsrechnung ermittelt, bevor die Verrechnung von Rechnung und Gutschrift stattfindet.</p> <p>Im Men\u00fc f\u00fcr den Zahlungsvorschlag wurde bei der detaillierten Anzeige der Einzelpositionen des Zahlungslaufes \u00a0(Button Bearbeiten) ein DMS-Button zur Anzeige der Buchungsbegr\u00fcndenden Belege integriert. Die Funktionalit\u00e4t der Option \"Pr\u00fcfung DMS\" entspricht analog dem Buchungsstapel Men\u00fc 33. </p> <p>672 - Meldung </p> <p>Zum Zeitpunkt der Erstellung der USt-Jahreserkl\u00e4rung werden nun Buchungen, die bereits in der Jahreserkl\u00e4rung zugeordnet wurden, nicht mehr in den \"Ausstehenden Buchungen\" der UST-VA angezeigt. Somit sind nur nachtr\u00e4gliche Vorg\u00e4nge in den \"Ausstehenden Buchungen\" der USt-VA zu finden.</p> <p>In der Ust-Zusammenstellung werden nun die Werte anzeigt, die als Grundlage f\u00fcr die abgegebene USt-Voranmeldung dienten. Bei einer Korrekturmeldung wurden bisher auch in der Erstmeldung die korrigierten Werte ausgewiesen. Meldungen welche vor einer Korrekturmeldung erfolgt sind werden nun im Titel um den Zusatz \"historisch\" erg\u00e4nzt. </p> <p>68 - Freie Auswertungen </p> <p>Im Men\u00fc 68 wurde die Auswertung FS0003 \"1. Planungsauswertung als Erg\u00e4nzung zum Teilfinanzplan B\" um den Parameter VE \"Verpflichtungserm\u00e4chtigungen\" erweitert. Mit dieser Auswertung erh\u00e4lt man im Zeitraum der Planungsphase eine \u00dcbersicht \u00fcber die geplanten VE's. Die Freie Auswertung wurde dahingehend erweitert, dass auch Nachtragsplanvarianten ausgewertet werden k\u00f6nnen. Hier wirkt intern ein Filter \"mit Plan\"..., so dass der VE-Saldo aus Gesamtplan und Nachtrag ausgewiesen wird. Die Liste wurde bei den VE-Spalten um eine Gesamtsumme erweitert. Im Men\u00fc 6513 Teilfinanzplan B wurden die Parameter um \"nur VE\", also nur Verpflichtungserm\u00e4chtigungen erg\u00e4nzt.</p> <p>Im Men\u00fc 68 Freie Auswertungen wurde unter der Rubrik Stammdaten ein neuer Report FQ0001 \"Tarifgruppen\u00fcbersicht f\u00fcr ARJ\" hinterlegt. Damit kann man die an den jeweiligen Tarifgruppen hinterlegten Tarife detailliert auswerten.</p> <p>69/652 - gesetzliche Drucklisten/ Finanzlisten</p> <p>Mittel\u00fcbertragungen auf Finanzrechnungsknoten (Men\u00fc 7113) werden in der Budget\u00fcbersicht und in der Finanzrechnung sowie Teilfinanzrechnung A und B im fortgeschriebenen Planansatz mit ausgewiesen. Somit werden die separaten Erm\u00e4chtigungs\u00fcbertragungen auf den Finanzrechnungskonten auch in den entsprechenden Listen dargestellt. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/programmaenderungen_release_4.1.0057.html#7-jahresabschluss","title":"7 - Jahresabschluss","text":"<p>731 - RAP-Verwaltung </p> <p>Nach dem Anlegen eines RAP \u00fcber dem Men\u00fcpunkt 731 und dem \u00dcbernehmen, war dieser in der \u00dcbersichtsmaske nicht mehr sichtbar. Dies wurde behoben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/programmaenderungen_release_4.1.0057.html#8-veranlagung","title":"8 - Veranlagung","text":"<p>152 - Stammdaten der Einnahmearten </p> <p>Die Objektbeschreibung der SB-Einnahmeart kann aus den Objektbeschreibungen der Teilnehmer \u00fcbernommen werden. \u00a0</p> <p>8 - Allgemein </p> <p>Mittels Vorlagen-Option 'Vermerk nach dem oberen Bescheidtext drucken' kann gesteuert werden, ob der Bescheidvermerk im Veranlagungsbescheid oben (nach RTB_2) oder an bisheriger Stelle (vor dem RTB_3) ausgewiesen werden soll.</p> <p>8 - Umsetzung FAQ 5.3 Betriebskostenvorauszahlungen/-abrechnungen im Nebenbuch Veranlagung </p> <p>Betriebskostenvorauszahlungen sind buchhalterisch wie Anzahlungen zu behandeln. Sie stellen im Jahr der Vorauszahlung eine Verbindlichkeit ohne Ertragswirksamkeit dar. Im darauf folgenden Jahr sind die Abrechnungen der Betriebskosten je PK zu veranlagen und die festgesetzten Betriebskosten als Ertrag zu buchen. </p> <p>Mit der Abrechnung in der Veranlagung erfolgt einerseits die Sollstellung und andererseits die neu entwickelte automatisierte Sachkontenumbuchung von den Anzahlungen in den Ertrag. Sollen Einnahmearten von der bisherigen Betriebskosten-Verbuchung auf automatisierte Verbuchung der Vorauszahlungen/Abrechnungen umgestellt werden, bedarf es der \u00a0sorgf\u00e4ltigen Vorbereitung. Die Umstellung muss mit einer Vorlauffrist mit der Fachberatung vorab eingerichtet werden.</p> <p>Das Buchungsprotokoll wurde f\u00fcr diese Buchungsvorg\u00e4nge erweitert.  1. Ermittlung der Summen der PK-Buchungen (\"Summe Debitoren\" entspricht der Veranlagungssumme) - wie bisher 2. Zus\u00e4tzlich werden die aus der Veranlagung automatisiert get\u00e4tigten Sachkontenumbuchungen inklusive des verursachenden PK \u00a0im Protokoll ausgewiesen. Diese \"Summe Sachkonten\" dient der Abstimmung der SK-Buchungen je HHJ und Einnahmeart. Speziell der Nachweis zu get\u00e4tigten Anzahlungsbuchungen wird somit gef\u00fchrt. 3. Die Summen je Buchungsstelle, HHJ und E-Art werden ermittelt. Diese \"Gesamtsumme\" bildet nach wie vor die Summe aller in den Haushalt \u00fcbergebenen Buchungen ab. Treten keine Sachkontenbuchungen auf, werden die Summe Debitoren und die Gesamtsumme wie bisher ausgewiesen.</p> <p>81 - Einzelveranlagung </p> <p>Beim Eigent\u00fcmerwechsel im Sammelbescheid, in dem EArten mit Unterobjekten enthalten sind, werden beim Neueigent\u00fcmer nur die tats\u00e4chlich betroffenen EArten angelegt.</p> <p>Wird nach einer PK-Suche in die Einzelveranlagungsmaske zur\u00fcckgekehrt, kann eine beliebige neue PK-Nummer eingetragen werden. Das bei speziellem Handling erfolgte automatische Auff\u00fcllen mit Vornullen wurde abgestellt.</p> <p>Nach dem Markieren eines PK's in der Auswahl der Einzelveranlagung \u00a0aus einer angezeigten Auswahl und dem Abtauchen in die PK-Verwaltung kann nach R\u00fcckkehr in die Verwaltung ein anderes PK markiert werden. Beim anschlie\u00dfenden erneuten Verzweigen in der PK-Verwaltung werden die Daten des nun gew\u00e4hlten PK's angezeigt. </p> <p>Wird mit ratenabh\u00e4ngigen Tarifen gearbeitet, k\u00f6nnen jetzt auch im Sammelbescheid nur die Tarife ausgew\u00e4hlt werden, welche laut Objektbeschreibung dazu passend angelegt wurden. </p> <p>83 - Tarifwechsel </p> <p>Das Tarifwechselprotokoll wurde dahingehend ge\u00e4ndert, dass der Tarifwechsel korrekt nur mit dem Status 'OK' versehen wird. Nur die zu wechselnden Tarife sind auszuw\u00e4hlen, f\u00fcr die nicht betroffenen Tarife erfolgt die automatische \u00dcbernahme in den Bescheid.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/programmaenderungen_release_4.1.0057.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":"<p>b11 - Bearbeiten </p> <p>Beim Switch von Altinventarg\u00fctern die schon AfA-Buchungen f\u00fcr das aktuelle AnBu-HH-Jahr hatten, wurden keine Umbuchungsbewegungen gebildet. Hierzu erfolgte eine Korrektur.</p> <p>b123 - Auskunft </p> <p>Beim Referenzableiten eines geswitchten Inventars wurden die Switchinformationen mit in das neue Inventar \u00fcbernommen. Damit galt das neu erzeugte Inventar in den Listen als umgestelltes Inventar. Hierzu erfolgte eine Korrektur.</p> <p>b35 - Buchung/ Buchungslauf </p> <p>Im Men\u00fc b35 wurde das \u00dcberschreiben des vorher manuell gew\u00e4hlten Buchungskreises (Men\u00fc b33 oder b34) mit dem im Men\u00fc 1271 vordefinierten Buchungskreises \u00fcberschrieben. Sollte ein manueller abweichender Buchungskreis gew\u00e4hlt werden, wird dieser nun entsprechend korrekt aus dem Men\u00fc b33/b34 so \u00fcbergeben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0057/programmaenderungen_release_4.1.0057.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s11 - Systemparameter </p> <p>Um weitere Informationen aus dem DMS, bei Abruf von Rechnungen f\u00fcr den Dokumententyp \"AllBuchbeleg\" anzeigen zu k\u00f6nnen, ist die Mappingtabelle um 10 Queryfelder erweitert wurden. Weiterhin wurde ein Mappingfeld f\u00fcr das Budget eingef\u00fcgt. Dar\u00fcber k\u00f6nnen die nutzerbezogenen Budgetrechte zur Auswahl gebracht werden. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/installationchecklisterelease410058.html","title":"Installation Checkliste Release 4.1.0058","text":""},{"location":"aktuelles/releasehistorie/release4.1.0058/installationchecklisterelease410058.html#installation-checkliste-release-410058","title":"Installation Checkliste Release 4.1.0058","text":"<p>Vorg\u00e4ngerrelease ist Release 57</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/installationchecklisterelease410058.html#update","title":"Update","text":"<p>1. Alle SASKIA \u00ae .de IFR-Nutzer abmelden </p> <p>(auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 58.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/installationchecklisterelease410058.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>1. \u00a0 Releasewechsel 57 </p> <p>Nach Herunterladen und Installation des Updates kann der Releasewechsel f\u00fcr Release 58 durchgef\u00fchrt werden.  Falls aus Vorg\u00e4nger-Releases noch offene Releasepunkte angezeigt werden, sind diese vorab - beginnend mit dem kleinsten noch offenem Release - auszuf\u00fchren. </p> <p></p> <p>Durch Markieren der entsprechenden Version der verf\u00fcgbaren Datenbank in der linken Tabelle werden die Punkte des Releasewechsels wie gewohnt in der rechten Tabelle dargestellt.</p> <ul> <li> <p>Datenbankstruktur anpassen Interne Anpassung der Datenbankstruktur in der Datenbank. Dieser Releasewechselpunkt hat keine Auswirkung auf den aktuellen Datenbestand.</p> </li> <li> <p>Datenbank\u00e4nderungen Anpassung des Datenbestandes an die neue Releaseversion.</p> </li> <li> <p>Anpassung der Reportvorlagen Installation von neuen Reportvorlagen und Deinstallation nicht mehr ben\u00f6tigter Reportvorlagen.</p> </li> <li> <p>Convert table columns from 'System.Decimal' to 'System.Int.32' Strukturelle Typ-Anpassung in der Datenbank.</p> </li> <li> <p>Datenbank\u00e4nderungen GWST-DTA Aktualisierung der Codetabellen f\u00fcr die digitalen Gewerbesteuerbescheide.</p> </li> <li> <p>Stammdatenerweiterung f\u00fcr die Tabelle 'VS_Dtaobj' Erg\u00e4nzung der Stammdaten f\u00fcr die digitalen Gewerbesteuerbescheide.</p> </li> <li> <p>Anpassung der IFR-Metadaten-Bezeichnung f\u00fcr das Feld \"STATUSDOK\" Vereinheitlichung der Metadaten f\u00fcr die DMS-\u00dcbergabe auf IFR-Seite.</p> </li> <li> <p>Erweiterung von Anbu-Sachkonten-Views Erweiterung und Aktualisierung von Datenbankansichten der Anlagenbuchhaltung.</p> </li> <li> <p>Korrektur KS_CONTAINER - Teil 3 (kann unterbrochen werden) Es werden fehlende Angaben in der Tabelle erg\u00e4nzt. Die Ausf\u00fchrung dieses RW-Punktes kann eine l\u00e4ngere Zeit in Anspruch nehmen und kann nachgelagert durchgef\u00fchrt werden, dazu den Haken bei \"Ausf\u00fchren\" herausnehmen.  Zur Durchf\u00fchrung ist es nicht notwendig, dass alle Anwender aus dem IFR abgemeldet sind.</p> </li> <li> <p>Korrektur KS_CONTAINER - Teil 4 (kann unterbrochen werden)  Es werden fehlende Angaben in der Tabelle erg\u00e4nzt.</p> </li> </ul> <p>Die Ausf\u00fchrung dieses RW-Punktes kann eine l\u00e4ngere Zeit in Anspruch nehmen und kann nachgelagert durchgef\u00fchrt werden, dazu den Haken bei \"Ausf\u00fchren\" herausnehmen.  Zur Durchf\u00fchrung ist es nicht notwendig, dass alle Anwender aus dem IFR abgemeldet sind.</p> <p>2. Aktualisierung des Schattenmandanten </p> <p>Bei der Aktualisierung des Schattenmandaten bitte alle Punkte aktualisieren, die auf \"Ausf\u00fchren\" stehen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html#letzte-programmanderungen","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html#auslieferung-zum-15012021-version-37513","title":"Auslieferung zum 15.01.2021 - Version 37513","text":""},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html#67-umsatzsteuer","title":"67 - Umsatzsteuer","text":"<p>Es wurden die folgenden Formulare (Elster-Komponenten) f\u00fcr den Bereich Umsatzsteuer (Men\u00fc 67) aktualisiert und implementiert: Formular Ust.-Voranmeldung f\u00fcr 2021. Formular Antrag Dauerfristverl\u00e4ngerung f\u00fcr 2021. Formular Ust.-Jahresmeldung 2020.</p> <p>Die Auslieferung im IFR hat sich verz\u00f6gert, weil die Elster-Formulare in der endg\u00fcltigen Form durch die Finanzverwaltung nicht eher zur Verf\u00fcgung standen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html#b73-jahresabschluss","title":"b73 - Jahresabschluss","text":"<p>Es wurde ein Fehler behoben, welcher den Jahresabschluss der Anlagenbuchhaltung verhinderte, obwohl alle Pr\u00fcfl\u00e4ufe erfolgreich ohne Beanstandungen abgeschlossen wurden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html#auslieferung-zum-18122020-version-37300","title":"Auslieferung zum 18.12.2020 - Version 37300","text":""},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html#12a3-personenkontenverwaltung","title":"12A3 - pERSONENKONTENVERWALTUNG","text":"<p>Die Bearbeitung von Zusatzadressen, die nicht als Debitor angegelegt sind \u00a0( Adressnummern mit #T....) ist wieder m\u00f6glich.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html#3521-schnittstelle-einlesen","title":"3521 - Schnittstelle EinLesen","text":"<p>Ein Fehler in der Adresspr\u00fcfung beim Einlesen einer Schnittstelle wurde behoben</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html#36-anordnung","title":"36 - Anordnung","text":"<p>Der Fehler, dass die AO-\u00dcbersichtsliste nicht mehr als PDF aufbereitet und angezeigt werden konnte, wurde behoben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html#672-meldung","title":"672 - Meldung","text":"<p>Der Validierungsfehler \"falsches Format f\u00fcr Zeitraum\" (R\u00fcckmeldung vom ELSTER-Portal) beim Versenden der Umsatzsteuer-Jahresmeldung wurde behoben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html#b241-druck-sonderpostenkarten","title":"b241-Druck Sonderpostenkarten","text":"<p>Der Druck der Sonderpostenkarte funktioniert wieder vollst\u00e4ndig mit allen \"Gew\u00fcnschten Informationen\". </p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html#auslieferung-zum-11122020-version-37203","title":"Auslieferung zum 11.12.2020 - Version 37203","text":""},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html#allgemeines","title":"AllgemeinES","text":"<p>Die Anzeige bestimmter PDF-Dateien erfolgte unvollst\u00e4ndig, weil die durch Scanner oder Fremdsoftware erzeugten PDF's Bilder enthielten, die nicht den PDF-A Konventionen entsprechen. Die im JPEG2000-Format vorliegenden Bilder in den PDF's werden nun trotzdem angezeigt. Eine Abh\u00e4ngigkeit zu einer Fremdbibliothek wurde entfernt, so dass keine lokalen Installationen auf den Arbeitspl\u00e4tzen mehr erforderlich sind.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html#6s-dokumentenmappe","title":"6S - Dokumentenmappe","text":"<p>Die Verarbeitung der Dokumentenmappe blieb unvermittelt stehen und die Verarbeitung wurde nicht zu Ende gef\u00fchrt. Dies wurde behoben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/letzte_programmaenderungen7.html#9-barkasse","title":"9 - Barkasse","text":"<p>Das Feld f\u00fcr den Geldtransit ist beim Absprung in die Maske zum Abschluss der Zahlung nicht mehr vorbelegt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html","title":"Programm\u00e4nderungen Release 4.1.0058","text":""},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html#_1","title":"Programm\u00e4nderungen Release 4.1.0058","text":""},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html#programmanderungen-release-410058","title":"Programm\u00e4nderungen Release 4.1.0058","text":""},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html#allgemein","title":"Allgemein","text":"<p>DB-Copy Tool </p> <p>Ab sofort werden die Systemparameter (s11) f\u00fcr den SASKIA\u00ae.de-Server (IFR Dienste + Jobsteuerung), den E-Post Client sowie die Konfiguration (s14) f\u00fcr die SASKIA\u00ae.de-OSK inkl. Data Warehouse beim Duplizieren einer Echtdatenbank in eine Testdatenbank geleert. Damit wird sichergestellt, dass kein Durchgriff aus dem Testsystem in die Produktivumgebung erfolgen kann.  Des Weiteren wurde das \"SqlServerCopyTool\" umbenannt in \"SaskiaDbCopy\". Dies ist bei vorhandener Einbindung des Tools in den SASKIA.Starter zu ber\u00fccksichtigen, denn dadurch ist der Pfad in der Starter.ini entsprechend anzupassen.</p> <p>011 - Aufgabenverwaltung </p> <p>Beim L\u00f6schen von Terminen aus der Aufgabenverwaltung und der Anzeige unter Benachrichtigungen gab es ein Problem. Hierzu erfolgte eine Korrektur.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html#1-stammdaten","title":"1 - Stammdaten","text":"<p>11 - Mandant </p> <p>Im Mandantenstamm im Reiter Buchungsstellen (A-Parameter) lassen sich ab sofort Kontenausnahmen (A0-Konten) definieren. Damit ist es m\u00f6glich, in der Rechnungszuordnung per \u201eER+\u201c, nicht investive sowie nicht AnBu \u00a0relevante Rechnungen ausblenden zu k\u00f6nnen. In der Rechnungszuordnung wird dies nach Aktivierung der Funktion als Zusatzbedingung eingeblendet, welche falls notwendig auch deaktiviert werden kann. </p> <p>12a3 - Personenkontenverwaltung </p> <p>Die Befristungsangaben 'Gilt von' / 'Gilt bis' \u00a0k\u00f6nnen bei allen bestehenden / neu angelegten Zusatzadressen gepflegt werden.</p> <p>123 - Listenpositionsverwaltung </p> <p>Ab R58 steht nach Aktualisierung des Schattenmandantes die Liste Nr. 91 im Reiter \"ER-Positionen\" - \u00a0\"Ist-Ergebnis f\u00fcr die Verrechnung/\u00dcbertagung\" zur Verf\u00fcgung. Diese Liste ist an das Muster 21 angelehnt und zeigt die Ist-Ergebnisse, die f\u00fcr die Verrechnung gem\u00e4\u00df \u00a7 72 Abs. 3 Satz 3 S\u00e4chsGemO und der \u00dcbertragung gem\u00e4\u00df \u00a7 24 Abs. 3 Satz 2 S\u00e4chsKomHVO notwendig sind.</p> <p>In der Liste \"Ergebnishaushalt\" wird nun in der Zeile 29 \"Fehlbetragsabdeckung\" als Teil\u00fcberschrift ohne Wertangabe ausgewiesen.</p> <p>1273 - Steuerkennzeichen </p> <p>Die f\u00fcr eine standardisierte Erstellung bzw. Verarbeitung von eRechnungen notwendige Zuordnung auf sog. TaxCategoryCodes ist ab sofort in den Steuerkennzeichen (Men\u00fc 1273) \u00fcber eine neue Auswahlliste m\u00f6glich. WICHTIG: Eine automatische Zuordnung der neuen ISO-Steuercodes z.B. \u00fcber den Releasewechsel wird aufgrund einer Vielzahl unterschiedlich strukturierter Bestandssteuerkennzeichen nicht vorgenommen. Bei R\u00fcckfragen wenden Sie sich bitte an die Fachberatung. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html#2-planung","title":"2 - Planung","text":"<p>27 - Neue Buchungsstelle </p> <p>Bei der Auswahl von Produkt / Ma\u00dfnahmekombinationen beim Anlegen von Buchungsstellen kam es in Ausnahmef\u00e4llen zu einem Fehlverhalten beim Selektieren bzw. bei der Pr\u00fcfung der gew\u00e4hlten Kombination. Hierzu erfolgte eine Anpassung.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html#3-buchung","title":"3 - Buchung","text":"<p>311 - Einzelbuchung </p> <p>Nach der Einf\u00fchrung des S/H-Kennzeichens im Buchungsbetragsfeld der Buchungsmaske kam es immer wieder zu Problemen mit dem bef\u00fcllen des Feldes, vor allem bei der Arbeit mit der F6-Taste. Dadurch erfolgte unter Umst\u00e4nden ein unbeabsichtigtes Drehen der Buchung, je nach vorheriger Eingabe bzw. Buchungsschl\u00fcssel. Zur Verbesserung des Verhaltens hat das S/H-Kennzeichen jetzt in ein eigenes Feld bekommen.</p> <p>3521 - Einlesen </p> <p>Beim Anlegen von Adressdaten mit Zusatzadressen \u00fcber die Schnittstelle wurde das Auslandskennzeichen bei der Zusatzadresse nicht mit \u00fcbernommen. Hierzu erfolgte eine Anpassung.</p> <p>353 - Ausgeben </p> <p>In der GoBD-Schnittschnittstelle wurde eine Korrektur an den Filterparametern nach Produkt und Sachkonto durchgef\u00fchrt. Es kann nun eine Filterung von Sachkonten und/oder Produkten vorgenommen werden. Eine Filterung kann mit \"%\" f\u00fcr einen bestimmten Bereich, mit \":\" f\u00fcr von-bis Werte und \"OR\" f\u00fcr mind. zwei genaue Werte vorgenommen werden.</p> <p>36 - Anordnung Wenn der Nutzer sachlich und auch rechnerisch best\u00e4tigen kann, gibt es die M\u00f6glichkeit beide Best\u00e4tigungsstufen in einer Funktion(Button) abzuschlie\u00dfen oder doch jeweils einzeln. Dies gilt bei Mehrfachauswahl oder 3-stufiger Best\u00e4tigung . </p> <p>In der AO-Verwaltung wurde teilweise nach Anordnung und Verbuchung nicht korrekt der Nutzer und das Datum des Verbuchens eingetragen. Das Anzeigeproblem wurde behoben.</p> <p>3a11 - Abgleichsregeln </p> <p>Mit dem neuen Button Standardregeln k\u00f6nnen Kontoabgleichsregeln zur Anwendung gebracht werden, welche urs\u00e4chlich aus dem IFR stammen. \u00a0</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":"<p>421 - Stundung bearbeiten </p> <p>Bei einem Stundungswiderruf wurden die ausgewiesenen Angaben zur Restschuld \u00fcberarbeitet, sodass der korrekte Widerrufs-Betrag dargestellt wird.</p> <p>444 - Wertberichtigungsbearbeitung </p> <p>Im Selektionsfeld f\u00fcr den Mahngrad gab es ein Fehler, die die Ausf\u00fchrung der Selektion verhinderte. Hierzu erfolgte eine Korrektur.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":"<p>52 - Eingangsrechnungsjournal </p> <p>Aus E-Rechnungen k\u00f6nnen im Eingangsrechnungsjournal auch die einzelnen Positionen entsprechend der Rechnung angelegt und mit Metadaten (bspw. Betrag und Buchungstext 2) \u00a0bef\u00fcllt werden. Diese Erweiterung ist ein lizenzpflichtiges Modul. Bei Interesse setzten Sie sich bitte mit unseren Fachberatern in Verbindung.</p> <p>Bei der \u00dcbernahme von eRechdaten aus dem DMS in die Rechnungseingangsmaske werden jetzt die Steuerkennzeichen bei den Rechnungspositionen erstmal fest \u00fcbernommen und beim Positionswechsel nicht mehr entfernt. Erst bei der Auswahl der Buchungsstelle (Produkt/Sachkonto) wird das endg\u00fcltige Steuerkennzeichen der Position ermittelt und f\u00fcr die Position \u00fcbernommen.</p> <p>Bei der Aufteilung in Positionen von Eingangsrechnungen per FIBU-Verteilung kam es zu einer nicht korrekten Ansicht der aufgeteilten Positionen vor dem \u00dcbernehmen, wenn Steuerbetr\u00e4ge mit involviert waren.</p> <p>Bei der zentralen Vorerfassung von Eingangsrechnungen mit sp\u00e4terer dezentraler Kontierung ist das Steuerkennzeichen jetzt kein Pflichtfeld mehr. Lediglich in Verbindung mit der Vergabe einer Kontierung je ER-Position wird auf ein zul\u00e4ssiges Steuerkennzeichen gepr\u00fcft.</p> <p>54 - Ausgangsrechnungsjournal </p> <p>Das Feld Debitor inkl. Bezeichnung nach dem Duplizieren einer Ausgangsrechnung und Speicherung als Muster bleibt nun leer.</p> <p>Es erfolgte eine \u00dcberarbeitung der durchf\u00fchrbaren Aktionen die ein Nutzer durchf\u00fchren kann, wenn er auf den Men\u00fcpunkt nur \"Leserecht\" hat. Der Nutzer kann sich die zugeordneten DMS-Dokumente anzeigen lassen und sich den Inhalt der erfassten Ausgangsrechnung \u00fcber \"Bearbeiten\" anzeigen lassen, aber keine \"\u00dcbernahme\" vornehmen.</p> <p>Das Ausgangsrechnungsjournal wurde um eine lizenzpflichtige Funktionalit\u00e4t zur Erzeugung und dem Versand von ERechnungen erweitert. Es werden aktuell die Formate XRechnung 1.2, XRechnung 2.0, ZUGFeRD 2.1, \u00a0ZUGFeRD 2.1.1 und Factur-x 1.0 unterst\u00fctzt. Die Angaben zum zu verwendenden Format werden in den Stammdaten zum jeweiligen Personenkonto hinterlegt Der Versand der erzeugten E-Rechnungen wird \u00fcber den Men\u00fcpunkt 001 Aufgabenverwaltung erm\u00f6glicht. Hier kann die erzeugte E-Rechnung wahlweise individuell im Filesystem abgespeichert oder direkt per E-Mail an den Empf\u00e4nger versandt werden. Bei weitergehenden Fragen k\u00f6nnen Sie sich gerne an die IFR-Fachberatung wenden.</p> <p>55 - Stammdaten </p> <p>Die Feldl\u00e4nge (Zeichenl\u00e4nge) f\u00fcr das Anlegen einer Tarifgruppe bzw. eines Tarifes im \u00a0wurde auf max. 50 Zeichen erweitert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html#6-auswertung","title":"6 - Auswertung","text":"<p>671 - Journal </p> <p>In der Steuerbuchungsrecherche wurden die Filterfelder \"Produkt/Gegen\" und \"Steuerkennzeichen\" erg\u00e4nzt. Somit kann bereits vor dem ersten Laden der Steuerbuchungen gezielt auf diese zwei Kriterien gefiltert werden. </p> <p>69 - gesetzliche Drucklisten </p> <p>Es wurde f\u00fcr Sachsen-Anhalt f\u00fcr die gesetzliche Liste Muster 09 das Layout sowie die Datenausgabe korrigiert.</p> <p>Beim Muster 21 - Fehlbetrag Abschreibungen / Basiskapital k\u00f6nnen jetzt durch Einf\u00fcgen von Listenpositionen mit der Positionsart = N eine Art Pseudoleerzeile eingef\u00fcgt werden.</p> <p>\u00dcber das Men\u00fc 69 kann nun f\u00fcr die Finanzrechnung auch die Buchungsperiode 0 ausgew\u00e4hlt werden, wenn die Vorjahreswerte mit einbezogen werden sollen und nicht nur die Jahresver\u00e4nderungen gew\u00fcnscht sind.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html#7-jahresabschluss","title":"7 - Jahresabschluss","text":"<p>7112 - \u00dcbertragbare Buchungsstellen </p> <p>F\u00fcr die Eingabe individueller Buchungstexte zur Mittel\u00fcbertragung steht jetzt der Buchungstext 2 zur Verf\u00fcgung.</p> <p>72 - Kassenjahreswechsel </p> <p>Um die Auszifferung in alten HH-Jahren bei \u00dcberzahlungen weiter zu gew\u00e4hrleisten, werden jetzt beim KJW die 3 Sachkonten (27,67,77*) f\u00fcr die \u00dcberzahlung nicht mit abgeschlossen.</p> <p>7333 - Einzelbewegungsabstimmung Bei der Einzelbewegungsabstimmung im Reiter \"Auftr\u00e4ge Reservierungen\" gab es in einem der Pr\u00fcfskripte ein Fehlverhalten. Was zum Ausweis von Fehlers\u00e4tzen f\u00fchrte, die nicht plausibel waren.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html#8-veranlagung","title":"8 - Veranlagung","text":"<p>Allgemein </p> <p>Das Buchungsprotokoll der Veranlagung weist Umsatzsteuer aus, wenn umsatzsteuerpflichtige Einnahmearten angesprochen werden. Der Ausweis erfolgt je F\u00e4lligkeit der Sollstellung und zus\u00e4tzlich als Summe pro Buchungsstelle.</p> <p>81 - Einzelveranlagungen </p> <p>Der Eigent\u00fcmerwechsel wurde dahingehend gesch\u00e4rft, dass keine bereits mit Abmeldedatum versehenen Objekte / Unterobjekte ber\u00fccksichtigt werden. Sind beim durchzuf\u00fchrenden Eigent\u00fcmerwechsel abgemeldete Objekte/Unterobjekte mit Abmeldedatum in der Zukunft betroffen, wird auf diesen Sachverhalt verwiesen. Der Anwender kann individuell entscheiden, wie mit diesen verfahren werden soll.</p> <p>F\u00fcr den Druck der Veranlagungsbescheide gibt es eine neue Druckvorlagenoption \"ohne Anmeldung zur Insolvenztabelle\". Mit dieser Option kann bei insolventen Objekten der Satz bez\u00fcglich der Insolvenztabelle beim Druck unterdr\u00fcckt werden. </p> <p>Die Berechnung der Erstattungszinsen wurde \u00fcberarbeitet, bereits verzinste Zahlungen werden korrekt ber\u00fccksichtigt.</p> <p>Die aus dem Nebenbuchwerk ins Hauptbuch \u00fcbergebenen Veranlagungsbuchungen, die noch nicht haushaltswirksam sind, \u00a0k\u00f6nnen gefiltert werden. Mit gesetztem Filter werden die PK's angezeigt, welche in der Veranlagung gebucht wurden aber im Haushalt noch unverbucht sind.</p> <p>Bei der Stornierung von Veranlagungen erfolgt die Verbuchung im Haushaltsjahr der urspr\u00fcnglichen Veranlagung. Das hei\u00dft bei Veranlagungen aus nicht aktuellen Haushaltsjahre wird in diese Jahre gebucht, solange die Haushaltsjahre noch nicht abgeschlossen sind. Sind abgeschlossene Haushaltsjahre betroffen, erfolgt die Buchung ins Haushaltsjahr laut Buchungsdatum der Stornierung.</p> <p>Umsetzung der zeitweiligen MwST-Senkung 2020 im Geb\u00fchrenbescheid: </p> <p>Die befristete Senkung der Umsatzsteuer f\u00fcr das 2.HJ 2020 wurde f\u00fcr den Bereich der Geb\u00fchren eingepflegt. Die Reduzierung erfolgt im Rahmen der Abrechnungen des Haushaltsjahres 2020. Die n\u00f6tigen vorbereitenden Arbeiten daf\u00fcr sollten in Abstimmung mit der Fachbetreuung erfolgen! F\u00fcr die Nutzung der neuen Funktionalit\u00e4t sind folgende Voraussetzungen notwendig: 1. Anlegen des Sachkontos mit 5% Umsatzsteuer im HHJ 2020 (Men\u00fc 124) 2. Anlegen der ben\u00f6tigten Buchungsstelle im HHJ 2020 (Men\u00fc 27) 3. Anlegen der Einnahmeart f\u00fcr diese Buchungsstelle im HHJ 2020 (Men\u00fc 1275) 4. Men\u00fc 11 im HHJ 2020 den neuen Schalter : V13 mit den Angaben zur \u00a0Buch-EArt, die f\u00fcr die Vorauszahlungen genutzt wurde \u00a0/ \u00a0Buch-Eart mit gemindertem Steuersatz belegen \u00a0( z.B. 1010/9010) Die Abrechnung der Geb\u00fchren erfolgt in bekannter Weise, im Bescheid wird die Umsatzsteuersenkung ausgewiesen. Im Buchungsprotokoll/Buchungsvorschau der Veranlagung ist die Verrechnung auf die neue Buchungsstelle erkennbar. Achtung: Die Umsatzsteuerreduzierung erfolgt nur im Rahmen von Abrechnungen (A oder AV- Bescheide), nicht bei Vorauszahlungen oder Abrechnungsberichtigungen. Fehlerhafte Abrechnungsbescheide sind zwingend zu stornieren!!! Nach dem Buchen der Bescheide im Men\u00fc 8* und der \u00dcbernahme in den Haushalt im Men\u00fc 33 \u00a0sind je PK/Objekt die offenen F\u00e4lligkeiten auf den beiden Buchungsstellen aufzurechnen.</p> <p>82 - Gesamtveranlagung </p> <p>Der Buchungskreis, im Reiter \"Buchen\", der Gesamtveranlagung war abweichend von der Einzelveranlagung noch ein Pflichtfeld.  Um hier ein gleiches Verhalten zu erreichen, ist der Buchungskreis nun kein Pflichtfeld mehr.</p> <p>83 - Tarifwechsel </p> <p>Beim Tarifwechsel wird gepr\u00fcft, ob sich noch Buchungen im Buchungsstapel befinden. Sollte dies der Fall sein, wird der Tarifwechsel nicht durchgef\u00fchrt.</p> <p>Das Abweisen von Veranlagungen, welche aus dem Tarifwechsel resultieren, war unter bestimmten Konstellationen nicht m\u00f6glich- das wurde behoben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html#9-barkasse","title":"9 - BARKASSE","text":"<p>911 - Stammdaten </p> <p>Bei der Einrichtung einer Kasse kann nun \u00fcber die Auswahl \"Bargeldlose Zahlungen zulassen\" festgelegt werden, ob \u00fcber die Kasse EC-Zahlungen m\u00f6glich sind. Mit aktiver Funktion steht im Men\u00fc 92 die Auswahl \"bargeldlos\" zur Verf\u00fcgung. Ansonsten ist die Auswahl inaktiv. Bitte pr\u00fcfen Sie die Einrichtung Ihrer bereits angelegten Kassen, da mit Auslieferung des Releases die Funktion \"Bargeldlose Zahlungen zulassen\" auf inaktiv gesetzt ist.</p> <p>92 \u00a0- Einnahmen und Ausgaben Kasse </p> <p>Eine nutzerspezifisch eingerichtete Ansicht des Kassenjournales bleibt nun auch nach erneutem \u00d6ffnen des Men\u00fcpunktes und einem Programmneustart erhalten.</p> <p>Besteht beim \"\u00dcbernehmen\" eine Differenz bei der Erstellung des Tagesabschlusses zwischen Z\u00e4hlbestand und Soll-Bestand, erfolgt nun eine Sicherheitsabfrage, ob der Tagesabschluss trotz Differenz erfolgen soll. \"JA\" erstellt den Tagesabschluss trotz Differenz, mit \"NEIN\" verbleibt man in der Maske und kann ggf. noch Korrekturen vornehmen oder die Erstellung des Z-Bons abbrechen.</p> <p>Werden Pflichtfelder, wie Betrag oder Bezeichnung / Tarif bei der Erfassung der Position/en nicht bef\u00fcllt, erfolgt nun bereits in dieser Maske eine Pflichtfeldpr\u00fcfung. Fehlt eine Angabe wird ein Fehlerfenster eingeblendet und ein Weitergehen zum Zahlungsabschluss ist nicht m\u00f6glich. Erst mit Bef\u00fcllung des Pflichtfeldes kann die Positionserfassung abgeschlossen werden.</p> <p>Wird bei der Eingabe des \"gegebenen\" Betrages ein kleiner Wert als der zu \"zahlende\" Betrag eingebeben, wird das Eingabefeld rot hinterlegt. Beim Klick auf den Button \"Zahlung abschlie\u00dfen\" erfolgt eine Fehlermeldung.</p> <p>Das Feld \"Menge\" wird nun automatisch mit \"1\" bei der Erfassung einer Kassenbewegung vorbelegt. Bei der Verwendung von Tarifen, wird die im Ausgangsrechnungsjournal hinterlegte Mindestmenge inkl. der Mengeneinheit vorgeblendet. Die Werte im Feld \"Menge\" sind Vorschlagswerte und k\u00f6nnen jederzeit ge\u00e4ndert werden. Die Angaben sind nun auch Bestandteil der Quittung.</p> <p>Kassenbewegungen, die bereits in einen erstellten Kassenabschluss (Z-Bon) einflie\u00dfen, k\u00f6nnen nun nicht mehr storniert bzw. gestrichen werden, Es erfolgt eine Hinweismeldung. Eine Verbuchung der Kassenbewegung nach Erstellung des Z-Bons ist weiterhin m\u00f6glich.</p> <p>F\u00fcr den Druck des Kassenabschlusses (Z-Bon) wurde die Vorlagen-Option \"Druck mit Einnahme-/Ausgabedetails\" \u00a0hinzugef\u00fcgt. Ist diese Option gew\u00e4hlt, werden die Summen f\u00fcr Einnahmen und Ausgaben detailliert gesplittet auf Bar-, Kartenzahlung, Transit und Storno.</p> <p>Bei der \u00dcbergabe einer erfassten Barzahlung in die Einzelbuchungsmaske mittels Button \"Buchen\" ist f\u00fcr Einnahmen (kreditorisch) der BS 731 und f\u00fcr Ausgaben in der Kasse der BS 631 (debitorisch) vorbelegt. Sollte f\u00fcr die gew\u00e4hlte Buchung ein anderer Buchungsschl\u00fcssel ben\u00f6tigt werden, kann dieser im Feld \"Buchungsschl\u00fcssel\" ge\u00e4ndert werden.</p> <p>Der aus der Barkasse \u00fcbergeben Inhalt aus Feld Bezeichnung (in Buchungsmaske: BT1) und Notiz ( in Buchungsmaske: Freitext) bleibt nun auch nach dem Abtauchen auf einen OP in der Einzelbuchungsmaske erhalten und wird nicht mit dem Text aus der Sollstellung \u00fcberschrieben.</p> <p>Stapelverbuchung - Barkasse : </p> <p>Anwendern, welche das Recht auf die Einzelbuchungsmaske haben, wird mit dem Release 58 die M\u00f6glichkeit der Stapelverbuchung \u00a0\u00fcber den gleichnamigen Button angeboten. \u00dcber diese lizenzpflichtige Funktion k\u00f6nnen vorab ausgew\u00e4hlte Kassenbewegungen (Einnahmen!) mittels Stapel verbucht werden. Ein Stapelbuchung von Ausgaben, Kreditkartenzahlungen und Geldtransitbuchungen ist nicht m\u00f6glich. Ist eine derartige Erfassung bei der Vorabselektion enthalten, wird diese nicht mit in den Stapel \u00fcbernommen. </p> <p>Vorgehensweise: </p> <p>Die zur Stapelbuchung vorgesehen Kassenbewegungen (Einnahmen) markieren und \u00fcber den Button \"Stapelbuchung\" in die Stapelverbuchung \u00fcbergeben. Die ausgew\u00e4hlten Erfassungen werden Ihnen in einer Tabelle angezeigt. An dieser Stelle k\u00f6nnen Sie \u00fcber das rote Kreuz noch Erfassungen gezielt aus der Verbuchung herausnehmen. Die entfernten Kassenbewegungen verbleiben mit Status \"erfasst\" im Kassenjournal.</p> <p>In der Stapelverbuchung haben Sie drei M\u00f6glichkeiten, die ausgew\u00e4hlten Erfassung in das Men\u00fc 36 bzw. 33 zu \u00fcbergeben.</p> <ul> <li>Soll/IST-Buchung- Buchungsschl\u00fcssel 421/621</li> <li>IST-Buchung - \u00a0Buchungsschl\u00fcssel 631 </li> <li>Sachkontenbuchung Zahlweg an Ertrag - Buchungsschl\u00fcssel 231 (f\u00fcr nicht steuerbare Ertr\u00e4ge!)</li> </ul> <p>F\u00fcr SOLL/IST- \u00a0bzw. IST-Buchung ist es zwingend notwendig ein Standard-PK \u00a0im rechten Teil der Maske auszuw\u00e4hlen. Per Default ist das an der Kasse definierte Standard-PK f\u00fcr den Debitor vorgeblendet und kann durch Abtauchen \u00fcber den nebenstehenden Button ge\u00e4ndert werden.</p> <p>Wurden bei der Vorauswahl Kassenbewegungen mit und ohne Tarifzuordnung selektiert, kann nun hier eine Einnahmeart gew\u00e4hlt werden, die f\u00fcr alle ausgew\u00e4hlten Erfassungen ohne Tarif gelten soll.  Ebenso k\u00f6nnen Sie zB. Ihre Vorauswahl im Kassenjournal so treffen, dass die zur Stapelbuchung zu \u00fcbergebenden Einnahmen auf eine Eart abzielen, die Sie in der Stapelbuchungsmaske zuordnen.</p> <p>F\u00fcr Soll/IST-Stellung (421) und IST-Stellung (631) habe Sie zus\u00e4tzlich noch die Option, die Buchungen nach Einnahmeart zusammenzufassen. Dabei erhalten die zusammengefassten Buchungen eine gemeinsame OP-Nummer.</p> <p>Nachdem die zur Verbuchung notwendigen Eingaben get\u00e4tigt wurden, treffen Sie nunmehr noch Wahl, ob die AO als Liste oder Formular gedruckt werden soll (keine AO bei BS 631!). \u00a0Mit \"\u00dcbernehmen\" startet die Stapelverbuchung. Es wird Ihnen zur Information \u00fcber den Buchungstand ein Fortschrittsbalken eingeblendet. Die Verbuchung erfolgt im Hintergrund und ohne Einblendung der Einzelbuchungsmaske!</p> <p>Die Buchungen m\u00fcssen nun noch im Men\u00fc 36 best\u00e4tigt bzw. Men\u00fc 33 gebucht werden. </p> <p>Die Erfassungen im Kassenjournal erhalten die entsprechenden Status. </p> <p>Abtauchen auf OP zur Erfassung von Einnahmen und Ausgaben: </p> <p>Mit der neue lizenzpflichtigen Funktion k\u00f6nnen Sie ab R58 eine Zahlung direkt auf einen debitorischen (BS 631) oder kreditorischen (BS 731) OP erfassen. </p> <p>Dazu stehen Ihnen zwei neue Buttons zur Verf\u00fcgung, mit denen Sie aus der Barkasse in die Einzelbuchungsmaske abspringen. Durch Abtauchen k\u00f6nnen Sie sich das entsprechende Personenkonto und den offenen Posten in die Buchungsmaske laden. Der Zahlweg wird analog der Stammdaten der Kasse vorbelegt. Eine Mehrfachauswahl von offenen Posten ist ebenso m\u00f6glich. Ein Quittungs- bzw. Empfangsbest\u00e4tigungsdruck erfolgt - wenn angehakt, direkt aus der Buchungsmaske mittels Report f\u00fcr die Quittung aus der Barkasse. Nach erfolgreicher \u00dcbernahme der Buchung gelangt man automatisch in das Kassenjournal der Kasse zur\u00fcck, aus der man zur Buchung in die Einzelbuchungsmaske abgesprungen ist. Alle relevanten Daten aus der Buchung werden dabei in das Kassenjournal \u00fcbergeben. Das lfd. Brutto der Barkasse wird entsprechend des Betrages aus der IST-Stellung neu berechnet. Bei erfolgreicher \u00dcbernahme wird eine BAk-Nummer generiert, die der IST-Stellung zugeordnet und in die Journalzeile geschrieben wird. Wurde eine Mehrfachauswahl getroffen, wird f\u00fcr jeden OP eine Positionszeile im Kassenjournal geschrieben und \u00fcber eine BAK-Nummer zusammengehalten. Sobald die IST-Stellungen im Men\u00fc 33 verbucht wurden, erhalten diese Erfassungen den Status \"verbucht\" und k\u00f6nnen \u00fcber \"Stornieren\" im Bedarfsfall storniert werden, sofern sie noch nicht in einen Z-Bon eingeflossen sind. </p> <p>Quittung / Empfangsbest\u00e4tigung </p> <p>F\u00fcr Ausgaben steht nun die M\u00f6glichkeit zum Druck einer Empfangsbest\u00e4tigung zur Verf\u00fcgung. </p> <p>F\u00fcr den Quittungs- und Empfangsbest\u00e4tigungsdruck wurde neu umgesetzt, dass die Eingabe des Namens des Einzahlers bzw. Empf\u00e4ngers bereits in der Maske f\u00fcr die Erfassung der Kassenpositionen erfolgt. Das Feld ist nicht als Pflichtfeld definiert. Die Steuerung, ob der Name des Einzahlers oder Empf\u00e4ngers hinterlegt werden muss, erfolgt \u00fcber die Betragseingabe im Feld \"Einnahme\" bzw. \"Ausgabe\". Werden mehrere Positionen erfasst, ist die Eingabe des Namens nur bei der ersten Position notwendig. Die Eingabe im Feld \"Einnahme\" bzw. \"Ausgabe\" ist ebenfalls daf\u00fcr ausschlaggebend, ob beim \"Zahlung abschlie\u00dfen\" ein Quittungs- bzw. Empfangsbest\u00e4tigungsdruck gew\u00e4hlt werden kann. </p> <p>Der Name des Einzahlers / Empf\u00e4ngers wird ab diesem Release in der Spalte Einzahler/Empf\u00e4nger im Kassenjournal gespeichert. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":"<p>Allgemein Im Mandantenstamm im Reiter Buchungsstellen (A-Parameter) lassen sich ab sofort Kontenausnahmen definieren, um spezielle Buchungsvorg\u00e4nge abbilden zu k\u00f6nnen. Damit wird es m\u00f6glich, Konten welche von der Kontenart her nicht als A0 | A1 | A2 Konten definiert sind, direkt durch die Anlagenbuchhaltung zu bebuchen. Zum Beispiel kann dadurch eine kredit\u00e4hnliche Ausleihung in der Schulden-/ Darlehensverwaltung gebucht werden und parallel als Anlagegut in der Anlagenbuchhaltung gef\u00fchrt werden. </p> <p>Au\u00dferdem lassen sich Soll/ Haben vertauschte Quellkonten, f\u00fcr spezielle Vorg\u00e4nge, z.B. Durchf\u00fchrung einer investiven Ma\u00dfnahme mit Kostenbeteiligung (Einzahlung) einer dritten Kommune, durch die Anlagenbuchhaltung korrekt ansprechen. Diese Quellkonten dienen einer korrekten Haushaltsmittelabbildung.</p> <p>F\u00fcr weitere Details sowie der Einrichtung von entsprechenden Kontenausnahmen wenden Sie sich bitte an die Fachberatung.</p> <p>betrifft b11 / b21 / b121 und b221 </p> <p>Im Mandantenstamm im Reiter Buchungsstellen (A-Parameter) lassen sich ab sofort Kontenausnahmen (A0-Konten) definieren. Damit ist es m\u00f6glich, in der Rechnungszuordnung per \u201eER+\u201c, nicht investive sowie nicht AnBu \u00a0relevante Rechnungen ausblenden zu k\u00f6nnen. In der Rechnungszuordnung wird dies nach Aktivierung der Funktion als Zusatzbedingung eingeblendet, welche falls notwendig auch deaktiviert werden kann. </p> <p>b11 - Bearbeiten </p> <p>Unter dem Anlagegut im Reiter \"Bruttozuschuss\" wird nach einer Korrektur nun der korrekte %-Wert am AHK des Zuschusses ausgewiesen. Hier lag ein Berechnungsfehler vor.</p> <p>Bzgl. der Fehlermeldung \"Betrag \u00fcbersteigt den AHK\" erfolgte eine Systemanpassung. Diese Meldung trat u.U. beim L\u00f6sen eines Sonderpostens auf, wenn dem zu l\u00f6senden Inventar mehrere Sonderposten zu geordnet waren.</p> <p>b121 - Nachaktivierung </p> <p>Bei Unter-Quellkonten die an 5. Stelle verschiedene Ziffern auswiesen (0, 1,2 etc.) wurde bei einer Nachaktivierung oder Nachpassivierung f\u00e4lschlicherweise auf eine automatische Kontenfindung zur\u00fcckgegriffen und somit zum Teil falsche Konten vorgeblendet bzw. bebucht.</p> <p>b126 - Stornierung </p> <p>Es wurde ein Fehler behoben, dass bei einem bereits geswitchtem AG oder Zuschuss die Umbuchungsposition des Switches storniert werden konnte. Dabei blieb jedoch das Switch-Kennzeichen gesetzt und wurde weiterhin im Anlagennachweis ausgewiesen. Ab R58 ist eine Stornierung nicht mehr m\u00f6glich. Es erscheint eine entsprechende Fehlermeldung.</p> <p>b221 - Nachpassivierung </p> <p>Bei Unter-Quellkonten die an 5. Stelle verschiedene Ziffern auswiesen (0, 1,2 etc.) wurde bei einer Nachaktivierung oder Nachpassivierung f\u00e4lschlicherweise auf eine automatische Kontenfindung zur\u00fcckgegriffen und somit zum Teil falsche Konten vorgeblendet bzw. bebucht.</p> <p>b35 - Buchungslauf </p> <p>Bei einer Fehlermeldung werden nun wieder die korrekten Fehlertexte im Protokoll ausgewiesen. </p> <p>b67 - Anlagenspiegel </p> <p>Es wurden in der Anlagen\u00fcbersicht die Spalten Anschaffungs- und Herstellungskosten in Anschaffungs- oder Herstellungskosten sowie die Spalte \"Buchwert\" in \"Buchwerte\" in den Jahren 2017- 2020 umbenannt. Des Weiteren wurde f\u00fcr die Anlagen\u00fcbersicht in 2017 noch eine Fu\u00dfnote erg\u00e4nzt.</p> <p>b7 - Jahresabschluss </p> <p>Es wurden im Men\u00fc b721 neue Pr\u00fcfungen eingebaut, die die Konsistenz der Umbuchungs- sowie Stornobuchungen pr\u00fcfen (entsprechende Gegenpositionen vorhanden und korrekt) .</p> <p>Des Weiteren wurde eine Korrekturm\u00f6glichkeit f\u00fcr fehlende oder unvollst\u00e4ndige AfA-Stamms\u00e4tze (im HH-Jahr) geschaffen, welche vorhandene AfA-Stamms\u00e4tze aus dem Vorjahr nachzieht oder erg\u00e4nzt sowie die AfA f\u00fcr diese G\u00fcter/Zusch\u00fcsse im Anschluss direkt berechnet.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0058/programm%C3%A4nderungenrelease410058.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s12 - DMS - Konfiguration </p> <p>Es gibt im Dokumententyp \"Anordnung\" jetzt ein neue Mappingfeld \"SKONTOB\" f\u00fcr die \u00dcbergabe des Skontobetrages der Anordnung an das DMS-System.</p> <p>s21 - Benutzerverwaltung </p> <p>Ab sofort wird die Domain aus dem LDAP-Abgleich in der korrekten Notation am Nutzer (externer Nutzer) hinterlegt. Somit ist der Anmeldung an den SASKIA\u00ae.de-Server Diensten wieder vollst\u00e4ndig m\u00f6glich.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/installations_checkliste_relea.html","title":"Installations Checkliste Release 4.1.0059","text":""},{"location":"aktuelles/releasehistorie/release4.1.0059/installations_checkliste_relea.html#installations-checkliste-release-410059","title":"Installations Checkliste Release 4.1.0059","text":"<p>Vorg\u00e4ngerrelease ist Release 58</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/installations_checkliste_relea.html#update","title":"Update","text":"<p>1. Alle SASKIA \u00ae .de IFR-Nutzer abmelden </p> <p>(auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 59.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/installations_checkliste_relea.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>2. \u00a0 Releasewechsel 59 </p> <p>Nach Herunterladen und Installation des Updates kann der Releasewechsel f\u00fcr Release 59 durchgef\u00fchrt werden.  Falls aus Vorg\u00e4nger-Releases noch offene Releasepunkte angezeigt werden, sind diese vorab - beginnend mit dem kleinsten noch offenem Release - auszuf\u00fchren.  </p> <p>Durch Markieren der entsprechenden Version der verf\u00fcgbaren Datenbank in der linken Tabelle werden die Punkte des Releasewechsels wie gewohnt in der rechten Tabelle dargestellt.</p> <ul> <li>Datenbankstruktur anpassen Interne Anpassung der Struktur von Tabellen, Ansichten, Indexe u.s.w. in der Datenbank. Daten werden hierbei nicht ver\u00e4ndert.</li> <li> <p>Datenbank\u00e4nderungen Anpassung des Datenbestandes an die neue Releaseversion.</p> </li> <li> <p>Anpassung der Reportvorlagen Installation neuer Reportvorlagen und Deinstallation nicht mehr ben\u00f6tigter Reportvorlagen, Registrieren neuer Ausgabek\u00fcrzel.</p> </li> <li> <p>Convert table columns from 'System.Decimal' to 'System.Int.32' Strukturelle Anpassung der Tabellen f\u00fcr den performanten Zugriff mit dem Entity-Framework. Nur f\u00fcr SQL-Server \u2013 Datenbanken! </p> </li> <li> <p>Anpassen des Parameters Filename f\u00fcr die Avviso-Antwort-Sst wegen der Einlesereihenfolge Vermeidung von Zuordnungsproblemen beim Einlesen der Vollstreckungs-Schnittstellen ins Avviso Programm.</p> </li> <li> <p>Eintragen der loadFromRemoteSource Eigenschaft in die Service-Replikator-Config Erm\u00f6glichen des Zugriffs der Automatischen Ersetzung des Programmstandes (Replikation) der IFR-Server-Dienste auf entfernten Servern.</p> </li> <li> <p>Aktualisiert die Stammdaten f\u00fcr die Tabelle 'Kc_Ausland' Einarbeiten von \u00c4nderungen der EU-Mitgliedschaft und anderen Grundlagen des internationalen Zahlungsverkehrs in die L\u00e4nder-Stammdaten.</p> </li> <li> <p>Neue Textbausteine Zur Verf\u00fcgung stellen neuer Informationen aus der Nutzerverwaltung f\u00fcr die Verwendung im Textbausteingenerator (z.B. Dienststelle, Funktion und ZimmerNr.). </p> </li> <li> <p>Korrektur KS_CONTAINER - Teil 3 (kann unterbrochen werden) und Korrektur KS_CONTAINER - Teil 4 (kann unterbrochen werden) Wiederholung von Release IFR 4.1.0058 \u2013 Es werden fehlende Angaben in der Tabelle erg\u00e4nzt.  Die Ausf\u00fchrung dieser beiden RW-Punkte kann eine l\u00e4ngere Zeit in Anspruch nehmen und kann nachgelagert durchgef\u00fchrt werden. Dazu muss zun\u00e4chst der Haken bei \u201eAusf\u00fchren\u201c herausgenommen werden. Zur sp\u00e4teren Durchf\u00fchrung einfach den Men\u00fcpunkt Releasewechsel aufrufen, die Haken bei \u201eAusf\u00fchren\u201c f\u00fcr die beiden Punkte setzen und den Knopf \u201eAktualisierung durchf\u00fchren\u201c dr\u00fccken. Es ist nicht notwendig, dass alle Anwender aus dem IFR abgemeldet sind. </p> </li> </ul> <p>3. Aktualisierung des Schattenmandanten </p> <p>Bei der Aktualisierung des Schattenmandaten bitte alle Punkte aktualisieren, die auf \"Ausf\u00fchren\" stehen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/letzte_programmaenderungen8.html","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0059/letzte_programmaenderungen8.html#letzte-programmanderungen","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0059/letzte_programmaenderungen8.html#auslieferung-zum-26032021-version-37725","title":"Auslieferung zum 26.03.2021 - Version 37725","text":""},{"location":"aktuelles/releasehistorie/release4.1.0059/letzte_programmaenderungen8.html#351-schnittstellen","title":"351 - Schnittstellen","text":"<p>Die Paisy-Lohnschnittstelle wurde um einen Schnittstellenparameter \"eindeutige Belegnummernbildung JA/NEIN\" erweitert. Damit ist es in Bezug zu einer DMS-Anbindung m\u00f6glich, eindeutige Dokumenten-Zuordnungen vorzunehmen. Bisher wurde vom Vorsystem je Buchungssatz und Schnittstelle eine fortlaufende Belegnummer geliefert mit 000001 beginnend entsprechend der Datensatzanzahl. Der neue Parameter w\u00fcrde f\u00fcr die aus dem Vorsystem gelieferte Belegnummer als Pr\u00e4fix noch Periode und Haushaltsjahr aus dem jeweiligen Datensatz voran stellen. Der neue Parameter wird in der Standardauslieferung auf N (NEIN) stehen. Sie k\u00f6nnen den Parameter im Men\u00fc 351 \"Schnittstellen einrichten\" auf J (JA) umstellen, sofern Sie in Bezug zur DMS eine Notwendigkeit erachten. F\u00fcr R\u00fcckfragen stehen wir gerne zur Verf\u00fcgung.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/letzte_programmaenderungen8.html#b122-abgang-bearbeiten-b222-ruckzahlung","title":"b122 - Abgang bearbeiten/ b222 - R\u00fcckzahlung","text":"<p>Es wurde ein Fehler behoben, welcher bei einer Abgangsbuchung nicht gegen das in der Bewegung ausgew\u00e4hlte Produkt gebucht hat, sondern immer gegen das Produkt welches im Stammsatz des Anlagegutes/ Zuschusses hinterlegt wurde.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/letzte_programmaenderungen8.html#b724-prufung-nicht-gebuchter-werte","title":"b724 - Pr\u00fcfung nicht gebuchter Werte","text":"<p>Im Men\u00fc b724 wurde ein Fehler behoben, welcher f\u00fcr alle Anlageg\u00fcter und Zusch\u00fcsse im Bestand ungebuchte Werte angezeigt hat. Ab sofort werden die tats\u00e4chlich noch nicht gebuchten Werte wieder ausgewiesen. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/letzte_programmaenderungen8.html#schattenmandant","title":"Schattenmandant","text":"<p>F\u00fcr die Liste 91 wurde der Kontenbereich angepasst. \u00a0</p> <p>Fehler aus Schattenmandant f\u00fcr die Sachkonten korrigiert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/letzte_programmaenderungen8.html#auslieferung-zum-11032021-version-37712","title":"Auslieferung zum 11.03.2021 - Version 37712","text":""},{"location":"aktuelles/releasehistorie/release4.1.0059/letzte_programmaenderungen8.html#32-tagesabschluss","title":"32 - Tagesabschluss","text":"<p>Wenn keine Auswahl im Feld \"Zahlweg\" beim Druck des Zeitbuches zum Tagesabschluss vorgenommen wurde kam es nach Einspielung des Releases dazu, dass nicht nur die zahlungsrelevanten Buchungen angezeigt wurden. Hierzu erfolgte eine Korrektur des Programms.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/letzte_programmaenderungen8.html#352-schnittstellen-eingang","title":"352 - Schnittstellen Eingang","text":"<p>Die Standardschnittstelle V3 hat keine Daten mehr eingelesen, weil die Schnittstellendatei durch ein Zeichensatzproblem besch\u00e4digt war.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/programmaenderungen_release_11.html","title":"Programm\u00e4nderungen Release 4.1.0059","text":""},{"location":"aktuelles/releasehistorie/release4.1.0059/programmaenderungen_release_11.html#programmanderungen-release-410059","title":"Programm\u00e4nderungen Release 4.1.0059","text":""},{"location":"aktuelles/releasehistorie/release4.1.0059/programmaenderungen_release_11.html#allgemein","title":"Allgemein","text":"<p>Datenbank </p> <p>In den Bundesl\u00e4ndern Sachsen (Produkt, Sachkonto) und Sachsen-Anhalt (Produkt) sind zum 01.01.2021, gesetzliche Anpassungen vorgenommen worden. Hierzu erfolgte eine Anpassung in den bestehenden Schattenmandantenversionen.Vierteljahresstatistik Es besteht nun die M\u00f6glichkeit die Vierteljahresstatistik nach Zeitbuchnummer + Buchungsperiode oder Zeitbuchnummer + Wertstellungsdatum zu erstellen. Mit diesen zwei Optionen ist eine genauere Abgrenzung der Quartale m\u00f6glich und somit k\u00f6nnen weniger Fehler bei der \u00dcbergabe an die Statistik erm\u00f6glicht werden. bis zur Zeitbuchnummer:Die Zeitbuchnummer wird immer automatisch vorgeblendet. Bitte \u00fcberpr\u00fcfen sie diese mit Ihrem letzten Tagesabschluss. Es ist zwingend notwendig, dass diese l\u00fcckenlos eingetragen werden bei folge Quartalen. </p> <p>Buchungsperiode:Empfohlen wird die Datei nach Zeitbuchnummer + Buchungsperiode aus zu geben. Ist diese Schaltfl\u00e4che aktiv, betrachtet das Programm zus\u00e4tzlich zur Zeitbuchnummer die Buchungsperiode und ber\u00fccksichtigt somit Buchungen die im nachhinein get\u00e4tigt wurden aber trotzdem in das jeweilige Quartal geh\u00f6ren. Diese Schaltfl\u00e4che darf innerhalb eines Jahres nicht ge\u00e4ndert werden. </p> <p></p> <p>Wenn Sie die Ausgabedatei nicht erzeugen k\u00f6nnen, pr\u00fcfen Sie bitte im Men\u00fc 51 - Schnittstellen Einrichten ob Ihre Ausgabeschnittstelle \"Vierteljahresstatistik\" hei\u00dft.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/programmaenderungen_release_11.html#1-stammdaten","title":"1 - Stammdaten","text":"<p>12a3 - Personenkontenverwaltung </p> <p>Die Bearbeitung von Zusatzadressen, die nicht als Debitor angegelegt sind \u00a0( Adressnummern mit #T....) ist wieder m\u00f6glich.</p> <p>152 - Einnahmearten </p> <p>Das eintragen einer vorhandenen Einnahmeart (aus Men\u00fc 1275) in das Feld bei BuchungsEArt f\u00fchrt jetzt dazu, dass die VeranlagungsEArt nicht mehr farblich (organge) gekennzeichnet wird.</p> <p>1y1 - Textbausteine </p> <p>F\u00fcr die Verwendung und Bearbeitung der Textbausteine im Men\u00fc 1y1 wurden 4 neue ATB's integriert. ATB_B_Dienststelle ATB_B_Funktion ATB_B_Vorname_Nachname ATB_B_Zimmer_Nr</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/programmaenderungen_release_11.html#2-planung","title":"2 - Planung","text":"<p>251 - Plan\u00fcbernahme </p> <p>Wenn eine bereits vorl\u00e4ufig \u00fcbernommene Planvariante in Men\u00fc 251 ausgew\u00e4hlt wird, dann wird diese Planvariante storniert und geschlossen. Zur Verhinderung, dass dies versehentlich passiert, kommt jetzt ein Dialogfenster, wo die Stornierung mit Ja zu best\u00e4tigen ist, bzw. mit Nein abgebrochen werden kann.</p> <p>291 - Planbuchungsjournal </p> <p>Das Planbuchungsjournal Men\u00fc 291 wurde auf Telerik-Tabellenansicht umgestellt. Damit sind analog der Budget\u00fcbersicht flexible Filterung \u00a0und Gruppierungen m\u00f6glich. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/programmaenderungen_release_11.html#3-buchung","title":"3 - Buchung","text":"<p>33 - Buchungsstapel </p> <p>Der Fehler bei der Ausbuchung von \u00dcberzahlungen im Rahmen der Bagatellbetragsbereinigung wurde korrigiert.</p> <p>3a3 - Kontoauszugsverbuchung </p> <p>In der Kontoauszugsverbuchung ist eine Zuordnung/Umbuchung von PK-DIVERS auf ein konkretes Personenkonto im Vorjahr m\u00f6glich, sofern es sich auch um einern Kontoauszug aus dem Vorjahr handelt. F\u00fcr die Umbuchung mit Saldo = 0 wird ein beim Verbuchen auszuw\u00e4hlender Zahlweg &gt;=90 verwendet. Die Auswahl dieses Umbuchungszahlweges ist nur m\u00f6glich, wenn der Anwender einen Kontoauszug aus dem Vorjahr verbuchen m\u00f6chte und eine Belegdatum aus dem Vorjahr verwendet. Nur dann wird diese Umbuchung im Vorjahr erzeugt. Damit ist eine manuelle Zuordnung/Umbuchungen auf andere diverse PK\u2018s vor dem Kassenjahreswechsel nicht mehr notwendig und damit wird \u00a0eine korrekte Darstellung der OP-Listen zum JAB durch Zuordnung im Jahr der eigentlichen Zahlung sichergestellt, sofern das betreffende HH_Jahr noch nicht abgeschlossen ist. Im aktuellen Haushaltsjahr erfolgt weiterhin die Zuordnung von PK-DIVERS auf ein konkretes Personenkonto \u00fcber den Zahlweg des gebuchten Kontoauszuges als \u201eUmbuchung\u201c (minus-Divers plus-PK). DIVERS-Zuordnungen in Vorjahren m\u00fcssen zwingend auf vorhandene OP\u2018s erfolgen. Die Bildung von neuen \u201e\u00dcberzahl-OP\u2018s\u201c auf dem konkreten PK zum Zweck der Zuordnung im Vorjahr ist nicht m\u00f6glich!!! \u00a0Es muss zwingend auf einen vorhandenen OP zugeordnet werden. \u00dcberzahlungen auf einem bestehenden OP sind auch bei einer Zuordnung im Vorjahr weiterhin m\u00f6glich. </p> <p>351 - Schnittstellen Einrichten - \u201eavviso AO\u201c-Schnittstelle </p> <p>Die \u201eavviso AO\u201c-Schnittstelle wurde um die Parameter \u201eBuchungstext im Freitext wiederholen\u201c &amp; \u201eOP-Nr-Bildung\u201c erweitert.  Mit dem Parameter \u201eBuchungstext im Freitext wiederholen\u201c l\u00e4sst sich der Buchungstext 1 im Freitext wiederholen, um den vollst\u00e4ndigen Buchungstext aus avviso nachhalten zu k\u00f6nnen, zur Auswahl steht: N= BText1 niemals wiederholen (Standard) | I= BText1 immer wiederholen | A= nur wenn abgeschnitten.  Der Parameter \u201eOP-Nr-Bildung\u201c erm\u00f6glicht die Bildung einer eindeutigen OP-Nummer f\u00fcr Nebenforderungen aus avviso, damit wird das Entstehen von \u201eSammel-OPs\u201c vermieden. Die OP-Nummer kann anhand der Bildungsvorschrift im Parameter individuell definiert werden.</p> <p>352 - Eingangsschnittstelle </p> <p>DATAUS: Auch die IBAN f\u00fchrt jetzt zur Pr\u00fcfung auf das Geldw\u00e4schegesetz, wenn das L\u00e4nderkennzeichen der IBAN ein Nicht-EU-Mitglied betrifft.</p> <p>36 - Anordnung </p> <p>Die Tabellen\u00fcberschrift des Summenblattes der AO-Liste wurde angepasst.</p> <p>Der Fehler, dass die AO-\u00dcbersichtsliste nicht mehr als PDF aufbereitet und angezeigt werden konnte, wurde behoben.</p> <p>In der Weiterleitungshistorie wird nun auch die Zusatzbest\u00e4tigung aufgef\u00fchrt. Sie spiegelt 1 zu 1 die Weiterleitungshistorie aus der AO-Verwaltung wider. In der Anordnungsverwaltung wurden die Optionen bei Ausgabeform um die \"Unterschriftenliste\" erweitert. Diese Option ist nur sichtbar, wenn das Modul \"Zusatzstufen\" im Einsatz ist. Sie dient zum Nachdruck der AO-Unterschriftenliste. Weiterhin kann es z.B. auch bei einer optionalen Zusatzstufe \"Rechnungspr\u00fcfungsamt\" \u00a0verwendet werden.</p> <p>Die Dokumente von jahres\u00fcbergreifenden Belegen werden im AO-Client vollst\u00e4ndig mit angezeigt.</p> <p>392 - Sachkontenauskunft </p> <p>Im Men\u00fc k\u00f6nnen nach einer Anpassung neben den bereits 9 ge\u00f6ffneten festen Fenstern auch noch weitere dynamische Fenster ge\u00f6ffnet werden. </p> <p>394 - Budget\u00fcbersicht </p> <p>Im Men\u00fcpunkt 394 Budget\u00fcbersicht wurde die Datenaufbereitung der \u00a0Spalten \"Mittel\u00fcbertrag Vorjahr\" und \"Budgetumbuchung Vorjahr\" angepasst. Analog dem Abtauchen in die Bewirtschaftungs- bzw. Planungsbuchungen zu einer Buchungsstelle in der Budget\u00fcbersicht, kann nun auch in der Summenzeile in \u00a0Anzeige abgesprungen werden. Es werden dem Anwender auf einem Blick alle Buchungsinformationen zu den Bewirtschaftungs- und Planbuchungen angezeigt, welche in die Gesamtsumme der gefilteteren Werte einflie\u00dfen. </p> <p>Bei Erstellung eines Nachtrages mit der \u00dcbernahme der \u00dcPL/APL-Buchungen kam es beim Ausweis der investitativen Buchungsstellen (AO-Konten) in der Budget\u00fcbersicht zu einer verdopplung der Werte. Hierzu erfolgte eine Programmkorrektur, so das der Werteausweis nicht mehr doppelt ist.</p> <p>3a2 - Kontoauszugabgleich </p> <p>Beim Einlesen von Kontoauzugsdaten \u00fcber die Schnittstelle, die einen Gesch\u00e4ftsvorfall 198 \"Sammellastschrift\" enthalten, kam es zu einem Problem beim Bef\u00fcllen des Datenfeldes f\u00fcr die Sperre. Das hatte sp\u00e4ter Auswirkungen beim automatischen Kontoauszugsabgleich, da er dann diese Positionen vom Abgleich ausgeschlossen hat.</p> <p>Im manuellen Abgleich des Kontoauszuges k\u00f6nnen nun bei Positionen einer R\u00fccklastschrift, sowie bei \u00dcberzahlungspositionen die Buchungstexte manuell eingegeben werden. Wird kein Text eingetragen, dann wird das Feld wie bisher belegt.</p> <p>Im Kontauszugsabgleich im Dialog manueller Abgleich wird bei den einzelnen Posten nun auch die Kundennummer mit ausgewiesen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/programmaenderungen_release_11.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":"<p>421 - Stundungen </p> <p>Beim Druck der Stundung im Breitformat, kam es bei langen PK-Adressangaben (mit Name2/3) zu einem Darstellungsfehler der dazu f\u00fchrte das die Angaben nicht mehr zweizeilig angezeigt wurden. Hierzu erfolgte eine Anpassung des Reports.</p> <p>422 - Druckliste Stundung </p> <p>In der stichtagsbezogenen Liste der Stundungsf\u00e4lle erfolgte bisher nicht der korrekte Ausweis der Stundungsraten zum Stichtagszeitpunkt. Hierzu erfolgte eine Korrektur.</p> <p>46 - Sperren </p> <p>Im Men\u00fc Sperren wurde die Spalte \"Freitetxt\" editierbar gestaltet analog der gleichen M\u00f6glichkeit im Men\u00fc 4a OP-Anpassung. Damit w\u00e4re es m\u00f6glich z.B. den Grund der Sperre im Freitext zu hinterlegen.</p> <p>48 - Vollstreckungslauf </p> <p>Produkt als zus\u00e4tzliches Filterfeld integriert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/programmaenderungen_release_11.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":"<p>52 - Eingangsrechnungsjournal </p> <p>Im Eingangsrechnungsjournal wurden die haushaltsjahrspezifischen Zuordnungsm\u00f6glichkeiten von Auftr\u00e4gen entsprechend der buchungsbegr\u00fcndenden Periode aus Rechnungsdatum oder abweichender Leistungsperiode angepasst. Je nach Konstellation k\u00f6nnen die Auftr\u00e4ge nun im korrekten Haushaltsjahr ausgew\u00e4hlt werden. Z.B. kann ein in 2021 angelegter Auftrag \u00a0bei Rechnungsdatum &lt;=31.12.2020 aber abweichender Leistungsperiode &gt;= 01/2021 nun verwendet werden.</p> <p>54 - Ausgangsrechnungsjournal </p> <p>Es wurde die neue Vorlagenoption \"Tarifgruppe unterdr\u00fccken\" implementiert. Die Auswahl dieser Option nach Rechtsklick auf Button \"Rechnungsdruck\" bewirkt, dass der Anwender/Nutzer nur die Tarifbezeichnung je Rechnungsposition auf der Ausgangsrechnung angezeigt/abgedruckt erh\u00e4lt.</p> <p>F\u00fcr die Definition des Ablageordners der eRechnungen im Men\u00fc s14 - Reiter eRechnung sind jetzt auch die folgenden Platzhalter [user]; [mand]; [date]; [temp]; [orgdatei] m\u00f6glich. Beispiel: \\Server\\Programm[mand][date]\\eRechnung </p> <p>Text beim L\u00f6schen von Musterrechnungen im ARJ pr\u00e4zisiert.</p> <p>55 - Stammdaten Ausgangsrechnungsjournal </p> <p>Die Anzeige des Steuerkennzeichens einer Position im ARJ erfolgt im \u00dcbersichtspanel nun im zugeklappten Zustand. F\u00fcr eine \u00c4nderung des Kennzeichens, wenn das Sachkonto hinter der Einnahmeart mit beliebig definiert ist, erfolgt weiterhin im aufgeklappten \u00dcbersichtspanel f\u00fcr die Position. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/programmaenderungen_release_11.html#6-auswertung","title":"6 - Auswertung","text":"<p>6223 - Kontoauszug </p> <p>F\u00fcr den Druck des Kontoauszuges sind Korrekturen am Report vorgenommen worden. Zum einen wurde die Breite der Tabellen so angepasst, da\u00df Sie jetzt auf allen Seiten gleich breit sind. Desweiteren erfolgte der Einbau von Zwischensummen bei Kontoauzugsdrucken die l\u00e4nger als eine Seite sind.</p> <p>6224 - Kontoauszug intern </p> <p>Bei dem internen Kontoauszug \u00fcber das Men\u00fc 6224 gab es einen Fehler bei der Pr\u00fcfung des Budgetrechtes ( mehrstellige \u00a0Budgets) . Hier kam es zu dem Fehler, das trotz entsprechender Rechte im Kontoauszug das zur Buchung geh\u00f6rige Zahlwegskonto nicht mit angezeigt wurden. Dies wurde nun entsprechend korrigiert und wird nun wieder, sollten die Rechte vorhanden sein, mit angezeigt.</p> <p>623 - Summen- und Saldenliste </p> <p>In der Summen- und Saldenliste f\u00fcr Personenkonto (Men\u00fc 623) ist es nun m\u00f6glich, Nullpositionen zu unterdr\u00fccken.</p> <p>6614 - Mahnvorschlag </p> <p>F\u00fcr den Druck der Mahnbescheide gibt es nun die neue Vorlagen-Option \"RTB_5 als Block ausgeben\". Ist diese Vorlagen-Option aktiv beim Druck wird der Zahlungshinweis als Block auf einer Seite zusammengehalten.</p> <p>Im RTB_5 kann nun \u00a0f\u00fcr die Mahnbescheide mit der Variable %GESAMT% die gesamte offene Forderung ausgewiesen werden.</p> <p>Beim Druck von Mahnungen die Veranlagungsbuchungen enthalten, erfolgte nicht immer der richtige Andruck der Veranlagungs(unter-)objektdaten. Hier vor allem wenn Unterobjekte schon Historisch gesetzt sind.</p> <p>Beim Druck der Mahnung kann es in Ausnahmef\u00e4llen dazu kommen, dass er beim Seitenumbruch einen Teil eines Satzes aus einem BTB/ RTB nicht korrekt mit andruckt. Als L\u00f6sung muss im Kontextmen\u00fc des Textbausteinfeldes unter Absatz, bei \"Abstand - Nach\" die Zeichenanzahl auf Null gesetzt werden.</p> <p>Erfolgt ein Mahndruck \u00fcber mehrere Seiten wird jetzt nach jedem Seitenwechsel eine Zwischensumme der Mahnforderung und der Nebenforderungen mit angezeigt.</p> <p>672 - Umsatzsteueranmeldungen </p> <p>Der Validierungsfehler \"falsches Format f\u00fcr Zeitraum\" (R\u00fcckmeldung vom ELSTER-Portal) beim Versenden der Umsatzsteuer-Jahresmeldung wurde behoben.</p> <p>68 - Freie Auswertungen </p> <p>Die Freie Auswertung FQ9997 \"Endsaldo debitorischer Offener Posten (JAB)\" \u00a0im Men\u00fc 68 wurde um eine Spalte \"befristete NDS/EWB\" erweitert, sodass man pro Buchungsstelle einen wertberichtigten Geamt-OP-Wert in der Spalte \"Endsaldo\" zum Stichtag 31.12. eines Jahresabschlusses ermitteln kann. Weiterhin wurde eine Freie Auswertung FQ9998 \"Endsaldo debitorischer befr. NDS und EWB (JAB)\" integriert, welche pro Buchungsstelle ausschlie\u00dflich die befristeten Niederschlagungen und Einzelwertberichtigungen zum Stichtag 31.12. eines Jahresabschlusses ermittelt.</p> <p>69 - Gesetzliche Drucklisten </p> <p>Es wurde f\u00fcr Sachsen-Anhalt f\u00fcr die gesetzliche Liste Muster 09 das Layout sowie die Datenausgabe korrigiert.</p> <p>Beim Druck des zweiten Teils des Muster 21 (Position 12 bis 16) kam es bei einem Nachtrag zu fehlenden bzw. nicht korrekten Werten. Hierzu erfolgte eine Korrektur der Datenaufbereitung. </p> <p>6s - Dokumentenmappe </p> <p>Bei der Erstellung der Dokumentenmappe mit Ausweis des Ergebnis-/Teilergebnishaushalt kam es zu Problemen im Layout mit der unteren rechten Seitenzahl. Hierzu erfolgte eine Korrektur des Reports.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/programmaenderungen_release_11.html#7-jahresabschluss","title":"7 - Jahresabschluss","text":"<p>7113 - Erm\u00e4chtigungs\u00fcbertragungen </p> <p>Die \u00dcbergabe von FR-Erm\u00e4chtigungen ins n\u00e4chste Jahr, wurde so ge\u00e4ndert, dass diese jetzt erst mit Verbuchung im Buchungsstapel m\u00f6glich ist. In der Vergangenheit war es m\u00f6glich schon Mittel zu \u00fcbertragen und die Buchung im Nachgang abzuweisen. Was dann zu einer nicht korrekten Mittelverf\u00fcgbarkeit gef\u00fchrt hat.</p> <p>72 - Kassenjahreswechsel </p> <p>Der Kassenjahreswechsel wurde beim Abschlie\u00dfen von Umbuchungszahlwegen so angepasst, dass abgeschlossene Umbuchungszahlwege ab 2018 nicht mehr zum Verbuchen angeboten werden. Alle abgeschlossenen Umbuchungszahlwege vor 2018 k\u00f6nnen weiterhin bebucht werden (soweit kein endg\u00fcltiger Jahresabschluss vorliegt). Seit 2018 ist eine selektive Auswahl der Zahlwege beim Kassenjahreswechsel verbunden mit verschiedenen Hinweisen m\u00f6glich</p> <p>731 - RAP-Verwaltung </p> <p>In der RAP-Verwaltung k\u00f6nnen jetzt RAPs entsprechend der Budgeteingrenzung gebucht oder auch storniert werden.</p> <p>Nach dem Anlegen eines RAP \u00fcber dem Men\u00fcpunkt 731 und nachfolgenden \u00dcbernehmen, war dieser unter bestimmten Konstellationen \u00a0in der \u00dcbersichtsmaske nicht mehr sichtbar. Dies wurde behoben.</p> <p>Beim verbuchen von RAP-Buchungen erfolgte keine Anlage von FR-VKZ-S\u00e4tzen in der KP_VKZ wenn diese noch nicht im Folgejahr vorhanden sind. Das Problem tritt nur auf wenn es noch keine vorl\u00e4ufige Plan\u00fcbernahme im Folgejahr gibt. Dazu erfolgte eine Programmanpassung. \u00a0 </p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/programmaenderungen_release_11.html#8-veranlagung","title":"8 - Veranlagung","text":"<p>Beim 'JW-Werte \u00fcbernehmen' im Steuerobjekt werden nur die Tarifzeilen mit G\u00fcltigkeit bis Dezember des lfd. StJ f\u00fcr das neue StJ vorgeblendet.</p> <p>Wird der Filter 'ungebuchte Veranlagungen im Buchungsstapel' gesetzt, werden jetzt auch die betreffenden PK zu Gewerbesteuern angezeigt.</p> <p>Beim Eigent\u00fcmerwechsel kann jetzt gew\u00e4hlt werden, welche Bescheid-Art der Alteigent\u00fcmer bekommen soll.  Standardm\u00e4\u00dfig vorgeblendet ist ' keine \u00c4nderung', es bleibt bei der Bescheidart des Vorbescheides. Dies entspricht der bisherigen Funktionalit\u00e4t des Eigent\u00fcmerwechsels. \u00a0 F\u00fcr Anwender, welche einen abweichenden Standard an der Einnahmeart setzen m\u00f6chten, wurde diese M\u00f6glichkeit in den Stammdaten der Einnahmeart geschaffen. Auch hier wird 'keine \u00c4nderung' vorgeblendet, welches der bisherigen Arbeitsweise entspricht. \u00a0 Vom Standard abweichende Bescheidarten k\u00f6nnen individuell getroffen werden und liegen im Ermessen des Anwenders.</p> <p>Am 12. Februar 2021 wurde durch den Bundesrat dem \"Gesetz zur Verl\u00e4ngerung der Aussetzung der Insolvenzantragspflicht und des Anfechtungsschutzes f\u00fcr pandemiebedingte Stundungen sowie zur Verl\u00e4ngerung der Steuererkl\u00e4rungsfrist in beratenen F\u00e4llen und der zinsfreien Karenzzeit f\u00fcr den Veranlagungszeitraum 2019\u201c zugestimmt. F\u00fcr die Ermittlung der Gewerbesteuerzinsen des Steuerjahres 2019 wurde die Verl\u00e4ngerung der Karenzzeit programmseitig eingearbeitet. Die Verzinsung beginnt somit f\u00fcr das Steuerjahr 2019 erst am 01.10.2021. F\u00fcr alle anderen Steuerjahre gilt weiterhin: die Verzinsung von Gewerbesteuer-Nachzahlungen und -Erstattungen beginnt 15 Monate nach Ablauf des entsprechenden Haushaltsjahres.</p> <p>Wird f\u00fcr Einnahmearten mit der Option 'monatliche Sollstellung' \u00a0kein monatlicher Tarifwert sondern ein Jahres-Tarifwert vorgegeben, der nicht durch die Anzahl der Raten geteilt werden kann, wird die jeweils letzte Rate des Tarifzeitraums entsprechend angepasst.: Beispiel:1 \u00a0 \u00a0 \u00a02</p> <p>Tarifwert14,00je \u00a014,00 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 (Angabe als Jahrestarif) Monat von11 7 Monat bis12612</p> <p>Rate 11,17\u00b41,17 Rate 21,171,17 Rate 31,171,17 Rate 41,171,17 Rate 51,171,17 Rate 61,171,15 Rate 71,171,17 Rate 8 1,171,17 Rate 91,171,17 Rate 101,171,17 Rate 111,171,17 Rate 121,131,15</p> <p>Ratensumme: \u00a0 \u00a014,00 \u00a0 \u00a0 14,00</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/programmaenderungen_release_11.html#9-barkasse","title":"9 - BARKASSE","text":"<p>92 - Einnahme und Ausgabe Kasse </p> <p>Beim Druck einer Quittung bzw. eines Kassenbons aus dem Kassenjournal heraus, wird der Beleg als Zweitdruck erstellt. Das Original kann nur beim Abschluss der Zahlung in der Erfassungsmaske gedruckt werden.</p> <p>Die Felder zur Auswahl einer Tarifnummer bzw. -gruppe stehen nur noch in der Eingabemaske zur Verf\u00fcgung, wenn an der Kasse im Men\u00fc 911 Tarife zugeordnet wurden.</p> <p>In den Stammdaten einer Barkasse besteht nun die M\u00f6glichkeit Bankzahlwege festzulegen, um Ein- und Auszahlungen zwischen Kassen und Banken zu erfassen. Die Bankzahlwege werden bei der Erfassung einer Ein- oder Auszahlung im Feld \"Geldtransit\" zur Auswahl angeboten. Diese Zu- und Abg\u00e4nge werden im Kassenjournal als \"Barzahlung\" gelistet und k\u00f6nnen nur \u00fcber den Button \"Buchen\" mittels Einzelsbuchungsmaske und Buchungsschl\u00fcssel 233 im Haushalt verbucht werden. Eine versehentliche \u00dcbernahme in eine Stapelverbuchung wird aufgrund einer Plausibilit\u00e4tspr\u00fcfung verhindert. Bei der Verbuchung via BS 233 wird auf dem Transitkonto zum Zahlweg ein Schwebeposten erzeugt, der dann mit Verbuchung des Kontoauszuges mit BS \u00a0220 oder 221 aufgel\u00f6st werden muss. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/programmaenderungen_release_11.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":"<p>Allgemein </p> <p>Neue AfA-Art 99 \"Abweichendes Sammelkonto Kontenausnahme\": dient der Kontenausnahme \"Abweichendes Sammelkonto\", welche im Mandantenstamm--&gt; Reiter Buchungsstellen (A-Parameter) hinterlegt werden k\u00f6nnen, z.B. f\u00fcr Ausleihungen welche \u00fcber die Kredit/ Darlehensverwaltung gebucht werden. Die AfA-Art 99 erzeugt keine Buchungen in Richtung Finanzbuchhaltung (Aktivierung | Bewegungen | AfA) und kann auch bei Finanzanlagen hinterlegt werden (Kommunale Gruppe Kennzeichnung als \u201eF\u201c Finanzanlageverm\u00f6gen).</p> <p>b122 - Abgang Anlagegut/ b222 - Abgang Zuschuss </p> <p>Die Men\u00fcpunkte b122/ b222 wurden um die Felder Produkt und Ma\u00dfnahme erweitert. Damit ist nun m\u00f6glich die komplette Gegenbuchungsstelle individuell auszuw\u00e4hlen. Die Eingabe einer Ma\u00dfnahme ist optional und wird nicht automatisch vorbelegt, sondern muss explizit ausgew\u00e4hlt werden. Bei Neueingabe bleibt die bisherige Logik erhalten, d.h. das Sachkonto wird mit dem definierten Konto in der VR-Kontierung vorbelegt (Vorschlagscharakter) und das Produkt aus den Stammdaten des Anlagegutes/ Zuschusses \u00fcbernommen (kann ggf. ge\u00e4ndert werden!).</p> <p>Anlagenbuchhaltung b121 - Nachaktivierung / 221 - Nachpassivierung </p> <p>Die Kontenausnahme \"Soll/ Haben vertauschtes Quellkonto\" kann ab sofort auch im Men\u00fc b121/ b221 verwendet werden.</p> <p>b241 - Druck Sonderpsotenkarten </p> <p>Der Druck der Sonderpsotenkarte funktioniert wieder vollst\u00e4ndig mit allen \"Gew\u00fcnschten Informationen\". </p> <p>b661 - Nachweise </p> <p>Im Anlagennachweis erfolgte ein nicht korrekter Ausweis der AHK wenn es einen Switch des Anlagegutes und Nachaktivierungen gab. Hierzu erfolgte eine Korrektur.</p> <p>b73 - Jahresabschluss </p> <p>Es wurde ein Fehler behoben, welcher den Jahresabschluss der Anlagenbuchhaltung verhinderte, obwohl alle Pr\u00fcfl\u00e4ufe erfolgreich ohne Beanstandungen abgeschlossen wurden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0059/programmaenderungen_release_11.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s31 - Releasewechsel </p> <p>Aktualisierung/Bearbeitung der einzelnen RW-Punkte wird jetzt visuell verbessert dargestellt. H\u00e4kchen werden je Bearbeitungsfortschritt gesetzt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/information_zur_grundsteuerref.html","title":"Information zur Grundsteuerreform","text":""},{"location":"aktuelles/releasehistorie/release4.1.0060/information_zur_grundsteuerref.html#information-zur-grundsteuerreform","title":"Information zur Grundsteuerreform","text":"<p>Information zur anstehenden Grundsteuerreform *  *Mai 2021 </p> <p>Die neuen Regelungen zur Grundsteuer - entweder bundesgesetzlich oder landesgesetzlich - gelten ab 1. Januar 2025. Bis dahin gilt das bisherige Recht weiter. Der S\u00e4chsische Landtag hat in seiner Sitzung am 3. Februar 2021 den Gesetzentwurf zum \u201eS\u00e4chsischen Gesetz zur Umsetzung der Grundsteuerreform\u201c in der ge\u00e4nderten Fassung mit den Stimmen der Regierungskoalition verabschiedet. F\u00fcr die Neubewertung der Grundst\u00fccke im Zuge der Grundsteuerreform wird das Bundesmodell angewandt, jedoch durch abweichende Steuermesszahlen f\u00fcr Sachsen modifiziert.  Mit der vom Bundes- und Landesgesetzgeber vorgesehenen Automatisierung der Bewertungsverfahren und dem k\u00fcnftig elektronischen Datenaustausch wird sich die Arbeit der staatlichen und kommunalen Beh\u00f6rden ver\u00e4ndern.  Im SASKIA\u00ae.de-IFR werden zur Zeit Programmfunktionen entwickelt und getestet, mit denen die maschinelle Verarbeitung der Grundsteuermessbetr\u00e4ge realisiert wird, so dass die Erstellung der Grundsteuerbescheide ab 2025 durch die Verwaltungen zu den vorgegebenen Terminen erfolgen kann. Voraussichtlich ab dem 1. Juli 2022 werden seitens der Finanz\u00e4mter Steuererkl\u00e4rungen der Steuerpflichtigen f\u00fcr die erste Hauptfeststellung nach neuem Recht entgegengenommen, die mit Ausnahme von H\u00e4rtef\u00e4llen in allen Bundesl\u00e4ndern elektronisch \u00fcber das Portal ELSTER abzugeben sind.  Diese Arbeit k\u00f6nnen die St\u00e4dte und Gemeinden unterst\u00fctzen, indem sie auf den periodischen Grundsteuerbescheiden das f\u00fcr die Grundsteuer ma\u00dfgebliche Einheitswert-Aktenzeichen (EWAZ) des Finanzamts ausweisen und als solches kenntlich machen. Der Ausweis der EWAZ erfolgt auf den SASKIA\u00ae.de-IFR-Bescheiden standardm\u00e4\u00dfig als \u201aAktenzeichen-Finanzamt\u2018. Zu den M\u00f6glichkeiten der Hervorhebung verweisen wir auf die SASKIA\u00ae.de-IFR-Release-Beschreibung zum Release 4.1.0060, welches im Juni 2021 ausgeliefert wird.</p> <p>F\u00fcr die Erstellung der Grundsteuerbescheide ab Steuerjahr 2025 ist es zwingend notwendig, dass in allen nicht historischen Grundsteuerobjekten das korrekte und vollst\u00e4ndige Finanzamts-Aktenzeichen (EWAZ) im IFR eingepflegt wurde.</p> <p>Aufgrund der zum Teil bereits seit der \u00dcbernahme des bundesdeutschen Rechts unver\u00e4nderten Grundsteuer-Einheitswerte und diverser Finanzamtsfusionen kann von Seiten der kommunalen Verwaltungen unter Umst\u00e4nden nicht garantiert werden, dass bei allen Grundsteuerobjekten das korrekte und vollst\u00e4ndige Finanzamts-Aktenzeichen (EWAZ) im SASKIA\u00ae.de-IFR hinterlegt ist. Dies aufzukl\u00e4ren und bei Bedarf zu bereinigen ist eine Aufgabe, die bereits im Vorfeld der auf Basis der EWAZ erfolgenden elektronischen \u00dcberlieferung der neuen Grundsteuermessbetr\u00e4ge erfolgen kann und sollte.  Nur so kann im SASKIA\u00ae.de-IFR der Aufwand bei der Grundsteuerfestsetzung ab 2025 gemindert werden. \u2003 Zur Unterst\u00fctzung der SASKIA\u00ae.de-IFR-Anwender bei den Vorbereitungsarbeiten zur Umsetzung der Grundsteuerreform wurde von Seiten SASKIA\u00ae eine Auswertung entwickelt, welche die aktuell im SASKIA\u00ae.de-IFR enthaltenen aktiven Finanzamts-Aktenzeichen (EWAZ) der Grundsteuer B auf die korrekte Struktur pr\u00fcft und fehlerhafte oder unvollst\u00e4ndige Aktenzeichen ausweist</p> <p>Es ist zwingend notwendig, dass f\u00fcr die Grundsteuerbescheide des Steuerjahres 2025 in allen Grundsteuerobjekten das korrekte EWAZ im SASKIA\u00ae.de-IFR eingepflegt ist. Bitte beachten Sie in diesem Zusammenhang, dass daf\u00fcr - abh\u00e4ngig von den n\u00f6tigen \u00c4nderungen- im Vorfeld gegebenenfalls ein umfangreicher Zeit- und Pflegeaufwand einzuplanen ist. </p> <p>Bitte nutzen Sie f\u00fcr die Datenpflege die verbleibende Zeit.  Wenden Sie sich f\u00fcr die terminliche Planung der Installation der Auswertungen und Einweisung, sowie entstehende Fragen an die \u00a0SASKIA\u00ae-Hotline., zu H\u00e4nden SASKIA\u00ae.de-IFR-Veranlagung.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/installations_checkliste_relea_2.html","title":"Installations Checkliste Release 4.1.0060","text":""},{"location":"aktuelles/releasehistorie/release4.1.0060/installations_checkliste_relea_2.html#installations-checkliste-release-410060","title":"Installations Checkliste Release 4.1.0060","text":"<p>Vorg\u00e4ngerrelease ist Release 59</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/installations_checkliste_relea_2.html#update","title":"Update","text":"<p>1. Alle SASKIA \u00ae .de IFR-Nutzer abmelden </p> <p>(auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 60.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/installations_checkliste_relea_2.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>2. \u00a0 Releasewechsel 60 </p> <p>Nach Herunterladen und Installation des Updates kann der Releasewechsel f\u00fcr Release 60 durchgef\u00fchrt werden.  Falls aus Vorg\u00e4nger-Releases noch offene Releasepunkte angezeigt werden, sind diese vorab - beginnend mit dem kleinsten noch offenen Release - auszuf\u00fchren. </p> <p>Die Checksummen der Releasewechselpunkte wurden neu berechnet. Daher kann es vorkommen, dass das Release 59 nochmals aktiviert ist und Punkte als nicht abgeschlossen gelten. Diese k\u00f6nnen ohne Bedenken neu ausgef\u00fchrt werden. </p> <p>Durch Markieren der entsprechenden Version der verf\u00fcgbaren Datenbank in der linken Tabelle werden die Punkte des Releasewechsels wie gewohnt in der rechten Tabelle dargestellt.</p> <ul> <li> <p>Datenbankstruktur anpassen Interne Anpassung der Struktur von Tabellen, Ansichten, Indexe u.s.w. in der Datenbank. Daten werden hierbei nicht ver\u00e4ndert.</p> </li> <li> <p>Datenbank\u00e4nderungen Anpassung des Datenbestandes an die neue Releaseversion.</p> </li> <li> <p>Anpassung der Reportvorlagen Installation neuer Reportvorlagen und Deinstallation nicht mehr ben\u00f6tigter Reportvorlagen, Registrieren neuer Ausgabek\u00fcrzel.</p> </li> <li> <p>Convert table columns from 'System.Decimal' to 'System.Int.32' Strukturelle Anpassung der Tabellen f\u00fcr den performanten Zugriff mit dem Entity-Framework. Nur f\u00fcr SQL-Server \u2013 Datenbanken! </p> </li> <li> <p>Sicherheitseinbehalt - neue Felder KZ_STATUS und GUID Die Tabellen des Sicherheitseinbehaltes werden um neue notwendige Felder erg\u00e4nzt. Vorhandene Daten werden analysiert, um die neuen Felder mit korrekten Daten zu bef\u00fcllen.</p> </li> <li> <p>Erweiterung von Anbu-Sachkonten-Views Um die Kontenausnahme \u201eAbweichendes Sammelkonto\u201c in der AnBu anbieten zu k\u00f6nnen, muss die Datenbank-Ansicht erweitert werden.</p> </li> <li> <p>Anpassung des Status der DTA-GWST und DTA-GRDS Die Status-Angaben wurden konsolidiert. Die \u00c4nderungen m\u00fcssen in die Bestandsdaten \u00fcbertragen werden.</p> </li> <li> <p>Erg\u00e4nzt die Konfigurationsdaten f\u00fcr das DMS \"VIS\" in den Schattenmandant Unterst\u00fctzung f\u00fcr VIS 6 wird erg\u00e4nzt.</p> </li> <li> <p>Test-Migration Rechnungsabgrenzungsposten F\u00fcr zuk\u00fcnftige Anpassungen in der RAP-Verwaltung wird eine Testmigration in separate Tabellen durchgef\u00fchrt. Diese Daten werden bei Bedarf von der SASKIA-Fachberatung analysiert.</p> </li> <li> <p>Erg\u00e4nzt Stammdaten f\u00fcr die TSE-Anbindung Erg\u00e4nzung notwendiger Stammdaten f\u00fcr die in die Barkasse integrierte TSE. (TSE = Technische Sicherheitseinrichtung)</p> </li> <li> <p>Erg\u00e4nzt Nutzerrechte Das neue Nutzerrecht ERJ-EMail-Benachrichtigung wird erg\u00e4nzt.</p> </li> <li> <p>Korrektur KS-CONTAINER - Teil 3 (kann unterbrochen werden) Ein Punkt aus dem Vorg\u00e4nger-Release wird zur erneuten Ausf\u00fchrung angeboten, da nicht sichergestellt werden konnte, dass dieser Punkt in der Vergangenheit korrekt ausgef\u00fchrt wurde. Wenn der Punkt  im Vorg\u00e4nger korrekt ausgef\u00fchrt wurde, wird keine Aktion mehr ausgef\u00fchrt. (Erg\u00e4nzung des Mandanten in der Tabelle ks_container)</p> </li> <li> <p>Korrektur KS-CONTAINER - Teil 4 (kann unterbrochen werden) Ein Punkt aus dem Vorg\u00e4nger-Release wird zur erneuten Ausf\u00fchrung angeboten, da nicht sichergestellt werden konnte, dass dieser Punkt in der Vergangenheit korrekt ausgef\u00fchrt wurde. Wenn der Punkt </p> </li> </ul> <p>im Vorg\u00e4nger korrekt ausgef\u00fchrt wurde, wird keine Aktion mehr ausgef\u00fchrt. (Erg\u00e4nzung des Mandanten in der Tabelle ks_container)</p> <p>3. Aktualisierung des Schattenmandanten </p> <p>Bei der Aktualisierung des Schattenmandaten bitte alle Punkte aktualisieren, die auf \"Ausf\u00fchren\" stehen. </p> <p>\u00c4nderungen an HH-Satzung: Zeilenumbr\u00fcche f\u00fcr die Haushaltssatzung werden nun wieder richtig gesetzt, wenn das gesetzliche Muster mit einem Doppelhaushalt gedruckt wird.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/letzte_programmaenderungen8_2.html","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0060/letzte_programmaenderungen8_2.html#letzte-programmanderungen","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0060/letzte_programmaenderungen8_2.html#auslieferung-zum-29062021-version-38065","title":"Auslieferung zum 29.06.2021 - Version 38065","text":""},{"location":"aktuelles/releasehistorie/release4.1.0060/letzte_programmaenderungen8_2.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>2. \u00a0 Releasewechsel 60 </p> <p>Nach Herunterladen und Installation des Updates kann der Releasewechsel f\u00fcr Release 60 durchgef\u00fchrt werden.  Falls aus Vorg\u00e4nger-Releases noch offene Releasepunkte angezeigt werden, sind diese vorab - beginnend mit dem kleinsten noch offenem Release - auszuf\u00fchren. </p> <p>Alle RW-Punkte, welche auf \"ausf\u00fchren\" stehen durchf\u00fchrenNeuer Releasewechselpunkt:  * \u201eRecherche nach nicht umgesetzten Anlageg\u00fctern, die hinter dem Abg. Anbu-Jahr festsitzen.\u201c Pr\u00fcfung auf nicht \u00fcbertragene AfA-Stamms\u00e4tze, welche im Rahmen des Jahresabschlusses Anlagenbuchhaltung nicht ins Folgejahr \u00fcbertragen wurden. Wird Ihnen nach Ausf\u00fchrung des RW-Punktes die Meldung: \u201eBitte senden Sie dieses Protokoll an den Support des Verfahrensanbieters wegen einer anstehenden Bereinigung.\u201c angezeigt wird, wenden Sie sich bitte an die SASKIA\u00ae.de-IFR Fachberatung zur Fehlerbehebung (weitere Details siehe unten Anlagenbuchhaltung). ### DMS Mit Release 60 k\u00f6nnen keine Anordnungs-Listen mehr an das DMS \u00fcbergeben werden, solange der neue Dokumententyp IfrAnordnungListe nicht in der Systemverwaltung und im DMS eingerichtet ist.  F\u00fcr die DMS-\u00dcbergabe von Anordnungen wurde speziell f\u00fcr Anordnungslisten ein eigener Dokumententyp IfrAnordnungListe entwickelt. Bisher wurden AO-Listen mit dem Dokumententyp IfrAnordnung (Formular) an ein angeschlossenes DMS \u00fcbergeben, was zur Folge hatte, dass eine einzelne AO-Liste u.U. mehrfach an das DMS \u00fcbergeben wurde; immer entsprechend der Anzahl der Ursprungsbelege. Die bisherige DMS-AO-Ablage-Philosophie bestand darin, eine Anordnung m\u00f6glichst immer gemeinsam mit dem Ursprungsbeleg im DMS in einem gemeinsamen Ordner abzulegen. Insbesondere bei Veranlagungsbescheiden wurden hier ggf. unn\u00f6tig viele AO-Listen an das jeweilige DMS \u00fcbergeben. Der neue Dokumententyp erm\u00f6glicht nun unabh\u00e4ngig von den AO-Listen-Ursprungsbelegen eine einmalige \u00dcbergabe einer AO-Liste und eine gezielte einmalige Ablage im DMS. In den IFR-seitigen DMS-Auskunftsfunktionalit\u00e4ten wird f\u00fcr jeden Buchungsvorgang ein Anzeigen der jeweiligen AO-Liste gew\u00e4hrleistet. Die Konfiguration des neuen Dokumententyps bedarf eines gewissen Einrichtungsaufwandes von ca.1 Stunde seitens der IFR-Fachberatung. Wir bitten DMS-Anwender, welche neben AO-Formularen explizit auch AO-Listen verwenden, sich mit der IFR-Fachberatung zwecks Abstimmung eines Umsetzungstermins nach Einspielung des Releases in Verbindung zu setzen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/letzte_programmaenderungen8_2.html#anordnungen","title":"Anordnungen","text":"<p>36 - Anordnungen Bei der Ansicht von Dokumenten aus dem DMS kam es \u00fcber die Lupe und im Anordnungsclient zu Fehlermeldungen bzw. fehlender Anzeige. Hierf\u00fcr gab es von Telerik ein Update. Wir haben diese neue Telerik-Version in das IFR implementiert und damit k\u00f6nnen jetzt auch wieder alte PDF-Versionen mit angezeigt werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/letzte_programmaenderungen8_2.html#jahresstatistik","title":"Jahresstatistik","text":"<p>Mit dem neuen Update liefern wir nun die unzul\u00e4ssigen Kombinationen f\u00fcr die Jahresstatistik 2020 aus. Es ist nun m\u00f6glich die Jahresstatistik ordnungsgem\u00e4\u00df an die Statistik zu \u00fcbermitteln. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/letzte_programmaenderungen8_2.html#anlagenbuchhaltung","title":"Anlagenbuchhaltung","text":"<p>b611 - Anlagennachweis Es wurde ein Fehler behoben, welcher bei den \u201edavon Summenzeilen\u201c im Anlagennachweis die Beschriftung des entsprechen Buchungsvorganges z.B. (N)achaktivierung, (U)mbuchung. usw., nicht mehr angezeigt hat. b73 - Jahresabschluss/ b74 - Werte\u00fcbertrag Es wurde ein Fehler behoben, welcher den \u00dcbertrag der AfA-Stamms\u00e4tze ins n\u00e4chste AnBu-Jahr verhinderte. Dies wurde vom Programm her nicht signalisiert. Daher ist dieses Update unbedingt einzuspielen, sonst kann im n\u00e4chsten AnBu-Jahr nicht ohne Folgefehler weitergearbeitet werden. Anhand des Releasewechselpunktes: \u201eRecherche nach nicht umgesetzten Anlageg\u00fctern, die hinter dem Abg. Anbu-Jahr festsitzen.\u201c, wird dem Anwender aufgezeigt, ob ein Eingriff durch die SASKIA\u00ae.de-IFR Fachberatung notwendig wird (siehe oben Releasewechselpunkt). </p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/letzte_programmaenderungen8_2.html#auslieferung-zum-11062021-version-38042","title":"Auslieferung zum 11.06.2021 - Version 38042","text":""},{"location":"aktuelles/releasehistorie/release4.1.0060/letzte_programmaenderungen8_2.html#allgemein","title":"Allgemein","text":"<p>Unter bestimmten Konstellationen wurden nach dem Update die IFR-Dienste (SASKIA.de-Server) nicht mehr gestartet. Dies konnte behoben werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/letzte_programmaenderungen8_2.html#buchung","title":"Buchung","text":"<p>33 - \u00a0BuchungsstapelBeim Verbuchen von Rechnungen im Eingangsrechnungsjournal mit Mehrfachauswahl wurden nicht die jeweilig angegebenen Weiterleitungsnutzer, sondern der jeweils erste oder letzte Nutzer f\u00fcr alle verbuchten ER ausgewiesen. Dieser Fehler wurde behoben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/letzte_programmaenderungen8_2.html#auswertungen","title":"Auswertungen","text":"<p>69 - Gesetzliche Drucklisten </p> <p>Gilt f\u00fcr Sachsen-Anhalt: Das Muster 21 - \"\u00dcbersicht \u00fcber die zu \u00fcbertragenden Erm\u00e4chtigungen f\u00fcr Aufwendungen und Auszahlungen\" kann jetzt sowohl \u00fcber Men\u00fc 7113 als auch \u00fcber Men\u00fc 69 gedruckt werden. Um das Muster \u00fcber das Men\u00fc 69 drucken zu k\u00f6nnen muss dieses Muster entsprechend eingebunden werden.</p> <p>Aufgrund von Updates der Softwarekomponente Stimulsoft (Fremdhersteller), die zur Erstellung der Drucklisten im IFR ben\u00f6tigt wird, kam es in einigen Drucklisten zu einer \u00dcberlappung von Sachkontonummer und Bezeichnung. Um die Lesbarkeit weiterhin gew\u00e4hren zu k\u00f6nnen, wird nun das Sachkonto auf einer separaten Zeile in H\u00f6he der gebuchten bzw. geplanten Werte dargestellt. Die Bezeichnung des Sachkontos erfolgt leicht einger\u00fcckt darunter.  Folgende Drucklisten wurden bis jetzt angepasst: Planlisten / Nachtragslisten: Ergebnishaushalt, Finanzhaushalt, Teilergebnishaushalt, Entwicklung Basiskapital HH-Rechnung: Teilfinanzrechnung B KLR: BAB</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/letzte_programmaenderungen8_2.html#anlagenbuchhaltung_1","title":"Anlagenbuchhaltung","text":"<p>\u00c4nderungsanzeige - \u00fcber Men\u00fc 011 - Aufgabenverwaltung  Es wurde ein Fehler behoben, welcher die Bezeichnung des Produktes aus der \u00c4nderungsanzeige (ARCHIKART), in das numerische Feld \u201eProdukt\u201c \u00fcbernommen hat. Dadurch war die \u00dcbernahme einer Nachaktivierung oder eines Abganges, ohne das Produkt h\u00e4ndisch zu korrigieren, nicht m\u00f6glich.</p> <p>b35 - Buchungslauf  Ein Darstellungsfehler in der \"Buchungsliste AfA\" wurde behoben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/letzte_programmaenderungen8_2.html#_1","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0060/programmaenderungen_release_11_2.html","title":"Programm\u00e4nderungen Release 4.1.0060","text":""},{"location":"aktuelles/releasehistorie/release4.1.0060/programmaenderungen_release_11_2.html#programmanderungen-release-410060","title":"Programm\u00e4nderungen Release 4.1.0060","text":""},{"location":"aktuelles/releasehistorie/release4.1.0060/programmaenderungen_release_11_2.html#allgemein","title":"Allgemein","text":"<p>Die Telerik-Komponenten wurden auf Version 2021.1 aktualisiert.</p> <p>Die Stimulsoft-Reports wurden auf Version 2020.5.2 aktualisiert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/programmaenderungen_release_11_2.html#1-stammdaten","title":"1 - Stammdaten","text":"<p>11 - Mandant </p> <p>Der Schalter K36 - SEPA-Umstellung von BLZ+KtoNr nach BIC+IBAN wurde ausgebaut, da er nach den aktuellen Anforderungen keine Relevanz mehr hat. </p> <p>123 - Listenpositionsverwaltung </p> <p>Gilt f\u00fcr Sachsen-Anhalt: Im Rahmen des aktuellen Release wurde das \u00a0Muster 22 - \"\u00dcbersicht \u00fcber die zu \u00fcbertragenden Verpflichtungserm\u00e4chtigungen\" umgesetzt. Diese kann sowohl mit Kontennachweis als auch ohne Kontennachweis gedruckt werden. </p> <p>1272 - Zahlwege </p> <p>Ab diesem Release ist es m\u00f6glich, max. 4-stellige Zahlwege anzulegen. Die Zahlwege 90 bis 99 sind aber weiterhin f\u00fcr interne Buchungen reserviert.</p> <p>12a3 - Personenkontenverwaltung </p> <p>Im Men\u00fc 12a3 Personenkontenverwaltung k\u00f6nnen an den jeweiligen hinterlegten Mandaten \u00fcber eine neu integrierte DMS-Funktionalit\u00e4t Zusatzdokumente angef\u00fcgt werden. Es steht ein neuer DMS-Dokumententyp IfrLastschriftmandat zur Verf\u00fcgung. Die Parametrisierung dieses neuen Dokumententypes erfordert einen Einrichtungsaufwand von ca. 1 Stunde. Die IFR-Fachberatung steht Ihnen gerne zur Verf\u00fcgung. </p> <p>12a9 - Mandate l\u00f6schen </p> <p>Beim L\u00f6schen von Mandaten mit abgelaufener Mandatsg\u00fcltigkeit wird jetzt gepr\u00fcft, ob es f\u00fcr das PK schon eine bestehende Bankverbindung mit dieser IBAN gibt, um sicherzustellen, dass z.B. zuk\u00fcnftige Gutschriftenl\u00e4ufe weiterhin durchgef\u00fchrt werden k\u00f6nnen. Sollte das nicht der Fall sein, wird mittels einer Abfrage entschieden, ob eine Bankverbindung aus der IBAN angelegt werden soll oder nicht.</p> <p>152 - Einnahmearten </p> <p>Neue Option im Reiter Objekt: Im Reiter \"Objekt\" k\u00f6nnen objektbeschreibende Felder, die auf den Bescheiden ausgewiesen werden, durch ''Hervorhebung im Bescheid' markiert werden. Diese Angaben werden dann auf den Bescheiden fett gedruckt.  Diese Option sollte im Rahmen der anstehenden Grundsteuerreform f\u00fcr die Hervorhebung der Angabe 'Aktenzeichen Finanzamt' genutzt werden.</p> <p>Neue Filterm\u00f6glichkeiten im Reiter Tarife:  Im Filter Tarifnummer k\u00f6nnen die zu selektierenden Tarifnummern eingetragen werden. Der zus\u00e4tzlich angebotene Textfilter wirkt auf Bezeichnung1, Bezeichnung2 \u00a0oder Tarifname. \u00a0</p> <p>1y1 - Textbausteinverwaltung </p> <p>Soll in einem BTB bzw. RTB die Umwandlung einer Homepageadresse in einen Hyperlink verhindert werden, ist die Homepageadresse folgenderweise zu hinterlegen. z.B.: \"Das ist eine Homepage www\u00ad-.\u00ad-stadt-\u00ad.-\u00adde\". Dabei sind die Striche durch das Sonderzeichen \u00a0Alt+0173 (bedingter Trennstrich) auszuf\u00fchren.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/programmaenderungen_release_11_2.html#2-planung","title":"2 - Planung","text":"<p>25 - Planentwurf\u00fcbernahme </p> <p>In den Men\u00fcpunkten wurden die Plausibilit\u00e4tspr\u00fcfungen erweitert. Neben der bisherigen Budgetzuordnungspr\u00fcfung f\u00fcr geplante Buchungsstellen werden zuk\u00fcnftig die Finanzrechnungskonten auf eine stammdatenseitige Verbindung zu einem f\u00fchrenden Sachkonto gepr\u00fcft. Ein Finanzrechnungskonto (Kontoart F1 und F2 au\u00dfer Kontenklasse 8) muss entsprechend der SASKIA\u00ae.de-IFR Buchungsphilosophie zwingend mit einem Ergebnisrechnungs- oder Bilanzkonto verkn\u00fcpft sein. Ohne diese Verkn\u00fcpfung sind keine Verf\u00fcgbarkeitspr\u00fcfungen bei der Buchung m\u00f6glich. Insbesondere die letztj\u00e4hrige Verf\u00fcgbarkeitsumstellung bei den Quellkonten erfordert eine stammdatenseitige Sachkontenverkn\u00fcpfung.  Vor einer Planentwurfs\u00fcbernahme sollte fr\u00fchzeitig im Men\u00fcpunkt 7331 Reiter \"Budget-Zuord.\" gepr\u00fcft werden, ob solche Konstellationen vorhanden sind und entsprechend manuelle Korrekturen vorgenommen werden. Es ist keine Autokorrektur f\u00fcr diesen Sachverhalt integriert. Die Pr\u00fcfung wirkt ausschlie\u00dflich auf \"planbare Buchungsstellen\", welche im Men\u00fc 22 Reiter \"Buchungsstellen\" als Buchungsstellenkombination definiert sind. Das Entfernen des Hakens w\u00fcrde die Pr\u00fcfung positiv auswerten. Notwendige Pr\u00fcfparameter im Men\u00fc 7331 sind \"Planvariante\", \"Fehler\" und \"Plan\". \u00a0 \u00a0</p> <p></p> <p>294 - Mittelanforderung </p> <p>Die Mittelanforderungsliste kann nun wieder in Tabellenform ausgegeben werden. </p> <p>29a - \u00dcbersicht voraussichtlich f\u00e4llige Auszahlungen aus VE (auch unter Men\u00fc 69) </p> <p>Gilt f\u00fcr Sachsen-Anhalt: Das Muster 09 weist nun zu jeder Ma\u00dfnahme das dazugeh\u00f6rige Produkt aus. Au\u00dferdem kann die Druckliste wahlweise mit Kontennachweis gedruckt werden. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/programmaenderungen_release_11_2.html#3-buchung","title":"3 - Buchung","text":"<p>311 - Einzelbuchung </p> <p>Ein bei der Buchung hinterlegter Weiterleitungsvermerk wird im Men\u00fc 36 Anordnung in der dortigen Weiterleitungshistorie protokolliert.</p> <p>Bei der Verwendung der Buchungsschl\u00fcssel 231 (Zahlweg im Soll) und 331 (Zahlweg im Haben) k\u00f6nnen nun auch Buchungen mit Steuerkennzeichen erfasst werden. Damit ist es m\u00f6glich, direkte Buchungen gegen Ergebniskonten durchzuf\u00fchren. </p> <p>Bei Buchungen mit Buchungsschl\u00fcssel 240 und einer Budgetumbuchung kam es zu einem nicht korrekten Buchungsverhalten. Es erfolgte noch eine zus\u00e4tzliche FR-Buchung zur Budgetumbuchung. Hierzu erfolgte eine Programmkorrektur.</p> <p>Am neuen Buchungsmaskenlayout sind Anpassungen hinsichtlich der Funktionalit\u00e4t des FR-Kontos, des Auswahlbutton f\u00fcr die Einnahmeart und der Unver\u00e4nderbarkeit von Feldinhalten nach Auswahl eines bestehenden OP's umgesetzt worden.</p> <p>314 - STORNO-Buchungen </p> <p>Im Men\u00fc 314 Stornobuchungen d\u00fcrfen keine Buchungen aus dem Ausgangsrechnungsjournal storniert werden. Die bisherige Pr\u00fcfung wurde erweitert. Zu stornierende Ausgangsrechnungen/Kostenbescheide sind bei Bedarf zwingend direkt im Men\u00fc 54 Ausgangsrechnungsjournal zu stornieren, da es sich hier um ein Nebenbuchwerk handelt.</p> <p>Bei Buchungen mit Buchungsschl\u00fcssel 240 und einer Budgetumbuchung kam es zu einem nicht korrekten Buchungsverhalten. Es erfolgte noch eine zus\u00e4tzliche FR-Buchung zur Budgetumbuchung. Hierzu erfolgte eine Programmkorrektur.</p> <p>3522 - Eingangsschnittstellen verarbeiten </p> <p>Die Plausibilit\u00e4tspr\u00fcfungen f\u00fcr die IFR-Standardeingangsschnittstellen wurden in allen Versionen erweitert. Wenn Schnittstellendatens\u00e4tze eine Buchung in ein abgeschlossenes Haushaltsjahr erzeugen w\u00fcrden, wird dies jetzt als fehlerhafter Datensatz rot markiert. Bisher erfolgte die Haushaltsjahrpr\u00fcfung erst beim Verbuchen des Buchungsstapels.</p> <p>353 - Ausgangsschnittstellen </p> <p>Bei bestimmten Konstellationen gab es in der Ausgabeschnittstelle (S_AUSGANG.STF) Zeilenumbr\u00fcche im Buchungstext2 und Freitext. Diese wurden nun entfernt, sodass Datens\u00e4tze nicht mehr \"auseinander gerissen\" werden.</p> <p>36 - Anordnungsdruck </p> <p>Das Hinzuf\u00fcgen von Zusatzdokumenten an eine erzeugte Anordnungsliste wurde angepasst. Es ist eine einzelne Zuordnung je Belegnummer m\u00f6glich. Dieses Zuordnungs-Verhalten entspricht vom Grundsatz her allen anderen Zuordnungsm\u00f6glichkeiten an anderen IFR.Dokumententypen. Es besteht eine 1:1 Beziehung zwischen eindeutiger Belegnummer und dem angef\u00fcgten Zusatzdokument.</p> <p>Bei der \u00dcbergabe der AO-Unterschriftenliste sowie des Bezahlkennzeichens an das DMS VIS kam es zu Problemen. Hierzu erfolgten auf beiden Seiten (IFR / VIS) Anpassungen.</p> <p>F\u00fcr die DMS-\u00dcbergabe von Anordnungen wurde speziell f\u00fcr Anordnungslisten ein eigener Dokumententyp IfrAnordnungListe entwickelt. Bisher wurden AO-Listen mit dem Dokumententyp IfrAnordnung (Formular) an ein angeschlossenes DMS \u00fcbergeben, was zur Folge hatte, dass eine einzelne AO-Liste u.U. mehrfach an das DMS \u00fcbergeben wurde; immer entsprechend der Anzahl der Ursprungsbelege. Die bisherige DMS-AO-Ablage-Philosophie bestand darin, eine Anordnung m\u00f6glichst immer gemeinsam mit dem Ursprungsbeleg im DMS in einem gemeinsamen Ordner abzulegen. Insbesondere bei Veranlagungsbescheiden wurden hier ggf. unn\u00f6tig viele AO-Listen an das jeweilige DMS \u00fcbergeben. Der neue Dokumententyp erm\u00f6glicht nun unabh\u00e4ngig von den AO-Listen-Ursprungsbelegen eine einmalige \u00dcbergabe einer AO-Liste und eine gezielte einmalige Ablage im DMS. In den IFR-seitigen DMS-Auskunftsfunktionalit\u00e4ten wird f\u00fcr jeden Buchungsvorgang ein Anzeigen der jeweiligen AO-Liste gew\u00e4hrleistet. Die Konfiguration des neuen Dokumententyps bedarf eines gewissen Einrichtungsaufwandes von ca.1 Stunde seitens der IFR-Fachberatung. DMS-Anwender, welche neben AO-Formularen explizit auch AO-Listen verwenden, k\u00f6nnen sich gerne mit der IFR-Fachberatung zwecks Abstimmung eines Umsetzungstermins in Verbindung setzen. \u00a0</p> <p>In der Anordnungsverwaltung Men\u00fc 36 k\u00f6nnen Freie Anordnungen (Schalter F39) zu beliebigen Zeitpunkten als Anordnungsliste an ein angeschlossenes DMS \u00fcbergeben werden. Bei Buchungen auf eine FreieAnordnung wird kein AO-Formular mehr erzeugt. Sofern eine Freie Anordnung f\u00fcr Nebenforderungen definiert worden sind, die in einem Mahnlauf verwendet werden, so wird hier auch kein Anordnungsdokument erzeugt.</p> <p>392 - Produkt/-Sachkontenauskunft </p> <p>Es wurden die Verf\u00fcgbarkeitsdetails hinsichtlich der Darstellung \"davon in Anspruch genommen\" und \"davon Budgetumbuchungen\" f\u00fcr Mittel aus Vorjahren angepasst.</p> <p>Es werden im Reiter Plantexte in der Sachkontenauskunft nun alle Plantexttypen (Drucken, Druckengesamt, Info) angezeigt. </p> <p>394 - Budget\u00fcbersicht </p> <p>Es wurde die Datenaufbereitung der \u00a0Spalten \"Mittel\u00fcbertrag Vorjahr\" und \"Budgetumbuchung Vorjahr\" angepasst. Weiterhin wurde im Kontextmen\u00fc ein neuer Punkt \"Verf\u00fcgbarkeitsdetails\" integriert. Bei Auswahl von mind. einer Datenzeile kann mit der rechten Maustaste dieser neue Punkt \"Verf\u00fcgbarkeitsdetails\" aufgerufen werden. Eine Mehrfachauswahl von Buchungsstellen zu nachfolgenden Vergleichszwecken ist m\u00f6glich. Dazu m\u00fcssen diese ebenfalls markiert werden. Die dargestellten Angaben in den Verf\u00fcgbarkeitsdetails beinhalten im Wesentlichen die Angaben aus der bisher bekannten Darstellung in der Sachkontenauskunft Men\u00fc 392 Reiter Verf\u00fcgbarkeitsdetails. Die Angaben wurden etwas umstrukturiert; insbesondere zur besseren Unterscheidung zwischen Mitteln des auszuwertenden Haushaltsjahres und Mitteln aus Vorjahren. Die Darstellung der Angaben werden durch die technologischen M\u00f6glichkeiten des TELERIK-Controls beeinflusst. Einer Weiterentwicklung der Darstellung und notwendiger Angaben auch gerne auf Grundlage eines Feedbacks von Ihnen als Anwender sehen wir sehr positiv entgegen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/programmaenderungen_release_11_2.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":"<p>45 - Pauschalwertberichtigung </p> <p>Bei der Auswahl der Buchungsperiode waren bisher auch Eingaben von Buchungsperioden au\u00dferhalb von 1 bis 12 m\u00f6glich, was zu Fehlbuchungen f\u00fchrte. Dieser Fehler wurde behoben.</p> <p>48 - Vollstreckung </p> <p>Ab sofort wird das Belegdatum eines Offenen Postens als Bescheiddatum ans avviso \u00fcbergeben.</p> <p>4a - OP-Anpassung </p> <p>Nachtr\u00e4gliche Buchungstext-\u00c4nderungen in der OP-Anpassung werden nun wieder korrekt auf dem Kontoauszug ausgewiesen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/programmaenderungen_release_11_2.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":"<p>51 - Auftragsverwaltung </p> <p>Im Men\u00fcpunkt 51 Auftragsverwaltung wurde die Funktionalit\u00e4t des Buttons \"BEST\u00c4TIGEN\" dahingehend erweitert, als das unmittelbar nach dem Dr\u00fccken des Buttons ein AutoRefresh der Maske erfolgt, sodass die Haken in den Statusspalten (G und B) dann sofort sichtbar sind. </p> <p>In der Auftragsverwaltung kann jetzt bei Verwendung von Produkt/Sachkonten, wo Steuer m\u00f6glich ist, (Steuerart = beliebig) auch das Kennzeichen \"\u2013 ohne Steuer\" ausgew\u00e4hlt/verwendet werden.</p> <p>Das \u00a0Modul \"Gesamtauftr\u00e4ge\" wurde um weitere Funktionalit\u00e4ten erweitert. Neben den bisherigen M\u00f6glichkeiten, IFR-Auftr\u00e4ge unterhalb einer Gesamtauftragsnummer zu gruppieren, besteht nun auch die M\u00f6glichkeit, Buchungsstellen in Verbindung mit einem Gesamtauftrag zu definieren. Es k\u00f6nnen sowohl IFR-Auftr\u00e4ge als auch Buchungsstellen gemeinsam definiert werden. Die Hinterlegung von Buchungsstellen am Gesamtauftrag unterliegt keiner Verf\u00fcgbarkeitspr\u00fcfung, sondern dient rein der Kontierungsfindung insbesondere im Kontext des elektronischen Rechnungsworkflows. Wenn im Eingangsrechnungsjournal aus dem angebundenen DMS eine Gesamtauftragsnummer \u00fcbergeben wird, erfolgt eine IFR-interne Pr\u00fcfung auf das Vorhandensein dieser Gesamtauftragsnummer. Bei erfolgreicher Pr\u00fcfung wird dem Anwender in einem Zwischenfenster die M\u00f6glichkeit gegeben, automatisch einzelne Eingangsrechnungspositionen anzulegen auf Basis der stammdatenseitigen Positionen des Gesamtauftrages. \u00a0</p> <p></p> <p>52 - Eingangsrechnungsjournal </p> <p>Beim Releasewechsel 58 ist ein nicht korrekter Mappingeintrag f\u00fcr die eRechnungen angelegt worden. Hierzu erfolgte eine Korrektur. </p> <p>Bei Kreditoren mit mehreren Bankverbindungen wird die im DMS-Erfassungsformular eingetragene Bankverbindung korrekt in die Erfassungsmaske im Eingangsrechnungsjournal \u00fcbernommen. Es wird damit eine Unterscheidung zwischen Standard-Bankverbindung und weiteren Bankverbindungen gew\u00e4hrleistet. Die verwendete Bankverbindung wird in einem neuen Feld unterhalb des Kreditors dargestellt. Ein visueller Abgleich mit der IBAN auf der zu buchenden Rechnung ist weiterhin unerl\u00e4sslich.  Bei neuen Eingangsrechnungen ist eine Positionserfassung wieder m\u00f6glich.</p> <p>Im Eingangsrechnungsjournal wurde die \u00dcbersichtsmaske um 3 Spalten erweitert. Neu hinzugekommen sind Buchungstext1, OP-Nummer und Kundennummer.</p> <p>Bei der Eingabe des RAP-Zeitraums in der Eingangsrechnungspositionserfassung gab es noch die Fehlerm\u00f6glichkeit, dass das Bis-Datum \u00a0kleiner sein konnte als das Von-Datum. Dieser Fehler wurde behoben.</p> <p>Bei der \u00dcbergabe von inaktiven PK-Nummern aus dem DMS bzw. bei fehlenden PK-Nummern erscheint eine entsprechende Fehlermeldung im Eingangsrechnungsjournal bei der \u00dcbernahme der Rechnung bzw. bleibt das PK-Nummernfeld leer und ist entsprechend mit einem Kreditoren zu f\u00fcllen. </p> <p>54 - Ausgangsrechnungsjournal </p> <p>Wird im ARJ eine Tarifgruppe gew\u00e4hlt, bei der im Sachkonto die Steuerart \"2 - nur eine Steuer\" hinterlegt ist, wird das in den Stammdaten hinterlegte Steuerkennzeichen per Default vorbelegt und ist nicht mehr editierbar. Vor der Anpassung konnte an dieser Stelle ein anderes Kennzeichen gew\u00e4hlt werden und mit \"\u00dcbernehmen\" verwies eine Plausibilit\u00e4tspr\u00fcfung darauf, dass die Einnahmeart ein anderes Steuerkennzeichen ben\u00f6tigt. </p> <p>Im Ausgangsrechnungsjournal wird bei der Stammdatenpflege einer Musterrechnung und auch der Erfassung einer AR auf Basis einer Musterrechnung der ERFASSER im gleichnamigen Auswahlfeld nicht mehr mit dem Login-Namen vorbelegt. Eine individuelle Filterung ist weiterhin m\u00f6glich. Musterrechnungen werden \u00fcberwiegend zentral erfasst, sodass der Buchhalter immer erst den Erfasser entfernen m\u00fcsste aus dem Auswahlfeld um alle Musterrechnungen angezeigt zu bekommen. \u00a0Der ERFASSER in der \u00dcbersichtsmaske des Ausgangsrechnungsjournal bleibt weiterhin mit dem Login-Namen vorbelegt.</p> <p>Im Ausgangsrechnungsjournal kann eine neue Vorlagenoption gew\u00e4hlt werden. Rechnungen k\u00f6nnen jetzt \"mit Kontoauszug\" gedruckt werden. \u00dcber die Option \"verk\u00fcrztes Format\" k\u00f6nnen die einzelnen Positionen eines Beleges zusammengefasst werden. </p> <p>Bei der \u00dcbergabe der Ausgangsrechnungen als eRechnung mit ZugPFeRD in das DMS VIS erfolgt jetzt nur noch die \u00dcbergabe der PDF-Datei mit dem eingebetteten XML.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/programmaenderungen_release_11_2.html#6-auswertung","title":"6 - Auswertung","text":"<p>6213 - Mittelbindung </p> <p>Die Filterfelder f\u00fcr Produkt, Sachkonto und Ma\u00dfnahme sind nun Multiselektionsfelder. Beim Abtauchen k\u00f6nnen mittels Anklicken und gedr\u00fcckter STRG-Taste mehrere Angaben ausgew\u00e4hlt werden. </p> <p>66 - OP-Listen </p> <p>Die Men\u00fcpunkte 6612 (Lastschrift-), 6613 (Gutschrift-), 6614 (Mahnung-), 6617 (Aufrechnung), 6622 (Zahlungsvorschlag), 6625 (Aufrechnung) werden nun standardm\u00e4\u00dfig im aktuellen Haushaltsjahr (=Kassenjahr) ge\u00f6ffnet. Damit soll verhindert werden, dass die Vorschl\u00e4ge versehentlich im falschen Haushaltsjahr erstellt werden, z.B. wenn zuvor das Folgejahr (=Planjahr) bearbeitet wurde.</p> <p>6611 - Debitorische OP-Listen </p> <p>F\u00fcr eine korrekte und nicht irritierende Darstellung der stichtagsbezogenen OP-Listen wurde eine Vorlagenoption \"Belegdaten unterdr\u00fccken\" \u00a0integriert. Damit werden die Belegnummer, die Buchungstexte sowie das Buchungsdatum in der Darstellung unterdr\u00fcckt. Da diese Angaben innerhalb einer OP-Historie nicht eindeutig sind, beschr\u00e4nkt sich die Darstellung mit der genannten Vorlagenoption auf die wesentlichen Eckdaten des OP's. Die Vorlagenoption wirkt auch auf die normale Erstellung einer OP-Liste. Insofern obliegt die Verwendung in der Verantwortung des Anwenders.</p> <p>6614 - Mahnvorschlag </p> <p>Der Mahnbescheid wurde um eine Vorlagenoption \"mit GiroCode drucken\" erweitert. Damit kann dem Zahlungspflichtigen, wie auch bereits im Ausgangsrechnungsjournal, eine bequeme L\u00f6sung zur Verf\u00fcgung gestellt werden, um mobil mit einem QR-Code die offenen Forderungen zu \u00fcberweisen. Zwingend daf\u00fcr muss der Schalter K07 mit dem entsprechenden Zahlweg bef\u00fcllt sein.</p> <p>672 - Umsatzsteueranmeldungen </p> <p>Es ist jetzt auch m\u00f6glich, eine leere Umsatzsteuermeldung = Null-Meldung zu erstellen. Auch nachtr\u00e4gliche Buchungen k\u00f6nnen dieser Meldung noch zugeordnet werden.</p> <p>Es wurde ein Schreibfehler im Report Umsatzsteuerzusammenstellung korrigiert.</p> <p>69 - gesetzliche Drucklisten </p> <p>Zeilenumbr\u00fcche f\u00fcr die Haushaltssatzung werden nun wieder richtig gesetzt, wenn das gesetzliche Muster mit einem Doppelhaushalt gedruckt wird.</p> <p>6s - Dokumentenmappen Beim Aufbereiten der Druckvorschau der Dokumentenmappe kam es zu einem Fehlverhalten bei der Darstellung der Seitenzahlen im Inhaltsverzeichnis. Der Fehler wurde gefunden und ist behoben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/programmaenderungen_release_11_2.html#7-jahresabschluss","title":"7 - Jahresabschluss","text":"<p>7111 - Mittel\u00fcbertrag ins Folgejahr aus offenen Auftr\u00e4gen </p> <p>Die M\u00f6glichkeiten von \u00dcbertragungen wurden um 2 Szenarien erweitert. Neben der bisher bekannten \u00dcbertragung in Form von Haushaltsresten k\u00f6nnen zuk\u00fcnftig auch Auftr\u00e4ge \u00fcber R\u00fcckstellungen oder auch mit Wert 0,00 \u20ac \u00fcbertragen werden. Der \u00dcbertrag per R\u00fcckstellung setzt in beiden Haushaltsjahren mind. ein R\u00fcckstellungskonto mit der Kontoart R0 voraus. Beim \u00dcbertrag kann pro Auftrag zwischen verschiedenen R0-Konten gew\u00e4hlt werden. Nach Auswahl des zu \u00fcbertragenden Auftrages (Mehrfachauswahl ist m\u00f6glich) kann im nachfolgenden Fenster das zu verwendende R0-Konto gew\u00e4hlt werden. Mit dem Dr\u00fccken des Buttons \u201eMittel\u00fcbertragung buchen\u201c werden die im Auftrag gebundenen Mittel im Hintergrund entreserviert. Es erfolgt im Jahr des \u00dcbertrages eine automatisierte Buchung Aufwand an R\u00fcckstellung und im Folgejahr die Aufl\u00f6sungsbuchung R\u00fcckstellung an Aufwand in gleicher H\u00f6he. Diese dann im Folgejahr aufgel\u00f6sten Haushaltsmittel werden dem \u00fcbertragenen Auftrag automatisiert wieder zugef\u00fchrt. Die beiden entstehenden R\u00fcckstellungsbuchungen durchlaufen den Anordnungsprozess. Bis zum Zeitpunkt der Verbuchung im Buchungsstapel wird der Auftrag mit einem neuen Status \u201eAO-Druck\u201c versehen. In diesem Zeitraum ist keine Bearbeitung oder Verwendung im Eingangsrechnungsjournal m\u00f6glich. Die automatisch erzeugten R\u00fcckstellungsbuchungen bilden somit die Verf\u00fcgbarkeitsmittel des zu \u00fcbertragenden Auftrages ab. Eine \u00dcbertragung per R\u00fcckstellung in Verbindung mit den bisherigen herk\u00f6mmlichen Vorjahresmitteln ist technologisch nicht vorgesehen. Weiterhin k\u00f6nnen zuk\u00fcnftig Auftr\u00e4ge mit Restauftragswert 0,00 \u20ac \u00fcbertragen werden. Dazu wurde die Option \"Auftr\u00e4ge ohne Restwert anzeigen\" integriert. Damit kann bei bestimmten Sachverhalten die urspr\u00fcngliche Auftragsnummer \u00fcber mehrere Jahre fortgef\u00fchrt werden. In den Folgejahren k\u00f6nnen dem Auftrag neue Haushaltsmittel des jeweiligen aktuellen Haushaltsjahres zugef\u00fchrt werden.</p> <p>7112 - Mittel\u00fcbertragung ins Folgejahr aus \u00fcbertragbaren Buchungsstellen </p> <p>Bei der Mittel\u00fcbertragung von Einnahmen kam eine nicht korrekte Infomeldung, obwohl gen\u00fcgend Budgetmittel zum \u00dcbertrag ins n\u00e4chste Jahr vorhanden waren. Dieser Fehler wurde korrigiert. Die Pr\u00fcfung des eingegebenen Betrags f\u00fcr den \u00dcbertrag, ob dieser zu hoch oder negativ gegen\u00fcber dem Verf\u00fcgbaren ist, besteht weiterhin.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/programmaenderungen_release_11_2.html#8-veranlagung","title":"8 - Veranlagung","text":"<p>Allgemeines </p> <p>Die Darstellung des ausf\u00fchrlichen Kontoauszugs in den Veranlagungsbescheiden der allgemeinen Steuern, wiederkehrenden Einnahmen und Geb\u00fchren wurde \u00fcberarbeitet und erfolgt nun in einer komprimierten Form.  Pro OP-Nummer und F\u00e4lligkeit wird - unabh\u00e4ngig von der Anzahl der daf\u00fcr durchgef\u00fchrten Einzelbuchungen - die Summe Soll und Haben ausgewiesen, die Auff\u00fchrung aller Einzelbuchungen entf\u00e4llt somit.</p> <p>Mit Aktivierung der neuen Druckroutine (Systemparameter: DRUCKOUTPUTCENTER = 1) wird als erstes die Bescheid-Vorschau aufgeblendet und es kann entschieden werden, ob der Bescheid zum Ausdrucken bereitgestellt wird. Der Status 'Bescheid gedruckt' wird erst gesetzt, wenn die Vorschau weiterverarbeitet wird, dabei ist \u00fcber die PDF-Archivierung und DMS-Ablage zu entscheiden. Im Anschluss kann der Bescheid verbucht werden.</p> <p>81 - Einzelveranlagung </p> <p>Werden Gewerbesteuer-Jahresbescheide f\u00fcr Objekte mit abweichenden Wirtschaftsjahren \u00fcber die Einzelveranlagung erstellt, wird beim Buchen der Bescheide ebenfalls der Hinweis gegeben, wenn noch Restraten aus dem Vorjahr verbucht werden m\u00fcssen. Diese sind zwingend \u00fcber das Men\u00fc 82_Gesamtveranlagung im alten Haushaltsjahr mit Bescheidart 'R-Restraten AwWJ' zu verbuchen.</p> <p>F\u00fcr die Trink- und Abwasserz\u00e4hler kann bei der Erfassung derselben die verbindliche Eichfrist hinterlegt werden.</p> <p>Ist beim Erstellen einer Veranlagung bereits bekannt, dass im neuen Jahr ge\u00e4nderte Berechnungsgrundlagen zum Tragen kommen, wird auf dem Bescheid generell keine Information zu den Raten des Folgejahres ausgewiesen. Der Steuerpflichtige erh\u00e4lt im neuen Jahr einen neuen Jahresbescheid.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/programmaenderungen_release_11_2.html#9-barkasse","title":"9 - BARKASSE","text":"<p>Mit der IFR-Barkasse ist es m\u00f6glich, Barkassengesch\u00e4fte gem\u00e4\u00df den gesetzlichen Vorgaben \u00a7146a AO in Verbindung mit der KassenSichV mittels einer angeschlossenen technischen Sicherheitseinrichtung (TSE) abzuwicklen. Die TSE ist \u00fcber die Cloud-L\u00f6sung der DEUTSCHEN FISKAL angebunden und bietet damit Zukunftssicherheit. Der Erwerb einer TSE ist direkt \u00fcber die DEUTSCHE FISKAL abzuwickeln. Die Implementierung erfolgt in Zusammenarbeit mit der IFR-Fachberatung.</p> <p>92 - Einnahmen und Ausgaben Kasse </p> <p>\u00dcber den Button 631/421 (deb. OP) besteht nun die M\u00f6glichkeit, in die Einzelbuchungsmaske abzuspringen und Zahlungsvorg\u00e4nge als SOLL-/IST-Buchung mit Buchungsschl\u00fcssel 421/621 zu erfassen. Mit \"\u00dcbernehmen\" wird dabei eine Anordnung erzeugt und die zahlungsrelevanten Informationen in das Kassenjournal, aus welcher der Bearbeiter abgesprungen ist, geschrieben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/programmaenderungen_release_11_2.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":"<p>b11 - Anlagegut bearbeiten </p> <p>Die Bildung und der Ausweis von Kostenstellen-Aufteilungen im Bereich AfA/Aufl\u00f6sung wurden im Zuge des Jahresabschlusses bzw. der Jahresabschluss-Pr\u00fcfungen bereinigt.</p> <p>b11 - Anlagegut bearbeiten/ b21 \u2013 Zuschuss bearbeiten (betrifft nur S\u00e4chsische Kommunen) </p> <p>Es wurde ein Fehler behoben, welcher bei bestimmen Konstellationen unn\u00f6tige Switch-Positionen (AfA 2018) produziert hat.\u00a0 </p> <p>b121 Nachaktivieren / b122 - Abgang / b221 - Nachpassivierung / b222 - R\u00fcckzahlung/Abgang </p> <p>Ab sofort steht die Kontenausnahme \u201eAbweichendes Sammelkonto\u201c \u00a0(Men\u00fc 11 --&gt; Mandantenstamm --&gt; Reiter Buchungsstellen) in den vorstehenden Men\u00fcpunkten bereit. Zum Beispiel zur direkten Umbuchung (Abgang) in den Aufwand ohne \u00c4nderung der Kontenart. \u00a0</p> <p>b122 - Abgang / b222 - R\u00fcckzahlung/Abgang </p> <p>Es wurde ein Fehler behoben, welcher bei einer Abgangsbuchung nicht gegen das in der Bewegung ausgew\u00e4hlte Produkt gebucht hat, sondern immer gegen das Produkt, welches im Stammsatz des Anlagegutes/Zuschusses hinterlegt wurde. \u00a0 \u00a0</p> <p>b123 - Umbuchung - Referenzableitung \u00a0  Ab sofort ist es m\u00f6glich bei der Referenzableitung eine Menge zu erfassen. Dies wird beispielweise bei Umbuchung einer Anlage im Bau, welche mit Menge null angelegt wird, notwendig. Dadurch entf\u00e4llt die Pflege der Menge im Nachgang. </p> <p>b42 - Ermittlung kalkulatorischer Zinsen/ b612 \u2013 Nachweis kalkulatorischer Zinsen </p> <p>Es wurde ein Fehler behoben, welcher bei unterj\u00e4hrigen Neuzug\u00e4ngen von Anlageg\u00fctern und Zusch\u00fcssen keine kalkulatorischen Zinsen ermittelt hat, sondern nur f\u00fcr Anlageg\u00fcter/Zusch\u00fcsse aus den Vorjahren. Bekannter Fehler (hat es kurzfristig nicht mehr in Release 60 geschafft) im Report \u201eNachweis der kalkulatorischen Zinsen\u201c Zeile: Ausweis Stand zum Jahresanfang f\u00fcr Zinsrechnung wird mit dem Release 61 behoben.\u00a0 </p> <p>b611 - Anlagennachweis </p> <p>Der Buchungstext 2 ist jetzt ausw\u00e4hlbar; sodass durch die einfache oder kombinierte Auswahl der Optionen im rechten Teil der Maske auf den Umfang des Druckes Einfluss genommen werden kann. Der Buchungstext 2 wird zus\u00e4tzlich zum Buchungstext 1 mit auf dem Anlagennachweis ausgegeben. </p> <p>b64 - Zu-/Abg\u00e4nge </p> <p>In der AnBu-Bewegungsliste wurde die Formatierung der Sachkonten korrigiert. (Report \u201eANLBU_2441_BEWEGUNGEN.MRT\u201c)</p> <p>Beim Druck der Zu-/Abgangsliste erfolgte nicht immer ein korrekter Ausweis des Abschreibungssachkontos, vor allem im Zusammenhang mit geswitchten Anlageg\u00fctern (betrifft nur Sachsen und HH-Ausgleich 2018).</p> <p>b721 - Pr\u00fcfung Jahresabschluss - fehlende AfA </p> <p>Es wurde ein Fehler behoben, bei welchem gel\u00f6schte bzw. stornierte Anschaffungspositionen im Men\u00fc b721 als fehlerhaft (orange) ausgewiesen wurden.\u00a0 </p>"},{"location":"aktuelles/releasehistorie/release4.1.0060/programmaenderungen_release_11_2.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s12 - DMS - Konfiguration </p> <p>Zur direkten Anbindung von IFR an das DMS-Verfahren VIS 6 wird in der Systemverwaltung DMS-Konfiguration ein neuer, gesonderter DMS-Typ angeboten. In dieser neuen Konfiguration wurden jetzt spezielle Erweiterungen bzw. \u00c4nderungen in der verwendeten VAPI des VIS 6 ber\u00fccksichtigt.</p> <p>s21 - Benutzerverwaltung </p> <p>In der Nutzerverwaltung wurden die max. Eingabefeldl\u00e4ngen bei Telefon-Nr. und Fax-Nr. auf 30 Stellen erweitert. Damit k\u00f6nnen \u00fcber den LDAP-Abgleich aus dem Active Directory (AD) die Telefon- und Faxnummern vollst\u00e4ndig importiert werden, wenn diese im AD l\u00e4nger als die von der Bundesnetzagentur vorgegebenen max.15 Stellen hinterlegt sind. Dies kann u.U. durch die Verwendung von Leerzeichen und Trennzeichen zur besseren Lesbarkeit vorkommen. </p> <p>s59 - Aufgaben\u00fcberwachung </p> <p>Der DMS-\u00dcbergabestatus wurde um neue Filterm\u00f6glichkeiten erweitert. Weiterhin kann \u00fcber einen Schieberegler die Anzeige bez\u00fcglich eines R\u00fcckblickes beeinflusst werden. Insbesondere bei fehlerhaften DMS-\u00dcbergaben mit Fehleranzahl-Versuche 10 kann \u00fcber den Button \u201eDMS-R\u00fccksetzen\u201c ein Wiederanlauf der noch nicht \u00fcbergebenen Dokumente gestartet werden. Dazu sind die betreffenden Datens\u00e4tze vorab zu markieren.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/installations_checkliste_rele2.html","title":"Installations Checkliste Release 4.1.0061","text":""},{"location":"aktuelles/releasehistorie/release4.1.0061/installations_checkliste_rele2.html#installations-checkliste-release-410061","title":"Installations Checkliste Release 4.1.0061","text":"<p>Vorg\u00e4ngerrelease ist Release 60</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/installations_checkliste_rele2.html#update","title":"Update","text":"<p>1. Alle SASKIA \u00ae .de IFR-Nutzer abmelden </p> <p>(auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 61.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/installations_checkliste_rele2.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>2. \u00a0 Releasewechsel 61 </p> <p>Nach Herunterladen und Installation des Updates kann der Releasewechsel f\u00fcr Release 61 durchgef\u00fchrt werden.  Falls aus Vorg\u00e4nger-Releases noch offene Releasepunkte angezeigt werden, sind diese vorab - beginnend mit dem kleinsten noch offenen Release - auszuf\u00fchren. </p> <p>Die Checksummen der Releasewechselpunkte wurden neu berechnet. Daher kann es vorkommen, dass das Release 60 nochmals aktiviert ist und Punkte als nicht abgeschlossen gelten. Diese k\u00f6nnen ohne Bedenken neu ausgef\u00fchrt werden. </p> <p>Durch Markieren der entsprechenden Version der verf\u00fcgbaren Datenbank in der linken Tabelle werden die Punkte des Releasewechsels wie gewohnt in der rechten Tabelle dargestellt.</p> <ul> <li> <p>Datenbankstruktur anpassen Interne Anpassung der Struktur von Tabellen, Ansichten, Indexe usw. in der Datenbank. Daten werden hierbei nicht ver\u00e4ndert.</p> </li> <li> <p>Datenbank\u00e4nderungen Anpassung des Datenbestandes an die neue Releaseversion.</p> </li> <li> <p>Anpassung der Reportvorlagen Installation neuer Reportvorlagen und Deinstallation nicht mehr ben\u00f6tigter Reportvorlagen, Registrieren neuer Ausgabek\u00fcrzel.</p> </li> <li> <p>Convert table columns from 'System.Decimal' to 'System.Int.32' Strukturelle Anpassung der Tabellen f\u00fcr den performanten Zugriff mit dem Entity-Framework. Die Ausf\u00fchrung erfolgt nur f\u00fcr SQL-Server \u2013 Datenbanken, die Anzeige im Releasewechsel erfolgt immer!</p> </li> <li> <p>Erweiterung von Anbu-Sachkonten-Views Um die Kontenausnahme \u201eAbweichendes Sammelkonto\u201c in der AnBu anbieten zu k\u00f6nnen, muss die Datenbank-Ansicht erweitert werden.</p> </li> <li> <p>Test-Migration Rechnungsabgrenzungsposten  F\u00fcr zuk\u00fcnftige Anpassungen in der RAP-Verwaltung wird eine Testmigration in separate Tabellen durchgef\u00fchrt. Diese Daten werden bei Bedarf von der SASKIA-Fachberatung analysiert.</p> </li> <li> <p>Erg\u00e4nzung des Haushaltsjahr in den Barkassen-Buchungen Die vorhandene Daten im Barkassenjournal werden um das HH-Jahr erg\u00e4nzt. Das HH-Jahr wird dabei aus dem Buchungsdatum abgeleitet.</p> </li> <li> <p>Erg\u00e4nzung der Kassen-Id in der BK_BELEG Es erfolgt die Zuordnung der Belege zu einer Barkasse.</p> </li> <li> <p>Korrektur KS-CONTAINER - Teil 3 (kann unterbrochen werden) Ein Punkt aus dem Vorg\u00e4nger-Release wird zur erneuten Ausf\u00fchrung angeboten, da nicht sichergestellt werden konnte, dass dieser Punkt in der Vergangenheit korrekt ausgef\u00fchrt wurde. Wenn der Punkt im Vorg\u00e4nger korrekt ausgef\u00fchrt wurde, wird keine Aktion mehr ausgef\u00fchrt. (Erg\u00e4nzung des Mandanten in der Tabelle ks_container)</p> </li> <li> <p>Korrektur KS-CONTAINER - Teil 4 (kann unterbrochen werden) Ein Punkt aus dem Vorg\u00e4nger-Release wird zur erneuten Ausf\u00fchrung angeboten, da nicht sichergestellt werden konnte, dass dieser Punkt in der Vergangenheit korrekt ausgef\u00fchrt wurde. Wenn der Punkt im Vorg\u00e4nger korrekt ausgef\u00fchrt wurde, wird keine Aktion mehr ausgef\u00fchrt. (Erg\u00e4nzung des Mandanten in der Tabelle ks_container)</p> </li> </ul> <p>3. Aktualisierung des Schattenmandanten </p> <p>Bei der Aktualisierung des Schattenmandaten bitte alle Punkte aktualisieren, die auf \"Ausf\u00fchren\" stehen. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/letzte_programmaenderungen9.html","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0061/letzte_programmaenderungen9.html#letzte-programmanderungen","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0061/letzte_programmaenderungen9.html#auslieferung-zum-24112021-version-38445","title":"Auslieferung zum 24.11.2021 - Version 38445","text":""},{"location":"aktuelles/releasehistorie/release4.1.0061/letzte_programmaenderungen9.html#veranlagung","title":"veranlagung","text":"<p>Einzel- und Gesamtveranlagung </p> <p>Auf Gewerbesteuerbescheiden, die ausschlie\u00dflich Vorauszahlungen abbilden, wird kein Vorl\u00e4ufigkeitsvermerk f\u00fcr die Zinsberechnung gedruckt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/letzte_programmaenderungen9.html#auslieferung-zum-15102021-version-38411","title":"Auslieferung zum 15.10.2021 - Version 38411","text":""},{"location":"aktuelles/releasehistorie/release4.1.0061/letzte_programmaenderungen9.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>2. \u00a0 Releasewechsel 61 </p> <p>Nach Herunterladen und Installation des Updates kann der Releasewechsel f\u00fcr Release 61 durchgef\u00fchrt werden.  Falls aus Vorg\u00e4nger-Releases noch offene Releasepunkte angezeigt werden, sind diese vorab - beginnend mit dem kleinsten noch offenem Release - auszuf\u00fchren. </p> <p></p> <p>Alle RW-Punkte, welche auf \"ausf\u00fchren\" stehen durchf\u00fchrenNeuer Releasewechselpunkt:  * \u201eInstalliert neue Textbausteine\u201c Installiert die neuen Report-Textbausteine mit der Vorl\u00e4ufigkeitserkl\u00e4rung f\u00fcr die Veranlagung</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/letzte_programmaenderungen9.html#buchung","title":"Buchung","text":"<p>311 - Einzelbuchung Die Plausibilit\u00e4tspr\u00fcfungen bei der Erzeugung von Buchungen wurden hinsichtlich des Vorhandenseins einer Belegnummer erweitert. Insbesondere bei Schnittstellen und manuellen Buchungen in der Einzelbuchungsmaske ist die Verwendung bzw. Bildung einer Belegnummer ein Pflichtkriterium. Die Nebenb\u00fccher im IFR (ERJ, ARJ, Veranlagung, Kontoauszugsverbuchungen usw.) erzeugen seit langem interne Belegnummer, welche im Kontext DMS von Bedeutung sind. In der Einzelbuchungsmaske war bisher bei Buchungsschl\u00fcssel 633 keine Belegnummer erforderlich. Vor dem Hintergrund einer einheitlichen Plausibilit\u00e4tspr\u00fcfung wurde auch dieser Buchungsschl\u00fcssel in die genannte Pr\u00fcfung einbezogen. Die Belegnummer wird wie z.B. auch bei Buchungsschl\u00fcssel 631 frei vergeben.  Mit Freigabe der neuen Buchungsmaske in einem der n\u00e4chsten Releases wird es entsprechend des \u201eG-Knopfes\u201c (Generierung eindeutige Belegnummer) auch f\u00fcr Zahlungsbuchungsschl\u00fcssel eine flexible Generierungsfunktion geben. Aktuell ist eine manuelle Vergabe einer Belegnummer bei BS633 zwingend notwendig.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/letzte_programmaenderungen9.html#auftrag-faktura","title":"auftrag / faktura","text":"<p>52 - Eingangsrechnungsjournal </p> <p>Im Eingangsrechnungsjournal Men\u00fc 52 werden beim Storno von Eingangsrechnungen mit hinterlegter KLR-Verteilung die KLR-Stornobuchungen korrekt erzeugt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/letzte_programmaenderungen9.html#veranlagung_1","title":"veranlagung","text":"<p>81 - Einzelveranlagung </p> <p>Die Festlegungen aus dem Urteil des BVerfG vom 08.07.2021 in Verbindung mit den Handlungsempfehlung des BmF vom 17.09.2021 und den Informationen von der Tagung des \"Beirat f\u00fcr Kommunalabgaben und Steuern\u201c des Deutschen St\u00e4dtetages am \u00a004.10.2021 wurden programmseitig eingearbeitet. Durch die Verwaltung ist im Vorfeld festzulegen, ob die anteilige Zinsfestsetzung (lt. BmF-Schreiben) oder die komplette Aussetzung der Gewerbesteuer-Zinsfestsetzung (alternative M\u00f6glichkeit lt. DST) \u00a0angewandt werden soll. Mit der 'Fachberatung Veranlagung' ist im Anschluss die gew\u00e4hlte Methode einzustellen und die jeweiligen Vorl\u00e4ufigkeitsvermerke f\u00fcr den Bescheid sind aufzunehmen. Bitte verbuchen Sie unbedingt alle Gewerbesteuerbescheide, die nicht erneut berechnet werden sollen, bevor die Umstellung auf die neue Zinsberechnung erfolgt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/letzte_programmaenderungen9.html#kreditedarlehen","title":"kredite/darlehen","text":"<p>a2 - Freigabe/Buchung </p> <p>\u00dcber die Schulden-Darlehensverwaltung k\u00f6nnen Kreditraten wieder erfolgreich gebucht werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html","title":"Programm\u00e4nderungen Release 4.1.0061","text":""},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html#programmanderungen-release-410061","title":"Programm\u00e4nderungen Release 4.1.0061","text":""},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html#allgemein","title":"Allgemein","text":"<p>Die Filterm\u00f6glichkeit per Rechtsklick auf eine Zelle mit gew\u00fcnschtem/nicht gew\u00fcnschtem Inhalt in den bisherigen IFR-Tabellen funktioniert ab sofort wieder. \u00a0</p> <p>Bei der Schreibweise Nachname, Vorname eines abweichenden Kontoinhabers wird dieser nun auch korrekt aufbereitet. Dies betrifft Drucke aus der Veranlagung und dem ARJ.</p> <p>In der Titelleiste des SASKIA.de-IFR werden jetzt neben der verwendeten Programmversion, Datenbank und ge\u00f6ffnetem Men\u00fcpunkt auch der Login-Name des angemeldeten Nutzers angezeigt. Diese Visualisierung erleichtert die Unterscheidung \u00a0bei der Verwendung von mehrfachen oder auch unterschiedlichen Programmanmeldungen.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html#0-global","title":"0 - global","text":"<p>011 - AufgabenVerwaltung </p> <p>Die M\u00f6glichkeit der E-Mail Benachrichtigung im Eingangsrechnungsjournal wurde hinsichtlich der Wirkungsweise und der zu konfigurierenden Nutzerrechte \u00fcberarbeitet. Sofern ein IFR-Anwender das Nutzerrecht \u201eERJ-EMail-Benachrichtigung\u201c mit \u201eJA\u201c zugewiesen bekommt, erh\u00e4lt er bei einer i.d.R. dezentralen Buchungsweise per E-Mail die Information, dass eine Eingangsrechnung f\u00fcr ihn zur Bearbeitung vorliegt. Der Ersterfasser der betreffenden Eingangsrechnungsposition ben\u00f6tigt das genannte Nutzerrecht als \u201eE-Mail-Sender\u201c nicht. Nur beim \u201eE-Mail-Empf\u00e4nger\u201c muss das Nutzerrecht eingerichtet sein. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html#1-stammdaten","title":"1 - Stammdaten","text":"<p>12a1 - Adressstammdaten </p> <p>\u00dcber den Button \u201eBriefkopf\u201c kann die Darstellung anhand des parametrisierten Adressformates (Auslandskennzeichen) nachvollzogen werden. Hier sind auch weitere Hinweise hinterlegt. </p> <p>Das verwendete Adressformat liegt in Verantwortung des Anwenders, sodass die nun erweiterte maximale Namensl\u00e4nge im Kontext der gebildeten Adresszeilen im Briefkopf zu sehen ist. Ein automatischer Zeilenumbruch oder \u00e4hnliches ist konzeptionell nicht vorgesehen, </p> <p>12a3 - Personenkontenverwaltung </p> <p>Die DMS-Anzeige \u00fcber den Button \"Anzeigen\" f\u00fcr die neuen DMS-Dokumententypen \"IfrLatsschriftmandat\" und \"IfrFreistellungsbescheinigung\" (Bauabzugssteuer) wurde angepasst.</p> <p>Der Aktiv-Haken bei einer als Einzellastschrift definierten BV wird nach Durchf\u00fchrung Lastschrift/Zahlung jetzt automatisch gel\u00f6scht.</p> <p>Im Reiter \"Freistellungsbescheinigung...\" wurden die Plausibilit\u00e4tspr\u00fcfungen bei der Erfassung einer Freistellungsbescheinigung erweitert. Es muss zwingend ein Zeitraum der G\u00fcltigkeit eingetragen werden. </p> <p>Die maximale Erfassungsl\u00e4nge f\u00fcr Name2 und Name3 wurde von bisher 27 auf nun einheitlich 45 Zeichen f\u00fcr alle 3 Namensfelder erweitert. Die manuelle Erfassung wurde bei L\u00e4ngen\u00fcberschreitungen um einen Warnhinweis erg\u00e4nzt \u201eName 2 und Name 3 sind zusammen l\u00e4nger als 45 Zeichen. Dies kann zur fehlerhaften Darstellung im Adresskopf f\u00fchren. Siehe Briefkopf!\u201c  \u00dcber den Button \u201eBriefkopf\u201c kann die Darstellung anhand des parametrisierten Adressformates(Men\u00fc 12a1 Auslandskennzeichen) nachvollzogen werden. Hier sind auch weitere Hinweise hinterlegt. Das verwendete Adressformat liegt in Verantwortung des Anwender, sodass die nun erweiterte maximale Namensl\u00e4nge im Kontext der gebildeten Adresszeilen im Briefkopf zu sehen ist. Ein automatischer Zeilenumbruch oder \u00e4hnliches ist konzeptionell nicht vorgesehen, \u00a0 \u00dcber Eingangsschnittstellen wird ebenfalls die maximale Eingabel\u00e4nge von jetzt 45 Zeichen f\u00fcr Name 2 und 3 erm\u00f6glicht.</p> <p>124 - Sachkontenverwaltung </p> <p>Bezugnehmend auf eine korrekte und einheiltliche Begrifflichkeitsverwendung im Kontext Steuerart/Steuerschl\u00fcssel wurden in relevanten Men\u00fcpunkten die daf\u00fcr verwendeten Bezeichnungen von \"ohne Steuer\" auf \"nicht steuerbar\" angepasst. </p> <p>125 - Ma\u00dfnahmen </p> <p>Im Men\u00fcpunkt wurde das bisher wirkende \"Budgetrecht\" entfernt, sodass sowohl in der Planungsphase als auch zu einem sp\u00e4teren Zeitpunkt die Ma\u00dfnahmen uneingeschr\u00e4nkt angezeigt und bearbeitet werden k\u00f6nnen, unabh\u00e4ngig davon, ob schon budgetrelevante Buchungsstellen existieren oder nicht. Dieser Men\u00fcpunkt sollte, wie auch andere stammdatenseitige Men\u00fcpunkte, ausschlie\u00dflich der K\u00e4mmerei/Finanzverwaltung vorbehalten sein.</p> <p>128 - Adressverwaltung </p> <p>Im Men\u00fc wurde die neue Maximall\u00e4nge von 45 Zeichen f\u00fcr die 3 Namensfelder umgesetzt. </p> <p>152 - Einnahmearten </p> <p>Sollen neue Tarifnummern f\u00fcr bestehenden Einnahmearten angelegt werden, so ist das im Men\u00fc 152-Reiter: 'Tarife' \u00a0\u00fcber die neue Funktionalit\u00e4t 'Tarif kopieren' einfacher und schneller m\u00f6glich. Dabei wird der Inhalt des gew\u00e4hltem Tarifs mit Ausnahme der Tarifnummer und des Wertes in die neue Zeile \u00fcbertragen. Die fehlenden Werte sind zu erg\u00e4nzen, gew\u00fcnschte textliche \u00c4nderungen einzutragen.</p> <p>Alle Tarifnummern, die im jeweiligen Steuerjahr nicht genutzt werden, k\u00f6nnen gel\u00f6scht werden.</p> <p>1z - Komplexpr\u00fcfung </p> <p>Die Komplexpr\u00fcfung kann jetzt wieder \u00fcber den Laufzeitbalken abgebrochen werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html#2-planung","title":"2 - Planung","text":"<p>243 - Ma\u00dfnahmeplan </p> <p>Beim Ausweis der Werte in der Zeile \"Bisher Folgejahre\" im unteren VE-Block kam es bei einem DHH mit Nachtrag zu einer Verschiebung der angezeigten Werte in den Jahresspalten. Hierzu erfolgte eine Programmkorrektur.</p> <p>Beim Anlegen eines Nachtragsplans f\u00fcr einen Doppelhaushalt kam es zu einem nicht korrekten Ausweis der Werte in den Spalten \"bish. Ansatz\". Hierzu erfolgte eine Korrektur.</p> <p>Bei einer Planansatz\u00e4nderung im Rahmen eines Nachtragshaushaltes kam es zu einer nicht korrekten Darstellung in der Bildschirmmaske f\u00fcr die schon best\u00e4tigten Planwerte. Hierzu erfolgte eine Programmkorrektur. </p> <p>264 - Sperren </p> <p>Automatiksperren auf R\u00fcckstellungskonten k\u00f6nnen nun auch \u00fcber dieses Men\u00fc aufgehoben werden, wenn es sich um R0-Konten handelt . </p> <p>27 - Neue Buchungsstellen </p> <p>Beim Anlegen von Buchungsstellen wird jetzt verhindert, dass eine Auswahl von Sachkonten bzw. Produkten, die nicht bebuchbar sind, und von Ma\u00dfnahmen, die nicht mehr g\u00fcltig sind, m\u00f6glich ist.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html#3-buchung","title":"3 - Buchung","text":"<p>311 - Einzelbuchung </p> <p>Beim Bearbeiten von manuellen Aufteilungsbuchungen kam es in der Zwischenbuchungs\u00fcbersichtsmaske zu verschiedenen Fehlverhalten. Hierzu erfolgten Programmkorrekturen.</p> <p>Bei Buchungsschl\u00fcssel 290 erfolgt jetzt keine Bebuchung der FR-Konten mehr. </p> <p>312 - Dauerbuchung </p> <p>F\u00fcr den AO-Druck der Dauerbuchungen erfolgte jetzt die Umstellung auf die im IFR schon vielfach umgesetzte L\u00f6sung mit dem Button \"AO-Druck\".</p> <p>Beim Druck von Anordnungen f\u00fcr eine Dauerbuchung mit der Option Liste kam es zu einem nicht korrekten Aufrufverhalten. Hierzu erfolgte eine Korrektur.</p> <p>33 / 36 - Buchungsstapel / Anordnungsdruck </p> <p>Die Pr\u00fcfung auf Dokumente im DMS wurde f\u00fcr die AO-Listen mit angepasst. Wenn also nur AO-Formular oder AO-Listen an einer Buchung h\u00e4ngen, erscheinen diese Buchungen bei angeschalteter Pr\u00fcfung-DMS nicht mit, wenn der Haken bei \"Buchungen nur mit DMS-Dokument\" gesetzt ist. Nur wenn ein anderer Dokumententyp (ER, allg. Buchbeleg, Zusatzdokument) noch zus\u00e4tzlich zur AO existiert, erscheinen die Buchungen bei Pr\u00fcfung-DMS mit aktiver Funktion \"Buchungen nur mit DMS-Dokument\". </p> <p>351 - Einrichtung Schnittstellen </p> <p>Die Schnittstelle V4 wurde um den Parameter \"Belegtyp f\u00fcr eindeutige Belegnummernbildung\" erweitert. Diese Anpassung wurde notwendig, um eine Eindeutigkeit beim Aufruf von Belegen aus dem DMS zu gew\u00e4hrleisten. Viele Vorsysteme liefern in ihren Datens\u00e4tzen ein und dieselbe Belegnummer f\u00fcr jeden Datensatz, welche dann in Folge zu Anzeigeproblemen beim DMS-Abruf f\u00fchrt.  \u00dcber das Men\u00fc \"127f - Belegtypen\" ist nun eine Definition von eigenen Belegtypen m\u00f6glich. Im Men\u00fc 3521 / 3522 k\u00f6nnen in dem neuen Parameter der Schnittstelle V4, die von Ihnen im Men\u00fc 127f administrierten Belegtypen ausgew\u00e4hlt werden. Bei einer getroffenen Auswahl werden vorhandene Belegnummern aus der Schnittstellendatei bei der Verarbeitung mit dem von Ihnen eingerichteten Belegnummerntyp \u00fcberschrieben. Die Nummerierung erfolgt dabei fortlaufend - f\u00fcr alle Schnittstellendateien, die \u00fcber diesen Belegtyp eingelesen und verarbeitet werden. Es ist ebenso m\u00f6glich, den Belegtyp im Parameter zu wechseln, wenn ein anderer Belegtyp, welcher unter 127f angelegt wurde, f\u00fcr das Einlesen ben\u00f6tigt wird. Die Fortschreibung der Belegnummern je Belegtyp wird auch beim Wechsel zwischen den unterschiedlichen Belegtypen sichergestellt.  Um diese neue Funktion nutzen zu k\u00f6nnen, ist neben der Einrichtung der Belegtypen ein Mapping Ihrer \u00e4lteren Version unserer Standardschnittstelle bzw. einer Schnittstelle aus Vorsystem auf unsere V4 notwendig. Bei Interesse an der Einrichtung der Belegtypen wenden Sie sich bitte an unsere Fachberatung. Kosten f\u00fcr das individuelle Mapping werden durch die Fachberatung je nach Arbeitsaufwand weiterberechnet.</p> <p>Die Prosoz Ausgangsschnittstelle wurde auf UTF8 umgestellt.</p> <p>36 - Anordnungsdruck </p> <p>Im SASKIA.de-IFR AO-Client wurde die Weiterleitungshistorie um die stammdatenseitig hinterlegten Bezeichnungen f\u00fcr die Zusatzstufen erg\u00e4nzt.</p> <p>F\u00fcr VIS-DMS-Kunden: Die \u00dcbergabe von Anordnungen ist wieder m\u00f6glich, wenn der Mandantenschalter F22 auf \"EinfachDMS\" steht.</p> <p>Bei Verwendung der neuen IFR-Druckvorschau u.a. zum Druck von Anordnungen bewirkt ein vorzeitiges \"Wegklicken\" der Druckvorschau ohne Dr\u00fccken des Buttons \"Weiterverarbeitung\", dass die Anordnung nicht an das DMS \u00fcbergeben wird. In dem Fall ist \u00fcber den Button \"AO-Druck\" eine nochmalige Erzeugung der Anordnung notwendig. Die \u00a0Anordnung ist bis zu diesem wiederholten Druck nicht in der AO-Verwaltung mit Status \u201egedruckt\u201c sichtbar. Es sollte ein gewisses \u201eAO-Monitoring\u201c organisiert werden, um bei vermeintlich fehlenden Anordnungen nicht erneute Buchungen zu erzeugen.</p> <p>Im AO-Client werden AO-Listen jetzt nur noch als ein Dokument angezeigt. Es kam bei AO-Listen ggfs. zu einem Timeout, wenn die Listen viele Positionen beinhalteten. </p> <p>Zusatzdokumente k\u00f6nnen im AO-Client nun auch angezeigt werden, wenn es kein PDF-Format ist. \u00dcber den Button \"Externe Anzeige\" \u00f6ffnet sich das entsprechende Programm zur Auswahl des Dateiformates. </p> <p>391 - Personenkundenauskunft </p> <p>Im Reiter OPs kam es beim Mandantenwechsel unter bestimmten Umst\u00e4nden zu Fehlern bei der Anzeige der Dokumente aus dem DMS. Dies wurde korrigiert. </p> <p>392 - Produkt-/Sachkontenauskunft </p> <p>Die Filterm\u00f6glichkeit per Rechtsklick auf eine Zelle mit gew\u00fcnschtem/nicht gew\u00fcnschtem Inhalt in den bisherigen IFR Tabellen (z.B. im Men\u00fc 392 Sachkontenauskunft) funktioniert ab sofort wieder. \u00a0</p> <p>394 - Budget\u00fcbersicht </p> <p>Im Men\u00fc 394 Budget\u00fcbersicht wurde die Spalte \"fortgeschriebener Planansatz\" angepasst. Die Budgetumbuchungen werden mit ber\u00fccksichtigt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":"<p>421 - Stundung </p> <p>Beim Stundungswiderruf kam es zu der Konstellation, dass er den nicht korrekten Status der Stundung angezeigt hat. Hierzu erfolgte eine Korrektur.</p> <p>491 - Erlass </p> <p>F\u00fcr den Erlass wurde ein neuer Report (F20133) \u00a0inclusive neuem Ausgabek\u00fcrzel hinterlegt. Dieser ist nun abgegrenzt von der AdV. Vor Nutzung sind die Textbausteine im Men\u00fc 1y1 \u00a0f\u00fcr den Report F20133 entsprechend \u00a0zu pflegen. </p> <p>492 - Erlass Druckliste </p> <p>Bei der Erlassliste kam es bei verschiedenen Kombinationen von OP's mit Steuerbuchungen zu einem nicht korrekten Ausweis der Spalte Erlass-Netto. Hierzu erfolgte eine Anpassung.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":"<p>52 - Eingangsrechnungsjournal </p> <p>Beim Verbuchen von Rechnungen im Eingangsrechnungsjournal mit Mehrfachauswahl wurden nicht die jeweilig angegebenen Weiterleitungsnutzer, sondern der jeweils erste oder letzte Nutzer f\u00fcr alle verbuchten ER ausgewiesen. Dieser Fehler wurde behoben.</p> <p>Im Eingangsrechnungsjournal selektiert nun das Suchfeld Rechnungsbetrag auf den Bruttobetrag der Rechnung. Vorher wurde nach dem Nettobetrag selektiert.</p> <p>54 - Ausgangsrechnungsjournal </p> <p>Der Fehler, dass bei Erstellen von mehr als einer neuen AR aus Musterauswahl und L\u00f6schen einer dieser AR aus der Stapelbearbeitung die \u00dcbernehmen-Funktion inaktiv/wirkungslos war, wurde behoben.</p> <p>54 / 592 - Ausgangsrechnungsjournal / Fakturierung </p> <p>Bei der Schreibweise Nachname, Vorname eines abweichenden Kontoinhabers wird dieser nun korrekt aufbereitet. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html#6-auswertung","title":"6 - Auswertung","text":"<p>623 - Summen- und Saldenliste </p> <p>In den Summen- und Saldenlisten f\u00fcr Sachkonten und f\u00fcr Personenkonten steht die Funktion Checkbox \"Null-Positionen\" unterdr\u00fccken wieder wie gewohnt zur Verf\u00fcgung. </p> <p>6611 - Debitorische OP-Listen </p> <p>F\u00fcr eine korrekte und nicht irritierende Darstellung der stichtagsbezogenen OP-Listen wurde eine Vorlagenoption \"Belegdaten unterdr\u00fccken\" \u00a0integriert. Damit wird die Belegnummer, die Buchungstexte sowie das Buchungsdatum in der Darstellung unterdr\u00fcckt. Da diese Angaben innerhalb einer OP-Historie nicht eindeutig sind, beschr\u00e4nkt sich die Darstellung mit der genannten Vorlagenoption auf die wesentlichen Eckdaten des OP's. Die Vorlagenoption wirkt auch auf die normale Erstellung einer OP-Liste. Insofern obliegt die Verwendung in der Verantwortung des Anwenders.</p> <p>In den OP-Listen k\u00f6nnen nun auch Sachkonten mit Kontoart 06 ausgew\u00e4hlt und gedruckt werden. </p> <p>671 - Umsatzsteuerjournal </p> <p>Der Men\u00fcpunkt 6224 interner Kontoauszug wurde um weitere Auswahlfelder (Auslandskennzeichen, Umsatzsteuer_ID und Steuerkennzeichen erweitert, welche die Recherchem\u00f6glichkeiten f\u00fcr m\u00f6glicherweise \u201efalsche\u201c nichtsteuerbare Buchungen unterst\u00fctzen sollen. Beim Auswahlfeld Auslandskennzeichen wurde eine neue \u00fcbergreifende Filteroptionen (nicht D,DE,DEU und nicht leer) integriert. Mit dieser Auswahl w\u00fcrden alle Personenkonten, welche nicht als Deutsch gekennzeichnet sind oder kein Auslandskennzeichen hinterlegt ist, zur Datenaufbereitung herangezogen. Damit k\u00f6nnte man die Buchungen auf ausl\u00e4ndischen Personenkonten n\u00e4her analysieren. Beim neuen Auswahlfeld Umsatzsteuer_ID w\u00fcrde man mit der Verwendung der Auswahl \u201enicht DE und nicht leer\u201c Buchungen von Personenkonten mit ausl\u00e4ndischer Umsatzsteuer_ID auswerten k\u00f6nnen. Die Selektionsm\u00f6glichkeiten zum Auslandskennzeichen f\u00fcr Personenkonten wurde in den OP-Listen ebenfalls erweitert. Auch hier ist die Auswahlm\u00f6glichkeit (nicht D,DE,DEU und nicht leer) integriert in Verbindung mit der bisher schon gewohnten M\u00f6glichkeit einer Mehrfachauswahl der angezeigten Personenkonten.</p> <p>672 - Umsatzsteueranmeldung </p> <p>Die Daten\u00fcbergabe in der ELSTER wurde an die aktuellen ERiC-Mindestanforderungen angepasst. </p> <p>68 - Freie Auswertungen </p> <p>Die Liste FS7001 - Vorbelastung k\u00fcnftiger HH-Jahre erh\u00e4lt nun je nach Land einen angepassten Titel. Standard (z. B. 014) --&gt; Vorbelastung k\u00fcnftiger Haushaltsjahre gem. \u00a746 S\u00e4chs.KomHVO 015 (Sachsen-Anhalt) --&gt; Vorbelastung k\u00fcnftiger Haushaltsjahre gem. \u00a736 KomHVO LSA 012 (Brandenburg) --&gt; Vorbelastung k\u00fcnftiger Haushaltsjahre gem. \u00a782 BbgKVerf</p> <p>69 - Gesetzliche Drucklisten </p> <p>Aufgrund von Updates der Fremdsoftware Stimulsoft, die zur Erstellung unserer Drucklisten im IFR ben\u00f6tigt wird, kam es in einigen Drucklisten zu einer \u00dcberlappung von Sachkontonummer und Bezeichnung. Um die Lesbarkeit weiterhin gew\u00e4hrleisten zu k\u00f6nnen, wird nun das Sachkonto auf einer separaten Zeile in H\u00f6he der gebuchten bzw. geplanten Werte dargestellt. Die Bezeichnung des Sachkontos erfolgt leicht einger\u00fcckt darunter.  Folgende Drucklisten wurden angepasst: Planlisten / Nachtragslisten: Ergebnishaushalt, Finanzhaushalt, Teilergebnishaushalt, Entwicklung Basiskapital HH-Rechnung: Teilfinanzrechnung B KLR: BAB</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html#7-jahresabschluss","title":"7 - Jahresabschluss","text":"<p>713 - Umbuchung GwSt-Erstattungszinsen </p> <p>F\u00fcr Gewerbesteuerf\u00e4lle mit Erstattungszinsen, die ab diesem Releasestand veranlagt werden, erfolgt die Umbuchung der Gewerbesteuererstattungszinsen in dem HH-Jahr in das sie verbucht wurden. Bisher erfolgte die Umbuchung immer im HH-Jahr lt. Bescheiddatum.</p> <p>Bei der Erstellung der Liste der umzubuchenden GwSt-Erstattungszinsen wurden auch hier noch die F\u00e4lle mit einbezogen, wo die Gesamtzinssumme unter 10 \u20ac ist. Diese F\u00e4lle sind allerdings nie kassenwirksam verbucht worden. Hierzu erfolgte eine Programmkorrektur.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html#8-veranlagung","title":"8 - Veranlagung","text":"<p>Information f\u00fcr vorbereitende Arbeiten zur Grundsteuerreform: Die strukturelle Vor-Pr\u00fcfung der Einheitswertaktenzeichen zur Grundsteuer B wurde erweitert. Zwei programmseitig festgelegte objektbeschreibende Felder wurden erg\u00e4nzt. Die Analyse ist somit detaillierter mit h\u00f6herer Aussagekraft m\u00f6glich.  Hinweis: a) f\u00fcr Anwender, welche die Anlayse bereits durchgef\u00fchrt haben: Wenden Sie sich bei Bedarf an unsere Fachberatung Veranlagung, wenn Sie eine aktualisierte Auswertung mit Grundst\u00fccksschl\u00fcssel und Objektbezeichnung ben\u00f6tigen. b) f\u00fcr Anwender, welche bisher noch keine Analyse durchf\u00fchrten: Bitte beachten Sie die \"Information Nr. 1 zur Grundsteuerreform\", welche in der Releasebeschreibung 4.1.0060 enthalten ist.</p> <p>Hinweis zur Gewerbesteuer-Vollverzinsung f\u00fcr Zeitr\u00e4ume ab 01.01.2019 </p> <p>Aufgrund der Beschl\u00fcsse des Bundesverfassungsgerichtes vom 08.07.2021 (Az.: 1 BvR 2237/14 und 1 BvR 2422/17) ist die aktuelle Anwendung des \u00a7 238 AO f\u00fcr Verzinsungszeitr\u00e4ume ab dem 01.01.2019 als verfassungswidrig erkl\u00e4rt worden. Der Gesetzgeber wurde bis zum 31.07.2022 aufgefordert, eine gesetzliche Neuregelung zu schaffen. Es wird aktuell aufgrund der fehlenden neuen Gesetzesgrundlage keine Software\u00e4nderung / Softwareanpassung geben. Wir empfehlen Ihnen deshalb, den gegebenenfalls bereits verwendeten Vorl\u00e4ufigkeitsvermerk nach \u00a7 165 AO hinsichtlich der Rechtsprechung anzupassen.</p> <p>Gewerbesteuerverzinsung f\u00fcr 2019 zinsfrei zwischen 01.04.2021 und 01.10.2021 </p> <p>Am 12. Februar 2021 wurde durch den Bundesrat dem \"Gesetz zur Verl\u00e4ngerung der Aussetzung der Insolvenzantragspflicht und des Anfechtungsschutzes f\u00fcr pandemiebedingte Stundungen sowie zur Verl\u00e4ngerung der Steuererkl\u00e4rungsfrist in beratenden F\u00e4llen und der zinsfreien Karenzzeit f\u00fcr den Veranlagungszeitraum 2019\u201c zugestimmt. F\u00fcr die Ermittlung der Gewerbesteuerzinsen des Steuerjahres 2019 wurde die Verl\u00e4ngerung der Karenzzeit programmseitig eingearbeitet. Die Verzinsung beginnt somit f\u00fcr das Steuerjahr 2019 erst am 01.10.2021. F\u00fcr alle anderen Steuerjahre gilt weiterhin: die Verzinsung von Gewerbesteuer-Nachzahlungen und -Erstattungen beginnt 15 Monate nach Ablauf des entsprechenden Haushaltsjahres.</p> <p>81 - Einzelveranlagung </p> <p>Weil sich der bisherige Umfang der \u00c4nderungen auf z.B. KITA-Bescheiden wesentlich erh\u00f6ht hat, wurde die M\u00f6glichkeit geschaffen, auf dem Bescheid nur die g\u00fcltigen ge\u00e4nderten Werte anzuzeigen. Insbesondere bei der Verwendung von Monatsbetr\u00e4gen ist diese Darstellung \u00fcbersichtlicher. </p> <p>Auch bei Gewerbesteuerbescheiden besteht die M\u00f6glichkeit, den ausf\u00fchrlichen Kontoauszug und die Mandatswerbung \u00a0auszuweisen.</p> <p>Die Zeichenanzahl, die f\u00fcr den Bescheidvermerk genutzt werden kann, wurde auf 1000 Zeichen erh\u00f6ht.</p> <p>Werden Bescheide in der Einzelveranlagung erfasst und berechnet und das Objekt bleibt in diesem Zustand ge\u00f6ffnet, dann wird \u00a0nach dem Drucken und Buchen in der Gesamtveranlagung bei der \u00a0R\u00fcckkehr in die Einzelveranlagung darauf hingewiesen, dass die noch sichtbare Veranlagung unterdessen nicht mehr aktuell und die Aktualisierung notwendig ist. Die in der Einzelveranlagung vor dem Wechsel in die Gesamtveranlagung nur eingetragenen, nicht \u00fcbernommenen Werte gehen dabei verloren!</p> <p>Bei der \u00dcbergabe an das DMS-System erfolgt die \u00dcbergabe der PK-Daten des Steuerpflichtigen, anstatt der zwischenzeitlich \u00fcbergebenen PK-Daten des Zustellers. </p> <p>Bei Veranlagungsf\u00e4llen der Gewerbesteuer wird beim erneuten Berechnen eines bereits gedruckten Bescheides \u00a0der Haken bei \"Bescheid ergangen\" entfernt. </p> <p>Die Wirksamkeit der Druckoption \"mit Monatsnamen\" \u00a0wurde auf weitere Layouts der Veranlagungen (VERAN / VERANU), die mit den Feldern 'von Monat' / 'bis Monat' arbeiten, umgesetzt. Mit dieser Druckoption k\u00f6nnen beim Druck der Veranlagungsbescheide die Monatszahlen in die Monatsnamen umgewandelt werden.</p> <p>In der Einzelveranlagung besteht beim Abtauchen in die PK-Verwaltung die M\u00f6glichkeit, auf Basis diverser PK-Angaben (Name, Ort, Stra\u00dfe,...) eine Mehrfachauswahl der zu betrachtenden PK's zu treffen. Diese Auswahl wird im Anschluss in die Auswahl \u00fcbernommen.</p> <p>Die Veranlagungsbescheide, die mit der Vorlagen-Option 'Duplex' \u00a0erstellt werden, ber\u00fccksichtigen jetzt auf den R\u00fcckseiten die korrekten Seitenr\u00e4nder. Damit k\u00f6nnen die Drucke problemlos gelocht und abgeheftet werden.</p> <p>Die Bezeichnung \"Vermerk zum Bescheid\" wurde - au\u00dfer auf den Bescheiden f\u00fcr Allgemeine Steuern und Gewerbesteuern - auf \"Vermerk\" gek\u00fcrzt. </p> <p>Wird die Vorschau im Outputcenter geschlossen und demzufolge nicht weiterverarbeitet, gilt der Bescheid als nicht gedruckt und ebenso als nicht ergangen. Neu berechnete Bescheide sind generell nicht ergangen. </p> <p>Im Titel des Gewerbesteuerbescheides wurde der Verweis auf Festsetzungen von Gewerbesteuerzinsen und Versp\u00e4tungszuschl\u00e4gen \u00fcberarbeitet, so dass auch bei Steuerbescheiden mit mehreren Steuerjahren stets ein korrekter Titel ausgewiesen wird.</p> <p>F\u00fcr den Druck der Bescheide, die ein Messbetragsfeld enthalten, erfolgt jetzt der Druck des Messbetrages mit Tausendertrennzeichen.</p> <p>Die Zeichenanzahl, die f\u00fcr den Bescheidvermerk genutzt werden kann, wurde auf 1.000 Zeichen erh\u00f6ht.</p> <p>Es erfolgte f\u00fcr den Report FVERGW (Gewerbesteuer) eine Erweiterung um die Druckvorlagenoption \"mit Ausdruck der Einzugserm\u00e4chtigung\".</p> <p>Werden Hundemarken \u00fcber eine Hundemarkenverwaltung eingerichtet, ist es m\u00f6glich, den Hundemarkenwechsel in der Tarifzeile abzubilden und im Bescheid im Tarifblock darzustellen. Bisher war der Ausweis der Markennummer nur in den objektbeschreibenden Daten m\u00f6glich.</p> <p>Bei der Schreibweise Nachname, Vorname eines abweichenden Kontoinhabers wird dieser nun korrekt aufbereitet. </p> <p>82 - Gesamtveranlagung </p> <p>F\u00fcr den Druck der Jahresbescheide der Gewerbesteuer kann -analog Allgemeine Steuern / Wiederkehrende Einnahmen- die Option 'nur ge\u00e4nderte Bescheide drucken' gew\u00e4hlt werden. Die dabei erzeugten Bescheide erhalten neben dem Status 'Gedruckt' die Markierung 'Bescheid ergangen'. Nicht erzeugte Bescheide erhalten den Status 'Gedruckt' aber keine Markierung 'Bescheid ergangen'. </p> <p>844 - Freie Auswertungen </p> <p>In den freien Auswertungen wurde die M\u00f6glichkeit geschaffen, individuelle Varianten zu speichern. Sie er\u00f6ffnen die M\u00f6glichkeit, Parameter vorab einzutragen und in einer zus\u00e4tzlichen Auswertung aufzurufen. Bitte wenden Sie sich bei Bedarf an unsere Fachberatung Veranlagung. </p> <p>Mit der \u00a0freien Auswertung FQ7003 \u00a0wurde die M\u00f6glichkeit der Auswertung der Z\u00e4hler inkl. Einbau/erstmalige Veranlagung f\u00fcr die entsprechend eingerichteten Abgabearten geschaffen.</p> <p>Mit der \u00a0freien Auswertung FQ7101 wurde die M\u00f6glichkeit der Auswertung der aufgrund der abgelaufenen Eichfrist auszubauenden Z\u00e4hler f\u00fcr die entsprechend eingerichteten Abgabearten geschaffen.</p> <p>Mit der \u00a0freien Auswertung FQ7101/ FQ7102 wurde die M\u00f6glichkeit der Auswertung der auszubauenden Z\u00e4hler f\u00fcr die entsprechend eingerichteten Abgabearten geschaffen.</p> <p>Mit der \u00a0freien Auswertung FQ7401 wurde die M\u00f6glichkeit der Auswertung der Tarife der genutzten Marken/Z\u00e4hler f\u00fcr die entsprechend eingerichteten Abgabearten (z.B. Hundesteuer, Wasser/Abwasser) geschaffen.</p> <p>Mit der \u00a0freien Auswertung FQ7501 wurde die M\u00f6glichkeit der Auswertung doppelter Marken/Z\u00e4hler f\u00fcr die entsprechend eingerichteten Abgabearten (z.B. Hundesteuer, Wasser/Abwasser) geschaffen.</p> <p>In den freien Auswertungen wurde die M\u00f6glichkeit geschaffen, individuelle Varianten zu speichern. Sie er\u00f6ffnen die M\u00f6glichkeit, Parameter vorab einzutragen und in einer zus\u00e4tzlichen Auswertung aufzurufen. Bitte wenden Sie sich bei Bedarf an unsere Fachberatung Veranlagung. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html#9-barkasse","title":"9 - BARKASSE","text":"<p>9 - Allgemein </p> <p>\u00dcber die neu geschaffene Ausgabeschnittstelle DSFinV-K erfolgt eine standardisierte Datenbereitstellung f\u00fcr die Au\u00dfenpr\u00fcfung sowie die Kassen-Nachschau durch Ausgabe definierter Kasseneinzelbewegungen, Stammdaten und Kassenabschl\u00fcsse gem\u00e4\u00df \u00a7146a AO.</p> <p>92 - Ein- und Ausgabe Kasse </p> <p>Der Kassenbon wurde um folgende Angaben in Bezug auf eine Anbindung an eine TSE erweitert: - TSE-Transaction - TSE-Start / Ende - TSE-Signaturz\u00e4hler - TSE-Seriennummer - TSE-Pr\u00fcfwert - Seriennummer (Kasse) Ist die TSE zum Zeitpunkt des Bondruckes nicht erreichbar, wird dies durch: \"TSE-Status: nicht erreichbar\" auf dem Kassenbon angezeigt. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html#b-anlagenbuchhaltung","title":"b - Anlagenbuchhaltung","text":"<p>b11 / b21 - Anlagegut / Zuschuss bearbeiten </p> <p>Ein umfangreicherer Zusatztext, welcher das sichtbare Textfeld \u00fcbersteigt, kann ab sofort durch die Integration eines Scrollbalkens problemlos hinterlegt und bearbeitet werden. Maximal 50.000 Zeichen sind m\u00f6glich. \u00a0 </p> <p>Ab sofort wird das AHK-Datum einer Anschaffungsposition, bei der Neuerfassung von Anlageg\u00fctern und Zusch\u00fcssen, nicht mehr mit dem aktuellen Datum vorbelegt. \u00a0</p> <p>Die Bildung und der Ausweis von Kostenstellen-Aufteilungen im Bereich AfA/Aufl\u00f6sung wurden im Zuge des Jahresabschlusses bzw. der Jahresabschluss-Pr\u00fcfungen bereinigt.</p> <p>b16 - Inventur </p> <p>Es wurde beim Vorschlag von Inventurdifferenzen ein SQL-Fehler behoben (betrifft nur Kunden mit Oracle-Datenbank).</p> <p>b35 - Doppische Verbuchung </p> <p>Ein Darstellungsfehler in der \u00a0\"Buchungsliste AfA\" wurde behoben. </p> <p>b42 - Doppische Verbuchung </p> <p>Nach Korrektur der kalkulatorischen Zinsberechnung f\u00fcr Neuzug\u00e4nge im Berechnungsjahr (Anbu-Jahr), zum Bezugszeitpunkt Jahresanfang im Release 60, wurde mit Release 61 wie angek\u00fcndigt, der Ausweis im Report \u201eNachweis der kalkulatorischen Zinsen\u201c (ANLBU_2412_KALK_ZINSEN.MRT) korrigiert.</p> <p>b73 / b74 - Jahresabschluss / Werte\u00fcbertrag </p> <p>Es wurde ein Fehler behoben, welcher den \u00dcbertrag der AfA-Stamms\u00e4tze ins n\u00e4chste AnBu-Jahr verhinderte. Dies wurde vom Programm her nicht signalisiert. Daher ist dieses Update unbedingt einzuspielen, sonst kann im n\u00e4chsten AnBu-Jahr nicht ohne Folgefehler weitergearbeitet werden. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0061/programmaenderungen_release_12.html#systemverwaltung","title":"Systemverwaltung","text":"<p>s21 - Benutzerverwaltung </p> <p>Die E-Mail-Benachrichtigung f\u00fcr die Anordnungsweiterleitung wurde \u00fcberarbeitet. Wenn der Empf\u00e4nger eine Mailadresse in der Systemverwaltung hinterlegt hat und das Recht, AO-E-Mail-Benachrichtigung mit ja hinterlegt ist, wird eine Mail versendet (Voraussetzung ist die Hinterlegung des Mailservers in den IFR- Systemparametern). Ist keine Mailadresse am Nutzer gepflegt und/oder das Recht AO-E-Mail-Benachrichtigung steht auf nein, wird keine Mail versendet.</p> <p>s31 - Releasewechsel </p> <p>Alte Daten aus Release 60 werden im Releasewechsel 61 entfernt.</p> <p>s342 - Systemaktualisierung </p> <p>Der Fehler, dass die beiden Saskia-Dienste nach Update/RW nicht gestartet werden konnten, wurde behoben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/installations_checkliste_rele3.html","title":"Installations Checkliste Release 4.1.0062","text":""},{"location":"aktuelles/releasehistorie/release4.1.0062/installations_checkliste_rele3.html#installations-checkliste-release-410062","title":"Installations Checkliste Release 4.1.0062","text":""},{"location":"aktuelles/releasehistorie/release4.1.0062/installations_checkliste_rele3.html#_1","title":"Installations Checkliste Release 4.1.0062","text":"<p>Vorg\u00e4ngerrelease ist Release 61</p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/installations_checkliste_rele3.html#update","title":"Update","text":"<p>1. Alle SASKIA \u00ae .de IFR-Nutzer abmelden </p> <p>(auch die Saskia.Starter schlie\u00dfen)</p> <p>2. Systemverwaltung Men\u00fc s342 \u2013 System \u2013 Update \u2013 Online-Update \u2013 Systemaktualisierung </p> <p>(beim Onlineupdate \u2018einspielen (ggf. herunterladen)' auch eigenen Starter schlie\u00dfen) Durchf\u00fchrung des Online-Updates mit anschlie\u00dfender Umstellung auf Update 62.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/installations_checkliste_rele3.html#releasewechsel","title":"Releasewechsel","text":"<p>1. Systemverwaltung \u00a0Men\u00fc s31 \u2013 Releasewechsel </p> <p>2. \u00a0 Releasewechsel 62 </p> <p>Nach Herunterladen und Installation des Updates kann der Releasewechsel f\u00fcr Release 62 durchgef\u00fchrt werden.  Falls aus Vorg\u00e4nger-Releases noch offene Releasepunkte angezeigt werden, sind diese vorab - beginnend mit dem kleinsten noch offenen Release - auszuf\u00fchren. </p> <p>Die Checksummen der Releasewechselpunkte wurden neu berechnet. Daher kann es vorkommen, dass das Release 61 nochmals aktiviert ist und Punkte als nicht abgeschlossen gelten. Diese k\u00f6nnen ohne Bedenken neu ausgef\u00fchrt werden. </p> <p>Durch Markieren der entsprechenden Version der verf\u00fcgbaren Datenbank in der linken Tabelle werden die Punkte des Releasewechsels wie gewohnt in der rechten Tabelle dargestellt.</p> <ul> <li> <p>Datenbankstruktur anpassen Interne Anpassung der Struktur von Tabellen, Ansichten, Indexe usw. in der Datenbank. Daten werden hierbei nicht ver\u00e4ndert.</p> </li> <li> <p>Datenbank\u00e4nderungen Anpassung des Datenbestandes an die neue Releaseversion.</p> </li> <li> <p>Korrektur KS-CONTAINER - Teil 3 (kann unterbrochen werden) Ein Punkt aus dem Vorg\u00e4nger-Release wird zur erneuten Ausf\u00fchrung angeboten, da nicht sichergestellt werden konnte, dass dieser Punkt in der Vergangenheit korrekt ausgef\u00fchrt wurde. Wenn der Punkt im Vorg\u00e4nger korrekt ausgef\u00fchrt wurde, wird keine Aktion mehr ausgef\u00fchrt. (Erg\u00e4nzung des Mandanten in der Tabelle ks_container)</p> </li> <li> <p>Korrektur KS-CONTAINER - Teil 4 (kann unterbrochen werden) Ein Punkt aus dem Vorg\u00e4nger-Release wird zur erneuten Ausf\u00fchrung angeboten, da nicht sichergestellt werden konnte, dass dieser Punkt in der Vergangenheit korrekt ausgef\u00fchrt wurde. Wenn der Punkt im Vorg\u00e4nger korrekt ausgef\u00fchrt wurde, wird keine Aktion mehr ausgef\u00fchrt. (Erg\u00e4nzung des Mandanten in der Tabelle ks_container)</p> </li> </ul> <p>3. Aktualisierung des Schattenmandanten </p> <p>Bei der Aktualisierung des Schattenmandaten bitte alle Punkte aktualisieren, die auf \"Ausf\u00fchren\" stehen. </p> <p>4. Achtung!! </p> <p>Die Autorisierung im IFR f\u00fcr interne Nutzer wurde aus Sicherheitsaspekten umgestellt. Nutzer, die sich mehr als 2 Jahre nicht im IFR angemeldet haben, werden sich nicht mehr anmelden k\u00f6nnen. In diesem Fall ist durch den Administrator ein neues Passwort zu vergeben. F\u00fcr externe Nutzer (Windows-Anmeldung) ergibt sich keine \u00c4nderung. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/letzte_programmaenderungen11.html","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0062/letzte_programmaenderungen11.html#letzte-programmanderungen","title":"Letzte Programm\u00e4nderungen","text":""},{"location":"aktuelles/releasehistorie/release4.1.0062/letzte_programmaenderungen11.html#auslieferung-zum-09022022-version-38845","title":"Auslieferung zum 09.02.2022 - Version 38845","text":""},{"location":"aktuelles/releasehistorie/release4.1.0062/letzte_programmaenderungen11.html#128-adressverwaltung","title":"128 - adressverwaltung","text":"<p>Es wurden die farblichen Zelleneigenschaften angepasst, sodass jederezeit eine sichtbare Transparenz gegeben ist analog der Darstellung im Ausgangsrechnungsjournal.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/letzte_programmaenderungen11.html#671-umsatzsteuerjournal","title":"671 - Umsatzsteuerjournal","text":"<p>Die aufgetretene Fehlermeldung (ewo_omm Spalte) beim Aufruf des Umsatzsteuerjournals wurde behoben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/letzte_programmaenderungen11.html#672-umsatzsteueranmeldungen","title":"672 - Umsatzsteueranmeldungen","text":"<p>Die Jahressteuerbescheinigung 2021 kann im System erstellt und \u00fcber die ELSTER-Schnittstelle an das Finanzamt \u00fcbertragen werden. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/letzte_programmaenderungen11.html#6s-dokumentenmappen","title":"6s - dokumentenmappen","text":"<p>Das Erstellen der Dokumentenmappe mit gro\u00dfen Dateianh\u00e4ngen funktioniert wieder.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/letzte_programmaenderungen11.html#anlagenbuchhaltung-allgemein","title":"Anlagenbuchhaltung Allgemein","text":"<p>Er\u00f6ffnungsbilanz-Positionen (Spalte \u201eEB\u201c an der Bewegung) mit inkludierten AfA-Betrag, z.B. Au\u00dferplanm\u00e4\u00dfige-Abschreibung, f\u00fchrten bei Anlageg\u00fctern / Zusch\u00fcssen ab Release 62 zu fehlerhaften Restbuchwerten. Der inkludierte AfA-Wert, einer EB-Position, wurde ein weiteres Mal zur aufgelaufenen AfA dazugerechnet und anschlie\u00dfend vom AHK-Wert abgezogen. Dieses Fehlverhalten wurde korrigiert. Das oben beschriebene Fehlverhalten, l\u00e4sst sich durch eine gezielte Neuberechnung der Abschreibung korrigieren. Um betroffene Anlageg\u00fcter / Zusch\u00fcsse identifizieren und korrigieren zu k\u00f6nnen, empfiehlt sich die \u201ePr\u00fcfung fehlende AfA\u201c im Men\u00fc b721 auszuf\u00fchren. Bei betroffenen Verm\u00f6gensgegenst\u00e4nden wird die Fehlermeldung \u201eRWA \u2013 abweichender Restwert\u201c angezeigt. Die Autokorrekturm\u00f6glichkeit wird durch einen Haken in der Spalte \u201eKorr.\u201c signalisiert. Danach l\u00e4sst sich der Fehler \u00fcber den Button \u201eKorrektur\u201c beheben. Anschlie\u00dfend sollte gezielt f\u00fcr etwaig betroffene Verm\u00f6gensgegenst\u00e4nde, bei denen die AfA bereits verbucht war, die Buchung der Abschreibung erneut vorgenommen werden.  </p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/letzte_programmaenderungen11.html#auslieferung-zum-21012022-version-38840","title":"Auslieferung zum 21.01.2022 - Version 38840","text":""},{"location":"aktuelles/releasehistorie/release4.1.0062/letzte_programmaenderungen11.html#672-umsatzsteueranmeldungen_1","title":"672 - Umsatzsteueranmeldungen","text":"<p>Die neue ERiC-Version wurde implementiert und somit k\u00f6nnen wieder alle USt.-Meldungen im System erstellt und \u00fcber die ELSTER-Schnittstelle an das Finanzamt \u00fcbertragen werden. </p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/letzte_programmaenderungen11.html#713-umbuchung-gwst-erstattungszinsen","title":"713 - umbuchung gwst-erstattungszinsen","text":"<p>Bei der Umbuchung der GWST-Erstattungszinsen wird wieder die Buchungsstelle der Gewerbesteuerzinsen entlastet.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/letzte_programmaenderungen11.html#92-ein-und-ausgabe-kasse","title":"92 - Ein- und ausgabe kasse","text":"<p>Beim Druck der Barkassenquittung kam es bei l\u00e4ngeren Einnahmearten-Bezeichnungen bzw. Kassenzeichen zu einem Abschneiden dieser. Hierzu erfolgte eine Reportkorrektur, sodass diese jetzt gegebenenfalls mehrzeilig bzw. in einer kleineren Schriftgr\u00f6\u00dfe dargestellt werden.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/letzte_programmaenderungen11.html#s21-benutzerverwaltung","title":"s21 - benutzerverwaltung","text":"<p>Der Fehler, dass nach Passwortneuvergabe (Anlage neuer Nutzer) bzw. Passwort\u00e4nderung mit dem vermeintlich \"neu vergebenen\" Passwort \u00a0keine erneute Anmeldung im Programm m\u00f6glich ist, wurde korrigiert.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/programmaenderungen_release_13.html","title":"Programm\u00e4nderungen Release 4.1.0062","text":""},{"location":"aktuelles/releasehistorie/release4.1.0062/programmaenderungen_release_13.html#programmanderungen-release-410062","title":"Programm\u00e4nderungen Release 4.1.0062","text":""},{"location":"aktuelles/releasehistorie/release4.1.0062/programmaenderungen_release_13.html#allgemein","title":"Allgemein","text":"<p>AO - Client </p> <p>Im IFR-AO-Client ist bei der sachlich/rechnerischen AO-Best\u00e4tigung im nachfolgenden \u201eWeiterleitungs-Fenster\" zwingend die Auswahl eines \u201eWeiterleitungs-Nutzers\u201c notwendig. Damit wird die Sicherheit des digitales Weiterleitungsprozesses optimiert. Es k\u00f6nnen dann keine Anordnungsvorg\u00e4nge ohne personifizierte Weiterleitungs-Zust\u00e4ndigkeit erzeugt werden. Beim Anordnen ist diese Auswahl als letzter Prozessschritt keine Pflichtangabe.</p> <p>Der IRF-AO-Client wurde um die Spalte \"F/L\" =&gt; AO-Formular/AO-Liste erweitert. In der Spalte \"Buchungstext\u201c wird bei AO-Listen jetzt nur noch allgemein \"IFR-Anordnungsliste\" ausgewiesen. Beim AO-Formular bleibt es wie bisher der Buchungstext 1 der jeweiligen Buchung. Das \"+\" (Plus-Zeichen) am Zeilenkopf wird nur noch bei Anordnungsvorg\u00e4ngen dargestellt, wo durch ein \"Aufklappen\" die weiteren Angaben zu vorhandenen \"Zusatzbest\u00e4tigungen\" und der \"Weiterleitungs-Historie\" sichtbar werden. Diese beiden gleichnamigen Reiter wurden hinsichtlich der Reihenfolge vertauscht, sodass der Fokus beim Aufklappen des Plus-Zeichens auf den \u201eZusatzbest\u00e4tigungen\u201c liegt.</p> <p>Telerik-Grid </p> <p>F\u00fcr alle TELERIK-Tabellen, insbesondere auch f\u00fcr die Budget\u00fcbersicht im Men\u00fc 394, besteht die M\u00f6glichkeit sog. \u201eGlobale Tabellenansichten\u201c zu definieren. Diese globalen Ansichten sind vordefinierte Spaltensichtbarkeiten, Gruppierungen und deren Reihenfolge f\u00fcr die verschiedensten Auswertungsanforderungen, die allen Anwendern zur Verf\u00fcgung stehen neben den weiterhin m\u00f6glichen eigenen individuell definierten Ansichten. F\u00fcr das Anlegen dieser \u201eglobalen Ansichten\u201c wurde in der Systemverwaltung Men\u00fc s21 Benutzerverwaltung ein neues Recht \u201eGlobale Tabellenansichten\u201c implementiert. Mit diesem Recht ist das Anlegen, Bearbeiten und L\u00f6schen von \u201eGlobalen Tabellenansichten\u201c m\u00f6glich. Es empfiehlt sich, dieses Recht nur einem Nutzer bzw. eingeschr\u00e4nkten Nutzerkreis zur Verf\u00fcgung zu stellen. Das Einpflegen von globalen Tabellenansichten sollte nur diesem Nutzerkreis vorbehalten sein, um m\u00f6gliche ungewollte Anpassungen und L\u00f6schungen dieser globalen Ansichten zu verhindern.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/programmaenderungen_release_13.html#1-stammdaten","title":"1 - Stammdaten","text":"<p>12a3 - Personenkontenverwaltung </p> <p>Zusatzadressen k\u00f6nnen nun auch aus bereits vorhandenen Adressen gebildet werden. Dabei wird auch der Vorname bei den Zusatzadressen mit \u00fcbernommen.</p> <p>12a6 - Einwohnerwesen Abgleich </p> <p>Der Abgleich zum Einwohnerwesen wurde sowohl f\u00fcr MESOklassisch als auch f\u00fcr VOIS auf die Version 43 umgestellt. </p> <p>1277 - Mahnstaffel </p> <p>F\u00fcr s\u00e4chsische Kunden:  Auf Grund der \u00c4nderungen im s\u00e4chsischen Kostenverzeichnis sind laut \u00a71 die Kosten f\u00fcr die Allgemeinen Amtshandlungen u.a. um die Vollstreckungsank\u00fcndigung (8.2) \u00a0erg\u00e4nzt worden. Um diese Geb\u00fchren entsprechend berechnen und auf der Mahnung darstellen zu k\u00f6nnen, ist im IFR die Forderungsart 800 einzurichten und an der daf\u00fcr angelegten Einnahmeart f\u00fcr die Vollstreckungsank\u00fcndigung zu hinterlegen. Au\u00dferdem m\u00fcssen zwingend die Forderungsarten um die sonstigen Zuschl\u00e4ge erweitert werden. Aus Forderungsart 130 wird dann bspw.132. Diese neuen Forderungsarten sind an den entsprechenden Einnahmearten zu hinterlegen. Erst dann kann unter \"sonstiger Zuschlag\" die Vollstreckungsank\u00fcndigungsgeb\u00fchr an der Einnahmeart hinterlegt werden. Danach ist der OP-Abgleich durchzuf\u00fchren, wenn die Vollstreckungsank\u00fcndigungs-Geb\u00fchr auch f\u00fcr alte F\u00e4lligkeiten mit berechnet werden soll. Die H\u00f6he der Vollstreckungsank\u00fcndigungs-Geb\u00fchr kann nun in der Mahnstaffel (Men\u00fc 1277) hinterlegt werden. </p> <p>128 - Adressverwaltung </p> <p>Bei der Neuanlage von Adressen kam es unter bestimmten Konstellationen zu Problemen. Der betreffenden Programmfunktionen in diesem Men\u00fcpunkt wurden dahingehend \u00fcberarbeitet. </p> <p>152 - Einnahmearten </p> <p>Es sind Vorbereitungen getroffen worden, dass die Hundemarkenverwaltung bei Kunden eingerichtet werden kann, die bisher noch nicht mit ihr arbeiten. Interessierte Anwender bitten wir sich bei Einrichtungswunsch in der Veranlagungs-Fachberatung zu melden. \u00a0 </p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/programmaenderungen_release_13.html#2-planung","title":"2 - Planung","text":"<p>21 - Neues Planjahr anlegen </p> <p>Beim Ableiten von Planvarianten wurden f\u00fcr den Finanzplan mit Ma\u00dfnahmen immer die Werte bis zum 10. Folgejahr vorgetragen. Das f\u00fchrte vor allem beim Druck des Teilfinanzplan B zu einem nicht korrekten Ausweis in der \"Spalte 9 - weitere Folgejahre\". Hierzu erfolgte eine Programmkorrektur, sodass er jetzt maximal nur die Folgejahre mit Werten bef\u00fcllt, die auch in der beschlossenen Ursprungsvorjahresplanvariante vorhanden sind.</p> <p>Im Reiter \"Stammdaten\" wurde der Haken f\u00fcr die \u00dcbernahme von \"gesetzlichen Listen\" ins Folgejahr im Standard-Default-Wert entfernt. Die Erfahrungen der letzten Jahre haben gezeigt, dass insbesondere auch durch Anpassungen von gesetzlichen Mustern die bewusste Aktualit\u00e4t der Listen bei Anwendern nicht unbedingt immer gegeben war und somit Listen ins neue Jahr \u00fcbertragen worden sind, die ggf. nicht mehr dem aktuellen gesetzlichen Vorgaben entsprechen. Die Funktionalit\u00e4t der \u00dcbertragung bei einem bewussten Setzen des Hakens ist weiterhin gegeben. Unsere Empfehlung geht dahin, alle gesetzlichen Listen im Men\u00fcpunkt 123 Listenpositionsverwaltung im Neuen Planjahr neu aus dem Schattenmandanten abzuleiten/kopieren. Damit ist sichergestellt, dass diese Listen den aktuellen gesetzlichen Vorgaben entsprechen. Weiterhin erfolgt hier eine Pr\u00fcfung der jeweiligen Sachkontenzuordnungen.\u00a0  Beim Neu-Ableiten sollte immer auch die Schattenmandant-Version gepr\u00fcft werden (Schalter F41). \u00dcber \u00c4nderungen an diesen Versionen informieren wir in der Release-Beschreibung. Aktuell g\u00fcltige Versionen f\u00fcr Planjahr 2022: Sachsen0003 Brandenburg0000 Sachsen-Anhalt0002</p> <p>22 - Planvarianten </p> <p>F\u00fcr die Vorlagen zu den HH-Satzungstexten (\u00a73 - \u00a76), die in der Planvariante initial angezeigt werden, erfolgte eine \u00dcberarbeitung. Des Weiteren blendet er je nach Planableitung EHH / DHH die richtige Basisvariante vor.</p> <p>265 - Verpflichtungserm\u00e4chtigungen </p> <p>Im Men\u00fc wurde bei gesetzter Option \"Vortragsbuchung\" das Eingabefeld \"Aus Jahr Gegenbuchungsstelle\" entfernt.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/programmaenderungen_release_13.html#3-buchung","title":"3 - Buchung","text":"<p>311 - Einzelbuchung </p> <p>In der Einzelbuchungsmaske wurde die DMS-Anbindung f\u00fcr den Dokumententyp \"Allgemeiner Buchbeleg\" um einige META-Felder erg\u00e4nzt. Diese META-Felder (PK-Nummer, OP-Nummer, Beleg- und F\u00e4lligkeitsdatum und die Buchungstexte) werden automatisiert in die entsprechenden Felder in der Buchungsmaske \u00fcbernommen.</p> <p>Die Plausibilit\u00e4tspr\u00fcfungen bei der Erzeugung von Buchungen wurden hinsichtlich des Vorhandenseins einer Belegnummer erweitert. Insbesondere bei Schnittstellen und manuellen Buchungen in der Einzelbuchungsmaske ist die Verwendung bzw. Bildung einer Belegnummer ein Pflichtkriterium. Die Nebenb\u00fccher im IFR (ERJ, ARJ, Veranlagung, Kontoauszugsverbuchungen usw.) erzeugen seit langem interne Belegnummern, welche im Kontext DMS von Bedeutung sind. In der Einzelbuchungsmaske war bisher bei Buchungsschl\u00fcssel 633 keine Belegnummer erforderlich. Vor dem Hintergrund einer einheitlichen Plausibilit\u00e4tspr\u00fcfung wurde auch dieser Buchungsschl\u00fcssel in die genannte Pr\u00fcfung einbezogen. Die Belegnummer wird wie z.B. auch bei Buchungsschl\u00fcssel 631 frei vergeben.  Mit Freigabe der neuen Buchungsmaske in einem der n\u00e4chsten Releases wird es entsprechend des \u201eG-Knopfes\u201c (Generierung eindeutige Belegnummer) auch f\u00fcr Zahlungsbuchungsschl\u00fcssel eine flexible Generierungsfunktion geben. Aktuell ist eine manuelle Vergabe einer Belegnummer bei BS 633 zwingend notwendig.</p> <p>Bei der Erfassung von Buchungen mit negativen Buchungsbetr\u00e4gen und Steuer kam es zu einem nicht korrekten Verhalten, die Verbuchung erfolgte dann mit positiven Betr\u00e4gen. Hierzu erfolgte eine Programmkorrektur.</p> <p>33 - Buchungsstapel </p> <p>Zur schnelleren Verbuchung von Aufrechnungen wurde ein Datenbankindex angelegt.</p> <p>3521 - Eingangsschnittstelle einlesen </p> <p>Vor dem Hintergrund, dass teilweise von den Vorsystemen veraltete bzw. ung\u00fcltige BIC-Nummern \u00fcbergeben werden, die dann bei der Verarbeitung der Schnittstelle auf einen Fehler laufen, haben wir in der Standardschnitte ab Version 4 den Parameter \"Keine \u00dcbernahme BIC f\u00fcr DE-IBAN\" erg\u00e4nzt. Mit Schalterstellung \"J\" wird beim Einlesen einer Bankverbindung mit deutscher IBAN (beginnend mit DE) die BIC-Nummer nicht mit in den Schnittstellenstapel \u00fcbernommen. Bitte nehmen Sie vorab mit Ihrem Kreditinstitut Kontakt auf, ob Ihre Bank eine BIC bei Zahlungen bzw. Lastschriften innerhalb von Deutschland ben\u00f6tigt.</p> <p>Die lizenzpflichtige Plandatenschnittstelle zum Einlesen von extern erfassten Planungsdaten in eine vorhandene Planvariante wurde hinsichtlich notwendiger Rundungsregeln \u00fcberarbeitet. Sofern Planzahlen mit Nachkommastellen geliefert werden, kann dies \u00fcber einen Parameter \"Rundungsgenauigkeit\" und \"Rundungsrichtung\" korrigiert werden.</p> <p>36 - Anordnung </p> <p>Der Email-Client im IFR erkennt nun selbstst\u00e4ndig den konfigurierten SSL-Port, und unterst\u00fctzt damit nun SSL-Mail. In den Systemparametern (s11) kann man zus\u00e4tzlich den Parameter \"SSL\" unter \"MAIL\" erg\u00e4nzen. Mit den Werten 0 und 1 wird SSL aus-, bzw. eingeschaltet.</p> <p>Beim Ausdruck der AO-\u00dcbersichtsliste erfolgte ein doppelter Ausweis der AO-Positionen, der auch zu einer nicht korrekten Summierung der AO-Werte f\u00fchrte. Hierzu erfolgte eine Anpassung des Programms/Reports.</p> <p>Beim AO-Druck werden jetzt der AO-Ersteller und Budgetverantwortliche f\u00fcr Original-/Zweitdruck mit dem Vor- und Nachnamen aus der Nutzerverwaltung gedruckt.</p> <p>Die verf\u00fcgbaren Rechte im digitalen Anordnungs- und Weiterleitungsprozess wurden um das Recht \"Abweisen\" erweitert. Damit ist es m\u00f6glich, bestimmten Nutzern das Recht auf \"Abweisen\" einer Anordnung zu entziehen. Das Recht wirkt auf den Button \u201eAbweisen\u201c im Men\u00fc 36 und im AO-Client. Die Anforderungen an diese Thematik in verschiedenen Projekten haben gezeigt, dass u.U. das \u201eAbweisen\u201c von Anordnungen ggf. an zentraler Stelle erfolgen soll. Zu diesem Zweck w\u00fcrde der Nutzer, welcher eine AO abweisen m\u00f6chte, diese AO an einen berechtigten Nutzer weiterleiten.  Dieses neue Recht wurde als \u201ePositiv-Recht\u201c implementiert, sodass sich an der bisherigen Verfahrensweise nichts \u00e4ndert. Das Recht \u201eAO-Abweisen\u201c wurde mit dem Releasewechsel f\u00fcr alle Nutzer automatisch gesetzt. Sofern dieses Recht verwendet werden soll, w\u00e4re es empfehlenswert, dies mit einer separaten neu anzulegenden Rechtegruppe abzubilden.</p> <p>394 - Budget\u00fcbersicht </p> <p>Im Men\u00fc wurde die bisherige Spalte \"Plan Gesamt\" in \"Budget Gesamt\" umbenannt. Damit soll deutlicher werden, dass es sich hier nicht um den eigentlichen fortgeschriebenen Planansatz handelt (hierzu gibt es eine gleichnamige Spalte), sondern um den tats\u00e4chlichen Gesamt-Budgetwert (BudgetGesamt = Planansatz + \u00dcPL/APL + Budgetausgleich + Mittel\u00fcbertragung Vorjahr + Budgetumbuchung Vorjahr \u2013 Sperren). Der Unterschied zur Spalte \u201efortgeschriebener Planansatz\u201c besteht somit darin, dass bei \u201eBudget Gesamt\u201c die Sperren ber\u00fccksichtigt werden. Es wurden Korrekturen an der Datenaufbereitung f\u00fcr die Spalten \u201eBudget Gesamt\u201c und \u201eerreicht/verbraucht\u201c vorgenommen. Die Budget\u00fcbersicht wurde um einige Funktionen erweitert. In Spalten/Zellen, wo sich der ausgewiesene Wert als Summe aus der Addition von anderen relevanten Spalten ergibt, wurde ein Tool-Tipp Fenster integriert. Sobald man mit der Maus auf bzw. \u00fcber eine konkrete Wertezelle f\u00e4hrt, erscheint ein kleines Fenster, welches man im Zugriff behalten kann, wenn man den Fokus der Maus auf das Fenster legt. Dort ist dann detailliert die Berechnung dargestellt. Diese neue Funktion soll dazu dienen die ausgewiesenen Werte hinsichtlich Ihrer Wertzusammensetzung transparenter darzustellen. Weiterhin wurde das Detailierungsfenster in der Spalte \u201egebucht\u201c \u00fcberarbeitet. Hier wird nun eine korrekte \u201eSOLL/HABEN\u201c gerechte Darstellung der jeweiligen Buchungss\u00e4tze erm\u00f6glicht. Da der Fokus einer auszuwertenden Buchung im auf Basis eines konkreten Sachkontos (Buchungsstelle) liegt, wurde eine visuelle Unterst\u00fctzung integriert. Die auszuwertende Buchungsstelle ist jeweils rot eingef\u00e4rbt. Der Summensaldo \u00fcber mehrere Buchungen in der Spalte \u201eBuchbetrag\u201c ist ausschlie\u00dflich auf die fokussierte Buchungsstelle abgestellt und damit auch rot eingef\u00e4rbt. Dies bewirkt eine zuverl\u00e4ssige Anzeige im Kontext \u201eSOLL/HABEN\u201c -gerechte Buchungsweise und bildet damit den saldierten gebuchten Verkehrszahlenwert ab. \u00a0 </p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/programmaenderungen_release_13.html#4-op-bearbeitung","title":"4 - OP-Bearbeitung","text":"<p>421 - Stundung </p> <p>Sollte beim Verbuchen einer Stundung die Buchungsstelle f\u00fcr das HH-Jahr noch nicht angelegt sein, wird der Nutzer durch eine Infomeldung darauf hingewiesen. </p> <p>48 - Vollstreckung </p> <p>Bei Ausgabe eines Vollstreckungslaufes an avviso \u00fcber den Button \u201eDrucken/Ausgeben\u201c (per Linksklick) erscheint nun wieder sofort das Kontextmen\u00fc zur Auswahl (Datei oder Report).</p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/programmaenderungen_release_13.html#5-auftrag-faktura","title":"5 - Auftrag / Faktura","text":"<p>51 - Auftragsverwaltung </p> <p>Die Auftragsverwaltung wurde hinsichtlich der Verwendung eines Vorsteuerkennzeichens am Auftrag in Verbindung mit Zusatzreservierungen, Entreservierungen und der \u00dcbertragung von Auftr\u00e4gen ins Folgejahr angepasst. </p> <p>52 - Eingangsrechnungsjournal </p> <p>F\u00fcr Kunden mit DMS-Nutzung: Eingangsrechnungen k\u00f6nnen \u00fcber das erneute Bearbeiten auch wieder gel\u00f6st werden, um ggfs. falsch ausgew\u00e4hlte Rechnungen wieder korrekt zuzuordnen. </p> <p>Im Eingangsrechnungsjournal werden beim Storno von Eingangsrechnungen mit hinterlegter KLR-Verteilung die KLR-Stornobuchungen nun korrekt erzeugt.</p> <p>Das Verf\u00fcgbarkeitsverhalten bei Verwendung von \u00fcbertragenen Auftr\u00e4gen und einer gleichzeitigen weiteren ER-Position mit gleicher Kontierung, aber ohne Auftragsbezug, wurde angepasst.</p> <p>54 - Ausgangsrechnungsjournal </p> <p>Im Ausgangsrechnungsjournal wurde in den Positionen (Detailinformationen) ein zus\u00e4tzliches Freitextfeld erg\u00e4nzt. Hier\u00fcber lassen sich verschiedene, zus\u00e4tzliche Angaben und Daten zu der jeweiligen Rechnungs- bzw. Bescheidposition hinzuf\u00fcgen.</p> <p>55 - Stammdaten </p> <p>Wenn \u00fcber NEU - MUSTER ein neues Muster angelegt werden sollte, wurde mit Auslieferung R61 eine Warnung angezeigt, dass der Debitor \"Muster\" bzw. \"\" nicht vorhanden ist. Dieser Fehler wurde behoben.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/programmaenderungen_release_13.html#6-auswertung","title":"6 - Auswertung","text":"<p>6224 - Kontoauszug intern </p> <p>Der Men\u00fcpunkt wurde um weitere Auswahlfelder (Auslandskennzeichen, Umsatzsteuer_ID und Steuerkennzeichen) erweitert, welche die Recherchem\u00f6glichkeiten f\u00fcr m\u00f6glicherweise \u201efalsche\u201c nichtsteuerbare Buchungen unterst\u00fctzen sollen. Beim Auswahlfeld Auslandskennzeichen wurde eine neue \u00fcbergreifende Filteroption (nicht D,DE,DEU und nicht leer) integriert. Mit dieser Auswahl w\u00fcrden alle Personenkonten, welche nicht als Deutsch gekennzeichnet sind oder kein Auslandskennzeichen hinterlegt ist zur Datenaufbereitung herangezogen. Damit k\u00f6nnte man die Buchungen auf ausl\u00e4ndischen Personenkonten n\u00e4her analysieren. Beim neuen Auswahlfeld Umsatzsteuer_ID w\u00fcrde man mit der Verwendung der Auswahl \u201enicht DE und nicht leer\u201c Buchungen von Personenkonten mit ausl\u00e4ndischer Umsatzsteuer_ID auswerten k\u00f6nnen. Die Selektionsm\u00f6glichkeiten zum Auslandskennzeichen f\u00fcr Personenkonten in den OP-Listen wurden ebenfalls erweitert. Auch hier ist die Auswahlm\u00f6glichkeit (nicht D,DE,DEU und nicht leer) integriert in Verbindung mit der bisher schon gewohnten M\u00f6glichkeit einer Mehrfachauswahl der angezeigten Personenkonten.</p> <p>6412 - Teilergebnisplan </p> <p>Durch eine \u00c4nderung wurden die Sachkontenbezeichnungen mit einer sehr kleinen Schriftgr\u00f6\u00dfe ausgedruckt. Hierzu erfolgte eine \u00c4nderung in den betroffenen Reports, sodass wieder die Original-Schriftgr\u00f6\u00dfe verwendet wird.</p> <p>672 - Umsatzsteueranmeldungen </p> <p>Datenschutzhinweise durch die Finanzverwaltung: Auf das Schreiben \u201eAllgemeine Informationen zur Umsetzung der datenschutzrechtlichen Vorgaben der Artikel 12 bis 14 der Datenschutz-Grundverordnung in der Steuerverwaltung\u201c der Finanzverwaltung (https://download.elster.de/download/dokumente/Informationen_zu_Artikel_12_bis_14_Datenschutz-Grundverordnung.pdf) wird hingewiesen. Dem Endnutzer wird weiterhin folgender Datenschutzhinweis der Finanzverwaltung zur Kenntnis gegeben: Mit dieser Software werden personenbezogene Daten im Sinne des Art. 4 Nr. 1 Datenschutzgrundverordnung (DSGVO) und Art. 9 Abs. 1 DSGVO zum Zwecke der Verarbeitung erhoben. Neben den reinen Daten, die zur Steuerveranlagung ben\u00f6tigt werden, erhebt die Software Daten \u00fcber die Art des Betriebssystems des Nutzers und \u00fcbermittelt diese an die Finanzverwaltung. Diese Daten werden ben\u00f6tigt, um die ordnungsgem\u00e4\u00dfe Verarbeitung der Daten sicherzustellen und Fehlern im Verarbeitungsprozess vorzubeugen. Die Nutzung der Daten erfolgt im Rahmen des Art. 6 Abs. 1 UAbs. 1 Buchst. e i.V.m. Abs. 3 UAbs. 1 Buchst. b DSGVO i.V.m. bundes- bzw. landesgesetzlicher Steuergesetze durch die Finanzverwaltung und nur f\u00fcr den genannten Zweck. Im Rahmen der ERiC Anwendung werden Protokolldateien erstellt und lokal gespeichert. Die Protokolldateien verbleiben lokal beim Endnutzer. Lediglich im Supportfall k\u00f6nnen sie nach ausdr\u00fccklicher Erlaubnis des Endnutzers an den Softwarehersteller \u00fcbermittelt werden. Sollte die ERiC Anwendung nicht lokal beim Endnutzer, sondern auf einem Server des Softwareherstellers laufen, so werden die Protokolldateien standardm\u00e4\u00dfig auf diesem Server gespeichert.</p> <p>671 - Umsatzsteuerjournal </p> <p>In der Steuerbuchungsrecherche erfolgte es bei der Selektion mit Produkt/-Gegen kein Ausweis der Personenkontennummer. Hierzu erfolgte eine Korrektur.</p> <p>68 - Freie Auswertungen </p> <p>Um Ihre Daten zu den angelegten Aktenkennzeichen Finanzamt leichter selbst \u00fcberpr\u00fcfen und korrigieren zu k\u00f6nnen, sind die beiden Auswertungen f\u00fcr Grundsteuer B (FQ7701) und Gewerbesteuer (Oracle: FQ7711 / SQL: FQ7712) in das Men\u00fc mit aufgenommen worden.</p> <p>69 - Gesetzliche Drucklisten </p> <p>Bei allen Drucklisten mit dem Auswahlfeld \"Produkt\" wurde das Handling optimiert. Manuell eingetragene Produkte bleiben nach Bet\u00e4tigung der TAB-Taste erhalten. Das Feld leert sich in dem Fall nicht mehr.</p> <p>Beim Druck der Liste M18 und DHH wurde ein Sachkonto, wenn es nur im 2. Jahr des DHH beplant wurde, nicht mit gedruckt. Hierzu erfolgte eine Korrektur.</p>"},{"location":"aktuelles/releasehistorie/release4.1.0062/programmaenderungen_release_13.html#7-jahresabschluss","title":"7 - Jahresabschluss","text":"<p>7331 - Kontenabstimmung </p> <p>Die Buchhaltungsabstimmung \"Budgetzuordnung - Option VKZ's\" wurde hinsichtlich der Pr\u00fcfung von Bilanzkonten ohne angehangenes FR-Konto angepasst. Die bisherige Fehler-Kennzeichnung, insbesondere bei R0-Konten, wo eine Umbuchung auf Produkt empfohlen wird, wurde entfernt.</p> <p>Im Reiter \"FR-Salden\" wurde die Pr\u00fcfung der Salden der F1+F2-Konten in Bezug zu den F3-Konten auf die Periode 01-13 eingeschr\u00e4nkt, sodass die Periode 00 nicht mehr gepr\u00fcft wird. </p> <p>Im Reiter \"Zahlwege\" wurden die Pr\u00fcfungen hinsichtlich der stammdatenseitig hinterlegten Sachkonten in Bezug zum Haushaltsjahr der Pr\u00fcfung \u00fcberarbeitet. </p> <p>732 - Bagatellbetragsbereinigung </p> <p>Im Men\u0